/* InstantKB 2014-1 to 2015 Upgrade Script */

/* add fields added in InstantForum 2015 to common users table */
ALTER TABLE InstantASP_Users ADD BannerImage  	nvarchar(255) DEFAULT('') NOT NULL;
ALTER TABLE InstantASP_Users ADD Phone  		nvarchar(100) DEFAULT('') NOT NULL;
ALTER TABLE InstantASP_Users ADD SnapChat  		nvarchar(100) DEFAULT('') NOT NULL;
ALTER TABLE InstantASP_Users ADD WhatsApp  		nvarchar(100) DEFAULT('') NOT NULL;
ALTER TABLE InstantASP_Users ADD Skills  		nvarchar(255) DEFAULT('') NOT NULL;
ALTER TABLE InstantASP_Users ADD ShowAge  		bit DEFAULT(0) NOT NULL;
ALTER TABLE InstantASP_Users ADD Gender  		smallint DEFAULT(0) NOT NULL;
ALTER TABLE InstantASP_Users ADD APIKey		    nvarchar(255) DEFAULT('') NOT NULL;

GO

ALTER TABLE InstantKB_SLAs ADD SLAEnabled		    bit DEFAULT(1) NOT NULL;

GO

ALTER TABLE InstantKB_Notifications ADD NotificationTemplate		    nvarchar(max) DEFAULT('') NOT NULL;

GO

ALTER TABLE InstantKB_WorkFlowSteps ADD NotificationXML		    nvarchar(max) DEFAULT('') NOT NULL;

GO

ALTER TABLE InstantKB_Users ADD Channel			smallint DEFAULT(0) NOT NULL;
ALTER TABLE InstantKB_Users ADD ChannelUserID	nvarchar(255) DEFAULT('') NOT NULL;
ALTER TABLE InstantKB_Users ADD ChannelUsername	nvarchar(255) DEFAULT('') NOT NULL;
ALTER TABLE InstantKB_Users ADD ChannelEmail	nvarchar(255) DEFAULT('') NOT NULL;
ALTER TABLE InstantKB_Users ADD IsSpam			bit DEFAULT(0) NOT NULL;
ALTER TABLE InstantKB_Users ADD DesignatedAgentID			int DEFAULT(0) NOT NULL;
ALTER TABLE InstantKB_Users ADD IsOnCall			bit DEFAULT(0) NOT NULL;

GO

UPDATE InstantKB_Users SET Channel = 1 WHERE Channel = 0;

GO

/* new ticket fields */
ALTER TABLE InstantKB_Tickets ADD TicketRelatedUserID 			int DEFAULT(0) NOT NULL;
ALTER TABLE InstantKB_Tickets ADD TicketChannel 				smallint DEFAULT(0) NOT NULL;
ALTER TABLE InstantKB_Tickets ADD TicketChannelMsgID 			nvarchar(255) DEFAULT('') NOT NULL;
ALTER TABLE InstantKB_Tickets ADD TicketChannelCatID 			nvarchar(255) DEFAULT('') NOT NULL;
ALTER TABLE InstantKB_Tickets ADD TicketChannelPageID 			nvarchar(255) DEFAULT('') NOT NULL;
ALTER TABLE InstantKB_Tickets ADD TicketChannelAccountID 		int DEFAULT(0) NOT NULL;
ALTER TABLE InstantKB_Tickets ADD TicketIsSpam		 			bit DEFAULT(0) NOT NULL;
ALTER TABLE InstantKB_Tickets ADD TicketIsArchived	 			bit DEFAULT(0) NOT NULL;

GO

UPDATE InstantKB_Tickets SET TicketChannel = 1 WHERE TicketChannel = 0

GO

/* new ticket reply fields */
ALTER TABLE InstantKB_TicketReplies ADD TicketReplyTimeWorked 			int DEFAULT(0) NOT NULL;
ALTER TABLE InstantKB_TicketReplies ADD TicketReplyChannel 				smallint DEFAULT(0) NOT NULL;
ALTER TABLE InstantKB_TicketReplies ADD TicketReplyChannelMsgID 			nvarchar(255) DEFAULT('') NOT NULL;

GO

-- drop InstantKB_Users photo & member level title, image constrants

BEGIN
	DECLARE @tname	nvarchar(100)
	DECLARE @name	nvarchar(100)

	DECLARE MSGCURSOR CURSOR FOR 
	SELECT tname=object_name(parent_obj),name FROM sysobjects 
	WHERE (OBJECTPROPERTY(id,N'IsDefaultCnst') <> 0 AND 
	object_name(parent_obj) = 'InstantKB_Users' )
	AND (name LIKE '%Photo%' OR name LIKE '%Membe%')

	OPEN MSGCURSOR
	FETCH NEXT FROM MSGCURSOR INTO @tname,@name
	WHILE @@fetch_status=0 BEGIN
		EXECUTE('alter table ' + @tname + ' drop constraint ' + @name)
		FETCH NEXT FROM MSGCURSOR INTO @tname,@name
	END
	CLOSE MSGCURSOR
	DEALLOCATE MSGCURSOR
END

GO

-- drop InstantKB_Users columns

IF EXISTS(select * from sys.columns 
            where Name = N'PhotoImage' and Object_ID = Object_ID(N'InstantKB_Users'))
BEGIN
	ALTER TABLE InstantKB_Users DROP COLUMN PhotoImage
END

IF EXISTS(select * from sys.columns 
            where Name = N'MemberLevelTitle' and Object_ID = Object_ID(N'InstantKB_Users'))
BEGIN
	ALTER TABLE InstantKB_Users DROP COLUMN MemberLevelTitle
END

IF EXISTS(select * from sys.columns 
            where Name = N'MemberLevelImage' and Object_ID = Object_ID(N'InstantKB_Users'))
BEGIN
	ALTER TABLE InstantKB_Users DROP COLUMN MemberLevelImage
END

GO

/* new ticket note field to relate notes to users - not just tickets */
ALTER TABLE InstantKB_TicketNotes ADD NoteRelatedUserID		int DEFAULT(0) NOT NULL;

GO

ALTER TABLE InstantKB_Articles ADD ArticleSettingsXML 		nvarchar(max) DEFAULT('') NOT NULL;

GO

ALTER TABLE InstantKB_ArticleRatings ADD Comments 		nvarchar(max) DEFAULT('') NOT NULL;

GO


---------------------------------------------------
-- add new ticket fields to existing ticket tabs
---------------------------------------------------

GO

DECLARE @intTabID int
DECLARE @strTagKeyword nvarchar(400)
DECLARE MSGCURSOR CURSOR FOR 
SELECT TabID FROM InstantKB_Tabs WHERE TabContentType = 5 
	
OPEN MSGCURSOR

FETCH NEXT FROM MSGCURSOR
INTO @intTabID
	
WHILE @@FETCH_STATUS = 0
BEGIN

	INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intTabID,'Field_TicketChannel','Channel','','','','','TicketChannel','4','0','','0','','','1',0,1,0,0,0, GETDATE())


	FETCH NEXT FROM MSGCURSOR
	INTO @intTabID
	
END
-- tidy cursor
CLOSE MSGCURSOR
DEALLOCATE MSGCURSOR

GO

-----------------------------------------

GO

CREATE TABLE InstantKB_Channels
(
ChannelID                           INT IDENTITY(1,1) NOT NULL,
ChannelText                         NVARCHAR(255) DEFAULT ('') NOT NULL,
ChannelDesc                         NVARCHAR(255) DEFAULT ('') NOT NULL,
SettingsXML                         nvarchar(max) DEFAULT ('') NOT NULL,
SortOrder							INT DEFAULT(0)NOT NULL,
Visible								BIT DEFAULT(1)NOT NULL,

CONSTRAINT PK_InstantKB_Channels PRIMARY KEY CLUSTERED ( ChannelID )
)

GO

-----------------------------------------

GO

/* add channels */
INSERT INTO InstantKB_Channels (ChannelText,ChannelDesc,SettingsXML,Visible,SortOrder) VALUES('AdminChannels_Web','AdminChannels_WebDesc','', 1, 1)
INSERT INTO InstantKB_Channels (ChannelText,ChannelDesc,SettingsXML,Visible,SortOrder) VALUES('AdminChannels_Phone','AdminChannels_PhoneDesc','', 1, 2)
INSERT INTO InstantKB_Channels (ChannelText,ChannelDesc,SettingsXML,Visible,SortOrder) VALUES('AdminChannels_Chat','AdminChannels_ChatDesc','', 1, 3)
INSERT INTO InstantKB_Channels (ChannelText,ChannelDesc,SettingsXML,Visible,SortOrder) VALUES('AdminChannels_Email','AdminChannels_EmailDesc','', 1, 4)
INSERT INTO InstantKB_Channels (ChannelText,ChannelDesc,SettingsXML,Visible,SortOrder) VALUES('AdminChannels_Twitter','AdminChannels_TwitterDesc','', 1, 5)
INSERT INTO InstantKB_Channels (ChannelText,ChannelDesc,SettingsXML,Visible,SortOrder) VALUES('AdminChannels_Facebook','AdminChannels_FacebookDesc','', 1, 6)

GO

-----------------------------------------

GO

CREATE TABLE InstantKB_EmailHistory
(
EmailHistoryID                      INT IDENTITY(1,1) NOT NULL,
EmailUniqueID                       NVARCHAR(255) DEFAULT ('') NOT NULL,
EmailTabID							INT DEFAULT(0)NOT NULL,
EmailIsSpam							BIT DEFAULT(0)NOT NULL,
EmailText							NVARCHAR(max) DEFAULT ('') NOT NULL,
EmailDate							DATETIME DEFAULT(GetDate()) NOT NULL
CONSTRAINT PK_InstantKB_EmailHistory PRIMARY KEY CLUSTERED ( EmailHistoryID )
)

GO

-----------------------------------------

GO


CREATE TABLE InstantKB_UserLists
(
ListID								INT IDENTITY(1,1) NOT NULL,
ListName							NVARCHAR(255) DEFAULT ('') NOT NULL,
ListType							INT DEFAULT(0)NOT NULL,
SortOrder							INT DEFAULT(0)NOT NULL,
CONSTRAINT PK_InstantKB_UserLists PRIMARY KEY CLUSTERED ( ListID )
)

GO

-----------------------------------------

GO

INSERT INTO InstantKB_UserLists (ListName,ListType,SortOrder) VALUES('Priority Support', 0, 1)
INSERT INTO InstantKB_UserLists (ListName,ListType,SortOrder) VALUES('Customers', 0, 2)
INSERT INTO InstantKB_UserLists (ListName,ListType,SortOrder) VALUES('Hot Lead', 0, 3)
INSERT INTO InstantKB_UserLists (ListName,ListType,SortOrder) VALUES('Warm Lead', 0, 4)
INSERT INTO InstantKB_UserLists (ListName,ListType,SortOrder) VALUES('Cold Lead', 0, 5)

GO

-----------------------------------------

GO

CREATE TABLE InstantKB_UserUserLists
(
UserUserListID                    INT IDENTITY(1,1) NOT NULL,
UserID							  INT DEFAULT(0)NOT NULL,
ListID							  INT DEFAULT(0)NOT NULL
CONSTRAINT PK_InstantKB_UserUserLists PRIMARY KEY CLUSTERED ( UserUserListID )
)


GO

-----------------------------------------

GO


CREATE PROCEDURE [ikb_sp_InsertUpdateUserList](
@intListID int,
@strListName nvarchar(255),
@intListType int,
@intSortOrder int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a user list within InstantKB_UserLists table */

IF EXISTS(SELECT ListID From InstantKB_UserLists WHERE ListName = @strListName)
BEGIN
	-- list already exists
	SET @intIdentity = -1
	RETURN
END

IF (@intListID = 0)
BEGIN
	
	-- insert 
	INSERT INTO InstantKB_UserLists (
		ListName, 
		ListType, 
		SortOrder
	) VALUES (
		@strListName, 
		@intListType, 
		@intSortOrder
	)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_UserLists SET
	ListName = @strListName,
	ListType = @intListType,
	SortOrder = @intSortOrder
	WHERE InstantKB_UserLists.ListID = @intListID;

	-- return the identity
	SET @intIdentity = @intListID
	RETURN

END

SET @intIdentity = 0
RETURN

GO

-----------------------------------------

GO


CREATE PROCEDURE [ikb_sp_DeleteUserList] (
@intListID int
) AS
SET NOCOUNT ON 

/* Deletes a user list from the InstantKB_UserLists  table */

DELETE FROM InstantKB_UserLists WHERE 
(InstantKB_UserLists.ListID = @intListID)

-- reset relationships
DELETE FROM InstantKB_UserUserLists WHERE ListID = @intListID;

RETURN


GO

-----------------------------------------

GO


CREATE PROCEDURE [ikb_sp_DeleteUserUserList] (
@intUserID int,
@intListID int
) AS

SET NOCOUNT ON 

/* Deletes a user & list association from the InstantKB_UserUSerLists table */

DELETE FROM InstantKB_UserUSerLists  WHERE 
(UserID = @intUserID AND ListID = @intListID)

RETURN

GO

-----------------------------------------

GO

CREATE PROCEDURE [ikb_sp_DeleteUserUserLists] (
@intUserID int
)
AS

SET NOCOUNT ON 

/* Deletes all lists associated to a specific user from the InstantKB_UserUserLists table */

DELETE FROM InstantKB_UserUserLists 
WHERE (InstantKB_UserUserLists.UserID = @intUserID)


GO

-----------------------------------------

GO


CREATE PROCEDURE [ikb_sp_InsertUserUserList] (
@intUserID int,
@intListID int
) AS

SET NOCOUNT ON 

/* Inserts a new user & list association to the InstantKB_UserUserLists table */

-- check to ensure we don't already have the role association
IF NOT EXISTS(SELECT ListID From InstantKB_UserUserLists WHERE UserID = @intUserID AND ListID = @intListID)
BEGIN
	INSERT INTO InstantKB_UserUserLists (UserID, ListID) VALUES (@intUserID, @intListID)
END

RETURN


GO

-----------------------------------------

GO


CREATE PROCEDURE [ikb_sp_SelectUserLists] 
AS

SET NOCOUNT ON 

SELECT * FROM InstantKB_UserLists ORDER BY SortOrder ASC

GO

-----------------------------------------

GO

CREATE PROCEDURE [ikb_sp_UpdateUserListSortOrder] (
@intListID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a user list sort order within InstantKB_UserLists */

UPDATE InstantKB_UserLists SET 
SortOrder = @intSortOrder 
WHERE (InstantKB_UserLists.ListID = @intListID)

RETURN


GO

-----------------------------------------

GO

CREATE PROCEDURE [ikb_sp_InsertUpdateChannel] (
@intChannelID int,
@strSettingsXML ntext,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates channel setting within InstantASP_Channels */

-- is this an update or insert?
IF (@intChannelID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Channels (SettingsXML) 
	VALUES (@strSettingsXML)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Channels SET
	SettingsXML = @strSettingsXML
	WHERE InstantKB_Channels.ChannelID = @intChannelID

	-- return the identity
	SET @intIdentity = @intChannelID
	RETURN

END

SET @intIdentity = 0
RETURN

GO

----------------------------------------

GO

ALTER PROCEDURE [ikb_sp_DeleteStatus] (
@intStatusID int
) AS
SET NOCOUNT ON 

/* Deletes a status from the InstantKB_Status  table */

DELETE FROM InstantKB_Status WHERE 
(InstantKB_Status.StatusID = @intStatusID)

-- reset article table

UPDATE InstantKB_Articles SET ArticleStatusID = 0
 WHERE InstantKB_Articles.ArticleStatusID = @intStatusID

-- reset tickets table

UPDATE InstantKB_Tickets SET TicketStatusID = 0 
WHERE InstantKB_Tickets.TicketStatusID = @intStatusID

RETURN

GO

----------------------------------------

GO


CREATE PROCEDURE [ikb_sp_InsertUpdateEmailHistory] (
@intEmailHistoryID int,
@strEmailUniqueID nvarchar(255),
@intEmailTabID int,
@bitEmailIsSpam bit,
@strEmailText nvarchar(max),
@dtEmailDate datetime2,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates email history information within InstantKB_EmailHistory */

-- is this an update or insert?
IF (@intEmailHistoryID = 0)
BEGIN

	-- insert 
	INSERT INTO InstantKB_EmailHistory (
		EmailUniqueID,
		EmailTabID,
		EmailText,
		EmailIsSpam,
		EmailDate
	) VALUES (
		@strEmailUniqueID,
		@intEmailTabID,
		@strEmailText,
		@bitEmailIsSpam,
		@dtEmailDate
	)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_EmailHistory SET
	EmailUniqueID = @strEmailUniqueID,
	EmailTabID = @intEmailTabID,	
	EmailText = @strEmailText,
	EmailIsSpam = @bitEmailIsSpam,
	EmailDate = @dtEmailDate
	WHERE InstantKB_EmailHistory.EmailHistoryID = @intEmailHistoryID

	-- return the identity
	SET @intIdentity = @intEmailHistoryID
	RETURN

END

SET @intIdentity = 0
RETURN

GO

-----------------------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectChannels] 
AS
SET NOCOUNT ON 

/* Select support channels */
SELECT * FROM InstantKB_Channels WITH (nolock)

-----------------------------------------

GO


SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [iasp_sp_InsertUpdateUser] (
@intUserID int,
@intPrimaryRoleID int,
@strUsername nvarchar(155),
@strUsernameEncoded nvarchar(155),
@strEmailAddress nvarchar(155),
@strPassword nvarchar(155),
@intPasswordSalt int,
@strCulture nvarchar(10),
@dbTimeZoneOffSet float,
@bolObserveDST bit,
@strDateTimeFormat nvarchar(50),
@intFirstDayOfWeek tinyint,
@strFirstName nvarchar(155),
@strLastName nvarchar(155),
@intGender smallint,
@strCompanyName nvarchar(155),
@strJobTitle nvarchar(155),
@strSkills nvarchar(155),
@strPublicEmail nvarchar(155),
@strPhone  nvarchar(100),
@strWebAddress nvarchar(255),
@strBlogAddress nvarchar(255),
@strOpenID nvarchar(255),
@strPhotoImage nvarchar(200),
@strBannerImage nvarchar(200),
@strMSN nvarchar(155),
@strSkype nvarchar(155),
@strAIM nvarchar(155),
@strYIM nvarchar(155),
@strICQ nvarchar (155),
@strSnapChat nvarchar (155),
@strWhatsApp nvarchar (155),
@strTwitter nvarchar (75),
@strFacebook nvarchar (75),
@strGooglePlus nvarchar (100),
@strLinkedIn nvarchar (75),
@strMySpace nvarchar(100),
@strYouTube nvarchar(100),
@strLocation nvarchar(155),
@intDOBDay tinyint,
@intDOBMonth tinyint,
@intDOBYear int,
@bitShowAge bit,
@strUserLevelTitle nvarchar(100),
@strUserLevelImageURL nvarchar(100),
@strIPAddress nvarchar(20),
@strLdapUsername nvarchar(255),
@strConfirmationCode nvarchar(50),
@intRecognitionPoints int,
@strAPIKey nvarchar(255),
@bitEnsureUniqueAccount bit,
@intIdentity int output
) 
AS

SET NOCOUNT ON 

/* Inserts or updates a user within InstantASP_Users */

-- is this an update or insert?
IF (@intUserID = 0)
BEGIN

	/* Ensure the username is not already present within the table */
	IF (@strUsername <> '' AND @bitEnsureUniqueAccount = 1)
	BEGIN
		IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE InstantASP_Users.Username = @strUsername OR InstantASP_Users.UsernameEncoded = @strUsernameEncoded)
		BEGIN 
			SET @intIdentity = -1
			RETURN
		END
	END
	
	/* Ensure the email address is not already present within the table */
	IF (@strEmailAddress <> '' AND @bitEnsureUniqueAccount = 1)
	BEGIN
		IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE InstantASP_Users.EmailAddress = @strEmailAddress)
		BEGIN 
			SET @intIdentity = -2
			RETURN
		END
	END

	-- insert user
	INSERT INTO InstantASP_Users (
	PrimaryRoleID, 
	Username, 
	UsernameEncoded,
	EmailAddress, 
	[Password], 
	PasswordSalt,
	Culture, 
	TimeZoneOffset, 
	ObserveDaylightSavingTime, 
	DateTimeFormat, 
	FirstDayOfWeek, 
	FirstName, 
	LastName, 
	Gender,
	CompanyName, 
	JobTitle, 
	Skills,
	PublicEmail, 
	Phone,
	WebAddress, 
	BlogAddress, 
	OpenID,
	PhotoImage, 
	BannerImage,	
	MSN, 
	Skype, 
	YIM, 
	AIM, 
	ICQ, 
	SnapChat,
	WhatsApp,
	Twitter, 
	Facebook, 
	GooglePlus,
	LinkedIn, 
	MySpace,
	YouTube,
	Location, 
	DOBDay, 
	DOBMonth, 
	DOBYear, 
	ShowAge,
	UserLevelTitle, 
	UserLevelImageURL, 
	IPAddress, 
	LdapUsername,
	ConfirmationCode,
	RecognitionPoints,
	TotalVisits,
	APIKey
	) 
	VALUES
	(
	@intPrimaryRoleID, 
	@strUsername, 
	@strUsernameEncoded,
	@strEmailAddress, 
	@strPassword, 
	@intPasswordSalt,
	@strCulture, 
	@dbTimeZoneOffSet, 
	@bolObserveDST, 
	@strDateTimeFormat, 
	@intFirstDayOfWeek, 
	@strFirstName, 
	@strLastName, 
	@intGender,
	@strCompanyName, 
	@strJobTitle, 
	@strSkills,
	@strPublicEmail, 
	@strPhone,
	@strWebAddress, 
	@strBlogAddress, 
	@strOpenID, 
	@strPhotoImage, 
	@strBannerImage,
	@strMSN, 
	@strSkype, 
	@strYIM, 
	@strAIM, 
	@strICQ, 
	@strSnapChat,
	@strWhatsApp,
	@strTwitter, 
	@strFacebook, 
	@strGooglePlus,
	@strLinkedIn, 
	@strMySpace, 
	@strYouTube, 
	@strLocation, 
	@intDOBDay, 
	@intDOBMonth, 
	@intDOBYear, 
	@bitShowAge,
	@strUserLevelTitle, 
	@strUserLevelImageURL, 
	@strIPAddress, 
	@strLdapUsername, 
	@strConfirmationCode,
	@intRecognitionPoints, 
	0,
	@strAPIKey)

	-- set output parameter
	SET @intIdentity = @@IDENTITY


	
END
ELSE -- we are updating an existing record
BEGIN

	IF (@strUsername <> ''  AND @bitEnsureUniqueAccount = 1)
	BEGIN
		IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE Username = @strUsername AND UserID <> @intUserID)
		BEGIN
			SET @intIdentity = - 1
			RETURN
		END 
	END

	-- Check to see if email address already exists for any other user
	IF (@strEmailAddress <> ''  AND @bitEnsureUniqueAccount = 1)
	BEGIN
		IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE EmailAddress = @strEmailAddress AND UserID <> @intUserID)
		BEGIN
			SET @intIdentity = - 2
			RETURN
		END 
	END

	-- update user
	UPDATE InstantASP_Users SET 
	PrimaryRoleID = @intPrimaryRoleID,
	Username = @strUsername,
	UsernameEncoded = @strUsernameEncoded,
	EmailAddress = @strEmailAddress,
	[Password] = @strPassword,
	PasswordSalt = @intPasswordSalt,
	Culture = @strCulture,
	TimeZoneOffset = @dbTimeZoneOffSet,
	ObserveDaylightSavingTime = @bolObserveDST,
	DateTimeFormat = @strDateTimeFormat,
	FirstDayOfWeek = @intFirstDayOfWeek,
	FirstName = @strFirstName,
	LastName = @strLastName,
	Gender = @intGender,
	CompanyName = @strCompanyName,
	JobTitle = @strJobTitle,
	Skills = @strSkills,
	PublicEmail = @strPublicEmail,
	Phone = @strPhone,
	WebAddress = @strWebAddress,
	BlogAddress = @strBlogAddress,
	OpenID = @strOpenID,
	PhotoImage = @strPhotoImage,
	BannerImage = @strBannerImage,
	MSN = @strMSN,
	Skype = @strSkype,
	YIM = @strYIM,
	AIM = @strAIM,
	ICQ = @strICQ,
	SnapChat = @strSnapChat,
	WhatsApp = @strWhatsApp,
	Twitter = @strTwitter,
	Facebook = @strFacebook,
	GooglePlus = @strGooglePlus,
	LinkedIn = @strLinkedIn,
	MySpace = @strMySpace,
	YouTube = @strYouTube,
	Location = @strLocation,
	DOBDay = @intDOBDay,
	DOBMonth = @intDOBMonth,
	DOBYear = @intDOBYear,
	ShowAge = @bitShowAge,
	IPAddress = @strIPAddress,
	UserLevelTitle = @strUserLevelTitle,
	UserLevelImageURL = @strUserLevelImageURL,
	LdapUsername = @strLdapUsername,
	ConfirmationCode = @strConfirmationCode,
	RecognitionPoints = @intRecognitionPoints,
	APIKey = @strAPIKey
	WHERE (InstantASP_Users.UserID = @intUserID)

	-- set output parameter
	SET @intIdentity = @intUserID

END

RETURN


GO

----------------------------------------

GO


ALTER PROCEDURE [ikb_sp_InsertUpdateUser] (
@intUserID int,
@bolIsAnonymous bit,
@intPermissionID int,
@intStaffPermissionID int,
@intPrimaryDeptID int,
@intRecognitionPoints int,
@strSkin nvarchar(100),
@strInterests nvarchar(255),
@strSignature nvarchar(max),
@strNotes nvarchar(max),
@intChannel smallint,
@strChannelUserID nvarchar(255),
@strChannelUsername nvarchar(255),
@strChannelEmail nvarchar(255),
@bitIsSpam bit,
@intDesignatedAgentID int, 
@bitIsOnCall bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a user within InstantKB_Users */

IF NOT EXISTS(SELECT UserID FROM InstantKB_Users WHERE InstantKB_Users.UserID = @intUserID)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Users (
		UserID, 
		IsAnonymous, 
		PermissionID, 
		StaffPermissionID, 
		PrimaryDeptID, 
		RecognitionPoints, 
		Skin, 
		Interests, 
		[Signature], 
		Notes,
		Channel,
		ChannelUserID,
		ChannelUsername,
		ChannelEmail,
		IsSpam,
		DesignatedAgentID,
		IsOnCall
	) VALUES (
		@intUserID, 
		@bolIsAnonymous, 
		@intPermissionID, 
		@intStaffPermissionID, 
		@intPrimaryDeptID, 
		@intRecognitionPoints, 
		@strSkin, 
		@strInterests, 
		@strSignature, 
		@strNotes,
		@intChannel,
		@strChannelUserID,
		@strChannelUsername,
		@strChannelEmail,
		@bitIsSpam,
		@intDesignatedAgentID,
		@bitIsOnCall
	)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY

	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Users SET
	IsAnonymous = @bolIsAnonymous,
	PermissionID = @intPermissionID,
	StaffPermissionID = @intStaffPermissionID,
	PrimaryDeptID = @intPrimaryDeptID,
	RecognitionPoints = @intRecognitionPoints,
	Skin = @strSkin,
	Interests = @strInterests,
	[Signature] = @strSignature,
	Notes = @strNotes,
	Channel = @intChannel,
	ChannelUserID = @strChannelUserID,
	ChannelUsername = @strChannelUsername,
	ChannelEmail = @strChannelEmail,
	IsSpam = @bitIsSpam,
	DesignatedAgentID = @intDesignatedAgentID,
	IsOnCall = @bitIsOnCall
	WHERE InstantKB_Users.UserID = @intUserID
		
	IF (@bitIsSpam = 1) 
	BEGIN
		UPDATE InstantKB_Tickets 
		SET TicketIsSpam = 1
		WHERE TicketCreatedUserID = @intUserID;
	END
	ELSE 
	BEGIN
		UPDATE InstantKB_Tickets 
		SET TicketIsSpam = 0
		WHERE TicketCreatedUserID = @intUserID;
	END

	-- return the identity
	SET @intIdentity = @intUserID

	RETURN

END

SET @intIdentity = 0
RETURN

GO

----------------------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectUserByChannel] (
@strChannelUserID nvarchar(255),
@intChannel smallint
) AS

SET NOCOUNT ON 

IF (@strChannelUserID <> '' AND @intChannel > 0) 
BEGIN

	DECLARE @intUserID int = 0;
	SET @intUserID = (
		SELECT TOP 1 UserID FROM InstantKB_Users 
		WHERE (
			ChannelUserID = @strChannelUserID AND
			Channel = @intChannel
			)
			ORDER BY UserID DESC
		)
			
	IF (@intUserID > 0) 
	BEGIN
		EXEC ikb_sp_SelectUserByUserID @intUserID
	END

END


GO

----------------------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectUserByPhone] (
@strPhoneNumber nvarchar(255)
) AS

SET NOCOUNT ON 

IF (@strPhoneNumber <> '') 
BEGIN

	DECLARE @intUserID int = 0;
	SET @intUserID = (
		SELECT TOP 1 UserID FROM InstantASP_Users 
		WHERE (
			Phone = @strPhoneNumber
			)
			ORDER BY UserID DESC
		)
			
	IF (@intUserID > 0) 
	BEGIN
		EXEC ikb_sp_SelectUserByUserID @intUserID
	END

END

GO

----------------------------------------

GO


ALTER PROCEDURE [ikb_sp_InsertUpdateTicket] (
@intTicketID int,
@intTicketTabID int,
@intTicketSLAID int,
@intTicketToUserID int,
@intTicketRelatedUserID int,
@strTicketTitle nvarchar(255),
@strTicketText ntext,
@intTicketStatusID int,
@intTicketPriorityID int,
@intTicketTypeID int,
@intTicketDeptID int,
@intTicketCategoryID int,
@intTicketWorkflowStepID int,
@intTicketCreatedUserID int,
@strTicketCreatedUsername nvarchar(255),
@strTicketCreatedEmailAddress nvarchar(255),
@intTicketModifiedUserID int,
@intTicketAssignedUserID int,
@dtTicketDueDate datetime2,
@dtTicketClosedDate datetime2,
@strTicketAttachment1 nvarchar(255),
@strTicketAttachment2 nvarchar(255),
@intTicketTimeWorked int,
@intTicketPercentComplete int,
@strTicketImage nvarchar(255),
@intTicketChannel smallint,
@strTicketChannelMsgID nvarchar(255),
@strTicketChannelCatID nvarchar(255),
@strTicketChannelPageID nvarchar(255),
@intTicketChannelAccountID int,
@bitTicketIsSpam bit,
@bitTicketIsArchived bit,
@bitUpdateDueDateBasedOnSLA bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a article within the InstantKB_Articles table */

DECLARE @bolIsStaffReply bit
SET @bolIsStaffReply = 0
	
DECLARE @strCreatedEmail nvarchar(255)
DECLARE @strModifiedUsername nvarchar(255)
DECLARE @strCreatedUsername nvarchar(255)
DECLARE @strAssignedUsername nvarchar(255)

if (@intTicketCreatedUserID > 0) 
BEGIN
	SET @strCreatedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketCreatedUserID))
	SET @strCreatedEmail = (SELECT EmailAddress FROM InstantASP_Users WHERE (UserID = @intTicketCreatedUserID))
	-- check if staff
	IF EXISTS(SELECT InstantASP_Users.UserID, InstantASP_UsersRoles.RoleID   FROM InstantASP_Users 
	INNER JOIN InstantASP_UsersRoles ON InstantASP_Users.UserID = InstantASP_UsersRoles.UserID 
	WHERE InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles 
	WHERE InstantASP_Roles.AdministratorRole  = 1 or InstantASP_Roles.ModeratorRole = 1)
	AND InstantASP_Users.UserID = @intTicketCreatedUserID)
	BEGIN
		SET @bolIsStaffReply = 1
	END
END
ELSE
BEGIN
	SET @strCreatedUsername = @strTicketCreatedUsername
	SET @strCreatedEmail = @strTicketCreatedEmailAddress
END

IF (@intTicketAssignedUserID > 0)
BEGIN	
	SET @strAssignedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketAssignedUserID))
END
ELSE
BEGIN
	SET @strAssignedUsername = '';
END

IF (@intTicketModifiedUserID > 0)
BEGIN
	SET @strModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketModifiedUserID))
END
ELSE
BEGIN
	SET @strModifiedUsername = @strCreatedUsername;
END
		
-- is this an update or insert?
IF (@intTicketID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Tickets 
		(
		TicketTabID,
		TicketSLAID,
		TicketToUserID,
		TicketRelatedUserID,
		TicketTitle, 
		TicketText,
		TicketStatusID, 
		TicketPriorityID, 
		TicketDeptID, 
		TicketTypeID, 
		TicketCategoryID,
		TicketWorkflowStepID, 
		TicketCreatedDate, 
		TicketCreatedUserID, 
		TicketCreatedUsername, 
		TicketCreatedEmail, 
		TicketModifiedUserID, 
		TicketModifiedUsername,
		TicketModifiedDate, 
		TicketDueDate,	
		TicketClosedDate,
		TicketAttachment1,
		TicketAttachment2,
		TicketIsStaffReply,
		TicketTimeWorked,
		TicketPercentComplete,
		TicketImage,
		TicketChannel,
		TicketChannelMsgID,
		TicketChannelCatID,
		TicketChannelPageID,
		TicketChannelAccountID,
		TicketIsSpam,
		TicketIsArchived
		)		
	VALUES 		(
		@intTicketTabID,
		@intTicketSLAID,
		@intTicketToUserID,
		@intTicketRelatedUserID,
		@strTicketTitle,
		@strTicketText,
		@intTicketStatusID,
		@intTicketPriorityID,
		@intTicketDeptID,
		@intTicketTypeID,	
		@intTicketCategoryID,
		@intTicketWorkflowStepID,
		getdate(),
		@intTicketCreatedUserID,
		IsNull(@strCreatedUsername,''),
		@strCreatedEmail,
		@intTicketModifiedUserID,
		IsNull(@strModifiedUsername, ''),
		getdate(),
		@dtTicketDueDate,
		@dtTicketClosedDate,
		@strTicketAttachment1,
		@strTicketAttachment2,
		@bolIsStaffReply,
		@intTicketTimeWorked,
		@intTicketPercentComplete,
		@strTicketImage,
		@intTicketChannel,
		@strTicketChannelMsgID,
		@strTicketChannelCatID,
		@strTicketChannelPageID,
		@intTicketChannelAccountID,
		@bitTicketIsSpam,
		@bitTicketIsArchived
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Tickets SET
	TicketTitle = @strTicketTitle,
	TicketSLAID = @intTicketSLAID,
	TicketText = @strTicketText,
	TicketStatusID = @intTicketStatusID,
	TicketPriorityID = @intTicketPriorityID,
	TicketTypeID = 	@intTicketTypeID,
	TicketDeptID = @intTicketDeptID,
	TicketCategoryID = 	@intTicketCategoryID,
	TicketWorkflowStepID =	@intTicketWorkflowStepID,
	TicketModifiedUserID = @intTicketModifiedUserID,
	TicketModifiedDate = getdate(),
	TicketDueDate = @dtTicketDueDate,
	TicketClosedDate = @dtTicketClosedDate,
	TicketModifiedUsername = IsNull(@strModifiedUsername, ''),	
	TicketAttachment1 = @strTicketAttachment1,
	TicketAttachment2 = @strTicketAttachment2,
	TicketTimeWorked = @intTicketTimeWorked,
	TicketPercentComplete = @intTicketPercentComplete,
	TicketImage = @strTicketImage,
	TicketChannel = @intTicketChannel,
	TicketChannelMsgID = @strTicketChannelMsgID,
	TicketChannelCatID = @strTicketChannelCatID,
	TicketChannelPageID = @strTicketChannelPageID,
	TicketChannelAccountID = @intTicketChannelAccountID,
	TicketIsSpam = @bitTicketIsSpam,
	TicketIsArchived = @bitTicketIsArchived
	WHERE InstantKB_Tickets.TicketID = @intTicketID

	-- return the identity
	SET @intIdentity = @intTicketID

END

-- do we have an assigned user?
IF (@strAssignedUsername <> '') 
BEGIN
	-- ensure we only update if information has changed
	DECLARE @intCurrentAssignedUserID int
	SET @intCurrentAssignedUserID = (SELECT TicketAssignedUserID FROM InstantKB_Tickets WHERE InstantKB_Tickets.TicketID = @intIdentity)
	IF (@intCurrentAssignedUserID <> @intTicketAssignedUserID)
	BEGIN	
		UPDATE InstantKB_Tickets SET 
		TicketAssignedUserID = 	@intTicketAssignedUserID,
		TicketAssignedUsername = @strAssignedUsername,
		TicketAssignedDate = 	GETDATE()
		WHERE InstantKB_Tickets.TicketID = @intIdentity
	END
END
ELSE
BEGIN
	UPDATE InstantKB_Tickets SET 
	TicketAssignedUserID = 	0,
	TicketAssignedUsername = '',
	TicketAssignedDate = 	null
	WHERE InstantKB_Tickets.TicketID = @intIdentity
END
	
-- determine if ticket is closed
DECLARE @bitIsClosed bit;
SET @bitIsClosed = 0;
IF (EXISTS(SELECT TicketID FROM InstantKB_Tickets WHERE TicketID = @intTicketID AND TicketClosedDate IS NOT NULL))
BEGIN
	SET @bitIsClosed = 1;
END

-- do we have an SLA?

if (@intTicketSLAID > 0 AND @bitUpdateDueDateBasedOnSLA = 1) 
BEGIN

	-- set due date based on SLA if ticket is not closed, marked as spam or archived
	DECLARE @intOverdueHours int
	SET @intOverdueHours = (SELECT SLAOverdueTime FROM InstantKB_SLAs WHERE InstantKB_SLAs.SLAID = @intTicketSLAID)
	IF (@intOverdueHours > 0 AND 
		@bitTicketIsSpam = 0 AND 
		@bitTicketIsArchived = 0 AND
		@bitIsClosed = 0) 
	BEGIN
		UPDATE InstantKB_Tickets SET
		TicketDueDate =  DATEADD(hh,@intOverdueHours,getdate())
		WHERE InstantKB_Tickets.TicketID = @intIdentity;
	END
	ELSE
	BEGIN
		UPDATE InstantKB_Tickets SET
		InstantKB_Tickets.TicketDueDate = NULL,
		InstantKB_Tickets.TicketIsEscalated = 0
		WHERE InstantKB_Tickets.TicketID = @intIdentity;
	END
END
	
IF (@bitIsClosed = 1)
BEGIN
		UPDATE InstantKB_Tickets SET
		InstantKB_Tickets.TicketDueDate = NULL,
		InstantKB_Tickets.TicketIsEscalated = 0
		WHERE InstantKB_Tickets.TicketID = @intIdentity;
END

RETURN



GO


----------------------------------------

GO


ALTER PROCEDURE [ikb_sp_SelectTicketsPaged] (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit,
@strSQLFullTextMaxRank nvarchar(4000)
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
IF (@intRowsToReturn > 0) 
BEGIN
	SET ROWCOUNT @intRowsToReturn
END

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex

-- set upperbound only if we have a pagesize
IF (@intRowsToReturn > 0) 
BEGIN
	SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1
END
ELSE
BEGIN
	SET @intPageUpperBound = (SELECT COUNT(TicketID) FROM InstantKB_Tickets)
END

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	TicketID int, Rank int, MaxRank int, SortBy sql_variant
)

-- insert data 
INSERT INTO #PageIndex (TicketID, Rank, SortBy)
EXECUTE sp_executesql @strSQLPopulate

-- do we need to return our full text max rank
DECLARE @intMaxRank int
IF (@strSQLFullTextMaxRank <> '')
BEGIN

	-- insert full text max rank
	INSERT INTO #PageIndex (MaxRank)
	EXECUTE sp_executesql @strSQLFullTextMaxRank
	-- set max rank
	SET @intMaxRank = (SELECT MaxRank FROM #PageIndex WHERE #PageIndex.IndexID = @@IDENTITY)
	DELETE FROM #PageIndex WHERE #PageIndex.IndexID = @@IDENTITY
	UPDATE #PageIndex SET MaxRank = @intMaxRank

END

-- select the data to return
SELECT 
IPI.Rank, IPI.MaxRank, 
InstantKB_Tickets.*, 
InstantKB_TicketCustomFields.*, 
InstantKB_Types.*, 
InstantKB_Status.*, 
InstantKB_Priorities.*, 
InstantKB_WorkFlowSteps.* ,
InstantASP_Users_Recipient.Username AS RecipientUsername,
InstantASP_Users_Recipient.EmailAddress AS RecipientEmailAddress,
InstantASP_Users_Recipient.FirstName AS RecipientFirstName,
InstantASP_Users_Recipient.LastName AS RecipientLastName,
InstantASP_Users_Recipient.PhotoImage AS RecipientPhotoImage,
InstantKB_Users_Recipient.Channel AS RecipientChannel,
InstantKB_Users_Recipient.ChannelUserID AS RecipientChannelUserID,
InstantKB_Users_Recipient.ChannelUsername AS RecipientChannelUsername,
InstantKB_Users_Recipient.ChannelEmail AS RecipientChannelEmail,
'' AS RecipientSignature,
InstantASP_Users_Sender.Username AS SenderUsername,
InstantASP_Users_Sender.EmailAddress AS SenderEmailAddress,
InstantASP_Users_Sender.FirstName AS SenderFirstName,
InstantASP_Users_Sender.LastName AS SenderLastName,
InstantASP_Users_Sender.PhotoImage AS SenderPhotoImage,
InstantKB_Users_Sender.Channel AS SenderChannel,
InstantKB_Users_Sender.ChannelUserID AS SenderChannelUserID,
InstantKB_Users_Sender.ChannelUsername AS SenderChannelUsername,
InstantKB_Users_Sender.ChannelEmail AS SenderChannelEmail,
'' AS SenderSignature,
InstantASP_Users_Related.Username AS RelatedUsername,
InstantASP_Users_Related.EmailAddress AS RelatedEmailAddress,
InstantASP_Users_Related.FirstName AS RelatedFirstName,
InstantASP_Users_Related.LastName AS RelatedLastName,
InstantASP_Users_Related.PhotoImage AS RelatedPhotoImage,
InstantKB_Users_Related.Channel AS RelatedChannel,
InstantKB_Users_Related.ChannelUserID AS RelatedChannelUserID,
InstantKB_Users_Related.ChannelUsername AS RelatedChannelUsername,
InstantKB_Users_Related.ChannelEmail AS RelatedChannelEmail,
InstantASP_Users_Modified.Username AS ModifiedUsername,
InstantASP_Users_Modified.EmailAddress AS ModifiedEmailAddress,
InstantASP_Users_Modified.FirstName AS ModifiedFirstName,
InstantASP_Users_Modified.LastName AS ModifiedLastName,
InstantASP_Users_Modified.PhotoImage AS ModifiedPhotoImage,
InstantKB_Users_Modified.Channel AS ModifiedChannel,
InstantKB_Users_Modified.ChannelUserID AS ModifiedChannelUserID,
InstantKB_Users_Modified.ChannelUsername AS ModifiedChannelUsername,
InstantKB_Users_Modified.ChannelEmail AS ModifiedChannelEmail,
InstantASP_Users_Assigned.Username AS AssignedUsername,
InstantASP_Users_Assigned.EmailAddress AS AssignedEmailAddress,
InstantASP_Users_Assigned.FirstName AS AssignedFirstName,
InstantASP_Users_Assigned.LastName AS AssignedLastName,
InstantASP_Users_Assigned.PhotoImage AS AssignedPhotoImage,
InstantKB_Users_Assigned.Channel AS AssignedChannel,
InstantKB_Users_Assigned.ChannelUserID AS AssignedChannelUserID,
InstantKB_Users_Assigned.ChannelUsername AS AssignedChannelUsername,
InstantKB_Users_Assigned.ChannelEmail AS AssignedChannelEmail
FROM #PageIndex IPI 
LEFT OUTER JOIN InstantKB_Tickets ON InstantKB_Tickets.TicketID = IPI.TicketID  
LEFT OUTER JOIN InstantKB_Users AS InstantKB_Users_Recipient INNER JOIN InstantASP_Users AS InstantASP_Users_Recipient ON InstantKB_Users_Recipient.UserID = InstantASP_Users_Recipient.UserID ON InstantKB_Tickets.TicketToUserID = InstantASP_Users_Recipient.UserID 
LEFT OUTER JOIN InstantKB_Users AS InstantKB_Users_Sender INNER JOIN InstantASP_Users AS InstantASP_Users_Sender ON InstantKB_Users_Sender.UserID = InstantASP_Users_Sender.UserID ON InstantKB_Tickets.TicketCreatedUserID = InstantASP_Users_Sender.UserID 
LEFT OUTER JOIN InstantKB_Users AS InstantKB_Users_Related INNER JOIN InstantASP_Users AS InstantASP_Users_Related ON InstantKB_Users_Related.UserID = InstantASP_Users_Related.UserID ON InstantKB_Tickets.TicketRelatedUserID = InstantASP_Users_Related.UserID 
LEFT OUTER JOIN InstantKB_Users AS InstantKB_Users_Modified INNER JOIN InstantASP_Users AS InstantASP_Users_Modified ON InstantKB_Users_Modified.UserID = InstantASP_Users_Modified.UserID ON InstantKB_Tickets.TicketModifiedUserID = InstantASP_Users_Modified.UserID 
LEFT OUTER JOIN InstantKB_Users AS InstantKB_Users_Assigned INNER JOIN InstantASP_Users AS InstantASP_Users_Assigned ON InstantKB_Users_Assigned.UserID = InstantASP_Users_Assigned.UserID ON InstantKB_Tickets.TicketAssignedUserID = InstantASP_Users_Assigned.UserID 
LEFT OUTER JOIN InstantKB_Types ON InstantKB_Tickets.TicketTypeID = InstantKB_Types.TypeID 
LEFT OUTER JOIN InstantKB_WorkFlowSteps ON InstantKB_Tickets.TicketWorkFlowStepID = InstantKB_WorkFlowSteps.WorkFlowStepID 
LEFT OUTER JOIN InstantKB_Priorities ON InstantKB_Tickets.TicketPriorityID = InstantKB_Priorities.PriorityID 
LEFT OUTER JOIN InstantKB_Status ON InstantKB_Tickets.TicketStatusID = InstantKB_Status.StatusID 
LEFT OUTER JOIN InstantKB_TicketCustomFields ON InstantKB_Tickets.TicketID = InstantKB_TicketCustomFields.TicketID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount



GO

---------------------------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectTicketByChannel] (
@strTicketChannelMsgID nvarchar(255),
@intTicketChannel smallint

) AS

SET NOCOUNT ON 

	DECLARE @intTicketID int
	SET @intTicketID = (
			SELECT TOP 1 TicketID FROM InstantKB_Tickets 
			WHERE 
			TicketChannelMsgID = @strTicketChannelMsgID AND
			TicketChannel = @intTicketChannel
		)

	IF (@intTicketID > 0)
	BEGIN
		EXEC ikb_sp_SelectTicket @intTicketID
	END

RETURN 

GO

--------------------------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectEmailHistoryByUniqueID] (
@strEmailUniqueID nvarchar(255)
) AS

SET NOCOUNT ON 

	SELECT * FROM InstantKB_EmailHistory
	WHERE InstantKB_EmailHistory.EmailUniqueID = @strEmailUniqueID;

RETURN 



GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_InsertUpdateTicketReply] (
@intTicketReplyID int,
@intTicketID int,
@intTicketWorkFlowStepID int,
@intTicketReplyUserID int,
@strTicketText nvarchar(max),
@intTicketTimeWorked int,
@intTicketReplyChannel smallint,
@strTicketReplyChannelMsgID nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

DECLARE @bolIsStaffReply bit
SET @bolIsStaffReply = 0
IF (@intTicketReplyUserID > 0)
BEGIN
	IF EXISTS(SELECT InstantASP_Users.UserID, InstantASP_UsersRoles.RoleID   FROM InstantASP_Users 
	INNER JOIN InstantASP_UsersRoles ON InstantASP_Users.UserID = InstantASP_UsersRoles.UserID 
	WHERE InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles 
	WHERE InstantASP_Roles.AdministratorRole  = 1 or InstantASP_Roles.ModeratorRole = 1)
	AND InstantASP_Users.UserID = @intTicketReplyUserID)
	BEGIN
		SET @bolIsStaffReply = 1
	END
END

-- is this an update or insert?
IF (@intTicketReplyID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_TicketReplies
		(
		TicketID, 
		TicketText,
		TicketReplyUserID,
		TicketReplyCreatedDate,
		TicketReplyTimeWorked,
		TicketReplyChannel,
		TicketReplyChannelMsgID,
		TicketReplyIsStaff 
		)		
	VALUES 		(		
		@intTicketID,
		@strTicketText,
		@intTicketReplyUserID,
		GETDATE(),
		@intTicketTimeWorked,
		@intTicketReplyChannel,
		@strTicketReplyChannelMsgID,
		@bolIsStaffReply
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	
	-- update reply count
	UPDATE InstantKB_Tickets SET
	InstantKB_Tickets.TicketReplies = (
	SELECT COUNT(TicketReplyID) FROM InstantKB_TicketReplies 
	WHERE InstantKB_TicketReplies.TicketID = @intTicketID)
	WHERE InstantKB_Tickets.TicketID = @intTicketID

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_TicketReplies SET
	TicketText = @strTicketText,
	TicketReplyTimeWorked = @intTicketTimeWorked,
	TicketReplyChannel = @intTicketReplyChannel,
	TicketReplyChannelMsgID = @strTicketReplyChannelMsgID,
	TicketModifiedUserID = @intTicketReplyUserID,
	TickedModifiedDate = GETDATE()
	WHERE InstantKB_TicketReplies.TicketReplyID = @intTicketReplyID

	-- return the identity
	SET @intIdentity = @intTicketReplyID

END

IF (@intTicketID > 0)
BEGIN

	IF (@intTicketWorkFlowStepID > 0) 
	BEGIN
		UPDATE InstantKB_Tickets SET
		InstantKB_Tickets.TicketWorkflowStepID  = @intTicketWorkFlowStepID
		WHERE TicketID = @intTicketID;	
	END
	
	-- update total time worked
	IF (@intTicketTimeWorked > 0)
	BEGIN
		DECLARE @intMinutes int
		SET @intMinutes = (SELECT TicketTimeWorked FROM InstantKB_Tickets WHERE TicketID = @intTicketID)
		UPDATE InstantKB_Tickets SET
		InstantKB_Tickets.TicketTimeWorked = (@intMinutes + @intTicketTimeWorked)
		WHERE TicketID = @intTicketID;
	END

	-- update staff reply flag for main ticket
	UPDATE InstantKB_Tickets SET
	InstantKB_Tickets.TicketIsStaffReply = @bolIsStaffReply,
	InstantKB_Tickets.TicketModifiedUserID = @intTicketReplyUserID,
	InstantKB_Tickets.TicketModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE UserID = @intTicketReplyUserID),
	InstantKB_Tickets.TicketModifiedDate = GETDATE()
	WHERE TicketID = @intTicketID;
		
END

RETURN


GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_SelectTicket] (
@intTicketID int
) AS

SET NOCOUNT ON 

SELECT 
	InstantKB_Tickets.*,
	InstantKB_TicketCustomFields.*, 
	InstantKB_Types.*, 
	InstantKB_Status.*, 
	InstantKB_Priorities.*,  
	InstantKB_WorkFlowSteps.*, 
	InstantASP_Users_Recipient.Username AS RecipientUsername,
	InstantASP_Users_Recipient.EmailAddress AS RecipientEmailAddress,
	InstantASP_Users_Recipient.FirstName AS RecipientFirstName,
	InstantASP_Users_Recipient.LastName AS RecipientLastName,
	InstantASP_Users_Recipient.PhotoImage AS RecipientPhotoImage,
	InstantKB_Users_Recipient.Channel AS RecipientChannel,
	InstantKB_Users_Recipient.ChannelUserID AS RecipientChannelUserID,
	InstantKB_Users_Recipient.ChannelUsername AS RecipientChannelUsername,
	InstantKB_Users_Recipient.ChannelEmail AS RecipientChannelEmail,
	InstantKB_Users_Recipient.[Signature] AS RecipientSignature,
	InstantASP_Users_Sender.Username AS SenderUsername,
	InstantASP_Users_Sender.EmailAddress AS SenderEmailAddress,
	InstantASP_Users_Sender.FirstName AS SenderFirstName,
	InstantASP_Users_Sender.LastName AS SenderLastName,
	InstantASP_Users_Sender.PhotoImage AS SenderPhotoImage,
	InstantKB_Users_Sender.Channel AS SenderChannel,
	InstantKB_Users_Sender.ChannelUserID AS SenderChannelUserID,
	InstantKB_Users_Sender.ChannelUsername AS SenderChannelUsername,
	InstantKB_Users_Sender.ChannelEmail AS SenderChannelEmail,
	InstantKB_Users_Sender.[Signature] AS SenderSignature,
	InstantASP_Users_Related.Username AS RelatedUsername,
	InstantASP_Users_Related.EmailAddress AS RelatedEmailAddress,
	InstantASP_Users_Related.FirstName AS RelatedFirstName,
	InstantASP_Users_Related.LastName AS RelatedLastName,
	InstantASP_Users_Related.PhotoImage AS RelatedPhotoImage,
	InstantKB_Users_Related.Channel AS RelatedChannel,
	InstantKB_Users_Related.ChannelUserID AS RelatedChannelUserID,
	InstantKB_Users_Related.ChannelUsername AS RelatedChannelUsername,
	InstantKB_Users_Related.ChannelEmail AS RelatedChannelEmail,
	InstantASP_Users_Modified.Username AS ModifiedUsername,
	InstantASP_Users_Modified.EmailAddress AS ModifiedEmailAddress,
	InstantASP_Users_Modified.FirstName AS ModifiedFirstName,
	InstantASP_Users_Modified.LastName AS ModifiedLastName,
	InstantASP_Users_Modified.PhotoImage AS ModifiedPhotoImage,
	InstantKB_Users_Modified.Channel AS ModifiedChannel,
	InstantKB_Users_Modified.ChannelUserID AS ModifiedChannelUserID,
	InstantKB_Users_Modified.ChannelUsername AS ModifiedChannelUsername,
	InstantKB_Users_Modified.ChannelEmail AS ModifiedChannelEmail,
	InstantASP_Users_Assigned.Username AS AssignedUsername,
	InstantASP_Users_Assigned.EmailAddress AS AssignedEmailAddress,
	InstantASP_Users_Assigned.FirstName AS AssignedFirstName,
	InstantASP_Users_Assigned.LastName AS AssignedLastName,
	InstantASP_Users_Assigned.PhotoImage AS AssignedPhotoImage,
	InstantKB_Users_Assigned.Channel AS AssignedChannel,
	InstantKB_Users_Assigned.ChannelUserID AS AssignedChannelUserID,
	InstantKB_Users_Assigned.ChannelUsername AS AssignedChannelUsername,
	InstantKB_Users_Assigned.ChannelEmail AS AssignedChannelEmail,
	0 As Rank, 0 As MaxRank
FROM InstantKB_Tickets
	LEFT OUTER JOIN InstantKB_Users AS InstantKB_Users_Recipient INNER JOIN InstantASP_Users AS InstantASP_Users_Recipient ON InstantKB_Users_Recipient.UserID = InstantASP_Users_Recipient.UserID ON InstantKB_Tickets.TicketToUserID = InstantASP_Users_Recipient.UserID 
	LEFT OUTER JOIN InstantKB_Users AS InstantKB_Users_Sender INNER JOIN InstantASP_Users AS InstantASP_Users_Sender ON InstantKB_Users_Sender.UserID = InstantASP_Users_Sender.UserID ON InstantKB_Tickets.TicketCreatedUserID = InstantASP_Users_Sender.UserID 
	LEFT OUTER JOIN InstantKB_Users AS InstantKB_Users_Related INNER JOIN InstantASP_Users AS InstantASP_Users_Related ON InstantKB_Users_Related.UserID = InstantASP_Users_Related.UserID ON InstantKB_Tickets.TicketRelatedUserID = InstantASP_Users_Related.UserID 
	LEFT OUTER JOIN InstantKB_Users AS InstantKB_Users_Modified INNER JOIN InstantASP_Users AS InstantASP_Users_Modified ON InstantKB_Users_Modified.UserID = InstantASP_Users_Modified.UserID ON InstantKB_Tickets.TicketModifiedUserID = InstantASP_Users_Modified.UserID 
	LEFT OUTER JOIN InstantKB_Users AS InstantKB_Users_Assigned INNER JOIN InstantASP_Users AS InstantASP_Users_Assigned ON InstantKB_Users_Assigned.UserID = InstantASP_Users_Assigned.UserID ON InstantKB_Tickets.TicketAssignedUserID = InstantASP_Users_Assigned.UserID 
	LEFT OUTER JOIN InstantKB_Types ON InstantKB_Tickets.TicketTypeID = InstantKB_Types.TypeID 
	LEFT OUTER JOIN InstantKB_WorkFlowSteps ON InstantKB_Tickets.TicketWorkFlowStepID = InstantKB_WorkFlowSteps.WorkFlowStepID 
	LEFT OUTER JOIN InstantKB_Priorities ON InstantKB_Tickets.TicketPriorityID = InstantKB_Priorities.PriorityID 
	LEFT OUTER JOIN InstantKB_Status ON InstantKB_Tickets.TicketStatusID = InstantKB_Status.StatusID 
	LEFT OUTER JOIN InstantKB_TicketCustomFields ON InstantKB_Tickets.TicketID = InstantKB_TicketCustomFields.TicketID
WHERE InstantKB_Tickets.TicketID = @intTicketID

SELECT InstantKB_TicketReplies.*,
	InstantASP_Users.UserID,
	InstantASP_Users.Username,
	InstantASP_Users.EmailAddress,
	InstantASP_Users.FirstName,
	InstantASP_Users.LastName,
	InstantASP_Users.PhotoImage,
	InstantKB_Users.[Signature],
	InstantKB_Users.Channel,
	InstantKB_Users.ChannelUserID,
	InstantKB_Users.ChannelUsername,
	InstantKB_Users.ChannelEmail,
	(SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName 
FROM InstantKB_TicketReplies 
	LEFT  OUTER JOIN InstantASP_Users ON InstantKB_TicketReplies.TicketReplyUserID = InstantASP_Users.UserID 
	LEFT  OUTER JOIN InstantKB_Users ON InstantKB_TicketReplies.TicketReplyUserID = InstantKB_Users.UserID 
WHERE TicketID = @intTicketID
ORDER BY InstantKB_TicketReplies.TicketReplyCreatedDate ASC

RETURN 

GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_SelectArticlesPaged] (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit,
@strSQLFullTextMaxRank nvarchar(4000)
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
IF (@intRowsToReturn > 0) 
BEGIN
	SET ROWCOUNT @intRowsToReturn
END

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex

-- set upperbound only if we have a pagesize
IF (@intRowsToReturn > 0) 
BEGIN
	SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1
END
ELSE
BEGIN
	SET @intPageUpperBound = (SELECT COUNT(ArticleID) FROM InstantKB_Articles)
END

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	ArticleID int, Rank int, MaxRank int, SortBy sql_variant
)

-- insert data 
INSERT INTO #PageIndex (ArticleID, Rank, SortBy)
EXECUTE sp_executesql @strSQLPopulate

-- do we need to return our full text max rank
DECLARE @intMaxRank int
IF (@strSQLFullTextMaxRank <> '')
BEGIN

	-- insert full text max rank
	INSERT INTO #PageIndex (MaxRank)
	EXECUTE sp_executesql @strSQLFullTextMaxRank
	-- set max rank
	SET @intMaxRank = (SELECT MaxRank FROM #PageIndex WHERE #PageIndex.IndexID = @@IDENTITY)
	DELETE FROM #PageIndex WHERE #PageIndex.IndexID = @@IDENTITY
	UPDATE #PageIndex SET MaxRank = @intMaxRank

END

-- select the data to return
SELECT 
	IPI.Rank, 
	IPI.MaxRank, 
	InstantKB_Articles.*, 
	InstantKB_ArticleCustomFields.*,
	InstantKB_Types.*, 
	InstantKB_Levels.*, 
	InstantKB_Status.*, 
	InstantKB_Priorities.*, 
	InstantKB_WorkFlowSteps.*,	
	InstantASP_Users_CreatedBy.Username AS CreatedByUsername,
	InstantASP_Users_CreatedBy.PhotoImage AS CreatedByPhotoImage,
	InstantASP_Users_ModifiedBy.Username AS ModifiedByUsername,
	InstantASP_Users_ModifiedBy.PhotoImage AS ModifiedByPhotoImage,
	InstantASP_Users_AssignedTo.Username AS AssignedToUsername,
	InstantASP_Users_AssignedTo.PhotoImage AS AssignedToPhotoImage,
		InstantASP_Users_ReportedBy.Username AS ReportedByUsername,
	InstantASP_Users_ReportedBy.PhotoImage AS ReportedByPhotoImage,
		InstantASP_Users_SuggestedBy.Username AS SuggestedByUsername,
	InstantASP_Users_SuggestedBy.PhotoImage AS SuggestedByPhotoImage
FROM #PageIndex IPI 
	LEFT OUTER JOIN InstantKB_Articles ON InstantKB_Articles.ArticleID = IPI.ArticleID  
	LEFT OUTER JOIN InstantKB_Types ON InstantKB_Articles.ArticleTypeID = InstantKB_Types.TypeID 
	LEFT OUTER JOIN InstantKB_WorkFlowSteps ON InstantKB_Articles.ArticleWorkFlowStepID = InstantKB_WorkFlowSteps.WorkFlowStepID 
	LEFT OUTER JOIN InstantKB_Priorities ON InstantKB_Articles.ArticlePriorityID = InstantKB_Priorities.PriorityID 
	LEFT OUTER JOIN InstantKB_Status ON InstantKB_Articles.ArticleStatusID = InstantKB_Status.StatusID 
	LEFT OUTER JOIN InstantKB_Levels ON InstantKB_Articles.ArticleLevelID = InstantKB_Levels.LevelID 
	LEFT OUTER JOIN InstantKB_ArticleCustomFields ON InstantKB_Articles.ArticleID = InstantKB_ArticleCustomFields.ArticleID
	LEFT OUTER JOIN InstantASP_Users AS InstantASP_Users_CreatedBy ON InstantKB_Articles.ArticleCreatedUserID = InstantASP_Users_CreatedBy.UserID 
	LEFT OUTER JOIN InstantASP_Users AS InstantASP_Users_ModifiedBy ON InstantKB_Articles.ArticleModifiedUserID = InstantASP_Users_ModifiedBy.UserID 
	LEFT OUTER JOIN InstantASP_Users AS InstantASP_Users_AssignedTo ON InstantKB_Articles.ArticleModifiedUserID = InstantASP_Users_AssignedTo.UserID 
	LEFT OUTER JOIN InstantASP_Users AS InstantASP_Users_ReportedBy ON InstantKB_Articles.ArticleModifiedUserID = InstantASP_Users_ReportedBy.UserID 
	LEFT OUTER JOIN InstantASP_Users AS InstantASP_Users_SuggestedBy ON InstantKB_Articles.ArticleSuggestedUserID = InstantASP_Users_SuggestedBy.UserID 
WHERE 
	IPI.IndexID > @intPageLowerBound AND 
	IPI.IndexID < @intPageUpperBound 
ORDER BY 
	IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
	

GO 

---------------------------------------------

GO

CREATe PROCEDURE [ikb_sp_SelectTicketReply] (
@intTicketReplyID int
) AS

SET NOCOUNT ON 

SELECT InstantKB_TicketReplies.*,
	InstantASP_Users.UserID,
	InstantASP_Users.Username,
	InstantASP_Users.FirstName,
	InstantASP_Users.LastName,
	InstantASP_Users.PhotoImage,
	InstantKB_Users.[Signature],
	InstantKB_Users.Channel,
	InstantKB_Users.ChannelUserID,
	InstantKB_Users.ChannelUsername,
	InstantKB_Users.ChannelEmail,
	(SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName 
FROM InstantKB_TicketReplies 
	LEFT  OUTER JOIN InstantASP_Users ON InstantKB_TicketReplies.TicketReplyUserID = InstantASP_Users.UserID 
	LEFT  OUTER JOIN InstantKB_Users ON InstantKB_TicketReplies.TicketReplyUserID = InstantKB_Users.UserID 
WHERE (
	InstantKB_TicketReplies.TicketReplyID = @intTicketReplyID 
)


GO 

---------------------------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectTicketReplyByChannel] (
@strTicketReplyChannelMsgID nvarchar(255),
@intTicketReplyChannel smallint
) AS

SET NOCOUNT ON 

DECLARE @intTicketReplyID int;
SET @intTicketReplyID = (
	SELECT TOP 1 TicketReplyID
	FROM InstantKB_TicketReplies 
	WHERE (
		TicketReplyChannel = @intTicketReplyChannel AND 
		TicketReplyChannelMsgID = @strTicketReplyChannelMsgID
		)
	ORDER BY TicketReplyID DESC
)

IF (@intTicketReplyID > 0)
BEGIN
	EXEC ikb_sp_SelectTicketReply @intTicketReplyID;
END

GO 

---------------------------------------------

GO


CREATE PROCEDURE [ikb_sp_SelectUserByAPIKey] (
@strAPIKey nvarchar(255)
) AS

SET NOCOUNT ON 


IF (@strAPIKey <> '') 
BEGIN

	DECLARE @intUserID int = 0;
	SET @intUserID = (
		SELECT TOP 1 UserID FROM InstantASP_Users 
		WHERE (
			APIKey = @strAPIKey
			)
		)

	IF (@intUserID > 0) 
	BEGIN
		EXEC ikb_sp_SelectUserByUserID @intUserID
	END

END

GO 

---------------------------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectUserUserLists] (
@intUserID int
) AS
SET NOCOUNT ON 

/* Select lists asscoaited with a user */

SELECT InstantKB_UserLists.* FROM 
InstantKB_UserUserLists 
INNER JOIN InstantKB_UserLists ON InstantKB_UserUserLists.ListID = InstantKB_UserLists.ListID 
WHERE InstantKB_UserUserLists.UserID = @intUserID

GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_SelectUserByUserID] (
@intUserID int
) AS

SET NOCOUNT ON 

EXEC iasp_sp_SelectUserData '', '', '', 0, @intUserID

/* Select general user information within first record set */
SELECT InstantKB_Users.* FROM InstantKB_Users WITH (nolock) WHERE (InstantKB_Users.UserID = @intUserID)

/* Select tabs for user within second record set */
EXEC ikb_sp_SelectTabsByUserID @intUserID

/* Select departments for user in third record set */
EXEC ikb_sp_SelectDepartmentsByUserID @intUserID

/* Select lists for user in forth record set */
EXEC ikb_sp_SelectUserUserLists @intUserID


GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_SelectUser] (
@strIdentity nvarchar(255)
) AS

SET NOCOUNT ON 

EXEC iasp_sp_SelectUserData @strIdentity, '', '', 0, 0

DECLARE @intLocalUserID int
SET @intLocalUserID = ( 
	SELECT IU.UserID 
	FROM InstantASP_Users IU WITH (nolock) 
	WHERE (IU.Username = @strIdentity OR IU.EmailAddress = @strIdentity OR IU.OpenID = @strIdentity)
	)
/* Select general user information within first record set */
SELECT InstantKB_Users.* FROM InstantKB_Users WITH (nolock) WHERE (InstantKB_Users.UserID = @intLocalUserID)

/* Select tabs for user within second record set */
EXEC ikb_sp_SelectTabsByUserID @intLocalUserID

/* Select departments for user in third record set */
EXEC ikb_sp_SelectDepartmentsByUserID @intLocalUserID

/* Select lists for user in forth record set */
EXEC ikb_sp_SelectUserUserLists @intLocalUserID

RETURN 


GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_SelectStatisticsForUser] (
@intUserID int,
@intTabID int
)
AS

SET NOCOUNT ON 

/* Select statistics for a single user within the knowledgebase */

DECLARE @intTotalLiveComments int
DECLARE @intTotalPrivateComments int
DECLARE @intTicketsAssignedToMe int
DECLARE @TotalTimeWorked int
DECLARE @TotalSentTickets int
DECLARE @TotalReceivedTickets int
DECLARE @TotalRelatedTickets int
DECLARE @TotalOpenTickets int
DECLARE @TotalClosedTickets int
DECLARE @TotalAttachments int
DECLARE @TicketFirstPostDate DateTime

SET @intTotalLiveComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE (UserID = @intUserID AND AccessType = 1))
SET @intTotalPrivateComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE (UserID = @intUserID AND AccessType = 2))

IF (@intTabID > 0) 
BEGIN

	If (@intUserID > 0) 
	BEGIN

		SET @TotalSentTickets = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets  WITH (nolock) 
			WHERE (TicketTabID = @intTabID AND TicketCreatedUserID  = @intUserID)
		)

		SET @TotalReceivedTickets = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets  WITH (nolock) 
			WHERE (TicketTabID = @intTabID AND TicketToUserID  = @intUserID)
		)

		SET @TotalRelatedTickets = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets  WITH (nolock) 
			WHERE (TicketTabID = @intTabID AND TicketRelatedUserID  = @intUserID)
		)

		SET @TotalOpenTickets = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets  WITH (nolock) 
			WHERE (TicketTabID = @intTabID AND TicketCreatedUserID  = @intUserID AND TicketClosedDate IS NULL)
		)

		SET @TotalClosedTickets = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets  WITH (nolock) 
			WHERE (TicketTabID = @intTabID AND TicketCreatedUserID  = @intUserID  AND TicketClosedDate IS NOT NULL)
		)

		SET @TotalTimeWorked = (
			SELECT SUM(TicketTimeWorked) FROM InstantKB_Tickets  WITH (nolock) 
			WHERE (TicketTabID = @intTabID AND (TicketCreatedUserID  = @intUserID  OR TicketToUserID  = @intUserID OR TicketRelatedUserID  = @intUserID))
		)

		SET @intTicketsAssignedToMe = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
			WHERE (InstantKB_Tickets.TicketAssignedUserID  = @intUserID AND TicketIsSpam = 0 AND TicketIsArchived = 0 AND TicketClosedDate IS NULL AND TicketTabID = @intTabID)
		)

		SET @TotalAttachments = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
			INNER JOIN InstantKB_Attachments ON InstantKB_Tickets.TicketID = InstantKB_Attachments.RelatedEntityID
			WHERE ((				
				InstantKB_Tickets.TicketCreatedUserID  = @intUserID OR 
				InstantKB_Tickets.TicketToUserID  = @intUserID OR 
				InstantKB_Tickets.TicketRelatedUserID  = @intUserID) AND 
				(InstantKB_Attachments.AttachmentType = 2 AND
				TicketTabID = @intTabID)
			 )
		)
		

		SET @TicketFirstPostDate = (
			SELECT TOP 1 TicketCreatedDate FROM InstantKB_Tickets WITH (nolock) 
			WHERE (InstantKB_Tickets.TicketCreatedUserID  = @intUserID  AND TicketTabID = @intTabID) 
			ORDER BY TicketCreatedDate ASC
		)		

	END
	
END
ELSE
BEGIN

	-- no specific tab ID

	SET @TotalSentTickets = (
		SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
		WHERE ( TicketCreatedUserID  = @intUserID)
	)

	SET @TotalReceivedTickets = (
		SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
		WHERE (TicketToUserID  = @intUserID)
	)

	SET @TotalRelatedTickets = (
		SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
		WHERE (TicketRelatedUserID  = @intUserID)
	)

	SET @TotalOpenTickets = (
		SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
		WHERE ( TicketCreatedUserID  = @intUserID AND TicketClosedDate IS NULL)
	)

	SET @TotalClosedTickets = (
		SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
		WHERE ( TicketCreatedUserID  = @intUserID  AND TicketClosedDate IS NOT NULL)
	)

	SET @TotalTimeWorked = (
		SELECT SUM(TicketTimeWorked) FROM InstantKB_Tickets WITH (nolock) 
		WHERE ( TicketCreatedUserID  = @intUserID OR TicketToUserID  = @intUserID OR TicketRelatedUserID  = @intUserID)
	)

	SET @intTicketsAssignedToMe = (
		SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
		WHERE (InstantKB_Tickets.TicketAssignedUserID  = @intUserID AND TicketIsSpam = 0 AND TicketIsArchived = 0 AND TicketClosedDate IS NULL)
	)

		SET @TotalAttachments = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
			INNER JOIN InstantKB_Attachments ON InstantKB_Tickets.TicketID = InstantKB_Attachments.RelatedEntityID
			WHERE ((				
				InstantKB_Tickets.TicketCreatedUserID  = @intUserID OR 
				InstantKB_Tickets.TicketToUserID  = @intUserID OR 
				InstantKB_Tickets.TicketRelatedUserID  = @intUserID) AND 
				(InstantKB_Attachments.AttachmentType = 2)
			 )
		)

		SET @TicketFirstPostDate = (
		SELECT TOP 1 TicketCreatedDate FROM InstantKB_Tickets WITH (nolock) 
		WHERE (InstantKB_Tickets.TicketCreatedUserID  = @intUserID) 
		ORDER BY TicketCreatedDate DESC
	)

				
END


SELECT 
@intTotalLiveComments As TotalLiveComments, 
@intTotalPrivateComments As TotalPrivateComments,
@TotalTimeWorked AS TotalTimeWorked,
@intTicketsAssignedToMe AS TicketsAssignedToMe,
@TotalSentTickets as TotalSentTickets,
@TotalReceivedTickets as TotalReceivedTickets,
@TotalRelatedTickets as TotalRelatedTickets,
@TotalOpenTickets as TotalOpenTickets,
@TotalClosedTickets as TotalClosedTickets,
@TotalAttachments AS TotalAttachments,
@TicketFirstPostDate AS TicketFirstPostDate

RETURN 

GO 

---------------------------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectAttachmentsForUser] (
@intTabID int,
@intUserID int,
@intAttachmentType int
) AS
SET NOCOUNT ON 

/* Returns all attachments for a specific user */

-- articles
IF (@intAttachmentType = 1)
BEGIN

	IF (@intTabID > 0)
	BEGIN
		SELECT InstantKB_Attachments.*,
		InstantKB_Articles.ArticleTitle AS RelatedEntityTitle
		FROM 
		InstantKB_Articles WITH (nolock) 
		INNER JOIN InstantKB_Attachments ON InstantKB_Articles.ArticleId = InstantKB_Attachments.RelatedEntityID
		WHERE ((				
			InstantKB_Articles.ArticleCreatedUserID  = @intUserID) AND 
			(InstantKB_Attachments.AttachmentType = @intAttachmentType
			AND TabID = @intTabID)
		)
	END
	ELSE
	BEGIN
		SELECT InstantKB_Attachments.*,
		InstantKB_Articles.ArticleTitle AS RelatedEntityTitle
		FROM 
		InstantKB_Articles WITH (nolock) 
		INNER JOIN InstantKB_Attachments ON InstantKB_Articles.ArticleId = InstantKB_Attachments.RelatedEntityID
		WHERE ((				
			InstantKB_Articles.ArticleCreatedUserID  = @intUserID) AND 
			(InstantKB_Attachments.AttachmentType = @intAttachmentType)
		)
	END

END

-- tickets
IF (@intAttachmentType = 2)
BEGIN

	IF (@intTabID >  0)
	BEGIN
		SELECT InstantKB_Attachments.*,
		InstantKB_Tickets.TicketTitle AS RelatedEntityTitle
		FROM 
		InstantKB_Tickets WITH (nolock) 
		INNER JOIN InstantKB_Attachments ON InstantKB_Tickets.TicketID = InstantKB_Attachments.RelatedEntityID
		WHERE ((				
			InstantKB_Tickets.TicketCreatedUserID  = @intUserID OR 
			InstantKB_Tickets.TicketToUserID  = @intUserID OR 
			InstantKB_Tickets.TicketRelatedUserID  = @intUserID) AND 
			(InstantKB_Attachments.AttachmentType = @intAttachmentType
			AND TicketTabID = @intTabID)
		)
	END
	ELSE
	BEGIN
		SELECT InstantKB_Attachments.*,
		InstantKB_Tickets.TicketTitle AS RelatedEntityTitle
		FROM 
		InstantKB_Tickets WITH (nolock) 
		INNER JOIN InstantKB_Attachments ON InstantKB_Tickets.TicketID = InstantKB_Attachments.RelatedEntityID
		WHERE ((				
			InstantKB_Tickets.TicketCreatedUserID  = @intUserID OR 
			InstantKB_Tickets.TicketToUserID  = @intUserID OR 
			InstantKB_Tickets.TicketRelatedUserID  = @intUserID) AND 
			(InstantKB_Attachments.AttachmentType = @intAttachmentType)
		)
	END

END


GO 

---------------------------------------------

GO

ALTER PROCEDURE [ikb_sp_SelectTicketNotes] (
@intTicketID int,
@intTabID int,
@intUserID int
)
AS

SET NOCOUNT ON 

/* select ticket notes */


IF (@intTicketID > 0) 
BEGIN

	SELECT 
		InstantKB_TicketNotes.TicketNoteID, 
		InstantKB_TicketNotes.TicketID, 
		InstantKB_TicketNotes.NoteRelatedUserID,
		InstantKB_Tickets.TicketTitle,
		InstantKB_TicketNotes.NoteText, 
		InstantKB_TicketNotes.NoteDate,
		InstantASP_Users.UserID, 
		InstantASP_Users.OpenID, 
		InstantASP_Users.Username,
		InstantASP_Users.PhotoImage
	FROM  
	InstantKB_TicketNotes 
	INNER JOIN	InstantKB_Tickets ON InstantKB_TicketNotes.TicketID = InstantKB_Tickets.TicketID 		
	LEFT OUTER JOIN	InstantASP_Users ON InstantKB_TicketNotes.NoteUserID = InstantASP_Users.UserID
	WHERE InstantKB_TicketNotes.TicketID = @intTicketID
	ORDER BY InstantKB_TicketNotes.NoteDate DESC

END

IF (@intUserID > 0)
BEGIN

	IF (@intTabID > 0) 
	BEGIN
	
		SELECT 
		InstantKB_TicketNotes.TicketNoteID, 
		InstantKB_TicketNotes.TicketID, 
		InstantKB_TicketNotes.NoteRelatedUserID,
		InstantKB_Tickets.TicketTitle,
		InstantKB_TicketNotes.NoteText, 
		InstantKB_TicketNotes.NoteDate,
		InstantASP_Users.UserID, 
		InstantASP_Users.OpenID, 
		InstantASP_Users.Username,
		InstantASP_Users.PhotoImage
		FROM  
		InstantKB_TicketNotes 
		LEFT OUTER JOIN	InstantKB_Tickets ON InstantKB_TicketNotes.TicketID = InstantKB_Tickets.TicketID 
		LEFT OUTER JOIN	InstantASP_Users ON InstantKB_TicketNotes.NoteUserID = InstantASP_Users.UserID
		WHERE (InstantKB_TicketNotes.NoteRelatedUserID = @intUserID) AND 
		(InstantKB_Tickets.TicketTabID = @intTabID)
		ORDER BY InstantKB_TicketNotes.NoteDate DESC

	END
	ELSE
	BEGIN
	
		SELECT 
		InstantKB_TicketNotes.TicketNoteID, 
		InstantKB_TicketNotes.TicketID, 
		InstantKB_TicketNotes.NoteRelatedUserID,
		InstantKB_Tickets.TicketTitle,
		InstantKB_TicketNotes.NoteText, 
		InstantKB_TicketNotes.NoteDate,
		InstantASP_Users.UserID, 
		InstantASP_Users.OpenID, 
		InstantASP_Users.Username,
		InstantASP_Users.PhotoImage
		FROM  
		InstantKB_TicketNotes 
		LEFT OUTER JOIN	InstantKB_Tickets ON InstantKB_TicketNotes.TicketID = InstantKB_Tickets.TicketID 
		LEFT OUTER JOIN	InstantASP_Users ON InstantKB_TicketNotes.NoteUserID = InstantASP_Users.UserID
		WHERE (InstantKB_TicketNotes.NoteRelatedUserID = @intUserID)
		ORDER BY InstantKB_TicketNotes.NoteDate DESC

	END
END

RETURN

GO 

---------------------------------------------

GO



ALTER PROCEDURE [ikb_sp_SelectStatisticsForTicketTab] (
@intTabID int
)
AS

SET NOCOUNT ON 

DECLARE @intPendingTickets int
DECLARE @intOverdueTickets int
DECLARE @EscalatedTickets int
DECLARE @intTotalTickets int

IF (@intTabID > 0) 
BEGIN
	SET @intPendingTickets =  (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (InstantKB_Tickets.TicketIsStaffReply  = 0 AND TicketTabID = @intTabID))
	SET @intOverdueTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE ((InstantKB_Tickets.TicketDueDate IS NOT NULL AND InstantKB_Tickets.TicketDueDate <= GETDATE())  AND TicketTabID = @intTabID))
	SET @EscalatedTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (InstantKB_Tickets.TicketIsEscalated = 1  AND TicketTabID = @intTabID))
	SET @intTotalTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (TicketTabID = @intTabID))
END
ELSE
BEGIN
	SET @intPendingTickets =  (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (InstantKB_Tickets.TicketIsStaffReply  = 0))
	SET @intOverdueTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE ((InstantKB_Tickets.TicketDueDate IS NOT NULL AND InstantKB_Tickets.TicketDueDate <= GETDATE())))
	SET @EscalatedTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (InstantKB_Tickets.TicketIsEscalated = 1))
	SET @intTotalTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock))
END

SELECT
@intPendingTickets As PendingTickets,
@intOverdueTickets AS OverdueTickets,
@EscalatedTickets AS EscalatedTickets,
@intTotalTickets AS TotalTickets

RETURN 

GO 

---------------------------------------------

GO


CREATE PROCEDURE [ikb_sp_SelectTicketNote] (
@intTicketNoteID int
)
AS

SET NOCOUNT ON 

/* select a single ticket notes */
	
SELECT 
	InstantKB_TicketNotes.TicketNoteID, 
	InstantKB_TicketNotes.TicketID, 
	InstantKB_TicketNotes.NoteRelatedUserID,
	InstantKB_Tickets.TicketTitle,
	InstantKB_TicketNotes.NoteText, 
	InstantKB_TicketNotes.NoteDate,
	InstantASP_Users.UserID, 
	InstantASP_Users.OpenID, 
	InstantASP_Users.Username,
	InstantASP_Users.PhotoImage
FROM  
InstantKB_TicketNotes 
LEFT OUTER JOIN InstantKB_Tickets ON InstantKB_TicketNotes.TicketID = InstantKB_Tickets.TicketID 
LEFT OUTER JOIN	InstantASP_Users ON InstantKB_TicketNotes.NoteUserID = InstantASP_Users.UserID
WHERE (InstantKB_TicketNotes.TicketNoteID = @intTicketNoteID)

RETURN


GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_InsertUpdateTicketNote] (
@intTicketNoteID int,
@intTicketID int,
@strNoteText ntext,
@intNoteUserID int,
@intNoteRelatedUserID int,
@intIdentity int output
) AS

SET NOCOUNT ON 

-- is this an update or insert?
IF (@intTicketNoteID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_TicketNotes
		(
		TicketID, 
		NoteText,
		NoteUserID,
		NoteRelatedUserID,
		NoteDate

		)		
	VALUES 		(		
		@intTicketID,
		@strNoteText,
		@intNoteUserID,
		@intNoteRelatedUserID,
		GETDATE()
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	
END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_TicketNotes SET
	NoteText = @strNoteText,
	NoteUserID = @intNoteUserID,
	NoteRelatedUserID = @intNoteRelatedUserID
	WHERE InstantKB_TicketNotes.TicketNoteID = @intTicketNoteID

	-- return the identity
	SET @intIdentity = @intTicketNoteID

END

GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_CleanTables] (
@strDateTime nvarchar(255)
)
AS

SET NOCOUNT ON 

/* Cleans all tables of any expired data */

-- delete expired who's on data
EXEC ikb_sp_DeleteWhosOnData @strDateTime

-- delete expired topic read information
EXEC ikb_sp_DeleteExpiredArticleRead @strDateTime

-- flah overddue tickets
UPDATE InstantKB_Tickets SET
InstantKB_Tickets.TicketOverdue = 1
WHERE InstantKB_Tickets.TicketDueDate <= @strDateTime

-- reset tickets if we don't have a due date
UPDATE InstantKB_Tickets SET
InstantKB_Tickets.TicketIsEscalated = 0,
InstantKB_Tickets.TicketOverdue = 0 
WHERE InstantKB_Tickets.TicketDueDate IS NULL

-- set expired public articles to private
UPDATE InstantKB_Articles SET
ArticleAccessType = 2
WHERE (
	ArticleAccessType = 1 AND 
	ArticleExpiresDate IS NOT NULL AND 
	ArticleExpiresDate <= @strDateTime
)

-- delete view state data older than 5 days
DELETE TOP (500)  
FROM  InstantASP_ViewState
WHERE (InstantASP_ViewState.DateStamp < DateAdd("d", -5, GetDate()))

-- return overdue but not escalated ticket IDs so we can run escalation ruls
SELECT TicketID FROM InstantKB_Tickets 
WHERE (InstantKB_Tickets.TicketOverdue = 1 AND
 InstantKB_Tickets.TicketIsEscalated = 0)

RETURN


GO 

---------------------------------------------

GO

ALTER PROCEDURE [iasp_sp_InsertSearchTerm] (
@strKeywords nvarchar(255),
@intUserID int,
@strIPAddress nvarchar(20),
@intContentType int,
@intApplicationID tinyint,
@intResults int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a user search within the InstantASP_Searches table */

-- insert the term
INSERT INTO InstantASP_Searches (
	Keywords, 
	UserID,
	IPAddress,
	ContentType,
	ApplicationID,
	Results,
	DateStamp
) VALUES
(
	@strKeywords, 
	@intUserID,
	@strIPAddress,
	@intContentType,
	@intApplicationID,
	@intResults,
	GetDate()
)
	
-- return the terms new identity
SET @intIdentity = @@IDENTITY
RETURN
	

GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_InsertUpdateArticle] (
@intArticleID int,
@intArticleParentID int,
@intArticleCategoryID int,
@strArticleTitle nvarchar(500),
@strArticleText nvarchar(max),
@intArticlePercentComplete int,
@intArticleTypeID int,
@intArticleLevelID int,
@intArticleStatusID int,
@intArticlePriorityID int,
@intArticleAccessType tinyint,
@intArticleWorkFlowStepID int,
@intArticleCreatedUserID int,
@intArticleModifiedUserID int,
@intArticleAssignedUserID int,
@dtArticleAssignedDate datetime,
@intArticleSuggestedUserID int,
@strArticleSuggestedUsername nvarchar(255),
@strArticleSuggestedEmail nvarchar(255),
@dtArticleSuggestedDate datetime,
@intArticleReportedUserID int,
@dtArticleReportedDate datetime,
@dtArticleDueDate datetime,
@dtArticleReviewDate datetime,
@dtArticleExpiresDate datetime,
@intTabID int,
@strArticleTitleEncoded nvarchar(500),
@strArticleDownloadFile nvarchar(255),
@strArticleDownloadLink nvarchar(255),
@strArticleDownloadPassword nvarchar(255),
@strArticleImageUrl nvarchar(255),
@bolUpdateLastModified bit,
@strArticleSettingsXML nvarchar(max),
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a article within the InstantKB_Articles table */

-- setup variables to hold usernames obtained from identities

DECLARE @dtArticleModifiedDate datetime
DECLARE @strArticleModifiedUsername nvarchar(255)

DECLARE @strArticleCreatedUsername nvarchar(255)
DECLARE @strArticleAssignedUsername nvarchar(255)
DECLARE @strArticleReportedUsername nvarchar(255)

SET @strArticleCreatedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleCreatedUserID))
SET @strArticleAssignedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleAssignedUserID))
SET @strArticleReportedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleReportedUserID))
SET @strArticleModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleModifiedUserID))
SET @dtArticleModifiedDate = GetDate()

-- is this an update or insert?
IF (@intArticleID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Articles 
		(ArticleParentID, 
		ArticleCategoryID,
		ArticleTitle, 
		ArticleTitleEncoded,
		ArticleText, 
		ArticlePercentComplete, 
		ArticleTypeID, 
		ArticleLevelID, 
		ArticleStatusID, 
		ArticlePriorityID, 
		ArticleAccessType, 
		ArticleWorkFlowStepID, 
		ArticleCreatedUserID, 
		ArticleCreatedUsername, 
		ArticleCreatedDate, 
		ArticleModifiedUserID, 
		ArticleModifiedUsername,
		ArticleModifiedDate,
		ArticleAssignedUserID,
		ArticleAssignedUsername,
		ArticleAssignedDate,
		ArticleSuggestedUserID,
		ArticleSuggestedUsername,
		ArticleSuggestedEmail,
		ArticleSuggestedDate,
		ArticleReportedUserID,
		ArticleReportedUsername,
		ArticleReportedDate,
		ArticleDueDate,
		ArticleReviewDate,
		ArticleExpiresDate,
		TabID,
		ArticleDownloadFile,
		ArticleDownloadLink, 
		ArticleDownloadPassword,
		ArticleImageUrl,
		ArticleSettingsXML
	)
	VALUES 
		(@intArticleParentID,
		@intArticleCategoryID,
		@strArticleTitle,
		@strArticleTitleEncoded,
		@strArticleText,
		@intArticlePercentComplete,
		@intArticleTypeID,
		@intArticleLevelID,
		@intArticleStatusID,
		@intArticlePriorityID,
		@intArticleAccessType,
		@intArticleWorkFlowStepID,
		@intArticleCreatedUserID,
		IsNull(@strArticleCreatedUsername,''),
		GetDate(),
		@intArticleModifiedUserID,
		IsNull(@strArticleModifiedUsername,''),
		GetDate(),		
		@intArticleAssignedUserID,
		IsNull(@strArticleAssignedUsername,''),
		@dtArticleAssignedDate,
		@intArticleSuggestedUserID,
		@strArticleSuggestedUsername,
		@strArticleSuggestedEmail,
		@dtArticleSuggestedDate,
		@intArticleReportedUserID,
		IsNull(@strArticleReportedUsername,''),
		@dtArticleReportedDate,
		@dtArticleDueDate,
		@dtArticleReviewDate,
		@dtArticleExpiresDate,
		@intTabID,
		@strArticleDownloadFile,
		@strArticleDownloadLink,
		@strArticleDownloadPassword, 
		@strArticleImageUrl,
		@strArticleSettingsXML
	)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update modified by?
	IF (@bolUpdateLastModified = 0)
	BEGIN
		SET @dtArticleModifiedDate = (SELECT ArticleModifiedDate FROM InstantKB_Articles WHERE ArticleID = @intArticleID)
		SET @intArticleModifiedUserID = (SELECT ArticleModifiedUserID FROM InstantKB_Articles WHERE ArticleID = @intArticleID)
	SET @intArticleModifiedUserID = (SELECT ArticleModifiedUserID FROM InstantKB_Articles WHERE ArticleID = @intArticleID)
	END

	-- update
	UPDATE InstantKB_Articles SET
	ArticleParentID = @intArticleParentID, 
	ArticleCategoryID = @intArticleCategoryID,
	ArticleTitle = @strArticleTitle, 
	ArticleTitleEncoded = @strArticleTitleEncoded,
	ArticleText = @strArticleText, 
	ArticlePercentComplete = @intArticlePercentComplete, 
	ArticleTypeID = @intArticleTypeID, 
	ArticleLevelID = @intArticleLevelID, 
	ArticleStatusID = @intArticleStatusID, 
	ArticlePriorityID = @intArticlePriorityID, 
	ArticleAccessType = @intArticleAccessType,
	ArticleWorkFlowStepID = @intArticleWorkFlowStepID, 
	ArticleModifiedUserID = @intArticleModifiedUserID, 
	ArticleModifiedUsername = IsNull(@strArticleModifiedUsername,''),
	ArticleModifiedDate = @dtArticleModifiedDate,
	ArticleAssignedUserID = @intArticleAssignedUserID,
	ArticleAssignedUsername = IsNull(@strArticleAssignedUsername,''),
	ArticleAssignedDate = @dtArticleAssignedDate,
	ArticleSuggestedUserID = @intArticleSuggestedUserID,
	ArticleSuggestedUsername = @strArticleSuggestedUsername,
	ArticleSuggestedEmail = @strArticleSuggestedEmail,
	ArticleSuggestedDate = @dtArticleSuggestedDate,
	ArticleReportedUserID = @intArticleReportedUserID,
	ArticleReportedUsername = IsNull(@strArticleReportedUsername,''),
	ArticleReportedDate = @dtArticleReportedDate,
	ArticleDueDate = @dtArticleDueDate,
	ArticleReviewDate = @dtArticleReviewDate,
	ArticleExpiresDate = @dtArticleExpiresDate,
	TabID = @intTabID,
	ArticleDownloadFile = @strArticleDownloadFile,
	ArticleDownloadLink = @strArticleDownloadLink,
	ArticleDownloadPassword = @strArticleDownloadPassword,
	ArticleImageUrl = @strArticleImageUrl,
	ArticleSettingsXML = @strArticleSettingsXML
	WHERE InstantKB_Articles.ArticleID = @intArticleID

	-- return the identity
	SET @intIdentity = @intArticleID
	RETURN

END

SET @intIdentity = 0
RETURN

GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_InsertArticleRating] (
@intArticleID int,
@intRating tinyint,
@intUserID int,
@strIPAddress nvarchar(20),
@strComments nvarchar(max),
@intIdentity int output
)
AS

SET NOCOUNT ON 

DECLARE @intArticleRatingID int;
IF (@intUserID > 0) 
BEGIN
	SET @intArticleRatingID = (
		SELECT TOP 1 ArticleRatingID FROM InstantKB_ArticleRatings WHERE (ArticleID = @intArticleID AND UserID = @intUserID)
	)
END
ELSE
BEGIN
	SET @intArticleRatingID = (
		SELECT TOP 1 ArticleRatingID FROM InstantKB_ArticleRatings WHERE (ArticleID = @intArticleID AND IPAddress = @strIPAddress)
	)
END


SET @intArticleRatingID = IsNull(@intArticleRatingID,0)

-- check to see if user has already rated article
IF (@intArticleRatingID > 0)
BEGIN

	-- if no comments are supplied keep existing comments
	IF (@strComments = '')
	BEGIN
		SET @strComments = (SELECT Comments FROM InstantKB_ArticleRatings WHERE InstantKB_ArticleRatings.ArticleRatingID = @intArticleRatingID) 
	END

	UPDATE InstantKB_ArticleRatings SET
	UserID = @intUserID,
	ArticleID = @intArticleID,
	ArticleRating = @intRating,
	Comments = @strComments,
	IPAddress = @strIPAddress
	WHERE InstantKB_ArticleRatings.ArticleRatingID = @intArticleRatingID	
		
	-- set to new inserted identity	
	SET @intIdentity = 0

END
ELSE
BEGIN

	-- user has not previously rated article
	INSERT INTO InstantKB_ArticleRatings (
		UserID, 
		ArticleID, 
		ArticleRating, 
		Comments,
		IPAddress
	) VALUES (
		@intUserID, 
		@intArticleID, 
		@intRating, 
		@strComments,
		@strIPAddress
	)
	
	-- set to new inserted identity	
	SET @intIdentity = @@IDENTITY

END

-- update articles table with mean number
EXEC ikb_sp_UpdateArticleRatingMeanNumber @intArticleID


GO 

---------------------------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectLastTicketReply] (
@intTicketID int

) AS

SET NOCOUNT ON 

DECLARE @intTicketReplyID int;
SET @intTicketReplyID = (
	SELECT TOP 1 TicketReplyID
	FROM InstantKB_TicketReplies
	WHERE (TicketID = @intTicketID)
	ORDER BY TicketReplyID DESC
)

IF (@intTicketReplyID > 0)
BEGIN
	EXEC ikb_sp_SelectTicketReply @intTicketReplyID
END

GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_DeleteUser] (
@intUserID int
)
AS

SET NOCOUNT ON 

/* Deletes a user from the InstantKB_Users table, role deletes are cascaded */

DELETE FROM InstantKB_Users 
WHERE (InstantKB_Users.UserID = @intUserID)

DELETE FROM InstantKB_Tickets 
WHERE (
	TicketCreatedUserID = @intUserID OR 
	TicketToUserID = @intUserID OR
	TicketRelatedUserID = @intUserID
)

DELETE FROM InstantKB_TicketReplies
WHERE (TicketReplyUserID = @intUserID)

DELETE FROM InstantKB_ArticleComments
WHERE (UserID = @intUserID)

EXEC iasp_sp_DeleteUser @intUserID

GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_SelectArticleRead] (
@intUserID int
)
AS

SET NOCOUNT ON 

SELECT ArticleReadArticleID, MAX(ArticleReadDate) AS ArticleReadDate
FROM InstantKB_ArticleRead WITH (nolock) 
WHERE InstantKB_ArticleRead.ArticleReadUserID = @intUserID
GROUP BY ArticleReadArticleID
ORDER BY ArticleReadDate

GO 

---------------------------------------------

GO


CREATE PROCEDURE [ikb_sp_SelectArticleRatings] (
@intArticleID int
)
AS

SET NOCOUNT ON 

SELECT 
	InstantKB_ArticleRatings.*, 
	InstantKB_Users.*, 
	InstantASP_Users.*
FROM 
	InstantKB_Users 
	INNER JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID 
	RIGHT OUTER JOIN InstantKB_ArticleRatings ON InstantASP_Users.UserID = InstantKB_ArticleRatings.UserID
WHERE 
	InstantKB_ArticleRatings.ArticleID = @intArticleID
ORDER BY 
	InstantKB_ArticleRatings.DateStamp DESC

GO 

---------------------------------------------

GO


CREATE PROCEDURE [ikb_sp_DeleteArticleRatings] (
@intArticleID int
) AS
SET NOCOUNT ON 

/* Deletes all ratings for an article from the InstantKB_ArticleRatings table */

DELETE FROM InstantKB_ArticleRatings
WHERE (InstantKB_ArticleRatings.ArticleID = @intArticleID)

UPDATE InstantKB_Articles SET
	TotalRatings = 0,
	ArticleRating = 0
WHERE
	ArticleID = @intArticleID

RETURN


GO 

---------------------------------------------

GO


CREATE PROCEDURE [ikb_sp_DeleteArticleRating] (
@intArticleRatingID int
) AS
SET NOCOUNT ON 

/* Deletes a single rating from the InstantKB_ArticleRatings table */

DECLARE @intArticleID int;
SET @intArticleID =  (
	SELECT ArticleID FROM InstantKB_ArticleRatings WHERE (InstantKB_ArticleRatings.ArticleRatingID = @intArticleRatingID)
	)

DELETE FROM InstantKB_ArticleRatings
WHERE (InstantKB_ArticleRatings.ArticleRatingID = @intArticleRatingID)

-- update articles table with mean number
EXEC ikb_sp_UpdateArticleRatingMeanNumber @intArticleID

RETURN



GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_SelectStatisticsForTicketTab] (
@intTabID int
)
AS

SET NOCOUNT ON 

DECLARE @intPendingTickets int
DECLARE @intOverdueTickets int
DECLARE @EscalatedTickets int
DECLARE @intTotalTickets int
DECLARE @intOpenTickets int
DECLARE @intClosedTickets int
DECLARE @intArchivedTickets int
DECLARE @intSpamTickets int

IF (@intTabID > 0) 
BEGIN

	SET @intPendingTickets =  (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (InstantKB_Tickets.TicketIsStaffReply  = 0 AND TicketClosedDate IS NULL AND TicketIsArchived = 0 AND TicketIsSpam = 0 AND TicketTabID = @intTabID))
	SET @intOverdueTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE ((InstantKB_Tickets.TicketDueDate IS NOT NULL AND InstantKB_Tickets.TicketDueDate <= GETDATE())  AND TicketTabID = @intTabID AND TicketIsArchived = 0 AND TicketIsSpam = 0))
	SET @EscalatedTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (InstantKB_Tickets.TicketIsEscalated = 1  AND TicketTabID = @intTabID AND TicketIsArchived = 0 AND TicketIsSpam = 0))
	SET @intTotalTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (TicketTabID = @intTabID))
	SET @intOpenTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (TicketTabID = @intTabID AND TicketClosedDate IS NULL AND TicketIsArchived = 0 AND TicketIsSpam = 0))
	SET @intClosedTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (TicketTabID = @intTabID AND TicketClosedDate IS NOT NULL AND TicketIsArchived = 0 AND TicketIsSpam = 0))
	SET @intArchivedTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (TicketTabID = @intTabID AND TicketIsArchived = 1))
	SET @intSpamTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (TicketTabID = @intTabID AND TicketIsSpam = 1))

END
ELSE
BEGIN

	SET @intPendingTickets =  (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (InstantKB_Tickets.TicketIsStaffReply  = 0 AND TicketClosedDate IS NULL AND TicketIsArchived = 0 AND TicketIsSpam = 0))
	SET @intOverdueTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE ((InstantKB_Tickets.TicketDueDate IS NOT NULL AND InstantKB_Tickets.TicketDueDate <= GETDATE()) AND TicketIsArchived = 0 AND TicketIsSpam = 0))
	SET @EscalatedTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (InstantKB_Tickets.TicketIsEscalated = 1 AND TicketIsArchived = 0 AND TicketIsSpam = 0))
	SET @intTotalTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock))
	SET @intOpenTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (TicketClosedDate IS NULL AND TicketIsArchived = 0 AND TicketIsSpam = 0))
	SET @intClosedTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (TicketClosedDate IS NOT NULL AND TicketIsArchived = 0 AND TicketIsSpam = 0))
	SET @intArchivedTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (TicketIsArchived = 1))
	SET @intSpamTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) WHERE (TicketIsSpam = 1))


END

SELECT
@intPendingTickets As PendingTickets,
@intOverdueTickets AS OverdueTickets,
@EscalatedTickets AS EscalatedTickets,
@intTotalTickets AS TotalTickets,
@intOpenTickets AS OpenTickets,
@intClosedTickets AS ClosedTickets,
@intArchivedTickets AS ArchivedTickets,
@intSpamTickets AS SpamTickets

RETURN 

GO 

---------------------------------------------

GO

ALTER PROCEDURE [ikb_sp_SelectStatisticsForTab] (
@intTabID int,
@intUserID int
)
AS

SET NOCOUNT ON 

DECLARE @intTotalCategories int
DECLARE @intTotalLiveArticles int
DECLARE @intTotalPrivateArticles int
DECLARE @intTotalLiveComments int
DECLARE @intTotalPrivateomments int
DECLARE @intOverdueArticles int
DECLARE @intExpiredArticles int
DECLARE @intDueForReview int
DECLARE @intAssignedToMe int


IF (@intTabID = 0) -- general stats
BEGIN

	SET @intTotalCategories = (SELECT COUNT(CategoryID) FROM InstantKB_Categories WITH (nolock))
	SET @intTotalLiveArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles WITH (nolock) WHERE (InstantKB_Articles.ArticleAccessType = 1))
	SET @intTotalPrivateArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles WITH (nolock) WHERE (ArticleAccessType = 2))
	SET @intTotalLiveComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WITH (nolock) WHERE (AccessType = 1))
	SET @intTotalPrivateomments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WITH (nolock) WHERE (AccessType = 2))
	SET @intOverdueArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles WITH (nolock) WHERE (ArticleDueDate <= GetDate()))
	SET @intExpiredArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles WITH (nolock) WHERE (ArticleExpiresDate <= GetDate()))
	SET @intDueForReview = (SELECT COUNT(ArticleID) FROM InstantKB_Articles WITH (nolock) WHERE (ArticleReviewDate <= GetDate()))
	SET @intAssignedToMe = (SELECT COUNT(ArticleID) FROM InstantKB_Articles WITH (nolock) WHERE (ArticleAssignedUserID = @intUserID))

END
ELSE -- rab specific stats
BEGIN

	SET @intTotalCategories = (SELECT COUNT(CategoryID) FROM InstantKB_Categories WITH (nolock) WHERE (InstantKB_Categories.TabID = @intTabID))
	SET @intTotalLiveArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles WITH (nolock) WHERE (InstantKB_Articles.TabID = @intTabID AND InstantKB_Articles.ArticleAccessType = 1))
	SET @intTotalPrivateArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles WITH (nolock) WHERE (InstantKB_Articles.TabID = @intTabID AND InstantKB_Articles.ArticleAccessType = 2))	
	SET @intTotalLiveComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WITH(nolock) INNER JOIN InstantKB_Articles ON InstantKB_ArticleComments.ArticleID = InstantKB_Articles.ArticleID WHERE (InstantKB_Articles.TabID = @intTabID AND InstantKB_ArticleComments.AccessType = 1))
	SET @intTotalPrivateomments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WITH (nolock) INNER JOIN InstantKB_Articles ON InstantKB_ArticleComments.ArticleID = InstantKB_Articles.ArticleID WHERE (InstantKB_Articles.TabID = @intTabID AND InstantKB_ArticleComments.AccessType = 2))
	SET @intOverdueArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles WITH (nolock) WHERE (TabID = @intTabID AND ArticleDueDate <= GetDate()))
	SET @intExpiredArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles WITH (nolock) WHERE (TabID = @intTabID AND ArticleExpiresDate <= GetDate()))
	SET @intDueForReview = (SELECT COUNT(ArticleID) FROM InstantKB_Articles WITH (nolock) WHERE (InstantKB_Articles.TabID = @intTabID AND (ArticleReviewDate <= GetDate())))
	SET @intAssignedToMe = (SELECT COUNT(ArticleID) FROM InstantKB_Articles WITH (nolock) WHERE (InstantKB_Articles.TabID = @intTabID AND (ArticleAssignedUserID = @intUserID)))

END

SELECT
@intTotalCategories As TotalCategories,
@intTotalLiveArticles As TotalLiveArticles, 
@intTotalPrivateArticles As TotalPrivateArticles,
@intTotalLiveComments As TotalLiveComments,
@intTotalPrivateomments As TotalPrivateComments,
@intOverdueArticles As OverdueArticles,
@intExpiredArticles As ExpiredArticles,
@intDueForReview As DueForReview,
@intAssignedToMe As AssignedToMe

GO 

---------------------------------------------

GO

ALTER PROCEDURE [ikb_sp_InsertUpdateSLA] (
@intSLAID int,
@intSLATabID int,
@strSLAName nvarchar(255),
@strSLADesc nvarchar(500),
@bitEnabled bit,
@intSLAAvgResponseTime int,
@intSLAOverdueTime int,
@intSLAFilterDeptID int,
@strSLAFilterStatusIDs nvarchar(255),
@strSLAFilterPriorityIDs nvarchar(255),
@intSLASortOrder int,
@intIdentity int output
) AS

SET NOCOUNT ON 

-- is this an update or insert?
IF (@intSLAID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_SLAs
		(
		SLATabID,
		SLAName,
		SLADesc,
		SLAEnabled,
		SLAResponseTime,
		SLAOverdueTime,
		SLAFilterDeptID,
		SLAFilterStatusIDs,
		SLAFilterPriorityIDs,
		SLASortOrder
	) VALUES (		
		@intSLATabID,
		@strSLAName,
		@strSLADesc,
		@bitEnabled,
		@intSLAAvgResponseTime,
		@intSLAOverdueTime,
		@intSLAFilterDeptID,
		@strSLAFilterStatusIDs,
		@strSLAFilterPriorityIDs,
		@intSLASortOrder
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_SLAs SET
	SLATabID = @intSLATabID,
	SLAName = @strSLAName,
	SLADesc = @strSLADesc,
	SLAEnabled = @bitEnabled,
	SLAResponseTime = @intSLAAvgResponseTime,
	SLAOverdueTime = @intSLAOverdueTime,
	SLAFilterDeptID = @intSLAFilterDeptID,
	SLAFilterStatusIDs = @strSLAFilterStatusIDs,
	SLAFilterPriorityIDs = @strSLAFilterPriorityIDs
	WHERE InstantKB_SLAs.SLAID = @intSLAID

	-- return the identity
	SET @intIdentity = @intSLAID

END

RETURN

GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_InsertUpdateNotification] (
@intNotificationID int,
@intRelatedEntityID int,
@intUserID int,
@strNotificationEmailAddress nvarchar(255),
@strNotificationTemplate nvarchar(max),
@intNotificationType int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a notification within InstantKB_Notifications  */

-- is this an update or insert?
IF (@intNotificationID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Notifications (
		RelatedEntityID, 
		UserID, 
		NotificationEmailAddress, 
		NotificationTemplate,
		NotificationType, 
		DateStamp
	) VALUES (
		@intRelatedEntityID, 
		@intUserID, 
		@strNotificationEmailAddress, 
		@strNotificationTemplate,
		@intNotificationType, 
		GetDate()
	)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Notifications SET
	RelatedEntityID = @intRelatedEntityID,
	UserID = @intUserID,
	NotificationEmailAddress = @strNotificationEmailAddress,
	NotificationTemplate = @strNotificationTemplate,
	NotificationType = @intNotificationType,
	DateStamp = GetDate()
	WHERE InstantKB_Notifications.NotificationID = @intNotificationID

	-- return the identity
	SET @intIdentity = @intNotificationID
	RETURN

END

SET @intIdentity = 0
RETURN

GO 

---------------------------------------------

GO

ALTER PROCEDURE [ikb_sp_InsertUpdateWorkFlowStep] (
@intWorkFlowStepID int,
@intWorkFlowID int,
@strName nvarchar(255),
@strNotificationXML nvarchar(max),
@intSortOrder int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a workflow step within InstantKB_WorkFlowSteps table */

-- is this an update or insert?
IF (@intWorkFlowStepID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_WorkFlowSteps (
		WorkFlowID, 
		[Name], 
		NotificationXML,
		SortOrder
	) VALUES (
		@intWorkFlowID, 
		@strName, 
		@strNotificationXML,
		@intSortOrder
	)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_WorkFlowSteps SET
	[Name] = @strName,
	NotificationXML = @strNotificationXML
	WHERE InstantKB_WorkFlowSteps.WorkFlowStepID = @intWorkFlowStepID

	-- return the identity
	SET @intIdentity = @intWorkFlowStepID
	RETURN

END

SET @intIdentity = 0
RETURN

GO 

---------------------------------------------

GO

ALTER PROCEDURE [ikb_sp_SelectStaff] 
AS

SET NOCOUNT ON 

DECLARE @intStaffRoleID int

-- select staff members from InstantASP_Users
SELECT 
	InstantASP_Users.UserID, 
	InstantASP_Users.Username,
	InstantKB_Users.IsOnCall
FROM
	 InstantKB_Users 
	INNER JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID
WHERE EXISTS (
	SELECT 
		RoleID 
	FROM 
		InstantASP_UsersRoles 
	WHERE  
		InstantASP_UsersRoles.UserID =  InstantASP_Users.UserID AND 
		InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles WHERE ModeratorRole = 1)
	)


GO 

---------------------------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectOnlineStaff] 
AS

SET NOCOUNT ON 

DECLARE @intStaffRoleID int

-- select staff members from InstantASP_Users who are online

SELECT 
	InstantASP_Users.UserID, 
	InstantASP_Users.Username,
	InstantKB_Users.IsOnCall
FROM
	 InstantKB_Users 
	INNER JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID
WHERE  EXISTS (
		SELECT 
			RoleID 
		FROM 
			InstantASP_UsersRoles 
		WHERE  
			InstantASP_UsersRoles.UserID =  InstantASP_Users.UserID AND 
			InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles WHERE ModeratorRole = 1)
	) AND 
	( InstantASP_Users.UserID IN (
		SELECT UserID FROM InstantKB_WhosOn
	))

GO 

---------------------------------------------

GO

CREATE PROCEDURE [ikb_sp_DeleteWhosOnByUserID] (
@intUserID int
)
AS
SET NOCOUNT ON 
/* Removes WhosOn data by user ID */
DELETE FROM InstantKB_WhosOn WHERE (UserID = @intUserID) 
RETURN

GO 

---------------------------------------------

GO


CREATE PROCEDURE [ikb_sp_DeleteTicketNote] (
@intTicketNoteID int
) AS
SET NOCOUNT ON 

/* Deletes a ticket note from InstantKB_TicketNotes table */

DELETE FROM InstantKB_TicketNotes WHERE (
InstantKB_TicketNotes.TicketNoteID = @intTicketNoteID)

GO 

---------------------------------------------

GO


CREATE PROCEDURE [ikb_sp_DeleteStandardReply] (
@intReplyID int
) AS
SET NOCOUNT ON 

/* Deletes a standard / canned reply from InstantKB_StandardReplies */

DELETE FROM InstantKB_StandardReplies WHERE (
InstantKB_StandardReplies.ReplyID = @intReplyID)

GO 

---------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_DeleteTab] (
@intTabID int,
@intMoveToTabID int,
@intApplicationID int
) AS
SET NOCOUNT ON 

/* Deletes a tab from the InstantKB_Tabs table */
DELETE FROM InstantKB_Tabs WHERE (InstantKB_Tabs.TabID = @intTabID)

/* Delete tab roles from InstantKB_TabRoles */
DELETE FROM InstantKB_TabRoles WHERE (InstantKB_TabRoles.TabID = @intTabID)

/* Delete fields for tab */
DELETE FROM InstantASP_Fields WHERE (InstantASP_Fields.ApplicationID = @intApplicationID AND InstantASP_Fields.TabID = @intTabID)

/* Delete field templates for tab */
DELETE FROM InstantASP_FieldTemplates WHERE (InstantASP_FieldTemplates.ApplicationID = @intApplicationID AND InstantASP_FieldTemplates.TabID = @intTabID)

/* Delete any categories belonging to this tab */
DELETE FROM InstantKB_Categories WHERE (TabID = @intTabID)

/* Clean tab;es */
DELETE FROM InstantKB_DataViews WHERE TabID = @intTabID
DELETE FROM InstantKB_PermissionSetsTabs WHERE TabID = @intTabID
DELETE FROM InstantKB_StaffPermissionSetsTabs WHERE TabID = @intTabID
DELETE FROM InstantKB_Levels WHERE LevelTabID = @intTabID
DELETE FROM InstantKB_Priorities WHERE PriorityTabID = @intTabID
DELETE FROM InstantKB_Status WHERE StatusTabID = @intTabID
DELETE FROM InstantKB_Types WHERE TypeTabID = @intTabID
DELETE FROM InstantKB_WorkFlows WHERE TabID = @intTabID

/* Do we have a new tab for content within the deleted tab */
IF (@intMoveToTabID > 0)
BEGIN

	-- ensure we are moving to a different tab
	IF (@intTabID <> @intMoveToTabID)
	BEGIN
		-- move content within tab to new tab
		EXEC ikb_sp_MoveArticlesBetweenTabs @intTabID, @intMoveToTabID
	END

END
ELSE
BEGIN

	-- we don't have a tab to move to simply delete all content
	DELETE FROM InstantKB_Articles WHERE (TabID = @intTabID)
	DELETE FROM InstantKB_Tickets WHERE (TicketTabID = @intTabID)

END


RETURN

GO 

---------------------------------------------

GO

