-- InstantKB 2014 to 2014-1

ALTER TABLE InstantKB_ArticleRelatedLinks ADD RelatedArticleID  		int DEFAULT(0) NOT NULL;

GO

----------------------------

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


ALTER PROCEDURE [iasp_sp_SelectQueuedEmails] (
@intResultLimit int
)
AS
SET NOCOUNT ON 
/* Returns emails within current queue ordered by priority */
DECLARE @strSQL nvarchar(500)
SELECT @strSQL = 'SELECT TOP ' + CAST(@intResultLimit as nvarchar(25)) + ' * FROM InstantASP_Emails (nolock) ORDER BY EmailID ASC, EmailPriority ASC'
EXECUTE sp_executesql @strSQL

GO

----------------------------

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_InsertUpdateArticleRelatedLink] (
@intArticleRelatedLinkID int,
@intArticleID int,
@intRelatedArticleID int,
@strRedirectURL nvarchar(255),
@strDescription nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a article related link within InstantKB_ArticleRelatedLinks table */

-- is this an update or insert?
IF (@intArticleRelatedLinkID = 0)
BEGIN

	-- are we relating an article
	IF (@intRelatedArticleID > 0)
	BEGIN
		-- ensure related article does not already exist
		IF (NOT EXISTS(SELECT ArticleID FROM InstantKB_ArticleRelatedLinks WHERE (ArticleID = @intArticleID AND RelatedArticleID = @intRelatedArticleID))) 
		BEGIN

			-- insert 
			INSERT INTO InstantKB_ArticleRelatedLinks (ArticleID,RelatedArticleID, RedirectURL, ViewCount, [Description]) 
			VALUES (@intArticleID, @intRelatedArticleID, @strRedirectURL, 0, @strDescription)

			-- increment related link count in articles table
			UPDATE InstantKB_Articles SET RelatedLinkCount = 
			RelatedLinkCount + 1 WHERE (ArticleID = @intArticleID)
		
			-- return the  new identity
			SET @intIdentity = @@IDENTITY

		END
	END
	ELSE
	BEGIN

		-- insert 
		INSERT INTO InstantKB_ArticleRelatedLinks (ArticleID,RelatedArticleID, RedirectURL, ViewCount, [Description]) 
		VALUES (@intArticleID, @intRelatedArticleID, @strRedirectURL, 0, @strDescription)

		-- increment related link count in articles table
		UPDATE InstantKB_Articles SET RelatedLinkCount = 
		RelatedLinkCount + 1 WHERE (ArticleID = @intArticleID)
		
		-- return the  new identity
		SET @intIdentity = @@IDENTITY

	END
		
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_ArticleRelatedLinks SET
	ArticleID = @intArticleID,
	RelatedArticleID = @intRelatedArticleID,
	RedirectURL = @strRedirectURL,
	[Description] = @strDescription
	WHERE InstantKB_ArticleRelatedLinks.ArticleRelatedLinkID = @intArticleRelatedLinkID

	-- return the identity
	SET @intIdentity = @intArticleRelatedLinkID
	RETURN

END

SET @intIdentity = 0
RETURN

GO

----------------------------

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


ALTER PROCEDURE [ikb_sp_SelectArticleRelatedLinks] (
@intArticleID int,
@intUserID int
) AS
SET NOCOUNT ON

 /* Selects all related articles for a specific article from InstantKB_ArticleRelatedLinks */

DECLARE @SQL nvarchar(2000)
SELECT @SQL = 'SELECT InstantKB_ArticleRelatedLinks.*, 
InstantKB_Articles.TabID, 
InstantKB_Articles.ArticleTitle, 
InstantKB_Articles.ArticleTitleEncoded,
InstantKB_Articles.ArticleAccessType
FROM InstantKB_ArticleRelatedLinks 
LEFT OUTER JOIN
InstantKB_Articles ON InstantKB_ArticleRelatedLinks.RelatedArticleID = InstantKB_Articles.ArticleID';

SELECT @SQL = @SQL + ' WHERE (InstantKB_ArticleRelatedLinks.ArticleID = ' + CAST(@intArticleID As nVarChar(20)) + ' AND InstantKB_ArticleRelatedLinks.RelatedArticleID > 0)';

-- should we enable the role check
IF (@intUserID >= 0)
BEGIN

	-- tab role checks
	SELECT @SQL = @SQL + ' AND EXISTS (SELECT InstantKB_TabRoles.RoleID FROM InstantKB_TabRoles WHERE InstantKB_TabRoles.TabID = InstantKB_Articles.TabID AND InstantKB_TabRoles.RoleID IN '
	-- filter related links based on roles
	IF (@intUserID = 0) -- anonymous users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.AnonymousRole = 1)'
	END
	ELSE IF (@intUserID > 0) -- authenticated users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN
		InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantASP_UsersRoles.UserID = ' + CAST(@intUserID As nVarChar(20)) + '))'
	END	
	SELECT @SQL = @SQL + ') '

	-- article role checks
	SELECT @SQL = @SQL + ' AND EXISTS (SELECT InstantKB_ArticleRoles.RoleID FROM InstantKB_ArticleRoles WHERE InstantKB_ArticleRoles.ArticleID = InstantKB_Articles.ArticleID AND InstantKB_ArticleRoles.RoleID IN '
	-- filter related links based on roles
	IF (@intUserID = 0) -- anonymous users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.AnonymousRole = 1)'
	END
	ELSE IF (@intUserID > 0) -- authenticated users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN
		InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantASP_UsersRoles.UserID = ' + CAST(@intUserID As nVarChar(20)) + '))'
	END	
	SELECT @SQL = @SQL + ') '

END

SELECT @SQL = @SQL + ' ORDER BY InstantKB_ArticleRelatedLinks.ArticleRelatedLinkID ASC'

-- ensure we use sp_executesql to cache execution plan for dynamic query
EXECUTE sp_executesql @SQL

/* Selects all related external links for a specific article from InstantKB_ArticleRelatedLinks */

SELECT InstantKB_ArticleRelatedLinks.*, 
0 AS TabID, '' AS ArticleTitle, '' AS ArticleTitleEncoded, 1 As ArticleAccessType
FROM InstantKB_ArticleRelatedLinks 
WHERE
(	
	InstantKB_ArticleRelatedLinks.ArticleID = @intArticleID AND
	InstantKB_ArticleRelatedLinks.RelatedArticleID = 0
 )
 

GO

----------------------------

GO

CREATE PROCEDURE [ikb_sp_DeleteArticleRelatedLink] (
@intArticleRelatedLinkID int
) AS
SET NOCOUNT ON 

/* Deletes a single related link from InstantKB_ArticleRelatedLinks */

DECLARE @intArticleID int;
SET @intArticleID = (
	SELECT ArticleID FROM InstantKB_ArticleRelatedLinks 
	WHERE (InstantKB_ArticleRelatedLinks.ArticleRelatedLinkID = @intArticleRelatedLinkID)
)

DELETE FROM InstantKB_ArticleRelatedLinks 
WHERE (InstantKB_ArticleRelatedLinks.ArticleRelatedLinkID = @intArticleRelatedLinkID)

-- update related link count in articles tabl
UPDATE InstantKB_Articles SET 
InstantKB_Articles.RelatedLinkCount = (
	SELECT COUNT(ArticleID) FROM InstantKB_ArticleRelatedLinks 
	WHERE (InstantKB_ArticleRelatedLinks.ArticleID = @intArticleID)
)
WHERE (InstantKB_Articles.ArticleID = @intArticleID)

RETURN

GO

----------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectArticleLinkBacks] (
@intArticleID int,
@intUserID int
) AS
SET NOCOUNT ON

 /* Selects all related articles for a specific article from InstantKB_ArticleRelatedLinks */

DECLARE @SQL nvarchar(2000)
SELECT @SQL = 'SELECT InstantKB_ArticleRelatedLinks.*, 
InstantKB_Articles.TabID, 
InstantKB_Articles.ArticleTitle, 
InstantKB_Articles.ArticleTitleEncoded,
InstantKB_Articles.ArticleAccessType
FROM InstantKB_ArticleRelatedLinks 
INNER JOIN InstantKB_Articles ON 
InstantKB_ArticleRelatedLinks.ArticleID = InstantKB_Articles.ArticleID
WHERE (InstantKB_ArticleRelatedLinks.RelatedArticleID = ' + CAST(@intArticleID As nVarChar(20)) + ')';

-- should we enable the role check
IF (@intUserID >= 0)
BEGIN

	-- tab role checks
	SELECT @SQL = @SQL + ' AND EXISTS (SELECT InstantKB_TabRoles.RoleID FROM InstantKB_TabRoles WHERE InstantKB_TabRoles.TabID = InstantKB_Articles.TabID AND InstantKB_TabRoles.RoleID IN '
	-- filter related links based on roles
	IF (@intUserID = 0) -- anonymous users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.AnonymousRole = 1)'
	END
	ELSE IF (@intUserID > 0) -- authenticated users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN
		InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantASP_UsersRoles.UserID = ' + CAST(@intUserID As nVarChar(20)) + '))'
	END	
	SELECT @SQL = @SQL + ') '

	-- article role checks
	SELECT @SQL = @SQL + ' AND EXISTS (SELECT InstantKB_ArticleRoles.RoleID FROM InstantKB_ArticleRoles WHERE InstantKB_ArticleRoles.ArticleID = InstantKB_Articles.ArticleID AND InstantKB_ArticleRoles.RoleID IN '
	-- filter related links based on roles
	IF (@intUserID = 0) -- anonymous users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.AnonymousRole = 1)'
	END
	ELSE IF (@intUserID > 0) -- authenticated users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN
		InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantASP_UsersRoles.UserID = ' + CAST(@intUserID As nVarChar(20)) + '))'
	END	
	SELECT @SQL = @SQL + ') '

END

SELECT @SQL = @SQL + ' ORDER BY InstantKB_ArticleRelatedLinks.ArticleRelatedLinkID ASC'

-- ensure we use sp_executesql to cache execution plan for dynamic query
EXECUTE sp_executesql @SQL

GO

---------------------------------

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [iasp_sp_DeleteTagByTagID] (
@intTagID int
) AS
SET NOCOUNT ON 

/* Deletes a single tag from the InstantASP_Tags table */

DELETE FROM InstantASP_Tags WHERE (InstantASP_Tags.TagID = @intTagID)

RETURN

GO

-----------------------------

GO

ALTER PROCEDURE [ikb_sp_InsertUpdateTicket] (
@intTicketID int,
@intTicketTabID int,
@intTicketSLAID int,
@intTicketToUserID int,
@strTicketToEmail nvarchar(255),
@strTicketTitle nvarchar(255),
@strTicketText ntext,
@intTicketStatusID int,
@intTicketPriorityID int,
@intTicketTypeID int,
@intTicketDeptID int,
@intTicketCategoryID int,
@intTicketWorkflowStepID int,
@intTicketCreatedUserID int,
@strTicketCreatedUsername nvarchar(255),
@strTicketCreatedEmailAddress nvarchar(255),
@intTicketModifiedUserID int,
@intTicketAssignedUserID int,
@strTicketAttachment1 nvarchar(255),
@strTicketAttachment2 nvarchar(255),
@intTicketTimeWorked int,
@intTicketPercentComplete int,
@strTicketImage nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a article within the InstantKB_Articles table */

DECLARE @bolIsStaffReply bit
SET @bolIsStaffReply = 0
	
DECLARE @strCreatedEmail nvarchar(255)
DECLARE @strModifiedUsername nvarchar(255)
DECLARE @strCreatedUsername nvarchar(255)
DECLARE @strAssignedUsername nvarchar(255)

if (@intTicketCreatedUserID > 0) 
BEGIN
	SET @strCreatedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketCreatedUserID))
	SET @strCreatedEmail = (SELECT EmailAddress FROM InstantASP_Users WHERE (UserID = @intTicketCreatedUserID))
	-- check if staff
	IF EXISTS(SELECT InstantASP_Users.UserID, InstantASP_UsersRoles.RoleID   FROM InstantASP_Users 
	INNER JOIN InstantASP_UsersRoles ON InstantASP_Users.UserID = InstantASP_UsersRoles.UserID 
	WHERE InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles 
	WHERE InstantASP_Roles.AdministratorRole  = 1 or InstantASP_Roles.ModeratorRole = 1)
	AND InstantASP_Users.UserID = @intTicketCreatedUserID)
	BEGIN
		SET @bolIsStaffReply = 1
	END
END
ELSE
BEGIN
	SET @strCreatedUsername = @strTicketCreatedUsername
	SET @strCreatedEmail = @strTicketCreatedEmailAddress
END

IF (@intTicketAssignedUserID > 0)
BEGIN	
	SET @strAssignedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketAssignedUserID))
END
ELSE
BEGIN
	SET @strAssignedUsername = '';
END

IF (@intTicketModifiedUserID > 0)
BEGIN
	SET @strModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketModifiedUserID))
END
ELSE
BEGIN
	SET @strModifiedUsername = @strCreatedUsername;
END
		
-- is this an update or insert?
IF (@intTicketID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Tickets 
		(
		TicketTabID,
		TicketSLAID,
		TicketToUserID,
		TicketToEmail,
		TicketTitle, 
		TicketText,
		TicketStatusID, 
		TicketPriorityID, 
		TicketDeptID, 
		TicketTypeID, 
		TicketCategoryID,
		TicketWorkflowStepID, 
		TicketCreatedDate, 
		TicketCreatedUserID, 
		TicketCreatedUsername, 
		TicketCreatedEmail, 
		TicketModifiedUserID, 
		TicketModifiedUsername,
		TicketModifiedDate, 	
		TicketAttachment1,
		TicketAttachment2,
		TicketIsStaffReply,
		TicketTimeWorked,
		TicketPercentComplete,
		TicketImage
		)		
	VALUES 		(
		@intTicketTabID,
		@intTicketSLAID,
		@intTicketToUserID,
		@strTicketToEmail,
		@strTicketTitle,
		@strTicketText,
		@intTicketStatusID,
		@intTicketPriorityID,
		@intTicketDeptID,
		@intTicketTypeID,	
		@intTicketCategoryID,
		@intTicketWorkflowStepID,
		getdate(),
		@intTicketCreatedUserID,
		IsNull(@strCreatedUsername,''),
		@strCreatedEmail,
		@intTicketModifiedUserID,
		IsNull(@strModifiedUsername, ''),
		getdate(),
		@strTicketAttachment1,
		@strTicketAttachment2,
		@bolIsStaffReply,
		@intTicketTimeWorked,
		@intTicketPercentComplete,
		@strTicketImage
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Tickets SET
	TicketTitle = @strTicketTitle,
	TicketSLAID = @intTicketSLAID,
	TicketText = @strTicketText,
	TicketStatusID = @intTicketStatusID,
	TicketPriorityID = @intTicketPriorityID,
	TicketTypeID = 	@intTicketTypeID,
	TicketDeptID = @intTicketDeptID,
	TicketCategoryID = 	@intTicketCategoryID,
	TicketWorkflowStepID =	@intTicketWorkflowStepID,
	TicketModifiedUserID = @intTicketModifiedUserID,
	TicketModifiedDate = getdate(),
	TicketModifiedUsername = IsNull(@strModifiedUsername, ''),	
	TicketAttachment1 = @strTicketAttachment1,
	TicketAttachment2 = @strTicketAttachment2,
	TicketTimeWorked = @intTicketTimeWorked,
	TicketPercentComplete = @intTicketPercentComplete,
	TicketImage = @strTicketImage
	WHERE InstantKB_Tickets.TicketID = @intTicketID

	-- return the identity
	SET @intIdentity = @intTicketID

END

-- so we have an assigned user?
IF (@strAssignedUsername <> '') 
BEGIN
	-- ensure we only update if information has changed
	DECLARE @intCurrentAssignedUserID int
	SET @intCurrentAssignedUserID = (SELECT TicketAssignedUserID FROM InstantKB_Tickets WHERE InstantKB_Tickets.TicketID = @intIdentity)
	IF (@intCurrentAssignedUserID <> @intTicketAssignedUserID)
	BEGIN	
		UPDATE InstantKB_Tickets SET 
		TicketAssignedUserID = 	@intTicketAssignedUserID,
		TicketAssignedUsername = @strAssignedUsername,
		TicketAssignedDate = 	GETDATE()
		WHERE InstantKB_Tickets.TicketID = @intIdentity
	END
END
ELSE
BEGIN
		UPDATE InstantKB_Tickets SET 
		TicketAssignedUserID = 	0,
		TicketAssignedUsername = '',
		TicketAssignedDate = 	null
		WHERE InstantKB_Tickets.TicketID = @intIdentity
END
	
-- do we have an SLA?

if (@intTicketSLAID > 0) 
BEGIN
DECLARE @intOverdueHours int
	SET @intOverdueHours = (SELECT SLAOverdueTime FROM InstantKB_SLAs WHERE InstantKB_SLAs.SLAID = @intTicketSLAID)
	IF (@intOverdueHours > 0) 
	BEGIN
		UPDATE InstantKB_Tickets SET
		TicketDueDate =  DATEADD(hh,@intOverdueHours,getdate())
		WHERE InstantKB_Tickets.TicketID = @intIdentity

	END
	ELSE
	BEGIN
		UPDATE InstantKB_Tickets SET
		InstantKB_Tickets.TicketDueDate = NULL,
		InstantKB_Tickets.TicketIsEscalated = 0
		WHERE InstantKB_Tickets.TicketID = @intIdentity
	END
END
	
RETURN

GO

-----------------------------

GO


ALTER PROCEDURE [ikb_sp_DeleteArticle] (
@intArticleID int
) AS
SET NOCOUNT ON 

/* Delete an article from InstantKB_Articles */
DELETE FROM InstantKB_Articles WHERE (InstantKB_Articles.ArticleID = @intArticleID)

/* Delete any tags */
DELETE FROM InstantASP_Tags WHERE (RelatedEntityID = @intArticleID AND ApplicationID = 2)

/* Delete article attachments */
DELETE FROM InstantKB_Attachments WHERE (RelatedEntityID = @intArticleID AND AttachmentType = 1)

/* Delete article comments */
DELETE FROM InstantKB_ArticleComments WHERE (ArticleID = @intArticleID)

/* Delete article categories from InstantKB_ArticleCategories */
EXEC ikb_sp_DeleteArticleCategories @intArticleID

/* Delete article roles from InstantKB_ArticleRoles */
EXEC ikb_sp_DeleteArticleRoles @intArticleID

/* Delete related links */
EXEC ikb_sp_DeleteArticleRelatedLinks @intArticleID
DELETE FROM InstantKB_ArticleRelatedLinks WHERE (
	InstantKB_ArticleRelatedLinks.RelatedArticleID = @intArticleID
)

RETURN

GO