/* InstantKB 2015-1 to 2015-2 */


ALTER TABLE InstantKB_SLAs ADD SLAFilterUserListIDs  		nvarchar(255) DEFAULT('') NOT NULL;

GO

CREATE TABLE InstantKB_DepartmentWorkTimes
(
WorkTimeID							INT IDENTITY(1,1) NOT NULL,
DepartmentID						INT DEFAULT (0)  NOT NULL,
WorkTimeDay							TINYINT DEFAULT (1) NOT NULL,
WorkTimeStart                       varchar(50),
WorkTimeEnd							varchar(50),
CONSTRAINT PK_InstantKB_DepartmentWorkTimes_DepartmentWorkTimeID PRIMARY KEY CLUSTERED ( WorkTimeID )
)

GO

---------------------

GO

CREATE TABLE InstantKB_Holidays
(
HolidayID							INT IDENTITY(1,1) NOT NULL,
HolidayName							nvarchar(255) DEFAULT ('')  NOT NULL,				
HolidayDate							varchar(50),
CONSTRAINT PK_InstantKB_Holidays_HolidayID PRIMARY KEY CLUSTERED ( HolidayID )
)

GO

---------------------

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

/* change to create */

CREATE PROCEDURE [ikb_sp_SetTicketDueDate] (
@intTicketID int,
@intHours int
) AS

SET NOCOUNT ON 

/* calculate & set the due date for a ticket */
DECLARE @start_date datetime = getdate()
DECLARE @time_span int = 60 * @intHours -- time till due in minutes
DECLARE @due_date datetime --our output

DECLARE @intDeptID INT;
SET @intDeptID = (SELECT TicketDeptID FROM InstantKB_Tickets WHERE TicketID = @intTicketID);

-- no working hours just set due date in hours

IF NOT EXISTS((SELECT WorkTimeID FROM InstantKB_DepartmentWorkTimes WHERE (DepartmentID = @intDeptID))) 
BEGIN
	SET @due_date = DATEADD(hh, @intHours, @start_date);
	UPDATE InstantKB_Tickets SET
	TicketDueDate = @due_date
	WHERE InstantKB_Tickets.TicketID = @intTicketID;
	RETURN
END

-- calculate due date based on working hours

-- set first day of week to Monday
SET DATEFIRST 1

-- get current day of week
DECLARE @week_day INT;
SET @week_day = (DATEPART(dw,@start_date) - 1)

--other variables
DECLARE @true bit = 'true'
DECLARE @false bit = 'false'

DECLARE @date_string varchar(10)
DECLARE @today_closing datetime
DECLARE @is_workday bit = @true
DECLARE @is_holiday bit = @false

-- we dont care about seconds in start or due dates 
SET @start_date = DATEADD(ss,datepart(ss,@start_date)*-1,@start_date)

WHILE (@time_span > 0)
BEGIN

	SET @due_date       = DATEADD(MINUTE,@time_span,@start_date)
	SET @date_string    = FORMAT(DATEADD(dd, 0, DATEDIFF(dd, 0, @start_date)),'yyyy-MM-dd')
	SET @today_closing  = (SELECT convert(datetime,@date_string + ' ' + WorkTimeEnd) FROM InstantKB_DepartmentWorkTimes WHERE (DepartmentID = @intDeptID AND WorkTimeDay = DATEPART(dw, @start_date)))
	
	IF EXISTS((SELECT WorkTimeID FROM InstantKB_DepartmentWorkTimes WHERE (DepartmentID = @intDeptID AND WorkTimeDay = DATEPART(dw, @start_date)))) 
		SET @is_workday = @true 
	ELSE
		SET @is_workday = @false
		
	IF EXISTS(SELECT HolidayID FROM InstantKB_Holidays where HolidayDate = @date_string)
		SET @is_holiday = @true
	ELSE 
		SET @is_holiday = @false

	IF (@is_workday = @true AND @is_holiday = @false)
	BEGIN		
		IF @due_date > @today_closing 
			SET @time_span = @time_span - DATEDIFF(MINUTE, @start_date, @today_closing)
		ELSE 
			SET @time_span = @time_span - DATEDIFF(minute, @start_date, @due_date)
	END
	ELSE
	BEGIN
		IF @due_date <= @start_date 
			SET @due_date = @start_date

		IF @due_date <= @today_closing 
		BEGIN		
			SET @time_span = @time_span - DATEDIFF(minute, @start_date, @due_date)
		END	
	END

	SET @date_string = FORMAT(DATEADD(dd, 1, DATEDIFF(dd, 0, @start_date)),'yyyy-MM-dd')
	SET @start_date = CONVERT(datetime, @date_string + ' ' + isnull((SELECT WorkTimeStart FROM InstantKB_DepartmentWorkTimes WHERE (DepartmentID = @intDeptID AND WorkTimeDay = DATEPART(dw,convert(datetime,@date_string)) )),''))

END

UPDATE InstantKB_Tickets SET
TicketDueDate = @due_date
WHERE InstantKB_Tickets.TicketID = @intTicketID;

RETURN 

GO

---------------------

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER PROCEDURE [ikb_sp_InsertUpdateTicket] (
@intTicketID int,
@intTicketTabID int,
@intTicketSLAID int,
@intTicketToUserID int,
@intTicketRelatedUserID int,
@strTicketTitle nvarchar(255),
@strTicketText ntext,
@intTicketStatusID int,
@intTicketPriorityID int,
@intTicketTypeID int,
@intTicketDeptID int,
@intTicketCategoryID int,
@intTicketWorkflowStepID int,
@intTicketCreatedUserID int,
@strTicketCreatedUsername nvarchar(255),
@strTicketCreatedEmailAddress nvarchar(255),
@intTicketModifiedUserID int,
@intTicketAssignedUserID int,
@dtTicketDueDate datetime2,
@dtTicketClosedDate datetime2,
@strTicketAttachment1 nvarchar(255),
@strTicketAttachment2 nvarchar(255),
@intTicketTimeWorked int,
@intTicketPercentComplete int,
@strTicketImage nvarchar(255),
@intTicketChannel smallint,
@strTicketChannelMsgID nvarchar(255),
@strTicketChannelCatID nvarchar(255),
@strTicketChannelPageID nvarchar(255),
@intTicketChannelAccountID int,
@bitTicketIsSpam bit,
@bitTicketIsArchived bit,
@bitUpdateDueDateBasedOnSLA bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a article within the InstantKB_Articles table */

DECLARE @bolIsStaffReply bit
SET @bolIsStaffReply = 0
	
DECLARE @strCreatedEmail nvarchar(255)
DECLARE @strModifiedUsername nvarchar(255)
DECLARE @strCreatedUsername nvarchar(255)
DECLARE @strAssignedUsername nvarchar(255)

if (@intTicketCreatedUserID > 0) 
BEGIN
	SET @strCreatedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketCreatedUserID))
	SET @strCreatedEmail = (SELECT EmailAddress FROM InstantASP_Users WHERE (UserID = @intTicketCreatedUserID))
	-- check if staff
	IF EXISTS(SELECT InstantASP_Users.UserID, InstantASP_UsersRoles.RoleID   FROM InstantASP_Users 
	INNER JOIN InstantASP_UsersRoles ON InstantASP_Users.UserID = InstantASP_UsersRoles.UserID 
	WHERE InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles 
	WHERE InstantASP_Roles.AdministratorRole  = 1 or InstantASP_Roles.ModeratorRole = 1)
	AND InstantASP_Users.UserID = @intTicketCreatedUserID)
	BEGIN
		SET @bolIsStaffReply = 1
	END
END
ELSE
BEGIN
	SET @strCreatedUsername = @strTicketCreatedUsername
	SET @strCreatedEmail = @strTicketCreatedEmailAddress
END

IF (@intTicketAssignedUserID > 0)
BEGIN	
	SET @strAssignedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketAssignedUserID))
END
ELSE
BEGIN
	SET @strAssignedUsername = '';
END

IF (@intTicketModifiedUserID > 0)
BEGIN
	SET @strModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketModifiedUserID))
END
ELSE
BEGIN
	SET @strModifiedUsername = @strCreatedUsername;
END
		
-- is this an update or insert?
IF (@intTicketID = 0)
BEGIN

	-- ensure unique channel messages
	IF (@strTicketChannelMsgID != '')
	BEGIN
		IF (EXISTS(SELECT TicketID FROM InstantKB_Tickets WHERE TicketChannelMsgID = @strTicketChannelMsgID))
		BEGIN
			SET @intIdentity = 0;
			RETURN;
		END
	END

	-- insert 
	INSERT INTO InstantKB_Tickets 
		(
		TicketTabID,
		TicketSLAID,
		TicketToUserID,
		TicketRelatedUserID,
		TicketTitle, 
		TicketText,
		TicketStatusID, 
		TicketPriorityID, 
		TicketDeptID, 
		TicketTypeID, 
		TicketCategoryID,
		TicketWorkflowStepID, 
		TicketCreatedDate, 
		TicketCreatedUserID, 
		TicketCreatedUsername, 
		TicketCreatedEmail, 
		TicketModifiedUserID, 
		TicketModifiedUsername,
		TicketModifiedDate, 
		TicketDueDate,	
		TicketClosedDate,
		TicketAttachment1,
		TicketAttachment2,
		TicketIsStaffReply,
		TicketTimeWorked,
		TicketPercentComplete,
		TicketImage,
		TicketChannel,
		TicketChannelMsgID,
		TicketChannelCatID,
		TicketChannelPageID,
		TicketChannelAccountID,
		TicketIsSpam,
		TicketIsArchived
		)		
	VALUES 		(
		@intTicketTabID,
		@intTicketSLAID,
		@intTicketToUserID,
		@intTicketRelatedUserID,
		@strTicketTitle,
		@strTicketText,
		@intTicketStatusID,
		@intTicketPriorityID,
		@intTicketDeptID,
		@intTicketTypeID,	
		@intTicketCategoryID,
		@intTicketWorkflowStepID,
		getdate(),
		@intTicketCreatedUserID,
		IsNull(@strCreatedUsername,''),
		@strCreatedEmail,
		@intTicketModifiedUserID,
		IsNull(@strModifiedUsername, ''),
		getdate(),
		@dtTicketDueDate,
		@dtTicketClosedDate,
		@strTicketAttachment1,
		@strTicketAttachment2,
		@bolIsStaffReply,
		@intTicketTimeWorked,
		@intTicketPercentComplete,
		@strTicketImage,
		@intTicketChannel,
		@strTicketChannelMsgID,
		@strTicketChannelCatID,
		@strTicketChannelPageID,
		@intTicketChannelAccountID,
		@bitTicketIsSpam,
		@bitTicketIsArchived
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Tickets SET
	TicketTitle = @strTicketTitle,
	TicketSLAID = @intTicketSLAID,
	TicketText = @strTicketText,
	TicketStatusID = @intTicketStatusID,
	TicketPriorityID = @intTicketPriorityID,
	TicketTypeID = 	@intTicketTypeID,
	TicketDeptID = @intTicketDeptID,
	TicketCategoryID = 	@intTicketCategoryID,
	TicketWorkflowStepID =	@intTicketWorkflowStepID,
	TicketModifiedUserID = @intTicketModifiedUserID,
	TicketModifiedDate = getdate(),
	TicketDueDate = @dtTicketDueDate,
	TicketClosedDate = @dtTicketClosedDate,
	TicketModifiedUsername = IsNull(@strModifiedUsername, ''),	
	TicketAttachment1 = @strTicketAttachment1,
	TicketAttachment2 = @strTicketAttachment2,
	TicketTimeWorked = @intTicketTimeWorked,
	TicketPercentComplete = @intTicketPercentComplete,
	TicketImage = @strTicketImage,
	TicketChannel = @intTicketChannel,
	TicketChannelMsgID = @strTicketChannelMsgID,
	TicketChannelCatID = @strTicketChannelCatID,
	TicketChannelPageID = @strTicketChannelPageID,
	TicketChannelAccountID = @intTicketChannelAccountID,
	TicketIsSpam = @bitTicketIsSpam,
	TicketIsArchived = @bitTicketIsArchived
	WHERE InstantKB_Tickets.TicketID = @intTicketID

	-- return the identity
	SET @intIdentity = @intTicketID

END

-- do we have an assigned user?
IF (@strAssignedUsername <> '') 
BEGIN
	-- ensure we only update if information has changed
	DECLARE @intCurrentAssignedUserID int
	SET @intCurrentAssignedUserID = (SELECT TicketAssignedUserID FROM InstantKB_Tickets WHERE InstantKB_Tickets.TicketID = @intIdentity)
	IF (@intCurrentAssignedUserID <> @intTicketAssignedUserID)
	BEGIN	
		UPDATE InstantKB_Tickets SET 
		TicketAssignedUserID = 	@intTicketAssignedUserID,
		TicketAssignedUsername = @strAssignedUsername,
		TicketAssignedDate = 	GETDATE()
		WHERE InstantKB_Tickets.TicketID = @intIdentity
	END
END
ELSE
BEGIN
	UPDATE InstantKB_Tickets SET 
	TicketAssignedUserID = 	0,
	TicketAssignedUsername = '',
	TicketAssignedDate = 	null
	WHERE InstantKB_Tickets.TicketID = @intIdentity
END
	
-- determine if ticket is closed
DECLARE @bitIsClosed bit;
SET @bitIsClosed = 0;
IF (EXISTS(SELECT TicketID FROM InstantKB_Tickets WHERE TicketID = @intTicketID AND TicketClosedDate IS NOT NULL))
BEGIN
	SET @bitIsClosed = 1;
END

-- do we have an SLA?

IF(@bitUpdateDueDateBasedOnSLA = 1)
BEGIN

	IF (@intTicketSLAID > 0) 
	BEGIN
	
		DECLARE @intHours int
		SET @intHours = (SELECT SLAOverdueTime FROM InstantKB_SLAs WHERE InstantKB_SLAs.SLAID = @intTicketSLAID)

		-- set due date based on SLA if ticket is not closed, marked as spam or archived
		IF (@intHours > 0 AND 
			@bitTicketIsSpam = 0 AND 
			@bitTicketIsArchived = 0 AND
			@bitIsClosed = 0) 
		BEGIN
			EXEC ikb_sp_SetTicketDueDate @intIdentity, @intHours 	
		END
	
		-- reset due date & escalation flag if SLA has 0 hours
		IF (@intHours = 0)
		BEGIN
			UPDATE InstantKB_Tickets SET
			InstantKB_Tickets.TicketDueDate = NULL,
			InstantKB_Tickets.TicketIsEscalated = 0,
			InstantKB_Tickets.TicketOverdue = 0
			WHERE InstantKB_Tickets.TicketID = @intIdentity;
		END

	END
	ELSE
	BEGIN
		-- reset due date & escalation flag if no SLA
		UPDATE InstantKB_Tickets SET
		InstantKB_Tickets.TicketDueDate = NULL,
		InstantKB_Tickets.TicketIsEscalated = 0,
		InstantKB_Tickets.TicketOverdue = 0
		WHERE InstantKB_Tickets.TicketID = @intIdentity;
	ENd
END
	
IF (@bitIsClosed = 1)
BEGIN
	UPDATE InstantKB_Tickets SET
	InstantKB_Tickets.TicketDueDate = NULL,
	InstantKB_Tickets.TicketIsEscalated = 0,
	InstantKB_Tickets.TicketOverdue = 0
	WHERE InstantKB_Tickets.TicketID = @intIdentity;
END

RETURN

GO

----------------------------------

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER PROCEDURE [ikb_sp_SelectEmailHistoryByUniqueID] (
@strEmailUniqueID nvarchar(255)
) AS

SET NOCOUNT ON 

	SELECT TOP 1 * FROM InstantKB_EmailHistory
	WHERE InstantKB_EmailHistory.EmailUniqueID = @strEmailUniqueID;

RETURN 

GO

---------------------------

GO


SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER PROCEDURE [ikb_sp_InsertUpdateEmailHistory] (
@intEmailHistoryID int,
@strEmailUniqueID nvarchar(255),
@intEmailTabID int,
@bitEmailIsSpam bit,
@strEmailText nvarchar(max),
@dtEmailDate datetime2,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates email history information within InstantKB_EmailHistory */

-- is this an update or insert?
IF (@intEmailHistoryID = 0)
BEGIN

	IF (NOT EXISTS(SELECT EmailHistoryID FROM 
	InstantKB_EmailHistory WHERE EmailUniqueID = @strEmailUniqueID))
	BEGIN

		-- insert 
		INSERT INTO InstantKB_EmailHistory (
			EmailUniqueID,
			EmailTabID,
			EmailText,
			EmailIsSpam,
			EmailDate
		) VALUES (
			@strEmailUniqueID,
			@intEmailTabID,
			@strEmailText,
			@bitEmailIsSpam,
			@dtEmailDate
		)

		-- return the  new identity
		SET @intIdentity = @@IDENTITY
		RETURN

	END

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_EmailHistory SET
	EmailUniqueID = @strEmailUniqueID,
	EmailTabID = @intEmailTabID,	
	EmailText = @strEmailText,
	EmailIsSpam = @bitEmailIsSpam,
	EmailDate = @dtEmailDate
	WHERE InstantKB_EmailHistory.EmailHistoryID = @intEmailHistoryID

	-- return the identity
	SET @intIdentity = @intEmailHistoryID
	RETURN

END

SET @intIdentity = 0
RETURN

GO

---------------------------

GO

ALTER PROCEDURE [ikb_sp_InsertUpdateSLA] (
@intSLAID int,
@intSLATabID int,
@strSLAName nvarchar(255),
@strSLADesc nvarchar(500),
@bitEnabled bit,
@intSLAAvgResponseTime int,
@intSLAOverdueTime int,
@intSLAFilterDeptID int,
@strSLAFilterUserListIDs nvarchar(255),
@strSLAFilterStatusIDs nvarchar(255),
@strSLAFilterPriorityIDs nvarchar(255),
@intSLASortOrder int,
@intIdentity int output
) AS

SET NOCOUNT ON 

-- is this an update or insert?
IF (@intSLAID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_SLAs
		(
		SLATabID,
		SLAName,
		SLADesc,
		SLAEnabled,
		SLAResponseTime,
		SLAOverdueTime,
		SLAFilterDeptID,
		SLAFilterUserListIDs,
		SLAFilterStatusIDs,
		SLAFilterPriorityIDs,
		SLASortOrder

		)		
	VALUES 		(		
		@intSLATabID,
		@strSLAName,
		@strSLADesc,
		@bitEnabled,
		@intSLAAvgResponseTime,
		@intSLAOverdueTime,
		@intSLAFilterDeptID,
		@strSLAFilterUserListIDs,
		@strSLAFilterStatusIDs,
		@strSLAFilterPriorityIDs,
		@intSLASortOrder
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_SLAs SET
	SLATabID = @intSLATabID,
	SLAName = @strSLAName,
	SLADesc = @strSLADesc,
	SLAEnabled = @bitEnabled,
	SLAResponseTime = @intSLAAvgResponseTime,
	SLAOverdueTime = @intSLAOverdueTime,
	SLAFilterDeptID = @intSLAFilterDeptID,
	SLAFilterUserListIDs = @strSLAFilterUserListIDs,
	SLAFilterStatusIDs = @strSLAFilterStatusIDs,
	SLAFilterPriorityIDs = @strSLAFilterPriorityIDs
	WHERE InstantKB_SLAs.SLAID = @intSLAID

	-- return the identity
	SET @intIdentity = @intSLAID

END

RETURN

GO

-------------------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectDepartmentWorkTimes] (
@intDepartmentID int
) AS

SET NOCOUNT ON 

	SELECT * FROM InstantKB_DepartmentWorkTimes
	WHERE InstantKB_DepartmentWorkTimes.DepartmentID = @intDepartmentID;

RETURN 

GO

-------------------------------

GO

CREATE PROCEDURE [ikb_sp_InsertUpdateDepartmentWorkTime] (
@intWorkTimeID int,
@intDepartmentID int,
@intWorkTimeDay tinyint,
@dtWorkTimeStart varchar(50),
@dtWorkTimeEnd varchar(50),
@intIdentity int output
) AS

SET NOCOUNT ON 

-- is this an update or insert?
IF (@intWorktimeID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_DepartmentWorkTimes
		(
		DepartmentID,
		WorkTimeDay,
		WorkTimeStart,
		WorkTimeEnd
		)		
	VALUES 		(		
		@intDepartmentID,
		@intWorkTimeDay,
		@dtWorkTimeStart,
		@dtWorkTimeEnd	
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_DepartmentWorkTimes SET
	DepartmentID = @intDepartmentID,
	WorkTimeDay = @intWorkTimeDay,
	WorkTimeStart = @dtWorkTimeStart,
	WorkTimeEnd = @dtWorkTimeEnd
	WHERE InstantKB_DepartmentWorkTimes.WorkTimeID = @intWorkTimeID

	-- return the identity
	SET @intIdentity = @intWorkTimeID

END

RETURN

GO

------------------------------

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_DeleteDepartmentWorkTimes] (
@intDepartmentID int
)
AS
SET NOCOUNT ON 

/* Deletes all work times for a department from the InstantKB_DepartmentWorkTimes table */

DELETE FROM InstantKB_DepartmentWorkTimes WHERE (
	InstantKB_DepartmentWorkTimes.DepartmentID = @intDepartmentID
)

RETURN

GO

----------------------------------

GO

CREATE PROCEDURE [if_sp_SelectTopicRead] (
@intTopicID int,
@intUserID int
)
AS

SET NOCOUNT ON 

/* Returns information about a single read topic */

SELECT tr.ReadTopicID, tr.ReadDate 
	FROM InstantForum_TopicsRead tr WITH (nolock) WHERE (
		ReadUserID = @intUserID AND	ReadTopicID = @intTopicID
	)
ORDER BY tr.ReadTopicID DESC

GO

------------------------------------

GO


CREATE PROCEDURE [if_sp_SelectLastUnreadPostID] (
@intTopicID int,
@intUserID int,
@intOutput int output
)
AS

SET NOCOUNT ON 

/* Returns information about a single read topic */

DECLARE @dtReadDate DateTime;
SET @dtReadDate = (
	SELECT TOP 1 tr.ReadDate 
		FROM InstantForum_TopicsRead tr WITH (nolock) WHERE (
			ReadUserID = @intUserID AND	ReadTopicID = @intTopicID
		) ORDER BY tr.ReadTopicID DESC
)

SET @intOutput = (
	SELECT TOP 1 PostID FROM InstantForum_Topics WHERE
	(
		TopicID = @intTopicID AND DateStamp >= @dtReadDate
	) ORDER BY DateStamp ASC
)

IF (IsNull(@intOutput,0) = 0) 
BEGIN
	SET @intOutput = (
		SELECT LastPosterPostID FROM InstantForum_Topics 
		WHERE PostID = @intTopicID
		)
END

GO
