-- InstantKB 2015-2 to 2016

GO

ALTER TABLE InstantASP_Users ALTER COLUMN [Password] nvarchar(255) NOT NULL

GO

ALTER TABLE InstantASP_Users ALTER COLUMN DateTimeFormat nvarchar(50) NOT NULL

GO

-----------------------

GO

IF NOT EXISTS(SELECT * FROM sys.columns 
            WHERE Name = N'UserIconID' AND Object_ID = Object_ID(N'InstantASP_Users'))
BEGIN
	ALTER TABLE InstantASP_Users ADD UserIconID   INT DEFAULT(0) NOT NULL;
END

GO
-------------------------

GO

IF NOT EXISTS(SELECT * FROM sys.columns 
            WHERE Name = N'CategoryForeColor' AND Object_ID = Object_ID(N'InstantKB_Categories'))
BEGIN
	ALTER TABLE InstantKB_Categories ADD CategoryForeColor   nvarchar(15) DEFAULT('') NOT NULL;
END

GO
-------------------------

GO

IF NOT EXISTS(SELECT * FROM sys.columns 
            WHERE Name = N'CategoryBackColor' AND Object_ID = Object_ID(N'InstantKB_Categories'))
BEGIN
	ALTER TABLE InstantKB_Categories ADD CategoryBackColor   nvarchar(15) DEFAULT('') NOT NULL;
END

GO

-------------------------

GO

IF NOT EXISTS(SELECT * FROM sys.columns 
            WHERE Name = N'ArticleVersion' AND Object_ID = Object_ID(N'InstantKB_Articles'))
BEGIN
	ALTER TABLE InstantKB_Articles ADD ArticleVersion   float DEFAULT(0) NOT NULL;
END

GO

-------------------------

GO

CREATE TABLE InstantKB_ArticleVersions
(
ArticleVersionID                    INT IDENTITY(1,1) NOT NULL,
ArticleID                           INT DEFAULT (0) NOT NULL,
UserID                              INT DEFAULT (0) NOT NULL,
ArticleTitle                        NVARCHAR(500) DEFAULT ('') NOT NULL,
ArticleText                         NVARCHAR(max) DEFAULT ('') NOT NULL,
ArticleWorkFlowStepID               INT DEFAULT (0) NOT NULL,
ArticleMajorVersion                 INT DEFAULT (0) NOT NULL,
ArticleMinorVersion                 TINYINT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantKB_ArticleVersions_ArticleVersionID PRIMARY KEY CLUSTERED (ArticleVersionID )
)

GO

----------------------------

GO

ALTER PROCEDURE [iasp_sp_InsertUpdateUser] (
@intUserID int,
@intPrimaryRoleID int,
@strUsername nvarchar(155),
@strUsernameEncoded nvarchar(155),
@strEmailAddress nvarchar(155),
@strPassword nvarchar(255),
@intPasswordSalt int,
@strCulture nvarchar(10),
@dbTimeZoneOffSet float,
@bolObserveDST bit,
@strDateTimeFormat nvarchar(50),
@intFirstDayOfWeek tinyint,
@strFirstName nvarchar(155),
@strLastName nvarchar(155),
@intGender smallint,
@strCompanyName nvarchar(155),
@strJobTitle nvarchar(155),
@strSkills nvarchar(155),
@strPublicEmail nvarchar(155),
@strPhone  nvarchar(100),
@strWebAddress nvarchar(255),
@strBlogAddress nvarchar(255),
@strOpenID nvarchar(255),
@strPhotoImage nvarchar(200),
@strBannerImage nvarchar(200),
@strMSN nvarchar(155),
@strSkype nvarchar(155),
@strAIM nvarchar(155),
@strYIM nvarchar(155),
@strICQ nvarchar (155),
@strSnapChat nvarchar (155),
@strWhatsApp nvarchar (155),
@strTwitter nvarchar (75),
@strFacebook nvarchar (75),
@strGooglePlus nvarchar (100),
@strLinkedIn nvarchar (75),
@strMySpace nvarchar(100),
@strYouTube nvarchar(100),
@strLocation nvarchar(155),
@intDOBDay tinyint,
@intDOBMonth tinyint,
@intDOBYear int,
@bitShowAge bit,
@strUserLevelTitle nvarchar(100),
@strUserLevelImageURL nvarchar(100),
@strIPAddress nvarchar(20),
@strLdapUsername nvarchar(255),
@strConfirmationCode nvarchar(50),
@intRecognitionPoints int,
@strAPIKey nvarchar(255),
@intUserIconID int,
@bitEnsureUniqueAccount bit,
@intIdentity int output
) 
AS

SET NOCOUNT ON 

/* Inserts or updates a user within InstantASP_Users */

-- is this an update or insert?
IF (@intUserID = 0)
BEGIN

	/* Ensure the username is not already present within the table */
	IF (@strUsername <> '' AND @bitEnsureUniqueAccount = 1)
	BEGIN
		IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE InstantASP_Users.Username = @strUsername OR InstantASP_Users.UsernameEncoded = @strUsernameEncoded)
		BEGIN 
			SET @intIdentity = -1
			RETURN
		END
	END
	
	/* Ensure the email address is not already present within the table */
	IF (@strEmailAddress <> '' AND @bitEnsureUniqueAccount = 1)
	BEGIN
		IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE InstantASP_Users.EmailAddress = @strEmailAddress)
		BEGIN 
			SET @intIdentity = -2
			RETURN
		END
	END

	-- insert user
	INSERT INTO InstantASP_Users (
	PrimaryRoleID, 
	Username, 
	UsernameEncoded,
	EmailAddress, 
	[Password], 
	PasswordSalt,
	Culture, 
	TimeZoneOffset, 
	ObserveDaylightSavingTime, 
	DateTimeFormat, 
	FirstDayOfWeek, 
	FirstName, 
	LastName, 
	Gender,
	CompanyName, 
	JobTitle, 
	Skills,
	PublicEmail, 
	Phone,
	WebAddress, 
	BlogAddress, 
	OpenID,
	PhotoImage, 
	BannerImage,	
	MSN, 
	Skype, 
	YIM, 
	AIM, 
	ICQ, 
	SnapChat,
	WhatsApp,
	Twitter, 
	Facebook, 
	GooglePlus,
	LinkedIn, 
	MySpace,
	YouTube,
	Location, 
	DOBDay, 
	DOBMonth, 
	DOBYear, 
	ShowAge,
	UserLevelTitle, 
	UserLevelImageURL, 
	IPAddress, 
	LdapUsername,
	ConfirmationCode,
	RecognitionPoints,
	TotalVisits,
	UserIconID,
	APIKey
	) 
	VALUES
	(
	@intPrimaryRoleID, 
	@strUsername, 
	@strUsernameEncoded,
	@strEmailAddress, 
	@strPassword, 
	@intPasswordSalt,
	@strCulture, 
	@dbTimeZoneOffSet, 
	@bolObserveDST, 
	@strDateTimeFormat, 
	@intFirstDayOfWeek, 
	@strFirstName, 
	@strLastName, 
	@intGender,
	@strCompanyName, 
	@strJobTitle, 
	@strSkills,
	@strPublicEmail, 
	@strPhone,
	@strWebAddress, 
	@strBlogAddress, 
	@strOpenID, 
	@strPhotoImage, 
	@strBannerImage,
	@strMSN, 
	@strSkype, 
	@strYIM, 
	@strAIM, 
	@strICQ, 
	@strSnapChat,
	@strWhatsApp,
	@strTwitter, 
	@strFacebook, 
	@strGooglePlus,
	@strLinkedIn, 
	@strMySpace, 
	@strYouTube, 
	@strLocation, 
	@intDOBDay, 
	@intDOBMonth, 
	@intDOBYear, 
	@bitShowAge,
	@strUserLevelTitle, 
	@strUserLevelImageURL, 
	@strIPAddress, 
	@strLdapUsername, 
	@strConfirmationCode,
	@intRecognitionPoints, 
	0,
	@intUserIconID,
	@strAPIKey)

	-- set output parameter
	SET @intIdentity = @@IDENTITY
	
	
END
ELSE -- we are updating an existing record
BEGIN

	IF (@strUsername <> ''  AND @bitEnsureUniqueAccount = 1)
	BEGIN
		IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE Username = @strUsername AND UserID <> @intUserID)
		BEGIN
			SET @intIdentity = - 1
			RETURN
		END 
	END

	-- Check to see if email address already exists for any other user
	IF (@strEmailAddress <> ''  AND @bitEnsureUniqueAccount = 1)
	BEGIN
		IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE EmailAddress = @strEmailAddress AND UserID <> @intUserID)
		BEGIN
			SET @intIdentity = - 2
			RETURN
		END 
	END

	-- update user
	UPDATE InstantASP_Users SET 
	PrimaryRoleID = @intPrimaryRoleID,
	Username = @strUsername,
	UsernameEncoded = @strUsernameEncoded,
	EmailAddress = @strEmailAddress,
	[Password] = @strPassword,
	PasswordSalt = @intPasswordSalt,
	Culture = @strCulture,
	TimeZoneOffset = @dbTimeZoneOffSet,
	ObserveDaylightSavingTime = @bolObserveDST,
	DateTimeFormat = @strDateTimeFormat,
	FirstDayOfWeek = @intFirstDayOfWeek,
	FirstName = @strFirstName,
	LastName = @strLastName,
	Gender = @intGender,
	CompanyName = @strCompanyName,
	JobTitle = @strJobTitle,
	Skills = @strSkills,
	PublicEmail = @strPublicEmail,
	Phone = @strPhone,
	WebAddress = @strWebAddress,
	BlogAddress = @strBlogAddress,
	OpenID = @strOpenID,
	PhotoImage = @strPhotoImage,
	BannerImage = @strBannerImage,
	MSN = @strMSN,
	Skype = @strSkype,
	YIM = @strYIM,
	AIM = @strAIM,
	ICQ = @strICQ,
	SnapChat = @strSnapChat,
	WhatsApp = @strWhatsApp,
	Twitter = @strTwitter,
	Facebook = @strFacebook,
	GooglePlus = @strGooglePlus,
	LinkedIn = @strLinkedIn,
	MySpace = @strMySpace,
	YouTube = @strYouTube,
	Location = @strLocation,
	DOBDay = @intDOBDay,
	DOBMonth = @intDOBMonth,
	DOBYear = @intDOBYear,
	ShowAge = @bitShowAge,
	IPAddress = @strIPAddress,
	UserLevelTitle = @strUserLevelTitle,
	UserLevelImageURL = @strUserLevelImageURL,
	LdapUsername = @strLdapUsername,
	ConfirmationCode = @strConfirmationCode,
	RecognitionPoints = @intRecognitionPoints,
	UserIconID = @intUserIconID,
	APIKey = @strAPIKey
	WHERE (InstantASP_Users.UserID = @intUserID)

	-- set output parameter
	SET @intIdentity = @intUserID

END

RETURN

GO

------------------------------

GO

CREATE PROCEDURE [ikb_sp_InsertArticleVersion] (
@intArticleID int,
@intUserID int,
@strArticleTitle nvarchar(500),
@strArticleText nvarchar(max),
@intArticleWorkFlowStepID int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Adds revisions for articles to the versioning table */

DECLARE @intArticleMajorVersion int;
SET @intArticleMajorVersion = 1;

DECLARE @intArticleMinorVersion int;
SET @intArticleMinorVersion = 0;

IF EXISTS(SELECT ArticleVersionID FROM InstantKB_ArticleVersions WHERE ArticleID = @intArticleID)
BEGIN
	SET @intArticleMajorVersion = (
		SELECT TOP 1 IsNull(ArticleMajorVersion, 0) FROM 
		InstantKB_ArticleVersions WHERE ArticleID = @intArticleID
		ORDER BY ArticleVersionID DESC
	);
	SET @intArticleMinorVersion = (
		SELECT TOP 1 IsNull(ArticleMinorVersion, 0) FROM 
		InstantKB_ArticleVersions WHERE ArticleID = @intArticleID
		ORDER BY ArticleVersionID DESC
	);
		
	IF (@intArticleMinorVersion <= 9)
		SET @intArticleMinorVersion = (@intArticleMinorVersion + 1)		
	IF (@intArticleMinorVersion = 10)
		SET @intArticleMinorVersion = 0;		
	IF (@intArticleMinorVersion = 0)
		SET @intArticleMajorVersion = (@intArticleMajorVersion + 1)
	
END

INSERT INTO InstantKB_ArticleVersions (
	ArticleID, 
	UserID,
	ArticleMajorVersion,
	ArticleMinorVersion,
	ArticleTitle,
	ArticleText,
	ArticleWorkFlowStepID,
	DateStamp
) VALUES (
	@intArticleID, 
	@intUserID,
	@intArticleMajorVersion,
	@intArticleMinorVersion,
	@strArticleTitle,
	@strArticleText,
	@intArticleWorkFlowStepID,
	GetDate()
)

DECLARE @strVersion nvarchar(50)
SET @strVersion = (
	CAST(@intArticleMajorVersion AS nvarchar(50)) + '.' + 
	CAST(@intArticleMinorVersion AS nvarchar(50))
)

-- update version in articles table
UPDATE InstantKB_Articles
SET ArticleVersion = (SELECT 1.0*CONVERT(float,@strVersion))
WHERE ArticleID = @intArticleID;

-- set return identity
SET @intIdentity = @@IDENTITY
RETURN @intIdentity

GO

------------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectArticleVersionsPaged] (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	ArticleVersionID int
)

-- insert data 
INSERT INTO #PageIndex (ArticleVersionID)
EXECUTE sp_executesql @strSQLPopulate


SELECT 
	av.*,
	u.UserLevelTitle, 
	u.UserLevelImageURL, 
	u.PhotoImage, 
	u.Username,
	u.FirstName,
	u.EmailAddress,
	u.LastName,
	u.UserIconID,
	kbu.RecognitionPoints, 	
	wfs.*,
	(SELECT InstantASP_Roles.RoleName FROM InstantASP_Roles WHERE RoleID = u.PrimaryRoleID) AS RoleName 
FROM #PageIndex IPI 
JOIN InstantKB_ArticleVersions AS av ON av.ArticleVersionID = IPI.ArticleVersionID
JOIN InstantASP_Users AS u ON av.UserID = u.UserID 
JOIN InstantKB_Users AS kbu ON av.UserID = kbu.UserID 
LEFT OUTER JOIN InstantKB_WorkFlowSteps AS wfs ON av.ArticleWorkFlowStepID = wfs.WorkFlowStepID 
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
	

GO

-----------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectArticleVersion] (
@intArticleVersionID int
) AS
SET NOCOUNT ON
 
SELECT 
	av.*,
	u.UserLevelTitle, 
	u.UserLevelImageURL, 
	u.PhotoImage, 
	u.Username,
	u.FirstName,
	u.EmailAddress,
	u.LastName,
	u.UserIconID,
	kbu.RecognitionPoints, 	
	wfs.*,
	(SELECT InstantASP_Roles.RoleName FROM InstantASP_Roles WHERE RoleID = u.PrimaryRoleID) AS RoleName 
FROM InstantKB_ArticleVersions AS av 
JOIN InstantASP_Users AS u ON av.UserID = u.UserID 
JOIN InstantKB_Users AS kbu ON av.UserID = kbu.UserID 
LEFT OUTER JOIN InstantKB_WorkFlowSteps AS wfs ON av.ArticleWorkFlowStepID = wfs.WorkFlowStepID 
WHERE av.ArticleVersionID = @intArticleVersionID;

GO

-----------------------

GO


ALTER PROCEDURE [ikb_sp_SelectArticlesPaged] (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(max),
@strSQLCount nvarchar(max),
@bolReturnRecordCount bit,
@strSQLFullTextMaxRank nvarchar(4000)
)
AS

SET NOCOUNT ON

DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
IF (@intRowsToReturn > 0) 
BEGIN
	SET ROWCOUNT @intRowsToReturn
END

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex

-- set upperbound only if we have a pagesize
IF (@intRowsToReturn > 0) 
BEGIN
	SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1
END
ELSE
BEGIN
	SET @intPageUpperBound = (SELECT COUNT(ArticleID) FROM InstantKB_Articles)
END

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL PRIMARY KEY,
	ArticleID int, 
	[Rank] int, 
	MaxRank int, 
	SortBy sql_variant
)

-- insert data 
INSERT INTO #PageIndex (ArticleID, Rank, SortBy)
EXECUTE sp_executesql @strSQLPopulate

-- do we need to return our full text max rank
DECLARE @intMaxRank int
IF (@strSQLFullTextMaxRank <> '')
BEGIN

	-- insert full text max rank
	INSERT INTO #PageIndex (MaxRank)
	EXECUTE sp_executesql @strSQLFullTextMaxRank
	-- set max rank
	SET @intMaxRank = (SELECT MaxRank FROM #PageIndex WHERE #PageIndex.IndexID = @@IDENTITY)
	DELETE FROM #PageIndex WHERE #PageIndex.IndexID = @@IDENTITY
	UPDATE #PageIndex SET MaxRank = @intMaxRank

END

-- select the data to return
SELECT 
	IPI.Rank, 
	IPI.MaxRank, 
	a.*, 
	CAST((
		SELECT  CAST(c.CategoryID AS nvarchar(255)) + ','
		FROM InstantKB_ArticleCategories c
		WHERE c.ArticleID = a.ArticleID
		FOR XML PATH(''))as varchar(max)) as ArticleSecondaryCategoryIDs,
	InstantKB_ArticleCustomFields.*,
	InstantKB_Types.*, 
	InstantKB_Levels.*, 
	InstantKB_Status.*, 
	InstantKB_Priorities.*, 
	InstantKB_WorkFlowSteps.*,	
	CreatedBy.Username AS CreatedByUsername,
	CreatedBy.PhotoImage AS CreatedByPhotoImage,
	ModifiedBy.Username AS ModifiedByUsername,
	ModifiedBy.PhotoImage AS ModifiedByPhotoImage,
	AssignedTo.Username AS AssignedToUsername,
	AssignedTo.PhotoImage AS AssignedToPhotoImage,
	ReportedBy.Username AS ReportedByUsername,
	ReportedBy.PhotoImage AS ReportedByPhotoImage,
	SuggestedBy.Username AS SuggestedByUsername,
	SuggestedBy.PhotoImage AS SuggestedByPhotoImage
FROM #PageIndex IPI 
	LEFT OUTER JOIN InstantKB_Articles AS a WITH (nolock) ON a.ArticleID = IPI.ArticleID  
	LEFT OUTER JOIN InstantKB_Types WITH (nolock) ON a.ArticleTypeID = InstantKB_Types.TypeID 
	LEFT OUTER JOIN InstantKB_WorkFlowSteps WITH (nolock) ON a.ArticleWorkFlowStepID = InstantKB_WorkFlowSteps.WorkFlowStepID 
	LEFT OUTER JOIN InstantKB_Priorities WITH (nolock) ON a.ArticlePriorityID = InstantKB_Priorities.PriorityID 
	LEFT OUTER JOIN InstantKB_Status WITH (nolock) ON a.ArticleStatusID = InstantKB_Status.StatusID 
	LEFT OUTER JOIN InstantKB_Levels WITH (nolock) ON a.ArticleLevelID = InstantKB_Levels.LevelID 
	LEFT OUTER JOIN InstantKB_ArticleCustomFields ON a.ArticleID = InstantKB_ArticleCustomFields.ArticleID
	LEFT OUTER JOIN InstantASP_Users AS CreatedBy WITH (nolock) ON a.ArticleCreatedUserID = CreatedBy.UserID 
	LEFT OUTER JOIN InstantASP_Users AS ModifiedBy WITH (nolock) ON a.ArticleModifiedUserID = ModifiedBy.UserID 
	LEFT OUTER JOIN InstantASP_Users AS AssignedTo WITH (nolock) ON a.ArticleModifiedUserID = AssignedTo.UserID 
	LEFT OUTER JOIN InstantASP_Users AS ReportedBy WITH (nolock) ON a.ArticleModifiedUserID = ReportedBy.UserID 
	LEFT OUTER JOIN InstantASP_Users AS SuggestedBy WITH (nolock) ON a.ArticleSuggestedUserID = SuggestedBy.UserID 
WHERE 
	IPI.IndexID > @intPageLowerBound AND 
	IPI.IndexID < @intPageUpperBound 
ORDER BY 
	IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
	

GO

-------------------------------------------

GO


ALTER PROCEDURE [ikb_sp_DeleteArticle] (
@intArticleID int
) AS
SET NOCOUNT ON 

/* Delete article */
DELETE FROM InstantKB_Articles WHERE (InstantKB_Articles.ArticleID = @intArticleID)

/* Delete tags */
DELETE FROM InstantASP_Tags WHERE (RelatedEntityID = @intArticleID AND ApplicationID = 2)

/* Delete attachments */
DELETE FROM InstantKB_Attachments WHERE (RelatedEntityID = @intArticleID AND AttachmentType = 1)

/* Delete comments */
DELETE FROM InstantKB_ArticleComments WHERE (ArticleID = @intArticleID)

/* Delete ratings */
EXEC ikb_sp_DeleteArticleRatings @intArticleID

/* Delete versions */
DELETE FROM InstantKB_ArticleVersions WHERE (ArticleID = @intArticleID)

/* Delete article categories from InstantKB_ArticleCategories */
EXEC ikb_sp_DeleteArticleCategories @intArticleID

/* Delete roles */
EXEC ikb_sp_DeleteArticleRoles @intArticleID

/* Delete related links */
EXEC ikb_sp_DeleteArticleRelatedLinks @intArticleID
DELETE FROM InstantKB_ArticleRelatedLinks WHERE (
	InstantKB_ArticleRelatedLinks.RelatedArticleID = @intArticleID
)

RETURN

GO

-----------------------------------

GO

ALTER PROCEDURE [ikb_sp_InsertUpdateCategory] (
@intCategoryID int,
@intCategoryParentID int,
@intTabID int,
@intDataViewID int,
@strCategoryName nvarchar(255),
@strCategoryDescription nvarchar(max),
@intCategorySortOrder int,
@strCategoryIcon nvarchar(255),
@bolCategoryExpanded bit,
@strCategoryForeColor nvarchar(15),
@strCategoryBackColor nvarchar(15),
@intUserID int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a category within InstantKB_Categories */

-- is this an update or insert?
IF (@intCategoryID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Categories (
		CategoryParentID, 
		TabID, 
		DataViewID, 
		CategoryName, 
		CategoryDescription, 
		CategorySortOrder, 
		CategoryIcon, 
		CategoryExpanded, 
		CategoryForeColor,
		CategoryBackColor,
		UserID, 
	DateStamp
	) VALUES (
		@intCategoryParentID,
		@intTabID, 
		@intDataViewID, 
		@strCategoryName, 
		@strCategoryDescription, 
		@intCategorySortOrder, 
		@strCategoryIcon, 
		@bolCategoryExpanded, 
		@strCategoryForeColor,
		@strCategoryBackColor,
		@intUserID, 
		GetDate()
	)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Categories SET
	CategoryParentID = @intCategoryParentID,
	TabID = @intTabID,
	DataViewID = @intDataViewID,
	CategoryName = @strCategoryName,
	CategoryDescription = @strCategoryDescription,
	CategorySortOrder = @intCategorySortOrder,
	CategoryIcon = @strCategoryIcon,
	CategoryExpanded = @bolCategoryExpanded,
	CategoryForeColor = @strCategoryForeColor,
	CategoryBackColor = @strCategoryBackColor,
	UserID = @intUserID,
	DateStamp = GetDate()
	WHERE InstantKB_Categories.CategoryID = @intCategoryID

	-- return the identity
	SET @intIdentity = @intCategoryID
	RETURN

END

SET @intIdentity = 0
RETURN


GO

---------------------------------------

GO

ALTER PROCEDURE [ikb_sp_InsertUpdateTicket] (
@intTicketID int,
@intTicketTabID int,
@intTicketSLAID int,
@intTicketToUserID int,
@intTicketRelatedUserID int,
@strTicketTitle nvarchar(255),
@strTicketText ntext,
@intTicketStatusID int,
@intTicketPriorityID int,
@intTicketTypeID int,
@intTicketDeptID int,
@intTicketCategoryID int,
@intTicketWorkflowStepID int,
@intTicketCreatedUserID int,
@strTicketCreatedUsername nvarchar(255),
@strTicketCreatedEmailAddress nvarchar(255),
@intTicketModifiedUserID int,
@intTicketAssignedUserID int,
@dtTicketDueDate datetime2,
@dtTicketClosedDate datetime2,
@strTicketAttachment1 nvarchar(255),
@strTicketAttachment2 nvarchar(255),
@intTicketTimeWorked int,
@intTicketPercentComplete int,
@strTicketImage nvarchar(255),
@intTicketChannel smallint,
@strTicketChannelMsgID nvarchar(255),
@strTicketChannelCatID nvarchar(255),
@strTicketChannelPageID nvarchar(255),
@intTicketChannelAccountID int,
@bitTicketIsSpam bit,
@bitTicketIsArchived bit,
@bitUpdateDueDateBasedOnSLA bit,
@bitUpdateLastModified bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a article within the InstantKB_Articles table */

DECLARE @bolIsStaffReply bit
SET @bolIsStaffReply = 0
	
DECLARE @strCreatedEmail nvarchar(255)
DECLARE @strCreatedUsername nvarchar(255)
DECLARE @dtCreatedDate datetime

DECLARE @strModifiedUsername nvarchar(255)
DECLARE @dtModifiedDate datetime

DECLARE @strAssignedUsername nvarchar(255)

SET @dtCreatedDate = GetDate()
SET @dtModifiedDate = GetDate()

if (@intTicketCreatedUserID > 0) 
BEGIN

	SET @strCreatedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketCreatedUserID))
	SET @strCreatedEmail = (SELECT EmailAddress FROM InstantASP_Users WHERE (UserID = @intTicketCreatedUserID))
	
	-- check if author is staff
	IF EXISTS(
		SELECT u.UserID, 
		ur.RoleID 
		FROM InstantASP_Users AS u
		INNER JOIN InstantASP_UsersRoles AS ur ON u.UserID = ur.UserID 
		WHERE ur.RoleID IN (SELECT RoleID FROM InstantASP_Roles AS r
		WHERE r.AdministratorRole  = 1 or r.ModeratorRole = 1)
		AND u.UserID = @intTicketCreatedUserID)
	BEGIN
		SET @bolIsStaffReply = 1
	END

END
ELSE
BEGIN
	SET @strCreatedUsername = @strTicketCreatedUsername
	SET @strCreatedEmail = @strTicketCreatedEmailAddress
END

IF (@intTicketAssignedUserID > 0)
BEGIN	
	SET @strAssignedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketAssignedUserID))
END
ELSE
BEGIN
	SET @strAssignedUsername = '';
END

IF (@intTicketModifiedUserID > 0)
BEGIN
	SET @strModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketModifiedUserID))
END
ELSE
BEGIN
	SET @strModifiedUsername = @strCreatedUsername;
END
		
-- is this an update or insert?
IF (@intTicketID = 0)
BEGIN

	-- ensure unique channel messages
	IF (@strTicketChannelMsgID != '')
	BEGIN
		IF (EXISTS(SELECT TicketID FROM InstantKB_Tickets WHERE TicketChannelMsgID = @strTicketChannelMsgID))
		BEGIN
			SET @intIdentity = 0;
			RETURN;
		END
	END

	-- insert 
	INSERT INTO InstantKB_Tickets 
		(
		TicketTabID,
		TicketSLAID,
		TicketToUserID,
		TicketRelatedUserID,
		TicketTitle, 
		TicketText,
		TicketStatusID, 
		TicketPriorityID, 
		TicketDeptID, 
		TicketTypeID, 
		TicketCategoryID,
		TicketWorkflowStepID, 
		TicketCreatedDate, 
		TicketCreatedUserID, 
		TicketCreatedUsername, 
		TicketCreatedEmail, 
		TicketModifiedUserID, 
		TicketModifiedUsername,
		TicketModifiedDate, 
		TicketDueDate,	
		TicketClosedDate,
		TicketAttachment1,
		TicketAttachment2,
		TicketIsStaffReply,
		TicketTimeWorked,
		TicketPercentComplete,
		TicketImage,
		TicketChannel,
		TicketChannelMsgID,
		TicketChannelCatID,
		TicketChannelPageID,
		TicketChannelAccountID,
		TicketIsSpam,
		TicketIsArchived
		)		
	VALUES 		(
		@intTicketTabID,
		@intTicketSLAID,
		@intTicketToUserID,
		@intTicketRelatedUserID,
		@strTicketTitle,
		@strTicketText,
		@intTicketStatusID,
		@intTicketPriorityID,
		@intTicketDeptID,
		@intTicketTypeID,	
		@intTicketCategoryID,
		@intTicketWorkflowStepID,
		@dtCreatedDate,
		@intTicketCreatedUserID,
		IsNull(@strCreatedUsername,''),
		@strCreatedEmail,
		@intTicketModifiedUserID,
		IsNull(@strModifiedUsername, ''),
		@dtCreatedDate,
		@dtTicketDueDate,
		@dtTicketClosedDate,
		@strTicketAttachment1,
		@strTicketAttachment2,
		@bolIsStaffReply,
		@intTicketTimeWorked,
		@intTicketPercentComplete,
		@strTicketImage,
		@intTicketChannel,
		@strTicketChannelMsgID,
		@strTicketChannelCatID,
		@strTicketChannelPageID,
		@intTicketChannelAccountID,
		@bitTicketIsSpam,
		@bitTicketIsArchived
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating
BEGIN

	-- update modified by?
	IF (@bitUpdateLastModified = 0)
	BEGIN
		SET @intTicketModifiedUserID = (SELECT TicketModifiedUserID FROM InstantKB_Tickets WHERE TicketID = @intTicketID)		
		SET @dtModifiedDate = (SELECT TicketModifiedDate FROM InstantKB_Tickets WHERE TicketID = @intTicketID)		
		SET @strModifiedUsername = (SELECT TicketModifiedUsername FROM InstantKB_Tickets WHERE TicketID = @intTicketID)		
		
	END

	-- update
	UPDATE InstantKB_Tickets SET
	TicketTitle = @strTicketTitle,
	TicketSLAID = @intTicketSLAID,
	TicketText = @strTicketText,
	TicketStatusID = @intTicketStatusID,
	TicketPriorityID = @intTicketPriorityID,
	TicketTypeID = 	@intTicketTypeID,
	TicketDeptID = @intTicketDeptID,
	TicketCategoryID = 	@intTicketCategoryID,
	TicketWorkflowStepID =	@intTicketWorkflowStepID,
	TicketModifiedUserID = @intTicketModifiedUserID,
	TicketModifiedDate = @dtModifiedDate,
	TicketDueDate = @dtTicketDueDate,
	TicketClosedDate = @dtTicketClosedDate,
	TicketModifiedUsername = IsNull(@strModifiedUsername, ''),	
	TicketAttachment1 = @strTicketAttachment1,
	TicketAttachment2 = @strTicketAttachment2,
	TicketTimeWorked = @intTicketTimeWorked,
	TicketPercentComplete = @intTicketPercentComplete,
	TicketImage = @strTicketImage,
	TicketChannel = @intTicketChannel,
	TicketChannelMsgID = @strTicketChannelMsgID,
	TicketChannelCatID = @strTicketChannelCatID,
	TicketChannelPageID = @strTicketChannelPageID,
	TicketChannelAccountID = @intTicketChannelAccountID,
	TicketIsSpam = @bitTicketIsSpam,
	TicketIsArchived = @bitTicketIsArchived
	WHERE InstantKB_Tickets.TicketID = @intTicketID

	-- return the identity
	SET @intIdentity = @intTicketID

END

-- do we have an assigned user?
IF (@strAssignedUsername <> '') 
BEGIN
	-- ensure we only update if assigned status has changed
	DECLARE @intCurrentAssignedUserID int
	SET @intCurrentAssignedUserID = (SELECT TicketAssignedUserID FROM InstantKB_Tickets WHERE InstantKB_Tickets.TicketID = @intIdentity)
	IF (@intCurrentAssignedUserID <> @intTicketAssignedUserID)
	BEGIN	
		UPDATE InstantKB_Tickets SET 
		TicketAssignedUserID = 	@intTicketAssignedUserID,
		TicketAssignedUsername = IsNull(@strAssignedUsername,''),
		TicketAssignedDate = 	GETDATE()
		WHERE InstantKB_Tickets.TicketID = @intIdentity
	END
END
ELSE
BEGIN
	UPDATE InstantKB_Tickets SET 
	TicketAssignedUserID = 	0,
	TicketAssignedUsername = '',
	TicketAssignedDate = 	null
	WHERE InstantKB_Tickets.TicketID = @intIdentity
END
	
-- determine if ticket is closed
DECLARE @bitIsClosed bit;
SET @bitIsClosed = 0;
IF (EXISTS(SELECT TicketID FROM InstantKB_Tickets WHERE TicketID = @intTicketID AND TicketClosedDate IS NOT NULL))
BEGIN
	SET @bitIsClosed = 1;
END

-- do we have an SLA?

IF(@bitUpdateDueDateBasedOnSLA = 1)
BEGIN

	IF (@intTicketSLAID > 0) 
	BEGIN
	
		DECLARE @intHours int
		SET @intHours = (SELECT SLAOverdueTime FROM InstantKB_SLAs WHERE InstantKB_SLAs.SLAID = @intTicketSLAID)

		-- set due date based on SLA if ticket is not closed or marked as spam 
		IF (@intHours > 0 AND 
			@bitTicketIsSpam = 0 AND 	
			@bitIsClosed = 0) 
		BEGIN
			EXEC ikb_sp_SetTicketDueDate @intIdentity, @intHours 	
		END
	
		-- reset escalation flag if SLA has 0 hours
		IF (@intHours = 0)
		BEGIN
			UPDATE InstantKB_Tickets SET
			InstantKB_Tickets.TicketIsEscalated = 0			
			WHERE InstantKB_Tickets.TicketID = @intIdentity;
		END

	END
	ELSE
	BEGIN
		-- reset escalation flag if no SLA
		UPDATE InstantKB_Tickets SET	
		InstantKB_Tickets.TicketIsEscalated = 0
		WHERE InstantKB_Tickets.TicketID = @intIdentity;
	ENd
END
	
IF (@bitIsClosed = 1)
BEGIN
	UPDATE InstantKB_Tickets SET
	InstantKB_Tickets.TicketIsEscalated = 0,
	InstantKB_Tickets.TicketOverdue = 0,
	InstantKB_Tickets.TicketDueDate = NULL
	WHERE InstantKB_Tickets.TicketID = @intIdentity;
END

RETURN


GO

------------------------

GO


ALTER PROCEDURE [ikb_sp_InsertUpdateTicketReply] (
@intTicketReplyID int,
@intTicketID int,
@intTicketWorkFlowStepID int,
@intTicketReplyUserID int,
@strTicketText nvarchar(max),
@intTicketTimeWorked int,
@intTicketReplyChannel smallint,
@strTicketReplyChannelMsgID nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

DECLARE @bolIsStaffReply bit
SET @bolIsStaffReply = 0
IF (@intTicketReplyUserID > 0)
BEGIN
	IF EXISTS(SELECT InstantASP_Users.UserID, InstantASP_UsersRoles.RoleID   FROM InstantASP_Users 
	INNER JOIN InstantASP_UsersRoles ON InstantASP_Users.UserID = InstantASP_UsersRoles.UserID 
	WHERE InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles 
	WHERE InstantASP_Roles.AdministratorRole  = 1 or InstantASP_Roles.ModeratorRole = 1)
	AND InstantASP_Users.UserID = @intTicketReplyUserID)
	BEGIN
		SET @bolIsStaffReply = 1
	END
END

-- is this an update or insert?
IF (@intTicketReplyID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_TicketReplies
		(
		TicketID, 
		TicketText,
		TicketReplyUserID,
		TicketReplyCreatedDate,
		TicketReplyTimeWorked,
		TicketReplyChannel,
		TicketReplyChannelMsgID,
		TicketReplyIsStaff 
		)		
	VALUES 		(		
		@intTicketID,
		@strTicketText,
		@intTicketReplyUserID,
		GETDATE(),
		@intTicketTimeWorked,
		@intTicketReplyChannel,
		@strTicketReplyChannelMsgID,
		@bolIsStaffReply
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	
	-- update reply count
	UPDATE InstantKB_Tickets SET
	InstantKB_Tickets.TicketReplies = (
	SELECT COUNT(TicketReplyID) FROM InstantKB_TicketReplies 
	WHERE InstantKB_TicketReplies.TicketID = @intTicketID)
	WHERE InstantKB_Tickets.TicketID = @intTicketID

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_TicketReplies SET
	TicketText = @strTicketText,
	TicketReplyTimeWorked = @intTicketTimeWorked,
	TicketReplyChannel = @intTicketReplyChannel,
	TicketReplyChannelMsgID = @strTicketReplyChannelMsgID,
	TicketModifiedUserID = @intTicketReplyUserID,
	TickedModifiedDate = GETDATE()
	WHERE InstantKB_TicketReplies.TicketReplyID = @intTicketReplyID

	-- return the identity
	SET @intIdentity = @intTicketReplyID

END

IF (@intTicketID > 0)
BEGIN

	IF (@intTicketWorkFlowStepID > 0) 
	BEGIN
		UPDATE InstantKB_Tickets SET
		InstantKB_Tickets.TicketWorkflowStepID  = @intTicketWorkFlowStepID
		WHERE TicketID = @intTicketID;	
	END
	
	-- update total time worked
	IF (@intTicketTimeWorked > 0)
	BEGIN
		DECLARE @intMinutes int
		SET @intMinutes = (SELECT TicketTimeWorked FROM InstantKB_Tickets WHERE TicketID = @intTicketID)
		UPDATE InstantKB_Tickets SET
		InstantKB_Tickets.TicketTimeWorked = (@intMinutes + @intTicketTimeWorked)
		WHERE TicketID = @intTicketID;
	END

	-- update main ticket
	UPDATE InstantKB_Tickets SET
	TicketIsStaffReply = @bolIsStaffReply,
	TicketModifiedUserID = @intTicketReplyUserID,
	TicketModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE UserID = @intTicketReplyUserID),
	TicketModifiedDate = GETDATE(),
	TicketClosedDate = NULL
	WHERE TicketID = @intTicketID;
		
END

RETURN


GO

----------------------------

GO

CREATE PROCEDURE [ikb_sp_SelectUserRank] (
@intUserID int
) AS

SET NOCOUNT ON 

DECLARE @temp TABLE
(
	[Rank] int IDENTITY (1, 1) NOT NULL PRIMARY KEY,
	UserID int, 
	Total int,
	DateStamp DATETIME NOT NULL
)


INSERT INTO @temp (UserID, Total, DateStamp) 
	SELECT u.UserID,
		(	
			SELECT COUNT(t.TicketID) 
			FROM InstantKB_Tickets AS t
			WHERE (
				t.TicketCreatedUserID = u.UserID OR
				t.TicketToUserID = u.UserID OR
				t.TicketRelatedUserID = u.UserID
			)
		) + 		 
		(	
			SELECT COUNT(tr.TicketReplyID) 
			FROM InstantKB_TicketReplies AS tr 
			WHERE tr.TicketReplyUserID = u.UserID
		) 
		AS Total,
		u.LastLoginDate
	FROM InstantASP_Users as u	
	INNER JOIN InstantKB_Users AS kbu ON kbu.UserID = u.UserID
	WHERE 
	(
		u.UserID IN (SELECT TicketCreatedUserID FROM InstantKB_Tickets AS t) OR
		u.UserID IN (SELECT TicketToUserID FROM InstantKB_Tickets AS t) OR
		u.UserID IN (SELECT TicketRelatedUserID FROM InstantKB_Tickets AS t) 		
	) AND kbu.IsSpam = 0 
	Order BY Total DESC
	
SELECT [Rank] FROM @temp 
WHERE UserID = @intUserID 
ORDER BY DateStamp DESC

GO

--------------------------------

GO


ALTER PROCEDURE [ikb_sp_SelectStatisticsForUser] (
@intUserID int,
@intTabID int
)
AS

SET NOCOUNT ON 

/* Select statistics for a single user within the knowledgebase */

DECLARE @intTotalLiveComments int
DECLARE @intTotalPrivateComments int
DECLARE @intTicketsAssignedToMe int
DECLARE @TotalTimeWorked int
DECLARE @TotalSentTickets int
DECLARE @TotalSentReplies int
DECLARE @TotalReceivedTickets int
DECLARE @TotalReceivedReplies int
DECLARE @TotalRelatedTickets int
DECLARE @TotalOpenTickets int
DECLARE @TotalClosedTickets int
DECLARE @TotalArchivedTickets int
DECLARE @TotalAttachments int
DECLARE @TicketFirstPostDate DateTime
DECLARE @TicketLastPostDate DateTime

SET @intTotalLiveComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE (UserID = @intUserID AND AccessType = 1))
SET @intTotalPrivateComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE (UserID = @intUserID AND AccessType = 2))

IF (@intTabID > 0) 
BEGIN

	If (@intUserID > 0) 
	BEGIN

		SET @TotalSentTickets = (
			SELECT COUNT(TicketID) 
			FROM InstantKB_Tickets  WITH (nolock) 
			WHERE (TicketTabID = @intTabID AND TicketCreatedUserID  = @intUserID)
		)

		SET @TotalSentReplies = (
			SELECT COUNT(tr.TicketReplyID) 
				FROM InstantKB_TicketReplies AS tr WITH (nolock)
				INNER JOIN InstantKB_Tickets  AS t WITH (nolock) ON tr.TicketID = t.TicketID
				WHERE 
				( t.TicketTabID = @intTabID AND
					tr.TicketReplyUserID = @intUserID					
				) 		
		)

		SET @TotalReceivedTickets = (
			SELECT COUNT(TicketID) 
			FROM InstantKB_Tickets  WITH (nolock) 
			WHERE (TicketTabID = @intTabID AND TicketToUserID  = @intUserID)
		)
				
		SET @TotalReceivedReplies = (
			SELECT COUNT(tr.TicketReplyID) 
				FROM InstantKB_TicketReplies AS tr WITH (nolock)
				INNER JOIN InstantKB_Tickets  AS t WITH (nolock) ON tr.TicketID = t.TicketID
				WHERE 			 
				(
					t.TicketCreatedUserID = @intUserID OR
					t.TicketToUserID = @intUserID
				) 
				AND
				(
					t.TicketTabID = @intTabID AND
					t.TicketRelatedUserID <> @intUserID AND 
					tr.TicketReplyUserID <> @intUserID
				)
		)

		SET @TotalRelatedTickets = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets  WITH (nolock) 
			WHERE (TicketTabID = @intTabID AND TicketRelatedUserID  = @intUserID)
		)

		SET @TotalOpenTickets = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets  WITH (nolock) 
			WHERE 
			( 
				(
					TicketCreatedUserID  = @intUserID  OR
					TicketToUserID  = @intUserID  OR
					TicketRelatedUserID  = @intUserID  
				) 
				AND (TicketTabID = @intTabID AND TicketClosedDate IS NULL AND TicketIsArchived = 0)
			)
		)

		SET @TotalClosedTickets = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets  WITH (nolock) 
			WHERE 
			( 
				(
					TicketCreatedUserID  = @intUserID  OR
					TicketToUserID  = @intUserID  OR
					TicketRelatedUserID  = @intUserID  
				) 
				AND (TicketTabID = @intTabID AND TicketClosedDate IS NOT NULL)
			)			
		)
		
		SET @TotalArchivedTickets = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets  WITH (nolock) 
			WHERE 
			( 
				(
					TicketCreatedUserID  = @intUserID  OR
					TicketToUserID  = @intUserID  OR
					TicketRelatedUserID  = @intUserID  
				) 
				AND (TicketTabID = @intTabID AND TicketIsArchived = 1)
			)						
		)

		SET @TotalTimeWorked = (
			SELECT SUM(TicketTimeWorked) FROM InstantKB_Tickets  WITH (nolock) 
			WHERE (TicketTabID = @intTabID AND (TicketCreatedUserID  = @intUserID  OR TicketToUserID  = @intUserID OR TicketRelatedUserID  = @intUserID))
		)

		SET @intTicketsAssignedToMe = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
			WHERE (InstantKB_Tickets.TicketAssignedUserID  = @intUserID AND TicketIsSpam = 0 AND TicketIsArchived = 0 AND TicketClosedDate IS NULL AND TicketTabID = @intTabID)
		)

		SET @TotalAttachments = (
			SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
			INNER JOIN InstantKB_Attachments ON InstantKB_Tickets.TicketID = InstantKB_Attachments.RelatedEntityID
			WHERE ((				
				InstantKB_Tickets.TicketCreatedUserID  = @intUserID OR 
				InstantKB_Tickets.TicketToUserID  = @intUserID OR 
				InstantKB_Tickets.TicketRelatedUserID  = @intUserID) AND 
				(InstantKB_Attachments.AttachmentType = 2 AND
				TicketTabID = @intTabID)
			 )
		)
		
		SET @TicketFirstPostDate = (
			SELECT TOP 1 TicketCreatedDate FROM InstantKB_Tickets WITH (nolock) 
			WHERE (InstantKB_Tickets.TicketCreatedUserID  = @intUserID  AND TicketTabID = @intTabID) 
			ORDER BY TicketCreatedDate ASC
		)		

		SET @TicketLastPostDate = (
			SELECT TOP 1 TicketCreatedDate FROM InstantKB_Tickets WITH (nolock) 
			WHERE (InstantKB_Tickets.TicketCreatedUserID  = @intUserID  AND TicketTabID = @intTabID) 
			ORDER BY TicketCreatedDate DESC
		)	

	END
	
END
ELSE
BEGIN

	-- no specific tab ID

	SET @TotalSentTickets = (
		SELECT COUNT(TicketID) 
		FROM InstantKB_Tickets WITH (nolock) 
		WHERE ( TicketCreatedUserID  = @intUserID)
	)
		
	SET @TotalSentReplies = (
		SELECT COUNT(tr.TicketReplyID) 
			FROM InstantKB_TicketReplies AS tr WITH (nolock)
			INNER JOIN InstantKB_Tickets  AS t WITH (nolock) ON tr.TicketID = t.TicketID
			WHERE 
			( 
				tr.TicketReplyUserID = @intUserID 	
			) 		
	)

	SET @TotalReceivedTickets = (
		SELECT COUNT(TicketID)
		FROM InstantKB_Tickets WITH (nolock) 
		WHERE (TicketToUserID  = @intUserID)
	)

	SET @TotalReceivedReplies = (
		SELECT COUNT(tr.TicketReplyID) 
			FROM InstantKB_TicketReplies AS tr WITH (nolock)
			INNER JOIN InstantKB_Tickets  AS t WITH (nolock) ON tr.TicketID = t.TicketID
			WHERE 			 
			(
				t.TicketCreatedUserID = @intUserID OR
				t.TicketToUserID = @intUserID
			) 
			AND
			(				
				t.TicketRelatedUserID <> @intUserID AND 
				tr.TicketReplyUserID <> @intUserID AND
				tr.TicketReplyIsStaff = 1				
			)
	)
	
	SET @TotalRelatedTickets = (
		SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
		WHERE (TicketRelatedUserID  = @intUserID)
	)

	SET @TotalOpenTickets = (
		SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
		WHERE 
		( 
			(
				TicketCreatedUserID  = @intUserID  OR
				TicketToUserID  = @intUserID  OR
				TicketRelatedUserID  = @intUserID  
			) 
			AND (TicketClosedDate IS NULL AND TicketIsArchived = 0)
		)
	)

	SET @TotalClosedTickets = (
		SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
		WHERE 
		( 
			(
				TicketCreatedUserID  = @intUserID  OR
				TicketToUserID  = @intUserID  OR
				TicketRelatedUserID  = @intUserID  
			) 
			AND (TicketClosedDate IS NOT NULL)
		)
	)
	
	SET @TotalArchivedTickets = (
		SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 	
		WHERE 
		(
			(
				TicketCreatedUserID  = @intUserID  OR
				TicketToUserID  = @intUserID  OR
				TicketRelatedUserID  = @intUserID  
			) 
			AND (TicketIsArchived  = 1)
		)		
	)

	SET @TotalTimeWorked = (
		SELECT SUM(TicketTimeWorked) FROM InstantKB_Tickets WITH (nolock) 
		WHERE ( TicketCreatedUserID  = @intUserID OR TicketToUserID  = @intUserID OR TicketRelatedUserID  = @intUserID)
	)

	SET @intTicketsAssignedToMe = (
		SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
		WHERE (InstantKB_Tickets.TicketAssignedUserID  = @intUserID AND TicketIsSpam = 0 AND TicketIsArchived = 0 AND TicketClosedDate IS NULL)
	)

	SET @TotalAttachments = (
		SELECT COUNT(TicketID) FROM InstantKB_Tickets WITH (nolock) 
		INNER JOIN InstantKB_Attachments ON InstantKB_Tickets.TicketID = InstantKB_Attachments.RelatedEntityID
		WHERE ((				
			InstantKB_Tickets.TicketCreatedUserID  = @intUserID OR 
			InstantKB_Tickets.TicketToUserID  = @intUserID OR 
			InstantKB_Tickets.TicketRelatedUserID  = @intUserID) AND 
			(InstantKB_Attachments.AttachmentType = 2)
			)
	)

	SET @TicketFirstPostDate = (
		SELECT TOP 1 TicketCreatedDate FROM InstantKB_Tickets WITH (nolock) 
		WHERE (InstantKB_Tickets.TicketCreatedUserID  = @intUserID) 
		ORDER BY TicketCreatedDate ASC
	)

	SET @TicketLastPostDate = (
		SELECT TOP 1 TicketCreatedDate FROM InstantKB_Tickets WITH (nolock) 
		WHERE (InstantKB_Tickets.TicketCreatedUserID  = @intUserID) 
		ORDER BY TicketCreatedDate DESC
	)
					
END

SELECT 
@intTotalLiveComments As TotalLiveComments, 
@intTotalPrivateComments As TotalPrivateComments,
@TotalTimeWorked AS TotalTimeWorked,
@intTicketsAssignedToMe AS TicketsAssignedToMe,
@TotalSentTickets as TotalSentTickets,
@TotalSentReplies as TotalSentReplies,
@TotalReceivedTickets as TotalReceivedTickets,
@TotalReceivedReplies as TotalReceivedReplies,
@TotalRelatedTickets as TotalRelatedTickets,
@TotalOpenTickets as TotalOpenTickets,
@TotalClosedTickets as TotalClosedTickets,
@TotalArchivedTickets as TotalArchivedTickets,
@TotalAttachments AS TotalAttachments,
@TicketFirstPostDate AS TicketFirstPostDate,
@TicketLastPostDate AS TicketLastPostDate

RETURN

GO

---------------------

GO

ALTER PROCEDURE [ikb_sp_CleanTables] (
@strDateTime nvarchar(255)
)
AS

SET NOCOUNT ON 

/* Cleans all tables of any expired data */

-- delete expired who's on data
EXEC ikb_sp_DeleteWhosOnData @strDateTime

-- delete expired topic read information
EXEC ikb_sp_DeleteExpiredArticleRead @strDateTime

-- flah overddue tickets
UPDATE InstantKB_Tickets SET
InstantKB_Tickets.TicketOverdue = 1
WHERE InstantKB_Tickets.TicketDueDate <= @strDateTime

-- reset tickets if they don't have a due date
UPDATE InstantKB_Tickets SET
InstantKB_Tickets.TicketOverdue = 0 
WHERE InstantKB_Tickets.TicketDueDate IS NULL

-- set expired public articles to private
UPDATE InstantKB_Articles SET
ArticleAccessType = 2
WHERE (
	ArticleAccessType = 1 AND 
	ArticleExpiresDate IS NOT NULL AND 
	ArticleExpiresDate <= @strDateTime
)

-- delete view state data older than 5 days
DELETE TOP (500)  
FROM  InstantASP_ViewState
WHERE (InstantASP_ViewState.DateStamp < DateAdd("d", -5, GetDate()))

-- return overdue but not escalated or closed tickets
-- so we can run escalation rules again this tickets
SELECT TOP 100 TicketID FROM InstantKB_Tickets AS t 
WHERE (
	t.TicketDueDate <= @strDateTime AND
	t.TicketClosedDate IS NULL AND
	t.TicketIsEscalated = 0 AND
	t.TicketIsSpam = 0
 )

RETURN

GO

GO

/* email attachment support */

GO

CREATE TABLE InstantASP_EmailAttachments
(
EmailAttachmentID                   INT IDENTITY(1,1) NOT NULL,
EmailID                             INT DEFAULT (0) NOT NULL,
[FileName]                          NVARCHAR(255) DEFAULT (N'') NOT NULL,
AttachmentBLOB                      IMAGE,
ContentType                         NVARCHAR(100) DEFAULT (N'') NOT NULL,
ContentLength                       INT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantASP_EmailAttachments PRIMARY KEY CLUSTERED ( EmailAttachmentID )
)

GO

------------------

GO

CREATE PROCEDURE [iasp_sp_InsertEmailAttachment] (
@intEmailID int,
@strFileName nvarchar(255),
@binAttachmentBLOB image, 
@strContentType nvarchar(100),
@intContentLength int,
@intIdentity int output
)
AS

SET NOCOUNT ON 

/* Inserts a new email attachment into InstantASP_EmailAttachments */

INSERT INTO InstantASP_EmailAttachments (
	EmailID, 
	[Filename], 
	AttachmentBLOB,
	ContentType, 
	ContentLength
) VALUES (
	@intEmailID, 
	@strFileName, 
	@binAttachmentBLOB,
	@strContentType, 
	@intContentLength
)

-- return the new identity

SET @intIdentity = @@IDENTITY

RETURN

GO

---------------------

GO

CREATE PROCEDURE [iasp_sp_DeleteEmailAttachment] (
@intEmailAttachmentID int
) AS
SET NOCOUNT ON 

/* Deletes an email attachment InstantKB_Attachments table */

DELETE FROM InstantASP_EmailAttachments WHERE 
InstantASP_EmailAttachments.EmailAttachmentID = @intEmailAttachmentID

RETURN

GO

--------------------------

GO

CREATE PROCEDURE [iasp_sp_SelectEmailAttachments] (
@intEmailID int
)
AS

SET NOCOUNT ON 

/* Select all email attachments from InstantASP_EmailAttachments */

SELECT * FROM 
InstantASP_EmailAttachments WHERE 
InstantASP_EmailAttachments.EmailID = @intEmailID

RETURN 

GO

--------------------------

GO

ALTER PROCEDURE [iasp_sp_InsertQueuedEmail] (
@strEmailTo nvarchar(255),
@strEmailCC nvarchar(255),
@strEmailBCC ntext,
@strEmailFrom nvarchar(255),
@strEmailSubject nvarchar(1500),
@strEmailBody ntext,
@intEmailPriority tinyint,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts a new email into the InstantASP_Emails mail queue */

INSERT INTO InstantASP_Emails(
	EmailTo, 
	EmailCC, 
	EmailBCC, 
	EmailFrom, 
	EmailSubject, 
	EmailBody,
	EmailPriority, 
	DateStamp
) VALUES (
	@strEmailTo, 
	@strEmailCC, 
	@strEmailBCC, 
	@strEmailFrom, 
	@strEmailSubject, 
	@strEmailBody, 
	@intEmailPriority, 
	GetDate()
)

SET @intIdentity = @@IDENTITY

RETURN

GO

------------------------------

GO


ALTER PROCEDURE [iasp_sp_DeleteQueuedEmails] (
@strIdentities nvarchar(2000)
) AS

SET NOCOUNT ON 

/* Accepts a comma delimited list of email identities and loops through this list removing emails matching the identities */

DECLARE @Separator varchar(1)
DECLARE @Value varchar(255)
DECLARE @SepPosition int
DECLARE @LoopCount int

SET  @Separator = ','
SET @LoopCount = 0
SET @strIdentities = @strIdentities + @Separator

WHILE patindex('%' + @Separator + '%' , @strIdentities) <> 0 -- loop until we find no more separators
BEGIN
	
	SET @SepPosition =  patindex('%' + @Separator + '%' , @strIdentities)  -- patindex matches the a pattern against a string
	SET @Value = left(@strIdentities, @SepPosition - 1) -- array value holds each single keyword
		
	/* Delete email as this has now been successfully sent */	
	DELETE FROM InstantASP_Emails WHERE EmailID = @Value  
	DELETE FROM InstantASP_EmailAttachments WHERE EmailID = @Value  
		
	SET @LoopCount = + 1 -- increment loop count		
	SET @strIdentities = stuff(@strIdentities, 1, @SepPosition, '') -- This replaces what we just processed with and empty string, pevents infinate loops
END

GO

------------------------------

GO

ALTER PROCEDURE [ikb_sp_SelectAttachmentsForUser] (
@intTabID int,
@intUserID int,
@intAttachmentType int
) AS
SET NOCOUNT ON 

/* Returns all attachments for a specific user */

-- articles
IF (@intAttachmentType = 1)
BEGIN

	IF (@intTabID > 0)
	BEGIN
		SELECT InstantKB_Attachments.*,
		InstantKB_Articles.ArticleTitle AS RelatedEntityTitle
		FROM 
		InstantKB_Articles WITH (nolock) 
		INNER JOIN InstantKB_Attachments ON InstantKB_Articles.ArticleId = InstantKB_Attachments.RelatedEntityID
		WHERE ((				
			InstantKB_Articles.ArticleCreatedUserID  = @intUserID) AND 
			(InstantKB_Attachments.AttachmentType = @intAttachmentType
			AND TabID = @intTabID)
		)
	END
	ELSE
	BEGIN
		SELECT InstantKB_Attachments.*,
		InstantKB_Articles.ArticleTitle AS RelatedEntityTitle
		FROM 
		InstantKB_Articles WITH (nolock) 
		INNER JOIN InstantKB_Attachments ON InstantKB_Articles.ArticleId = InstantKB_Attachments.RelatedEntityID
		WHERE ((				
			InstantKB_Articles.ArticleCreatedUserID  = @intUserID) AND 
			(InstantKB_Attachments.AttachmentType = @intAttachmentType)
		)
	END

END

-- tickets
IF (@intAttachmentType = 2)
BEGIN

	IF (@intTabID >  0)
	BEGIN
		SELECT InstantKB_Attachments.*,
		InstantKB_Tickets.TicketTitle AS RelatedEntityTitle
		FROM 
		InstantKB_Tickets WITH (nolock) 
		INNER JOIN InstantKB_Attachments ON InstantKB_Tickets.TicketID = InstantKB_Attachments.RelatedEntityID
		WHERE ((				
			InstantKB_Tickets.TicketCreatedUserID  = @intUserID OR 
			InstantKB_Tickets.TicketToUserID  = @intUserID OR 
			InstantKB_Tickets.TicketRelatedUserID  = @intUserID) AND 
			(InstantKB_Attachments.AttachmentType = @intAttachmentType
			AND TicketTabID = @intTabID)
		) ORDER BY InstantKB_Attachments.DateStamp DESC
	END
	ELSE
	BEGIN
		SELECT InstantKB_Attachments.*,
		InstantKB_Tickets.TicketTitle AS RelatedEntityTitle
		FROM 
		InstantKB_Tickets WITH (nolock) 
		INNER JOIN InstantKB_Attachments ON InstantKB_Tickets.TicketID = InstantKB_Attachments.RelatedEntityID
		WHERE ((				
			InstantKB_Tickets.TicketCreatedUserID  = @intUserID OR 
			InstantKB_Tickets.TicketToUserID  = @intUserID OR 
			InstantKB_Tickets.TicketRelatedUserID  = @intUserID) AND 
			(InstantKB_Attachments.AttachmentType = @intAttachmentType)
		) ORDER BY InstantKB_Attachments.DateStamp DESC
	END

END

GO

--------------------------

GO