-- InstantKB 2016 to 2016-1

INSERT INTO InstantKB_Settings (SettingText,SettingDesc,SettingsXML) VALUES('AdminSettings_APIExplorer','AdminSettings_APIExplorerDesc','')

GO

----------------------

GO

IF NOT EXISTS(SELECT * FROM sys.columns 
            WHERE Name = N'TicketReplyWorkFlowStepID' AND Object_ID = Object_ID(N'InstantKB_TicketReplies'))
BEGIN
	ALTER TABLE InstantKB_TicketReplies ADD TicketReplyWorkFlowStepID   INT DEFAULT(0) NOT NULL;
END

GO

---------------------

GO


ALTER PROCEDURE [iasp_sp_SelectFieldTemplateDetails] (
@intFieldTemplateID int
) AS
SET NOCOUNT ON 

/* Select all fields for a specific field template */

IF (@intFieldTemplateID > 0)
BEGIN
	SELECT InstantASP_Fields.*, InstantASP_FieldTemplateDetails.* 
	FROM InstantASP_Fields INNER JOIN InstantASP_FieldTemplateDetails ON
	InstantASP_Fields.FieldID = InstantASP_FieldTemplateDetails.FieldID 
	WHERE InstantASP_FieldTemplateDetails.FieldTemplateID = @intFieldTemplateID
	ORDER BY InstantASP_FieldTemplateDetails.DetailSortOrder ASC
END
ELSE
BEGIN
	SELECT InstantASP_Fields.*, InstantASP_FieldTemplateDetails.* 
	FROM InstantASP_Fields INNER JOIN InstantASP_FieldTemplateDetails ON
	InstantASP_Fields.FieldID = InstantASP_FieldTemplateDetails.FieldID
	ORDER BY InstantASP_FieldTemplateDetails.DetailSortOrder ASC
END

GO

----------------------

GO

CREATE PROCEDURE [ikb_sp_SelectArticleRelatedLink] (
@intArticleRelatedLinkID int,
@intUserID int
) AS
SET NOCOUNT ON

 /* Selects all related articles for a specific article from InstantKB_ArticleRelatedLinks */

DECLARE @SQL nvarchar(2000)
SELECT @SQL = 'SELECT InstantKB_ArticleRelatedLinks.*, 
InstantKB_Articles.TabID, 
InstantKB_Articles.ArticleTitle, 
InstantKB_Articles.ArticleTitleEncoded,
InstantKB_Articles.ArticleAccessType
FROM InstantKB_ArticleRelatedLinks 
LEFT OUTER JOIN
InstantKB_Articles ON InstantKB_ArticleRelatedLinks.RelatedArticleID = InstantKB_Articles.ArticleID';

SELECT @SQL = @SQL + ' WHERE (InstantKB_ArticleRelatedLinks.ArticleRelatedLinkID = ' + CAST(@intArticleRelatedLinkID As nVarChar(20)) + ')';

-- should we enable the role check
IF (@intUserID >= 0)
BEGIN

	-- tab role checks
	SELECT @SQL = @SQL + ' AND EXISTS (SELECT InstantKB_TabRoles.RoleID FROM InstantKB_TabRoles WHERE InstantKB_TabRoles.TabID = InstantKB_Articles.TabID AND InstantKB_TabRoles.RoleID IN '
	-- filter related links based on roles
	IF (@intUserID = 0) -- anonymous users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.AnonymousRole = 1)'
	END
	ELSE IF (@intUserID > 0) -- authenticated users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN
		InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantASP_UsersRoles.UserID = ' + CAST(@intUserID As nVarChar(20)) + '))'
	END	
	SELECT @SQL = @SQL + ') '

	-- article role checks
	SELECT @SQL = @SQL + ' AND EXISTS (SELECT InstantKB_ArticleRoles.RoleID FROM InstantKB_ArticleRoles WHERE InstantKB_ArticleRoles.ArticleID = InstantKB_Articles.ArticleID AND InstantKB_ArticleRoles.RoleID IN '
	-- filter related links based on roles
	IF (@intUserID = 0) -- anonymous users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.AnonymousRole = 1)'
	END
	ELSE IF (@intUserID > 0) -- authenticated users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN
		InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantASP_UsersRoles.UserID = ' + CAST(@intUserID As nVarChar(20)) + '))'
	END	
	SELECT @SQL = @SQL + ') '

END

-- ensure we use sp_executesql to cache execution plan for dynamic query
EXECUTE sp_executesql @SQL

GO

----------------------

GO

ALTER PROCEDURE [iasp_sp_SelectTags] (
@intApplicationID int,
@intRelatedEntityId int
) AS
SET NOCOUNT ON 

/* Select all content tags for a specific application */

IF (@intRelatedEntityId > 0)
BEGIN
	SELECT InstantASP_Tags.*
	FROM InstantASP_Tags WHERE (ApplicationID = @intApplicationID AND RelatedEntityID = @intRelatedEntityId)
	ORDER BY TagKeyword

END
ELSE -- just return all tags
BEGIN
	SELECT InstantASP_Tags.*
	FROM InstantASP_Tags WHERE (ApplicationID = @intApplicationID)
	ORDER BY TagKeyword
END

GO

----------------------

GO

ALTER PROCEDURE [ikb_sp_InsertUpdateWorkFlowStep] (
@intWorkFlowStepID int,
@intWorkFlowID int,
@strName nvarchar(255),
@intFieldTemplateID int,
@strEditUserIDs nvarchar(750),
@strChangeActionXML nvarchar(max),
@strNotificationXML nvarchar(max),
@intSortOrder int,
@intMarkedAsClosed tinyint,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a workflow step within InstantKB_WorkFlowSteps table */

-- is this an update or insert?
IF (@intWorkFlowStepID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_WorkFlowSteps (
		WorkFlowID, 
		[Name], 
		EditUserIDs,
		FieldTemplateID,
		ChangeActionsXml,
		NotificationXML,
		MarkedAsClosed,
		SortOrder
	) VALUES (
		@intWorkFlowID, 
		@strName, 
		@strEditUserIDs,
		@intFieldTemplateID,
		@strChangeActionXML,
		@strNotificationXML,
		@intMarkedAsClosed,
		@intSortOrder
	)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_WorkFlowSteps SET
	[Name] = @strName,
	EditUserIDs = @strEditUserIDs,
	FieldTemplateID = @intFieldTemplateID,
	ChangeActionsXml = @strChangeActionXML,
	NotificationXML = @strNotificationXML,
	MarkedAsClosed = @intMarkedAsClosed
	WHERE WorkFlowStepID = @intWorkFlowStepID

	-- return the identity
	SET @intIdentity = @intWorkFlowStepID
	RETURN

END

SET @intIdentity = 0
RETURN

GO

----------------------

GO

ALTER PROCEDURE [ikb_sp_SelectDepartmentWorkTimes] (
@intDepartmentID int
) AS

SET NOCOUNT ON 

IF (@intDepartmentID > 0)
BEGIN
	SELECT * FROM InstantKB_DepartmentWorkTimes
	WHERE InstantKB_DepartmentWorkTimes.DepartmentID = @intDepartmentID;
END
ELSE
BEGIN
	SELECT * FROM InstantKB_DepartmentWorkTimes;
END

RETURN 

GO

----------------------

GO

ALTER PROCEDURE [ikb_sp_InsertUpdateTicketReply] (
@intTicketReplyID int,
@intTicketID int,
@intTicketWorkFlowStepID int,
@intTicketReplyUserID int,
@strTicketText nvarchar(max),
@intTicketTimeWorked int,
@intTicketReplyChannel smallint,
@strTicketReplyChannelMsgID nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

DECLARE @bolIsStaffReply bit
SET @bolIsStaffReply = 0
IF (@intTicketReplyUserID > 0)
BEGIN
	IF EXISTS(SELECT InstantASP_Users.UserID, InstantASP_UsersRoles.RoleID   FROM InstantASP_Users 
	INNER JOIN InstantASP_UsersRoles ON InstantASP_Users.UserID = InstantASP_UsersRoles.UserID 
	WHERE InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles 
	WHERE InstantASP_Roles.AdministratorRole  = 1 or InstantASP_Roles.ModeratorRole = 1)
	AND InstantASP_Users.UserID = @intTicketReplyUserID)
	BEGIN
		SET @bolIsStaffReply = 1
	END
END

-- is this an update or insert?
IF (@intTicketReplyID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_TicketReplies
		(
		TicketID, 
		TicketText,
		TicketReplyUserID,
		TicketReplyCreatedDate,
		TicketReplyTimeWorked,
		TicketReplyChannel,
		TicketReplyChannelMsgID,
		TicketReplyWorkFlowStepID,
		TicketReplyIsStaff 
		)		
	VALUES 		(		
		@intTicketID,
		@strTicketText,
		@intTicketReplyUserID,
		GETDATE(),
		@intTicketTimeWorked,
		@intTicketReplyChannel,
		@strTicketReplyChannelMsgID,
		@intTicketWorkFlowStepID,
		@bolIsStaffReply
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	
	-- update reply count
	UPDATE InstantKB_Tickets SET
	InstantKB_Tickets.TicketReplies = (
	SELECT COUNT(TicketReplyID) FROM InstantKB_TicketReplies 
	WHERE InstantKB_TicketReplies.TicketID = @intTicketID)
	WHERE InstantKB_Tickets.TicketID = @intTicketID

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_TicketReplies SET
	TicketText = @strTicketText,
	TicketReplyTimeWorked = @intTicketTimeWorked,
	TicketReplyChannel = @intTicketReplyChannel,
	TicketReplyChannelMsgID = @strTicketReplyChannelMsgID,
	TicketModifiedUserID = @intTicketReplyUserID,
	TicketReplyWorkFlowStepID = @intTicketWorkFlowStepID,
	TickedModifiedDate = GETDATE()
	WHERE InstantKB_TicketReplies.TicketReplyID = @intTicketReplyID

	-- return the identity
	SET @intIdentity = @intTicketReplyID

END

IF (@intTicketID > 0)
BEGIN

	IF (@intTicketWorkFlowStepID > 0) 
	BEGIN
		UPDATE InstantKB_Tickets SET
		InstantKB_Tickets.TicketWorkflowStepID  = @intTicketWorkFlowStepID
		WHERE TicketID = @intTicketID;	
	END
	
	-- update total time worked
	IF (@intTicketTimeWorked > 0)
	BEGIN
		DECLARE @intMinutes int
		SET @intMinutes = (SELECT TicketTimeWorked FROM InstantKB_Tickets WHERE TicketID = @intTicketID)
		UPDATE InstantKB_Tickets SET
		InstantKB_Tickets.TicketTimeWorked = (@intMinutes + @intTicketTimeWorked)
		WHERE TicketID = @intTicketID;
	END

	-- update main ticket
	UPDATE InstantKB_Tickets SET
	TicketIsStaffReply = @bolIsStaffReply,
	TicketModifiedUserID = @intTicketReplyUserID,
	TicketModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE UserID = @intTicketReplyUserID),
	TicketModifiedDate = GETDATE(),
	TicketClosedDate = NULL
	WHERE TicketID = @intTicketID;
		
END

RETURN

GO

----------------------

GO


CREATE PROCEDURE [ikb_sp_SelectCategory] (
@intUserID int,
@intCategoryID int
) AS
SET NOCOUNT ON 

/* Select categories that are associated with the same roles as user */
DECLARE @SQL nvarchar(2000)

SELECT @SQL = 'SELECT InstantKB_Categories.* FROM InstantKB_Categories (nolock) '

IF (@intCategoryID > 0) -- do we have a tab identity
BEGIN
	SELECT @SQL = @SQL + 'WHERE (InstantKB_Categories.CategoryID = ' + CAST(@intCategoryID AS nVarChar(15)) + ') '
END

-- should we enable the role check
IF (@intUserID >= 0)
BEGIN
	-- did we also search by tab
	IF (@intCategoryID > 0) 
	BEGIN
		SELECT @SQL = @SQL + 'AND '
	END
	ELSE
	BEGIN
		SELECT @SQL = @SQL + 'WHERE '
	END

	SELECT @SQL = @SQL + 'EXISTS (SELECT InstantKB_CategoryRoles.RoleID FROM InstantKB_CategoryRoles WHERE InstantKB_CategoryRoles.CategoryID = InstantKB_Categories.CategoryID AND InstantKB_CategoryRoles.RoleID IN '
	-- filter categories based on roles
	IF (@intUserID = 0) -- anonymous users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.AnonymousRole = 1)'
	END
	ELSE IF (@intUserID > 0) -- authenticated users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN
		InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantASP_UsersRoles.UserID = ' + CAST(@intUserID As nVarChar(15)) + '))'
	END	
	SELECT @SQL = @SQL + ') '
END

-- ensure we use sp_executesql to cache execution plan for dynamic query
EXECUTE sp_executesql @SQL

GO

----------------------

GO

ALTER PROCEDURE [ikb_sp_SelectStaff] 
AS

SET NOCOUNT ON 

DECLARE @intStaffRoleID int

-- select staff members from InstantASP_Users
SELECT 
	InstantASP_Users.UserID, 
	InstantASP_Users.Username,
	InstantKB_Users.IsOnCall,
	InstantASP_Users.APIKey
FROM
	 InstantKB_Users 
	INNER JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID
WHERE EXISTS (
	SELECT 
		RoleID 
	FROM 
		InstantASP_UsersRoles 
	WHERE  
		InstantASP_UsersRoles.UserID =  InstantASP_Users.UserID AND 
		InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles WHERE ModeratorRole = 1)
	)


