-- Upgrade InstantKB.NET 2.0.6 to InstantKB.NET 2010-1.

/**************************************************************
Alter Tables
**************************************************************/

-- add new columns to InstantASP_Users table

ALTER TABLE InstantASP_Users ADD Twitter 				NVARCHAR(150) DEFAULT('') NOT NULL ;
ALTER TABLE InstantASP_Users ADD Facebook 				NVARCHAR(150) DEFAULT('') NOT NULL ;
ALTER TABLE InstantASP_Users ADD MySpace 				NVARCHAR(150) DEFAULT('') NOT NULL ;
ALTER TABLE InstantASP_Users ADD YouTube 				NVARCHAR(150) DEFAULT('') NOT NULL ;
ALTER TABLE InstantASP_Users ADD UsernameEncoded 		NVARCHAR(155) DEFAULT('') NOT NULL ;
ALTER TABLE InstantASP_Users ADD OpenID 				NVARCHAR(255) DEFAULT('') NOT NULL ;
ALTER TABLE InstantASP_Users ADD PhotoImage 			NVARCHAR(255) DEFAULT('') NOT NULL ;
ALTER TABLE InstantASP_Users ADD LinkedIn 				NVARCHAR(255) DEFAULT('') NOT NULL ;
ALTER TABLE InstantASP_Users ADD UserLevelTitle 		NVARCHAR(255) DEFAULT('') NOT NULL ;
ALTER TABLE InstantASP_Users ADD UserLevelImageURL		NVARCHAR(255) DEFAULT('') NOT NULL ;

-- add tab setting column

ALTER TABLE InstantKB_Tabs ADD TabSettingsXML 				NTEXt ;

GO

PRINT 'Existing Tables Updated'

/**************************************************************
Add New Tables
**************************************************************/

----------------------------------------------------
-- InstantKB_SLAs
----------------------------------------------------
CREATE TABLE InstantKB_SLAs
(
SLAID								INT IDENTITY(1,1) NOT NULL,
SLATabID							INT DEFAULT (0) NOT NULL,
SLAName								NVARCHAR(255) DEFAULT (N'') NOT NULL,
SLADesc								NVARCHAR(500) DEFAULT (N'') NOT NULL,
SLAResponseTime                     INT DEFAULT (24) NOT NULL,
SLAOverdueTime                      INT DEFAULT (24) NOT NULL,
SLAFilterStatusIDs		            NVARCHAR(255) DEFAULT (N'') NOT NULL,
SLAFilterPriorityIDs 				NVARCHAR(255) DEFAULT (N'') NOT NULL,
SLAFilterDeptID 					INT DEFAULT(0) NOT NULL,
SLASortOrder						INT DEFAULT(0) NOT NULL
CONSTRAINT PK_InstantKB_SLAs_SLAID PRIMARY KEY CLUSTERED ( SLAID )
)

----------------------------------------------------
-- InstantKB_Alerts
----------------------------------------------------
CREATE TABLE InstantKB_Alerts
(
AlertID								INT IDENTITY(1,1) NOT NULL,
AlertTabID							INT DEFAULT (0) NOT NULL,
AlertUserID							INT DEFAULT (0) NOT NULL,
AlertName							NVARCHAR(255) DEFAULT (N'') NOT NULL,
AlertConditionsXML                  NTEXT,
AlertSortOrder						INT DEFAULT(0) NOT NULL
CONSTRAINT PK_InstantKB_Alerts_AlertID PRIMARY KEY CLUSTERED ( AlertID )
)

----------------------------------------------------
-- InstantKB_StandardReplies
----------------------------------------------------
CREATE TABLE InstantKB_StandardReplies
(
ReplyID								INT IDENTITY(1,1) NOT NULL,
ReplyTabID							INT DEFAULT (0) NOT NULL,
ReplyUserID							INT DEFAULT (0) NOT NULL,
ReplyIsPublic						BIT DEFAULT (0) NOT NULL,
ReplyName							NVARCHAR(255) DEFAULT (N'') NOT NULL,
ReplyText                 			NTEXT,
ReplySortOrder						INT DEFAULT(0) NOT NULL
CONSTRAINT PK_InstantKB_StandardReplies_ReplyID PRIMARY KEY CLUSTERED ( ReplyID )
)

----------------------------------------------------
-- InstantKB_Rules
----------------------------------------------------
CREATE TABLE InstantKB_Rules
(
RuleID								INT IDENTITY(1,1) NOT NULL,
RuleTabID							INT DEFAULT (0) NOT NULL,
RuleUserID							INT DEFAULT (0) NOT NULL,
RuleName							NVARCHAR(255) DEFAULT (N'') NOT NULL,
RuleDesc							NVARCHAR(500) DEFAULT (N'') NOT NULL,
RuleScope							INT DEFAULT (0) NOT NULL,
RuleConditionsXML					NTEXT,
RuleActionsXML						NTEXT,
IsEscalationRule 					BIT DEFAULT (0) NOT NULL,
IsAlter			 					BIT DEFAULT (0) NOT NULL,
IsPublic							BIT DEFAULT (0) NOT NULL,
IsEnabled							BIT DEFAULT (0) NOT NULL,
RuleSortOrder						INT
CONSTRAINT PK_InstantKB_Rules_RuleID PRIMARY KEY CLUSTERED ( RuleID )
)

----------------------------------------------------
-- InstantKB_Rules
----------------------------------------------------
CREATE TABLE InstantKB_Tickets
(
TicketID							INT IDENTITY(1,1) NOT NULL,
TicketTabID							INT DEFAULT (0) NOT NULL,
TicketSLAID							INT DEFAULT (0) NOT NULL,
TicketToUserID						INT DEFAULT (0) NOT NULL,
TicketToEmail						NVARCHAR(255) DEFAULT (N'') NOT NULL,
TicketTitle							NVARCHAR(255) DEFAULT (N'') NOT NULL,
TicketText							NTEXT,
TicketStatusID						INT DEFAULT (0) NOT NULL,
TicketPriorityID					INT DEFAULT (0) NOT NULL,
TicketTypeID						INT DEFAULT (0) NOT NULL,
TicketDeptID						INT DEFAULT (0) NOT NULL,
TicketWorkflowStepID				INT DEFAULT (0) NOT NULL,
TicketCategoryID					INT DEFAULT (0) NOT NULL,
TicketAttachmentCount				INT DEFAULT (0) NOT NULL,
TicketCreatedDate					DATETIME DEFAULT (getdate()) NOT NULL,
TicketCreatedUserID 				INT DEFAULT (0) NOT NULL,
TicketCreatedUsername  				NVARCHAR(255) DEFAULT (N'') NOT NULL,
TicketCreatedEmail   				NVARCHAR(255) DEFAULT (N'') NOT NULL,
TicketModifiedUserID   				INT DEFAULT (0) NOT NULL,
TicketModifiedUsername  			NVARCHAR(255) DEFAULT (N'') NOT NULL,
TicketModifiedDate					DATETIME,
TicketAssignedUserID				INT DEFAULT (0) NOT NULL,
TicketAssignedDate					DATETIME,
TicketTimeWorked					INT DEFAULT (0) NOT NULL,
TicketPercentComplete				INT DEFAULT (0) NOT NULL,
TicketAssignedUsername				NVARCHAR(255) DEFAULT (N'') NOT NULL,
TicketViews							INT DEFAULT (0) NOT NULL,
TicketReplies						INT DEFAULT (0) NOT NULL,
TicketFlagged						BIT DEFAULT (0) NOT NULL,
TicketMoved							BIT DEFAULT (0) NOT NULL,
TicketOverdue						BIT DEFAULT (0) NOT NULL,
TicketImage							NVARCHAR(255) DEFAULT (N'') NOT NULL,
TicketAttachment1   				NVARCHAR(255) DEFAULT (N'') NOT NULL,
TicketAttachment2   				NVARCHAR(255) DEFAULT (N'') NOT NULL,
TicketIsStaffReply					BIT DEFAULT (0) NOT NULL,
TicketDueDate						DATETIME,
TicketClosedDate					DATETIME,
TicketIsEscalated					BIT DEFAULT (0) NOT NULL

CONSTRAINT PK_InstantKB_Tickets_TicketID PRIMARY KEY CLUSTERED ( TicketID )
)

----------------------------------------------------
-- InstantKB_TicketReplies
----------------------------------------------------
CREATE TABLE InstantKB_TicketReplies
(
TicketReplyID						INT IDENTITY(1,1) NOT NULL,
TicketID							INT DEFAULT (0) NOT NULL,
TicketText							NTEXT,
TicketReplyUserID					INT DEFAULT (0) NOT NULL,
TicketReplyCreatedDate				DATETIME DEFAULT (getdate()) NOT NULL,
TicketModifiedUserID				INT DEFAULT (0) NOT NULL,
TicketReplyIsStaff					BIT DEFAULT (0) NOT NULL,
TickedModifiedDate					DATETIME
CONSTRAINT PK_InstantKB_TicketReplies_TicketReplyID PRIMARY KEY CLUSTERED ( TicketReplyID )
)


----------------------------------------------------
-- InstantKB_TicketNotes
----------------------------------------------------
CREATE TABLE InstantKB_TicketNotes
(
TicketNoteID						INT IDENTITY(1,1) NOT NULL,
TicketID							INT DEFAULT (0) NOT NULL,
NoteText							NTEXT,
NoteUserID							INT DEFAULT (0) NOT NULL,
NoteDate							DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantKB_TicketNotes_TicketNoteID PRIMARY KEY CLUSTERED ( TicketNoteID )
)

PRINT 'New Tables Created'

----------------------------------------------------
-- InstantKB_ArticleCustomFields
----------------------------------------------------
CREATE TABLE InstantKB_TicketCustomFields
(
TicketID                           INT NOT NULL,
CONSTRAINT PK_InstantKB_TicketCustomFields PRIMARY KEY CLUSTERED ( TicketID )
)

GO

PRINT 'New Indexes Created'

/**************************************************************
New Stored Procedures
**************************************************************/

/****** Object:  StoredProcedure [ikb_sp_InsertUpdateAlert] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_InsertUpdateAlert] (
@intAlertID int,
@intAlertTabID int,
@intAlertUserID int,
@strAlertName nvarchar(255),
@strAlertConditionsXML ntext,
@intAlertSortOrder int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a Alert within InstantKB_Alerts */

-- is this an update or insert?
IF (@intAlertID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Alerts (
	AlertTabID,
	AlertUserID,
	AlertName,
	AlertConditionsXML,
	AlertSortOrder
	) 
	VALUES (
	@intAlertTabID,
	@intAlertUserID,
	@strAlertName,
	@strAlertConditionsXML,
	@intAlertSortOrder
	)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Alerts SET
	AlertTabID = @intAlertTabID ,
	AlertUserID = @intAlertUserID,
	AlertName = @strAlertName,
	AlertConditionsXML =  @strAlertConditionsXML,
	AlertSortOrder = @intAlertSortOrder
	WHERE InstantKB_Alerts.AlertID = @intAlertID

	-- return the identity
	SET @intIdentity = @intAlertID
	RETURN

END

SET @intIdentity = 0
RETURN


GO



/****** Object:  StoredProcedure [ikb_sp_UpdateTicketIsEscalated] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_UpdateTicketIsEscalated] (
@intTicketID int,
@bolOperator bit
)
AS
SET NOCOUNT ON 

/* Ensure we have a ticket identity */
IF (@intTicketID > 0)
BEGIN
	/* Increments article view count */
	UPDATE InstantKB_Tickets SET 
	InstantKB_Tickets.TicketIsEscalated = @bolOperator 
	WHERE (InstantKB_Tickets.TicketID = @intTicketID)
END

GO

/****** Object:  StoredProcedure [[ikb_sp_UpdateTicketFlagged]]    Script Date: 09/28/2010 23:51:35 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_UpdateTicketFlagged] (
@intTicketID int,
@bolOperator bit
)
AS
SET NOCOUNT ON 

/* Ensure we have a ticket identity */
IF (@intTicketID > 0)
BEGIN
	/* Increments article view count */
	UPDATE InstantKB_Tickets SET 
	InstantKB_Tickets.TicketFlagged = @bolOperator 
	WHERE (InstantKB_Tickets.TicketID = @intTicketID)
END

GO





/****** Object:  StoredProcedure [ikb_sp_UpdateTicketViews]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_UpdateTicketViews] (
@intTicketID int,
@intOperator int
)
AS
SET NOCOUNT ON 

/* Ensure we have a ticket identity */
IF (@intTicketID > 0)
BEGIN
	/* Increments article view count */
	UPDATE InstantKB_Tickets SET 
	InstantKB_Tickets.TicketViews = (InstantKB_Tickets.TicketViews + @intOperator)
	WHERE (InstantKB_Tickets.TicketID = @intTicketID)
END

RETURN 

GO


/****** Object:  StoredProcedure [ikb_sp_InsertUpdateStandardReply]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_InsertUpdateStandardReply] (
@intReplyID int,
@intReplyTabID int,
@intReplyUserID int,
@strReplyName nvarchar(255),
@strReplyText ntext,
@bolReplyIsPublic bit,
@intReplySortOrder int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a Reply within InstantKB_Replys */

-- is this an update or insert?
IF (@intReplyID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_StandardReplies (
	ReplyTabID,
	ReplyUserID,
	ReplyName,
	ReplyText,
	ReplyIsPublic,
	ReplySortOrder
	) 
	VALUES (
	@intReplyTabID,
	@intReplyUserID,
	@strReplyName,
	@strReplyText,
	@bolReplyIsPublic,
	@intReplySortOrder
	)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_StandardReplies SET
	ReplyTabID = @intReplyTabID ,
	ReplyUserID = @intReplyUserID,
	ReplyName = @strReplyName,
	ReplyText =  @strReplyText,
	ReplyIsPublic =  @bolReplyIsPublic,
	ReplySortOrder = @intReplySortOrder
	WHERE InstantKB_StandardReplies.ReplyID = @intReplyID

	-- return the identity
	SET @intIdentity = @intReplyID
	RETURN

END

SET @intIdentity = 0
RETURN


GO

/****** Object:  StoredProcedure [ikb_sp_DeleteArticle] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_DeleteAlert] (
@intAlertID int
) AS
SET NOCOUNT ON 

/* Delete an alert from InstantKB_Alerts */
DELETE FROM InstantKB_Alerts WHERE (InstantKB_Alerts.AlertID  = @intAlertID)

RETURN

GO


/****** Object:  StoredProcedure [ikb_sp_UpdateStandardReplySortOrder] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_UpdateStandardReplySortOrder] (
@intReplyID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a standard reply sort order within InstantKB_StandardReplies */

UPDATE InstantKB_StandardReplies SET ReplySortOrder = @intSortOrder WHERE (InstantKB_StandardReplies.ReplyID = @intReplyID)

RETURN

GO

/****** Object:  StoredProcedure [ikb_sp_UpdateAlertSortOrder] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_UpdateAlertSortOrder] (
@intAlertID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a alert sort order within InstantKB_Alerts */

UPDATE InstantKB_Alerts SET AlertSortOrder = @intSortOrder WHERE (InstantKB_Alerts.AlertID = @intAlertID)

RETURN

GO

/****** Object:  StoredProcedure [ikb_sp_SelectRules]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_SelectAlerts] (
@intUserID int
) AS
SET NOCOUNT ON 
/* Select alerts */

IF (@intUserID > 0) 
BEGIN

	SELECT InstantKB_Alerts.*, 
	InstantASP_Users.Username, 
	InstantASP_Users.EmailAddress 
	FROM InstantKB_Alerts (nolock)
	INNER JOIN
    InstantASP_Users ON InstantKB_Alerts.AlertUserID = InstantASP_Users.UserID
	WHERE InstantKB_Alerts.AlertUserID = @intUserID 
	ORDER BY AlertSortOrder ASC
	
END
ELSE
BEGIN
	SELECT InstantKB_Alerts.*, 
	InstantASP_Users.Username, 
	InstantASP_Users.EmailAddress 
	FROM InstantKB_Alerts (nolock) 
	INNER JOIN
    InstantASP_Users ON InstantKB_Alerts.AlertUserID = InstantASP_Users.UserID	
	ORDER BY AlertSortOrder ASC
END

RETURN
GO

/****** Object:  StoredProcedure [ikb_sp_SelectStandardReplies]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_SelectStandardReplies] (
@intUserID int
) AS
SET NOCOUNT ON 
/* Select alerts */

IF (@intUserID > 0) 
BEGIN
	SELECT * FROM InstantKB_StandardReplies (nolock) WHERE InstantKB_StandardReplies.ReplyUserID = @intUserID ORDER BY ReplySortOrder ASC
END
ELSE
BEGIN
	SELECT * FROM InstantKB_StandardReplies (nolock)   ORDER BY ReplySortOrder ASC
END

RETURN

GO

/****** Object:  StoredProcedure [ikb_sp_SelectRules] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_SelectRules] 
AS
SET NOCOUNT ON 
/* Select application settings */
SELECT * FROM InstantKB_Rules (nolock) ORDER BY RuleSortOrder ASC

GO

/****** Object:  StoredProcedure [[ikb_sp_DeleteRule]] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_DeleteRule] (
@intRuleID int
) AS
SET NOCOUNT ON 

/* Deletes a rule from the InstantKB_Rules  table */

DELETE FROM InstantKB_Rules WHERE (InstantKB_Rules.RuleID = @intRuleID)

RETURN

/****** Object:  StoredProcedure [ikb_sp_SelectSLAs] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_SelectSLAs] 
AS
SET NOCOUNT ON 
/* Select application settings */
SELECT * FROM InstantKB_SLAs (nolock) ORDER BY SLASortOrder ASC

GO





/****** Object:  StoredProcedure [ikb_sp_DeleteTicket] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_DeleteTicket] (
@intTicketID int
) AS
SET NOCOUNT ON 

/* Deletes a ticket from InstantKB_Priorities  table */

DELETE FROM InstantKB_Tickets WHERE (InstantKB_Tickets.TicketId = @intTicketID)
DELETE FROM InstantKB_TicketReplies WHERE (InstantKB_TicketReplies.TicketId = @intTicketID)

RETURN

GO


/****** Object:  StoredProcedure [ikb_sp_DeleteTicketReply] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_DeleteTicketReply] (
@intTicketReplyID int
) AS
SET NOCOUNT ON 

/* Deletes a ticket from InstantKB_Priorities  table */

DECLARE @intTicketID int
SET @intTicketID = (SELECT TicketID FROM InstantKB_TicketReplies WHERE (InstantKB_TicketReplies.TicketReplyID = @intTicketReplyID))

DELETE FROM InstantKB_TicketReplies 
WHERE (InstantKB_TicketReplies.TicketReplyID = @intTicketReplyID)

UPDATE InstantKB_Tickets 
SET TicketReplies = (SELECT COUNT(TicketID)FROM InstantKB_TicketReplies WHERE TicketID = @intTicketID)
WHERE TicketID = @intTicketID

RETURN

GO


/****** Object:  StoredProcedure [ikb_sp_InsertUpdateTicket]   ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_InsertUpdateTicket] (
@intTicketID int,
@intTicketTabID int,
@intTicketSLAID int,
@intTicketToUserID int,
@strTicketToEmail nvarchar(255),
@strTicketTitle nvarchar(255),
@strTicketText ntext,
@intTicketStatusID int,
@intTicketPriorityID int,
@intTicketTypeID int,
@intTicketDeptID int,
@intTicketCategoryID int,
@intTicketWorkflowStepID int,
@intTicketCreatedUserID int,
@strTicketCreatedUsername nvarchar(255),
@strTicketCreatedEmailAddress nvarchar(255),
@intTicketModifiedUserID int,
@intTicketAssignedUserID int,
@strTicketAttachment1 nvarchar(255),
@strTicketAttachment2 nvarchar(255),
@intTicketTimeWorked int,
@intTicketPercentComplete int,
@strTicketImage nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a article within the InstantKB_Articles table */

DECLARE @bolIsStaffReply bit
SET @bolIsStaffReply = 0
	
DECLARE @strCreatedEmail nvarchar(255)
DECLARE @strModifiedUsername nvarchar(255)
DECLARE @strCreatedUsername nvarchar(255)
DECLARE @strAssignedUsername nvarchar(255)

if (@intTicketCreatedUserID > 0) 
BEGIN
	SET @strCreatedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketCreatedUserID))
	SET @strCreatedEmail = (SELECT EmailAddress FROM InstantASP_Users WHERE (UserID = @intTicketCreatedUserID))
	-- check if staff
	IF EXISTS(SELECT InstantASP_Users.UserID, InstantASP_UsersRoles.RoleID   FROM InstantASP_Users 
	INNER JOIN InstantASP_UsersRoles ON InstantASP_Users.UserID = InstantASP_UsersRoles.UserID 
	WHERE InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles 
	WHERE InstantASP_Roles.AdministratorRole  = 1 or InstantASP_Roles.ModeratorRole = 1)
	AND InstantASP_Users.UserID = @intTicketCreatedUserID)
	BEGIN
		SET @bolIsStaffReply = 1
	END
END
ELSE
BEGIN
	SET @strCreatedUsername = @strTicketCreatedUsername
	SET @strCreatedEmail = @strTicketCreatedEmailAddress
END

IF (@intTicketAssignedUserID > 0)
BEGIN	
	SET @strAssignedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketAssignedUserID))
END
ELSE
BEGIN
	SET @strAssignedUsername = '';
END

IF (@intTicketModifiedUserID > 0)
BEGIN
	SET @strModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intTicketModifiedUserID))
END
ELSE
BEGIN
	SET @strModifiedUsername = @strCreatedUsername;
END
		
-- is this an update or insert?
IF (@intTicketID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Tickets 
		(
		TicketTabID,
		TicketSLAID,
		TicketToUserID,
		TicketToEmail,
		TicketTitle, 
		TicketText,
		TicketStatusID, 
		TicketPriorityID, 
		TicketDeptID, 
		TicketTypeID, 
		TicketCategoryID,
		TicketWorkflowStepID, 
		TicketCreatedDate, 
		TicketCreatedUserID, 
		TicketCreatedUsername, 
		TicketCreatedEmail, 
		TicketModifiedUserID, 
		TicketModifiedUsername,
		TicketModifiedDate, 	
		TicketAttachment1,
		TicketAttachment2,
		TicketIsStaffReply,
		TicketTimeWorked,
		TicketPercentComplete,
		TicketImage
		)		
	VALUES 		(
		@intTicketTabID,
		@intTicketSLAID,
		@intTicketToUserID,
		@strTicketToEmail,
		@strTicketTitle,
		@strTicketText,
		@intTicketStatusID,
		@intTicketPriorityID,
		@intTicketDeptID,
		@intTicketTypeID,	
		@intTicketCategoryID,
		@intTicketWorkflowStepID,
		getdate(),
		@intTicketCreatedUserID,
		@strCreatedUsername,
		@strCreatedEmail,
		@intTicketModifiedUserID,
		@strModifiedUsername,
		getdate(),
		@strTicketAttachment1,
		@strTicketAttachment2,
		@bolIsStaffReply,
		@intTicketTimeWorked,
		@intTicketPercentComplete,
		@strTicketImage
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Tickets SET
	TicketTitle = @strTicketTitle,
	TicketSLAID = @intTicketSLAID,
	TicketText = @strTicketText,
	TicketStatusID = @intTicketStatusID,
	TicketPriorityID = @intTicketPriorityID,
	TicketTypeID = 	@intTicketTypeID,
	TicketDeptID = @intTicketDeptID,
	TicketCategoryID = 	@intTicketCategoryID,
	TicketWorkflowStepID =	@intTicketWorkflowStepID,
	TicketModifiedUserID = @intTicketModifiedUserID,
	TicketModifiedDate = getdate(),
	TicketModifiedUsername = @strModifiedUsername,	
	TicketAttachment1 = @strTicketAttachment1,
	TicketAttachment2 = @strTicketAttachment2,
	TicketTimeWorked = @intTicketTimeWorked,
	TicketPercentComplete = @intTicketPercentComplete,
	TicketImage = @strTicketImage
	WHERE InstantKB_Tickets.TicketID = @intTicketID

	-- return the identity
	SET @intIdentity = @intTicketID

END

-- so we have an assigned user?
IF (@strAssignedUsername <> '') 
BEGIN
	-- ensure we only update if information has changed
	DECLARE @intCurrentAssignedUserID int
	SET @intCurrentAssignedUserID = (SELECT TicketAssignedUserID FROM InstantKB_Tickets WHERE InstantKB_Tickets.TicketID = @intIdentity)
	IF (@intCurrentAssignedUserID <> @intTicketAssignedUserID)
	BEGIN	
		UPDATE InstantKB_Tickets SET 
		TicketAssignedUserID = 	@intTicketAssignedUserID,
		TicketAssignedUsername = @strAssignedUsername,
		TicketAssignedDate = 	GETDATE()
		WHERE InstantKB_Tickets.TicketID = @intIdentity
	END
END
	
-- do we have an SLA?

if (@intTicketSLAID > 0) 
BEGIN
	DECLARE @intOverdueHours int
	SET @intOverdueHours = (SELECT SLAOverdueTime FROM InstantKB_SLAs WHERE InstantKB_SLAs.SLAID = @intTicketSLAID)
	IF (@intOverdueHours > 0) 
	BEGIN
		UPDATE InstantKB_Tickets SET
		TicketDueDate =  DATEADD(hh,@intOverdueHours,getdate()),
		TicketIsEscalated = 0
		WHERE InstantKB_Tickets.TicketID = @intIdentity

	END
	ELSE
	BEGIN
		UPDATE InstantKB_Tickets SET
		TicketDueDate = NULL
		WHERE InstantKB_Tickets.TicketID = @intIdentity
	END
END
	
RETURN


/****** Object:  StoredProcedure [ikb_sp_DeleteSLA] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_DeleteSLA] (
@intSLAID int
) AS
SET NOCOUNT ON 

/* Deletes a rule from the InstantKB_Rules  table */

DELETE FROM InstantKB_SLAs WHERE (InstantKB_SLAs.SLAID = @intSLAID)

RETURN

/****** Object:  StoredProcedure [ikb_sp_InsertUpdateTicketReply] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_InsertUpdateTicketReply] (
@intTicketReplyID int,
@intTicketID int,
@intTicketWorkFlowStepID int,
@intTicketReplyUserID int,
@strTicketText ntext,
@intTicketTimeWorked int,
@intIdentity int output
) AS

SET NOCOUNT ON 

DECLARE @bolIsStaffReply bit
SET @bolIsStaffReply = 0
IF (@intTicketReplyUserID > 0)
BEGIN
	IF EXISTS(SELECT InstantASP_Users.UserID, InstantASP_UsersRoles.RoleID   FROM InstantASP_Users 
	INNER JOIN InstantASP_UsersRoles ON InstantASP_Users.UserID = InstantASP_UsersRoles.UserID 
	WHERE InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles 
	WHERE InstantASP_Roles.AdministratorRole  = 1 or InstantASP_Roles.ModeratorRole = 1)
	AND InstantASP_Users.UserID = @intTicketReplyUserID)
	BEGIN
		SET @bolIsStaffReply = 1
	END
END

-- is this an update or insert?
IF (@intTicketReplyID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_TicketReplies
		(
		TicketID, 
		TicketText,
		TicketReplyUserID,
		TicketReplyCreatedDate,
		TicketReplyIsStaff 

		)		
	VALUES 		(		
		@intTicketID,
		@strTicketText,
		@intTicketReplyUserID,
		GETDATE(),
		@bolIsStaffReply
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	
	-- update reply count
	UPDATE InstantKB_Tickets SET
	InstantKB_Tickets.TicketReplies = (
	SELECT COUNT(TicketReplyID) FROM InstantKB_TicketReplies 
	WHERE InstantKB_TicketReplies.TicketID = @intTicketID)
	WHERE InstantKB_Tickets.TicketID = @intTicketID

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_TicketReplies SET
	TicketText = @strTicketText,
	TicketModifiedUserID = @intTicketReplyUserID,
	TickedModifiedDate = GETDATE()
	WHERE InstantKB_TicketReplies.TicketReplyID = @intTicketReplyID

	-- return the identity
	SET @intIdentity = @intTicketReplyID

END

IF (@intTicketID > 0)
BEGIN

	IF (@intTicketWorkFlowStepID > 0) 
	BEGIN
		UPDATE InstantKB_Tickets SET
		InstantKB_Tickets.TicketWorkflowStepID  = @intTicketWorkFlowStepID
		WHERE TicketID = @intTicketID;	
	END
	
	-- update total time worked
	IF (@intTicketTimeWorked > 0)
	BEGIN
		DECLARE @intMinutes int
		SET @intMinutes = (SELECT TicketTimeWorked FROM InstantKB_Tickets WHERE TicketID = @intTicketID)
		UPDATE InstantKB_Tickets SET
		InstantKB_Tickets.TicketTimeWorked = (@intMinutes + @intTicketTimeWorked)
		WHERE TicketID = @intTicketID;
	END

	-- update staff reply flag for main ticket
	UPDATE InstantKB_Tickets SET
	InstantKB_Tickets.TicketIsStaffReply = @bolIsStaffReply,
	InstantKB_Tickets.TicketModifiedUserID = @intTicketReplyUserID,
	InstantKB_Tickets.TicketModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE UserID = @intTicketReplyUserID),
	InstantKB_Tickets.TicketModifiedDate = GETDATE()
	WHERE TicketID = @intTicketID;
	
	
END

RETURN


/****** Object:  StoredProcedure [ikb_sp_InsertUpdateTicketNote] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_InsertUpdateTicketNote] (
@intTicketNoteID int,
@intTicketID int,
@strNoteText ntext,
@intNoteUserID int,
@intIdentity int output
) AS

SET NOCOUNT ON 


-- is this an update or insert?
IF (@intTicketNoteID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_TicketNotes
		(
		TicketID, 
		NoteText,
		NoteUserID,
		NoteDate

		)		
	VALUES 		(		
		@intTicketID,
		@strNoteText,
		@intNoteUserID,
		GETDATE()
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	
END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_TicketNotes SET
	NoteText = @strNoteText,
	NoteUserID = @intNoteUserID
	WHERE InstantKB_TicketNotes.TicketNoteID = @intTicketNoteID

	-- return the identity
	SET @intIdentity = @intTicketNoteID

END

/****** Object:  StoredProcedure [ikb_sp_InsertUpdateSLA] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_InsertUpdateSLA] (
@intSLAID int,
@intSLATabID int,
@strSLAName nvarchar(255),
@strSLADesc nvarchar(500),
@intSLAAvgResponseTime int,
@intSLAOverdueTime int,
@intSLAFilterDeptID int,
@strSLAFilterStatusIDs nvarchar(255),
@strSLAFilterPriorityIDs nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

-- is this an update or insert?
IF (@intSLAID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_SLAs
		(
		SLATabID,
		SLAName,
		SLADesc,
		SLAResponseTime,
		SLAOverdueTime,
		SLAFilterDeptID,
		SLAFilterStatusIDs,
		SLAFilterPriorityIDs  

		)		
	VALUES 		(		
		@intSLATabID,
		@strSLAName,
		@strSLADesc,
		@intSLAAvgResponseTime,
		@intSLAOverdueTime,
		@intSLAFilterDeptID,
		@strSLAFilterStatusIDs,
		@strSLAFilterPriorityIDs
	)
	-- return the  new identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_SLAs SET
	SLATabID = @intSLATabID,
	SLAName = @strSLAName,
	SLADesc = @strSLADesc,
	SLAResponseTime = @intSLAAvgResponseTime,
	SLAOverdueTime = @intSLAOverdueTime,
	SLAFilterDeptID = @intSLAFilterDeptID,
	SLAFilterStatusIDs = @strSLAFilterStatusIDs,
	SLAFilterPriorityIDs = @strSLAFilterPriorityIDs
	WHERE InstantKB_SLAs.SLAID = @intSLAID

	-- return the identity
	SET @intIdentity = @intSLAID

END

RETURN


/****** Object:  StoredProcedure [[ikb_sp_InsertUpdateRule]]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_InsertUpdateRule] (
@intRuleID int,
@intRuleTabID int,
@intRuleUserID int,
@strRuleName nvarchar(255),
@strRuleDesc nvarchar(500),
@intRuleScope int,
@strRuleConditionsXML ntext,
@strRuleActionsXML ntext,
@bolIsEscalationRule bit,
@bolIsPublic bit,
@bolIsEnabled bit,
@intRuleSortOrder int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a rule within InstantKB_Rules */

-- is this an update or insert?
IF (@intRuleID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Rules (
	RuleTabID,
	RuleUserID,
	RuleName,
	Ruledesc,
	RuleScope,
	RuleConditionsXML,
	RuleActionsXML,
	IsEscalationRule,
	IsPublic,
	IsEnabled,
	RuleSortOrder
	) 
	VALUES (
	@intRuleTabID,
	@intRuleUserID,
	@strRuleName,
	@strRuleDesc,
	@intRuleScope,
	@strRuleConditionsXML,
	@strRuleActionsXML,
	@bolIsEscalationRule,
	@bolIsPublic,
	@bolIsEnabled,
	@intRuleSortOrder
	)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Rules SET
	RuleTabID = @intRuleTabID ,
	RuleUserID = @intRuleUserID,
	RuleName = @strRuleName,
	Ruledesc = @strRuleDesc,
	RuleScope = @intRuleScope,
	RuleConditionsXML =  @strRuleConditionsXML,
	RuleActionsXML = @strRuleActionsXML,
	IsEscalationRule = @bolIsEscalationRule,
	IsPublic = @bolIsPublic ,
	IsEnabled = @bolIsEnabled,
	RuleSortOrder = @intRuleSortOrder
	WHERE InstantKB_Rules.RuleID = @intRuleID

	-- return the identity
	SET @intIdentity = @intRuleID
	RETURN

END

SET @intIdentity = 0
RETURN



/****** Object:  StoredProcedure [ikb_sp_SelectStatisticsForTicketTab] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_SelectStatisticsForTicketTab] (
@intTabID int
)
AS

SET NOCOUNT ON 

DECLARE @intPendingTickets int
DECLARE @intOverdueTickets int
DECLARE @EscalatedTickets int
DECLARE @intTotalTickets int

SET @intPendingTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets (nolock) WHERE (InstantKB_Tickets.TicketIsStaffReply  = 0 AND TicketTabID = @intTabID))
SET @intOverdueTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets (nolock) WHERE ((InstantKB_Tickets.TicketDueDate IS NOT NULL AND InstantKB_Tickets.TicketDueDate <= GETDATE())  AND TicketTabID = @intTabID))
SET @EscalatedTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets (nolock) WHERE (InstantKB_Tickets.TicketIsEscalated = 1  AND TicketTabID = @intTabID))
SET @intTotalTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets (nolock) WHERE (TicketTabID = @intTabID))

SELECT
@intPendingTickets As PendingTickets,
@intOverdueTickets AS OverdueTickets,
@EscalatedTickets AS EscalatedTickets,
@intTotalTickets AS TotalTickets

RETURN 

GO


/****** Object:  StoredProcedure [ikb_sp_UpdateRuleSortOrder]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_UpdateRuleSortOrder] (
@intRuleID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a rule sort order within InstantKB_Rules */

UPDATE InstantKB_Rules SET RuleSortOrder = @intSortOrder WHERE (InstantKB_Rules.RuleID = @intRuleID)

RETURN



/****** Object:  StoredProcedure [ikb_sp_UpdateSLASortOrder]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_UpdateSLASortOrder] (
@intSLAID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a rule sort order within InstantKB_Rules */

UPDATE InstantKB_SLAs SET SLASortOrder = @intSortOrder WHERE (InstantKB_SLAs.SLAID = @intSLAID)

RETURN


/****** Object:  StoredProcedure [[ikb_sp_SelectTicketsPaged]] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_SelectTicketsPaged] (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit,
@strSQLFullTextMaxRank nvarchar(4000)
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
IF (@intRowsToReturn > 0) 
BEGIN
	SET ROWCOUNT @intRowsToReturn
END

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex

-- set upperbound only if we have a pagesize
IF (@intRowsToReturn > 0) 
BEGIN
	SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1
END
ELSE
BEGIN
	SET @intPageUpperBound = (SELECT COUNT(TicketID) FROM InstantKB_Tickets)
END

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	TicketID int, Rank int, MaxRank int, SortBy sql_variant
)

-- insert data 
INSERT INTO #PageIndex (TicketID, Rank, SortBy)
EXECUTE sp_executesql @strSQLPopulate

-- do we need to return our full text max rank
DECLARE @intMaxRank int
IF (@strSQLFullTextMaxRank <> '')
BEGIN

	-- insert full text max rank
	INSERT INTO #PageIndex (MaxRank)
	EXECUTE sp_executesql @strSQLFullTextMaxRank
	-- set max rank
	SET @intMaxRank = (SELECT MaxRank FROM #PageIndex WHERE #PageIndex.IndexID = @@IDENTITY)
	DELETE FROM #PageIndex WHERE #PageIndex.IndexID = @@IDENTITY
	UPDATE #PageIndex SET MaxRank = @intMaxRank

END

-- select the data to return
SELECT IPI.Rank, IPI.MaxRank, InstantKB_Tickets.*, InstantKB_TicketCustomFields.*, InstantKB_Types.*, InstantKB_Status.*, InstantKB_Priorities.*,  InstantKB_WorkFlowSteps.* FROM #PageIndex IPI 
LEFT OUTER JOIN InstantKB_Tickets ON InstantKB_Tickets.TicketID = IPI.TicketID  
LEFT OUTER JOIN InstantKB_Types ON InstantKB_Tickets.TicketTypeID = InstantKB_Types.TypeID 
LEFT OUTER JOIN InstantKB_WorkFlowSteps ON InstantKB_Tickets.TicketWorkFlowStepID = InstantKB_WorkFlowSteps.WorkFlowStepID 
LEFT OUTER JOIN InstantKB_Priorities ON InstantKB_Tickets.TicketPriorityID = InstantKB_Priorities.PriorityID 
LEFT OUTER JOIN InstantKB_Status ON InstantKB_Tickets.TicketStatusID = InstantKB_Status.StatusID 
LEFT OUTER JOIN InstantKB_TicketCustomFields ON InstantKB_Tickets.TicketID = InstantKB_TicketCustomFields.TicketID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount

GO



/****** Object:  StoredProcedure [iasp_sp_SelectUserData] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [ikb_sp_SelectTicket] (
@intTicketID int
) AS

SET NOCOUNT ON 

SELECT InstantKB_Tickets.*, InstantKB_TicketCustomFields.*, InstantKB_Types.*, InstantKB_Status.*, InstantKB_Priorities.*,  InstantKB_WorkFlowSteps.*, 0 As Rank, 0 AS MaxRank FROM InstantKB_Tickets
LEFT OUTER JOIN InstantKB_Types ON InstantKB_Tickets.TicketTypeID = InstantKB_Types.TypeID 
LEFT OUTER JOIN InstantKB_WorkFlowSteps ON InstantKB_Tickets.TicketWorkFlowStepID = InstantKB_WorkFlowSteps.WorkFlowStepID 
LEFT OUTER JOIN InstantKB_Priorities ON InstantKB_Tickets.TicketPriorityID = InstantKB_Priorities.PriorityID 
LEFT OUTER JOIN InstantKB_Status ON InstantKB_Tickets.TicketStatusID = InstantKB_Status.StatusID 
LEFT OUTER JOIN InstantKB_TicketCustomFields ON InstantKB_Tickets.TicketID = InstantKB_TicketCustomFields.TicketID
WHERE InstantKB_Tickets.TicketID = @intTicketID

SELECT InstantKB_TicketReplies.*,
InstantASP_Users.UserID,
InstantASP_Users.Username,
InstantASP_Users.OpenID,
InstantKB_Users.[Signature],
(SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName 
 FROM InstantKB_TicketReplies 
LEFT  OUTER JOIN InstantASP_Users ON InstantKB_TicketReplies.TicketReplyUserID = InstantASP_Users.UserID 
LEFT  OUTER JOIN InstantKB_Users ON InstantKB_TicketReplies.TicketReplyUserID = InstantKB_Users.UserID 
WHERE TicketID = @intTicketID
ORDER BY InstantKB_TicketReplies.TicketReplyCreatedDate ASC

RETURN 

GO




/****** Object:  StoredProcedure [ikb_sp_UpdateArticleAttachmentCount]    Script Date: 09/26/2010 13:31:05 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_UpdateTicketAttachmentCount] (
@intTicketID int,
@intOperator int
)
AS
SET NOCOUNT ON 

/* Ensure we have a ticket identity */
IF (@intTicketID > 0)
BEGIN
	/* Increments article view count */
	UPDATE InstantKB_Tickets SET InstantKB_Tickets.TicketAttachmentCount =  InstantKB_Tickets.TicketAttachmentCount  + @intOperator WHERE (InstantKB_Tickets.TicketID = @intTicketID)
END

RETURN 

GO


/****** Object:  StoredProcedure [ikb_sp_UpdateTicketStatus]******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_UpdateTicketStatus] (
@intTicketID int,
@intStatusID int
)
AS
SET NOCOUNT ON 


/* Increments article view count */
UPDATE InstantKB_Tickets 
SET InstantKB_Tickets.TicketStatusID = @intStatusID
WHERE (InstantKB_Tickets.TicketID = @intTicketID)

RETURN 

GO



/****** Object:  StoredProcedure [ikb_sp_UpdateTicketPriority] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_UpdateTicketPriority] (
@intTicketID int,
@intPriorityID int
)
AS
SET NOCOUNT ON 


/* Increments article view count */
UPDATE InstantKB_Tickets 
SET InstantKB_Tickets.TicketPriorityID = @intPriorityID
WHERE (InstantKB_Tickets.TicketID = @intTicketID)

RETURN

GO

/****** Object:  StoredProcedure [ikb_sp_SelectTicketNotes]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [ikb_sp_SelectTicketNotes] (
@intTicketID int,
@intTabID int,
@intUserID int,
@strEmailAddress nvarchar(255)
)
AS


SET NOCOUNT ON 

/* select ticket notes */

IF (@strEmailAddress <> '') 
BEGIN

	IF (@intTabID > 0) 
	BEGIN
	
		SELECT 
		InstantKB_TicketNotes.TicketNoteID, 
		InstantKB_TicketNotes.TicketID, 
		InstantKB_TicketNotes.NoteText, 
		InstantKB_TicketNotes.NoteDate,
		InstantASP_Users.UserID, 
		InstantASP_Users.OpenID, 
		InstantASP_Users.Username
		FROM  
		InstantKB_TicketNotes 
		INNER JOIN
		InstantKB_Tickets ON InstantKB_TicketNotes.TicketID = InstantKB_Tickets.TicketID 
		LEFT OUTER JOIN
		InstantASP_Users ON InstantKB_TicketNotes.NoteUserID = InstantASP_Users.UserID
		WHERE (InstantKB_Tickets.TicketToEmail = @strEmailAddress OR 
		InstantKB_Tickets.TicketCreatedEmail = @strEmailAddress) AND (InstantKB_Tickets.TicketTabID = @intTabID)
	
	END
	ELSE
	BEGIN
	
		SELECT 
		InstantKB_TicketNotes.TicketNoteID, 
		InstantKB_TicketNotes.TicketID, 
		InstantKB_TicketNotes.NoteText, 
		InstantKB_TicketNotes.NoteDate,
		InstantASP_Users.UserID, 
		InstantASP_Users.OpenID, 
		InstantASP_Users.Username
		FROM  
		InstantKB_TicketNotes 
		INNER JOIN
		InstantKB_Tickets ON InstantKB_TicketNotes.TicketID = InstantKB_Tickets.TicketID 
		LEFT OUTER JOIN
		InstantASP_Users ON InstantKB_TicketNotes.NoteUserID = InstantASP_Users.UserID
		WHERE (InstantKB_Tickets.TicketToEmail = @strEmailAddress OR 
		InstantKB_Tickets.TicketCreatedEmail = @strEmailAddress)
	
	END
	
END

IF (@intTicketID > 0) 
BEGIN

	SELECT 
	InstantKB_TicketNotes.TicketNoteID, 
	InstantKB_TicketNotes.TicketID, 
	InstantKB_TicketNotes.NoteText, 
	InstantKB_TicketNotes.NoteDate,
	InstantASP_Users.UserID, 
	InstantASP_Users.OpenID, 
	InstantASP_Users.Username
	FROM  
	InstantKB_TicketNotes 
	LEFT OUTER JOIN
	InstantASP_Users ON InstantKB_TicketNotes.NoteUserID = InstantASP_Users.UserID
	WHERE TicketID = @intTicketID
	
END

IF (@intUserID > 0)
BEGIN

	IF (@intTabID > 0) 
	BEGIN
	
		SELECT 
		InstantKB_TicketNotes.TicketNoteID, 
		InstantKB_TicketNotes.TicketID, 
		InstantKB_TicketNotes.NoteText, 
		InstantKB_TicketNotes.NoteDate,
		InstantASP_Users.UserID, 
		InstantASP_Users.OpenID, 
		InstantASP_Users.Username
		FROM  
		InstantKB_TicketNotes 
		INNER JOIN
		InstantKB_Tickets ON InstantKB_TicketNotes.TicketID = InstantKB_Tickets.TicketID 
		LEFT OUTER JOIN
		InstantASP_Users ON InstantKB_TicketNotes.NoteUserID = InstantASP_Users.UserID
		WHERE (InstantKB_Tickets.TicketToUserId = @intUserID OR 
		InstantKB_Tickets.TicketCreatedUserID = @intUserID) AND (InstantKB_Tickets.TicketTabID = @intTabID)
	
	END
	ELSE
	BEGIN
	
		SELECT 
		InstantKB_TicketNotes.TicketNoteID, 
		InstantKB_TicketNotes.TicketID, 
		InstantKB_TicketNotes.NoteText, 
		InstantKB_TicketNotes.NoteDate,
		InstantASP_Users.UserID, 
		InstantASP_Users.OpenID, 
		InstantASP_Users.Username
		FROM  
		InstantKB_TicketNotes 
		INNER JOIN
		InstantKB_Tickets ON InstantKB_TicketNotes.TicketID = InstantKB_Tickets.TicketID 
		LEFT OUTER JOIN
		InstantASP_Users ON InstantKB_TicketNotes.NoteUserID = InstantASP_Users.UserID
		WHERE (InstantKB_Tickets.TicketToUserId = @intUserID OR 
		InstantKB_Tickets.TicketCreatedUserID = @intUserID)
	
	END
END

RETURN

GO


/****** Object:  StoredProcedure [ikb_sp_SelectUser] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [ikb_sp_SelectUser] (
@strIdentity nvarchar(255)
) AS

SET NOCOUNT ON 

EXEC iasp_sp_SelectUserData @strIdentity, '', '', 0, 0

DECLARE @intLocalUserID int
SET @intLocalUserID = ( 
	SELECT IU.UserID 
	FROM InstantASP_Users IU (nolock) 
	WHERE (IU.Username = @strIdentity OR IU.EmailAddress = @strIdentity OR IU.OpenID = @strIdentity)
	)
/* Select general user information within first record set */
SELECT InstantKB_Users.* FROM InstantKB_Users  (nolock) WHERE (InstantKB_Users.UserID = @intLocalUserID)

/* Select tabs for user within second record set */
EXEC ikb_sp_SelectTabsByUserID @intLocalUserID

/* Select departments for user in third record set */
EXEC ikb_sp_SelectDepartmentsByUserID @intLocalUserID

RETURN 

GO

PRINT 'New Stored Procedures Created'

GO

/**************************************************************
Update Existing Procs
**************************************************************/

/****** Object:  StoredProcedure [ikb_sp_InsertUpdateStatus]   ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_InsertUpdateStatus](
@intStatusID int,
@strStatusName nvarchar(255),
@strStatusForegroundColor nvarchar(50),
@strStatusBackgroundColor nvarchar(50),
@intStatusSortOrder int,
@intStatusAccessType tinyint,
@intStatusTabID int,
@strStatusImage  nvarchar(100),
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a status within InstantKB_Status table */

-- is this an update or insert?
IF (@intStatusID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Status (StatusName, StatusForegroundColor, StatusBackgroundColor, StatusSortOrder, StatusAccessType, StatusTabID, StatusImage) 
	VALUES (@strStatusName, @strStatusForegroundColor, @strStatusBackgroundColor, @intStatusSortOrder, @intStatusAccessType, @intStatusTabID, @strStatusImage)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Status SET
	StatusName = @strStatusName,
	StatusForegroundColor = @strStatusForegroundColor,
	StatusBackgroundColor = @strStatusBackgroundColor,
	StatusSortOrder = @intStatusSortOrder,
	StatusAccessType = @intStatusAccessType,
	StatusImage = @strStatusImage,
	StatusTabID = @intStatusTabID
	WHERE InstantKB_Status.StatusID = @intStatusID

	-- return the identity
	SET @intIdentity = @intStatusID
	RETURN

END

SET @intIdentity = 0
RETURN

GO

/****** Object:  StoredProcedure [ikb_sp_InsertUpdateTab] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_InsertUpdateTab] (
@intTabID int,
@strTabLabel nvarchar(255),
@strTabLabelNonLocalized nvarchar(255),
@strTabToolTip nvarchar(255),
@strTabToolTipNonLocalized nvarchar(255),
@strTabRedirectURL nvarchar(255),
@intFieldTemplateID int,
@bolIsCustomTab bit,
@intSortOrder int,
@intTabContentType tinyint,
@strTabIcon nvarchar(255),
@strTabContentTypeNameNonLocalized nvarchar(255),
@strTabSettingsXML ntext,
@bolDupeExistingFields bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a custom tab into the InstantKB_Tabs table */

-- is this an update or insert?
IF (@intTabID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Tabs (TabLabel, TabLabelNonLocalized, TabTooltip, TabTooltipNonLocalized, TabRedirectURL, FieldTemplateID, IsCustomTab, SortOrder, TabContentType, TabIcon, TabContentTypeNameNonLocalized, TabSettingsXML) VALUES
	(@strTabLabel, @strTabLabelNonLocalized, @strTabToolTip, @strTabToolTipNonLocalized, @strTabRedirectURL,@intFieldTemplateID, @bolIsCustomTab, @intSortOrder, @intTabContentType, @strTabIcon, @strTabContentTypeNameNonLocalized, @strTabSettingsXML)

		-- return the  new identity
	SET @intIdentity = @@IDENTITY

	-- if we are creating a tab that will host content then we need to duplicate the existing tabs matching the new tabs content tab
	IF (@bolDupeExistingFields = 1)
	BEGIN

		-- get the default tab identity we'll be cloning
		DECLARE @intDefaultTabID int
		SET @intDefaultTabID = (SELECT TabID FROM InstantKB_Tabs WHERE (InstantKB_Tabs.TabContentType = @intTabContentType AND InstantKB_Tabs.IsCustomTab = 0))

		-- clone fields for new tab
		INSERT INTO InstantASP_Fields (ApplicationID, TabID, FieldLabel, FieldLabelNonLocalized, FieldDescLabel, FieldDescLabelNonLocalized, 
		TableFieldName, FieldType, PickListID, StringSize, [Format], RegExValidation, SortOrder, IsVisible, IsEnabled, IsRequired, IsCustomField, IsUserEditable) 
		(SELECT ApplicationID, @intIdentity AS TabID, FieldLabel, FieldLabelNonLocalized, FieldDescLabel, FieldDescLabelNonLocalized, 
		TableFieldName, FieldType, PickListID, StringSize,  [Format], RegExValidation, SortOrder, IsVisible, IsEnabled, IsRequired, IsCustomField, IsUserEditable
		FROM InstantASP_Fields WHERE ApplicationID = 2  AND IsCustomField = 0 AND TabID = @intDefaultTabID)

		-- add user permission sets for tab
		INSERT INTO InstantKB_PermissionSetsTabs (PermissionID, TabID)
		SELECT PermissionID, @intIdentity FROM InstantKB_PermissionSets
		
		-- add staff permission sets for tab
		INSERT INTO InstantKB_StaffPermissionSetsTabs (PermissionID, TabID)
		SELECT PermissionID, @intIdentity FROM InstantKB_StaffPermissionSets

		-- view are not required
		DECLARE @bolIsRequired bit; SET @bolIsRequired = 1

		-- date stamp for view
		DECLARE @dtDateStamp datetime; SET @dtDateStamp = GetDate()

		-- clone default views
		INSERT INTO InstantKB_DataViews (UserID, TabID, [Name], [Description], [Columns], SortBy, SortOrder, PageSize, AccessType, DataViewType, IsRequired, DateStamp) 
		(SELECT UserID, @intIdentity AS TabID, [Name], [Description], [Columns], SortBy, SortOrder, PageSize, AccessType, DataViewType, @bolIsRequired As IsRequired, @dtDateStamp As DateStamp FROM InstantKB_DataViews
		WHERE (InstantKB_DataViews.TabID = @intDefaultTabID and UserID = 0 AND IsRequired = 1))

		-- clone default statues
		INSERT INTO InstantKB_Status (StatusTabID, StatusName, StatusSortOrder, StatusForegroundColor, StatusBackgroundColor, StatusImage, StatusAccessType) 
		SELECT @intIdentity AS StatusTabID, StatusName, StatusSortOrder, StatusForegroundColor, StatusBackgroundColor, StatusImage, StatusAccessType FROM InstantKB_Status 
		WHERE (InstantKB_Status.StatusTabID = @intDefaultTabID)
		
		-- clone default priorities
		INSERT INTO InstantKB_Priorities (PriorityTabID, PriorityName, PrioritySortOrder, PriorityForegroundColor, PriorityBackgroundColor, PriorityImage, PriorityAccessType)
		SELECT @intIdentity AS PriorityTabID, PriorityName, PrioritySortOrder, PriorityForegroundColor, PriorityBackgroundColor, PriorityImage, PriorityAccessType FROM InstantKB_Priorities
		WHERE (InstantKB_Priorities.PriorityTabID = @intDefaultTabID)

		-- clone default levels
		INSERT INTO InstantKB_Levels (LevelTabID, LevelName, LevelSortOrder, LevelAccessType)
		SELECT @intIdentity AS LevelTabID, LevelName, LevelSortOrder, LevelAccessType FROM InstantKB_Levels
		WHERE (InstantKB_Levels.LevelID = @intDefaultTabID)

		-- close default types
		INSERT INTO InstantKB_Types (TypeTabID, TypeName, TypeIcon, TypeSortOrder)
		SELECT @intIdentity AS TypeTabID, TypeName, TypeIcon, TypeSortOrder FROM InstantKB_Types
		WHERE (InstantKB_Types.TypeTabID = @intDefaultTabID)

		-- clone attachment types
		INSERT INTO InstantKB_ATtachmentTypes (TabID, Extension, Icon)
		SELECT @intIdentity AS TabID,  Extension, Icon FROM InstantKB_ATtachmentTypes
		WHERE (InstantKB_ATtachmentTypes.TabID = @intDefaultTabID)

	END		

	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Tabs SET
	TabLabel = @strTabLabel,
	TabLabelNonLocalized = @strTabLabelNonLocalized,
	TabTooltip = @strTabToolTip,
	TabTooltipNonLocalized = @strTabToolTipNonLocalized,
	TabRedirectURL = @strTabRedirectURL,
	FieldTemplateID = @intFieldTemplateID,
	IsCustomTab = @bolIsCustomTab,
	TabContentType = @intTabContentType,
	TabIcon = @strTabIcon,
	TabContentTypeNameNonLocalized = @strTabContentTypeNameNonLocalized,
	TabSettingsXML = @strTabSettingsXML,
	SortOrder = @intSortOrder
	WHERE InstantKB_Tabs.TabID = @intTabID

	-- return the identity
	SET @intIdentity = @intTabID
	RETURN

END

RETURN

GO

/****** Object:  StoredProcedure [ikb_sp_InsertUpdatePriority]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_InsertUpdatePriority] (
@intPriorityID int,
@strPriorityName nvarchar(255),
@strPriorityForegroundColor nvarchar(50),
@strPriorityBackgroundColor nvarchar(50),
@intPrioritySortOrder int,
@intPriorityAccessType tinyint,
@intPriorityTabID int,
@strPriorityImage nvarchar(100),
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a priority within InstantKB_Priority table */

-- is this an update or insert?
IF (@intPriorityID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Priorities (PriorityName, PriorityForegroundColor, PriorityBackgroundColor, PrioritySortOrder, PriorityAccessType, PriorityTabID, PriorityImage) 
	VALUES (@strPriorityName, @strPriorityForegroundColor, @strPriorityBackgroundColor, @intPrioritySortOrder, @intPriorityAccessType, @intPriorityTabID, @strPriorityImage)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Priorities SET
	PriorityName = @strPriorityName,
	PriorityForegroundColor = @strPriorityForegroundColor,
	PriorityBackgroundColor = @strPriorityBackgroundColor,
	PrioritySortOrder = @intPrioritySortOrder,
	PriorityAccessType = @intPriorityAccessType,
	PriorityImage = @strPriorityImage,
	PriorityTabID = @intPriorityTabID
	WHERE InstantKB_Priorities.PriorityID = @intPriorityID

	-- return the identity
	SET @intIdentity = @intPriorityID
	RETURN

END

SET @intIdentity = 0
RETURN

GO

/****** Object:  StoredProcedure [ikb_sp_SelectAttachment] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_SelectAttachment] (
@intAttachmentID int,
@intUserID int,
@intAttachmentType int
)
AS

SET NOCOUNT ON 

/* Select a single attachment from InstantKB_Attachments */

-- select article attachment
IF (@intAttachmentType = 1) 
BEGIN

	-- get the article this attachmentb belongs to
	DECLARE @intArticleID int
	SET @intArticleID = (SELECT ArticleID FROM InstantKB_Articles WHERE ArticleID = 
	(SELECT RelatedEntityID FROM InstantKB_Attachments WHERE InstantKB_Attachments.AttachmentID = @intAttachmentID))

	-- select the attachment with role check on article to ensure user has access
	IF (@intUserID > 0) 
	BEGIN
		SELECT InstantKB_Attachments.* FROM InstantKB_Attachments WHERE InstantKB_Attachments.AttachmentID = @intAttachmentID 
		AND EXISTS (
		SELECT InstantKB_ArticleRoles.RoleID FROM InstantKB_ArticleRoles WHERE InstantKB_ArticleRoles.ArticleID = @intArticleID AND InstantKB_ArticleRoles.RoleID IN (
		SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE InstantASP_UsersRoles.UserID = @intUserID)
		)
	END
	ELSE
	BEGIN
		SELECT InstantKB_Attachments.* FROM InstantKB_Attachments WHERE InstantKB_Attachments.AttachmentID = @intAttachmentID 
		AND EXISTS (
		SELECT InstantKB_ArticleRoles.RoleID FROM InstantKB_ArticleRoles WHERE InstantKB_ArticleRoles.ArticleID = @intArticleID AND InstantKB_ArticleRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles WHERE AnonymousRole = 1)
		)
	END

END

-- select article attachment
IF (@intAttachmentType = 2) 
BEGIN
		SELECT * FROM InstantKB_Attachments WHERE InstantKB_Attachments.AttachmentID = @intAttachmentID
END

RETURN 

GO


/****** Object:  StoredProcedure [ikb_sp_CleanTables]  ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_CleanTables] (
@strDateTime nvarchar(255)
)
AS


SET NOCOUNT ON 

/* Cleans all tables of any expired data */

-- delete expired who's on data
EXEC ikb_sp_DeleteWhosOnData @strDateTime

-- delete expired topic read information
EXEC ikb_sp_DeleteExpiredArticleRead @strDateTime

-- flah overddue tickets
UPDATE InstantKB_Tickets SET
InstantKB_Tickets.TicketOverdue = 1
WHERE InstantKB_Tickets.TicketDueDate <= @strDateTime


-- return ticket identities so we can run escalation ruls
SELECT TicketID FROM InstantKB_Tickets 
WHERE (InstantKB_Tickets.TicketOverdue = 1 AND
 InstantKB_Tickets.TicketIsEscalated = 0)

RETURN

GO

/****** Object:  StoredProcedure [ikb_sp_SelectStatisticsForUser]    Script Date: 09/30/2010 16:10:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_SelectStatisticsForUser] (
@intUserID int,
@intTabID int,
@strEmailAddress nvarchar(255)
)
AS

SET NOCOUNT ON 

/* Select statistics for a single user within the knowledgebase */


DECLARE @intTotalLiveComments int
DECLARE @intTotalPrivateComments int
DECLARE @intTicketsAssignedToMe int
DECLARE @TotalTimeWorked int
DECLARE @TotalUserTickets int
DECLARE @TicketFirstPostDate DateTime

SET @intTotalLiveComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE (UserID = @intUserID AND AccessType = 1))
SET @intTotalPrivateComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE (UserID = @intUserID AND AccessType = 2))

IF (@intTabID > 0) 
BEGIN
	If (@intUserID > 0) 
	BEGIN
		SET @TotalUserTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WHERE (TicketTabID = @intTabID AND TicketCreatedUserID  = @intUserID))
		SET @TotalTimeWorked = (SELECT SUM(TicketTimeWorked) FROM InstantKB_Tickets WHERE (TicketTabID = @intTabID AND TicketCreatedUserID  = @intUserID))
		SET @intTicketsAssignedToMe = (SELECT COUNT(TicketID) FROM InstantKB_Tickets (nolock) WHERE (InstantKB_Tickets.TicketAssignedUserID  = @intUserID  AND TicketTabID = @intTabID))
		SET @TicketFirstPostDate = (SELECT TOP 1 TicketCreatedDate FROM InstantKB_Tickets (nolock) WHERE (InstantKB_Tickets.TicketCreatedUserID  = @intUserID  AND TicketTabID = @intTabID) ORDER BY TicketCreatedDate ASC)
				
		
	END
	
	IF (@strEmailAddress <> '') 
	BEGIN
	
		SET @TotalUserTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WHERE (TicketTabID = @intTabID AND (TicketCreatedEmail  = @strEmailAddress OR TicketToEmail = @strEmailAddress)))
		SET @TotalTimeWorked = (SELECT SUM(TicketTimeWorked) FROM InstantKB_Tickets WHERE (TicketTabID = @intTabID AND (TicketCreatedEmail  = @strEmailAddress OR TicketToEmail = @strEmailAddress)))
		SET @TicketFirstPostDate = (SELECT TOP 1 TicketCreatedDate FROM InstantKB_Tickets (nolock) WHERE ((TicketCreatedEmail  = @strEmailAddress OR TicketToEmail = @strEmailAddress) AND TicketTabID = @intTabID) ORDER BY TicketCreatedDate ASC)
				
	END

END
ELSE
BEGIN

	SET @TotalUserTickets = (SELECT COUNT(TicketID) FROM InstantKB_Tickets WHERE ( TicketCreatedUserID  = @intUserID))
	SET @TotalTimeWorked = (SELECT SUM(TicketTimeWorked) FROM InstantKB_Tickets WHERE ( TicketCreatedUserID  = @intUserID))
	SET @TicketFirstPostDate = (SELECT TOP 1 TicketCreatedDate FROM InstantKB_Tickets (nolock) WHERE (InstantKB_Tickets.TicketCreatedUserID  = @intUserID  AND TicketTabID = @intTabID) ORDER BY TicketCreatedDate DESC)
				
END


SELECT 
@intTotalLiveComments As TotalLiveComments, 
@intTotalPrivateComments As TotalPrivateComments,
@TotalTimeWorked AS TotalTimeWorked,
@intTicketsAssignedToMe AS TicketsAssignedToMe,
@TotalUserTickets as TotalUserTickets,
@TicketFirstPostDate AS TicketFirstPostDate

RETURN 

GO


/****** Object:  StoredProcedure [ikb_sp_SelectUserByUserID] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_SelectUserByUserID] (
@intUserID int
) AS

SET NOCOUNT ON 

EXEC iasp_sp_SelectUserData '', '', '', 0, @intUserID

/* Select general user information within first record set */
SELECT InstantKB_Users.* FROM InstantKB_Users  (nolock) WHERE (InstantKB_Users.UserID = @intUserID)

/* Select tabs for user within second record set */
EXEC ikb_sp_SelectTabsByUserID @intUserID

/* Select departments for user in third record set */
EXEC ikb_sp_SelectDepartmentsByUserID @intUserID

GO

/****** Object:  StoredProcedure [ikb_sp_SelectArticleComments] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_SelectArticleComments] (
@intArticleID int,
@intAccessType tinyint,
@intSortOrder tinyint
) AS
SET NOCOUNT ON
 
/* Returns all anonymous and member public comments for an article */

IF (@intAccessType > 0)
BEGIN
	SELECT InstantASP_Users.UserLevelTitle, InstantASP_Users.UserLevelImageURL, InstantASP_Users.PhotoImage,(SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName, InstantKB_Users.RecognitionPoints, InstantKB_ArticleComments.* FROM InstantKB_Users
	INNER JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID RIGHT OUTER JOIN InstantKB_ArticleComments ON InstantASP_Users.UserID = InstantKB_ArticleComments.UserID 
	WHERE (InstantKB_ArticleComments.ArticleID = @intArticleID AND InstantKB_ArticleComments.AccessType = @intAccessType) ORDER BY
	CASE 
	WHEN @intSortOrder = 1 THEN DateStamp 
	END DESC,
	CASE
	WHEN @intSortOrder = 2 THEN DateStamp 
	END ASC,
	CASE
	WHEN @intSortOrder = 3 THEN MarkedAsHelpFul 
	END	DESC
END
ELSE
BEGIN
	SELECT InstantASP_Users.UserLevelTitle,  InstantASP_Users.UserLevelImageURL, InstantASP_Users.PhotoImage,  (SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName, InstantKB_Users.RecognitionPoints, InstantKB_ArticleComments.* FROM InstantKB_Users 
	INNER JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID RIGHT OUTER JOIN InstantKB_ArticleComments ON InstantASP_Users.UserID = InstantKB_ArticleComments.UserID 
	WHERE (InstantKB_ArticleComments.ArticleID = @intArticleID) ORDER BY
	CASE 
	WHEN @intSortOrder = 1 THEN DateStamp 
	END DESC,
	CASE
	WHEN @intSortOrder = 2 THEN DateStamp 
	END ASC,
	CASE
	WHEN @intSortOrder = 3 THEN MarkedAsHelpFul 
	END	DESC
END

GO
/****** Object:  StoredProcedure [ikb_sp_SelectArticleCommentsPaged] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE ikb_sp_SelectArticleCommentsPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	CommentID int
)

-- insert data 
INSERT INTO #PageIndex (CommentID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantASP_Users.UserLevelTitle, InstantASP_Users.UserLevelImageURL, InstantASP_Users.PhotoImage, InstantKB_Users.RecognitionPoints, InstantKB_ArticleComments.*,
(SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName FROM #PageIndex IPI 
 JOIN InstantKB_ArticleComments ON InstantKB_ArticleComments.CommentID = IPI.CommentID
 LEFT  OUTER JOIN InstantASP_Users ON InstantKB_ArticleComments.UserID = InstantASP_Users.UserID 
LEFT  OUTER JOIN InstantKB_Users ON InstantKB_ArticleComments.UserID = InstantKB_Users.UserID 
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
	
GO

/****** Object:  StoredProcedure [ikb_sp_SelectArticleComment]    Script Date: 11/14/2010 17:49:14 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_SelectArticleComment] (
@intCommentID int
) AS
SET NOCOUNT ON
 
/* Returns all single comment from InstantKB_ArticleComments */

SELECT InstantKB_ArticleComments.*, InstantASP_Users.UserLevelTitle, InstantASP_Users.UserLevelImageURL, InstantASP_Users.PhotoImage, InstantKB_Users.RecognitionPoints, InstantKB_ArticleComments.UserID, 
InstantKB_ArticleComments.Username, InstantKB_ArticleComments.EmailAddress, InstantKB_ArticleComments.WebAddress, InstantKB_Articles.TabID,
(SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName FROM InstantKB_Users 
JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID 
RIGHT OUTER JOIN InstantKB_ArticleComments ON InstantASP_Users.UserID = InstantKB_ArticleComments.UserID 
JOIN InstantKB_Articles ON InstantKB_ArticleComments.ArticleID = InstantKB_Articles.ArticleID
WHERE (InstantKB_ArticleComments.CommentID = @intCommentID)

GO

/****** Object:  StoredProcedure [iasp_sp_InsertUpdateUser] ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [iasp_sp_InsertUpdateUser] (
@intUserID int,
@intPrimaryRoleID int,
@strUsername nvarchar(155),
@strUsernameEncoded nvarchar(155),
@strEmailAddress nvarchar(155),
@strPassword nvarchar(155),
@strCulture nvarchar(10),
@dbTimeZoneOffSet float,
@bolObserveDST bit,
@strDateTimeFormat nvarchar(10),
@intFirstDayOfWeek tinyint,
@strFirstName nvarchar(155),
@strLastName nvarchar(155),
@strCompanyName nvarchar(155),
@strJobTitle nvarchar(155),
@strPublicEmail nvarchar(155),
@strWebAddress nvarchar(255),
@strBlogAddress nvarchar(255),
@strOpenID nvarchar(255),
@strPhotoImage nvarchar(200),
@strMSN nvarchar(155),
@strSkype nvarchar(155),
@strAIM nvarchar(155),
@strYIM nvarchar(155),
@strICQ nvarchar (155),
@strTwitter nvarchar (75),
@strFacebook nvarchar (75),
@strLinkedIn nvarchar (75),
@strMySpace nvarchar(100),
@strYouTube nvarchar(100),
@strLocation nvarchar(155),
@intDOBDay tinyint,
@intDOBMonth tinyint,
@intDOBYear int,
@strUserLevelTitle nvarchar(100),
@strUserLevelImageURL nvarchar(100),
@strIPAddress nvarchar(20),
@strLdapUsername nvarchar(255),
@strConfirmationCode nvarchar(50),
@intIdentity int output

) 
AS

SET NOCOUNT ON 

/* Inserts or updates a user within InstantASP_Users */

-- is this an update or insert?
IF (@intUserID = 0)
BEGIN

	/* Ensure the username is not already present within the table */
	IF (@strUsername <> '')
	BEGIN
		IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE InstantASP_Users.Username = @strUsername)
		BEGIN 
			SET @intIdentity = -1
			RETURN
		END
	END
	
	/* Ensure the email address is not already present within the table */
	IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE InstantASP_Users.EmailAddress = @strEmailAddress)
	BEGIN 
		SET @intIdentity = -2
		RETURN
	END

	-- insert user
	INSERT INTO InstantASP_Users (
	PrimaryRoleID, 
	Username, 
	UsernameEncoded,
	EmailAddress, 
	[Password], 
	Culture, 
	TimeZoneOffset, 
	ObserveDaylightSavingTime, 
	DateTimeFormat, 
	FirstDayOfWeek, 
	FirstName, 
	LastName, 
	CompanyName, 
	JobTitle, 
	PublicEmail, 
	WebAddress, 
	BlogAddress, 
	OpenID,
	PhotoImage, 	
	MSN, 
	Skype, 
	YIM, 
	AIM, 
	ICQ, 
	Twitter, 
	Facebook, 
	LinkedIn, 
	MySpace,
	YouTube,
	Location, 
	DOBDay, 
	DOBMonth, 
	DOBYear, 
	UserLevelTitle, 
	UserLevelImageURL, 
	IPAddress, 
	LdapUsername,
	ConfirmationCode
	) 
	VALUES
	(
	@intPrimaryRoleID, 
	@strUsername, 
	@strUsernameEncoded,
	@strEmailAddress, 
	@strPassword, 
	@strCulture, 
	@dbTimeZoneOffSet, 
	@bolObserveDST, 
	@strDateTimeFormat, 
	@intFirstDayOfWeek, 
	@strFirstName, 
	@strLastName, 
	@strCompanyName, 
	@strJobTitle, 
	@strPublicEmail, 
	@strWebAddress, 
	@strBlogAddress, 
	@strOpenID, 
	@strPhotoImage, 
	@strMSN, 
	@strSkype, 
	@strYIM, 
	@strAIM, 
	@strICQ, 
	@strTwitter, 
	@strFacebook, 
	@strLinkedIn, 
	@strMySpace, 
	@strYouTube, 
	@strLocation, 
	@intDOBDay, 
	@intDOBMonth, 
	@intDOBYear, 
	@strUserLevelTitle, 
	@strUserLevelImageURL, 
	@strIPAddress, 
	@strLdapUsername, 
	@strConfirmationCode)

	-- set output parameter
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating an existing record
BEGIN

	IF (@strUsername <> '')
	BEGIN
		IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE Username = @strUsername AND UserID <> @intUserID)
		BEGIN
			SET @intIdentity = - 1
			RETURN
		END 
	END

	-- Check to see if email address already exists for any other user

	IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE EmailAddress = @strEmailAddress AND UserID <> @intUserID)
	BEGIN
		SET @intIdentity = - 2
		RETURN
	END 

	-- update user
	UPDATE InstantASP_Users SET 
	PrimaryRoleID = @intPrimaryRoleID,
	Username = @strUsername,
	UsernameEncoded = @strUsernameEncoded,
	EmailAddress = @strEmailAddress,
	[Password] = @strPassword,
	Culture = @strCulture,
	TimeZoneOffset = @dbTimeZoneOffSet,
	ObserveDaylightSavingTime = @bolObserveDST,
	DateTimeFormat = @strDateTimeFormat,
	FirstDayOfWeek = @intFirstDayOfWeek,
	FirstName = @strFirstName,
	LastName = @strLastName,
	CompanyName = @strCompanyName,
	JobTitle = @strJobTitle,
	PublicEmail = @strPublicEmail,
	WebAddress = @strWebAddress,
	BlogAddress = @strBlogAddress,
	OpenID = @strOpenID,
	PhotoImage = @strPhotoImage,
	MSN = @strMSN,
	Skype = @strSkype,
	YIM = @strYIM,
	AIM = @strAIM,
	ICQ = @strICQ,
	Twitter = @strTwitter,
	Facebook = @strFacebook,
	LinkedIn = @strLinkedIn,
	MySpace = @strMySpace,
	YouTube = @strYouTube,
	Location = @strLocation,
	DOBDay = @intDOBDay,
	DOBMonth = @intDOBMonth,
	DOBYear = @intDOBYear,
	IPAddress = @strIPAddress,
	UserLevelTitle = @strUserLevelTitle,
	UserLevelImageURL = @strUserLevelImageURL,
	LdapUsername = @strLdapUsername,
	ConfirmationCode = @strConfirmationCode
	WHERE (InstantASP_Users.UserID = @intUserID)

	-- set output parameter
	SET @intIdentity = @intUserID

END

RETURN

GO

PRINT 'Existing Procedures Updated'

/**************************************************************
Add New Default Data 
**************************************************************/

INSERT INTO InstantKB_Tabs (TabContentType,TabLabel,TabLabelNonLocalized,TabTooltip,TabTooltipNonLocalized,TabIcon,FieldTemplateID,TabRedirectURL,TabClickCount,IsCustomTab,SortOrder, TabContentTypeName, TabContentTypeNameNonLocalized, TabSettingsXML) VALUES('5','TabStrip_4','','TabStrip_ToolTip4','','Tickets.gif','0','','0',0,'9','TabStrip_ContentType4','', '<?xml version=''1.0'' encoding=''UTF-8''?><settings><setting name="LiveSearch" value="true" /></settings>')

DECLARE @intNewTabID int
SET @intNewTabID = @@IDENTITY 

INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES(@intNewTabID,'1')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES(@intNewTabID,'2')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES(@intNewTabID,'3')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES(@intNewTabID,'4')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES(@intNewTabID,'5')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES(@intNewTabID,'6')

-- add edit ticket fields

INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketID','TicketID','','','','','TicketID','1','0','','0','','','1',1,1,0,0,0, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES ('2',@intNewTabID,'FieldSeperator_TicketInformation','Seperator','','','','','','14','0','','0','','','2',1,1,0,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketDepartmentID','Department','','','','','TicketDeptID','4','0','','0','','','3',1,1,0,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketSLA','SLA','','','','','TicketSLAID','2','0','','0','','','4',1,1,0,0,0, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketCreatedUserID','Full Name','','','','','TicketCreatedUsername','1','0','','0','','','5',1,1,1,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketCreatedEmailAddress','Email Address','','','','','TicketCreatedEmail','1','0','','0','','\S+@\S+\.\S{2,4}','6',1,1,1,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketTitle','Ticket Title','','','','','TicketTitle','1','0','','0','','','7',1,1,1,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_ArticleWorkFlowStepID','Workflow Step','','','','','TicketWorkFlowStepID','4','0','','0','','','8',1,1,0,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketText','Ticket Text','','','','','TicketText','7','0','','0','','','9',1,1,1,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'FieldSeperator_General','Seperator','','','','','','14','0','','0','','','10',1,1,0,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES ('2',@intNewTabID,'Field_ArticleCategory','Primary Category','','','','','TicketCategoryID','4','0','','0','','','11',1,1,1,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES ('2',@intNewTabID,'Field_ArticleCreatedUserID','Created By','','','','','TicketCreatedUserID','4','0','','0','','','12',1,1,0,0,0, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketCreatedDate','Created Date','','','','','TicketCreatedDate','3','0','','0','','','13',1,1,0,0,0, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketModifiedUserID','Modified By','','','','','TicketModifiedUserID','1','0','','0','','','14',1,1,0,0,0, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketModifiedDate','Modified Date','','','','','TicketModifiedDate','3','0','','0','','','15',1,1,0,0,0, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketPriorityID','Priority','','','','','TicketPriorityID','4','0','','0','','','16',1,1,0,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketStatusID','Status','','','','','TicketStatusID','4','0','','0','','','17',1,1,0,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketTypeID','Type','','','','','TicketTypeID','4','0','','0','','','18',1,1,0,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketAssignedUserID','Assigned To','','','','','TicketAssignedUserID','4','0','','0','','','19',1,1,0,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketAssignedDate','Assigned Date','','','','','TicketAssignedDate','3','0','','0','','','20',1,1,0,0,0, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketTimeWorked','Timed Worked','','','','','TicketTimeWorked','2','0','','0','','','21',1,1,0,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES ('2',@intNewTabID,'Field_ArticlePercentComplete','Percent Complete','','','','','TicketPercentComplete','2','0','','0','','','22',1,1,0,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES ('2',@intNewTabID,'Field_ArticleDueDate','Due Date','','','','','TicketDueDate','3','0','','0','','','23',1,1,0,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketViews','Views','','','','','TicketViews','2','0','','0','','','24',1,1,0,0,0, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES('2',@intNewTabID,'Field_TicketReplies','Replies','','','','','TicketReplies','2','0','','0','','','25',1,1,0,0,0, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES ('2',@intNewTabID,'Field_SubmitTicketAttachment','Upload File','','','','','TicketAttachment1','15','0','','','','','26',1,1,0,0,1, GETDATE())
INSERT INTO InstantASP_Fields (ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable, DateStamp) VALUES ('2',@intNewTabID,'Field_SubmitTicketAttachment','Upload File','','','','','TicketAttachment2','15','0','','','','','27',1,1,0,0,1, GETDATE())

-- add new default submit ticket template

INSERT INTO InstantASP_FieldTemplates (ApplicationID, [Name], NameNonLocalized, [Description], TabID, IsRequired, DateStamp) VALUES (2, 'TicketTemplate', '', '', 4, 1, GETDATE())

-- add ticket priorities

INSERT INTO InstantKB_Priorities (PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('Urgent','1','white','red','','1','4')
INSERT INTO InstantKB_Priorities (PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('High','2','ghostwhite','darkorange','','1','4')
INSERT INTO InstantKB_Priorities (PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('Medium','3','cornflowerblue','yellow','','2','4')
INSERT INTO InstantKB_Priorities (PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('Low','4','cornflowerblue','white','','1','4')

-- add default views

INSERT INTO InstantKB_DataViews (UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('0',@intNewTabID,'User View','','TicketIcon,TicketTitle,TicketReplies,TicketModifiedDate','TicketModifiedDate','1','10','1','3',1,GetDate())
INSERT INTO InstantKB_DataViews (UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('0',@intNewTabID,'Staff View','','TicketIcon,TicketFlagged,TicketTitle,TicketReplies,TicketStatusID,TicketPriorityID,TicketDueDate','TicketModifiedDate','1','20','1','4',1,GetDate())

-- add tab permission sets

INSERT INTO InstantKB_StaffPermissionSetsTabs (PermissionID,TabID,SettingsXML) VALUES('1',@intNewTabID,'')

-- insert user tab permissions

INSERT INTO InstantKB_PermissionSetsTabs (PermissionID, TabID, SettingsXML) 
SELECT PermissionID, @intNewTabID As TabID, '' As SettingsXML FROM InstantKB_PermissionSets

-- add ticket status list

INSERT INTO InstantKB_Status (StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('Open','1','','','','1','4')
INSERT INTO InstantKB_Status (StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('Assigned','3','','','','1','4')
INSERT INTO InstantKB_Status (StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('Under Investigation','4','','','','1','4')
INSERT INTO InstantKB_Status (StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('On Hold','5','','','','1','4')
INSERT INTO InstantKB_Status (StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('Closed','6','','','','1','4')
INSERT INTO InstantKB_Status (StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('Resolved','7','','','','1','4')

-- download attachment types

INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.ascx','ascx.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.aspx','aspx.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.avi','avi.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.bmp','bmp.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.chm','chm.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.config','config.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.cs','cs.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.csproj','csproj.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.css','css.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.doc','doc.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.gif','gif.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.htm','htm.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.inf','inf.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.jpg','jpg.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.js','js.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.mdb','mdb.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.mov','mov.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.pdf','pdf.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.png','png.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.pub','pub.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.rar','rar.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.sln','sln.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.sql','sql.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.txt','txt.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.vb','vb.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.vbproj','vbproj.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.vbs','vbs.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.vsd','vsd.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.xls','xls.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.xml','xml.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.xsn','xsn.png')
INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon) VALUES(@intNewTabID,'.zip','zip.png')

-- add new ignored search terms

INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\ba\b', GetDate())
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\ball\b', GetDate())
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bam\b', GetDate())
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\ban\b', GetDate())
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\band\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\babout\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bafter\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\balso\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bany\b', GetDate())  
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bare\b', GetDate())  
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bas\b', GetDate())   
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bat\b', GetDate())    
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bbe\b', GetDate())     
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bbut\b', GetDate())      
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bcan\b', GetDate())       
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bdid\b', GetDate())        
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bdo\b', GetDate())         
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bdoes\b', GetDate())          
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bfor\b', GetDate())           
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bfrom\b', GetDate())            
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bhad\b', GetDate())             
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bhas\b', GetDate())              
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bhave\b', GetDate())               
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bhere\b', GetDate())                
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bhow\b', GetDate())                 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bi\b', GetDate())                  
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bif\b', GetDate())                   
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bin\b', GetDate())                    
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bis\b', GetDate())                     
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bit\b', GetDate())                      
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bme\b', GetDate())
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bmy\b', GetDate())
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bmore\b', GetDate())
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bmost\b', GetDate())
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bmake\b', GetDate())
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bmany\b', GetDate())
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bmust\b', GetDate())
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bmust\b', GetDate())
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bno\b', GetDate())                       
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bnot\b', GetDate())                        
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bnever\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bnow\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bof\b', GetDate())                         
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bon\b', GetDate())                          
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bor\b', GetDate())                           
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bother\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bour\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bout\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bover\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bre\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bsaid\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bsame\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bsee\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bshould\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bsince\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bso\b', GetDate())                            
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bsome\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bstill\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bsuch\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\btake\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bthan\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bthat\b', GetDate())                             
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bthe\b', GetDate())                              
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\btheir\b', GetDate())                              
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bthem\b', GetDate())                              
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bthen\b', GetDate())                               
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bthere\b', GetDate())                                
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bthis\b', GetDate())  
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bthrough\b', GetDate())                                  
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bto\b', GetDate())                                   
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\btoo\b', GetDate())                                    
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bup\b', GetDate())                                     
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\buse\b', GetDate())                                      
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bunder\b', GetDate())  
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bup\b', GetDate())  
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\buse\b', GetDate())  	
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bvery\b', GetDate())   
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bwhat\b', GetDate())                                       
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bwent\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bwas\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bway\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bwe\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bwell\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bwere\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bwhich\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bwhile\b', GetDate()) 
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bwhen\b', GetDate())                                        
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bwhere\b', GetDate())                                         
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bwho\b', GetDate())                                          
INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText, DateStamp) VALUES('2','\bwhy\b', GetDate())                                           

-- insert default ticket workflow
INSERT INTO InstantKB_WorkFlows (WorkFlowName, TabID, IsDefault, DateStamp) VALUES ('Tickets', 4, 1, GETDATE())

DECLARE @intWorkFlowID int
SET @intWorkFlowID = @@IDENTITY 

INSERT INTO InstantKB_WorkFlowSteps (WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder, EditUserIDs) VALUES (@intWorkFlowID, 'Ticket Opened' , 0, '', 1, '')
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder, EditUserIDs) VALUES (@intWorkFlowID, 'Assigned Ticket ' , 0, '', 2, '')
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder, EditUserIDs) VALUES (@intWorkFlowID, 'Under Investigation' , 0, '', 3, '')
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder, EditUserIDs) VALUES (@intWorkFlowID, 'Resolved Ticket' , 0, '', 4, '')
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder, EditUserIDs) VALUES (@intWorkFlowID, 'Closed Ticket' , 0, '', 5, '')

PRINT 'New Default Data Created'

