
using InstantASP.InstantKB;

namespace InstantASP.InstantKB.UI.Pages
{

	public partial class KnowledgebaseArticle : InstantASP.InstantKB.UI.Base.Page
	{

		protected override void Page_PreInit(object sender, System.EventArgs e)
		{
            
            // get tabs
            Business.TabsRepository t = new Business.TabsRepository(base.CurrentContext.CurrentUser);
            InstantKB.Collections.TabCollection tabs = t.SelectTabs();
          
            // get article by id
            int id = base.CurrentContext.CurrentRequest.ArticleId;
            Business.ArticleRepository a = new Business.ArticleRepository(base.CurrentContext.CurrentUser);
            Components.Article article = null;
            if (id > 0)
                article = a.SelectArticle(id);

            Components.Tab tab = null;
            if (article != null)
            {
                if (tabs != null)
                    tab = tabs.FilterById(article.TabID);
            }

			bool isSplit = false;
			if (tab != null) {
				isSplit = tab.SplitView();
			}

			if (isSplit) {
				this.MasterPageFile = "Documentation.master";
			} else {
				this.MasterPageFile = "MasterPage.master";
			}

			// call base method
			base.Page_PreInit(sender, e);

		}
		public KnowledgebaseArticle()
		{
			PreInit += Page_PreInit;
		}

	}

}
