﻿<%@ Control Language="CS" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>

<asp:UpdateProgress ID="ctlUpdateProgress" Visible="False" runat="Server" />
<asp:UpdatePanel ID="ctlUpdatePanel" Runat="Server"/>

<InstantASP:Summary id="ctlSummary" Runat="Server"/>

<telerik:RadTabStrip id="ctlTabStrip" MultiPageID="ctlMultiPage" SelectedIndex="0" runat="server"/>

 <telerik:RadMultiPage id="ctlMultiPage" runat="server" SelectedIndex="0">
    <telerik:RadPageView id="RadPageView1" runat="server">                         
        <InstantASP:PanelBar id="ctlPanelBar" Collapseable="false" Text="AdminSettings_APIExplorer" TableName="tblAPIExplorer" Runat="Server">
            <InstantASP:Table id="tblAPIExplorer" class="i-table i-responsive-table admin-api-explorer" Runat="Server">          
            <tr id="trEnableAPI" runat="server">
                <td class="i-col-light" colspan="2">

                    <div class="i-row ikb-box ikb-box-danger">
                        <span class="padding">
                            <strong>NOTE:</strong> Before you can use the API explorer or make requests into the various API endpoints you must first enable the API to generate a unique Application Key. To get started use the "<strong>Application Key</strong>" tab above to  generate your application key & enable the API.
                        </span>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="i-col-header" colspan="2">
                    <div class="i-col-header-bg"></div>
                    <span>Explore Services</span>
                </td>
            </tr>
            <tr>
                <td class="i-col-light" style="width: 20%;">
                    <strong>Auth Key:</strong>
                </td> 
                <td class="i-col-light">                                
                    <div class="fields auth">
                        <InstantKBWebControls:StaffDropDownList ID="ddlAgents" ClientIDMode="Static" runat="server" />
                        <InstantASP:TextBox ID="txtAPIKey" ClientIDMode="Static" CssClass="i-text-box" runat="server" />          
                    </div>            
                </td>
            </tr>         
            <tr>
                <td class="i-col-light" style="width: 20%; vertical-align:top;">
                    <strong>Endpoint:</strong>
                </td> 
                <td class="i-col-light">                                     
                    <div class="fields endpoint">
                        <div class="padding">
                            <asp:DropDownList ID="ddlMethod" ClientIDMode="Static" runat="server">
                                <asp:ListItem Text="GET" Value="GET"></asp:ListItem>
                                <asp:ListItem Text="POST" Value="POST"></asp:ListItem>
                                <asp:ListItem Text="PUT" Value="PUT"></asp:ListItem>
                                <asp:ListItem Text="DELETE" Value="DELETE"></asp:ListItem>
                            </asp:DropDownList>     
                            <i class="fa fa-long-arrow-right"></i>                            
                            <asp:DropDownList ID="ddlVersion" ClientIDMode="Static" runat="server">
                                <asp:ListItem Text="1.0" Value="1"></asp:ListItem>                                
                            </asp:DropDownList>
                            <i class="fa fa-long-arrow-right"></i>
                            api/
                            <asp:DropDownList ID="ddlController" ClientIDMode="Static" runat="server">                                
                                <asp:ListItem Text="articles" Value="api/articles"></asp:ListItem>
                                <asp:ListItem Text="article" Value="api/article"></asp:ListItem>
                                <asp:ListItem Text="attachmenttypes" Value="api/attachmenttypes"></asp:ListItem>
                                <asp:ListItem Text="attachmenttype" Value="api/attachmenttype"></asp:ListItem>
                                <asp:ListItem Text="auth" Value="api/auth"></asp:ListItem>
                                <asp:ListItem Text="categories" Value="api/categories"></asp:ListItem>
                                <asp:ListItem Text="category" Value="api/category"></asp:ListItem>
                                <asp:ListItem Text="departments" Value="api/departments"></asp:ListItem>
                                <asp:ListItem Text="department" Value="api/department"></asp:ListItem>
                                <asp:ListItem Text="fields" Value="api/fields"></asp:ListItem>
                                <asp:ListItem Text="field" Value="api/field"></asp:ListItem>                                                                
                                <asp:ListItem Text="fieldtemplates" Value="api/fieldtemplates"></asp:ListItem>
                                <asp:ListItem Text="fieldtemplate" Value="api/fieldtemplate"></asp:ListItem>
                                <asp:ListItem Text="fieldtemplatedetails" Value="api/fieldtemplatedetails"></asp:ListItem>
                                <asp:ListItem Text="fieldtemplatedetail" Value="api/fieldtemplatedetail"></asp:ListItem>
                                <asp:ListItem Text="levels" Value="api/levels"></asp:ListItem>
                                <asp:ListItem Text="level" Value="api/level"></asp:ListItem>
                                <asp:ListItem Text="lists" Value="api/lists"></asp:ListItem>
                                <asp:ListItem Text="list" Value="api/list"></asp:ListItem>
                                <asp:ListItem Text="login" Value="api/login"></asp:ListItem>
                                <asp:ListItem Text="notes" Value="api/notes"></asp:ListItem>
                                <asp:ListItem Text="note" Value="api/note"></asp:ListItem>                                
                                <asp:ListItem Text="picklistvalues" Value="api/picklistvalues"></asp:ListItem>
                                <asp:ListItem Text="picklistvalue" Value="api/picklistvalue"></asp:ListItem>
                                <asp:ListItem Text="priorities" Value="api/priorities"></asp:ListItem>
                                <asp:ListItem Text="priority" Value="api/priority"></asp:ListItem>                                
                                <asp:ListItem Text="relatedlinks" Value="api/relatedlinks"></asp:ListItem>
                                <asp:ListItem Text="relatedlink" Value="api/relatedlink"></asp:ListItem>
                                <asp:ListItem Text="reply" Value="api/reply"></asp:ListItem>                               
                                 <asp:ListItem Text="roles" Value="api/roles"></asp:ListItem>
                                <asp:ListItem Text="role" Value="api/role"></asp:ListItem>
                                <asp:ListItem Text="rules" Value="api/rules"></asp:ListItem>
                                <asp:ListItem Text="rule" Value="api/rule"></asp:ListItem>
                                <asp:ListItem Text="search" Value="api/search"></asp:ListItem>
                                <asp:ListItem Text="slas" Value="api/slas"></asp:ListItem>
                                <asp:ListItem Text="sla" Value="api/sla"></asp:ListItem>
                                <asp:ListItem Text="statuses" Value="api/statuses"></asp:ListItem>
                                <asp:ListItem Text="status" Value="api/status"></asp:ListItem>                                                         
                                <asp:ListItem Text="tabs" Value="api/tabs"></asp:ListItem>
                                <asp:ListItem Text="tab" Value="api/tab"></asp:ListItem>
                                <asp:ListItem Text="tags" Value="api/tags"></asp:ListItem>
                                <asp:ListItem Text="tag" Value="api/tag"></asp:ListItem>                                
                                <asp:ListItem Text="terms" Value="api/terms"></asp:ListItem>
                                <asp:ListItem Text="term" Value="api/term"></asp:ListItem>
                                <asp:ListItem Text="tickets" Value="api/tickets"></asp:ListItem>
                                <asp:ListItem Text="ticket" Value="api/ticket"></asp:ListItem>                                
                                <asp:ListItem Text="types" Value="api/types"></asp:ListItem>
                                <asp:ListItem Text="type" Value="api/type"></asp:ListItem>                                                                                                                                       
                                <asp:ListItem Text="users" Value="api/users"></asp:ListItem>
                                <asp:ListItem Text="user" Value="api/user"></asp:ListItem>
                                <asp:ListItem Text="views" Value="api/views"></asp:ListItem>
                                <asp:ListItem Text="view" Value="api/view"></asp:ListItem>
                                <asp:ListItem Text="workflows" Value="api/workflows"></asp:ListItem>
                                <asp:ListItem Text="workflow" Value="api/workflow"></asp:ListItem>
                                <asp:ListItem Text="workflowsteps" Value="api/workflowsteps"></asp:ListItem>
                                <asp:ListItem Text="workflowstep" Value="api/workflowstep"></asp:ListItem>                                 
                            </asp:DropDownList>                                                        
                            <InstantASP:TextBox ID="txtParams" ClientIDMode="Static" CssClass="i-text-box" runat="server" />
                        </div>
                    </div>
                    <div class="i-row" style="display: none;" id="pnlParams">                      
                        <br />
                        <div class="i-row" style="display: none;" id="paramsContainer"></div>                      
                        <div class="i-row i-margin-bottom" style="display: none;" id="jsonContainer">
                            <textarea id="txtJSON" class="i-text-area" style="height: 250px;"></textarea>
                        </div>                      
                        <a href="javascript:void(0);" onclick="addParam();">Add Field</a> 
                        |
                        <a href="javascript:void(0);" onclick="addJSON();">Add JSON</a>
                    </div>
                </td>
            </tr>         
            <tr>
                <td class="i-col-light" style="width: 15%;"></td>
                <td class="i-col-light">                    
                    <InstantASP:HyperLink ID="hypSubmit" ClientIDMode="Static" CssClass="i-btn i-btn-2x i-btn-primary" runat="server">
                        <span>Submit</span>
                    </InstantASP:HyperLink>
                </td>
            </tr>
            <tr>         
                <td class="i-col-light" colspan="2">                                   
                    <div id="results">                        
                        <ul class="i-tabs-o">
                            <li><a href="#formatted" class="selected"><span class="padding">DATA</span></a></li>
                            <li><a href="#raw"><span class="padding">RAW</span></a></li>
                            <li><a href="#request"><span class="padding">REQUEST</span></a></li>
                            <li><a href="#statusResponse"><span class="padding">RESPONSE</span></a></li>
                        </ul>       
                        <div class="i-row results-scrollable">
                            <div class="i-row" id="formatted">
                                <div class="i-row" id="response">
                                    <table class="i-table">
                                        <tr>
                                            <td class="result-cell">
                                                <pre class="json-pre jjson"></pre>    
                                            </td>
                                        </tr>
                                    </table>  
                                </div>
                                <div class="i-row" id="error">                                            
                                    <table class="i-table">
                                        <tr>
                                            <td  class="result-cell">                                                
                                                <pre class="json-pre jjson"></pre>                                                
                                            </td>
                                        </tr>
                                    </table>    
                                </div>
                            </div>
                            <div class="i-row" id="raw">
                                <table class="i-table">
                                    <tr>
                                        <td class="result-cell">
                                            <textarea id="txtResponseJSON" style="width:99%; height: 500px;"></textarea>
                                        </td>
                                    </tr>
                                </table>   
                            </div>    
                            <div class="i-row" id="request">                                       
                                <table class="i-table">
                                    <tr>
                                        <td class="result-cell">                                                    
                                            <pre></pre>                                                    
                                        </td>
                                    </tr>
                                </table>      
                            </div>      
                            <div class="i-row" id="statusResponse">                                       
                                <table class="i-table">
                                    <tr>
                                        <td class="result-cell">                                                    
                                            <pre></pre>                                                    
                                        </td>
                                    </tr>
                                </table>      
                            </div>                                                                                               
                        </div>
                    </div>                      
                </td>
            </tr>
            </InstantASP:Table>
        </InstantASP:PanelBar>
    </telerik:RadPageView>
    <telerik:RadPageView id="RadPageView2" runat="server">
        <InstantASP:PanelBar id="ctlManageKeys" Collapseable="false" Text="AdminAPIExplorer_Tab2" TableName="tblManageKeys" Runat="Server">
            <InstantASP:Table id="tblManageKeys" class="i-table" Runat="Server">          
            <tr>
                <td class="i-col-light" style="width: 50%;">                                     
                    <InstantASP:Panel ID="pnlEnable" CssClass="i-row" runat="server">
                        The InstantKB REST API offers remote programmatic access to all the data stored within your InstantKB database.                         
                        Using the REST API you can create, read, update or delete data by making simple HTTP requests to specific API endpoints.<br /><br /> 
                        Access to the REST API requires at minimum an Application Key. The Application Key can be used to make requests for public data. 
                        To add, update or delete data or select private data you must combine the Application Key with a unique User Key within the request. The Application Key can be public however the User Key must remain private and only accessible to the user who owns the key.<br /><br />                        
                        To enable the REST API and generate a new Application Key use the Enable API Access button below. You can revoke API access at anytime once enabled. 
                        <br /><br />
                        <InstantASP:LinkButton ID="btnEnable" Text="AdminAPIExplorer_EnableAccess" CssClass="i-btn i-btn-2x i-btn-primary" runat="server">
                            <span>[0]</span>
                        </InstantASP:LinkButton>
                    </InstantASP:Panel>
                    <InstantASP:Panel ID="pnlDisable" CssClass="i-row" runat="server">
                        <div class="i-row">     
                            <span class="i-type-light">
                                Application Key
                                <instantasp:ToolTip TipWidth="300" TextNonLocalized="The Application Key can be public. This Application Key allows you to make requests into the various API endpoints as an anonymous user to return public data or perform further user authentication." runat="server"/>
                            </span>
                            <br /><br />
                            <InstantASP:TextBox ID="txtAppAPIKey" CssClass="i-text-box" runat="server" />
                            <br /><br />

                            <span class="i-type-light">
                                Application Secret
                                <instantasp:ToolTip TipWidth="300" TextNonLocalized="The Application Secret must remain private and never displayed to end users. The Application Secret never changes and allows you to optionally obtain the latest Application Key via  the api/auth?app_secret={secret} API endpoint." runat="server"/>
                            </span>
                            <br /><br />
                            <InstantASP:TextBox ID="txtAppAPISecret" CssClass="i-text-box" runat="server" />                            
                            <br /><br />

                            To make requests as an authenticated user to update records or select private data you must combine a User Key with the Application Key. You can try this by enabling API access for an existing support agent or administrator under the "User Keys" tab above. Once enabled click the "Explorer" tab above and select the user to connect as within the Auth Key section of Explorer tab.


                            <br /><br />
                        </div>
                        <div class="i-row">
                            <strong>WARNING:</strong> Revoking the Application Key will prevent all existing clients using this Application Key from making further requests into the InstantKB REST API. You can privately exchange the Application Secret for latest Application Key within your client applications if needed.<br /><br />                       
                            <InstantASP:LinkButton ID="btnRevoke" Text="AdminAPIExplorer_DiableAccess" CssClass="i-btn i-btn-2x i-btn-danger" runat="server">
                                <span>[0]</span>
                            </InstantASP:LinkButton>
                        </div>
                    </InstantASP:Panel>
                </td>
            </tr>
            </InstantASP:Table>
        </InstantASP:PanelBar>
    </telerik:RadPageView>       
    <telerik:RadPageView id="RadPageView3" runat="server">
        <InstantASP:PanelBar id="ctlUserKeys" Collapseable="false" Text="AdminAPIExplorer_Tab3" TableName="tblUserKeys" Runat="Server">
            <InstantASP:Table id="tblUserKeys" class="i-table" runat="server">
                <tr>
                    <td>
                        Generate a user key for any existing support agent below. To generate keys for regular users you will need to edit the users profile via the Admin CP > Users page. You can also return an existing user key or generate a new user key programmatically by calling the api/login endpoint with the application key and posting valid user credentials
                    </td>
                </tr>
                <tr>
                    <td class="i-col-light">
                                       
                        <InstantASP:DataGrid ID="ctlUsers" AllowSorting="True" AutoGenerateColumns="False" Width="100%" 
                        CssClass="i-table" ShowHeader="False" AllowPaging="False" NoRecordsTableCellCssClass="i-col-light" 
                        AllowCustomPaging="True" Runat="Server" FooterStyle-CssClass="i-col-dark">
                        <Columns>                     
                            <InstantASP:TemplateColumn ItemStyle-CssClass="i-col-light" ItemStyle-Wrap="False" 
		                        HeaderStyle-CssClass="i-col-header" ItemStyle-Width="10%">
	                            <ItemTemplate>	                    
                                    <InstantASP:LinkButton id="btnEnableUser" CssClass="i-btn i-btn-primary" Text="AdminAPIExplorer_EnableAccess" runat="server">
                                        <span>[0]</span>
                                    </InstantASP:LinkButton>
                                    <InstantASP:LinkButton id="btnDisableUser" CssClass="i-btn i-btn-danger" Text="AdminAPIExplorer_DiableAccess" runat="server">
                                        <span>[0]</span>
                                    </InstantASP:LinkButton>
	                            </ItemTemplate>	
                            </InstantASP:TemplateColumn>   	                	
                            <InstantASP:TemplateColumn ItemStyle-CssClass="i-col-light" ItemStyle-Wrap="False" 
		                        HeaderStyle-CssClass="i-col-header" ItemStyle-Width="90%">
	                            <ItemTemplate>	                    
                                    <div class="i-float-left">
                                        <InstantASP:Label id="lblUsername" CssClass="i-type-bold" runat="server" />
                                    </div> 
                                    <div class="i-float-right" id="pnlUserAPIKey" runat="server">                                                        
                                        <span class="i-type-light">User Key:</span> 
                                        <InstantASP:TextBox id="txtUserAPIKey" CssClass="i-text-box" style="width: 700px;" runat="server" />
                                    </div>
	                            </ItemTemplate>	
                            </InstantASP:TemplateColumn>                         
                        </Columns>
                        </InstantASP:DataGrid>		
                        
                    </td>
                </tr> 
            </InstantASP:Table>	
        </InstantASP:PanelBar>         
    </telerik:RadPageView>      
 </telerik:RadMultiPage>	

<script src="../js/helpers/apiexplorer/http.js"></script>
<script src="../js/helpers/apiexplorer/ui.js"></script>
