﻿<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>

<div class="i-row">
    <div class="i-col-9">
        
        <div class="i-row" style="width: 99%;">
            <InstantASP:PanelBar id="ctlReportPanelPanel" TableName="tblReport" Text="AdminHeader_OtherReports" Runat="Server">
            <InstantASP:Panel ID="tblReport" class="i-row" runat="server">	      
                <div style="padding: 12px;">
                    <div class="i-no-results" id="ctlArticleViewsNoResults" runat="server">
                        <div class="i-spacing">
                            <i class="fa fa-area-chart"></i>
                            <h2>No Data</h2>
                        </div>                        
                    </div>
                     <telerik:RadHtmlChart runat="server"  ID="ctlArticleViews">
                          <PlotArea>
                               <CommonTooltipsAppearance  Shared="true" Visible="true" Color="White">
                                      <SharedTemplate>                                          
                                      #= kendo.format(\'{0:D}\', category)#
                                           # for (var i = 0; i < points.length; i++) { #
                                                <div>#: points[i].series.name#: #: points[i].value #</div>
                                           # } #
                                      </SharedTemplate>
                                </CommonTooltipsAppearance>
                               <Series>
                                    <telerik:AreaSeries Name="Contact Tickets" DataFieldY="UserTickets">
                                        <LineAppearance LineStyle="Smooth" />
                                        <Appearance FillStyle-BackgroundColor="#E30000"  Overlay-Gradient="None">
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.UserTickets#
                                              </ClientTemplate>
                                         </LabelsAppearance>                                  
                                    </telerik:AreaSeries>
                                    <telerik:AreaSeries Name="Agent Tickets" DataFieldY="StaffTickets">
                                        <LineAppearance LineStyle="Smooth" />
                                        <Appearance FillStyle-BackgroundColor="#F88A41" Overlay-Gradient="None">
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.StaffTickets#
                                              </ClientTemplate>
                                         </LabelsAppearance>                                  
                                    </telerik:AreaSeries>
                                    <telerik:AreaSeries Name="Contact Replies" DataFieldY="UserReplies">
                                        <LineAppearance LineStyle="Smooth" />
                                        <Appearance FillStyle-BackgroundColor="#41BAF8" Overlay-Gradient="None">                                                                           
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.UserTickets#
                                              </ClientTemplate>
                                         </LabelsAppearance>                                  
                                    </telerik:AreaSeries>                               
                                    <telerik:AreaSeries Name="Agent Replies" DataFieldY="StaffReplies">
                                        <LineAppearance LineStyle="Smooth" />
                                        <Appearance FillStyle-BackgroundColor="#DBDE31" Overlay-Gradient="None">
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.UserTickets#
                                              </ClientTemplate>
                                         </LabelsAppearance>                                  
                                    </telerik:AreaSeries>
                                    <telerik:AreaSeries Name="Closed" DataFieldY="Closed">
                                        <LineAppearance LineStyle="Smooth" />
                                        <Appearance FillStyle-BackgroundColor="#7ACE73" Overlay-Gradient="None">                                                                           
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.Closed#
                                              </ClientTemplate>
                                         </LabelsAppearance>                                  
                                    </telerik:AreaSeries>
                                    <telerik:AreaSeries Name="Archived" DataFieldY="Archived">
                                        <LineAppearance LineStyle="Smooth" />
                                        <Appearance FillStyle-BackgroundColor="#dddddd" Overlay-Gradient="None">                                                                           
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.Archived#
                                              </ClientTemplate>
                                         </LabelsAppearance>                                  
                                    </telerik:AreaSeries>
                               </Series>
                               <XAxis Visible="true" Name="Date"  Type="Date" DataLabelsField="ReadDate">
                                    <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                                    <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                                   <LabelsAppearance  Step="2" />
                               </XAxis>
                               <YAxis>
                                    <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                                    <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                                    <LabelsAppearance DataFormatString="{0}" />                                 
                               </YAxis>
                          </PlotArea>                     
                          <Legend>                          
                               <Appearance Visible="true" Position="Bottom" />
                          </Legend>
                     </telerik:RadHtmlChart>
                </div>
            </InstantASP:Panel>
        </InstantASP:PanelBar>
        </div>
    </div>
    <div class="i-col-3">
        
       <InstantASP:PanelBar id="ctlFilterPanelBar" TableName="tblFilterPanelBar" Text="AdminHeader_Filter" Runat="Server">
        <InstantASP:Table ID="tblFilterPanelBar" class="i-table" runat="server">
                <tr>
                    <td class="i-col-light">                        
                        Start Date:<br />
                        <telerik:RadDatePicker ID="ddlStartDate" runat="server" /><br /><br />
                        End Date:<br />
                        <telerik:RadDatePicker ID="ddlEndDate" runat="server" />
                        <br /><br /> 
                        <InstantASP:Button ID="butFilter" TextNonLocalized="Update Reports" CssClass="i-button" runat="server" />
                    </td>
                </tr>
            </InstantASP:Table> 
        </InstantASP:PanelBar>
	         
    </div>
</div>

<InstantASP:Spacer runat="server" />

<div class="i-row">
    <div class="i-col-6">

        <div style="width: 99%">
            
        <InstantASP:PanelBar id="ctlNewTickets" TableName="tblNewTickets" Text="AdminHeader_ActivityBreakDown" Runat="Server">
         <InstantASP:Table class="i-table" ID="tblNewTickets" runat="server">            
            <tr>
                <td>
                    
                    <div class="i-no-results" id="ctlNewTicketsNoResults" runat="server">
                      <div class="i-spacing">
                            <i class="fa fa-bar-chart"></i>
                            <h2>No Data</h2>
                        </div>             
                    </div>
                    <telerik:RadHtmlChart runat="server" Legend-Appearance-Visible="true"  ID="ctlNewTicketsChart">
                          <PlotArea>
                              <Appearance RotationAngle="90">
                              </Appearance>                                                     
                               <Series>
                                    <telerik:ColumnSeries Name="New" DataFieldY="UserTickets">                                    
                                        <Appearance FillStyle-BackgroundColor="#FF0000" Overlay-Gradient="None">                                                                           
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.UserTickets#
                                              </ClientTemplate>
                                         </LabelsAppearance>    
                                          <TooltipsAppearance>
                                            <ClientTemplate>                                             
                                                 #=dataItem.ReadDate#<br />
                                                 New: #=dataItem.UserTickets# 
                                            </ClientTemplate>
                                        </TooltipsAppearance>     
                                    </telerik:ColumnSeries>
                                            
                               </Series>
                              <XAxis Visible="true" Name="Date" Type="Date" DataLabelsField="ReadDate">
                                    <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                                    <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                                   <LabelsAppearance  Step="2" />
                               </XAxis>
                               <YAxis>
                                    <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                                    <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                                    <LabelsAppearance DataFormatString="{0}" />                                 
                               </YAxis>
                          </PlotArea>                     
                           <Legend>                                 
                                <Appearance Visible="true" Position="Bottom" />
                            </Legend>
                     </telerik:RadHtmlChart>

                </td>
            </tr>
         </InstantASP:Table>
        </InstantASP:PanelBar> 

        <InstantASP:Spacer runat="server" />
            
        <InstantASP:PanelBar id="ctlClosedTickets" TableName="tblClosedTickets" Runat="Server">
         <InstantASP:Table class="i-table" ID="tblClosedTickets" runat="server">            
            <tr>
                <td>
                    
                    <div class="i-no-results" id="ctlClosedTicketsNoResults" runat="server">
                         <div class="i-spacing">
                            <i class="fa fa-bar-chart"></i>
                            <h2>No Data</h2>
                        </div>     
                    </div>
                    <telerik:RadHtmlChart runat="server"
                         Legend-Appearance-Visible="true"                          
                         ID="ctlClosedTicketsChart">
                          <PlotArea>
                              <Appearance RotationAngle="90">
                              </Appearance>                                                     
                               <Series>
                                    <telerik:ColumnSeries Stacked="true" Name="Closed" DataFieldY="ClosedTickets">                                    
                                        <Appearance FillStyle-BackgroundColor="#62C55A" Overlay-Gradient="None">  
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.ClosedTickets#
                                              </ClientTemplate>
                                         </LabelsAppearance>    
                                          <TooltipsAppearance>
                                            <ClientTemplate>                                             
                                                 #=dataItem.ReadDate#<br />
                                                 Closed: #=dataItem.ClosedTickets#<br/>
                                                Archived: #=dataItem.ArchivedTickets# 
                                            </ClientTemplate>
                                        </TooltipsAppearance>     
                                    </telerik:ColumnSeries>
                                    <telerik:ColumnSeries Stacked="true" Name="Archived" DataFieldY="ArchivedTickets">                                    
                                        <Appearance FillStyle-BackgroundColor="#eeeeee" Overlay-Gradient="None"> 
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.ArchivedTickets#
                                              </ClientTemplate>
                                         </LabelsAppearance>    
                                          <TooltipsAppearance>
                                            <ClientTemplate>                                             
                                                 #=dataItem.ReadDate#<br />
                                                Closed: #=dataItem.ClosedTickets#<br />
                                                 Archived: #=dataItem.ArchivedTickets# 
                                            </ClientTemplate>
                                        </TooltipsAppearance>     
                                    </telerik:ColumnSeries>
                                   
                                            
                               </Series>
                              <XAxis Visible="true" Name="Date" Type="Date" DataLabelsField="ReadDate">
                                    <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                                    <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                                   <LabelsAppearance  Step="2" />
                               </XAxis>
                               <YAxis>
                                    <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                                    <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                                    <LabelsAppearance DataFormatString="{0}" />                                 
                               </YAxis>
                          </PlotArea>                     
                           <Legend>                                 
                                <Appearance Visible="true" Position="Bottom" />
                            </Legend>
                     </telerik:RadHtmlChart>

                </td>
            </tr>
         </InstantASP:Table>
        </InstantASP:PanelBar> 
             
        <InstantASP:Spacer runat="server" />
            
        <InstantASP:PanelBar id="ctlMostWorkedReceived" TableName="ctlMostWorkedReceivedGrid" Text="AdminHeader_ReportsTopCustomers" Runat="Server">
            <InstantASP:DataGrid ID="ctlMostWorkedReceivedGrid" AutoGenerateColumns="False" Width="100%" NoRecordsText="AdminHeader_NoReportData"
            CssClass="i-table" ShowHeader="true" AllowPaging="False" NoRecordsTableCellCssClass="i-col-light" 
            AllowCustomPaging="True" Runat="Server">
            <Columns>                        
		  	    <InstantASP:TemplateColumn ItemStyle-Width="80%" HeaderText="DataViewType_UserTickets"
                 ItemStyle-CssClass="i-col-light" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>	         
                         <InstantASP:Hyperlink id="hypTitle" CssClass="i-type-bold" EnableViewState="False" Runat="Server">
                            <span>[0]</span>
                        </InstantASP:Hyperlink>    
                        <div class="i-float-right">
                            <InstantASP:Label id="lblTicketType" CssClass="light-text" runat="server" />
                        </div>                        
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>      
                  <InstantASP:TemplateColumn ItemStyle-Width="20%"  HeaderText="Field_TicketTimeWorked"
                 ItemStyle-CssClass="i-col-light" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="center" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>	      
                      <InstantASP:Label id="lblTimeWorked" runat="server" />                     
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>     
                <InstantASP:TemplateColumn ItemStyle-Width="20%"  HeaderText="Field_TicketReplies"
                 ItemStyle-CssClass="i-col-light" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="center" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>	      
                        <InstantASP:Label ID="lblViews" runat="server"/><br />                        
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>             	            
            </Columns>
            </InstantASP:DataGrid>
        </InstantASP:PanelBar>
        
        <InstantASP:Spacer runat="server" />

        <InstantASP:PanelBar id="ctlMostReceived" TableName="ctlMostReceivedGrid" Text="AdminHeader_ReportsMostReceived" Runat="Server">
            <InstantASP:DataGrid ID="ctlMostReceivedGrid" AutoGenerateColumns="False" Width="100%" NoRecordsText="AdminHeader_NoReportData"
            CssClass="i-table" ShowHeader="true" AllowPaging="False" NoRecordsTableCellCssClass="i-col-light" 
            AllowCustomPaging="True" Runat="Server">
            <Columns>                        
		  	    <InstantASP:TemplateColumn ItemStyle-Width="80%" HeaderText="DataViewType_UserTickets"
                 ItemStyle-CssClass="i-col-light" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>	         
                         <InstantASP:Hyperlink id="hypTitle" CssClass="i-type-bold" EnableViewState="False" Runat="Server">
                            <span>[0]</span>
                        </InstantASP:Hyperlink>    
                        <div class="i-float-right">
                            <InstantASP:Label id="lblTicketType" CssClass="light-text" runat="server" />
                        </div>                        
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>          
                <InstantASP:TemplateColumn ItemStyle-Width="20%"  HeaderText="AdminViewReportUserStats_TotalTickets"
                 ItemStyle-CssClass="i-col-light" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="center" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>	      
                        <InstantASP:Label ID="lblViews" runat="server"/><br />                        
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>             	            
            </Columns>
            </InstantASP:DataGrid>
        </InstantASP:PanelBar>
        
        <InstantASP:Spacer runat="server" />

        <InstantASP:PanelBar id="ctlExtraReports" TableName="tblExreaReports" Text="AdminHeader_OtherReports" Runat="Server">
        <InstantASP:Panel ID="tblExreaReports" class="i-row" runat="server">
	      
            <InstantASP:DataGrid ID="ctlExtraReportsGrid" AutoGenerateColumns="False" Width="100%" 
            CssClass="i-table" ShowHeader="false" AllowPaging="False" NoRecordsTableCellCssClass="i-col-light" 
            AllowCustomPaging="True" Runat="Server">
            <Columns>                        
		  	    <InstantASP:TemplateColumn ItemStyle-Width="100%" 
                 ItemStyle-CssClass="i-col-light" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>	         
                         <InstantASP:Hyperlink id="hypTitle" EnableViewState="False" Runat="Server">
                            <span>
                                <InstantASP:Label ID="lblTitle" CssClass="i-type-bold" runat="server"/><br />			                	          
                            </span>
                        </InstantASP:Hyperlink> 
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>            	            
            </Columns>
            </InstantASP:DataGrid>
            	 	          
        </InstantASP:Panel>
        </InstantASP:PanelBar>
        
        </div>

    </div>
    <div class="i-col-6">

        <InstantASP:PanelBar id="ctlTrafficSummary" TableName="tblTrafficSummary" Text="AdminHeader_ActivityBreakDown" Runat="Server">
         <InstantASP:Table class="i-table" ID="tblTrafficSummary" runat="server">            
            <tr>
                <td>
                    
                    <div class="i-no-results" id="ctlTrafficPieNoResults" runat="server">
                        <div class="i-spacing">
                            <i class="fa fa-pie-chart"></i>
                            <h2>No Data</h2>
                        </div>             
                    </div>
                    <telerik:RadHtmlChart runat="server" Legend-Appearance-Visible="true"  ID="ctlTrafficPie">
                          <PlotArea>
                              <Appearance RotationAngle="90">
                              </Appearance>                                                     
                               <Series>
                                    <telerik:DonutSeries HoleSize="85" ColorField="Color" Name="Members" NameField="Text" DataFieldY="Count">                                    
                                        <Appearance FillStyle-BackgroundColor="#FF0000" Overlay-Gradient="None">
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.MemberCount#
                                              </ClientTemplate>
                                         </LabelsAppearance>    
                                          <TooltipsAppearance>
                                            <ClientTemplate>                                             
                                                  #=dataItem.Text# - #= kendo.format(\'{0:p}\', percentage)# (#= kendo.format(\'{0:n}\', kendo.toString(dataItem.Count, \'d\'))# total)
                                            </ClientTemplate>
                                        </TooltipsAppearance>   
                                          
                                    </telerik:DonutSeries>
                                            
                               </Series>
                               <XAxis Visible="true" Name="Date" DataLabelsField="Text">
                                    <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                                    <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                                   <LabelsAppearance  />
                               </XAxis>
                               <YAxis>
                                    <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                                    <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                                    <LabelsAppearance DataFormatString="{0}"  />                                 
                               </YAxis>
                          </PlotArea>                     
                           <Legend>                                 
                                <Appearance Visible="true" Position="Bottom" />
                            </Legend>
                     </telerik:RadHtmlChart>

                </td>
            </tr>
         </InstantASP:Table>
        </InstantASP:PanelBar> 
        <InstantASP:Spacer runat="server" />
        
        <InstantASP:PanelBar id="ctlChannelSummary" TableName="tblTrafficSummary" Text="AdminHeader_Channel" Runat="Server">
         <InstantASP:Table class="i-table" ID="Table1" runat="server">            
            <tr>
                <td>
                    
                    <div class="i-no-results" id="ctlChannelPieNoResults" runat="server">
                         <div class="i-spacing">
                            <i class="fa fa-pie-chart"></i>
                            <h2>No Data</h2>
                        </div>      
                    </div>
                    <telerik:RadHtmlChart runat="server" Legend-Appearance-Visible="true"  ID="ctlChannelPie">
                          <PlotArea>
                              <Appearance RotationAngle="90">
                              </Appearance>                                                     
                               <Series>
                                    <telerik:DonutSeries HoleSize="85" ColorField="Color" Name="Members" NameField="Text" DataFieldY="Count">                                    
                                        <Appearance FillStyle-BackgroundColor="#FF0000" Overlay-Gradient="None">
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.MemberCount#
                                              </ClientTemplate>
                                         </LabelsAppearance>    
                                          <TooltipsAppearance>
                                            <ClientTemplate>                                             
                                                  #=dataItem.Text# - #= kendo.format(\'{0:p}\', percentage)# (#= kendo.format(\'{0:n}\', kendo.toString(dataItem.Count, \'d\'))# total)
                                            </ClientTemplate>
                                        </TooltipsAppearance>     
                                    </telerik:DonutSeries>
                                            
                               </Series>
                               <XAxis Visible="true" Name="Date" DataLabelsField="Text">
                                    <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                                    <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                                   <LabelsAppearance  />
                               </XAxis>
                               <YAxis>
                                    <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                                    <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                                    <LabelsAppearance DataFormatString="{0}"  />                                 
                               </YAxis>
                          </PlotArea>                     
                           <Legend>                                 
                                <Appearance Visible="true" Position="Bottom" />
                            </Legend>
                     </telerik:RadHtmlChart>

                </td>
            </tr>
         </InstantASP:Table>
        </InstantASP:PanelBar> 
        <InstantASP:Spacer runat="server" />
                    
        <InstantASP:PanelBar id="ctlTopTickets" TableName="ctlTopTicketsGrid" Runat="Server">
            <InstantASP:DataGrid ID="ctlTopTicketsGrid" AutoGenerateColumns="False" Width="100%" NoRecordsText="AdminHeader_NoReportData"
            CssClass="i-table" ShowHeader="true" AllowPaging="False" NoRecordsTableCellCssClass="i-col-light" 
            AllowCustomPaging="True" Runat="Server">
            <Columns>                        
		  	    <InstantASP:TemplateColumn ItemStyle-Width="80%" HeaderText="Field_StepTitle"
                 ItemStyle-CssClass="i-col-light" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>	         
                         <InstantASP:Hyperlink id="hypTitle" EnableViewState="False" Runat="Server">
                            <span>
                                <InstantASP:Label ID="lbltitle" CssClass="i-type-bold" runat="server"/><br />			                	          
                            </span>
                        </InstantASP:Hyperlink> 
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>       
                <InstantASP:TemplateColumn ItemStyle-Width="20%"  HeaderText="Field_TicketReplies"
                 ItemStyle-CssClass="i-col-light" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="center" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>	     
                        <InstantASP:Label ID="lblReplies" runat="server"/><br />			                	                                  
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>             	            
            </Columns>
            </InstantASP:DataGrid>
        </InstantASP:PanelBar>
       
    </div>

</div>


