﻿<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>

<InstantASP:PanelBar id="ctlReportPanelPanel" TableName="tblReport" Text="AdminHeader_OtherReports" Runat="Server">
<InstantASP:Panel ID="tblReport" class="i-row" runat="server">	      
    <div style="padding: 12px;">
        <div class="i-no-results" id="ctlArticleViewsNoResults" runat="server">
            <div class="i-spacing">
                <i class="fa fa-area-chart"></i>
                <h2>No recent user activity</h2>
            </div>
        </div>
            <telerik:RadHtmlChart runat="server"  ID="ctlArticleViews">
                <PlotArea>
                    <CommonTooltipsAppearance Shared="true" Visible="true" Color="White">
                            <SharedTemplate>                                          
                            #= kendo.format(\'{0:D}\', category)#
                                # for (var i = 0; i < points.length; i++) { #
                                    <div>#: points[i].series.name#: #: points[i].value #</div>
                                # } #
                            </SharedTemplate>
                    </CommonTooltipsAppearance>
                    <Series>
                        <telerik:ColumnSeries Stacked="true" Gap="0.3" Name="In" DataFieldY="UserTickets">                            
                            <Appearance FillStyle-BackgroundColor="#D55128" Overlay-Gradient="None">                                                                           
                            </Appearance>                         
                                <LabelsAppearance Visible="false">
                                    <ClientTemplate>
                                        #=dataItem.UserTickets#
                                    </ClientTemplate>
                                </LabelsAppearance>                                  
                        </telerik:ColumnSeries>
                        <telerik:ColumnSeries Stacked="true" Gap="0" Name="Out" DataFieldY="AgentTickets">                            
                            <Appearance FillStyle-BackgroundColor="#FA8D00" Overlay-Gradient="None">                                                                           
                            </Appearance>                         
                                <LabelsAppearance Visible="false">
                                    <ClientTemplate>
                                        #=dataItem.AgentTickets#
                                    </ClientTemplate>
                                </LabelsAppearance>                                  
                        </telerik:ColumnSeries>
                        <telerik:ColumnSeries Stacked="true" Gap="0" Name="Reply In" DataFieldY="UserReplies">                            
                            <Appearance FillStyle-BackgroundColor="#499EDF" Overlay-Gradient="None">                                                                           
                            </Appearance>                         
                                <LabelsAppearance Visible="false">
                                    <ClientTemplate>
                                        #=dataItem.UserReplies#
                                    </ClientTemplate>
                                </LabelsAppearance>                                  
                        </telerik:ColumnSeries>        
                         <telerik:ColumnSeries Stacked="true" Gap="0" Name="Reply Out" DataFieldY="AgentReplies">                            
                            <Appearance FillStyle-BackgroundColor="#DFCE0D" Overlay-Gradient="None">                                                                           
                            </Appearance>                         
                                <LabelsAppearance Visible="false">
                                    <ClientTemplate>
                                        #=dataItem.AgentReplies#
                                    </ClientTemplate>
                                </LabelsAppearance>                                  
                        </telerik:ColumnSeries>             
                        <telerik:ColumnSeries Stacked="true" Name="Closed" DataFieldY="Closed">                            
                            <Appearance FillStyle-BackgroundColor="#62C55A" Overlay-Gradient="None">                                                                           
                            </Appearance>                         
                                <LabelsAppearance Visible="false">
                                    <ClientTemplate>
                                        #=dataItem.Closed#
                                    </ClientTemplate>
                                </LabelsAppearance>                                  
                        </telerik:ColumnSeries>
                        <telerik:ColumnSeries Stacked="true" Gap="0" Name="Read Articles" DataFieldY="ReadArticles">                            
                            <Appearance FillStyle-BackgroundColor="#cccccc" Overlay-Gradient="None">
                            </Appearance>                         
                                <LabelsAppearance Visible="false">
                                    <ClientTemplate>
                                        #=dataItem.ReadArticles#
                                    </ClientTemplate>
                                </LabelsAppearance>                                  
                        </telerik:ColumnSeries>
                    </Series>
                    <XAxis Visible="true" Name="Date"  Type="Date" DataLabelsField="ReadDate">
                        <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                        <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                        <LabelsAppearance  Step="2" />
                    </XAxis>
                    <YAxis>
                        <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                        <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                        <LabelsAppearance DataFormatString="{0}" />                                 
                    </YAxis>
                </PlotArea>                     
                <Legend>                          
                    <Appearance Visible="true" Position="Bottom" />
                </Legend>
            </telerik:RadHtmlChart>
    </div>
</InstantASP:Panel>
</InstantASP:PanelBar>
 