<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>

<InstantKB:AdminHeader id="ctlAdminHeader" Runat="Server"/>

<InstantKB:AdminPageTitle id="ctlAdminPageTitle" Runat="Server"/>

<InstantASP:Spacer Runat="Server"/>

<InstantASP:Summary id="ctlSummary" Runat="Server"/>

<InstantASP:PanelBar TableName="tblEditUserDetails" id="ctlPanelBar" runat="Server">
	<InstantASP:Table id="tblEditUserDetails" class="i-table" Runat="Server">
	<tr>
	<td class="i-col-header" colspan="2">
	    <InstantASP:Label id="lblSubHeader1" Text="AdminEditMemberDetails_SubHeader" Runat="server"/>
	</td>
	</tr>	
	<tr id="trCurrentDetails" runat="server">
		<td style="width: 30%;" class="i-col-light">
		<InstantASP:Label id="lblCurrentDetail1" CssClass="i-type-bold" Runat="server"/>
		</td>
		<td class="i-col-light">
		<InstantASP:Label id="lblCurrentDetail2" Runat="server"/>
		</td>
	</tr>
	<tr>
		<td style="width: 30%;" class="i-col-light">
		    <InstantASP:Label id="lblNewDetail1" CssClass="i-type-bold" Runat="server"/><br />
		    <InstantASP:Label id="lblNewDetail2" Runat="server"/>
		</td>
		<td class="i-col-light">
		
		    <InstantASP:TextBox id="txtNewDetail" CssClass="i-text-box" Runat="Server"/>		
		     <InstantASP:CalloutValidatorExtender id="txtNewDetailRequiredFieldValidator" ShortErrorMessage="FormValidation_DefaultText" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtNewDetail" ErrorMessage="FormValidation_CallOutExtenderDefaultText"/>
	        </InstantASP:CalloutValidatorExtender>	    
            <InstantASP:CalloutValidatorExtender id="txtNewDetailEmailRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
	            <RegExValidator ControlToValidate="txtNewDetail" ErrorMessage="LogonControl_EmailAddressInvalid" ValidationExpression="\S+@\S+\.\S{2,4}"/>
	        </InstantASP:CalloutValidatorExtender>	    
	        <InstantASP:CalloutValidatorExtender id="txtNewDetailPasswordRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
	            <RegExValidator ControlToValidate="txtNewDetail" ErrorMessage="LogonControl_PasswordLength" ValidationExpression="\S{4,32}"/>
	        </InstantASP:CalloutValidatorExtender>
		
		</td>
	</tr>	
	<tr>
		<td style="width: 30%;" class="i-col-light" valign="top">
            <InstantASP:Label id="lblEmailContent" Text="AdminEditMemberDetails_EmailContents" CssClass="i-type-bold" Runat="Server"/>
		</td>	
		<td class="i-col-light">
				<InstantASP:TextBox id="txtEmailContents" 
				TextMode="Multiline" Width="100%" Height="200"
				CssClass="i-text-box" Runat="Server"/>	
		</td>
	</tr>
	<tr>
		<td style="width: 30%;" class="i-col-light">
		    <InstantASP:Label id="lblSendEmailNotification" Text="AdminEditMemberDetails_SendEmail" CssClass="i-type-bold" Runat="Server"/>
		</td>	
		<td class="i-col-light">
		    <InstantASP:YesNoRadioButtons id="rbSendEmail" RepeatDirection="Horizontal" RepeatLayout="Flow" CssClass="SmallTxt" Runat="Server"/>
		</td>
	</tr>
	<tr>
	    <td style="width: 30%;" class="i-col-light">&nbsp;</td>
	    <td class="i-col-light">
	        <InstantASP:Button id="butSubmit" DisableAfterClick="True"
	        CssClass="i-button" Text="Button_Submit" DisabledText="Button_PleaseWait" runat="server"/>
	    </td>
	</tr>
	</InstantASP:Table>
</InstantASP:PanelBar>

<InstantKB:AdminFooter Runat="Server"/>