<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register TagPrefix="AjaxToolkit" Namespace="AjaxControlToolkit" Assembly="AjaxControlToolkit" %>

<InstantKB:ViewArticleComments id="ctlViewArticleComments" Runat="Server" />

<InstantASP:Summary ID="ctlSummary" visible="False" runat="Server" />

<InstantASP:Panel id="pnlPreview" visible="False" Runat="Server">
    <InstantKB:ViewArticleComments id="ctlViewArticleCommentPreview" Runat="Server" />     
</InstantASP:Panel>

<InstantASP:Label id="lblRateConfirmation" Runat="Server" />
<InstantASP:Label id="lblRateError" Runat="Server" />
  
<asp:UpdateProgress ID="ctlUpdateProgress" Visible="false" runat="Server" />
<asp:UpdatePanel ID="ctlUpdatePanel" Runat="Server"/>

<InstantASP:Panel id="pnlAddComments" runat="server" class="i-row">

    <InstantASP:Panel ID="pnlLoginRequired" CssClass="i-row ikb-box ikb-box-default" runat="server">
        <span class="padding">
            <i class="fa fa-lock i-type-light i-margin-right-small"></i>
            <InstantASP:Label ID="lblLoginRequired1" Text="AddArticleComments_LoginRequired1" runat="Server" />
            <InstantASP:HyperLink ID="hypLogin" Text="AddArticleComments_LoginRequired2" runat="Server" />
            <InstantASP:Label ID="lblLoginRequired2" Text="AddArticleComments_LoginRequired3" runat="Server" />
            <InstantASP:HyperLink ID="hypRegister" Text="AddArticleComments_LoginRequired4" runat="Server" />.
        </span>
    </InstantASP:Panel> 
                     
    <InstantASP:Panel ID="pnlShowCommentBox" CssClass="i-row ikb-box ikb-box-default" runat="server">
        <span class="padding">
            <i class="fa fa-comment i-type-light i-margin-right-small"></i>
            <InstantASP:LinkButton ID="hypShowCommentBox" Text="AddArticleComments_LeaveComments" runat="server">
                <span>[0]</span>
            </InstantASP:LinkButton>                
        </span>
    </InstantASP:Panel>

    <InstantASP:Panel ID="pnlCommentBox" Visible="false" CssClass="i-row" runat="server">
        <div class="i-row">         
            <h6 class="h6"><InstantASP:Label ID="lblHeader" Text="AddArticleComments_Header" runat="Server" /></h6>        
        </div>
        <InstantASP:Spacer runat="server" />
        <table id="tblAddComment" class="i-table" runat="server">
            <tr id="trUsername" runat="Server">
                <td style="width: 30%;">
                    <InstantASP:Label ID="lblName" Text="AddArticleComments_Name" CssClass="i-type-bold" runat="Server" />
                </td>
                <td>
                    <InstantASP:TextBox CssClass="i-text-box" ID="txtUserName" TabIndex="1" runat="Server" />
                    <InstantASP:CalloutValidatorExtender ID="txtUserNameRequiredFieldValidator" ShowRequiredFieldLabel="True" ShortErrorMessage="RequiredField" runat="Server">
                        <requiredfieldvalidator controltovalidate="txtUserName" errormessage="AddArticleComments_CommentsSavedNoUsername" />
                    </InstantASP:CalloutValidatorExtender>
                </td>
            </tr>
            <tr id="trEmailAddress" runat="Server">
                <td style="width: 30%;">
                    <InstantASP:Label ID="lblEmailAddress" Text="AddArticleComments_EmailAddress" CssClass="i-type-bold" runat="Server" />
                </td>
                <td>
                    <InstantASP:TextBox CssClass="i-text-box" ID="txtEmailAddress" TabIndex="2" runat="Server" />
                </td>
            </tr>
            <tr id="trWebAddress" visible="false" runat="Server">
                <td>
                    <InstantASP:Label ID="lblWebAddress" Text="AddArticleComments_WebAddress" CssClass="i-type-bold" runat="Server" />
                </td>
                <td>
                    <InstantASP:TextBox CssClass="i-text-box" ID="txtWebAddress" TabIndex="3" runat="Server" />
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    
                    <InstantASP:TextArea ID="txtComments" Rows="12" Cols="1" TabIndex="4" class="i-text-area" style="Width: 98%;" runat="Server" />
                    <InstantASP:CalloutValidatorExtender ID="txtCommentsRequiredFieldValidator" ShowRequiredFieldLabel="False" ShortErrorMessage="RequiredField" runat="Server">
                        <requiredfieldvalidator controltovalidate="txtComments" errormessage="AddArticleComments_CommentsRequired" />
                    </InstantASP:CalloutValidatorExtender>

                </td>
            </tr>

            <tr id="trVerificationImage1" runat="server">
                <td style="width: 30%;">
                    <InstantASP:Label Text="AddArticleComments_VerificationCode" ID="lblSecurityCode" CssClass="i-type-bold" runat="server" />
                </td>
                <td>
                    <div style="float: left; margin-right: 8px;">
                        <div class="Captcha">
                            <InstantASP:Image ID="imgCaptchaImage" runat="Server" />
                        </div>
                    </div>
                    <div style="float: left; margin-top: 9px;">
                        <InstantASP:TextBox CssClass="i-text-box" Width="100" TabIndex="5" ID="txtCaptchaCode" runat="Server" />
                        <InstantASP:CalloutValidatorExtender ID="txtCaptchaCodeRequiredFieldValidator" ShortErrorMessage="RequiredField" runat="Server">
                            <requiredfieldvalidator controltovalidate="txtCaptchaCode" errormessage="Register_CaptchaCodeRequired" />
                        </InstantASP:CalloutValidatorExtender>
                    </div>

                </td>
            </tr>
            <tr>        
                <td>
                    <asp:Button ID="butSubmit" CssClass="i-button" CausesValidation="True" runat="Server" />
                    <asp:Button ID="butPreview" Visible="false" CssClass="i-button" runat="Server" />
                </td>
            </tr>
        </table>
    </InstantASP:Panel>
    
    <InstantASP:Spacer runat="server" />

</InstantASP:Panel>

