<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<InstantASP:PanelBar Text="LogonControl_Logon1" TableName="tblLogon" id="ctlLoginControls" runat="Server">
	<InstantASP:Table id="tblLogon" class="i-table i-responsive-table" Runat="Server">
	<tr>
	    <td class="i-col-header" colspan="2">
	        <InstantASP:Label Text="LogonControl_Logon2" id="lblSubHeader" Runat="server"/>
	    </td>
	</tr>
	<tr>
	<td style="width: 30%;" class="i-col-light">
	
	    <InstantASP:Label id="lblUsername1" CssClass="i-type-bold" Runat="server"/><br />
	    <InstantASP:Label id="lblUsername2" Visible="false" data-mobile="false" runat="server"/>
	    
	</td>
	<td class="i-col-light">
	
	    <InstantASP:TextBox CssClass="i-text-box" id="txtUserName" runat="Server"/> 
	    	
	    <InstantASP:CalloutValidatorExtender id="txtUsernameRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	        <RequiredFieldValidator ControlToValidate="txtUserName"/>
	    </InstantASP:CalloutValidatorExtender>
	    
        <InstantASP:CalloutValidatorExtender id="txtUsernameRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
	        <RegExValidator ControlToValidate="txtUserName" ErrorMessage="LogonControl_EmailAddressInvalid" ValidationExpression="\S+@\S+\.\S{2,4}"/>
	    </InstantASP:CalloutValidatorExtender>
	    
   </td>
   </tr>
   <tr>
	<td style="width: 30%;" class="i-col-light">
	
	    <InstantASP:Label Text="LogonControl_LogonPassword1" id="lblPassword1" CssClass="i-type-bold" Runat="server"/><br />
	    <InstantASP:Label Text="LogonControl_LogonPassword2" id="lblPassword2" Visible="false" data-mobile="false" Runat="server"/>	    
	</td>	    
	<td class="i-col-light">
	
	    <InstantASP:TextBox CssClass="i-text-box" TextMode="Password" id="txtPassword" runat="Server"/> 
	    	    	
	    <InstantASP:CalloutValidatorExtender id="txtPasswordRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	        <RequiredFieldValidator ControlToValidate="txtPassword" ErrorMessage="LogonControl_PasswordRequired"/>
	    </InstantASP:CalloutValidatorExtender>
	    
        <InstantASP:CalloutValidatorExtender id="txtPasswordRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
	        <RegExValidator ControlToValidate="txtPassword" ErrorMessage="LogonControl_PasswordLength" ValidationExpression="\S{4,32}"/>
	    </InstantASP:CalloutValidatorExtender>

	</td>
	</tr>
	<tr>
	<td style="width: 30%;" class="i-col-light"></td>
	<td class="i-col-light">
	
	    <asp:Button id="butLogon" CausesValidation="True" CssClass="i-button" runat="server"/> 
	    <InstantASP:Button id="butRegister" Visible="false" CausesValidation="False" CssClass="i-button" Text="Button_Register" runat="server"/>
	    
	</td></tr>
	</InstantASP:Table>
</InstantASP:PanelBar>

<InstantASP:Spacer id="lblSpacer" Runat="Server"/>

<InstantASP:PanelBar Text="LogonControl_LogonOptions" TableName="tblLogonOptions" id="ctlLoginOptions" runat="Server">
	<InstantASP:Table id="tblLogonOptions" class="i-table i-responsive-table" Runat="Server">
	<tr>
        <td class="i-col-light" style="width:50%;">
	
			<InstantASP:CheckBox id="ckbRememberMe" Checked="true" Text="LogonControl_RememberMe" runat="server"/><br />
			<InstantASP:CheckBox id="ckbLogonAnonymous" Visible="false" Text="LogonControl_AnonymousLogin" runat="server"/>
            <InstantASP:CheckBox id="ckbLDAPLogin" Text="LogonControl_LDAPLogin" runat="server"/>		

	    </td>
        <td class="i-col-light" style="width:50%;">
				
			<InstantASP:Hyperlink id="hypForgotPassword" Text="LogonControl_ForgotPassword" runat="server"/><br />
			<InstantASP:Hyperlink id="hypSendValidationCode" Text="LogonControl_SendValidationEmail" runat="server"/>		
		
	    </td>
	</tr>
	</InstantASP:Table>	
</InstantASP:PanelBar>
