<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<InstantASP:PanelBar Text="Register_Title" TableName="tblRegister" id="ctlPanelBar" runat="Server">
	<InstantASP:Table id="tblRegister" class="i-table i-responsive-table" Runat="Server">
	<tr>
	    <td class="i-col-header" colspan="2">
	        <InstantASP:Label Text="Register_UserDetails" id="lblSubHeader" Runat="server"/>
	    </td>
	</tr>
	<tr>
	    <td style="width: 30%;" class="i-col-light">
    	
	        <InstantASP:Label Text="Register_UserName" CssClass="i-type-bold" id="lblUsername1" Runat="server"/><br />
	        <InstantASP:Label Text="Register_UserNameDescription" Visible="false" id="lblUsername2" Runat="Server"/>
	    
	    </td>
	    <td class="i-col-light"> 
	
	        <InstantASP:TextBox CssClass="i-text-box" id="txtUserName" TabIndex="1" runat="Server"/>
	  	
	        <InstantASP:CalloutValidatorExtender id="txtUsernameRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtUserName" ErrorMessage="Register_UserNameRequired"/>
	        </InstantASP:CalloutValidatorExtender>
    	    
	    </td>
	</tr>
	<tr>
	    <td style="width: 30%;" class="i-col-light">
        	
	        <InstantASP:Label Text="Register_EmailAddress" CssClass="i-type-bold" id="lblEmailAddress1" Runat="server"/><br />
	        <InstantASP:Label Text="Register_EmailAddressDescription" Visible="false" id="lblEmailAddress2" Runat="Server"/>
        	
	    </td>
	    <td class="i-col-light">
    	
	        <InstantASP:TextBox CssClass="i-text-box" id="txtEmailAddress" TabIndex="2" runat="Server"/>

	        <InstantASP:CalloutValidatorExtender id="txtEmailAddressRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtEmailAddress" ErrorMessage="Register_EmailAddressRequired"/>
	        </InstantASP:CalloutValidatorExtender>
    	    
            <InstantASP:CalloutValidatorExtender id="txtEmailAddressRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
	            <RegExValidator ControlToValidate="txtEmailAddress" ErrorMessage="Register_EmailAddressInvalid" ValidationExpression="\S+@\S+\.\S{2,4}"/>
	        </InstantASP:CalloutValidatorExtender>
	    
	    </td>
	</tr>
	<tr>
	    <td style="width: 30%;" class="i-col-light">
    	
	        <InstantASP:Label Text="Register_Password1" CssClass="i-type-bold" id="lblPassword1" Runat="server"/><br />
	        <InstantASP:Label Text="Register_Password1Description" Visible="false" id="lblPassword2" Runat="Server"/>
    	
	    </td>
	    <td class="i-col-light">
    	
	        <InstantASP:TextBox TextMode="Password" TabIndex="3" CssClass="i-text-box" id="txtPassword" runat="Server"/> 
    	    
	        <InstantASP:CalloutValidatorExtender id="txtPasswordRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtPassword" ErrorMessage="Register_Password1Required"/>
	        </InstantASP:CalloutValidatorExtender>
    	    
            <InstantASP:CalloutValidatorExtender id="txtPasswordRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
	            <RegExValidator ControlToValidate="txtPassword" ErrorMessage="Register_PasswordLength" ValidationExpression="\S{4,32}"/>
	        </InstantASP:CalloutValidatorExtender>
        	
	    </td>
	</tr>
	
	<tr>
	    <td style="width: 30%;" class="i-col-light">
    	
	        <InstantASP:Label Text="Register_Password2" id="lblConfirmPassword1" CssClass="i-type-bold" Runat="server"/><br />
	        <InstantASP:Label Text="Register_Password2Description" Visible="false" id="lblConfirmPassword2" Runat="Server"/>
        	
	    </td>
	    <td class="i-col-light">
    	
	        <InstantASP:TextBox TextMode="Password" TabIndex="4" CssClass="i-text-box" id="txtPasswordConfirmation" runat="Server" /> 
	        	        
	        <InstantASP:CalloutValidatorExtender id="txtPasswordConfirmationRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtPasswordConfirmation" ErrorMessage="Register_Password2Required"/>
	        </InstantASP:CalloutValidatorExtender>
    	    
            <InstantASP:CalloutValidatorExtender id="txtPasswordConfirmationCompareValidator" ShortErrorMessage="InvalidMatch" Runat="Server">
	            <CompareValidator ControlToValidate="txtPasswordConfirmation" ControlToCompare="txtPassword" ErrorMessage="Register_Password2NoMatch"/>
	        </InstantASP:CalloutValidatorExtender>
	    	
	    </td>
	</tr>
	<tr visible="False" runat="Server">
	    <td class="i-col-header" colspan="2">
	    
	        <InstantASP:Label Text="Register_OptionalSettings" id="lblSettings" Runat="server"/>
	        
	    </td>
	</tr>
	
	 <tr>
	    <td style="width: 30%;" class="i-col-light">
	    
	        <InstantASP:Label Text="Register_TimeZone" CssClass="i-type-bold" id="lblTimeZone1" Runat="server"/><br />
	        <InstantASP:Label Text="Register_TimeZoneDescription" id="lblTimeZone2" data-mobile="false" Runat="Server"/>
	        
	        </td>
	    <td class="i-col-light">
    	    
	        <InstantASP:TimeZones TabIndex="6" CssClass="i-select" Width="70%" id="ddlTimeZones" runat="Server"/>
	        <br /><br />
	        <InstantASP:CheckBox id="ckbObserveDaylightSavingTime" Text="Register_ObserveDaylightSavingTime" Runat="Server"/>
	    
	    </td>
	</tr>
	
	<tr id="trVerificationImage1" runat="server">
	    <td class="i-col-header" colspan="2">
	        <InstantASP:Label Text="SecurityCode_Title" id="lblCaptchaHeader" Runat="server"/>
	    </td>
	</tr>
	<tr id="trVerificationImage2" runat="server">
	    <td style="width: 30%;" class="i-col-light">
    	
	        <InstantASP:Label Text="SecurityCode_ConfirmCode" id="lblSecurityCode1" CssClass="i-type-bold" Runat="server"/><br />
	        <InstantASP:Label Text="SecurityCode_SecurityCodeDescription" id="lblSecurityCode2" Runat="Server"/>
        	
	    </td>
	    <td class="i-col-light">
    	
            <div style="float: left; margin-right: 8px;">
                <div class="Captcha">
                <InstantASP:Image id="imgCaptchaImage" Runat="Server"/>
                </div>
            </div>
        	<div style="float: left; margin-top: 9px;">
                <InstantASP:TextBox CssClass="i-text-box" Width="150" TabIndex="8" id="txtCaptchaCode"  runat="Server"/> 
        	     	        
                <InstantASP:CalloutValidatorExtender id="txtCaptchaCodeRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
                    <RequiredFieldValidator ControlToValidate="txtCaptchaCode" ErrorMessage="Register_CaptchaCodeRequired"/>
                </InstantASP:CalloutValidatorExtender>
            </div>
            
    	    	
	    </td>
	</tr>	
	<tr>
	    <td style="width: 30%;" class="i-col-light">&nbsp;</td>
	    <td class="i-col-light">
	        <asp:Button ID="butSubmit" runat="Server"
                CausesValidation="True" CssClass="i-button" />
	    </td>
	</tr>
	</InstantASP:Table>	
</InstantASP:PanelBar>

<InstantASP:Spacer Runat="Server"/>

<InstantASP:PanelBar Text="Register_OptionsTitle" TableName="tblRegisterOptions" id="ctlRegisterOptions" runat="Server">
	<InstantASP:Table id="tblRegisterOptions" class="i-table" Runat="Server">
	<tr>
        <td class="i-col-light">
		
			<InstantASP:CheckBox id="ckbRememberMe" Text="LogonControl_RememberMe" runat="server"/><br />
			<InstantASP:CheckBox id="ckbAnonymous" Visible="false" Text="LogonControl_AnonymousLogin" runat="server"/>
					
	    </td>
	</tr>
	</InstantASP:Table>	
</InstantASP:PanelBar>