<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>
	
<InstantASP:Panel ID="pnlNoRecords" runat="Server">
    <InstantASP:Label id="lblNoRecords" Text="ViewArticleComments_NoRecords" CssClass="SmallTxt" Runat="Server"/>
</InstantASP:Panel>

<InstantASP:Repeater id="ctlCommentsRepeater" Runat="Server">
<HeaderTemplate>    
    <div  class="i-row">
        <div class="ikb-comment-header">          
            <div class="i-float-left">
                <h6 class="h6"><InstantASP:Label ID="lblHeader" Text="ViewArticleComments_Header" runat="server" /></h6>
                <InstantASP:HyperLink ID="hypCommentsRss" ClientIDMode="Static" ToolTip="ViewArticle_CommentsRssToolTip" runat="Server">          
                    <span><i class="fa fa-rss"></i></span>
                </InstantASP:HyperLink> 
            </div>
            <div class="i-float-right">
                <ul class="i-tabs-o">        
                    <InstantASP:LinkButton ID="butSortOldest" Text="ViewArticleComments_Oldest" runat="Server" />
                    <InstantASP:LinkButton ID="butSortNewest" Text="ViewArticleComments_Newest" runat="Server" />
                    <InstantASP:LinkButton ID="butSortVotes" Text="ViewArticleComments_Votes" runat="Server" />     
                </ul>  
            </div>
        
        </div>    
    </div>  
</HeaderTemplate>
<ItemTemplate>	
    <InstantASP:Panel ID="pnlComments" CssClass="i-row ikb-article-comment" runat="server">
        <div class="padding">
            <div class="left">                
                <div class="i-photo i-photo-small">
                    <InstantASP:Image id="imgPhoto" BorderWidth="0" Runat="Server" />
                    <InstantASP:HyperLink ID="hypEditPhoto" ToolTip="UserCPEditMemberPhoto_EditPhoto" CssClass="i-tooltip" runat="server">
                        <span><InstantASP:Image id="imgEditPhoto" BorderWidth="0" Runat="Server" /></span>
                    </InstantASP:HyperLink>
                </div>
                <div class="ikb-comment-vote">                                  
                    <InstantASP:LinkButton id="butRateCommentYes" CssClass="i-tooltip" Runat="Server">
                        <span><i class="fa fa-angle-up"></i></span>
                    </InstantASP:LinkButton>               
                    <InstantASP:Label id="lblUpVotes" CssClass="vote-count" runat="Server"/>
                    <InstantASP:LinkButton id="butRateCommentNo"  CssClass="i-tooltip" Runat="Server">
                        <span><i class="fa fa-angle-down"></i></span>
                    </InstantASP:LinkButton>                
                </div>            
            </div>
            <div class="right">        
                <div class="i-row">
                    <div class="i-col-6">                    
                        <InstantASP:Label id="lblName" CssClass="i-type-bold" Runat="Server" /> 
                        <InstantASP:Label id="lblPostedDate" CssClass="i-type-light" Text="ViewArticleComments_PostedDate" Runat="Server" />                                                  
                    </div>
                    <div class="i-col-6">
                        <div class="i-float-right">                   
                            <InstantASP:HyperLink ID="hypEditComment" ToolTip="ViewArticleComments_EditComment" CssClass="i-btn i-btn-default" runat="Server">
                                <span><i class="fa fa-pencil"></i></span>
                            </InstantASP:HyperLink> 
                            <div class="i-user-level">
                                <InstantKBWebControls:UserLevel id="ctlUserLevel" DisplayType="Image" Runat="Server"/>
                            </div>
                        </div> 
                    </div> 
                </div>
                <div class="i-row">
                    <div class="ikb-article i-margin-top">                                                                        
                        <InstantASP:Literal id="lblFullMessage" Runat="Server"/>
                    </div>         
                </div>
                <div class="i-row i-margin-top" id="footer" runat="server">                      
                    <div class="light-text">
                        <InstantASP:Label id="lblWasUseful" Visible="false" Runat="Server" />                            
                        <InstantASP:Label id="lblMarkedAsHelpful1" runat="Server"/>
                        <InstantASP:Label id="lblMarkedAsHelpful2" runat="Server"/>                                                    
                    </div>
                </div>                            
            </div>    
        </div>
    </InstantASP:Panel>   
</ItemTemplate>
<FooterTemplate>  
    <InstantASP:Spacer runat="server" />
</FooterTemplate>
</InstantASP:Repeater>

