<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>

<asp:UpdatePanel ID="ctlUpdatePanel" Runat="Server"/>

<InstantASP:Summary id="ctlSummary" Runat="Server"/>

<InstantASP:Panel CssClass="i-toolbar" ClientIDMode="Static" id="pnlToolBar" runat="server">
     <div class="i-float-left">
        <InstantASP:Panel CssClass="i-float-left default-tools" id="pnlDefaultTools" runat="server">
            <ul class="i-tabs-o">                        
                <li>
                    <InstantASP:ToolTip ID="smFilterToolTip" Position="Bottom" Text="ViewTickets_FiltersToolTip" runat="server">
                        <InstantASP:SimpleMenu ID="smFilter" EnableUpdatePanel="true"  MenuWidth="250px" DivToDisplay="pnlFilters" runat="server">
                            <InstantASP:HyperLink ID="hypFilter" runat="server">
                                <span class="padding"><i class="fa fa-filter i-margin-right"></i> <i class="fa fa-caret-down"></i></span>
                            </InstantASP:HyperLink>
                        </InstantASP:SimpleMenu>
                    </InstantASP:ToolTip> 
                </li> 
                <li>
                    <InstantASP:ToolTip ID="ctlSearchToolTip" Position="Bottom" Text="ViewTickets_SearchToolTip" runat="server">
                        <InstantASP:LinkButton ID="btnSearch" runat="server">
                            <span class="padding"><i class="fa fa-search"></i></span>
                        </InstantASP:LinkButton>
                    </InstantASP:ToolTip>
                </li>
                <li>
                    <InstantASP:SimpleMenu ID="smOptions" EnableUpdatePanel="true" MenuWidth="250px" DivToDisplay="pnlOptions" runat="server">
                        <InstantASP:HyperLink ID="hypOptions" runat="server">
                            <span class="padding"><i class="fa fa-cog i-margin-right"></i> <i class="fa fa-caret-down"></i></span>
                        </InstantASP:HyperLink>
                    </InstantASP:SimpleMenu>
                </li>     
                 <li>      
                    <InstantASP:ToolTip ID="hypGotoTabToolTip" Position="Bottom" Text="ViewArticles_GotoTab" runat="server">
                        <InstantASP:HyperLink ID="hypGotoTab" Text="ViewUserInfo_NewTicket" runat="server">
                            <span class="padding rotate45"><i class="fa fa-level-down fa-rotate-270"></i></span>
                        </InstantASP:HyperLink>     
                    </InstantASP:ToolTip>
                </li>         
            </ul> 
        </InstantASP:Panel> 
        <InstantASP:Panel CssClass="i-float-left edit-tools" id="pnlEditTools" runat="server" style="display: none;">
            <ul class="i-tabs-o">    
                <li>             
                    <InstantASP:ToolTip ID="ctlMarkAsPublicToolTip" Position="Bottom" Text="ViewArticles_PublicToolTip" runat="server">
                        <InstantASP:LinkButton ID="btnMarkAsPublic" CssClass="i-toolbar-success" runat="server">                     
                            <span class="padding"><i class="fa fa-unlock"></i></span>
                        </InstantASP:LinkButton>
                    </InstantASP:ToolTip>       
                </li> 
                <li>
                    <InstantASP:ToolTip ID="ctlMarkAsPrivateToolTip" Position="Bottom" Text="ViewArticles_PrivateToolTip" runat="server">
                        <InstantASP:LinkButton ID="btnMarkAsPrivate" runat="server">                     
                            <span class="padding"><i class="fa fa-lock"></i></span>
                        </InstantASP:LinkButton>
                    </InstantASP:ToolTip>       
                </li> 
                <li>                         
                    <InstantASP:ToolTip ID="ctlDeleteToolTip" Position="Bottom" Text="ViewArticles_DeletedToolTip" runat="server">
                        <InstantASP:LinkButton ID="btnDelete" CssClass="i-toolbar-danger" runat="server">                     
                            <span class="padding"><i class="fa fa-trash"></i></span>
                        </InstantASP:LinkButton>
                    </InstantASP:ToolTip>       
                </li> 
             
            </ul> 
        </InstantASP:Panel> 
    </div> 
    <div class="i-float-right">
        <InstantASP:Panel CssClass="i-float-right filter-tools" ID="pnlFilterTools" runat="server">
            <ul class="i-tabs-o">
                <li>
                    <InstantASP:HyperLink ID="hypNewTicket" Text="ViewUserInfo_NewTicket" CssClass="i-btn i-btn-primary" runat="server">
                        <span><i class="fa fa-plus i-margin-right-small"></i>[0]</span>
                    </InstantASP:HyperLink>
                </li>             
            </ul>
        </InstantASP:Panel>
    </div> 

    <div class="i-menu-arrow" id="pnlFilters_arrow"></div>
    <InstantASP:Panel CssClass="i-menu-box i-pull-left" ClientIDMode="Static" id="pnlFilters" runat="server">   
        <div class="i-menu ">
            <div id="filter_smMenu" class="menu">                              
                <ul>
                    <li>
                        <InstantASP:LinkButton ID="btnFilterAll" Text="ViewArticles_Filter0" runat="server">
                            <span class="padding">[0]</span>
                        </InstantASP:LinkButton>                 
                    </li>         
                    <li>
                        <InstantASP:LinkButton ID="btnFilterPublic" Text="ViewArticles_Filter1" runat="server">
                            <span class="padding">[0]</span>
                        </InstantASP:LinkButton>                 
                    </li>         
                     <li>
                        <InstantASP:LinkButton ID="btnFilterPrivate" Text="ViewArticles_Filter2" runat="server">
                            <span class="padding">[0]</span>
                        </InstantASP:LinkButton>                 
                    </li>      
                    <li>
                        <InstantASP:LinkButton ID="btnFilterDueforReview" Text="ViewArticles_Filter3" runat="server">
                            <span class="padding">[0]</span>
                        </InstantASP:LinkButton>                 
                    </li>   
                     <li>
                        <InstantASP:LinkButton ID="btnFilterExpired" Text="ViewArticles_Filter4" runat="server">
                            <span class="padding">[0]</span>
                        </InstantASP:LinkButton>                 
                    </li>   
                    <li>
                        <InstantASP:LinkButton ID="btnFilterAssigned" Text="ViewArticles_Filter5" runat="server">
                            <span class="padding">[0]</span>
                        </InstantASP:LinkButton>                 
                    </li>   
                    <li>
                        <InstantASP:LinkButton ID="btnFilterHasComments" Text="ViewArticles_Filter6" runat="server">
                            <span class="padding">[0]</span>
                        </InstantASP:LinkButton>                 
                    </li>   
                     <li>
                        <InstantASP:LinkButton ID="btnFilterHasRatings" Text="ViewArticles_Filter7" runat="server">
                            <span class="padding">[0]</span>
                        </InstantASP:LinkButton>                 
                    </li>   
                    <li>
                        <InstantASP:LinkButton ID="btnFilterHasAttachments" Text="ViewArticles_Filter8" runat="server">
                            <span class="padding">[0]</span>
                        </InstantASP:LinkButton>                 
                    </li>   
                </ul>     
            </div>      
        </div>
    </InstantASP:Panel>

    <div class="i-menu-arrow" id="pnlOptions_arrow"></div>
    <InstantASP:Panel CssClass="i-menu-box" ClientIDMode="Static" id="pnlOptions" runat="server">   
        <div class="i-menu ">
            <div id="explore_smMenu" class="menu">                              
                <ul>          
                    <li>
                        <InstantASP:HyperLink ID="hypReport" Text="ViewTickets_ViewReport" runat="server">
                            <div class="padding">[0]</div>
                        </InstantASP:HyperLink>                              
                    </li>
                    <li>
                        <InstantASP:HyperLink ID="hypEditView" Text="ViewTickets_EditView" runat="server">
                            <div class="padding">[0]</div>
                        </InstantASP:HyperLink>             
                    </li>
                </ul>     
            </div>
        </div>
    </InstantASP:Panel>


</InstantASP:Panel> 

<InstantASP:Spacer ID="lblToolBarSpacer" runat="server" />

<InstantKBWebControls:PagingOptions id="ctlHeaderPagingOptions" Orientation="Top" Runat="Server" />

<InstantKB:ViewSearchOptions ID="ctlBasicSearchOptions" ViewType="Basic" runat="server" />
<InstantKB:ViewSearchOptions ID="ctlAdvancedSearchOptions" EnableToggleViewRow="false" ViewType="Advanced" runat="server" />
<InstantASP:Spacer ID="lblSearchOptionsSpacer" runat="Server" />

<InstantASP:Panel ID="pnlDidYouMean" Visible="false" CssClass="i-row" runat="server">
    <div class="i-row ikb-box ikb-box-default">
        <span class="padding">          
            <InstantASP:Label ID="lblDidYouMean" Text="Search_DidYouMean" runat="server" />
            <InstantASP:HyperLink ID="hypDidYouMean" runat="server" />
            <InstantASP:LinkButton ID="btnDidYouMean" runat="server" />
        </span>
    </div>
    <InstantASP:Spacer runat="server" />
</InstantASP:Panel>

<InstantASP:PanelBar id="ctlPanelBar" TableName="pnlScroll"  CssClass="ikb-view-articles-wrapper" Runat="Server"> 
    <div class="i-row" id="pnlScroll" runat="server">

        <InstantASP:DataGrid ID="ctlVisibleDataGrid" AutoGenerateColumns="False" AllowSorting="True"
	    CssClass="i-table ikb-view-articles" ShowHeader="True" AllowPaging="False" NoRecordsTableCellCssClass="i-col-light" 
	    AllowCustomPaging="True" Runat="Server" FooterStyle-CssClass="i-col-light" /> 
	    <InstantASP:DataGrid ID="ctlTemplateDataGrid" AutoGenerateColumns="False" Visible="False" Runat="Server">
        <Columns>
			
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleID"  SortExpression="ArticleID"   
		    ItemStyle-CssClass="i-col-light hide-mobile hide-tablet" HeaderStyle-CssClass="i-col-header hide-mobile hide-tablet"
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-Wrap="False" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate>
                       <InstantASP:Label id="lblArticleID" Runat="Server"/>
   			    </ItemTemplate>
		    </InstantASP:TemplateColumn>
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleIcon" ItemStyle-CssClass="i-col-light hide-mobile hide-tablet" 
		    HeaderStyle-CssClass="i-col-header hide-mobile hide-tablet" ItemStyle-HorizontalAlign="Center" SortExpression="ArticleIcon" ItemStyle-Width="20">
			    <ItemTemplate>                    
                    <div id="pnlIcon" class="ikb-icon" runat="server"></div>
			    </ItemTemplate>	
		    </InstantASP:TemplateColumn>

		    <InstantASP:TemplateColumn HeaderText="Field_ArticleTitle" SortExpression="ArticleTitle" 
		    ItemStyle-CssClass="i-col-light title-cell" HeaderStyle-CssClass="i-col-header">		
			    <ItemTemplate>			
			    <InstantASP:Label id="lblIdentity" Visible="False" Runat="Server"/>
			
			    <div class="i-row" >				
			        <div class="i-float-right">    
                        <InstantASP:Panel id="pnlAccessType" CssClass="i-btn i-btn-default i-tooltip" Runat="Server"> 
                            <span><i class="fa fa-lock"></i></span>                        
                        </InstantASP:Panel> 
                        <InstantASP:Panel ID="pnlRank" CssClass="i-search-rank i-tooltip i-margin-right" runat="server">
                            <InstantASP:Image id="imgRank" Runat="Server" />
                        </InstantASP:Panel>
                        <InstantASP:HyperLink id="hypEdit" CssClass="i-btn i-btn-default i-tooltip" Runat="Server">
                            <span><i class="fa fa-pencil"></i></span>
                        </InstantASP:HyperLink>
                    </div>		
                    <InstantASP:Image id="imgTypeIcon" Visible="false" CssClass="i-align-middle" Runat="Server" />     
                                            
                    <asp:label id="lblNew" CssClass="i-label i-label-primary i-to-upper" runat="server"><span><InstantASP:Literal ID="lblNewText" runat="server" /></span></asp:label>
                    <asp:label id="lblUpdated" CssClass="i-label i-label-default i-to-upper" runat="server"><span><InstantASP:Literal ID="lblUpdatedText" runat="server" /></span></asp:label>
                    
                    <InstantASP:HyperLink id="hypTitle" Runat="Server"/>                 
                    
			    </div>
		        <div id="pnlMeta" Runat="Server">
                    <InstantASP:Label id="lblPostedDate" Text="ViewArticles_PostedDate" Runat="Server" /> 
                    <InstantASP:Label id="lblPostedBy" Text="ViewArticles_PostedBy" Runat="Server" />
		            <InstantASP:HyperLink id="hypPostedBy" Runat="Server" />
                    <InstantASP:Label id="lblSeperator1" Text="Comma" Runat="Server" />
                    <InstantASP:HyperLink id="hypComments" Runat="Server" />
                    
                    
		        </div>	

			    </ItemTemplate>	
		    </InstantASP:TemplateColumn>
												
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleCategory" ItemStyle-Width="200" SortExpression="ArticleCategoryID"
		    ItemStyle-CssClass="i-col-light nowrap hide-mobile" HeaderStyle-CssClass="i-col-header hide-mobile" HeaderStyle-HorizontalAlign="Center" 
		    ItemStyle-HorizontalAlign="Center">
		         <ItemTemplate>		   
			           <InstantASP:HyperLink id="hypCategory" Runat="Server"/>	
			    </ItemTemplate>
		    </InstantASP:TemplateColumn>		
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleSecondaryCategories" ItemStyle-Width="150" SortExpression="ArticleSecondaryCategories"
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header hide-mobile" HeaderStyle-HorizontalAlign="Center" 
		    ItemStyle-HorizontalAlign="Center">
		         <ItemTemplate>		
			           <InstantASP:Panel id="pnlSecondaryCategories" Runat="Server" />		
			    </ItemTemplate>
		    </InstantASP:TemplateColumn>
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleCreatedUserID" ItemStyle-Width="34" SortExpression="ArticleCreatedUserID"
		    ItemStyle-CssClass="i-col-light nowrap hide-mobile" HeaderStyle-CssClass="i-col-header nowrap hide-mobile" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center">
			     <ItemTemplate>				        
                    <InstantASP:ToolTip id="hypCreatedByToolTip" Cssclass="i-photo i-photo-small" runat="server">                    
                        <InstantASP:Image id="imgCreatedByPhoto" runat="server" />                       
                    </InstantASP:ToolTip>
			     </ItemTemplate>	
		    </InstantASP:TemplateColumn>
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleCreatedDate" ItemStyle-Width="60" 
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header nowrap hide-mobile" SortExpression="ArticleCreatedDate"
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-Wrap="False" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Label id="lblCreatedDate" CssClass="i-tooltip" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>
				
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleModifiedUserID" ItemStyle-Width="60" SortExpression="ArticleModifiedUserID"
		    ItemStyle-CssClass="i-col-light nowrap hide-mobile" HeaderStyle-CssClass="i-col-header nowrap hide-mobile" ItemStyle-HorizontalAlign="Center">
			    <ItemTemplate>		
                    <InstantASP:ToolTip id="hypModifiedByToolTip" CssClass="i-photo i-photo-small" runat="server">                   
                        <InstantASP:Image id="imgModifiedByPhoto" runat="server" />                      
                    </InstantASP:ToolTip>
			    </ItemTemplate>
		    </InstantASP:TemplateColumn>
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleModifiedDate" ItemStyle-Width="60"
		    ItemStyle-CssClass="i-col-light nowrap hide-mobile" HeaderStyle-CssClass="i-col-header nowrap hide-mobile" SortExpression="ArticleModifiedDate" 
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-Wrap="False" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Label id="lblLastModifiedDate" CssClass="i-tooltip" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>
						
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleAssignedUserID" ItemStyle-Width="34"
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header nowrap hide-mobile" SortExpression="ArticleAssignedUserID"
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center">
			     <ItemTemplate>		
                     <InstantASP:Label id="lblAssignedTo" TextNonLocalized="-" runat="server" />
                    <InstantASP:ToolTip id="hypAssignedToToolTip" Cssclass="i-photo i-photo-small" runat="server">                    
                            <InstantASP:Image id="imgAssignedToPhoto" runat="server" />                     
                    </InstantASP:ToolTip>
                </ItemTemplate>		
		    </InstantASP:TemplateColumn>
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleAssignedDate" ItemStyle-Width="60"
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header nowrap hide-mobile" SortExpression="ArticleAssignedDate"
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-Wrap="False" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Label id="lblAssignedDate" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>
					
            	
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleSuggestedUserID" ItemStyle-Width="80" SortExpression="ArticleSuggestedUsername"
		    ItemStyle-CssClass="i-col-light hide-mobile"  HeaderStyle-CssClass="i-col-header nowrap hide-mobile" ItemStyle-HorizontalAlign="Center">
			    <ItemTemplate>
                    <InstantASP:Label id="lblSuggestedBy" TextNonLocalized="-" runat="server" />
                    <InstantASP:ToolTip id="hypSuggestedByToolTip" CssClass="i-photo i-photo-small" runat="server">                   
                        <InstantASP:Image id="imgSuggestedByPhoto" runat="server" />                      
                    </InstantASP:ToolTip>

			    </ItemTemplate>	
		    </InstantASP:TemplateColumn>
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleSuggestedDate" ItemStyle-Width="60"
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header hide-mobile" SortExpression="ArticleSuggestedDate"
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-Wrap="False" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Label id="lblSuggestedDate" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>
				
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleReviewDate" ItemStyle-Width="60"
		    ItemStyle-CssClass="i-col-light nowrap hide-mobile" HeaderStyle-CssClass="i-col-header nowrap hide-mobile"  SortExpression="ArticleReviewDate"
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-Wrap="False" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Label id="lblReviewDate" CssClass="i-tooltip" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>
        
            <InstantASP:TemplateColumn HeaderText="Field_ArticleExpiresDate" ItemStyle-Width="60"
		    ItemStyle-CssClass="i-col-light nowrap hide-mobile" HeaderStyle-CssClass="i-col-header nowrap hide-mobile" SortExpression="ArticleExpiresDate"
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-Wrap="False" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Label id="lblExpiryDate" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>
        	
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleDueDate" ItemStyle-Width="60"
		    ItemStyle-CssClass="TableCell_Ligh hide-mobilet" HeaderStyle-CssClass="i-col-header hide-mobile" SortExpression="ArticleDueDate"
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-Wrap="False" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Label id="lblDueDate" Cssclass="i-tooltip" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleViews" ItemStyle-Width="10%" SortExpression="ArticleViews"
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header hide-mobile" 
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Label id="lblViews" CssClass="SmallTxt" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleWorkFlowStepID" ItemStyle-Width="100"
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header hide-mobile" SortExpression="ArticleWorkFlowStepID" 
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Label id="lblWorkFlowStepName" CssClass="SmallTxt" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleRating" ItemStyle-Width="20%"
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header hide-mobile" SortExpression="ArticleRating"   
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-Wrap="False" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Image id="imgRating" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticlePercentComplete" ItemStyle-Width="110" 
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header hide-mobile" SortExpression="ArticlePercentComplete" 
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate>
                    <div class="i-table">
   			            <InstantASP:PercentageBar id="ctlPercentageBar" BarWidth="100" Runat="Server"/>
                    </div>
   			    </ItemTemplate>
		    </InstantASP:TemplateColumn>
			
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleLevel" ItemStyle-Width="20%" 
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header hide-mobile" SortExpression="ArticleLevelID" 
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Label id="lblLevel" CssClass="SmallTxt" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>

		    <InstantASP:TemplateColumn HeaderText="Field_ArticleTypeID" ItemStyle-Width="60" 
		    ItemStyle-CssClass="i-col-light nowrap hide-mobile" HeaderStyle-CssClass="i-col-header nowrap hide-mobile" SortExpression="ArticleTypeID" 
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Label id="lblType" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleAccessType" ItemStyle-Width="10%" 
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header hide-mobile" SortExpression="ArticleAccessType" 
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate><InstantASP:Label id="lblAccessType" CssClass="SmallTxt" Runat="Server"/></ItemTemplate>
		    </InstantASP:TemplateColumn>
		
		    <InstantASP:TemplateColumn HeaderText="Field_ArticleStatusID" ItemStyle-Width="40" 
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header hide-mobile" SortExpression="ArticleStatusID" 
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-Wrap="False" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate>
                       <div id="pnlStatus" runat="server" class="ikb-content-state-pip">
                            <InstantASP:Label id="lblStatus" CssClass="i-tooltip" Runat="Server"/>
                        </div> 

   			    </ItemTemplate>
		    </InstantASP:TemplateColumn>
				
		    <InstantASP:TemplateColumn HeaderText="Field_ArticlePriorityID" ItemStyle-Width="40" 
		    ItemStyle-CssClass="i-col-light hide-mobile" HeaderStyle-CssClass="i-col-header hide-mobile" SortExpression="ArticlePriorityID" 
		    HeaderStyle-HorizontalAlign="Center" ItemStyle-Wrap="False" ItemStyle-HorizontalAlign="Center">
   			    <ItemTemplate>
                       <div id="pnlPriority" runat="server" class="ikb-content-state-pip">
                            <InstantASP:Label id="lblPriority" CssClass="i-tooltip" Runat="Server"/>
                        </div> 
   			    </ItemTemplate>
		    </InstantASP:TemplateColumn>
                
	    </Columns>
	    </InstantASP:DataGrid>
    </div>
</InstantASP:PanelBar>

<InstantKBWebControls:PagingOptions id="ctlFooterPagingOptions" Orientation="Bottom" Runat="Server" />
