<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<asp:UpdateProgress ID="ctlUpdateProgress" Visible="False" runat="Server" />
<asp:UpdatePanel ID="ctlUpdatePanel" Runat="Server"/>

<InstantASP:Summary id="ctlSummary" Runat="Server"/>

<InstantASP:Panel CssClass="i-toolbar" id="pnlToolBar" runat="server">
    <div class="i-float-left">
        <InstantASP:Panel CssClass="i-float-left edit-tools" id="pnlEditTools" runat="server" style="display: none;">
             <ul class="i-tabs-o">     
                 <li>
                    <InstantASP:ToolTip ID="ctlMarkAsSpamToolTip" Position="Bottom" Text="ViewMembers_MarkAsSpamToolTip" runat="server">
                        <InstantASP:LinkButton ID="btnMarkAsSpam" CssClass="i-toolbar-danger" runat="server">                     
                            <span class="padding"><i class="fa fa-exclamation-triangle"></i></span>
                        </InstantASP:LinkButton>
                    </InstantASP:ToolTip> 
                     <InstantASP:LinkButton ID="btnRemoveAsSpam" CssClass="i-tooltip i-toolbar-active" data-position="bottom" data-arrowcss="i-tt-arrow-top"  runat="server">
                        <span class="padding"><i class="fa fa-check"></i></span>
                    </InstantASP:LinkButton>
                </li>   
                <li>
                    <InstantASP:ToolTip ID="ctlDeleteToolTip" Position="Bottom" Text="ViewMembers_DeleteUserToolTip" runat="server">
                        <InstantASP:LinkButton ID="btnDelete" CssClass="i-toolbar-danger" runat="server">                     
                            <span class="padding"><i class="fa fa-trash"></i></span>
                        </InstantASP:LinkButton>
                    </InstantASP:ToolTip> 
                </li>   
            </ul> 
        </InstantASP:Panel> 
    </div>
    <div class="i-float-left  default-tools">
        <ul class="i-tabs-o">       
            <li>
                <InstantASP:ToolTip ID="smFilterToolTip" Position="Bottom" Text="ViewTickets_FiltersToolTip" runat="server">
                    <InstantASP:SimpleMenu ID="smFilter" EnableUpdatePanel="true" MenuWidth="400px" MenuHeight="400px" DivToDisplay="pnlFilters" runat="server">
                        <InstantASP:HyperLink ID="hypFilter" runat="server">
                            <span class="padding"><i class="fa fa-filter i-margin-right"></i> <i class="fa fa-caret-down"></i></span>
                        </InstantASP:HyperLink>
                    </InstantASP:SimpleMenu>
                </InstantASP:ToolTip> 
            </li>
            <li>
                <InstantASP:ToolTip ID="ctlSearchToolTip" Position="Bottom" Text="ViewTickets_SearchToolTip" runat="server">
                    <InstantASP:LinkButton ID="btnSearch" runat="server">
                        <span class="padding"><i class="fa fa-search"></i></span>
                    </InstantASP:LinkButton>
                </InstantASP:ToolTip>
            </li> 
            <li>
                <InstantASP:SimpleMenu ID="smOptions" EnableUpdatePanel="true" MenuWidth="250px" DivToDisplay="pnlOptions" runat="server">
                    <InstantASP:HyperLink ID="hypOptions" runat="server">
                        <span class="padding"><i class="fa fa-cog i-margin-right"></i> <i class="fa fa-caret-down"></i></span>
                    </InstantASP:HyperLink>
                </InstantASP:SimpleMenu>
            </li>      
        </ul> 
    </div>
    <div class="i-float-right">
        <ul class="i-tabs-o">
            <li>
                <InstantASP:HyperLink ID="hypNewMember" Text="ViewMembers_StaffAddUser" CssClass="i-btn i-btn-primary" runat="server">
                    <span class="i-btn-bg"></span>
                    <span><i class="fa fa-plus i-margin-right"></i>[0]</span>
                </InstantASP:HyperLink>
            </li>     
        </ul>
    </div>

    <div class="i-menu-arrow" id="pnlFilters_arrow"></div>
    <InstantASP:Panel CssClass="i-menu-box i-pull-left" ClientIDMode="Static" id="pnlFilters" runat="server">   
        <div class="i-menu">
            <div id="filter_smMenu" class="menu">       
                 <header>
                    <h2>FILTER</h2>
                </header>
                <ul>
                    <li>
                        <InstantASP:LinkButton ID="btnFilterAll" runat="server">
                            <span class="padding">All Contacts</span>
                        </InstantASP:LinkButton> 
                    </li>
                </ul>
                <InstantASP:PlaceHolder ID="pnlOtherFilters" runat="server" />                                     
                <header>
                    <h2>LISTS</h2>
                </header>
                <InstantASP:PlaceHolder ID="pnlUserListFilters" runat="server" />
            </div>      
        </div>
    </InstantASP:Panel>
    
    <div class="i-menu-arrow" id="pnlOptions_arrow"></div>
    <InstantASP:Panel CssClass="i-menu-box" ClientIDMode="Static" id="pnlOptions" runat="server">   
        <div class="i-menu ">
            <div id="explore_smMenu" class="menu">                              
                <ul>   
                    <li>
                        <InstantASP:HyperLink ID="hypNewList" Text="ViewMembers_AddList" runat="server">
                            <div class="padding">[0]</div>
                        </InstantASP:HyperLink>             
                    </li>           
                    <li>
                        <InstantASP:HyperLink ID="hypManageLists" Text="ViewMembers_ManageLists" runat="server">
                            <div class="padding">[0]</div>
                        </InstantASP:HyperLink>             
                    </li>    
                </ul>     
            </div>
        </div>
    </InstantASP:Panel>

</InstantASP:Panel>

<InstantASP:Spacer ID="lblToolBarSpacer" Runat="Server"/>

<InstantASP:PanelBar Text="ViewMembers_SearchMembers" TableName="tblMemberSearchOptions" id="ctlPanelBarSearchOptions" runat="Server">
	<InstantASP:Table id="tblMemberSearchOptions" class="i-table" Runat="Server">
	<tr>
        <td class="i-col-light">
					
            <div class="i-search-input">                                         
                <InstantASP:TextBox id="txtUsername" Runat="Server"/>                
                <asp:LinkButton ID="butSearch" CssClass="i-search-button" runat="server">
                    <span><i class="fa fa-search"></i></span>
                </asp:LinkButton>
            </div>   
            <ajaxToolkit:AutoCompleteExtender ID="txtUsernameAutoCompleteExtender" OnClientItemSelected="OnUserAutoCompleteSelected" OnClientPopulated="Users_AuthCompletePopulated" TargetControlID="txtUsername" ServiceMethod="SelectAutoCompletionList" runat="server" />
						
		</td>      
    </tr>
	<tr id="trDataGridFooter" visible="false" runat="server">
    <td class="i-col-light">

			<table class="i-table">
                <tr>
                    <td class="i-col-light i-centered">
                        <InstantASP:AlphabeticBarControl ID="ctlAlphabeticBarControl" runat="server" />
                    </td>
                </tr>
			    <tr>
                    <td class="i-col-light i-centered">			
                        <InstantASP:SearchKeywordType id="ddlSearchKeywordType" CssClass="i-select" Runat="Server"/>                 
			            <InstantASP:RolesDropDown ID="ddlRoles" CssClass="i-select" Runat="Server"/> 
                        <InstantKBWebControls:ChannelDropDownList ID="ddlChannel" CssClass="i-select" runat="server" />
			            <InstantKBWebControls:MemberListSortBy id="ddlMemberListSortBy" CssClass="i-select" Runat="Server"/> 
			            <InstantASP:SortOrder id="ddlSortOrder" CssClass="i-select" Runat="Server"/> 
			            <InstantASP:RecordsPerPage id="ddlRecordsPerPage" CssClass="i-select" Runat="Server"/> 						
                        <InstantASP:CheckBox ID="ckbHasPassword" Text="ViewMembers_HasPassword" runat="server" />
			        </td>
			    </tr>
              
			</table>
		
	</td></tr>
	</InstantASP:Table>	
</InstantASP:PanelBar>

<InstantASP:Spacer ID="lblSearchSpacer" Runat="Server"/>

<InstantKBWebControls:PagingOptions id="ctlHeaderPagingOptions" Orientation="Top" Runat="Server" />

<InstantASP:PanelBar id="ctlPanelBar" Text="AdminViewFields_PageTitle" CssClass="ikb-view-members-wrapper" TableName="tblFieldTemplates" Runat="Server">
    <InstantASP:Table id="tblFieldTemplates" CellPadding="0" CellSpacing="0" Width="100%" Runat="Server">
    <tr>
        <td>    	
            <InstantASP:DataGrid ID="ctlDataGrid" AllowSorting="True" AutoGenerateColumns="False" Width="100%" 
            CssClass="i-table ikb-view-members" ShowHeader="True" AllowPaging="False" NoRecordsTableCellCssClass="i-col-light" 
            AllowCustomPaging="True" Runat="Server" FooterStyle-CssClass="i-col-dark">
            <Columns>
        		
                <InstantASP:TemplateColumn Visible="False" HeaderText="AdminViewFieldTemplates_ID" 
                HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                ItemStyle-CssClass="i-col-light" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate><InstantASP:Label id="lblIdentity" Runat="Server" /></ItemTemplate>	
                </InstantASP:TemplateColumn>
    		  	
                <InstantASP:TemplateColumn ItemStyle-Width="20" 
                ItemStyle-HorizontalAlign="Center"  HeaderStyle-HorizontalAlign="Center" SortExpression="u.RecognitionPoints"
                ItemStyle-CssClass="i-col-light hide-tablet" HeaderStyle-CssClass="i-col-header hide-tablet">
                    <ItemTemplate> 
                        <span class="i-type-light">
                            <InstantASP:PlaceHolder ID="pnlIcon" runat="server" />
                        </span>
                    </ItemTemplate>
                </InstantASP:TemplateColumn>
                  
		  	    <InstantASP:TemplateColumn HeaderText="ViewMembers_Username"  
                  ItemStyle-CssClass="i-col-light" 
                      HeaderStyle-CssClass="i-col-header" 
                      SortExpression="Username">
                    <ItemTemplate>
                                         
                        <div class="i-float-right i-menu-group">                       
                            <InstantASP:SimpleMenu id="smAdd" LayerCssClass="i-tooltip hide-tablet" MenuWidth="200" EnableUpdatePanel="true" Runat="Server">
                                <InstantASP:HyperLink ID="hypAdd" CssClass="i-btn i-btn-default" runat="server">
                                    <span><i class="fa fa-plus"></i></span>
                                </InstantASP:HyperLink>
                            </InstantASP:SimpleMenu>                                   
                            <InstantASP:SimpleMenu id="smTickets" LayerCssClass="i-tooltip hide-tablet" MenuWidth="200" EnableUpdatePanel="true" Runat="Server">
                                <InstantASP:HyperLink ID="hypTickets" CssClass="i-btn i-btn-default" runat="server">
                                    <span><i class="fa fa-bars"></i></span>
                                </InstantASP:HyperLink>
                            </InstantASP:SimpleMenu>        
                              <InstantASP:HyperLink ID="hypEditProfile" CssClass="i-btn i-btn-primary i-tooltip" ToolTip="Button_EditMember" runat="server">
                                <span><i class="fa fa-pencil"></i></span>
                            </InstantASP:HyperLink>
                        </div>    
                        <InstantASP:Label ID="lblEmail" CssClass="i-float-right i-select-on-focus i-type-light i-margin-right hide-tablet" runat="server" />                     
                        <div class="i-float-left i-margin-left">
                            <div class="i-photo i-photo-small i-align-middle i-margin-right">
                                <InstantASP:Image ID="imgPhoto" runat="server" />
                            </div>
                            <InstantASP:HyperLink id="hypUsername" CssClass="i-type-bold i-tooltip" Runat="Server" />
                        </div>
                   
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>
                
                <InstantASP:TemplateColumn HeaderText="ViewMembers_MemberLevel" ItemStyle-Width="15%" 
                    ItemStyle-Wrap="false" ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center" 
                    SortExpression="u.RecognitionPoints" ItemStyle-CssClass="i-col-light hide-tablet" HeaderStyle-CssClass="i-col-header hide-tablet">
	                <ItemTemplate> 
                     <div class="i-user-level" style="float:none !important; display: inline-block !important;">
	                    <InstantKBWebControls:UserLevel id="ctlUserLevel" DisplayType="Image" Runat="Server"/>      
	                 </div>
	                </ItemTemplate>
                </InstantASP:TemplateColumn>
                  
                <InstantASP:TemplateColumn Visible="false" HeaderText="ViewMembers_MemberGroup" ItemStyle-Width="15%" 
	             HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" ItemStyle-Wrap="false" SortExpression="PrimaryRoleID" 
	             ItemStyle-CssClass="i-col-light hide-tablet" HeaderStyle-CssClass="i-col-header hide-tablet">
	                <ItemTemplate>
	                    <InstantASP:Label id="lblMemberGroup" Runat="Server" />
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>

                <InstantASP:TemplateColumn HeaderText="ViewMembers_LastActive" ItemStyle-Width="15%" 
		  	    ItemStyle-HorizontalAlign="Center"  HeaderStyle-HorizontalAlign="Center" SortExpression="LastLoginDate"
                ItemStyle-CssClass="i-col-light hide-tablet" HeaderStyle-CssClass="i-col-header hide-tablet">
	                <ItemTemplate> 
	                    <InstantASP:Label id="lblLastActive" Runat="Server" />
	                </ItemTemplate>
                </InstantASP:TemplateColumn>
	            
            </Columns>
            </InstantASP:DataGrid>			
        </td>
    </tr>
    </InstantASP:Table>
</InstantASP:PanelBar>

<InstantKBWebControls:PagingOptions id="ctlFooterPagingOptions" Orientation="Bottom" Runat="Server" />
