﻿<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>

<InstantASP:PanelBar id="ctlPanelBar" TableName="ctlTicketRepeater" Runat="Server">
<InstantASP:Repeater id="ctlTicketRepeater" runat="Server">
	<HeaderTemplate>	 	
	 	<table class="i-table ikb-view-ticket">
        <tr id="trDetails1" ClientIDMode="Static" runat="server">
            <td class="i-col-header">      
                <a href="javascript:void(0);" class="i-btn i-btn-default" onclick="toggleTicketDetails(this, '#trDetails2');">
                    <span><InstantASP:Literal ID="lblSubHeader1" Text="ViewTicket_SubHeader1" runat="server" /> <i class="fa fa-caret-down i-margin-left"></i></span>
                </a>
            </td>
        </tr>         
        <tr id="trDetails2" ClientIDMode="Static" runat="server">          
            <td class="i-col-light ikb-view-ticket-details">   
                <InstantKB:ViewArticleDetails 
                    ID="ctlViewArticleDetails"
                    EnableHeader="false"
                    RepeatLayout="Table"
                    RepeatColumns="2" 
                    ItemStyleCssClass="ikb-view-ticket-details-cell" 
                    runat="server" />
            </td>        
        </tr>   
        <tr id="trAttachments1" runat="server">
            <td class="i-col-header"> 
                <InstantASP:Label ID="lblSubHeader2" Text="ViewTicket_Attachments" runat="server" />
            </td>
        </tr>
        <tr id="trAttachments2" runat="server">
            <td  class="i-col-light">                        
                  <InstantKB:ViewAttachments id="ctlViewAttachments" Runat="Server" />
            </td>
        </tr>
        <tr runat="server">
            <td class="i-col-header">
                <InstantASP:Label ID="lblSubHeader3" runat="server" />
            </td>
        </tr>				
	</HeaderTemplate>
	<ItemTemplate>		    		      	
		<tr>	
		    <td class="i-col-light" id="tdHeader" runat="server">			
		        <div class="i-row">            		  
                    <div class="i-float-left">	
                        <div class="ticket-info">
                            <InstantASP:Panel ID="pnlCreated" CssClass="info" runat="server">
                                <div class="padding" style="padding-left: 0 !important;">
                                    <div class="i-float-left i-margin-right">
                                    <span class="i-photo i-photo-small i-margin-top">
		                                <InstantASP:Image id="imgSenderPhoto" Runat="Server" />
                                    </span>	            
                                </div>
                                <div class="i-float-left">                                    
                                    <InstantASP:Label id="lblPostedBy" Text="ViewTicket_Posted" CssClass="i-type-light i-to-upper" runat="Server" /><br />
                                    <InstantASP:Label id="lblUsername" CssClass="i-type-bold i-select-on-focus" runat="Server"/><br />
                                    <InstantASP:Label id="lblEmailAddress" CssClass="i-type-light i-select-on-focus" runat="Server"/>
                                </div>
                                </div> 
                            </InstantASP:Panel>
                            <InstantASP:Panel ID="pnlCreatedDate" data-mobile="false" CssClass="info" runat="server">
                                <div class="padding">
                                    <InstantASP:Label id="lblPostedDate1"  CssClass="i-type-light i-to-upper" runat="Server" /><br />
                                    <InstantASP:Label id="lblPostedDate2" runat="Server" />            
                                </div> 
                            </InstantASP:Panel> 
                            <InstantASP:Panel ID="pnlSentTo" CssClass="info" runat="server">
                                <div class="padding">
                                    <div class="i-float-left i-margin-right">
                                        <span class="i-photo i-photo-small i-margin-top">
                                            <InstantASP:Image id="imgRecipientPhoto" Runat="Server" />                     
                                        </span>                           
                                    </div>      
                                    <div class="i-float-left">
                                        <InstantASP:Label id="lblSentTo" Text="ViewTicket_SentTo" CssClass="i-type-light i-to-upper" runat="Server" /><br />
                                        <InstantASP:Label id="lblSentToUsername" CssClass="i-type-bold i-select-on-focus" runat="Server"/><br />
                                        <InstantASP:Label id="lblSentToEmailAddress" CssClass="i-type-light i-select-on-focus" runat="Server"/>
                                    </div>      
                                </div> 
                            </InstantASP:Panel>
                            <InstantASP:Panel ID="pnlRelatedUser" CssClass="info" runat="server">                                                   
                                <div class="padding">
                                    <div class="i-float-left i-margin-right">
                                        <span class="i-photo i-photo-small i-margin-top">
                                            <InstantASP:Image id="imgRelatedPhoto" Runat="Server" />                     
                                        </span>                 
                                    </div>                           
                                    <div class="i-float-left">
                                        <InstantASP:Label id="lblRelatedUser1" Text="ViewTicket_RelatedTo" CssClass="i-type-light i-to-upper" runat="Server" /><br />
                                        <InstantASP:Label id="lblRelatedUser2" CssClass="i-type-bold" runat="Server"/><br />
                                        <InstantASP:Label id="lblRelatedUserEmailAddress" CssClass="i-type-light i-select-on-focus" runat="Server"/>
                                    </div> 
                                </div> 
                            </InstantASP:Panel>
                            <InstantASP:Panel ID="pnlTimeWorked"  data-tablet="false" CssClass="info" runat="server">
                                <div class="padding">
                                    <InstantASP:Label id="lblTimeWorked1" Text="ViewTicket_TimeWorked" CssClass="i-type-light i-to-upper" runat="Server" /><br />
                                    <InstantASP:Label id="lblTimeWorked2" runat="Server" />
                                </div>
                            </InstantASP:Panel> 
                        </div>
                    </div>
		            <div class="i-float-right">   	
                        <div class="i-float-right">
		                    <InstantASP:HyperLink id="butEdit" ToolTip="Button_Edit" CssClass="i-btn i-btn-default" Runat="Server"> 
                                <div class="i-btn-bg"></div>
                                <span><i class="fa fa-pencil"></i></span>
                            </InstantASP:HyperLink>
                            <InstantASP:LinkButton id="butDelete" ToolTip="Button_Delete" CssClass="i-btn i-btn-default" runat="Server">        				
                                <div class="i-btn-bg"></div>
                                <span><i class="fa fa-times"></i></span>
                            </InstantASP:LinkButton> 
                        </div>
		            </div>
		        </div>
		    </td>
		</tr>  
		<tr>
		    <td class="i-col-light" id="tdBody" runat="server">						                            
                <div class="i-row">
                    <div class="i-float-left enable-ticket-images" style="display: none;">
                        <div id="enableImages" class="i-float-left ikb-box ikb-box-default i-type-bold">
                            <div class="padding">
                                <i class="fa fa-image i-margin-right-small"></i>
                                Images are disabled
                                <a href="javascript:void(0)" onclick="showImages();">Show Images</a>
                            </div>
                        </div>
                        <div id="downloadImages" class="i-float-left ikb-box ikb-box-default i-type-bold" style="display: none;">
                            <div class="padding">
                                <i class="fa fa-download i-margin-right-small"></i>
                                Still don't see images? 
                                <instantasp:LinkButton ID="btnSaveEmbeddedResources" Text="ViewTicket_DownloadImages" runat="server"/>
                            </div>
                        </div>
                        <InstantASP:Spacer runat="server" />
                    </div>
                </div>          
                <div class="i-row ikb-article ikb-ticket">                    
			        <InstantASP:Literal id="lblFullMessage" runat="Server"/>                                  
			  	    <InstantASP:Literal id="lblSignatureSpacer" runat="Server"/>				
				    <InstantASP:Literal id="lblPostSignature" runat="Server"/> 					  
                </div>
		    </td>			
		</tr>
		</ItemTemplate>		 
		<FooterTemplate>			
			</table>							
		</FooterTemplate>	
	</InstantASP:Repeater>
</InstantASP:PanelBar>

<InstantASP:Spacer runat="server" />