﻿<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>

<InstantASP:Panel ID="pnlInsertUpdateTicket" CssClass="i-row i-body i-dialog-content" ClientIDMode="Static" runat="server">    
    <header class="i-dialog-header">
        <div class="margin">
            <h5><InstantASP:Label ID="lblHeader" CssClass="popup-header-text" runat="server" /></h5>
            <a href="javascript:void(0);" class="close" rel="close"><i class="fa fa-times"></i></a>
        </div>
    </header>
    <section class="i-row i-col-light">     
        <InstantASP:Panel CssClass="i-row ikb-dialog-choices" id="pnlChoices" runat="server">                      
            <InstantASP:Panel CssClass="i-col-4" id="pnlChoice1" runat="server">            
                <a href="javascript:void(0);" data-panel="pnlNewTicket">
                    <div class="padding">
                        <div class="icon">
                            <i class="fa fa-plus"></i>
                        </div><br /><br /><br />
                        <h1 class="h1"><InstantASP:Label ID="lblNewTicket" Text="InsertUpdateTicket_NewTicket" runat="server" /></h1><br /><br />                        
                        <div class="text">
                            <InstantASP:Label ID="lblNewTicketDesc" Text="InsertUpdateTicket_NewTicketDesc" runat="server" />
                        </div>
                    </div>
                </a>
            </InstantASP:Panel>            
            <InstantASP:Panel CssClass="i-col-4" id="pnlChoice2" runat="server">            
                <a href="javascript:void(0);" data-panel="pnlNewPrivateTicket">
                    <div class="padding">
                        <div class="icon">
                            <i class="fa fa-user"></i>
                        </div><br /><br /><br />
                        <h1 class="h1"><InstantASP:Label ID="lblNewPrivateTicket" Text="InsertUpdateTicket_NewPrivateTicket" runat="server" /></h1><br /><br />                        
                        <div class="text">
                            <InstantASP:Label ID="lblNewPrivateTicketDesc" Text="InsertUpdateTicket_NewPrivateTicketDesc" runat="server" />
                        </div>
                    </div>
                </a>
            </InstantASP:Panel>            
            <InstantASP:Panel CssClass="i-col-4" id="pnlChoice3" runat="server">            
                <a href="javascript:void(0);" data-panel="pnlNewSharedTicket" class="last">
                    <div class="padding">
                        <div class="icon">
                            <i class="fa fa-envelope"></i>
                        </div><br /><br /><br />
                        <h1 class="h1"><InstantASP:Label ID="lblNewSharedTicket" Text="InsertUpdateTicket_NewSharedTicket" runat="server" /></h1><br /><br />                        
                        <div class="text">
                            <InstantASP:Label ID="lblNewSharedTicketDesc" Text="InsertUpdateTicket_NewSharedTicketDesc" runat="server" />
                        </div>
                    </div>
                </a>
            </InstantASP:Panel>   
        </InstantASP:Panel>
        <InstantASP:Panel ID="pnlNewTicket" Cssclass="i-row" ClientIDMode="Static" runat="server">
            <InstantKB:StaffInsertUpdateTicketReply ID="ctlNewTicket" runat="server" />
        </InstantASP:Panel>
        <InstantASP:Panel ID="pnlNewPrivateTicket" Cssclass="i-row" ClientIDMode="Static" runat="server">
               <InstantKB:StaffInsertUpdateTicketReply ID="ctlNewPrivateTicket" runat="server" />         
        </InstantASP:Panel> 
        <InstantASP:Panel ID="pnlNewSharedTicket" Cssclass="i-row" ClientIDMode="Static" runat="server">
               <InstantKB:StaffInsertUpdateTicketReply ID="ctlNewSharedTicket" runat="server" />         
        </InstantASP:Panel>         
        <InstantASP:Panel ID="pnlEditTicket" Cssclass="i-row" runat="server">
            <ul id="tabs" class="i-tabs-o"> 
                <li>
                    <InstantASP:HyperLink ID="hypTab1"  Text="InsertUpdateTicket_EditTicket" CssClass="selected" runat="server"><span class="padding">[0]</span></InstantASP:HyperLink>
                </li> 
                <li>
                    <InstantASP:HyperLink ID="hypTab2" Text="InsertUpdateTicket_EditContact"  runat="server"><span class="padding">[0]</span></InstantASP:HyperLink>             
                </li>             
            </ul> 
            <InstantASP:PlaceHolder ID="phControl" runat="server" />     
        </InstantASP:Panel>            
    </section>    
</InstantASP:Panel>

<script type="text/javascript">

    $(document).ready(function () {
        
        $(".ikb-dialog-choices").find("a").click(function (e) {
      
            var $pnl = $('#' + $(this).data('panel'));

            // disable auto-fill in chrome
            if ($instantasp.isChrome) {
                $pnl.find('input[autocomplete="off"]').each(function () {
                    var input = $(this);
                    setTimeout(function () {
                        input.attr('autocomplete', 'false');
                    }, 1);
                });
            }
            
            setTimeout(function () {
                disableFormAutoComplete();
            }, 1);

            function disableFormAutoComplete() {
                var frm = document.getElementsByTagName('form')[0];
                if (frm) {
                    frm.setAttribute('autocomplete', 'off');                
                }
            }

            // attach unload event based on choice
            var p = window.parent.instantasp_popup['iPopUp'];
            if (p) {             
                p.onBeforeUnload = function () {             
                    var editor = $pnl.find(".RadEditor");
                    var id = editor.attr('id');
                    var telerikEditor = $telerik.findEditor(id);
                    if (telerikEditor) {
                        var html = telerikEditor.get_html(true);
                        if (html != '' &&
                            html != '<p></p>' &&
                            html != '<p>&nbsp;</p>') {
                            var output = confirm(ibk_CloseTicketPopUp)
                            if (output)
                            {
                                // disable global onbeforeunload 
                                // check within StaffInsertTicketReply
                                doBeforeUnloadCheck = false;
                            }
                            return output;
                        }
                        return true;
                    }
                    return true;
                }
            }                     
            if (!$pnl.is(":visible")) {
                iasp_scrollToDiv('pnlInsertUpdateTicket');
                $(".ikb-dialog-choices").hide();
                $pnl.show();
                var $input = $($pnl.find("input")[0])
                $input.focus();                
            }        
            
            e.stopPropagation();
            return false;

        });

    })
    
</script>


