﻿<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register Assembly="CS.Web.UI.CropImage" Namespace="CS.Web.UI" TagPrefix="cs" %>

<div id="pageLoader" class="i-loader-jumbo">
    <div class="i-loader i-loader-2x"></div>
</div>

<div class="i-row i-body i-dialog-content" id="editPhoto" style="display: none;">
    <div class="i-loader-overlay" style="display: none;">
        <div class="i-loader-overlay-bg"></div>
        <div class="i-loader i-loader-2x"></div>
    </div>
    <header class="i-dialog-header">
        <div class="margin">
            <h5><InstantASP:Label ID="lblHeader" runat="server" /></h5>
            <a href="javascript:void(0)" class="close" rel="close"><i class="fa fa-times"></i></a>
        </div>
    </header>
    <ul id="uploadBannerPhotoTabs" class="i-tabs-o"> 
        <li class="i-tabs-o-menu">
            <a href="javascript:void(0);" onclick="togglePopUpTabStrip(this, event);"><span class="padding"><i class="fa fa-bars"></i></span></a>
        </li> 
        <li runat="server" id="liTab1">
            <InstantASP:HyperLink ID="hypTab1"  NavigateUrl="#pnlGallery" Text="EditPhoto_Gallery" runat="server"><span class="padding">[0]</span></InstantASP:HyperLink>
        </li> 
        <li runat="server" id="liTab2">
            <InstantASP:HyperLink ID="hypTab2"  NavigateUrl="#pnlUploadAndCrop" Text="EditPhoto_Upload" runat="server"><span class="padding">[0]</span></InstantASP:HyperLink>             
        </li>
         <li runat="server" id="liTab3">
            <InstantASP:HyperLink ID="hypTab3"  NavigateUrl="#pnlSocial" Text="EditPhoto_Social" runat="server"><span class="padding">[0]</span></InstantASP:HyperLink>             
        </li>
    </ul>          
    <section class="i-col-light">                   

        <InstantASP:Summary id="ctlSummary" ClientIDMode="Static" Runat="Server"/> 
    
        <InstantASP:Panel id="pnlSuccess"  ClientIDMode="Static" CssClass="i-row" runat="server">            
            <div class="i-row">                  
                <div style="width: 80%; text-align: center; margin: 170px auto;">
                    <div class="i-pip i-pip-3x i-pip-success">
                        <span><i class="fa fa-check"></i></span>
                    </div>
                    <br /><br />
                    <h2 class="h2"><InstantASP:Literal id="lblSuccess" runat="server" /></h2>
                </div>
            </div>  
        </InstantASP:Panel>
        
        <InstantASP:Panel id="pnlError"  ClientIDMode="Static" CssClass="i-row" runat="server">          
            <div class="i-row">                  
                <div style="width: 80%; text-align: center; margin: 170px auto;">
                    <div class="i-pip i-pip-3x i-pip-danger">
                        <span><i class="fa fa-times"></i></span>
                    </div>
                    <br /><br />
                    <h2 class="h2"><InstantASP:Literal id="lblError" runat="server" /></h2>
                </div>
            </div>       
        </InstantASP:Panel> 
                             
        <InstantASP:Panel CssClass="i-row" id="pnlGallery" ClientIDMode="Static" runat="server">
            <div class="i-row" style="margin-bottom: 80px;">                                       
                <div class="margin">
                    <InstantASP:ImageRadioButtonList 
                        id="rblImages"                                                 
                        OnClientChange="updateListSelection"
                        RepeatDirection="Horizontal" 
                        RepeatLayout="Flow"                                
                        Runat="Server" />  
                </div>         
            </div>
            <div class="footer-pull-bottom">
                <footer class="i-col-dark">   
                    <div class="margin">                                      
                        <InstantASP:Button ID="btnGallerySelect" CssClass="i-button" CausesValidation="false" runat="server" />                     
                    </div>      
                </footer>
            </div>
        </InstantASP:Panel>        
        <InstantASP:Panel class="i-row" id="pnlUploadAndCrop" ClientIDMode="Static" runat="server">
            <InstantASP:Panel id="pnlCrop"  ClientIDMode="Static" CssClass="i-row" runat="server">            
                <div class="i-row" style="overflow-x: auto; margin-bottom:84px; ">
                      <div class="margin">   
                        <asp:Image ID="imgCrop" runat="server" />          
                        <cs:CropImage ID="ctlCrop" runat="server" W="150" H="150" />    
                    </div>             
                </div>  
                <div class="footer-pull-bottom">
                    <footer class="i-col-dark">   
                        <div class="margin">                                                     
                            <div id="pnlCropButton" runat="server">
                                <InstantASP:Button ID="btnCrop"  CssClass="i-button" CausesValidation="false" runat="server" Text="Save Image"  />
                            </div> 
                            <div id="pnlCropLoader" runat="server" style="display: none;">
                                <InstantASP:Image ID="imgCropLoading" runat="server" />
                            </div>                      
                        </div>      
                    </footer>
                </div> 
            </InstantASP:Panel>
            <InstantASP:Panel CssClass="i-row i-col-light" ClientIDMode="Static"  id="pnlUpload" runat="server">
                <div class="i-row" style="overflow: hidden !important">                                                            
                    <div style="width: 60%; text-align: center; margin: 135px auto 1000px auto;">
                        <div id="fileUpload" class="if-photo-upload">
                            <InstantASP:Image ID="imgDropImage" runat="server" />                                        
                            <br /><br />      
                            <div class="i-fake-file">
                                <InstantASP:File id="txtFile" runat="Server"/>
                                <div class="i-fake-file-visible">         
                                    <a href="javascript:void(0);" class="i-btn i-btn-2x i-btn-primary">                           
                                        <span class="i-btn-bg"></span>
                                        <span>                                                 
                                            <InstantASP:Literal id="lblButtonText" runat="server" />                  
                                        </span>
                                    </a>    
                                </div>   
                            </div>  
                            <InstantASP:Label id="lblUploadRequirements" runat="server" />                            
                        </div>                         
                        <InstantASP:Button runat="server" ID="btnUpload" style="display: none;" CssClass="submit-upload" Text="submit"/>
                    </div>                                
                </div>                                     
            </InstantASP:Panel>   
        </InstantASP:Panel> 

        <InstantASP:Panel CssClass="i-row" ID="pnlSocial" ClientIDMode="Static" runat="server">            
            <div class="i-row">                  
                <div style="width: 80%; text-align: center; margin: 170px auto;">
                  
                    <div style="display: none;">
                        <InstantASP:TextBox ID="txtSocial" CssClass="ikb-social-photo-input" runat="server"/>
                    </div>

                    <div class="i-row" id="useSocialPhoto" style="display: none;">
                        <h3 class="h3 i-type-sego">Use this photo?</h3><br />
                        <div class="i-photo i-photo-large">
                            <InstantASP:Image ID="imgSocial" BorderWidth="0" CssClass="ikb-social-photo-img" runat="server" />
                        </div>
                        <br /><br />
                        <InstantASP:LinkButton ID="btnUseSocialPhoto" Text="Button_OK" CssClass="i-btn i-btn-2x i-btn-primary" runat="server">
                            <span class="i-btn-bg"></span>
                            <span>[0]</span>
                        </InstantASP:LinkButton>
                        <InstantASP:HyperLink ID="btnCancelSocialPhoto" Text="Button_Cancel" CssClass="i-btn i-btn-2x i-btn-default" runat="server">
                            <span class="i-btn-bg"></span>
                            <span>[0]</span>
                        </InstantASP:HyperLink>
                    </div>
                    <div class="i-row" id="selectSocialPhoto">
                        <h3 class="h3 i-type-sego">Check social services for a profile photo...</h3><br />
                        <InstantASP:HyperLink ID="hypSocialProfileGoogle" CssClass="i-tooltip" data-position="bottom" runat="server">
                            <span>
                                <InstantASP:Image ID="imgGoogle" runat="server" />
                            </span>
                        </InstantASP:HyperLink>
                        <InstantASP:HyperLink ID="hypSocialProfileGravatar" CssClass="i-tooltip" data-position="bottom" runat="server">
                            <span>
                                <InstantASP:Image ID="imgGravatar" runat="server" />                       
                            </span>
                        </InstantASP:HyperLink>
                    </div> 

                </div> 
            </div>   
        </InstantASP:Panel>

    </section>  
</div>

<script type="text/javascript">

    var _URL = window.URL || window.webkitURL;

    $(document).ready(function () {
        $("#pageLoader").hide();
        $("#editPhoto").show();
        $("#uploadBannerPhotoTabs").idTabs();
    });

    // gallery selection
    function updateListSelection(sender) {
        // workaround for :checked pseudo selector not working in IE7/8        
        $(".i-image-radio-buttons").find("label").removeClass("selected");
        $(sender).closest("label").addClass("selected");
        // workaround for IE9+
        var ckbid = $(sender).closest("label").attr("for");
        $('#' + ckbid).prop("checked", true)
    }

    // check size of uploaded images
    function imageMeetsDimensions(file, complete) {     
        if (!file) { return; }
        if (!_URL) { complete(true);; }
        var img = new Image();
        img.src = _URL.createObjectURL(file);
        img.onload = function () {
            var width = img.naturalWidth,
                height = img.naturalHeight;
            _URL.revokeObjectURL(img.src);
            if (width < iasp_ImageWidth || height < iasp_ImageHeight) {
                complete(false);
            } else {
                complete(true);
            }
        };
        img.onerror = function () {
            iasp_showAlert(null, iasp_InvalidImagge);
            $('.i-loader-overlay').hide();
        }

    }

</script>

