﻿<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>

<InstantASP:Summary ID="ctlSummary" runat="server" />

<div class="i-row ikb-diff">     
    <div class="i-row ikb-diff-box">
        <div class="margin">
        <div class="ikb-diff-pane-container">
            <div class="i-row">
             
                <div class="i-float-left">
                    <div class="i-float-left i-margin-right">
                        Version:  <InstantKBWebControls:ArticleVersionsDropDownList id="ddlOldVersions" CssClass="i-select" runat="server" />
                    </div>
                    <div class="i-float-left">
                        <div class="i-photo i-photo-small i-align-middle">
                            <InstantKBWebControls:UserPhoto ID="ctlPhotoOld" runat="server" />
                        </div>
                        <InstantASP:Label ID="lblUsernameOld" CssClass="i-type-bold" runat="server" /> - 
                        <InstantASP:Label ID="lblDateOld" runat="server" />
                    </div> 
                </div>
                <div class="i-float-right i-margin-right">                
                    <InstantASP:ToolTip ID="hypPreviewOldVersionToolTip" Position="Bottom" Text="StaffEditArticleHistory_PreviewVersionToolTip" runat="server">
                        <InstantASP:HyperLink ID="hypPreviewOldVersion" CssClass="i-btn i-btn-default" runat="server">
                            <span class="i-btn-bg"></span>
                            <span><i class="fa fa-external-link"></i></span>
                        </InstantASP:HyperLink>
                    </InstantASP:ToolTip>
                    <InstantASP:ToolTip ID="hypRollBackOldToolTip" Position="Bottom" Text="StaffEditArticleHistory_RollBackToolTip" runat="server">
                       <InstantASP:LinkButton ID="hypRollBackOld" Text="StaffEditArticleHistory_RollBack" CssClass="i-btn i-btn-default" runat="server">
                           <span class="i-btn-bg"></span>
                           <span>[0]</span>
                       </InstantASP:LinkButton>
                   </InstantASP:ToolTip>
                </div>    

          
            </div>
            <InstantASP:Spacer runat="server" />
            <div class="i-row ikb-diff-pane">
                <InstantASP:Table id="tblOld" class="ikb-diff-table" runat="server" />
            </div> 
        </div>
        <div class="ikb-diff-pane-container">
            <div class="i-row">
                <div class="i-float-left">                
                    <div class="i-float-left i-margin-right">
                        Version: <InstantKBWebControls:ArticleVersionsDropDownList id="ddlNewVersions" CssClass="i-select" runat="server" />
                    </div>
                    <div class="i-float-left">

                        <div class="i-photo i-photo-small i-align-middle">
                            <InstantKBWebControls:UserPhoto ID="ctlPhotoNew" runat="server" />
                        </div>
                        <InstantASP:Label ID="lblUsernameNew" CssClass="i-type-bold" runat="server" /> - 
                        <InstantASP:Label ID="lblDateNew" runat="server" />
                    </div> 
                    
                </div>
                <div class="i-float-right i-margin-right">      

                     <InstantASP:ToolTip ID="hypPreviewNewVersionToolTip" Position="Bottom" Text="StaffEditArticleHistory_PreviewVersionToolTip" runat="server">
                        <InstantASP:HyperLink ID="hypPreviewNewVersion" CssClass="i-btn i-btn-default" runat="server">
                            <span class="i-btn-bg"></span>
                            <span><i class="fa fa-external-link"></i></span>
                        </InstantASP:HyperLink>
                    </InstantASP:ToolTip>

                    <InstantASP:ToolTip ID="hypRollBackNewToolTip" Position="Bottom" Text="StaffEditArticleHistory_RollBackToolTip" runat="server">
                        <InstantASP:LinkButton ID="hypRollBackNew" Text="StaffEditArticleHistory_RollBack" CssClass="i-btn i-btn-default" runat="server">
                            <span class="i-btn-bg"></span>
                            <span>[0]</span>
                        </InstantASP:LinkButton>
                    </InstantASP:ToolTip>
                </div> 
                   

                <br /><br />
            </div>     
            <div class="i-row ikb-diff-pane">
                <InstantASP:Table id="tblNew" class="ikb-diff-table" runat="server" />
            </div>
        </div>
        </div>
    </div> 
</div>

<div class="footer-pull-bottom">
    <footer class="i-col-dark">   
               
        <div class="i-row">
            <div class="i-float-left">
                <div class="margin"> 
                    
                    <InstantASP:HyperLink ID="hypVersionHistory" CssClass="i-btn i-btn-2x i-btn-primary" Text="StaffEditArticleHistory_BackToVersionHistory" runat="server">
                        <span class="i-btn-bg"></span>
                        <span>[0]</span>
                    </InstantASP:HyperLink>

                    <InstantASP:HyperLink ID="hypNewWindow" CssClass="i-btn i-btn-2x i-btn-primary-o" Text="StaffEditArticleHistory_OpenDiffNewWindow" runat="server">
                        <span class="i-btn-bg"></span>
                        <span><i class="fa fa-external-link i-margin-right-small"></i>[0]</span>
                    </InstantASP:HyperLink>
                    
                </div> 
            </div>
            <div class="i-float-right ikb-diff">
                <div class="margin">
                
                    <span class="i-label InsertedLine">
                        Inserted Line
                    </span>
                    <span class="i-label ModifiedLine">
                        Modified Line
                    </span>
                    <span class="i-label DeletedLine">
                        Deleted Line
                    </span>
                    <span class="i-label UnchangedLine">
                        Unchanged Line
                    </span>
                    <span class="i-label ImaginaryLine">
                        Imaginary Line
                    </span>
                    <span class="i-label InsertedCharacter">
                        Inserted Character
                    </span>
                    <span class="i-label DeletedCharacter">
                        Deleted Character
                    </span>

                </div> 
            </div>
        </div>
    
    </footer>                        
</div>

<script type="text/javascript">
    
    function InitializeDiffPanes() {

        var diffBox = $(".ikb-diff-box");
        var parent = diffBox.parent();
        var diffPane = $(".ikb-diff-pane", diffBox);
        var leftTable = $(".ikb-diff-table", diffPane[0]);
        var rightTable = $(".ikb-diff-table", diffPane[1]);
        var diffPaneLinesLeft = $("td.line", leftTable);
        var diffPaneLineHeight = diffPaneLinesLeft.outerHeight() + 2;
        var scrollBarsActive = false;
        
        SizeDiffTablesEqually();
        SizeDiffPanesToWindow();
        
        // synchronize the scroll bars
        $(diffPane[0]).scroll(OnLeftDiffPaneScroll);
        $(diffPane[1]).scroll(OnRightDiffPaneScroll);
        
        $(window).resize(function () {
            SizeDiffTablesEqually();
            SizeDiffPanesToWindow();
        });
        
        function SizeDiffPanesToWindow() {
            var lineCount = diffPaneLinesLeft.length;
            var contentHeight = lineCount * diffPaneLineHeight;

            diffPane.hide();
            var parentHeight = parent.outerHeight(true);            
            var parentTop = parent.offset().top;
            var windowHeight = $(window).height() - diffBox.height();
            var newHeight = windowHeight - (parentHeight + parentTop);
            diffPane.show();

            if (contentHeight < newHeight) {
                newHeight = contentHeight;
                if (scrollBarsActive)
                    newHeight += diffPaneLineHeight + 3;
            }
            if (newHeight > 0)
                diffPane.height(newHeight);

        }

        function SizeDiffTablesEqually() {
            
            var maxWidth = Math.max(leftTable.width(), rightTable.width());
            var maxHeight = Math.max(leftTable.height(), rightTable.height());
            
            leftTable.height(maxHeight);
            rightTable.height(maxHeight);

            if (diffPane.width() < maxWidth) {
                leftTable.width(maxWidth);
                rightTable.width(maxWidth);
                scrollBarsActive = true;
            }
        }

        function OnLeftDiffPaneScroll(e) {
            var left = this.scrollLeft;
            var top = this.scrollTop;
            if (top != diffPane[1].scrollTop) diffPane[1].scrollTop = top;
            if (left != diffPane[1].scrollLeft) diffPane[1].scrollLeft = left;
        }

        function OnRightDiffPaneScroll(e) {
            var left = this.scrollLeft;
            var top = this.scrollTop;
            if (top != diffPane[0].scrollTop) diffPane[0].scrollTop = top;
            if (left != diffPane[0].scrollLeft) diffPane[0].scrollLeft = left;
        }
    }
    
    $(document).ready(function () {
        InitializeDiffPanes();
    });

 
</script>
