<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>

<InstantASP:Summary ID="ctlSummary" runat="server" />

<InstantASP:Panel ID="pnlTags" Cssclass="i-row margin" ClientIDMode="Static" runat="server">
    
    <div class="i-col-9">
     
        <asp:UpdateProgress ID="ctlUpdateProgress" Visible="False" runat="Server" />
        <asp:UpdatePanel ID="ctlUpdatePanel" Runat="Server"/>
        <InstantASP:PanelBar id="ctlPanelBar" EnablePanelBar="false" Collapseable="false" Text="StaffInsertUpdateArticleTags_SubHeader" Runat="Server">
        <InstantASP:Panel Cssclass="i-row" style="width: 80%;" Runat="Server"> 
            <div class="i-row">                     
                Tags help you organize and improve the discoverability of your content. You can use tags to ensure content is ranked highly within search results if users search for a term you've used as a tag.
                Enter a single tag into each text box. Suggestions will be provided for tags as you start typing based on your excising tags.<br /><br />
                            
            <InstantASP:DataGrid ID="ctlTagsDataGrid" AutoGenerateColumns="False" Width="100%" 
            CssClass="i-tableClear" ShowHeader="False" AllowPaging="False"
            AllowCustomPaging="True" Runat="Server" FooterStyle-CssClass="TableCell_Dark">
            <Columns>                        
                <InstantASP:TemplateColumn HeaderText="StaffInsertUpdateArticleTags_TagHeader" ItemStyle-Width="100%">
                    <ItemTemplate>                
                        <InstantASP:Label id="lblTagID" Visible="False" Runat="Server" /> 
                        <InstantASP:Label id="lblTagName" Visible="False" Runat="Server" />                        
                        <div class="i-row" style="margin-bottom: 6px;">
                            <InstantASP:TextBox id="txtTagKeyword" CssClass="i-text-box" runat="Server"/>
                            <ajaxToolkit:AutoCompleteExtender ID="txtTagKeywordAutoCompleteExtender" TargetControlID="txtTagKeyword" ServiceMethod="SelectAutoCompletionList" runat="server" />
                            <InstantASP:ToolTip id="ctlToolTip1" Text="StaffInsertUpdateArticleTags_ToolTip" TipWidth="300" Position="Bottom" Runat="Server" />
                            <InstantASP:Button ID="hypSuggest"  CssClass="i-button" runat="server"/>
                            <InstantASP:Button ID="hypDelete"  CssClass="i-button" runat="server"/>
                        </div>     
                        <div id="pnlSimilarTags" class="i-row" style="display: none; margin-bottom: 12px;" runat="server" />
                    </ItemTemplate>	
                </InstantASP:TemplateColumn>                            
            </Columns>
            </InstantASP:DataGrid>
            </div>           
            <div class="i-row" style="margin: 12px 0 24px 0;">
                <asp:Button id="butSubmit" CausesValidation="false" 
                CssClass="i-button" runat="server"/>
            </div>        
        
                        
        </InstantASP:Panel>
        </InstantASP:PanelBar>
                    
    </div>
    <div class="i-col-3">

        <div class="i-row">       
            <h6 class="h6">Google Suggest</h6><br />               
        </div>   
        <div class="i-row">  
            <div class="i-search-input ikb-google-suggest" style="margin: 12px 0; width: 80%">
                <input type="text" />
                <a href="#" class="i-search-button">
                    <span><i class="fa fa-search"></i></span>
                </a>
            </div>        
        </div>    
        <div id="googleSuggestResults" class="i-row" style="display: none;"></div>           
        <div class="i-row i-margin-top">      
            <h6 class="h6">Our Suggestions</h6><br />
        </div>        
        <div id="pnlTagSuggestions" class="i-row" runat="server" />    
 
    </div>
</InstantASP:Panel>
        
<script type="text/javascript">

    var wrapper = $(".ikb-google-suggest");
    wrapper.find("input").bind("keydown", function () {
        $("#googleSuggestResults").googleSuggest({ term: $(this).val() });
    });

    wrapper.find(".i-search-button").bind("click", function (e) {
        e.preventDefault();
        var txt = wrapper.find("input");
        if (txt.val() != "") {
            $("#googleSuggestResults").googleSuggest({ term: txt });
        } else {
            txt.focus();
        }

    });
    
</script>