﻿<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<InstantASP:Panel ID="pnlIncomingCall" CssClass="i-row ikb-incoming-call" style="display: none;" runat="server">
    <div class="i-menu i-centered">  
        <div class="i-row">
            <div class="i-col-6">     
                <InstantASP:HyperLink ID="hypAcceptCall" ClientIDMode="Static" CssClass="i-btn i-btn-2x i-btn-primary" style="width: 100%; border: 0 !important; border-radius: 0 !important;" runat="server">
                    <span>
                        <i class="fa fa-microphone"></i><br />
                        Accept
                    </span>
                </InstantASP:HyperLink>
            </div>
            <div class="i-col-6">
               <InstantASP:HyperLink ID="hypRejectCall" ClientIDMode="Static" CssClass="btn-big btn-caution" style="width: 100%; border: 0 !important; border-radius: 0 !important;" runat="server">
                   <span>
                        <i class="fa fa-microphone-slash fa-2x"></i><br />
                        Decline
                    </span>
                </InstantASP:HyperLink> 
            </div>
        </div> 
        <div class="i-row ikb-call-log">
            <div class="log">Incoming Call</div>
        </div>        
    </div>
</InstantASP:Panel>
   
<div class="i-asides ikb-asides-make-call" id="callAsides">    
    <header class="i-asides-header">
        <h2 class="title">Call</h2>              
        <a class="close" href="javascript:void(0);"><span><i class="fa fa-times"></i></span></a>            
    </header>    
    <section class="i-row">
        <InstantASP:Panel ID="pnlNotEnabled" Cssclass="i-row" runat="server">
            <div class="i-spacing">
                <div class="i-center">
                    <div class="i-no-results" style="line-height: 22px;">                         
                        <h3 class="h3 i-type-sego inline">Phone Support Is Not Enabled</h3><br />
                        Make and receive calls right from your browser. Enable twillo integration from the Channels / Phone page within the Admin CP. Ensure you provide your twilio Verified Caller ID, AccountSID, AuthToken &amp; ApplicationSID to enable phone support.
                    </div>
                </div>
            </div>
        </InstantASP:Panel>
        <InstantASP:Panel ID="pnlEnabled" Cssclass="i-row" runat="server">

            <div style="display: none;">
                <InstantASP:TextBox ID="txtTicketID" runat="server" />
                <InstantASP:TextBox ID="txtTimeWorked" runat="server" />
                <InstantASP:TextBox ID="txtUserID" runat="server" />
            </div>         
            <InstantASP:Panel ID="pnlNumberWrapper" Cssclass="i-row ikb-phone-dial-textbox" runat="server">
                <InstantASP:Panel id="pnlRecipeient" CssClass="i-label i-label-default ikb-recipient-box" runat="server">              
                    <span class="uid" style="display:none;"></span> 
                    <span class="phonenumber" style="display:none;"></span> 
                    <span class="channel" style="display:none;"><InstantASP:Literal ID="lblRecipientChannel" runat="server" /></span> 
                    <div class="i-photo i-photo-small i-align-middle i-float-left i-margin-right">
                        <InstantASP:Image ID="imgRecipient" runat="server" />
                    </div> 
                    <div class="i-float-left">                           
                        <span class="text">
                            <span class="username"><InstantASP:Literal ID="lblRecipientUsername" runat="server"/></span>
                            &lt;<span class="email"><InstantASP:Literal ID="lblRecipientEmail" runat="server"/></span>&gt;
                        </span>   
                    </div>      
                    <div class="i-float-right i-margin-left">
                        <InstantASP:HyperLink ID="hypClearRecipient" CssClass="i-btn i-btn-primary" runat="server">
                            <span class="i-btn-bg"></span>
                            <span><i class="fa fa-times"></i></span>
                        </InstantASP:HyperLink>                            
                    </div> 
                   
                </InstantASP:Panel>                                   
                <InstantASP:TextBox CssClass="phone-number" ID="txtPhoneNumber" TabIndex="1" runat="server"/>                    
                <ajaxToolkit:AutoCompleteExtender ID="txtPhoneNumberAutoCompleteExtender" TargetControlID="txtPhoneNumber" OnClientItemSelected="OnNewTicketUserAutoCompleteSelected" OnClientPopulated="Users_AuthCompletePopulated" ServiceMethod="SelectAutoCompletionList" runat="server" />      
            </InstantASP:Panel> 
            <InstantASP:Panel ID="pnlSpeakingWith" CssClass="i-row ikb-speaking-with" style="display: none" runat="server">                                         
                <div class="i-row">
                    <div class="i-float-left">                                        
                        <div class="padding">    
                            <div class="i-float-left">
                                <div class="i-photo i-photo-medium i-float-left i-margin-right"></div> 
                            </div>
                            <div class="i-float-left">
                            <h2 class="i-type-sego i-inline"></h2><br />
                                <span class="user-info"></span>
                            </div> 
                        </div>                                         
                    </div>
                    <div class="i-float-right">
                        <div class="padding">
                            <InstantASP:ToolTip ID="ctlEditProfiletooltip" Position="Bottom" Text="Button_EditMember" runat="server">
                                <InstantASP:HyperLink ID="hypEditProfile" CssClass="edit-profile" Target="_blank" runat="server">
                                        <span>
                                    <i class="fa fa-pencil"></i>
                                </span>
                                </InstantASP:HyperLink>
                            </InstantASP:ToolTip>
                            <InstantASP:ToolTip ID="ctlEditNotestooltip" Position="Bottom" Text="UserInfo_Notes" runat="server">
                                <InstantASP:HyperLink ID="hypEditNotes" CssClass="edit-notes" Target="_blank" runat="server">
                                        <span>
                                    <i class="fa fa-book"></i>
                                </span>
                                </InstantASP:HyperLink>
                            </InstantASP:ToolTip>
                            <InstantASP:ToolTip ID="ctlGotoProfiletooltip" Position="Bottom" Text="Button_GotoProfile" runat="server">
                            <InstantASP:HyperLink ID="hypgotoProfile" CssClass="goto-profile" Target="_blank" runat="server">
                                    <span>
                                <i class="fa fa-external-link"></i>
                            </span>
                            </InstantASP:HyperLink>
                        </InstantASP:ToolTip>                             
                        </div>
                    </div>                  
                </div>       
            </InstantASP:Panel>
            <InstantASP:Panel ID="pnlSubject" CssClass="i-row ikb-phone-dial-textbox" style="display: none;" runat="server">
                <InstantASP:TextBox ID="txtSubject" runat="server"/>
                <InstantASP:CalloutValidatorExtender id="txtSubjectRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
                        <RequiredFieldValidator ControlToValidate="txtSubject" ErrorMessage="FormValidation_CallOutExtenderSubjectRequired" />
                </InstantASP:CalloutValidatorExtender>	   
            </InstantASP:Panel>     
            <InstantASP:Panel ID="pnlIncomingCallLoader" CssClass="i-row ikb-incoming-call-loader" style="display: none;" runat="server">
                <div class="i-spacing i-centered">
                    <i class="fa fa-spinner fa-spin fa-2x"></i><br /><br />                                
                    <InstantASP:Label ID="lblIncomingCallLoader" CssClass="i-type-bold" runat="server" />
                </div>
            </InstantASP:Panel>
            <InstantASP:Panel ID="pnlDialer" Cssclass="i-row" runat="server">
                <div class="i-menu" style="margin: 0 !important; padding: 0 !important;">    
                <ul class="ikb-phone-dial">
                    <li>
                        <a href="javascript:void(0);" data-num="1"><span>1</span></a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" data-num="2"><span>2</span></a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" data-num="3"><span>3</span></a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" data-num="4"><span>4</span></a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" data-num="5"><span>5</span></a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" data-num="6"><span>6</span></a>
                    </li>
                        <li>
                        <a href="javascript:void(0);" data-num="7"><span>7</span></a>
                    </li>
                        <li>
                        <a href="javascript:void(0);" data-num="8"><span>8</span></a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" data-num="9"><span>9</span></a>
                    </li>
                        <li>
                        <a href="javascript:void(0);" data-num="*"><span>*</span></a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" data-num="0"><span>0</span></a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" data-num="#"><span>#</span></a>
                    </li>
                </ul>
                </div>
            </InstantASP:Panel>
            <InstantASP:Panel ID="pnlNotes" CssClass="i-row phone-notes ikb-phone-dial-textbox" runat="server" style="display: none;">
                <InstantASP:TextBox ID="txtNotes" TextMode="MultiLine" Height="230px" runat="server" />
            </InstantASP:Panel>                
            <InstantASP:Panel ID="pnlTimer" Cssclass="i-row" runat="server">
                <div class="ikb-stop-watch">
                    <div class="timer-text"></div>
                </div>
            </InstantASP:Panel> 
            <div class="i-row">
                <div class="i-row">
                    <InstantASP:HyperLink ID="hypMakeCall" CssClass="i-btn i-btn-2x i-btn-primary" style="width: 100%; border: 0 !important; border-radius: 0 !important;" Text="StaffInsertUpdatePhoneCall_MakeCall" ToolTip="StaffInsertUpdatePhoneCall_MakeCall" runat="server">
                        <span class="text"><i class="fa fa-microphone fa-2x"></i> [0]</span>
                        <span class="loader" style="display: none;">
                            <i class="fa fa-spinner fa-spin fa-2x"></i>
                        </span>
                    </InstantASP:HyperLink>             
                    <InstantASP:HyperLink ID="hypHangUp" CssClass="i-btn i-btn-2x i-btn-danger" style="width: 100%; display: none; border: 0 !important; border-radius: 0 !important;" Text="StaffInsertUpdatePhoneCall_HangUp" ToolTip="StaffInsertUpdatePhoneCall_HangUp" runat="server">
                        <span class="text"><i class="fa fa-microphone-slash fa-2x"></i> [0]</span>
                        <span class="loader" style="display: none;">
                            <i class="fa fa-spinner fa-spin fa-2x"></i>
                        </span>
                    </InstantASP:HyperLink>
                </div>
            </div>             
            <InstantASP:Panel ID="pnlLog" CssClass="i-row ikb-call-log" runat="server">
                <div class="log">checking status...</div>
            </InstantASP:Panel>  

        </InstantASP:Panel>
     </section>      
</div>         
                   
<div style="display: none;"></div>
<InstantASP:Literal ID="lblTwilloCode" runat="server" />
</div>