﻿<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>

<asp:UpdateProgress ID="ctlUpdateProgress" Visible="False" runat="Server" />
<asp:UpdatePanel ID="ctlUpdatePanel" Runat="Server"/>

<InstantASP:Summary id="ctlSummary" Runat="Server"/>

<InstantKBWebControls:PagingOptions id="ctlHeaderPagingOptions" Orientation="Top" Runat="Server" />

<InstantASP:PanelBar id="ctlPanelBar" Text="StaffEditArticleHistory_PageTitle" TableName="tblArticleVersions" Runat="Server">
    <InstantASP:Table id="tblArticleVersions" CellPadding="0" CellSpacing="0" Width="100%" Runat="Server">
    <tr><td>
    	
            <InstantASP:DataGrid ID="ctlDataGrid" AllowSorting="True" AutoGenerateColumns="False" Width="100%" 
            CssClass="i-table" ShowHeader="True" AllowPaging="False" NoRecordsTableCellCssClass="i-col-light" 
            AllowCustomPaging="True" Runat="Server">
            <Columns>
        	        
                <InstantASP:TemplateColumn Visible="false" HeaderText="StaffViewComments_CommentID" 
                HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                ItemStyle-CssClass="i-col-light" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>
	                    <InstantASP:Label id="lblIdentity" Runat="Server" />
	                    <InstantASP:Label id="lblArticleIdentity" Runat="Server" />
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>
                    		
                <InstantASP:TemplateColumn HeaderText="StaffEditArticleHistory_Version" 
                HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                ItemStyle-CssClass="i-col-light" ItemStyle-Width="5%" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>	                    
                        <InstantASP:Label id="lblVersion" CssClass="i-type-bold i-margin-right-small" Runat="Server" />                                                                       
                  
                        <InstantASP:ToolTip id="hypCopyVerionLinkToolTip" Visible="false" Text="StaffEditArticleHistory_CopyVerionLinkToolTip" Runat="Server">
                            <InstantASP:HyperLink id="hypCopyVerionLink" CssClass="i-btn i-btn-default" runat="server">
                                <span><i class="fa fa-link"></i></span>
                            </InstantASP:HyperLink>
                        </InstantASP:ToolTip> 
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>
                          		
                <InstantASP:TemplateColumn HeaderText="" 
                HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                ItemStyle-CssClass="i-col-light" ItemStyle-Width="2%" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>	                    
                           <InstantASP:ToolTip id="hypOpenVersionToolTip" Text="StaffEditArticleHistory_PreviewVersionToolTip" Runat="Server">
                            <InstantASP:HyperLink id="hypOpenVersion" CssClass="i-btn i-btn-default" runat="server">
                                <span><i class="fa fa-external-link"></i></span>
                            </InstantASP:HyperLink>
                        </InstantASP:ToolTip> 
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>

                 <InstantASP:TemplateColumn HeaderText="StaffEditArticleHistory_Date" 
                HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                ItemStyle-CssClass="i-col-light" ItemStyle-Width="15%" SortExpression="InstantKB_ArticleVersions.DateStamp" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>	                    
                          <InstantASP:Label id="lblPostedDate" Text="ViewArticles_PostedDateEmpty" CssClass="i-type-light" Runat="Server" />
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>
                                                    
                <InstantASP:TemplateColumn HeaderText="Field_ArticleWorkFlowStepID" 
                HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                ItemStyle-CssClass="i-col-light" ItemStyle-Width="20%" SortExpression="InstantKB_ArticleVersions.ArticleWorkFlowStepID" HeaderStyle-CssClass="i-col-header">
	                <ItemTemplate>	                    
                          <InstantASP:Label id="lblWorkFlowStep" CssClass="i-type-light" Runat="Server" />
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>
                      
                <InstantASP:TemplateColumn HeaderText="StaffEditArticleHistory_ChangedBy"  
                ItemStyle-CssClass="i-col-light" HeaderStyle-CssClass="i-col-header"
                ItemStyle-Width="60%" SortExpression="InstantKB_ArticleVersions.UserID">
                    <ItemTemplate>
                                      
                        <span class="i-photo i-photo-small i-align-middle i-margin-right-small">
                            <InstantKBWebControls:UserPhoto id="ctlPhoto" runat="server" />
                        </span>
                        <InstantASP:Label id="lblUsername" CssClass="i-type-bold" Runat="Server" />
          
                    </ItemTemplate>	
                </InstantASP:TemplateColumn>      

            </Columns>
            </InstantASP:DataGrid>
			
    </td></tr>    
    </InstantASP:Table>
</InstantASP:PanelBar>

<InstantKBWebControls:PagingOptions id="ctlFooterPagingOptions" Orientation="Bottom" Runat="Server" />

<div class="footer-pull-bottom">
    <footer class="i-col-dark">   
        <div class="margin">            
            <InstantASP:LinkButton ID="hypCompare" Text="StaffEditArticleHistory_CompareVersions" CssClass="i-btn i-btn-2x i-btn-primary disabled" runat="server">
                <span class="i-btn-bg"></span>
                <span>[0]</span>
            </InstantASP:LinkButton>                            
            <span class="i-type-light">
                Select 2 versions to compare
            </span>
        </div>
    </footer>                        
</div>

