﻿<%@ Control Language="cs" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>

<InstantKB:Header id="ctlHeader" Runat="Server"/>

<asp:UpdateProgress ID="ctlUpdateProgress" Visible="false" runat="Server" />
<asp:UpdatePanel ID="ctlUpdatePanel" Runat="Server"/>

<InstantASP:Summary id="ctlSummary" Runat="Server"/>
		
<InstantASP:PanelBar Text="ResetPassword_Title" id="ctlPanelBar" runat="Server">
	<InstantASP:Table ID="Table1" class="i-table i-responsive-table" runat="Server">
	<tr>
    <td class="i-col-header" colspan="2">
        <div class="i-col-header_bg"></div>
        <InstantASP:Label Text="ResetPassword_Description" id="lblResetPasswordSubHeader" runat="server"/>            
    </td>
    </tr>    
    <tr>
    <td style="width: 30%;" class="i-col-light">
    
        <InstantASP:Label Text="ResetPassword_NewPassword" id="lblNewPassword1" CssClass="i-type-bold" Runat="server"/><br />
        <InstantASP:Label Text="ResetPassword_NewPasswordDesc" id="lblNewPassword2" Runat="server"/>
             
    </td>
    <td class="i-col-light">                

	    <InstantASP:TextBox CssClass="i-text-box" TextMode="Password" id="txtPassword" TabIndex="3" runat="Server"/>
	    <InstantASP:ToolTip Text="Register_Password1Description" id="ToolTip2" TipWidth="250" runat="Server"/>
	
	    <InstantASP:CalloutValidatorExtender id="txtPasswordRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
            <RequiredFieldValidator ControlToValidate="txtPassword" ErrorMessage="Register_Password1Required"/>
        </InstantASP:CalloutValidatorExtender>

        <InstantASP:CalloutValidatorExtender id="txtPasswordRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
            <RegExValidator ControlToValidate="txtPassword" ErrorMessage="Register_PasswordLength" ValidationExpression="\S{4,32}"/>
        </InstantASP:CalloutValidatorExtender>
        
    </td>
    </tr>	
    <tr>
    <td style="width: 30%;" class="i-col-light">
    
        <InstantASP:Label Text="Register_Password2" id="lblPasswordConfirm1" CssClass="i-type-bold" Runat="server"/><br />
        <InstantASP:Label Text="Register_Password2Description" id="lblPasswordConfirm2" runat="Server"/>
		
    </td>
    <td class="i-col-light">                

  <InstantASP:TextBox TextMode="Password" TabIndex="4" CssClass="i-text-box" id="txtPasswordConfirmation" runat="Server"/>
		<InstantASP:ToolTip Text="Register_Password1Description" id="ToolTip3"  TipWidth="250" Runat="Server"/>
	
	    <InstantASP:CalloutValidatorExtender id="txtPasswordConfirmationRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
            <RequiredFieldValidator ControlToValidate="txtPasswordConfirmation" ErrorMessage="Register_Password2Required"/>
        </InstantASP:CalloutValidatorExtender>

        <InstantASP:CalloutValidatorExtender id="txtPasswordConfirmationCompareValidator" ShortErrorMessage="InvalidMatch" Runat="Server">
            <CompareValidator ControlToValidate="txtPasswordConfirmation" ControlToCompare="txtPassword" ErrorMessage="Register_Password2NoMatch"/>
        </InstantASP:CalloutValidatorExtender>
        
    </td>
    </tr>	
	<tr>
    <td style="width: 30%;" class="i-col-light  i-responsive-table-hide">&nbsp;</td>
	<td class="i-col-light">
	        
        <asp:Button id="butUpdatePassword" CssClass="i-button" runat="server"/>
		        
    </td>
    </tr>
	</InstantASP:Table>
</InstantASP:PanelBar>
  
<InstantKB:Footer ID="Footer1" Runat="Server"/>