﻿"use strict";

var $instantasp = {
    // client detection
    userAgent: navigator.userAgent.toLowerCase(),
    browserVersion: navigator.appVersion,
    isWebKit: (navigator.userAgent.toLowerCase().indexOf("webkit/") != -1),
    isFirefox: (navigator.userAgent.toLowerCase().indexOf("firefox/") != -1),    
    isChrome: (navigator.userAgent.toLowerCase().indexOf("chrome/") != -1),
    isOpera: (navigator.userAgent.toLowerCase().indexOf('opera') != -1),
    isSafari: ((navigator.userAgent.toLowerCase().indexOf("safari/") > -1) && (navigator.userAgent.toLowerCase().indexOf("chrome/") == -1)) ? true : false,
    isIE11: (navigator.userAgent.match(/Trident/) && !navigator.userAgent.match(/MSIE/)) ? true : false,
    isIE: (document.all && document.getElementById) ? true : false,
    isAndroid: (navigator.userAgent.toLowerCase().indexOf("android/") != -1),
    isBlackberry: (navigator.userAgent.toLowerCase().indexOf("blackberry/") != -1),
    isIOS: navigator.userAgent.toLowerCase().match(/(iphone|ipod|ipad)/) ? true : false,
    isMobile: function () {
        return ((this.isIOS || this.isAndroid || this.isBlackberry) ? true : false);
    },
    get: function (id) {
        if (document.getElementById)
        { return document.getElementById(id); }
        else if (document.all) { return document.all[id]; }
        else if (document.layers) { return document.layers[id]; }
        return null;
    },
    getViewport: function () {
        var m = document.compatMode == 'CSS1Compat';
        return {
            l: window.pageXOffset || (m ? document.documentElement.scrollLeft : document.body.scrollLeft),
            t: window.pageYOffset || (m ? document.documentElement.scrollTop : document.body.scrollTop),
            w: $(window).width(),
            h: $(window).height()
        };
    },
    initUI: function () {     
        this.initToolTips();
        this.initMobileBreadCrumb();
        this.initSimpleMenu();
        this.initFocus();
        this.initSelectOnFocus();
        this.initTableOverflows();    
    },
    initTableOverflows: function () {
                
        // automatic table horizontal overflow scroll   
        var el = $(".grid-overflow");
        if (el.length > 0) {                    
         
            var applyScroll = false;
            var container = el.parents().find("table");            
            if (container) {
                if (container.width() > el.width()) {                        
                    el.css({ "overflow-y": "hidden",  "overflow-x": "scroll" });
                    applyScroll = true;
                }
            }
                              
            $(window).resize(function () {             
                if (container.width() > el.width()) {
                    el.css({ "overflow-y": "hidden", "overflow-x": "scroll" });
                } else {
                    el.css({ "overflow": "hidden" });
                }
            });

        }
    },
    initSimpleMenu: function () {
        // append simple menus to the end of our body
        // ensures correct positioning / rendering
        $(".sm").each(function () {
            var sm = $(this), html = sm.html();
            sm.empty(); $("body").append(html);
        });
    },
    initMobileBreadCrumb: function () {
        // copy lists into menu
        var bc = $(".i-mobile-bread-crumb");
        if (bc.length > 0) {
            var list = bc.find("UL"),
                lis = $(".i-bread-crumb").find("LI");
            list.empty();
            lis.each(function (ev) {
                list.append($(this).clone());
            });
            bc.addClass("i-mobile-bread-crumb-visible");
        }
    },
    initToolTips: function () {

        /* desktop */
        var tooltips = $(".i-tooltip");
        tooltips.mouseenter(function (e) {         
            iasp_HideAllToolTips();
            iasp_ShowToolTip($(this));
        });

        tooltips.mouseleave(function (e) {
            iasp_HideToolTip($(this));
        });

        /* mobile */
        tooltips.mousedown(function (e) {
            iasp_HideToolTip($(this), false);
            iasp_ShowToolTip($(this), false);
        });
         
    },
    initFocus: function () {
        $("form").find('.i-text-box').each(function () {
            var input = $(this);
            if (typeof input.data("hasfocus") != 'undefined') {
                if (typeof input.data("isTidy") == 'undefined' || input.data("isTidy") == false) {
                    input.data("isTidy", true);
                    input.focus();
                    return false;
                }

            }
        });
    },
    initSelectOnFocus: function () {
        $('.i-select-on-focus').selectOnFocus();
    },
    isScrolledIntoView: function (elem) {
        var docViewTop = $(window).scrollTop();
        var docViewBottom = docViewTop + $(window).height();
        var elemTop = $(elem).offset().top;
        var elemBottom = elemTop + $(elem).height();
        return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
    },
    isInFrame: function () {
        try {
            return window.self !== window.top;
        } catch (e) {
            return true;
        }
    }
};

/* legacy sniffing */
var iasp_UserAgent = navigator.userAgent.toLowerCase(),
    iasp_BrowserVer = navigator.appVersion, 
    iasp_Opera = (iasp_UserAgent.indexOf('opera') != -1),
    iasp_Opera8 = ((iasp_UserAgent.indexOf('opera 8') != -1 || iasp_UserAgent.indexOf('opera/8') != -1) ? 1 : 0),
    iasp_NS4 = (document.layers) ? true : false,
    iasp_IE4 = (document.all && !document.getElementById) ? true : false,
    iasp_IE5 = (document.all && document.getElementById) ? true : false,
    iasp_IsIE = (iasp_IE4 || iasp_IE5) ? true : false,
    iasp_NS6 = (!document.all && document.getElementById) ? true : false,
    iasp_FireFox = (iasp_UserAgent.indexOf("firefox/") != -1), 
    iasp_Chrome = (iasp_UserAgent.indexOf("chrome/") != -1);

// simple menu control

var iasp_MenusActive = false, iasp_MenuItems = new Array();
var iasp_MenuLeft = 0, iasp_MenuRight = 0, iasp_MenuTop = 0, iasp_MenuBottom = 0;
var currentSize = null, iasp_ModalActive = false;

// very important for <IE9 HTML 5 support !!!!!!!
// http://fortuito.us/diveintohtml5/semantics.html#unknown-elements
// http://html5doctor.com/html-5-reset-stylesheet/
var e = ("abbr,article,aside,audio,canvas,datalist,details," +
"figure,footer,header,hgroup,mark,menu,meter,nav,output," +
"progress,section,time,video").split(',');
for (var i = 0; i < e.length; i++) {
    document.createElement(e[i]);
}

addEvent(window, 'load', function (e) {
      
    // common
    $instantasp.initUI();
    
    // add touch events  
    addEvent(document, "touchstart", touchHandler);
    addEvent(document, "touchmove", touchHandler);
    addEvent(document, "touchend", touchHandler);
    addEvent(document, "touchcancel", touchHandler);
        
});

/* mainly for touch support */
addEvent(document, 'mousedown', function (e) {

    // hide menus
    if (!$("#bgDimmer").is(":visible")) {
        iasp_HideAllMenusOnClick(e);
    }
    // hide validators
    iasp_HideAllCallOutExtenders(e);
    // hide tooltips
    iasp_HideAllToolTips();
    // hide link bar menus
    linkbar.hideMenusOnClick(e);

});

/* event handler for desktop skin on touch devices */
function touchHandler(event) {
    var touches = event.changedTouches,
        first = touches[0],
        type = "";

    switch (event.type) {
        case "touchstart": type = "mousedown"; break;
        case "touchmove": type = "mousemove"; break;
        case "touchend": type = "mouseup"; break;
        default: return;
    }
    
    var simulatedEvent = document.createEvent("MouseEvent");
    simulatedEvent.initMouseEvent(type, true, true, window, 1,
                          first.screenX, first.screenY,
                          first.clientX, first.clientY, false,
                          false, false, false, 0/*left*/, null);
    
    first.target.dispatchEvent(simulatedEvent);
    event.cancelBubble();

}

/* form validation */
var validatePage = {
    validate: function () {     
        if (typeof Page_ClientValidate == 'undefined') { return true; }            
        if (typeof (ValidatorOnSubmit) == "function" && ValidatorOnSubmit() == false) {
            return false;
        }          
        if (this.allValidatorsValid()) {
            return true;
        } else {          
            return false;
        }    
    },
    allValidatorsValid: function () {
        if ((typeof (Page_Validators) != "undefined") && (Page_Validators != null)) {          
            for (var i = 0; i < Page_Validators.length; i++) {               
                if (!Page_Validators[i].isvalid) {
                    return false;
                }
            }
        }
        return true;
    },
    groupValidatorsValid: function(validationGroup) {
        for (i = 0; i < Page_Validators.length; i++) {
            var val = Page_Validators[i];
            if (val.validationGroup == validationGroup) {
                if (!val.isvalid) {
                    return false;
                }
            }
        }
        return true;
    },
    iterateValidators: function(validationGroup) {

        // highlight valid
        for (var i = 0; i < Page_Validators.length; i++) {
            var val = Page_Validators[i];          
            ValidatorEnable(val);
            var id = this.getCalloutExtenderId(val);
            if (id != null) {
                if (val.isvalid) {
                    this.hideValidatorCallout(id);
                } else {
                    this.showValidatorCallout(id, false);
                    this.bindChangeEvents(val);
                }
            }
        }
        // highlight invalid
        for (var i = 0; i < Page_Validators.length; i++) {
            var val = Page_Validators[i];
            ValidatorEnable(val);
            var id = this.getCalloutExtenderId(val);
            if (id != null) {
                if (!val.isvalid) {
                    this.showValidatorCallout(id, true);
                    this.bindChangeEvents(val);
                    break;
                }
            }
        }        
    },
    getCalloutExtenderId: function (input) {
        if (input == null) { return; }
        var id = null, ajaxCTKIdentifier = "_ClientState"
        var extender = $(input).next();
        if (extender.length > 0) {
            var eleid = extender.attr("id");          
            if (typeof eleid != 'undefined') {
                if (eleid.indexOf(ajaxCTKIdentifier) >= 0) {
                    id = eleid.replace(ajaxCTKIdentifier, "")
                }
            }
        }
        return id;
    },
    getControlForValidator: function(validator) {
        return iasp_FindControl(validator.controltovalidate);
    },
    addDropDownHightlight: function (input) {     
        if (input == null) { return; }
        if (input.className != null && typeof input.className != 'undefined') {
            if (input.className.indexOf("i-select") >= 0) {
                var dd = $("#" + input.id + "_msdd").find(".ddTitle");
                if (dd.length > 0) {
                    dd.addClass("i-input-error");
                }
            }
        }
    },
    removeDropDownHightlight: function (input) {
        if (input == null) { return; }
        if (input.className != null && typeof input.className != 'undefined') {
            if (input.className.indexOf("i-select") >= 0) {
                var dd = $("#" + input.id + "_msdd").find(".ddTitle");
                if (dd.length > 0) {
                    dd.removeClass("i-input-error");
                }
            }
        }
    },
    hideAllValidatorCallouts: function () {
        if (typeof Page_Validators == 'undefined') { return; }
        for (var i = 0; i < Page_Validators.length; i++) {
            var val = Page_Validators[i];           
            var id = this.getCalloutExtenderId(val);
            if (id != null) {                
                var co = $find(id);
                if (co != null) {
                    var input = co._elementToValidate;
                    co.hide(); 
                }
            }
        }
    },
    hideValidatorCallout: function (id) {
        var co = $find(id);
        if (co != null) {
            var input = co._elementToValidate;
            co.hide(); this.removeDropDownHightlight(input);
        }
    },
    bindChangeEvents: function (validator) {
        var input = this.getControlForValidator(validator);
        if (input.tagName.toLowerCase() == "select") {
            $(input).change(function () {
                if ($(this).val() == "") {
                    validatePage.addDropDownHightlight(input);
                } else {
                    validatePage.removeDropDownHightlight(input);
                }
            });
        }
        if (input.tagName.toLowerCase() == "input") {
            $(input).keypress(function () {
                var id = validatePage.getCalloutExtenderId(validator);
                if ($(this).val() != "") {
                    validatePage.hideValidatorCallout(id);
                } else {
                    validatePage.showValidatorCallout(id, false);
                }

            });
        }
    },
    showValidatorCallout: function (id, scrollTo) {
        var co = $find(id);
        if (co != null) {          
            Sys.Extended.UI.ValidatorCalloutBehavior._currentCallout = co;           
            var input = co._elementToValidate;          
            if (scrollTo) {
                if (!$instantasp.isScrolledIntoView(input)) {
                    iasp_scrollToDiv(input.id);
                }
                input.focus();                
                $(co._popupTable).css({ "position": "absolute", "opacity": "1.0" }).shake();
            } else {
                Sys.Extended.UI.ValidatorCalloutBehavior._currentCallout.show(false);
            }
            this.addDropDownHightlight(input);
        }
     
    }    
}

/* window resizing */
var winResizer = {
    previousViewPortSize: null,
    onReize: function () {   
        if (this.previousViewPortSize == null) { return; }   
        var viewPortSize = $instantasp.getViewport();
        if (viewPortSize != null) {
            if (viewPortSize.w != this.previousViewPortSize.w || viewPortSize.h != this.previousViewPortSize.h) {
                this.previousViewPortSize = viewPortSize;
                this.windowResized();
            }
        }
    },
    startTrackingResize: function() {     
        this.previousViewPortSize = $instantasp.getViewport();        
        if (this.previousViewPortSize != null) {
            setInterval(function () { winResizer.onReize() }, 100);
        }
    },
    windowResized: function () {
        if (!$("#bgDimmer").is(":visible")) {
            iasp_HideAllMenus();
        }
        iasp_HideAllToolTips();
    }
}

// -----------------------------
// simple menu control
// -----------------------------

function iasp_OpnMnu(event, a, divid, width, height) {

    height = height || "";

    var viewport = $instantasp.getViewport();

    // hide all other menus
    iasp_HideAllMenus();

    // set local flag
    iasp_MenusActive = true;

    // disable href on main menu link
    var $el = null;
    if (a.tagName != null && a.tagName != 'undefined') {
        if (a.tagName.toLowerCase() == "span") {
            $el = $(a).find("a");
        } else {
            $el = $(a);
        }
    } else {
        $el = $(a);
    }

    if ($el.length > 0) {

        // set active styles
        $el.addClass("selected");
        if ($el.find(".fa-caret-right").length > 0) {
            $el.attr("data-reset-arrow", divid);
            $el.find(".fa-caret-right").removeClass("fa-caret-right").addClass("fa-caret-down");
        }
        $el.attr("data-menu", divid);

        // don't navigate to links, open menu
        var href = $el.attr("href");
        if (typeof href != 'undefined') {
            if (href.toLowerCase().indexOf("http://") >= 0 || href.toLowerCase().indexOf("https://") >= 0) {
                InstantASPCommonUI.prototype.cancelEvent(event);
            }
        }
    }

    // create the container for this menu
    var div = iasp_GetMnuDiv(divid, width);

    // get height now content has been added
    var menuDims = {
        width: $('#' + div.id).width(),
        height: $('#' + div.id).height()
    };

    // do we need to inject a frame?    
    var frameURL = $el.data("frameurl");
    var frameScroll = $el.data("framescroll") ? $el.data("framescroll") : 'yes';
   
    if (frameURL) {

        // find and clear container
        var wrapper = $(div).find(".menu-frame");
        wrapper.empty();
        wrapper.css({ "overflow": "hidden", "height": height })

        // add loader
        var loader = $('<div class="i-loader-jumbo">');
        loader.append($('<div class="i-loader i-loader-2x">'));
        wrapper.append(loader);

        // add frame
        var frame = wrapper.find("iframe");
        if (frame.length == 0) {
            frame = $('<iframe>', {
                src: frameURL,
                id: 'frame' + divid,
                frameborder: 0,
                scrolling: frameScroll
            }).hide().appendTo(wrapper);
        }

        // frame loaded      
        frame.load(function () {
            loader.hide();
            frame.css({ "overflow-y": "auto", "height": height })
            frame.contents().find("body").css({ "background-color": $(div).css("background-color") });
            frame.show();
        });

    }

    // exit if menu is already visible
    for (var count = 0; count < iasp_MenuItems.length; count++) {
        if (iasp_MenuItems[count] == div.id) {
            return false;
        }
    }

    // add menu to active menus array
    iasp_MenuItems[iasp_MenuItems.length] = div.id;

    // position menu relative to the opening link  
    if (a.id == "") { a.id = div.id + "_a"; }

    var heightOffset = a.offsetHeight + 4,
        callerTopPos = iasp_GetOffsetTop(a),
        callerLeft = iasp_GetOffsetLeft(a),
        callerRight = callerLeft + $(a).width(),
        callerTop = callerTopPos + heightOffset,
        centerPoint = callerLeft + (Math.floor($(a).width() / 2));

    if (callerTop != null && !isNaN(callerTop)) {
        div.style.top = (callerTop + 14) + "px";
    }
    if (callerLeft != null && !isNaN(callerLeft)) {
        if (div.className.indexOf("pull-right") >= 0) {
            div.style.left = ((callerRight - (menuDims.width)) + 12) + "px";
        } else if (div.className.indexOf("pull-left") >= 0) {
            div.style.left = (callerLeft - 12) + "px";
        }  else {
            div.style.left = (centerPoint - (menuDims.width / 2)) + "px";
        }
    }

    // create & position menu arrow
    var $arrow = $('#' + divid + "_arrow");
    if ($arrow.length === 0) {
        $arrow = $("<div>");
        $arrow.attr("id", divid + "_arrow");
        $arrow.addClass("i-menu-arrow");
        if (div.className.toLowerCase().indexOf("fixed") >= 0) {
            $arrow.addClass("i-fixed")
        }
        $("body").append($arrow)
    }
    $arrow.css({ "top": callerTop + 2, "left": centerPoint - 12 })

    var menuLeft = 0,
        menuRight = 0,
        menuTop = 0,
        menuBottom = 0;

    //  calculate left and top positions of menu
    if ($instantasp.isIE || $instantasp.isOpera) {
        menuLeft = parseInt(div.style.posLeft);
        menuTop = parseInt(div.style.posTop - heightOffset);
    } else if (iasp_NS6) {
        menuLeft = iasp_StyleWidthToInt(div.style.left);
        menuTop = iasp_StyleWidthToInt(div.style.top);
    }

    menuRight = (menuLeft + menuDims.width);
    menuBottom = (menuTop + menuDims.height);
        
    if (menuRight >= (viewport.w - 12)) {    
        div.style.left = viewport.w - (menuDims.width + 12) + "px";
    }

    if (menuLeft < 0) {
        div.style.left = "8px";
    }

    // set up scroll panel
  
    if (!frameURL) {
        iasp_setMenuHeight(div, height);
    }
    
    function showMenu() {
        $(div).addClass("i-menu-box-animate");
        $arrow.addClass("i-menu-box-animate");          
        $(div).show();
        $arrow.show();
        if ($().tidyUI) {
            $(div).tidyUI();
        }     
    }

    // for smaller screens don't reposition menu       
    if (viewport.w < 400 | viewport.h < 600) {
        showMenu();
        return;
    }

    // finally show after repositioning
    showMenu();

}

function iasp_setMenuHeight(menu, height) {
    menu = $(menu);
    var dims = {
        width: menu.width(),
        height: menu.height()
    };
    if (height != "" && height != null) {
        height = iasp_StyleWidthToInt(height);
        if (dims.height > height) {
            menu.css({ 'height': height, 'overflow-y': 'auto', 'overflow-x': 'hidden' });
        }
    }

}

// Create div to hold menu
function iasp_GetMnuDiv(divid, width) {

    // get dic to display from client
    var div = iasp_FindControl(divid);

    if (div != null) {

        if (width) {
            div.style.width = width;
        }
                
    }

    return div;
}

// Hide all menus on click event of document
function iasp_HideAllMenusOnClick(event, root) {

    var el = null;
    if (event == null) { event = window.event; }
    var el = event.target || event.srcElement;
    if (el != null && typeof el != 'undefined') {
        if (el.tagName != null && typeof el.tagName != 'undefined') {
            if (el.tagName.toLowerCase() == "a") { return; }
            if (el.tagName.toLowerCase() == "input") { return; }
        }
    }

    var p1 = el.parentNode;
    if (p1 != null && typeof p1 != 'undefined') {
        if (p1.tagName != null && typeof p1.tagName != 'undefined') {        
            if (p1.tagName.toLowerCase() == "a") { return; }
            if (p1.tagName.toLowerCase() == "input") { return; }
        }
        var p2 = p1.parentNode;
        if (p2 != null && typeof p2 != 'undefined') {
            if (p2.tagName != null && typeof p2.tagName != 'undefined') {
                if (p2.tagName.toLowerCase() == "a") { return; }
            }
        }
    }
  
    if (el.className) {
        if (el.className.toLowerCase().indexOf("i-menu-box ") >= 0) {
            return;
        }
    }

    el = (el.tagName ? el : p1);
    el = (el.tagName ? el : p2);
    if (el == null) { return; }

    // are menus active
    if (iasp_MenusActive) {
        // find a parent menu div
        var container = iasp_GetContainer(el, "DIV", "_smMenu")
        // if it didn't match our menu close
        if (container != null) {
            if (container.id.indexOf("_smMenu") == -1) {
                // hide all menus
                iasp_HideAllMenus();
            }
        } else {
            // hide all menus
            iasp_HideAllMenus();
        }
    }

}

// Hide all ajaxCTK call out validation extenders
function iasp_HideAllCallOutExtenders(e) {
    if (typeof Page_ClientValidate == 'undefined') { return; }
    var el = null;
    // find the element that was clicked
    if (e == null) { e = window.event; }
    var el = e.target || e.srcElement;
    if (el.tagName != null && typeof el.tagName != 'undefined') {
        if (el.tagName.toLowerCase() == "input") { return; }
        if (el.tagName.toLowerCase() == "a") { return; }
    }
    if (el.parentNode != null && typeof el.parentNode != 'undefined') {
        if (el.parentNode.tagName != null && typeof el.parentNode.tagName != 'undefined') {
            if (el.parentNode.tagName.toLowerCase() == "a") { return; }
        }
    }
    el = (el.tagName ? el : el.parentNode);

    // did we find a parent layer
    var container = iasp_GetContainer(el, "table", "_popupTable")
    if (container != null) {
        if (container.id.indexOf("_popupTable") == -1) {
            validatePage.hideAllValidatorCallouts();
        }
    } else {
        validatePage.hideAllValidatorCallouts();
    }



}

// Hide all menus 
function iasp_HideAllMenus(exception) {
    // hide any possible simply menu control
    if (iasp_MenusActive) {
        for (var i = 0; i < iasp_MenuItems.length; i++) {
            if (iasp_MenuItems[i] != "") {
                var id = iasp_MenuItems[i];
                iasp_HideMenu(id);
                iasp_MenuItems[i] = '';             
            }
        }
    }
    iasp_MenusActive = false;
}

function iasp_HideMenu(id) {
    
    $('#' + id).hide();
    $('#' + id + "_arrow").hide();

    // reset selection
    var link = $("a[data-menu='" + id + "']");
    link.removeClass("selected");
    if (link.data("resetArrow")) {
        link.find(".fa-caret-down").removeClass("fa-caret-down").addClass("fa-caret-right");
    }
    link.attr("data-menu", "");

}

// LinkBar Control

var linkbar = {
    initialSelected: null,
    $container: null,
    $menu: null,
    show: function (a, id, childId) {

        this.$container = $("#" + id);
        this.$menu = $("#" + childId);

        if (this.initialSelected == null) {
            this.initialSelected = this.$container.find(".selected");
        }
            
        this.$menu.unbind("mouseleave").bind("mouseleave", function () {
            linkbar.hideMenus();         
        });
        
        // reset menu
        this.hideMenus();
        this.$menu.addClass("visible");

        this.initialSelected.removeClass("selected");
        a.className = "selected";
               
        // exceed vertical view port?   
        var viewport = $instantasp.getViewport(),
            newHeight = this.$menu.height(),
            menuTop = this.$menu.position().top,
            menuBottom = (parseInt(menuTop) + parseInt(newHeight)),
            scrollBottom = viewport.t + viewport.h;

        if (menuBottom > scrollBottom) {       
            this.$menu.css({ "top": (scrollBottom - newHeight) - 30 })
        }

    },
    hideMenus: function () {
        if (this.$container) {
            this.$container.find("ul").removeClass("visible");
            this.$container.find("a").removeClass("selected");
            if (linkbar.initialSelected != null) {
                linkbar.initialSelected.addClass("selected");
            }
        }            
    },
    hideMenusOnClick: function (e) {    
        if (e.target != null) {
            if (e.target.tagName.toLowerCase() === "a") {
                return true;
            }            
            this.hideMenus();
        } else {
            this.hideMenus();
        }
    }
}

// tasty cookies

function iasp_UpdateCookie(objName, bolSave, strCookieName) {
    var ckColl = iasp_GetCookie(strCookieName);
    var arrLocTemp = new Array();
    if (ckColl != null) {
        var arrColl = ckColl.split(",");
        for (i in arrColl) {
            if (arrColl[i] != objName && arrColl[i] != "") { arrLocTemp[arrLocTemp.length] = arrColl[i]; }
        }
    }
    if (bolSave) { arrLocTemp[arrLocTemp.length] = objName; }
    iasp_SetCookie(strCookieName, arrLocTemp.join(","));
}

function iasp_SetCookie(name, value) {
    var expire = "expires=Wed, 1 Jan 2020 00:00:00 GMT;";
    document.cookie = name + "=" + value + "; path=/;" + expire;
}

function iasp_GetCookie(name) {
    var ckName = name + "=";
    var ckPos = document.cookie.indexOf(ckName);
    if (ckPos != -1) {
        var ckStart = ckPos + ckName.length;
        var ckEnd = document.cookie.indexOf(";", ckStart);
        if (ckEnd == -1) { ckEnd = document.cookie.length; }
        return unescape(document.cookie.substring(ckStart, ckEnd));
    }
    return null;
}

// toggle css class

function iasp_SwitchClass(objectname, classname) {
    var obj = iasp_FindControl(objectname);
    if (obj) { obj.className = classname; }
}

// toggle check boxes

function iasp_tCkbs(ckb) { 
    if (ckb.length == 0) { return; }
    var tagName = ckb[0].nodeName;  
    if (tagName != null) {
        // did we click on the lable?
        if (tagName.toLowerCase() == "label") {            
            var labelfor = $(ckb).attr("for");
            ckb = $("#" + labelfor);
        }
    }
    if (ckb.is(':checked')) {
        ckb.prop('checked', false); 
    } else {
        ckb.prop('checked', true);     
    }
}

// get top offset for object

function iasp_GetOffsetTop(objControl) {

    var top = 0;
    top = objControl.offsetTop;
    var parent = objControl.offsetParent;
    while (parent != document.form) {
        top += parent.offsetTop;
        parent = parent.offsetParent;
    }
    return top;

}

// get left offset for object

function iasp_GetOffsetLeft(objControl) {
    
    var left = 0;
    left = objControl.offsetLeft;
    var parent = objControl.offsetParent;
    while (parent != document.form) {
        left += parent.offsetLeft;
        parent = parent.offsetParent;
    }

    return left;

}

// get the height of an object.

function iasp_GetObjHeight(obj) {
    var height = 0;
    if (iasp_NS4) { var height = obj.clip.height; }
    else { var height = obj.offsetHeight; }
    return height;
}

// starting with the given node, find the nearest contained element             

function iasp_GetContainer(node, tagName, id) {

    while (node != null) {
        if (typeof id != 'undefined' && id != null) {
            if (node.tagName != null && node.tagName.toLowerCase() == tagName.toLowerCase()) {
                if (node.id.indexOf(id) >= 0) {
                    return node;
                }
            }
            node = node.parentNode;

        } else {
            if (node.tagName != null && node.tagName == tagName)
                return node; node = node.parentNode;
        }
    }
    return node;
}

// removes px and percentage markers from css style properties and returns an integer      

function iasp_StyleWidthToInt(strIn) {

    if (strIn == null || typeof strIn == 'undefined') {return 0;}       
    if (!IsNumeric(strIn)) {
        var intOut = 0;
        if (strIn.toLowerCase().indexOf("px") >= 0) {
            intOut = strIn.substr(0, strIn.toLowerCase().indexOf("px"));
        } else if (strIn.indexOf("%") >= 0) {
            intOut = strIn.substr(0, strIn.indexOf("%"));
        }
        return parseInt(intOut);
    } else {
        return parseInt(strIn);
    }
    
}

// removes any trialing anchor points within a string

function iasp_RemoveBookMark(strInput) {
    var uri = new String(strInput)
    var strOutput; var intPos = uri.indexOf('#');
    if (intPos > 0) { strOutput = uri.substring(0, intPos); }
    else { strOutput = uri; } return strOutput;
}

// removes any querystring from a string

function iasp_RemoveQueryString(strInput) {
    var uri = new String(strInput)
    var strOutput; var intPos = uri.indexOf('?');
    if (intPos > 0) { strOutput = uri.substring(0, intPos); }
    else { strOutput = uri; } return strOutput;
}

// set focus in inputs

function setCaretToPos(input, pos) {
    setSelectionRange(input, pos, pos);
}

function setSelectionRange(input, selectionStart, selectionEnd) {
    if (input.setSelectionRange) {
        input.focus();
        input.setSelectionRange(selectionStart, selectionEnd);
    }
    else if (input.createTextRange) {
        var range = input.createTextRange();
        range.collapse(true);
        range.moveEnd('character', selectionEnd);
        range.moveStart('character', selectionStart);
        range.select();
    }

}

var delay = (function () {
    var timer = 0;
    return function (callback, ms) {
        clearTimeout(timer);
        timer = setTimeout(callback, ms);
    };
})();

/* get object model */
function iasp_ieTrueBody() {
    return (document.compatMode && document.compatMode != "BackCompat") ? document.documentElement : document.body;
}

// ToolTip Control

var ttTimer = false;

function iasp_ShowToolTip(caller, delay) {
    
    // disable tipcs for touch devices
    if ($instantasp.isMobile()) {
        return;
    }

    if (!caller.length) { return; }
    delay = (delay == null) ? true : false;
    var tText = caller.attr("title");
    if (tText == "") { tText = caller.attr("alt"); }
    if (tText == "") { tText = (typeof caller.data("orig-title") != 'undefined') ? caller.data("orig-title") : ""; }

    // ensure we have text to display
    if (tText != null) {
        if (tText.replace(" ", "") == "") { return; }
    } else {
        return;
    }

    // clear & store original title / alt text
    caller.data("orig-title", tText)
    caller.attr("alt", "")
    caller.attr("title", "")

    if (delay) {
        ttTimer = window.setTimeout(function () { showTip() }, 25);
    } else {
        showTip();
    }

    function showTip() {

        // set CSS
        var css = "i-tt", arrowcss = "i-tt-arrow i-tt-arrow-bottom";
        if (caller.data("css") != null || typeof caller.data("css") != 'undefined') { css = caller.data("css"); }    
   
        // should we align arrow below
        var position = "top";
        if (caller.data("position") != null || typeof caller.data("position") != 'undefined') { position = caller.data("position"); }
        if (position == "bottom") {
            arrowcss = "i-tt-arrow i-tt-arrow-top";
        } else if (position == "right") {
            arrowcss = "i-tt-arrow i-tt-arrow-left";
        } else if (position == "left") {
            arrowcss = "i-tt-arrow i-tt-arrow-right";
        }

        // get tooltip layer
        var div = iasp_FindControl('iasp_ToolTip');
        var footer = iasp_FindControl('iaspToolTip_Footer');

        // reset CSS
        if (div != null && footer != null) {
            if (div.className != css || footer.className != arrowcss) {
                document.body.removeChild(div); div = null;
                document.body.removeChild(footer); footer = null;
            }
        }

        // build if not found
        if (div == null && footer == null) {

            div = document.createElement("DIV");
            div.id = "iasp_ToolTip";
            div.style.left = '-3000px'
            div.className = css;

            var text = document.createElement("DIV");
            text.id = "iasp_ToolTipTxt";
            if (typeof caller.data("width") == "undefined" && caller.data("width") != 0 || caller.data("width") == null) {
                text.style.whiteSpace = "nowrap";
            }

            div.appendChild(text);

            footer = document.createElement("DIV");
            footer.id = "iaspToolTip_Footer";
            footer.style.left = '-3000px';
            footer.className = arrowcss;

            document.body.appendChild(div);
            document.body.appendChild(footer);

        } else {

            div.style.left = '-3000px'
            footer.style.left = '-3000px'

        }

        // populate text
        iasp_PopulateToolTip(tText);

        var intWidth;
        if (typeof caller.data("width") != "undefined" && caller.data("width") != 0 && caller.data("width") != null) {
            intWidth = caller.data("width");
            div.style.width = intWidth + "px";
        } else {
            intWidth = $('#iasp_ToolTip').width();
            InstantASPCommonUI.prototype.setAttribute(div, "style", "width:");
        }
           
        var $offset = caller.offset(),
            intParentTop = $offset.top,
            intParentLeft = $offset.left,
            intParentWidth = caller.width(),
            intParentHeight = caller.height(),
            $div = $("#" + div.id),
            $footer = $("#" + footer.id);

        // get tip height
             
        var mainHeight = $div.height(),
            arrowHeight = $footer.height(),
            height = mainHeight + arrowHeight;      
        
        // ensure tooltip fits on screen 
        var size = $instantasp.getViewport(), winWidth, winHeight;
        if (size != null) {
            winWidth = parseInt(size.w);
            winHeight = parseInt(size.h);
        }
        
        if (position == "bottom") {
            var top = Math.floor(intParentTop + caller.height());            
            if ((top + height) > (winHeight + $(window).scrollTop())) {
                position = "top";               
                $footer.removeClass("i-tt-arrow-top");
                $footer.addClass("i-tt-arrow-bottom");
            }
        }
                

        // position
           
        var centerPoint = intParentLeft + (Math.floor(intParentWidth / 2));
        var centerPointVert = intParentTop + (Math.floor(intParentHeight / 2));
        var aniOffSet = -10;
        if (position == "left" || position == "bottom") {
            aniOffSet = 10;
        }
                   
        // position tip
        if (position == "top") {
            div.style.top = Math.floor(intParentTop) - (Math.floor(height)) + "px";
            div.style.left = Math.floor(centerPoint + 4) - ((Math.floor(intWidth) / 2)) + "px";
        } else if (position == "right") {
            div.style.top = Math.floor(centerPointVert) - ((Math.floor(mainHeight) / 2)) + "px";
            div.style.left = (intParentLeft + 16) + (Math.floor(intParentWidth)) + "px";
        } else if (position == "left") {
            div.style.top = Math.floor(centerPointVert) - ((Math.floor(mainHeight) / 2)) + "px";
            div.style.left = (intParentLeft - 16) - (Math.floor(intWidth)) + "px";
        } else if (position == "bottom") {
            div.style.top = Math.floor(intParentTop) + (Math.floor(caller.height())) + "px";
            div.style.left = Math.floor(centerPoint) - ((Math.floor(intWidth) / 2)) + "px";
        }

        // position arrow
        if (position == "top") {
            footer.style.top = iasp_StyleWidthToInt(div.style.top) + (mainHeight) + "px";
            footer.style.left = (centerPoint - 7) + "px";
        } else if (position == "right") {
            footer.style.top = (centerPointVert - 8) + "px";
            footer.style.left = (iasp_StyleWidthToInt(div.style.left) - 8) + "px";
        } else if (position == "left") {
            footer.style.top = (centerPointVert - 8) + "px";
            footer.style.left = iasp_StyleWidthToInt(div.style.left) + (intWidth) + "px";
        } else if (position == "bottom") {
            footer.style.top = (iasp_StyleWidthToInt(div.style.top)) - 7 + "px";
            footer.style.left = (centerPoint - 7) + "px";
        }

        //  calculate left and top position of populated div
        var intLeft, intTop;        
        if (iasp_IE4 || iasp_IE5 || iasp_Opera) {
            intLeft = div.style.posLeft;
            intTop = div.style.posTop;
        } else if (iasp_NS6) {
            intLeft = iasp_StyleWidthToInt(div.style.left);
            intTop = iasp_StyleWidthToInt(div.style.top);
        }

        if (intLeft < 0) {
            div.style.left = intParentLeft + "px";
        }
           
        if (intTop <= 0) {         
            return;
        }

        if (intWidth >= (winWidth - 12)) {
            div.style.width = (winWidth - 12) + "px";
        }

        if (intLeft <= 0) {
            div.style.left = "6px";
        } else {        
            if ((intLeft + intWidth) >= winWidth) {                             
                div.style.left = (winWidth - (intWidth + 12)) + "px";
            }
        }
              
        // finally show
              
        if (position == "top" || position == "bottom") {
            $div.fadeIn('fast').animate({
                'top': iasp_StyleWidthToInt(div.style.top) + aniOffSet
            }, { duration: 'fast', queue: false }, function () {
            });
            $footer.fadeIn('fast').animate({
                'top': iasp_StyleWidthToInt(footer.style.top) + aniOffSet
            }, { duration: 'fast', queue: false }, function () {
            });
        } else if (position == "right" || position == "left") {
            $div.fadeIn('fast').animate({
                'left': iasp_StyleWidthToInt(div.style.left) + aniOffSet
            }, { duration: 'fast', queue: false }, function () {
            });
            $footer.fadeIn('fast').animate({
                'left': iasp_StyleWidthToInt(footer.style.left) + aniOffSet
            }, { duration: 'fast', queue: false }, function () {
            });
        }


    }

}

function iasp_PopulateToolTip(strText) {
    var div = iasp_FindControl("iasp_ToolTipTxt");
    if (div != null) {
        div.innerHTML = "<p>" + strText + "</p>";
    }
}

function iasp_HideToolTip(a) {
    // disable tipcs for touch devices
    if ($instantasp.isMobile()) {
        return;
    }
    var div = iasp_FindControl('iasp_ToolTip');
    var footer = iasp_FindControl('iaspToolTip_Footer');
    if (div != null) { div.style.display = "none"; document.body.removeChild(div); }
    if (footer != null) { footer.style.display = "none"; document.body.removeChild(footer); }
    if (ttTimer) {
        window.clearTimeout(ttTimer);
        ttTimer = false;
    }
}

function iasp_HideAllToolTips() {
    if ($("#iasp_ToolTip").is(':visible')) {
        $("#iasp_ToolTip").hide();
        $("#iaspToolTip_Footer").hide();
    }
}

// dim background 

function iasp_disableBody(cursor, css, fade) {

    // set pointer to hourglass
    if (document.body != null) { document.body.style.cursor = cursor ? cursor : "wait"; }

    css = css || "i-async-dimmer";
    fade = (fade != null) ? fade : true;

    // init dimmer
    var div = null;
    var divid = "lightsOut";
    if (iasp_FindControl(divid) != null) {
        div = iasp_FindControl(divid);
    } else {     
        div = document.createElement("DIV");
        div.id = divid;
        div.className = css;
        div.innerHTML = "&nbsp;";        
        window.document.body.appendChild(div);
    }
       
    // show dimmed background
    $(div).addClass("i-async-dimmer-visible");

}

// enable bg again

function iasp_enableBody() {

    // get body
    var body = document.getElementsByTagName("body");

    // set pointer to default
    if (document.body != null) { document.body.style.cursor = 'default'; }

    // hide dimmer
    var dimmer = iasp_FindControl("lightsOut");
    if (dimmer != null) {
        $(dimmer).removeClass("i-async-dimmer-visible");
    }

}

// disable object

function iasp_diableElem(el) {
    try {
        el.disabled = el.disabled ? false : true;
    }
    catch (e) { }
    if (el.childNodes && el.childNodes.length > 0) {
        for (var x = 0; x < el.childNodes.length; x++) {
            iasp_diableElem(el.childNodes[x]);
        }
    }
}

// find child control

function iasp_findChildByTag(el, tagName) {
    if (el.childNodes && el.childNodes.length > 0) {
        for (var x = 0; x < el.childNodes.length; x++) {
            if (el.tagName == tagName) {

                return el;
            } else {
                iasp_findChildByTag(el.childNodes[x]);
            }

        }
    }
    return null;
}

// find the submit button within a form

function iasp_findSubmit(doc) {
    var inputs = doc.getElementsByTagName('input');
    for (var i = 0; i < inputs.length; i++) {
        var input = inputs[i];   
        if (input.type.toLowerCase() == 'submit') {
            return input;
        };
    };
    return null;
}

function iasp_findUpload(doc) {
    var inputs = doc.getElementsByTagName('input');
    for (var i = 0; i < inputs.length; i++) {
        var input = inputs[i];   
        if (input.type.toLowerCase() == 'file') {
            return input;
        };
    };
    return null;
}

// AJAX Loader

var iasp_bolLoadStarted = false,
    iasp_bolLoadEnded = false,
    iasp_LoaderDivId = 'iasp_LoaderDiv',
    iasp_LoaderDiv = null;

function iasp_AjaxExtensionsInitializeRequest(postBackElement) {

    // ensure method is only ran once
    if (!iasp_bolLoadStarted) {

        // disable bg
        iasp_disableBody();

        // show loader
        iasp_AddLoader();

        // update flags
        iasp_bolLoadStarted = true;
        iasp_bolLoadEnded = false;

    }
}

function iasp_AjaxExtensionsEndRequest(postBackElement) {

    // ensure method is only ran once
    if (!iasp_bolLoadEnded) {

        // enable background
        iasp_enableBody();

        // hide loader
        iasp_RemoveLoader();

        // update flags
        iasp_bolLoadEnded = true;
        iasp_bolLoadStarted = false;

    }
}

function iasp_AjaxExtensionsLoaderSetText(text) {
    $(".async-loader").find(".text").html(text);
}

function iasp_AddLoader() {

    // build loader
    if (!iasp_LoaderDiv) { iasp_LoaderDiv = document.createElement('div'); }
    iasp_LoaderDiv.id = iasp_LoaderDivId;
    iasp_LoaderDiv.className = "i-async-loader"
    iasp_LoaderDiv.innerHTML = '<div class="i-row"><div class="i-async-loader-bars"><div class="rect1"></div><div class="rect2"></div><div class="rect3"></div><div class="rect4"></div><div class="rect5"></div></div><div class="text">' + iasp_Loading + '</div></div>';
    document.body.appendChild(iasp_LoaderDiv);

    // center

    var loader = $(".i-async-loader");
    var top = Math.max(($(window).height() - loader.outerHeight()) / 2);
    top += $(window).scrollTop() || 0;
    var left = ($(window).width() - loader.outerWidth()) / 2;
    if (window) left += $(window).scrollLeft() || 0;
    loader.css({ "top": top, "left": left }).show().addClass("i-async-loader-visible");

}

function iasp_RemoveLoader() {
    // hide loader
    var loader = $(".async-loader");
    loader.removeClass("async-loader-visible");
    var iasp_LoaderDiv = iasp_FindControl(iasp_LoaderDivId);
    if (iasp_LoaderDiv != null) {
        iasp_LoaderDiv.style.display = "";
        document.body.removeChild(iasp_LoaderDiv);
    }

}

// JSON Proxy

var instantaspjsonproxy = new Object();

function InstantASPJSONProxy(strJSON) {
    this.json = strJSON;
    this.jsonData = null; // store in internal array to avoid multiple json parsing

    if (instantaspjsonproxy[strJSON] != null) {
        return instantaspjsonproxy[strJSON];
    } else {
        instantaspjsonproxy[strJSON] = this;
    }
    return this;
}

InstantASPJSONProxy.prototype.getData = function () {
    if (this.jsonData == null) {
        try {
            this.jsonData = JSON.parse(this.json);
        } catch (e) {
            alert("Unable to parse JSON string!\n\n" + this.json);
        }
    }
    return this.jsonData;
}

InstantASPJSONProxy.prototype.objToArray = function (obj) {
    if (!obj) return new Array();
    if (!obj.length) { return new Array(obj); }
    return obj;
}

// tree view 

var instantaspTree = new Object();
var instantaspTreeIc = new Object();

function InstantASPTree(TreeID) {

    this.TreeID = TreeID;
    this.Options = new Options();
    this.Icons = new Icons();
    this.NodeList = new Object();
    this.enableIndents = false;
    this.ContextMenu = null;
    this.NodeContextMenu = new Object();
    this.TreeReference = "";
    this.RootNode = null;
    this.SelectedNode = null;
    this.Transition = null;
    this.EditId = null;
    this.NodeCount = 0;
    this.XmlHttp = null;
 
    if (instantaspTree[this.TreeID] != null) {
        return instantaspTree[this.TreeID];
    } else {
        instantaspTree[this.TreeID] = this;
    }
    return this;

}

function Icons(path) {
    if (path != undefined) {
        this.pnb = path + "Lines/TreeView_Plusnb.gif";
        this.pb = path + "Lines/TreeView_Plusb.gif";
        this.pr = path + "Lines/TreeView_Plusr.gif";
        this.mnb = path + "Lines/TreeView_Minusnb.gif";
        this.mb = path + "Lines/TreeView_Minusb.gif";
        this.mr = path + "Lines/TreeView_Minusr.gif";
        this.opf = path + "TreeView_FolderOpen.gif";
        this.clf = path + "TreeView_Folder.gif";
        this.chd = path + "TreeView_Leaf.gif";
        this.rot = path + "Lines/TreeView_Root.gif";
        this.lnb = path + "Lines/TreeView_lineInts.gif";
        this.lb = path + "Lines/TreeView_LineInts.gif";
        this.lin = path + "Lines/TreeView_Line.gif";
        this.bln = path + "Lines/TreeView_Blank.gif";
        this.spc = path + "Lines/TreeView_Spacer.gif";
        
        this.toString = function () { return "Standard Icons" };
        return this;
    }
}

function Options() {
    this.Target = "_self";
    this.Sort = "no";
    this.Icons = true;
    this.Check = false;
    this.Editable = false;
    this.SelectRow = false;
    this.EditKey = 113;
    this.EnableContext = true;
    this.OneExpand = false;
    this.OneClick = false;
    this.EnableCookie = false;
    this.ShowRoot = false;
    this.LoadingText = "Loading...";
    this.ExpandedListTextBoxID = "";
    this.SelectedNodeTextBoxID = "";
    this.TabID = 0;
    this.LiveWriteCallBackURL = "";
    this.LiveDeleteCallBackURL = "";
    this.LiveMoveUpCallBackURL = "";
    this.LiveMoveDownCallBackURL = "";
    this.LiveEditArticleCallBackURL = "";
    this.InputHiddenID = null;
    this.NodeEditURL = "";
    this.Expanded = false;
    return this;
}

function InstantASPTreeNode(NodeID, Text, Name, NavigateURL, Icon, Expanded, Checked, CallBackURL, CategoryID, Foreground, Background, Counter) {

    this.NodeID = NodeID;
    this.ID = "";
    this.Text = Text;
    this.Name = Name;
    this.NavigateURL = (NavigateURL == null || NavigateURL == "") ? "javascript:void(0)" : NavigateURL;
    this.Icon = (Icon == null || Icon == "") ? null : Icon.split(",");
    this.Expanded = Expanded == null ? false : Expanded;
    this.Checked = (Checked ? Checked : false);
    this.CallBackURL = CallBackURL == "" ? null : CallBackURL;
    this.ContextMenu = null;
    this.cstStyle = "";
    
    this.NextNode = null;
    this.PrevNode = null;
    this.FirstChild = null;
    this.LastChild = null;
    this.Foreground = (Foreground == "" || typeof Foreground == 'undefined' ? "" : Foreground);
    this.Background = (Background == "" || typeof Background == 'undefined' ? "" : Background);
    this.Counter = Counter == undefined ? 0 : Counter;
    this.ParentNode = null;
    this.LoadingOnDemand = false;
    this.CategoryID = CategoryID == undefined ? 0 : CategoryID;
    this.equals = function (nd) { return (this.ID == nd.ID); };
    return this;
}

InstantASPTree.prototype.genIntTreeID = function (id) {
    return this.TreeID + id;
}

InstantASPTree.prototype.genOrgId = function (inTreeID) {
    return inTreeID.substr(this.TreeID.length);
}

InstantASPTree.prototype.compareNode = function (aN, bN) {
    return (aN.Text >= bN.Text);
}

InstantASPTree.prototype.add = function (id, prn, capt, name, url, ic, exp, chk, callbackurl, categoryid, foreground, background, counter) {
    var nNd = new InstantASPTreeNode(((id == null || id == "") ? ("n_" + (++this.NodeCount)) : id), capt, name, url, ic, exp, chk, callbackurl, categoryid, foreground, background, counter);
    nNd.ID = this.genIntTreeID(nNd.NodeID);
    if (this.NodeList[nNd.ID] != null) { return; }
    this.NodeList[nNd.ID] = nNd;
  

    if (this.RootNode == null) {
        this.RootNode = nNd
    } else {
        var pnd = this.NodeList[this.genIntTreeID(prn)];
        if (pnd != null) {
            nNd.ParentNode = pnd;
            if (pnd.LastChild == null) {
                pnd.FirstChild = nNd;
                pnd.LastChild = nNd
            } else {
                var t = pnd.FirstChild;
                if (this.Options.Sort != "no") {
                    do {
                        if (this.Options.Sort == "asc" ? this.compareNode(t, nNd) : this.compareNode(nNd, t)) { break; }
                        t = t.NextNode;
                    }
                    while (t != null);
                    if (t != null) {
                        if (t.PrevNode == null) {
                            t.PrevNode = nNd;
                            pnd.FirstChild = nNd
                        } else {
                            nNd.PrevNode = t.PrevNode;
                            t.PrevNode.NextNode = nNd;
                            t.PrevNode = nNd;
                        }
                        nNd.NextNode = t;
                    }
                }
                if (this.Options.Sort == "no" || t == null) {
                    nNd.PrevNode = pnd.LastChild;
                    pnd.LastChild.NextNode = nNd;
                    pnd.LastChild = nNd;
                }
            }
        }
    }
    return nNd
}

InstantASPTree.prototype.addBefore = function (id, sib, capt, name, url, ic, exp, chk, callbackurl) {
    var nd = this.getNodeById(sib);
    if (nd == null) { return; }
    var nNd = new InstantASPTreeNode(((id == null || id == "") ? ("int" + (++this.NodeCount)) : id), capt, name, url, ic, exp, chk, callbackurl);
    nNd.ID = this.genIntTreeID(nNd.NodeID);
    if (this.NodeList[nNd.ID] != null) { alert("Item with id " + id + " already exist"); return; }
    this.NodeList[nNd.ID] = nNd;
    nNd.ParentNode = nd.ParentNode;
    nNd.NextNode = nd;
    if (nd.PrevNode == null) {
        nd.PrevNode = nNd;
        nd.ParentNode.FirstChild = nNd;
    } else {
        nNd.PrevNode = nd.PrevNode; nd.PrevNode.NextNode = nNd; nd.PrevNode = nNd;
    }
    return nNd
}

InstantASPTree.prototype.addAfter = function (id, sib, capt, name, url, ic, exp, chk, callbackurl) {
    var nd = this.getNodeById(sib);
    if (nd == null) { return };
    var nNd = new InstantASPTreeNode(((id == null || id == "") ? ("int" + (++this.NodeCount)) : id), capt, name, url, ic, exp, chk, callbackurl);
    nNd.ID = this.genIntTreeID(nNd.NodeID);
    if (this.NodeList[nNd.ID] != null) { alert("Item with id " + id + " already exist"); return; }
    this.NodeList[nNd.ID] = nNd;
    nNd.ParentNode = nd.ParentNode;
    nNd.PrevNode = nd;
    if (nd.NextNode == null) { nd.NextNode = nNd; nd.ParentNode.LastChild = nNd }
    else { nNd.NextNode = nd.NextNode; nd.NextNode.PrevNode = nNd; nd.NextNode = nNd }
    return nNd
}

InstantASPTree.prototype.append = function (id, prn, capt, name, url, ic, exp, chk, callbackurl) {
    var nd = this.add(id, prn, capt, name, url, ic, exp, chk, callbackurl);
    this.reloadNode(prn);
    return nd
}

InstantASPTree.prototype.remove = function (id, reload) {
    var rNd = (id != null ? this.NodeList[this.genIntTreeID(id)] : this.SelectedNode);
    if (rNd != null) {
        if (this.RootNode.equals(rNd)) { this.RootNode = null; this.NodeList = new Object(); this.SelectedNode = null; return rNd };
        if (this.SelectedNode != null) { if (rNd.equals(this.SelectedNode)) { this.SelectedNode = null; } }
        var pr = rNd.ParentNode;
        if (pr.LastChild.equals(rNd)) { pr.LastChild = rNd.PrevNode; }
        if (pr.FirstChild.equals(rNd)) { pr.FirstChild = rNd.NextNode; }
        if (rNd.PrevNode != null) { rNd.PrevNode.NextNode = rNd.NextNode; }
        if (rNd.NextNode != null) { rNd.NextNode.PrevNode = rNd.PrevNode; }
        rNd.NextNode = null; rNd.PrevNode = null; rNd.ParentNode = null;
        var treeId = this.TreeID;
        this.loopTree(rNd, function (n) { instantaspTree[treeId].NodeList[n.ID] = null });
        if (reload == null || reload) { this.reloadNode(this.genOrgId(pr.ID)); }
    }
    return rNd;
}

InstantASPTree.prototype.removeChilds = function (id, reload) {
    var rNd = (id != null ? this.NodeList[this.genIntTreeID(id)] : this.SelectedNode);
    if (rNd != null) {
        while (rNd.FirstChild) { this.remove(rNd.FirstChild.NodeID, false); }
        if (reload == null || reload) { this.reloadNode(id); }
    }
}

InstantASPTree.prototype.removeLoading = function (id) {
    var rNd = (id != null ? this.NodeList[this.genIntTreeID(id)] : this.SelectedNode);
    if (rNd != null) {
        if (rNd.FirstChild != null) {
            if (rNd.FirstChild.Text == this.Options.LoadingText) { this.remove(rNd.FirstChild.NodeID, false); }
        }
    }
}

InstantASPTree.prototype.getSelNode = function () {
    return this.SelectedNode
};

InstantASPTree.prototype.unloadChild = function (src) {
    var pr = src.ParentNode;
    if (pr.LastChild.equals(src)) pr.LastChild = src.PrevNode;
    if (pr.FirstChild.equals(src)) pr.FirstChild = src.NextNode;
    if (src.PrevNode != null) src.PrevNode.NextNode = src.NextNode;
    if (src.NextNode != null) src.NextNode.PrevNode = src.PrevNode; src.NextNode = null; src.PrevNode = null; src.ParentNode = null;
    if (this.SelectedNode) {
        var tmp = this.SelectedNode;
        while (tmp) {
            if (tmp.equals(src)) { this.SelectedNode = null; return; }
            tmp = tmp.ParentNode;
        }
    }
};

InstantASPTree.prototype.moveChild = function (src, dest, type) {
    if (!src || !dest) { return; }
    if (src.equals(dest)) { return; }
    var tmp = dest;
    while (tmp.ParentNode) {
        if (tmp.equals(src)) { return; }
        tmp = tmp.ParentNode;
    }
    switch (type) {
        case 1:
            if (src.equals(this.RootNode)) { return; }
            if (src.ParentNode.equals(dest)) { return; }
            var srcPr = src.ParentNode;
            this.unloadChild(src);
            this.reloadNode(srcPr.NodeID);
            src.ParentNode = dest;
            if (dest.LastChild == null) {
                dest.FirstChild = src;
                dest.LastChild = src;
            } else {
                var t = dest.FirstChild;
                if (this.Options.Sort != "no") {
                    do { if (this.Options.Sort == "asc" ? this.compareNode(t, src) : this.compareNode(src, t)) break; t = t.NextNode; }
                    while (t != null);
                    {
                        if (t != null) {
                            if (t.PrevNode == null) { t.PrevNode = src; dest.FirstChild = src; }
                            else { src.PrevNode = t.PrevNode; t.PrevNode.NextNode = src; t.PrevNode = src; } src.NextNode = t;
                        }
                    }
                }
                if (this.Options.Sort == "no" || t == null) {
                    src.PrevNode = dest.LastChild;
                    dest.LastChild.NextNode = src;
                    dest.LastChild = src;
                }
            }
            this.reloadNode(dest.NodeID);
            this.expandNode(dest.NodeID);
            break;
        case 2:
            if (dest.equals(this.RootNode)) { return; }
            if (src.NextNode && dest.equals(src.NextNode)) { return; }
            var srcPr = src.ParentNode;
            this.unloadChild(src);
            this.reloadNode(srcPr.NodeID);
            src.ParentNode = dest.ParentNode;
            if (dest.PrevNode == null) { dest.PrevNode = src; dest.ParentNode.FirstChild = src; }
            else { src.PrevNode = dest.PrevNode; dest.PrevNode.NextNode = src; dest.PrevNode = src; }
            src.NextNode = dest;
            this.reloadNode(dest.ParentNode.NodeID);
            break;
        case 3:
            if (dest.equals(this.RootNode)) return;
            if (src.PrevNode && dest.equals(src.PrevNode)) return;
            var srcPr = src.ParentNode;
            this.unloadChild(src);
            this.reloadNode(srcPr.NodeID);
            src.ParentNode = dest.ParentNode;
            if (dest.NextNode == null) { dest.NextNode = src; dest.ParentNode.LastChild = src; }
            else { src.NextNode = dest.NextNode; dest.NextNode.PrevNode = src; dest.NextNode = src; }
            src.PrevNode = dest;
            this.reloadNode(dest.ParentNode.NodeID);
            break;
    }
};

InstantASPTree.prototype.genANode = function (sNd) {

    var ev = "",
        st = "",
        cm = "";

    var treeName = this.TreeReference + "instantaspTree." + this.TreeID;
    var ip = (sNd.NextNode != null ? this.Icons.lb : this.Icons.lnb);
  
    var sv = treeName + ".selectNode(\"" + sNd.ID + "\");";
    var cm = treeName + ".contextMenu(event, \"" + sNd.ID + "\");";
    var cn = treeName + ".checkNode(\"" + sNd.ID + "\");";
    if (sNd.FirstChild || sNd.CallBackURL != null) {
        ev = treeName + ".ParentNodeepareToggle(\"" + sNd.ID + "\");" + treeName + ".toggleNode(\"" + sNd.ID + "\");";
        st = (sNd.NavigateURL == "javascript:void(0)" ? treeName + ".selNToggle(\"" + sNd.ID + "\");" : "");
        ip = (sNd.NextNode != null ? (sNd.Expanded ? (!this.Options.ShowRoot && sNd.ParentNode.NodeID == 1 && !sNd.PrevNode ? this.Icons.mr : this.Icons.mb) : (!this.Options.ShowRoot && sNd.ParentNode.NodeID == 1 && !sNd.PrevNode ? this.Icons.pr : this.Icons.pb)) : (sNd.Expanded ? this.Icons.mnb : this.Icons.pnb));
    } else { sNd.Expanded = false; }

    var s = "";
    s += (sNd.ParentNode == null || ip == null || ip == "" ? "" : "<img id=ip_" + sNd.ID + " src='" + ip + "' " + (sNd.FirstChild == null && sNd.CallBackURL == null ? "" : "onclick='" + ev + "' class='toggle-icon'") + " />");
    if (this.Options.Icons || sNd.equals(this.RootNode)) {

        var evl = "' onclick='" + (sNd.FirstChild && this.Options.OneClick ? st : sv) + " return " + treeName + ".treeOnClick(\"" + this.TreeID + "\",\"" + sNd.ID + "\", event);' oncontextmenu='return " + cm + "' ondblclick='" + st + " return " + treeName + ".treeOnDblClick(event)' onmouseover='" + treeName + ".treeOnMouseOver(event)' onmousemove='" + treeName + ".treeOnMouseMove(event)' onmouseout='" + treeName + ".treeOnMouseOut(event)' onmousedown='" + treeName + ".treeOnMouseDown(event)' onmouseUp='" + treeName + ".treeOnMouseUp(event)' />";              
        var icon = this.toggleNodeImage(sNd);            
        if (icon && icon.indexOf(".") >= 0) {
            s += ("<img id=\"ic_" + sNd.ID + "\" class=\"" + (sNd.PrevNove ? "tree" : "treeroot") + "\" src='" + icon + evl);
        } else {
            s += "<i class='fa " + icon + evl + "</i>";
        }
        
    }

    // don't navigate, tick check box on node selection
    s += (this.Options.Check ? "<input type='checkbox' class='check' id='cb_" + sNd.ID + "' " + (sNd.Checked ? "checked" : "") + " onclick='" + cn + treeName + ".treeOnCheck(\"" + sNd.NodeID + "\")'><label for='cb_" + sNd.ID + "'></label>" : "");
    var navigateURL = sNd.NavigateURL;
    if (this.Options.Check) {
        navigateURL = "javascript:void(0);";
        sv = treeName + ".setCheckNode(\"" + sNd.ID + "\");";
    }

    var style = "";
    if (sNd.Foreground != "") {
        style += "color:" + sNd.Foreground + ";";
    }
    if (sNd.Background != "") {
        style += "background-color:" + sNd.Background + ";";
    }


    s += "<a target=\"" + this.Options.Target + "\" href=\"" + navigateURL + "\" id='ac_" + sNd.ID + "' class='" + (sNd.FirstChild ? "prnnode" : "node") + "' onclick='" + (sNd.FirstChild && this.Options.OneClick ? st : sv) + " return " + treeName + ".treeOnClick(\"" + this.TreeID + "\",\"" + sNd.ID + "\", event);' oncontextmenu='return " + cm + "' ondblclick='" + st + " return " + treeName + ".treeOnDblClick(event)' onmouseover='" + treeName + ".treeOnMouseOver(event)' onmousemove='" + treeName + ".treeOnMouseMove(event)' onmouseout='" + treeName + ".treeOnMouseOut(event)' onmousedown='" + treeName + ".treeOnMouseDown(event)' onmouseup='" + treeName + ".treeOnMouseUp(event)'>"
    s += "<span " + (style != "" ? "style=\"" + style + "\"" : "") + " id='cstl_" + sNd.ID + "' " + (sNd.cstStyle != "" ? "class='" + sNd.cstStyle + "'" : "") + " >" + sNd.Text + "</span>"
    s += "</a>";

    var n = sNd.ParentNode;
    while (n != null && !n.equals(this.RootNode)) {
        s = "<img src='" + (n.NextNode != null ? this.Icons.lin : this.Icons.bln) + "' />" + s;
        n = n.ParentNode
    }

    if (sNd.ContextMenu && sNd.ContextMenu.mId && !this.NodeContextMenu[sNd.ContextMenu.mId])
    {
        s += sNd.ContextMenu.genMenu();
        this.NodeContextMenu[sNd.ContextMenu.mId] = sNd.ContextMenu.mId       
    }
    return s;

}

InstantASPTree.prototype.genNodes = function (sNd, incpar, wrt) {
    var s = "";
    if (!this.Options.ShowRoot && sNd.equals(this.RootNode)) { 
        s = "<ul id='ch_" + sNd.ID + "'>";
    } else if (this.Options.ShowRoot && sNd.equals(this.RootNode)) { 
        s = "<ul id='ch_" + sNd.ID + "'><li id='" + sNd.ID + "' s'>" + this.genANode(sNd) + "</li>";
    }
    else {
        s = incpar ? ("<li id='" + sNd.ID + "'>" + this.genANode(sNd) + "</li><li style='display:" + (sNd.FirstChild && sNd.Expanded ? "inline" : "none") + "; visibility:" + (sNd.FirstChild && sNd.Expanded ? "visible" : "hidden") + ";' id='ch_" + sNd.ID + "'><ul>") : "";
    }
    if (wrt) document.write(s);
    if (sNd.FirstChild != null) {
        var chNode = sNd.FirstChild;
        do {
            if (wrt) {
                this.genNodes(chNode, true, wrt);
            } else {
                s = s + this.genNodes(chNode, true, wrt);
            }
            chNode = chNode.NextNode;
        }
        while (chNode != null)
    }
    if (wrt) {
        if (incpar) document.write("</li>");
        return "";
    } else {
        s = incpar ? (s + "</li></ul>") : s + "</li>";
        return s;
    }
}

InstantASPTree.prototype.genTree = function () {
    $("body").append("<input id='ndedt" + this.TreeID + "' type='text' class='i-tree-edit' style='display:none;' value='' onblur='instantaspTree." + this.TreeID + ".liveNodeWrite()'/>");
    return this.genNodes(this.RootNode, true, false) + (this.ContextMenu ? this.ContextMenu.genMenu() : "") + (!iasp_FindControl("ddGesture") ? "<div id='ddGesture' style='display:none;' class='ddGesture'></div>" : "");
}

InstantASPTree.prototype.render = function (plc) {

    if (this.Options.Check) {
        this.populateCheckedNodes();
    }

    if (plc && plc != "") {
        var p = iasp_FindControl(plc);
        if (p != null) {
            p.innerHTML = "<div class=\"i-tree\">" + this.genTree() + "</div>";           
        }     
    } else {
        document.write("<div class=\"i-tree\">");
        this.genNodes(this.RootNode, true, true);
        document.write("<input id=\"ndedt" + this.TreeID + "\" type='text' class='nodeedit' style='display:none;' value='' onblur='instantaspTree." + this.TreeID + ".liveNodeWrite()' />" + (this.ContextMenu ? this.ContextMenu.genMenu() : "") + (!iasp_FindControl("ddGesture") ? "<div id='ddGesture' style='display:none;' class='ddGesture'></div>" : ""));
        document.write("</div>");
    }

    this.initEvent();

    if (this.Options.EnableCookie && this.getCookie) {
        var sid = this.getCookie(this.TreeID + "_selnd");
        if (sid && sid != "") { this.selectNodeById(sid); }
    }

}

InstantASPTree.prototype.initEvent = function () {
    var isIE = (navigator.userAgent.indexOf("MSIE") >= 0);
    var orgEvent = (isIE ? document.body.onkeydown : window.onkeydown);
    if (!orgEvent || orgEvent.toString().search(/orgEvent/gi) < 0) {
        var newEvent = function (e) {
            if (instantaspTree.selectedTree) { instantaspTree.selectedTree.liveNodePress(isIE ? event : e); }
            if (orgEvent) { return orgEvent(); }
        };
        if (isIE) { document.body.onkeydown = newEvent; }
        else { window.onkeydown = newEvent; }
    }
}

InstantASPTree.prototype.reloadNode = function (id) {
    var inTreeID = this.genIntTreeID(id);
    var s = this.genNodes(this.NodeList[inTreeID], false);
    var dvN = iasp_FindControl("ch_" + inTreeID);
    dvN.innerHTML = s;
    if (dvN.innerHTML == "") {
        dvN.style.display = "none";
        s = this.genANode(this.NodeList[inTreeID]);
        dvN = iasp_FindControl(inTreeID);
        dvN.innerHTML = s;
    }
    if (this.SelectedNode != null) {
        var sId = this.SelectedNode.ID;
        this.SelectedNode = null;
        this.selectNode(sId);
    }
    if (this.Options.Check) {
        this.populateCheckedNodes();
    }
}

InstantASPTree.prototype.selNToggle = function (id) {
    this.toggleNode(id);
    if (!this.SelectedNode || this.SelectedNode.ID != id) { this.selectNode(id); }
    if (this.EditId != null) { clearTimeout(this.EditId); this.EditId = null }
}

InstantASPTree.prototype.selectNode = function (id) {

    instantaspTree.selectedTree = this;
    if (this.Options.Editable) {
        if (this.SelectedNode != null && this.SelectedNode.ID != id) {
            if (this.EditId) { clearTimeout(this.EditId); this.EditId = null }
        }
        if (this.SelectedNode != null && this.SelectedNode.ID == id) {
            this.EditId = setTimeout("instantaspTree." + this.TreeID + ".liveNodeEdit('" + id + "')", 500);
        }
        if (iasp_FindControl("ndedt" + this.TreeID).style.display == "") {
            var edt = iasp_FindControl("ndedt" + this.TreeID);
            edt.style.display = "none";
            edt.disabled = true
        }
    }

    var ac = null; var ic = null; var sNd = null;
    sNd = this.SelectedNode;
    if (sNd != null) {
        if (this.Options.SelectedRow)
            iasp_FindControl(sNd.ID).className = "row";
        ac = iasp_FindControl("ac_" + sNd.ID);
        if (this.Options.Icons) {
            var ic = iasp_FindControl("ic_" + sNd.ID);
            if (ic) { ic.style.display = "none"; iasp_FindControl("ic_" + sNd.ID).style.display = "" }
        }
        if (ac) { ac.className = (sNd.FirstChild ? "prnnode" : "node"); }
    }

    sNd = this.NodeList[id];
    this.SelectedNode = sNd;
    if (this.Options.SelectRow)
        iasp_FindControl(id).className = "selected";
    ac = iasp_FindControl("ac_" + id);
    if (this.Options.Icons) {
        var ic = iasp_FindControl("ic_" + id);
        if (ic) { iasp_FindControl("ic_" + id).style.display = "none"; ic.style.display = "" }
    }

    if (ac) { ac.className = (sNd.FirstChild ? "selected-parent" : "selected"); }
    if (this.Options.EnableCookie && this.setCookie)
        this.setCookie(this.TreeID + "_selnd", sNd.NodeID);
}

InstantASPTree.prototype.selectNodeById = function (id) {

    var node = this.getNodeById(id);
    if (!node) { return };
    var tmp = node;
    while (tmp.ParentNode != null) { this.expandNode(tmp.NodeID); tmp = tmp.ParentNode }
    this.selectNode(node.ID);
}

InstantASPTree.prototype.isChild = function (c, p) {
    var nd = this.getNodeById(c);
    if (!nd) { return false };
    var tmp = nd.ParentNode;
    while (tmp != null) { if (tmp.NodeID == p) { return true; } tmp = tmp.ParentNode; }
    return false
}

InstantASPTree.prototype.hasChild = function (id) {
    var nd = this.getNodeById(id);
    return (nd.FirstChild != null);
}

InstantASPTree.prototype.expandNode = function (id) {
    var tmpTransition = null;
    var sNd = this.NodeList[this.genIntTreeID(id)];
    if (this.Transition != null) { tmpTransition = this.Transition; this.Transition = null; }
    if (!sNd.Expanded) { this.toggleNode(sNd.ID); }
    if (tmpTransition != null) { this.Transition = tmpTransition; };
}

InstantASPTree.prototype.collapseNode = function (id) {
    var sNd = this.NodeList[this.genIntTreeID(id)];
    if (this.Transition != null) { tmpTransition = this.Transition; this.Transition = null; }
    if (sNd.Expanded) { this.toggleNode(sNd.ID); }
    if (tmpTransition != null) { this.Transition = tmpTransition; };
}

InstantASPTree.prototype.ParentNodeepareToggle = function (id) {

    var sNd = this.SelectedNode;
    if (sNd == null) { this.selectNode(id); return; }
     if (sNd.ID == id) return;
    while (sNd != null && sNd.ID != id) { sNd = sNd.ParentNode; }
    if (sNd == null) { return; }
    if (sNd.ID == id) { this.selectNode(id); }

}

InstantASPTree.prototype.toggleNode = function (id) {

    var nd = iasp_FindControl("ch_" + id);
    var ip = iasp_FindControl("ip_" + id);
    var ic = iasp_FindControl("ic_" + id);

    var sNd = this.NodeList[id];
    if (sNd.Expanded) {
        sNd.Expanded = false;
        nd.style.height = '';
        if (this.Transition != null && this.Transition.CollapseSlide != 0) {
            this.Transition.CollapseDiv(nd);
        } else {
            nd.style.display = 'none';
            nd.style.visibility = 'hidden';
        }
        if (ip != null) {
            ip.src = (sNd.NextNode ? this.Icons.pb : this.Icons.pnb);
        }

        if (ic != null) { ic.src = this.toggleNodeImage(sNd); }
        this.treeOnCollapse(sNd.NodeID);
        this.treeOnResize(sNd.NodeID);

    } else {

        if (this.Options.OneExpand && sNd.ParentNode) {
            var tNd = sNd.ParentNode.FirstChild;
            while (tNd) {
                if (tNd.id != id && tNd.Expanded) {
                    this.collapseNode(tNd.NodeID);
                }
                tNd = tNd.NextNode
            }
        }
        sNd.Expanded = true;
        nd.style.height = '';
        if (this.Transition != null && this.Transition.ExpandSlide != 0) {           
            this.Transition.ExpandDiv(nd);
        } else {
            nd.style.display = 'block';
            nd.style.visibility = 'visible';
        }

        if (ip != null && (sNd.FirstChild != null || sNd.CallBackURL != null)) {
            ip.src = (sNd.NextNode ? this.Icons.mb : this.Icons.mnb);
        }

        if (ic != null) { ic.src = this.toggleNodeImage(sNd); }
        this.treeOnExpand(sNd.NodeID);
        this.treeOnResize(sNd.NodeID);
    }
}

InstantASPTree.prototype.fetchContent = function (id) {
    var sNd = this.NodeList[id];
    if (sNd != null) {
        if (sNd.LoadingOnDemand) {
            return;
        } else {
            if (sNd.CallBackURL != null && sNd.FirstChild == null) { this.populatefetchedContent(id); }
        }
    }
}

InstantASPTree.prototype.populatefetchedContent = function (id) {

    var sNd = this.NodeList[id];
    var nd = iasp_FindControl("ch_" + id);
    var arrURL = sNd.CallBackURL.split("?");
    var tree = this; // can't use this within HttpHandler method

    tree.add(null, sNd.NodeID, this.Options.LoadingText, "", "", false, false, "");
    tree.reloadNode(sNd.NodeID);
     
    if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
    var objXmlHttpHandler = function (obj) {
        sNd.LoadingOnDemand = true;
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("Node");
            if (items.length > 0) {
                tree.removeLoading(sNd.NodeID);
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    var id = nd.getAttribute("NodeID") == null ? null : nd.getAttribute("NodeID");
                    var capt = nd.getAttribute("Text") == null ? "" : nd.getAttribute("Text");
                    if (capt == "") { capt = nd.getAttribute("TextNonLocalized"); }
                    var name = nd.getAttribute("Name") == null ? "" : nd.getAttribute("Name");
                    var url = nd.getAttribute("NavigateURL") == null ? "" : nd.getAttribute("NavigateURL");
                    var icon = nd.getAttribute("ImageURL") == null ? "" : nd.getAttribute("ImageURL");
                    var expandedicon = nd.getAttribute("ExpandedImageUrl") == null ? "" : nd.getAttribute("ExpandedImageUrl");
                    if (icon != '') { expandedicon = ',' + expandedicon }
                    var expanded = nd.getAttribute("Expanded") == null ? false : nd.getAttribute("Expanded");
                    var categoryid = nd.getAttribute("ID") == null ? false : nd.getAttribute("ID");
                    var checked = nd.getAttribute("Checked") == null ? false : nd.getAttribute("Checked");
                    var callbackurl = nd.getAttribute("CallbackUrl") == null ? "" : nd.getAttribute("CallbackUrl");
                    var foreground = nd.getAttribute("ForegroundColor") == null ? "" : nd.getAttribute("ForegroundColor");
                    var background = nd.getAttribute("BackgroundColor") == null ? "" : nd.getAttribute("BackgroundColor");
                    var counter = nd.getAttribute("Counter") == null ? "" : nd.getAttribute("Counter");

                    // add node					
                    var nNd = tree.add(id, sNd.NodeID, capt, name, url, icon + expandedicon, expanded, checked, callbackurl, categoryid, foreground, background, counter);
                    nNd.ParentNode = sNd;

                }

                tree.reloadNode(sNd.NodeID);
                sNd.LoadingOnDemand = false;
                tree.treeOnResize(sNd.NodeID);

            }
        } else {
            alert("Could not retrieve data from " + sNd.CallBackURL + ", invalid response. Response received: " + obj.responseXML);
            sNd.LoadingOnDemand = false;
        }
    };

    this.XmlHttp.Connect(arrURL[0], "GET", arrURL[1], objXmlHttpHandler);
}

InstantASPTree.prototype.toggleNodeImage = function (sNd) {
    var isrc = (sNd.equals
   (this.RootNode) ? this.Icons.rot : sNd.FirstChild || sNd.CallBackURL != null ? (sNd.Expanded ? this.Icons.opf : this.Icons.clf) :
   (sNd.FirstChild ? this.Icons.opf : this.Icons.chd));

    if (sNd.Icon) { isrc = (sNd.Icon.length > 1 ? (sNd.Expanded ? sNd.Icon[1] : sNd.Icon[0]) : sNd.Icon[0]); }
    return isrc;
}

InstantASPTree.prototype.expandAll = function () {
    var treeId = this.TreeID;
    this.loopTree(this.RootNode, function (n) {
        if (n.FirstChild) {
            instantaspTree[treeId].expandNode(n.NodeID);
        }
    });
}

InstantASPTree.prototype.collapseAll = function (incPr) {
    var treeId = this.TreeID;
    this.loopTree(this.RootNode, function (n) {
        if (n.FirstChild && (!instantaspTree[treeId].RootNode.equals(n) || incPr)) {
            instantaspTree[treeId].collapseNode(n.NodeID);
        }
    });
}

InstantASPTree.prototype.checkNode = function (nodeId) {
    var nd = iasp_FindControl("cb_" + nodeId);
    var treeId = this.TreeID;
    var sNd = this.NodeList[nodeId];
    sNd.Checked = nd.checked;
    this.populateHiddenField();
}

InstantASPTree.prototype.setCheckNode = function (nodeId) {
    var nd = iasp_FindControl("cb_" + nodeId);
    var treeId = this.TreeID;
    var sNd = this.NodeList[nodeId];
    if (nd.checked) {
        sNd.Checked = false;
        nd.checked = false;
    } else {
        sNd.Checked = true;
        nd.checked = true;
    }
    this.populateHiddenField();
}

InstantASPTree.prototype.populateHiddenField = function () {

    if (this.Options.InputHiddenID == null) { return; }

    var txt = iasp_FindControl(this.Options.InputHiddenID);
    if (txt != null) {
        txt.value = '';
        this.loopTree(this.RootNode, function (n) {
            if (n.Checked && n.CategoryID != "") {
                txt.value += n.CategoryID + ",";
            }
        }
        );
    }
}

InstantASPTree.prototype.populateCheckedNodes = function () {

    if (this.Options.InputHiddenID == null) { return; }

    var txt = iasp_FindControl(this.Options.InputHiddenID);
    if (txt != null) {
        if (txt.value == "") { return; }        
        var arrIds = txt.value.split(",");
        if (arrIds.length == 0) { alert("no"); }
        this.loopTree(this.RootNode, function (n) {
            var nd = iasp_FindControl("cb_" + n.ID);
            n.Checked = false;           
            for (var i = 0; i < arrIds.length; i++) {
                if (arrIds[i] == n.CategoryID) {
                    n.Checked = true;
                    if (nd != null) {
                        nd.checked = true;
                    }
                }
            }
        }
        );

    }
}

InstantASPTree.prototype.setNodeStyle = function (id, cls, rt) {
    var nd = this.getNodeById(id); nd.cstStyle = cls;
    if (rt) {
        var oNd = iasp_FindControl("cstl_" + nd.ID);
        if (oNd) { oNd.className = cls; }
    }
}

InstantASPTree.prototype.setNodeText = function (id, Text) {
    var inTreeID = this.genIntTreeID(id);
    var nd = iasp_FindControl("ac_" + inTreeID);
    var sNd = this.NodeList[inTreeID];
    nd.innerHTML = Text;
    sNd.Text = Text;
}

InstantASPTree.prototype.getNodeById = function (id) {
    return this.NodeList[this.genIntTreeID(id)];
}

InstantASPTree.prototype.setGlobalCtxMenu = function (ctx) {
    this.ContextMenu = ctx;
    ctx.container = this;
}

InstantASPTree.prototype.setGlobalTransition = function (transition) {
    this.Transition = transition;
    transition.Container = this;
}

InstantASPTree.prototype.setNodeCtxMenu = function (id, ctx) {
    var nd = this.NodeList[this.genIntTreeID(id)];
    nd.ContextMenu = ctx;
    if (ctx.mId) { ctx.container = this; }
}

InstantASPTree.prototype.contextMenu = function (ev, id) {
    if (!this.Options.EnableContext) { return false; }
    var sNd = this.NodeList[id];
    var ctx = null;
    if (sNd.ContextMenu && sNd.ContextMenu.mId) { ctx = sNd.ContextMenu; }
    else if (sNd.ContextMenu == "DEFAULT") { ctx = null; }
    else if (sNd.ContextMenu == "NONE") { return false; }
    else { ctx = this.ContextMenu; }
    if (!ctx) { return true; }
    this.selectNode(id);
    if (this.EditId) clearTimeout(this.EditId);
    ctx.showMenu(iasp_FindControl("ac_" + sNd.ID));
    return false
}

InstantASPTree.prototype.loopTree = function (sNd, act) {
    act(sNd);
    if (sNd.FirstChild != null) {
        var chNode = sNd.FirstChild;
        do {
            this.loopTree(chNode, act);
            chNode = chNode.NextNode
        }
        while (chNode != null)
    }

}

InstantASPTree.prototype.liveNodeEditStart = function (id) {
    this.EditId = setTimeout("instantaspTree." + this.TreeID + ".liveNodeEdit('" + id + "')", 0)
}

InstantASPTree.prototype.ctx_liveAdd = function (prId, strNodeText) {
    var selNode = this.NodeList[this.genIntTreeID(prId)];
    this.expandNode(selNode.NodeID);
    var newNode = this.append("", selNode.NodeID, strNodeText, strNodeText, "", "", false);
    this.selectNode(newNode.ID);
    iasp_HideAllMenus();
    this.liveNodeEditStart(newNode.ID);
};

InstantASPTree.prototype.liveNodeEdit = function (id) {
    if (this.EditId != null) {
        var edt = iasp_FindControl("ndedt" + this.TreeID);
        var ac = iasp_FindControl("ac_" + id);
        var sp = iasp_FindControl("cstl_" + id);
        var x = 0, y = 0, elm = ac;
        while (elm.tagName != "BODY") {
            x += elm.offsetLeft;
            y += elm.offsetTop; elm = elm.offsetParent
        };
        ac.style.display = "none";       
        edt.disabled = false;
        edt.style.top = y + "px";
        edt.style.left = x + "px";
        edt.style.display = "";
        edt.focus();
        edt.value = sp.innerHTML;
        edt.select();     
        this.EditId = null
    }
}

InstantASPTree.prototype.liveNodeWrite = function () {

    var edt = iasp_FindControl("ndedt" + this.TreeID);
    if (edt.style.display == "none") { return; }
    var node = iasp_FindControl("ac_" + this.SelectedNode.ID);
    var ac = iasp_FindControl("cstl_" + this.SelectedNode.ID);
    // do we have a new value 
    if (edt.value != "") {
        ac.innerHTML = edt.value;
        this.SelectedNode.Text = edt.value;
        this.treeOnNodeWrite(this)
        edt.style.display = "none";
        node.style.display = "";
        edt.disabled = true;
        
        // refresh parent node
        if (this.SelectedNode != null) {
            if (this.SelectedNode.ParentNode != null) {
                this.SelectedNode.ParentNode.Expanded = false;
                this.toggleNode(this.SelectedNode.ParentNode.ID);
            }
        }
    }

}

InstantASPTree.prototype.liveNodePress = function (e) {
    if (!this.Options.Editable) { return; }
    if (e.keyCode == 13) {
        this.liveNodeWrite();
    } else if (e.keyCode == 27) {
        var edt = iasp_FindControl("ndedt" + this.TreeID);
        edt.style.display = "none";
        edt.disabled = true
    } else if (e.keyCode == this.Options.EditKey) {
        this.EditId = setTimeout("instantaspTree." + this.TreeID + ".liveNodeEdit('" + this.SelectedNode.ID + "')", 10);
    }
}

InstantASPTree.prototype.setCookie = function (key, value, expire) {
    document.cookie = escape(key) + "=" + escape(value) + (expire ? "; expires=" + expire : "");
}

InstantASPTree.prototype.getCookie = function (key) {
    if (document.cookie) {
        var c = document.cookie.split(";")[0].split("=");
        if (unescape(c[0]) == key) { return unescape(c[1]); }
    }
    return ""
}

InstantASPTree.prototype.getInstance = function (id) {   
    return instantaspTree[id];
}

InstantASPTree.prototype.removeCookie = function () { this.setCookie(this.TreeID + "_selnd", "-1", "Fri, 31 Dec 1999 23:59:59 GMT;"); };
InstantASPTree.prototype.treeOnClick = function (treeid, nodeid, e) { };
InstantASPTree.prototype.treeOnDblClick = function (e) { };
InstantASPTree.prototype.treeOnMouseOver = function (e) { };
InstantASPTree.prototype.treeOnMouseMove = function (e) { };
InstantASPTree.prototype.treeOnMouseOut = function (e) { };
InstantASPTree.prototype.treeOnMouseDown = function (e) { };
InstantASPTree.prototype.treeOnMouseUp = function (e) { };
InstantASPTree.prototype.treeOnCheck = function (id) { };
InstantASPTree.prototype.treeOnExpand = function (id) { };
InstantASPTree.prototype.treeOnResize = function (id) { };
InstantASPTree.prototype.treeOnCollapse = function (id) { };
InstantASPTree.prototype.treeOnNodeWrite = function (tree) { };

/* context menu */

var instantaspContextMenu = new Object();

function InstantASPContextMenuItem(key, capt, url, ico, enb) {
    this.key = key;
    this.intKey = "";
    this.capt = capt;
    this.url = (!url || url == "" ? "javascript:void(0);" : url);
    this.ico = ico;
    this.enable = (enb == null ? true : enb);
    return this;
}

function InstantASPContextMenu(mId) {
    this.lsItm = null;
    this.genMenu = genMenu;
    this.mId = mId;
    this.items = new Object();
    this.container = null;
    this.count = 0;
    this.stlprf = "";
    this.active = false;
    this.absWidth = 0;
    this.add = addItem;
    this.addSeparator = addSeparator;
    this.enableItem = enableItem;
    this.itemClick = itemClick;
    this.showMenu = showMenu;
    this.hideMenu = hideMenu;
    this.menuOnClick = null;
    this.menuOnShow = menuOnShow;

    if (instantaspContextMenu[mId] != null) {
        return instantaspContextMenu[mId];
    } else {
        instantaspContextMenu[mId] = this;
    }
    return this;

}

function itemClick(itemId) {
    if (!this.items[itemId].enable) { return; }
    var ids = itemId.split("|");
    return this.menuOnClick(this.container, this.container.SelectedNode, ids[0], ids[1]);
}

function genMenu() {

    var smenu = "";
    for (var it in this.items) {
        if (this.items[it].capt == "-") {
           // smenu += "<li class='separator'></li>";
        } else {
            smenu += "<li ";
            if (this.menuOnClick != null) {
                smenu += " onclick=\"return instantaspContextMenu." + this.mId + ".itemClick('" + it + "');\" ";
            }
            smenu += ">";
            smenu += "<a href=\"" + (this.items[it].url ? this.items[it].url : "javascript:void(0);") + "\"><span class=\"padding\">" + this.items[it].capt + "</span></a>";
            smenu += "</li>";
        }
    }
    
    smenu = "<div id=\"" + this.mId + "\" class=\"i-menu-box\"><div class=\"i-menu\"><div class=\"menu\"><ul>" + smenu + "</ul></div></div></div>";
    $("body").append($(smenu));

    return "";

}

function addItem(key, capt, url, ico, enb) {
    var intKey = this.mId + "|" + key;
    var it = new InstantASPContextMenuItem(key, capt, url, ico, enb);
    it.intKey = intKey;
    this.items[intKey] = it; this.count++
}

function addSeparator() {
    this.add("auto" + this.count, "-", "", "");
}

function showMenu(a) {
    iasp_OpnMnu(window.event, a, this.mId, '200px', null, false, true);
}

function showMenuAbs(x, y) {
    hideAllMenu();
    var ctx = iasp_FindControl(this.mId);
    ctx.style.top = y + "px";
    ctx.style.left = y + "px";
    ctx.style.display = "";
    this.active = true
}

function hideMenu() {
    var ctx = iasp_FindControl(this.mId);
    ctx.style.display = "none";
    this.active = false;
    if (this.lsItm != null) {
        setStyle(this.lsItm, "N"); this.lsItm = null;
    }
}

function hideAllMenu() {
    for (it in instantaspContextMenu) {
        if (instantaspContextMenu[it].active) { instantaspContextMenu[it].hideMenu(); }
    }
}

function enableItem(key, b) {
    var intKey = this.mId + "|" + key;
    this.items[intKey].enable = b;
    setStyle(iasp_FindControl(intKey), (b ? "N" : "D"))
}

function setStyle(it, s) {
    var suff = (s == "O" ? "over" : "");
    it.cells[0].className = "ctxsidebar" + suff;
    it.cells[1].className = "ctxitem" + suff;
    it.cells[1].childNodes[0].className = "ctxtext" + (s == "D" ? "disable" : (s == "OD" ? "overdisable" : suff));
}

function ctxItemOver(it) {
    var m = it.split("|");
    var oIt = iasp_FindControl(it);
    var li = instantaspContextMenu[m[0]].lsItm;
    if (li != null && li.intKey == it) { return; }
    if (li != null)
        setStyle(li, (instantaspContextMenu[m[0]].items[li.id].enable ? "N" : "D"));
    setStyle(oIt, (instantaspContextMenu[m[0]].items[it].enable ? "O" : "OD"));
    instantaspContextMenu[m[0]].lsItm = oIt
}

function menuOnClick(container, selNode, menuId, itemId) { }
function menuOnShow(selNode) { }

// common UI elements

var instantaspcommonui = new Object();

function InstantASPCommonUI(strImgFolder) {

    if (strImgFolder == null) { strImgFolder = ""; }
    // public properties
    this.imgFolder = strImgFolder;
    this._sfloat = null;
    if (document.all) {
        this._sfloat = "styleFloat"; //ie
    } else {
        this._sfloat = "cssFloat"; //ff
    }
    if (instantaspcommonui[strImgFolder] != null) {
        return instantaspcommonui[strImgFolder];
    } else {
        instantaspcommonui[strImgFolder] = this;
    }
    return this;
}

// build table cell

InstantASPCommonUI.prototype.buildTD = function (strClass, strWidth, strAlign, objControl, intColSpan) {
    var td = document.createElement("TD");
    if (strClass != null) { td.className = strClass; };
    if (strWidth != null) { td.style.width = strWidth; };
    if (strAlign != null) { td.align = strAlign; };
    if (intColSpan != null) { td.setAttribute('colSpan', intColSpan) };
    if (objControl != null) { td.appendChild(objControl); };
    return td;
}

InstantASPCommonUI.prototype.toggleRow = function(row, oldCss, newCss) {
    var tds = row.find("TD");
    for (i = 0; i <= tds.length; i++) {
        var td = $(tds[i]);
        td.removeClass(oldCss);
        td.addClass(newCss);
    }    
}

InstantASPCommonUI.prototype.cancelEvent = function (e) {

    e = e || window.event;
    if (!e) { return true; }
    if (e.stopPropagation) { e.stopPropagation(); }
    if (e.preventDefault) { e.preventDefault(); }
    if ($instantasp.isIE || $instantasp.isFirefox) {        
        e.cancelBubble = true;
        if (e.returnValue) {
            e.returnValue = false;
        }
    }
    return false;
}

// build select list

InstantASPCommonUI.prototype.buildSelect = function (strClass, strWidth, arrValues) {

    var objSelect = document.createElement("SELECT");
    if (strClass != null) {
        objSelect.className = strClass;
    } else {
        objSelect.className = "i-select";
    }

    if (strWidth != null) {
        objSelect.style.width = strWidth;
    }

    if (arrValues != null) {

        for (i = 0; i < arrValues.length; i++) {
            var arrValue = arrValues[i];
            var objOption = document.createElement("OPTION");
            objOption.text = arrValue[1];
            objOption.value = arrValue[2];
            this.AddOptToSelect(objSelect, objOption);
        }

    } else {

        var objOption = document.createElement("OPTION");
        objOption.text = "No data";
        objOption.value = "0";
        this.AddOptToSelect(objSelect, objOption);

    }

    return objSelect;

}

// add option to select

InstantASPCommonUI.prototype.AddOptToSelect = function (select, option) {

    if (document.all && !window.opera) {
        select.add(option);
    } else {
        select.add(option, null);
    }

}

// search textbox

InstantASPCommonUI.prototype.buildSearchTxtBox = function (txtTextBox, butSubmit, butOptions, width) {

    var div1 = document.createElement("div");
    div1.className = "input_BG";
    if (width) { div1.style.width = width; }

    var div2 = document.createElement("div");
    div2.className = "input_BGLeft";

    var div3 = document.createElement("div");
    div3.className = "input_BGContainer";

    var div4 = document.createElement("div");
    div4.className = "input_BGContainerBG";

    div1.appendChild(div2);
    div2.appendChild(div3);
    div3.appendChild(div4);

    // setup textbox

    var div5 = document.createElement("div");
    div5.className = "text-field";

    if (txtTextBox != null) {

        // catch enter button
        addEvent(txtTextBox, "keydown", function (e) {
            return catchKeyDown(butSubmit.id, e);
        });

        div5.appendChild(txtTextBox);

    }

    // setup search button

    var div6 = document.createElement("div");
    div6.className = "i-search-button";

    if (butSubmit != null) {
        var bg = document.createElement("div");
        bg.className = "btn-big-bg";       
        var icon = document.createElement("i");
        icon.className = "icon-search";
        var butSpan = document.createElement("span");
        butSpan.appendChild(bg);
        butSubmit.appendChild(icon);
        butSpan.appendChild(butSubmit);
        div6.appendChild(butSpan);
    }

    // setup show forums button

    var div7 = null;
    if (butOptions != null) {
        div7  = document.createElement("div");
        div7.id = butOptions.id  + "_smMenu";
        div7.appendChild(butOptions);        
        div7.className = "button-catfield";
    }

    // add search options to div

    div4.appendChild(div5);
    div4.appendChild(div6);

    if (div7 != null) { div4.appendChild(div7); }

    return div1;

}

InstantASPCommonUI.prototype.buildSimpleMenuLink = function (ctl) {
    
    var div = document.createElement("span");
    if (ctl != null) {
        div.setAttribute("id", ctl.id + "_smMenu");
        div.appendChild(ctl);
    }

    return div;

}

// rounded tab le

InstantASPCommonUI.prototype.buildRoundedTable = function (title, div) {
    
    var tbl = document.createElement("div");
    tbl.className = "iasp-rt";

    var header = document.createElement("div");
    header.className = "title";
    header.appendChild(document.createTextNode(title));

    var padding = document.createElement("div");
    padding.className = "padding";
    padding.appendChild(div);

    tbl.appendChild(header);
    tbl.appendChild(padding);
    
    return tbl;


    // build table
    var tbl = document.createElement("TABLE");
    tbl.style[this._sfloat] = "left";
    tbl.style.width = "100%";
    tbl.className = "rt_tbl";

    var tBody = document.createElement("TBODY");

    tbl.appendChild(tBody);

    // ---------------- top row

    var row = document.createElement("TR");

    // top left 

    var img = document.createElement("IMG");
    img.src = this.imgFolder + "Common/RoundedTable/tbl_topleft.gif";
    img.style.display = "block";

    var td1 = this.buildTD("rt_Edge", null, null, img)
    row.appendChild(td1);

    // top

    var div1 = document.createElement("DIV");
    div1.className = "hLight"
    div1.appendChild(document.createTextNode(title));

    var td2 = this.buildTD("rt_Top", null, null, div1)
    row.appendChild(td2);

    // top right 

    var img = document.createElement("IMG");
    img.src = this.imgFolder + "Common/RoundedTable/tbl_topright.gif";
    img.style.display = "block";

    var td3 = this.buildTD("rt_Edge", null, null, img)
    row.appendChild(td3);

    tBody.appendChild(row);

    // ---------------- middle row

    var row = document.createElement("TR");

    // middle left 

    var td4 = this.buildTD("rt_Left", null, null, document.createElement("DIV"))
    row.appendChild(td4);

    // create container table

    var tblContent = document.createElement("TABLE");
    tblContent.style.width = "100%";

    var tBodyContent = document.createElement("TBODY");
    tblContent.appendChild(tBodyContent);

    var rowContent = document.createElement("TR");

    var tdContent = this.buildTD(null, null, null, div)
    rowContent.appendChild(tdContent);

    tBodyContent.appendChild(rowContent);

    var td5 = this.buildTD(null, null, null, tblContent)

    row.appendChild(td5);

    // middle right  

    var td6 = this.buildTD("rt_Right", null, null, document.createElement("DIV"))
    row.appendChild(td6);

    tBody.appendChild(row);

    // ---------------- bottom row

    var row = document.createElement("TR");

    // bottom left 

    var img = document.createElement("IMG");
    img.src = this.imgFolder + "Common/RoundedTable/tbl_bottomleft.gif";

    var td7 = this.buildTD("rt_Edge", null, null, img)
    row.appendChild(td7);

    // bottom                          

    var td8 = this.buildTD("rt_Bottom", null, null, document.createElement("DIV"));
    row.appendChild(td8);

    // bottom right 

    var img = document.createElement("IMG");
    img.src = this.imgFolder + "Common/RoundedTable/tbl_bottomright.gif";

    var td9 = this.buildTD("rt_Edge", null, null, img)
    row.appendChild(td9);

    tBody.appendChild(row);

    return tbl;

}

// sort order drop down list

InstantASPCommonUI.prototype.buildSortOrderDropDown = function () {

    var arr = new Array(2);
    for (i = 0; i < arr.length; i++) {
        arr[i] = new Array(2);
    }

    arr[0][1] = "in: DESC order";
    arr[0][2] = "1";
    arr[1][1] = "in: ASC order";
    arr[1][2] = "2";

    return this.buildSelect(null, "150px", arr);

}

// records per page drop down list

InstantASPCommonUI.prototype.buildRecordsPerPageDropDown = function () {

    var arr = new Array(7);
    for (i = 0; i < arr.length; i++) {
        arr[i] = new Array(2);
    }

    arr[0][1] = iasp_PageSize.replace("[0]", "10");
    arr[0][2] = "10";
    arr[1][1] = iasp_PageSize.replace("[0]", "20");
    arr[1][2] = "20";
    arr[2][1] = iasp_PageSize.replace("[0]", "30");
    arr[2][2] = "30";
    arr[3][1] = iasp_PageSize.replace("[0]", "40");
    arr[3][2] = "40";
    arr[4][1] = iasp_PageSize.replace("[0]", "50");
    arr[4][2] = "50";
    arr[5][1] = iasp_PageSize.replace("[0]", "75");
    arr[5][2] = "75";
    arr[6][1] = iasp_PageSize.replace("[0]", "100");
    arr[6][2] = "100";

    return this.buildSelect(null, "150px", arr);

}

// search type drop down list

InstantASPCommonUI.prototype.buildSearchTypeDropDown = function () {

    var arr = new Array(3);
    for (i = 0; i < arr.length; i++) {
        arr[i] = new Array(2);
    }

    arr[0][1] = iasp_SearchUsing1;
    arr[0][2] = "1";
    arr[1][1] = iasp_SearchUsing2;
    arr[1][2] = "2";
    arr[2][1] = iasp_SearchUsing3;
    arr[2][2] = "3";

    return this.buildSelect(null, "200px", arr);

}

InstantASPCommonUI.prototype.setAttribute = function (node, attr, value) {

    if (value == null || node == null || attr == null) return;
    if (attr.toLowerCase() == "style") {
        this.setStyleAttribute(node, value);
    }
    else {
        node.setAttribute(attr, value);
    }

}

InstantASPCommonUI.prototype.setStyleAttribute = function (node, style) {

    if (style == null) return;
    var styles = style.split(";");
    var pos;
    for (var i = 0; i < styles.length; i++) {
        var attributes = styles[i].split(":");
        if (attributes.length == 2) {
            try {
                var attr = this.trim(attributes[0]);
                while ((pos = attr.search(/-/)) != -1) {
                    var strBefore = attr.substring(0, pos);
                    var strToUpperCase = attr.substring(pos + 1, pos + 2);
                    var strAfter = attr.substring(pos + 2, attr.length);
                    attr = strBefore + strToUpperCase.toUpperCase() + strAfter;
                }
                var value = this.trim(attributes[1]).toLowerCase();
                node.style[attr] = value;
            }
            catch (e) {
                alert(e);
            }
        }
    }
}

InstantASPCommonUI.prototype.trim = function (str) {
    return str.replace(/^\s*|\s*$/g, "");
}

// transitions

var fadetimer = false,
    timerloopback = 1,
    dtCurrentTime,
    instantaspTransition = new Object();

function InstantASPTransition(transitionid) {
    this.TransitionID = transitionid;
    this.ExpandSlide = 0;
    this.ExpandSlideDuration = 200;
    this.ExpandTransition = 0;
    this.ExpandTransitionDuration = 175;
    this.CollapseSlide = 0;
    this.CollapseSlideDuration = 200;
    this.CollapseTransition = 12;
    this.CollapseTransitionDuration = 175;
    this.UseFade = false;
    this.FadeIncrement = 25;
    this.Container = null;
    if (instantaspTransition[this.TransitionID] != null) {
        return instantaspTransition[this.TransitionID];
    } else {
        instantaspTransition[this.TransitionID] = this;
    }
    return this;
}

InstantASPTransition.prototype.ExpandDiv = function (obj) {

    if (obj != null) {

        obj.style.overflow = 'hidden';
        obj.style.display = '';

        if (this.ExpandSlide > 0) {
            dtCurrentTime = (new Date()).getTime();
            ExpandDivSlide(iasp_GetObjHeight(obj), this.ExpandSlideDuration, this.ExpandSlide, obj.id);
        }

        if (this.ExpandTransition > 0) {
            obj.style.filter = InitializeFilter(this.ExpandTransition, this.ExpandTransitionDuration);
            if (obj.filters && obj.filters[0]) {
                obj.style.visibility = 'hidden';
                obj.filters[0].apply();
                obj.style.visibility = 'visible';
                obj.filters[0].play();
            }
        } else {
            obj.style.visibility = 'visible'
        }

        if (this.UseFade) { doFade(obj, this.FadeIncrement); }

    }

}

InstantASPTransition.prototype.CollapseDiv = function (obj) {

    if (obj != null) {
        obj.style.overflow = 'hidden';
        if (this.CollapseSlide > 0) {
            if (this.CollapseSlide > 0) {
                dtCurrentTime = (new Date()).getTime();
                CollapseDivSlide(iasp_GetObjHeight(obj), this.CollapseSlideDuration, this.CollapseSlide, obj.id);
            }
        } else {
            obj.style.display = 'none';
        }
        if (this.UseFade) { doFade(obj, this.FadeIncrement); }
    }

}

function ExpandDivSlide(height, slideduration, slidetype, id) {


    var obj = iasp_FindControl(id);
    if (obj == null) { return; }
    var slidetimer = (new Date()).getTime() - dtCurrentTime;
    var slideincrement = InitializeSlide(slidetimer, slideduration, slidetype);
    if (slideincrement == 1) {
        obj.style.height = 'auto';
        obj.style.overflow = 'visible';      
        obj = null;
    } else {
        obj.style.height = Math.max(1, Math.floor(height * slideincrement)) + 'px';
        setTimeout('ExpandDivSlide(' + height + ',' + slideduration + ',' + slidetype + ',"' + id + '");', timerloopback);
       
    };
  

}

function CollapseDivSlide(height, slideduration, slidetype, id) {
    var obj = iasp_FindControl(id);
    var slidetimer = (new Date()).getTime() - dtCurrentTime;
    var slideincrement = InitializeSlide(slidetimer, slideduration, slidetype);
    if (slideincrement == 1) {       
        obj.style.display = 'none'; obj = null;
    } else {
        obj.style.height = Math.ceil((1 - slideincrement) * height) + 'px';
        setTimeout('CollapseDivSlide(' + height + ',' + slideduration + ',' + slidetype + ',"' + id + '");', timerloopback);
    };
}

function InitializeFilter(transition, duration) {
    var s; if (iasp_BrowserVer < 5.5) {
        if (transition = 37) { transition = parseInt(23 * Math.random()); }
        s = "revealTrans(Transition=" + transition + ",Duration=" + (duration / 1000) + ");";
    } else {
        if (transition == 37) { transition = parseInt(36 * Math.random()); }
        s = "progid:DXImageTransform.Microsoft." + GetFilter(transition);
        s = s.replace(')', 'Duration=' + (duration / 1000) + ');');
    }
    return s;
}

function InitializeSlide(slidetimer, slideduration, slidetype) {
    if (slidetype == 0 || slidetimer >= slideduration) { return 1; };
    if (slidetype == 1) { slidetimer = slideduration - slidetimer; };
    var intMod = slidetimer / slideduration;
    var intReturn;
    switch (slidetype) {
        case 1: intReturn = 1 - Math.pow(1 / 300, intMod); break;
        case 2:
        case 3: intReturn = intMod; break;
    };
    if (slidetype == 1) { intReturn = 1 - intReturn; };
    return Math.min(Math.max(0, intReturn), 1);
};

function GetFilter(transition) {
    switch (transition) {
        case 0: return "Iris(irisStyle=SQUARE,motion=in,)";
        case 1: return "Iris(irisStyle=SQUARE,motion=out,)";
        case 2: return "Iris(irisStyle=CIRCLE,motion=in,)";
        case 3: return "Iris(irisStyle=CIRCLE,motion=out,)";
        case 4: return "Wipe(GradientSize=1.0,wipeStyle=1,motion=reverse,)";
        case 5: return "Wipe(GradientSize=1.0,wipeStyle=1,motion=forward,)";
        case 6: return "Wipe(GradientSize=1.0,wipeStyle=0,motion=forward,)";
        case 7: return "Wipe(GradientSize=1.0,wipeStyle=0,motion=reverse,)";
        case 8: return "Blinds(bands=8,direction=RIGHT,)";
        case 9: return "Blinds(bands=8,direction=DOWN,)";
        case 10: return "Checkerboard(squaresX=16,squaresY=16,direction=right,)";
        case 11: return "Checkerboard(squaresX=12,squaresY=12,direction=down,)";
        case 12: return "RandomDissolve()";
        case 13: return "Barn(orientation=vertical,motion=in,)";
        case 14: return "Barn(orientation=vertical,motion=out,)";
        case 15: return "Barn(orientation=horizontal,motion=in,)";
        case 16: return "Barn(orientation=horizontal,motion=out,)";
        case 17: return "Strips(Motion=leftdown,)";
        case 18: return "Strips(Motion=leftup,)";
        case 19: return "Strips(Motion=rightdown,)";
        case 20: return "Strips(Motion=rightup,)";
        case 21: return "RandomBars(orientation=horizontal,)";
        case 22: return "RandomBars(orientation=vertical,)";
        case 23: return "Fade(overlap=.5,)";
        case 24: return "Wheel(spokes=16,)";
        case 25: return "Slide(slideStyle=hide,bands=15,)";
        case 26: return "Slide(slideStyle=swap,bands=15,)";
        case 27: return "Inset()";
        case 28: return "Pixelate(MaxSquare=15,)";
        case 29: return "Stretch(stretchStyle=hide,)";
        case 30: return "Stretch(stretchStyle=spin,)";
        case 31: return "Iris(irisStyle=cross,motion=in,)";
        case 32: return "Iris(irisStyle=cross,motion=out,)";
        case 33: return "Iris(irisStyle=plus,motion=in,)";
        case 34: return "Iris(irisStyle=plus,motion=out,)";
        case 35: return "Iris(irisStyle=star,motion=in,)";
        case 36: return "Iris(irisStyle=star,motion=out,)";
    };
    return null;
}

function doFade(obj, fadeincrement) {
    if (obj.filters != null && obj.style.filter.indexOf("alpha") == -1) {
        obj.style.filter = "alpha(opacity=0); moz-opacity:0%;"
    }
    FadeIn(obj.id, 0, fadeincrement);
}

function FadeIn(id, opac, fadeincrement) {
    obj = iasp_FindControl(id);
    if (opac <= 100) {
        opac += fadeincrement;
        if (iasp_IE4 || iasp_IE5) { obj.filters.alpha.opacity = opac; }
        if (iasp_NS6) { obj.style.MozOpacity = opac / 100; }
        fadetimer = setTimeout("FadeIn('" + id + "', " + opac + "," + fadeincrement + ");", timerloopback);
    } else {
        clearTimeout(fadetimer)
    }
}

// Json Table

var instantaspjsontables = new Array();
var instantaspjsontable = new Object();

function InstantASPJSONTable(strTableID) {

    this.TableID = strTableID;
    this.jsonproxy = null;
    this.Host = null;
    this.commonUI = null;
    this.useCols = false;
    this.noOfCols = 1;
    this.loading = false;
    this.rightToLeft = false;
    this.LayoutMode = "table"; // table / flow
    if (instantaspjsontable[this.TableID] != null) {
        return instantaspjsontable[this.TableID];
    } else {
        instantaspjsontable[this.TableID] = this;
        instantaspjsontables.push(this);
    }
    return this;

}

InstantASPJSONTable.prototype.initalize = function () {

    if (this.commonUI == null) { this.commonUI = new InstantASPCommonUI(); }

    // show loader whist we build the table
    this.showLoader();
    this.buildTable();
    this.hideLoader();
    this.isReady = true;

}

InstantASPJSONTable.prototype.buildTable = function () {

    // get table header
    var tHead = this.getTableHead();

    // rause bind data event to get data
    var data = this.BindData(this.Host);

    // add table row to header
    if (data != null) {
        if (this.OnHeaderRowAdd != null) {

            var row = this.addHeaderRow();
            var tempRow = null;

            if (tempRow != null) {
                tHead.appendChild(tempRow);
            } else {
                tHead.appendChild(row);
            }

        }
    }

    if (this.BindData != null) {

        if (this.useCols == false) {
            this.buildRowsFromData(data);
        } else {
            this.buildColsFromData(data);
        }

    }

    this.loading = false;

}

InstantASPJSONTable.prototype.buildRowsFromData = function (data) {

    var tBody = this.getTableBody();

    // are we overriding this?
    if (this.OnDataBind != null) {
        this.OnDataBind(this.Host, data, tBody)
        return;
    }

    // build our data rows
    if (data != null) {

        for (var i = 0; i < data.length; i++) {
            if (typeof data[i].Seperator == 'undefined') {

                var row = this.addRow(data[i], i);
                var tempRow = null;

                if (tempRow != null) {
                    tBody.appendChild(tempRow);
                } else {
                    if (row != null) {
                        tBody.appendChild(row);
                    }
                }

            } else {
                if (this.OnSeperatorRowAdd != null) {
                    tBody.appendChild(this.addSeperatorRow(data[i]));
                }
            }
        }

    } else {

        tBody.appendChild(this.buildNoResults());

    }

}

InstantASPJSONTable.prototype.buildColsFromData = function (data) {

    var tBody = this.getTableBody();

    // build our data rows
    if (data != null) {

        if (this.LayoutMode == "table") {

            for (var i = 0; i < data.length; i++) {
                if (i % this.noOfCols == 0) {
                    var row = document.createElement("TR");
                }
                row.appendChild(this.addCol(data[i], i));
                if (i % this.noOfCols == this.noOfCols - 1) {
                    tBody.appendChild(row)
                }
            }
            if (i % this.noOfCols != 0) {
                tBody.appendChild(row)
            }

        } else {

            // flow 
            var row = document.createElement("TR");
            var td = document.createElement("TD");
           
            for (var i = 0; i < data.length; i++) {         
                td.appendChild(this.addCol(data[i], i));             
            }

            row.appendChild(td);
            tBody.appendChild(row)

        }


    } else {
        tBody.appendChild(this.buildNoResults());
    }

}

InstantASPJSONTable.prototype.buildNoResults = function () {

    // get header columns
    var intColSpan = (this.getTableHead().getElementsByTagName("TD").length - 1);

    // cell css
    var strCssLight = "i-col-light";

    // create row
    var row = document.createElement("TR");

    // create label
    var span = document.createElement("SPAN");
    span.appendChild(document.createTextNode(iasp_NoResults));

    // create column
    var td = this.commonUI.buildTD(strCssLight, "100%", null, span, intColSpan)

    // add column to row
    row.appendChild(td);

    // update loading status
    this.loading = false;

    // return row
    return row;

}

InstantASPJSONTable.prototype.clearTable = function () {

    this.clearHeader();
    this.clearBody();

}

InstantASPJSONTable.prototype.clearHeader = function () {

    var tHead = this.getTableHead();
    var rows = tHead.getElementsByTagName("TR");

    // ensure we never remove the first row  
    for (i = rows.length - 1; i >= 1; i--) {
        tHead.removeChild(rows[i]);
    }

}

InstantASPJSONTable.prototype.clearBody = function () {

    var tBody = this.getTableBody();
    var rows = tBody.getElementsByTagName("TR");

    // ensure we never remove the first row
    for (i = rows.length - 1; i >= 1; i--) {
        tBody.removeChild(rows[i]);
    }

}

InstantASPJSONTable.prototype.showLoader = function () {

    var trLoader = this.getLoader();
    trLoader.style.display = '';

    // update loading status
    this.loading = true;

}

InstantASPJSONTable.prototype.hideLoader = function () {

    var trLoader = this.getLoader();
    trLoader.style.display = 'none';

    // update loading status
    this.loading = false;

}

InstantASPJSONTable.prototype.getTable = function () { 
    return iasp_FindControl(this.TableID);
}

InstantASPJSONTable.prototype.getTableHead = function () {
    return this.getTable().getElementsByTagName("THEAD")[0];
}

InstantASPJSONTable.prototype.getTableBody = function () {
    return this.getTable().getElementsByTagName("TBODY")[0];
}

InstantASPJSONTable.prototype.getLoader = function () {
    return this.getTableBody().getElementsByTagName("TR")[0];
}

InstantASPJSONTable.prototype.addHeaderRow = function () {
    // raise event so we can build the table tow
    return this.OnHeaderRowAdd(this.Host);
}

InstantASPJSONTable.prototype.addRow = function (data, index) {
    // raise event so we can build the table tow
    return this.OnRowAdd(this.Host, data, index);
}

InstantASPJSONTable.prototype.addSeperatorRow = function (data) {
    // raise event so we can build the table tow
    return this.OnSeperatorRowAdd(this.Host, data);
}

InstantASPJSONTable.prototype.addCol = function (data, index) {
    // raise event so we can build the table tow
    return this.OnColAdd(this.Host, data, index);
}

InstantASPJSONTable.prototype.BindData = function (host) { };
InstantASPJSONTable.prototype.OnHeaderRowAdd = function () { };
InstantASPJSONTable.prototype.OnDataBind = null // function (data) { };
InstantASPJSONTable.prototype.OnRowAdd = function (host, data, index) { };
InstantASPJSONTable.prototype.OnSeperatorRowAdd = null // function(host, data) { };
InstantASPJSONTable.prototype.OnColAdd = function (host, data, index) { };

/* ---------------*/
// popup dialogs
/* ---------------*/

var instantasp_popup = new Object();

function InstantASP_PopUp(divid) {

    this.divid = divid;
    this.$el = null;
    this.popupStatus = 0;
    this.ImgFolder = null;
    this.width = null;
    this.height = null;
    this.origWidth = null;
    this.origHeight = null;
    this.loader = null;
    this.owner = null;
    this.jqMobile = null;
    this.useFrame = false;
    this.onLoad = null;
    this.onBeforeLoad = null;    
    this.onUnload = null;
    this.onBeforeUnload = null;

    if (instantasp_popup[divid] != null) {
        return instantasp_popup[divid];
    } else {
        instantasp_popup[divid] = this;
    }
    return this;

}

InstantASP_PopUp.prototype.initialize = function () {
     
    this.$el = $("#" + this.divid);
    this.width = (this.width != null) ? this.width : null;
    this.height = (this.height != null) ? this.height : null;
     
    this.$el.removeClass("i-dialog-transition");

    if (this.width) {
        this.origWidth = this.width;
        this.$el.css({ "width": this.width });
    }
   
    if (this.height) {
        this.origHeight = this.height;
        this.$el.css({ "height": this.height });
        this.$el.find(".mb").css({ "height": this.height });
    } 
            
    this.setHozPosition(this.divid);
    this.setVertPosition(this.divid);

    if (this.loader != null) { 
        this.$el.find(".mb").html(this.loader);
    }

    this.bindClose(this.divid);

    // show popup
 
    if (this.popupStatus == 0) {

        this.popupStatus = 1;

        iasp_HideAllMenus();

        this.setDimentions(this.divid);
        this.setHozPosition(this.divid);
        this.setVertPosition(this.divid);

        if (this.height) {
            var loader = this.$el.find(".i-dialog-loader");
            loader.css({ "margin-top": Math.floor(this.$el.height() / 2) - loader.height() });
        }

        iasp_disableBody('default', null, true);
        this.$el.addClass("i-dialog-transition");
        this.$el.addClass("i-dialog-visible");
         
        window.document.body.style.overflow = "hidden";
        
    }
        
    var self = this;

    // close menus on escape key
    $(document).keydown(function (e) {
        e = (e || window.event);
        var keyCode = getKeyCode(e);
        if (e.keyCode == 27) {
            InstantASP_PopUp.prototype.hidePopup(self.divid);
            return false;
        }
    });
        
    $(window).resize(function (event) {
        self.fixUI(self.divid);
    });

    $(".i-async-dimmer").bind("click", function () {
        InstantASP_PopUp.prototype.hidePopup(self.divid);        
    });

    function getKeyCode(e) {
        if (document.all) {
            if (e != null) {
                return e.keyCode;
            } else {
                if (window.event) {
                    return event.keyCode;
                }
            }
        }
        else if (e.which) {
            return e.which;
        }
    }

}

InstantASP_PopUp.prototype.setHozPosition = function (divid) {
    var el = $("#" + divid);
    var left = Math.floor(Math.floor($(window).width() - el.outerWidth(true)) / 2);
    el.css({ "left": left });
}

InstantASP_PopUp.prototype.setVertPosition = function (divid) {
    var el = $("#" + divid);
    var top = Math.floor(Math.floor($(window).height() - el.outerHeight(true)) / 3);  
    el.css({ "top": top });
}

InstantASP_PopUp.prototype.bindClose = function (divid) { 
    $('#' + divid).find(".i-dialog-header").find(".close").bind("click", function () {
        InstantASP_PopUp.prototype.hidePopup(divid);
    });
}

InstantASP_PopUp.prototype.hidePopup = function (divid) {

    var self = this.getInstance(divid);
       
    var wrapper = $('#' + divid);
    if (wrapper.hasClass("i-dialog-visible")) {

        if (self != null) {
            if (self.onBeforeUnload != null) {
                var close = self.onBeforeUnload();
                if (!close) { return; }
                self.onBeforeUnload == null;
            }            
        }
     
        wrapper.removeClass("i-dialog-visible");
        iasp_enableBody();

        $(".i-async-dimmer").unbind("click");

        if (document.activeElement != null && typeof document.activeElement != 'unredefined') {
            document.activeElement.blur();
        }
             
        document.body.style.overflow = "auto";      
        self.popupStatus = 0;

        if (self.onUnload != null) {
            self.onUnload();
            self.onUnload = null;
        }

    }

}

InstantASP_PopUp.prototype.getInstance = function (id) {

    // get instance of current popup
    if (instantasp_popup[id] != null) {
        return instantasp_popup[id];
    } else {
        alert("Could not find an instance of the popup!");
    }

}

InstantASP_PopUp.prototype.setContent = function (header, content) {

    // add loader template
    var divid = "#" + this.divid;
    this.loader = $(divid).find(".mb").html();

    var c = null;
    if (typeof content == 'string') {

        c = "<div class=\"i-row i-body i-dialog-content\">" +
        "<header>" +
        "<div class=\"margin\">" +
        "<h5>" + header + "</h5>" +
        "<a href=\"javascript:void(0)\" onclick=\"return false\" class=\"close\" rel=\"close\">" +
        "<i class=\"fa fa-times\"></i>" +
        "</a>" +
        "</div>" +
        "</header>" +
        "<section class=\"i-col-light\"><div class=\"margin\">" + content + "</div></section></div>";

    } else if (typeof content == 'object') {
        c = content;
    }
    
    this.populate(c);

}

InstantASP_PopUp.prototype.load = function (url) {

    // load content
    var divid = "#" + this.divid;
    var self = this;

    // add loader template
    self.loader = $(divid).find(".mb").html();

    if (self.useFrame) {

        var wraooer = $(divid).find(".mb");
        var frame = wraooer.find(".i-dialog-iframe");
        if (frame.length == 0) {
            frame = $('<iframe>', {
                src: url,
                id: 'frame' + divid,
                frameborder: 0,
                className: "i-dialog-iframe",
                scrolling: 'yes'
            }).appendTo(wraooer);          
            frame.hide().css({ "width": "100%", "height": self.height + 'px' })
        }

        frame.load(function () {       
            wraooer.find(".i-dialog-loader").hide();
            frame.show();        
        });

        frame.load(function () {

            // bind close within frame
            frame.contents().find(".i-dialog-header").find(".close").bind("click", function () {
                self.hidePopup(self.divid)
            });

            // bind escape within frame
            frame.contents().find("body").keydown(function (e) {
                var keyCode = getKeyCode(e);
                e = (e || window.event);
                if (e.keyCode == 27) {
                    InstantASP_PopUp.prototype.hidePopup(self.divid);
                    return false;
                }
            });

        });

        self.bindClose(self.divid);        

    } else {
            
        $.ajax({
            url: url,
            cache: false,
            dataType: "html",
            success: function (data) {
                self.populate(data);
            }
        });
    }

    return false;

}

InstantASP_PopUp.prototype.populate = function (content) {
     
    var $body = $("#" + this.divid).find(".mb");
    if (typeof content == 'string') {
        $body.html(content);
    } else {
        $body.html(content.html());
    }    
    this.bindClose(this.divid);

}

InstantASP_PopUp.prototype.fixUI = function (divid) {

    var self = this.getInstance(divid);
    if (!self) { return; }
    if (self.popupStatus == 1) {
        self.$el.removeClass("i-dialog-transition");
        self.setDimentions(divid);        
        self.setHozPosition(divid);
        self.setVertPosition(divid);
        self.$el.addClass("i-dialog-transition");  
    }

},

InstantASP_PopUp.prototype.setDimentions = function (divid) {
    
    var popup = $("#" + divid),
        win = $(window),
        maxWidth = Math.floor(win.width()),
        maxHeight = Math.floor(win.height());

    var padding = 100;    
    padding = ((maxHeight <= 1024) ? 80 : padding);
    padding = ((maxHeight <= 768) ? 60 : padding);
    padding = ((maxHeight <= 480) ? 40 : padding);
    padding = ((maxHeight <= 360) ? 20 : padding);

    if (popup.outerWidth() >= (maxWidth - padding)) {
        popup.css({ "width": (maxWidth - padding) });
        popup.find(".mb").css({ "width": (maxWidth - padding) });
    } else {    
        if (this.origWidth != null) {       
            if (this.origWidth <= (maxWidth - padding)) {
                popup.css({ "width": this.origWidth });
                popup.find(".mb").css({ "width": this.origWidth });
            } else {
                popup.css({ "width": (maxWidth - padding) });
                popup.find(".mb").css({ "width": (maxWidth - padding) });
            }
        }           
    }

    var frame = popup.find("iframe");
    if (popup.height() >= (maxHeight - padding)) {
     
        popup.css({ "height": (maxHeight - padding) })
        popup.find(".mb").css({ "height": (maxHeight - padding) })
        if (frame.length > 0) {              
            frame.css({ "height": popup.height() });
        }
   
    } else {      
        if (this.origHeight != null) {
            if ((maxHeight - padding) >= this.origHeight) {
                popup.css({ "height": this.origHeight });
                popup.find(".mb").css({ "height": this.origHeight })
                if (frame.length > 0) {
                    frame.css({ "height": popup.height() });
                }
            } else {
                popup.css({ "height": (maxHeight - padding) });
                popup.find(".mb").css({ "height": (maxHeight - padding) })
                if (frame.length > 0) {
                    frame.css({ "height": popup.height() });
                }
            }
        }    

    }

}

// show pop up helpers

function showPopUp(a, pid, width, height, useFrame) {

    if (useFrame == null || typeof useFrame == 'undefined') {
        useFrame = false;
    }
    if (width == null || typeof width == 'undefined') {
        width = 600;
    }
    
    iasp_HideAllMenus();
       
    // initialize pop up
    var p = new InstantASP_PopUp(pid);
    p.owner = a;
    p.width = width;
    p.height = height;
    p.useFrame = useFrame;
    p.initialize();

    // do we have content to load?
    if (a.href != "") {
        if (a.href.indexOf("#") == -1 && a.href.indexOf("javascript:") == -1) {
            if (a.href.indexOf("?") >= 0) {
                p.load(a.href + "&ClientID=" + a.id);
            } else {
                p.load(a.href + "?ClientID=" + a.id);
            }
        }
    }
   
    return false;

}

function fullScreenPopUpWidth() {
    var w = Math.floor($(window).width());
    return w - 100;
}

function fullScreenPopUpHeight() {
    var h = Math.floor($(window).height()); 
    return h - 100;
}

/* ---------------*/
// helpers
/* ---------------*/

// Get a reference to an object on the client                   

function iasp_FindControl(strControlName) {
    return $instantasp.get(strControlName);
}

// XmlHttpRequest    

function iasp_XmlHttpRequest() {
    var XmlHttp, bComplete = false;
    try { XmlHttp = new ActiveXObject("Msxml2.XMLHTTP"); }
    catch (e) {
        try { XmlHttp = new ActiveXObject("Microsoft.XMLHTTP"); }
        catch (e) {
            try { XmlHttp = new XMLHttpRequest(); }
            catch (e) { XmlHttp = false; }
        }
    }
    if (!XmlHttp) return null;

    this.Connect = function (sURL, sMethod, sVars, oEvent) {
        if (!XmlHttp) return false;
        bComplete = false;
        sMethod = sMethod.toUpperCase();

        try {
            if (sMethod == "GET") {
                XmlHttp.open(sMethod, sURL + "?" + sVars, true);
                sVars = "";
            } else {
                XmlHttp.open(sMethod, sURL, true);
                XmlHttp.setRequestHeader("Method", "GET " + sURL + " HTTP/1.1");
                XmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            }
            XmlHttp.onreadystatechange = function () {
                if (XmlHttp.readyState == 4 && XmlHttp.status == 200 && !bComplete) {
                    bComplete = true; oEvent(XmlHttp);
                }
            };
            XmlHttp.send(sVars);
        } catch (e) { return false; }
        return true;
    };
    return this;
}

// ------------ panel bar

var panelBar = {
    transition: null,
    toggle: function (contentId, cookiePrefix, cookieName, bolState, groupName, a) {

        var el = iasp_FindControl(contentId);
        var icon = a;
        var collapseCss = "fa-minus-square-o";
        var expandCss = "fa-plus-square-o";
        if (a != null) {
            if ($(a).data("expandcss")) {
                expandCss = $(a).data("expandcss");
            }
            if ($(a).data("collapsecss")) {
                collapseCss = $(a).data("collapsecss");
            }
        }

        if (this.transition == null) {
            this.transition = new InstantASPTransition;
            this.transition.UseFade = false;
            this.transition.ExpandSlide = 2;
            this.transition.CollapseSlide = 2;
            this.transition.ExpandTransition = -1;
            this.transition.CollapseTransition = -1;
        }

        if (el.style.display == "none") { // expand

            // should we collapse the rest of the group
            if (groupName != "") {
                this.toggleGroup(groupName, cookiePrefix, cookieName, 0);
            }

            // display controls
            if (icon != null) { icon.className = "fa " + collapseCss; }
            $(el).slideDown("fast");

            // update cookie
            if (bolState) { iasp_UpdateCookie(contentId, false, cookiePrefix + cookieName); }
            else { iasp_UpdateCookie(contentId, true, cookiePrefix + cookieName); }

            var p = $(a).parents(".i-panel-collapsed");
            if (p.length) {
                if (p.hasClass("i-panel-collapsed")) {
                    p.removeClass("i-panel-collapsed")
                }
            }

        } else { // collapse

            // hide controls
            if (icon != null) { icon.className = "fa " + expandCss; }
            $(el).slideUp("fast");

            // update cookie
            if (bolState) { iasp_UpdateCookie(contentId, true, cookiePrefix + cookieName); }
            else { iasp_UpdateCookie(contentId, false, cookiePrefix + cookieName); }

            var p = $(a).parents(".i-panel");
            if (p.length) {
                p.addClass("i-panel-collapsed");
            }

        }
    },
    toggleGroup: function (groupName, cookiePrefix, cookieName, bolState) {
        
        if (this.transition == null) {
            this.transition = new InstantASPTransition;
            this.transition.UseFade = false;
            this.transition.ExpandTransition = -1;
            this.transition.CollapseTransition = -1;
        }

        // toggle all divs matching object name
        var elements = document.getElementsByTagName("DIV");
        for (var i = 0; i < elements.length; i++) {
            if (elements[i].id.indexOf(groupName) >= 0) {
                var ele = elements[i];
                if (bolState) {

                    if (ele.className) {
                        if (ele.className.toLowerCase().indexOf("i-panel-content-box") >= 0) {

                            $(ele).slideDown("fast");
                            if (cookieName != "") {
                                iasp_UpdateCookie(ele.id, true, cookiePrefix + cookieName);
                            }
                            var $panel = $(ele).parents(".i-panel-collapsed");
                            if ($panel.length > 0) {
                                if ($panel.hasClass("i-panel")) {
                                    $panel.removeClass("i-panel-collapsed");
                                }
                            }
                        }
                    }

                } else {

                    if (ele.className) {
                        if (ele.className.toLowerCase().indexOf("i-panel-content-box") >= 0) {

                            $(ele).slideUp("fast");


                            if (cookieName != "") {
                                iasp_UpdateCookie(ele.id, false, cookiePrefix + cookieName);
                            }
                            var $panel = $(ele).parents(".i-panel");
                            if ($panel.length > 0) {
                                if ($panel.hasClass("i-panel")) {
                                    $panel.addClass("i-panel-collapsed");
                                }
                            }
                        }
                    }


                }

            }
        }

        // change all images matching object name
        var icons = document.getElementsByTagName("i");
        for (var i = 0; i < icons.length; i++) {
            if (icons[i].id.indexOf(groupName) >= 0) {
                if (bolState)
                { icons[i].className = "fa fa-minus-square-o toggle-panel-bar"; }
                else
                { icons[i].className = "fa fa-plus-square-o toggle-panel-bar"; }
            }
        }

    }

}

// Retrieve text of an XML document element, including elements using namespaces

function iasp_GetElementTextNS(prefix, local, parentElem, index) {
    var result = "";
    if (prefix && iasp_IE4 || iasp_IE5) {
        result = parentElem.getElementsByTagName(prefix + ":" + local)[index];
    } else {
        result = parentElem.getElementsByTagName(local)[index];
    }

    if (result) {
        if (result.childNodes.length > 1) {
            return result.childNodes[1].nodeValue;
        } else {
            return result.firstChild.nodeValue;
        }
    } else {
        return "";
    }
}

// encode a string for including within a URL      

function iasp_EncodeString(s) {
    if (!s) { return ''; }
    s = s.replace(/\+/g, '%2B');
    s = s.replace(/\"/g, '%22')
    s = s.replace(/\'/g, '\'')
    s = s.replace(/&gt;+/g, "%26gt;");
    s = s.replace(/&lt;+/g, "%26lt;");
    s = s.replace(/&amp;/g, "%26");
    s = s.replace("&", "%26");
    return encodeURI(s);
}

function iasp_EscapeXML(s) {
    if (!s) { return ''; }
    s = s.replace("&", '&amp;');
    s = s.replace("'", '&apos;');
    s = s.replace('"', '&quot;');
    s = s.replace(">", '&gt;');
    s = s.replace("<", '&lt;');
    return s;
}

function iasp_ToggleVisibility(strControlName) {
    var obj = iasp_FindControl(strControlName);
    if (obj != null) {
        if (obj.style.display == "none") {
            obj.style.display = "inline";
        } else {
            obj.style.display = "none";
        }
    }
}

function iasp_HideControl(strControlName) {
    var obj = iasp_FindControl(strControlName);
    if (obj != null) {
        obj.style.display = "none";
    }
}

function iasp_ShowControl(strControlName) {
    var obj = iasp_FindControl(strControlName);
    if (obj != null) {
        obj.style.display = "";
    }
}

function hasOptions(obj) {
    if (obj != null && obj.options != null) { return true; }
    return false;
}

function addTextBoxOption(from, to, inputhidden) {
    var value = from.value;
    var options = new Object();
    if (hasOptions(to)) {
        for (var i = 0; i < to.options.length; i++) {
            options[to.options[i].value] = to.options[i].text;
        }
    }
    if (value == "") { return; }
    if (value == null || value == "undefined" || options[value] != value) {
        if (!hasOptions(to)) { var index = 0; } else { var index = to.options.length; }
        to.options[index] = new Option(value, value, false, false);
    }
    populateValueField(to, inputhidden);
    from.value = "";
    to.selectedIndex = -1;
}

function addSelectedOptions(from, to, inputhidden) {
    var options = new Object();
    if (hasOptions(to)) {
        for (var i = 0; i < to.options.length; i++) {
            options[to.options[i].value] = to.options[i].text;
        }
    }
    if (!hasOptions(from)) { return; }
    for (var i = 0; i < from.options.length; i++) {
        var o = from.options[i];
        if (o.selected) {
            if (options[o.value] == null || options[o.value] == "undefined" || options[o.value] != o.text) {
                if (!hasOptions(to)) { var index = 0; } else { var index = to.options.length; }
                to.options[index] = new Option(o.text, o.value, false, false);
            }
        }
    }

    populateValueField(to, inputhidden);
    from.selectedIndex = -1;
    to.selectedIndex = -1;

}

function removeSelectedOptions(from, inputhidden) {
    if (!hasOptions(from)) { return; }
    if (from.type == "select-one") {
        from.options[from.selectedIndex] = null;
    }
    else {
        for (var i = (from.options.length - 1); i >= 0; i--) {
            var o = from.options[i];
            if (o.selected) {
                from.options[i] = null;
            }
        }
    }
    populateValueField(from, inputhidden);
    from.selectedIndex = -1;
}

function moveOptionUp(obj, inputhidden) {
    if (!hasOptions(obj)) { return; }
    for (i = 0; i < obj.options.length; i++) {
        if (obj.options[i].selected) {
            if (i != 0 && !obj.options[i - 1].selected) {
                swapOptions(obj, i, i - 1);
                obj.options[i - 1].selected = true;
            }
        }
    }
    populateValueField(obj, inputhidden);
}

function moveOptionDown(obj, inputhidden) {
    if (!hasOptions(obj)) { return; }
    for (i = obj.options.length - 1; i >= 0; i--) {
        if (obj.options[i].selected) {
            if (i != (obj.options.length - 1) && !obj.options[i + 1].selected) {
                swapOptions(obj, i, i + 1);
                obj.options[i + 1].selected = true;
            }
        }
    }
    populateValueField(obj, inputhidden);
}

function swapOptions(obj, i, j) {
    var o = obj.options;
    var i_selected = o[i].selected;
    var j_selected = o[j].selected;
    var temp = new Option(o[i].text, o[i].value, o[i].defaultSelected, o[i].selected);
    var temp2 = new Option(o[j].text, o[j].value, o[j].defaultSelected, o[j].selected);
    o[i] = temp2; o[j] = temp;
    o[i].selected = j_selected;
    o[j].selected = i_selected;
}

function populateValueField(obj, inputhidden) {

    if (!hasOptions(obj)) { return; }
    var strValues = "";
    for (i = 0; i < obj.options.length; i++) {
        strValues = strValues + obj.options[i].value + ",";
    }
    inputhidden.value = strValues;

}

function iasp_Bookmark(bmurl, bmtitle) {

    if (window.sidebar) {
        window.sidebar.addPanel(bmtitle, bmurl, "");
    } else if (document.all) {
        window.external.AddFavorite(bmurl, bmtitle);
    } else if (window.opera && window.print) {
        return true;
    }
}

// catch enter key for forms

function catchKeyDown(butSubmitID, e) {

    if (butSubmitID == null || butSubmitID == "") {
        return false
    }

    disableFormSubmit();

    var keyCode = getKeyCode(e);
    if (keyCode && keyCode == 13) {
        if (butSubmitID != null) {
            var but = iasp_FindControl(butSubmitID);
            if (but != null) {
                but.click();
            }
        }
        return false;
    } else {
        return true;
    }

}

// disable form submitting for mozilla

function disableFormSubmit() {
    var frm = document.forms[0];
    if (frm) {
        frm.onsubmit = function () { return false };
    }
}

function enableFormSubmit() {
    var frm = document.forms[0];
    if (frm) {
        frm.onsubmit = function () { return true };
    }
}

// get keycode to catch carriage returns

function getKeyCode(e) {

    if (iasp_IsIE) {

        if (e != null) {
            return e.keyCode;
        } else {
            if (window.event) {
                return event.keyCode;
            }
        }

    }
    else if (e.which) {
        return e.which;
    }
}

// global add / bind event method

function addEvent(obj, evType, fn) {

    if (obj.addEventListener) {
        obj.addEventListener(evType, fn, false);
        return false;
    } else if (obj.attachEvent) {
        var r = obj.attachEvent("on" + evType, fn);       
        return r;
    } else {
        return false;
    }
}

// scrollTo method

function iasp_scrollToDiv(divid) {

    var to = $("#" + divid);
    if (to.length > 0) {
        $('html, body').stop().animate({
            scrollTop: (to.offset().top - 10)
        }, 500, 'easeInOutExpo');

    }

    return;

    // removed, but left in to easily revert
    var div = iasp_FindControl(divid);
    if (div != null) {
        if (div.offsetTop > 16) {
            window.scroll(0, if_absOffset(div) - 16);
        } else {
            window.scroll(0, 0);
        }
    }
    
}

// clear textbox default value and reset if nothing is entered

function clearTxt(txt, defaultVal, clear) {

    if (txt.tagName != "INPUT") { return; };
    var strDefaultVal = "";
    if (defaultVal != null) { strDefaultVal = defaultVal; }
    if (!clear) { clear = false; }
    if (txt != null) {
        if (clear) {
            if (txt.value == strDefaultVal) {
                txt.value = "";
            }
        } else {
            if (txt.value == "") {
                txt.value = strDefaultVal;
            }
        }

    }

    return false;
}

function resetTextbox(txt, defaultVal) {
    var strDefaultVal = "";
    if (defaultVal != null) { strDefaultVal = defaultVal; }
}

// used for controls implementing IScriptControl interface

function refreshControl(controlID, pageIndex, pageIndexChange) {

    var pIndex = 1;
    if (pageIndexChange == null) { pageIndexChange = false; }
    if (pageIndex != null) {
        if (pageIndex != "" && IsNumeric(pageIndex)) {
            pIndex = pageIndex;
        } else {
            pIndex = 1;
        }
        iasp_HideAllMenus();
    }

    var ctl = $find(controlID);
    if (ctl != null) {
        if (pageIndexChange) {
            ctl.pageIndexChanged(pIndex);
        } else {
            ctl.fetchData(pIndex);
        }
    }
}

function updateControl(id, action) {

    var ctl = $find(id);
    if (ctl != null) {
        ctl.updateControl(action);
    }

    iasp_HideAllMenus();

}

// check to see if a string is numbers only
function IsNumeric(sText) {

    if (sText == "" || sText == null) { return false; }
    var ValidChars = "0123456789";
    var IsNumber = true;
    var Char;
    for (i = 0; i < sText.length && IsNumber == true; i++) {
        Char = sText.charAt(i);
        if (ValidChars.indexOf(Char) == -1) {
            IsNumber = false;
        }
    }

    return IsNumber;
}

// add commas to numbers
function formatNum(nStr) {
    nStr += '';
    x = nStr.split('.');
    x1 = x[0];
    x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + ',' + '$2');
    }
    return x1 + x2;
}

// filter a string and return only numbers
function tidyInt(sInt) {

    var ValidChars = "0123456789";
    var news = "";
    var Char;
    if (sInt != null) {
        for (i = 0; i < sInt.length; i++) {
            Char = sInt.charAt(i);
            if (ValidChars.indexOf(Char) >= 0) {
                news += Char;
            }
        }
    }

    return news;
}

// select all checkboxes
function checkAll(ckbId, checked) {
     
    var form = document.forms[0];
    for (var i = 0; i < form.length; i++) {
        var ckb = form.elements[i];
        if (ckb.type == 'checkbox' && ckb.id.indexOf(ckbId) >= 0) {     
            if (checked) {
                ckb.checked = true;
            } else {
                ckb.checked = false;
            }
        }
    }
}

// convert array to xml
function ObjToXml(obj, d) {

    d = (d) ? d : 0;
    var rString = "\n", pad = "";
    for (var i = 0; i < d; i++) {
        pad += " ";
    }

    if (typeof obj == "object") {
        if (obj.constructor.toString().indexOf("Array") !== -1) {
            for (i = 0; i < obj.length; i++) {
                if (obj[i] != null && obj[i] != "") {
                    rString += pad + "<item>" + obj[i] + "</item>\n";
                }
            }
            rString = rString.substr(0, rString.length - 1);
        } else {

            for (i in obj) {
                if (obj[i] != null) {
                    var val = ObjToXml(obj[i], d + 1);
                    if (val == null) {
                        rString = "";
                    } else {
                        rString += ((rString === "\n") ? "" : "\n") + pad + "<" + i + ">" + val + ((typeof obj[i] === "object") ? "\n" + pad : "") + "</" + i + ">";
                    }
                }
            }
        }
    }
    else if (typeof obj == "string") {
        rString = iasp_EscapeXML(obj);
    }
    else if (typeof obj == "number") {
        rString = obj.toString();
    }
    else if (obj.toString) {
        rString = obj.toString();
    }
    else {
        return false;
    }

    return rString;

}

// convert JSON string to XML
function JsonToXml(json) {
    return eval("ObjToXml(" + json + ");");
}

function clickElement(elementid) {
    var e = iasp_FindControl(elementid);
    if (e != null) {
        if (document.createEvent) {
            var evObj = document.createEvent('MouseEvents');
            evObj.initEvent('click', true, true);
            e.dispatchEvent(evObj);            
            return false;
        }
        else if (document.createEventObject) {
            e.fireEvent('onclick');          
            return false;
        }
        else {
            e.click();
            return false;
        }
    }
}

// create json dates from sort able date time pattern

function dateFromJSON(s) {
    if (s != null) {
        if (s.indexOf("/Date") != -1) {
            return eval(s.replace(/\/Date\((\d+)\)\//gi, "new Date($1)"));
        }
    }
    return null;
}

function decodeJSON(s) {
    if (s != null) {
        s = s.replace(/\\"/gi, '"');
        s = s.replace("\\\/", "\/");
        s = s.replace(/\\\//gi, '/');
        s = s.replace(/\\u0027/gi, "'");
        s = s.replace(/\\u0009/gi, " ");
    }
    return s;
}

/* show client side alert for various app notifications */

function iasp_showAlert(iconCss, text, width, css, showfor) {

    // checks
    text = text || "";
    width = width || '100%';
    css = css || 'i-notify i-notify-primary';
    showfor = showfor || 10000;

    if (text == "") { return; }
    if (typeof width == "string") { width = width.indexOf("%") ? '' : width + 'px'; }

    // create alert html
    var s = "<div class=\"" + css + "\"><div>"
    s += (iconCss ? "<i class=\"" + iconCss + "\"></i>" : "");
    s += text
    s += "</div></div>"

    // create and add to dom
    var $alert = $(s)
    $("body").append($alert)

    // show alert
    $.blockUI({
        message: $alert,
        fadeIn: 0,
        fadeOut: 700,
        timeout: showfor,
        showOverlay: false,
        centerY: false,
        centerX: true,
        css: {
            width: width,
            top: '5px',
            zIndex: 999999,
            border: 'none',
            '-webkit-border-radius': '10px',
            '-moz-border-radius': '10px',
            opacity: .9
        }

    });

}

/* asides */

var asides = {
    show: function (a, onBeforeShow, onAfterShow) {

        iasp_HideAllMenus();

        if (onBeforeShow) {
            onBeforeShow();
        }

        var selector = "";
        if (typeof a == "string") {
            selector = a;
        } else {
            selector = $(a).attr("href");
        }

        var menu = $(selector);
        menu.find(".i-asides-header").find(".close").click(function () {            
            asides.hide();
        });
        if (menu.hasClass("i-asides-right")) {
            this.showRight(selector);
        } else {
            this.showLeft(selector);
        }
        this.showDimmer();
        if (onAfterShow) {
            onAfterShow();
        }
    },
    hide: function () {
        this.hideLeft();
        this.hideRight();
        this.hideDimmer();
    },
    showDimmer: function () {
        var $dimmer = $(".i-asides-dimmer");
        if ($dimmer.length == 0) {
            $dimmer = $('<div class="i-asides-dimmer"></div>');
            $dimmer.on('click', function () {
                asides.hide();
            });
            $("body").append($dimmer)
        }
        $dimmer.addClass("i-asides-dimmer-visible")
    },
    hideDimmer: function () {
        var $dimmer = $(".i-asides-dimmer");
        $dimmer.removeClass("i-asides-dimmer-visible")
    },
    showLeft: function (selector) {
        var menu = $(selector);
        if (!menu.hasClass("i-asides-visible")) {
            menu.addClass("i-asides-visible").addClass(" i-asides-visible-left");
        }
    },
    showRight: function (selector) {
        var menu = $(selector);
        if (!menu.hasClass("i-asides-visible")) {
            menu.addClass("i-asides-visible").addClass(" i-asides-visible-right");
        }
    },
    hideLeft: function () {
        $(".i-asides").removeClass("i-asides-visible").removeClass(" i-asides-visible-left");
    },
    hideRight: function () {
        $(".i-asides-right").removeClass("i-asides-visible").removeClass(" i-asides-visible-right");
    }
};

/* ----------------------------------- */
/* new for 2013 */
/* ----------------------------------- */

var slideOutBar = {
    css: "slideout-right",
    enableAjax: false,
    position: null,
    bar: null,
    popup: null,
    mainContent: null,
    loader: null,
    close: null,
    buttonWraooer: null,
    button: null,
    content: null,
    callbackUrl: null,
    isOpen: false,
    isLoaded: false,
    init: function (css, callbackUrl, enableAjax) {
                
        this.css = css;
        this.position = css.split("-")[1];
        this.enableAjax = enableAjax;
        this.callbackUrl = callbackUrl;            
        this.bar = $("." + css);
        this.wrapper = $(".so-wrapper");
        this.popupcontent = $(".so-content");
        this.loader = $(".so-loader");
        this.close = $(".close");
        this.buttonWraooer = $(".button-wrapper");
        this.button = $(".button a");
        this.mainContent = $(".main-content");                      
      
        this.bar.fadeIn("fast");

        this.button.bind("click", function () {
            slideOutBar.show();
        });
        this.button.bind("mouseenter", function () {
            iasp_ShowToolTip($(this));
        });
        this.button.bind("mouseleave", function () {
            iasp_HideToolTip($(this));
        });
        this.close.bind("click", function () {
            slideOutBar.hide();
        });
    },
    buildLoader: function () {
        var div = $('<div class="bubblingG">')
        div.html('<span id="bubblingG_1"></span><span id="bubblingG_2"></span><span id="bubblingG_3"></span> ');
        return div;
    },  
    show: function(fn) {

        this.wrapper.show()
        var height = this.wrapper.height();
        var width = this.wrapper.width();
        this.button.hide();
        this.loader.show();

        switch (this.position) {
            case "top":
                this.wrapper.css({ "margin-top": (-height) + "px" });
            case "bottom":
                this.wrapper.css({ "margin-bottom": (-height) + "px" });
            case "right":
                this.wrapper.css({ "margin-right": (-width) + "px" });
        }
       

        var self = this;

        switch (this.position) {
            case "top":
                this.wrapper.animate({ "margin-top": 0 }, { duration: 300 });
                $("#contentWrapper").animate({ "margin-top": height }, { duration: 300, complete: function () { load(self) } });
            case "bottom":
                this.wrapper.animate({ "margin-bottom": 0 }, { duration: 0, complete: function () { load(self) } });
            case "right":
                this.wrapper.animate({ "margin-right": 0 }, { duration: 0, complete: function () { load(self) } });
        }

        this.wrapper.show();
    
        function load(self) {
            if (self.isLoaded == false) {              
                self.isLoaded = true;                
                if (!self.enableAjax) {
                    var f = $('<iframe>', {
                        src: this.callbackUrl,
                        id: 'fbb-iframe',
                        frameborder: 0,
                        scrolling: 'no'
                    }).appendTo(this.mainContent);
                    $('#fbb-iframe').load(function () {
                        f.fadeIn("fast");
                        self.isLoaded = true;
                    });
                    self.loader.fadeOut("fast");
                    self.mainContent.fadeIn("fast");
                } else {
                    //alert(self.callbackUrl)
                    $.ajax({
                        url: self.callbackUrl,
                        cache: false,
                        dataType: "html",
                        async: true,
                        success: function (data) {
                            self.mainContent.html(data);
                            self.loader.fadeOut("fast");
                            self.mainContent.fadeIn("fast");
                            $(".i-notify").hide();                            
                            if (fn != null) { eval(fn()); }
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            jAjax.handleCallBackError(xhr, thrownError);
                            if (fn != null) { eval(fn()); }
                        }
                    });
                }
            }
                   

        }
            
        this.isOpen = true;
    },
    hide: function (fn) {
        var height = this.wrapper.height();
        this.isOpen = false;
        this.isLoaded = false;
        switch (this.position) {
            case "top":
                $("#contentWrapper").animate({ "margin-top": 0 }, { duration: 300 });
                this.wrapper.animate({ "margin-top": (-height) + "px" }, {
                    duration: 300,
                    complete: function () {
                        slideOutBar.button.show();
                        slideOutBar.wrapper.hide();
                        slideOutBar.mainContent.html("<div class=\"so-loader\"></div>");
                        slideOutBar.loader.show();
                        if (fn != null) {
                            eval(fn());
                        }
                    }
                });
                break;
            case "bottom":
                this.wrapper.animate({ "margin-bottom": (-height) + "px" }, {
                    duration: 300,
                    complete: function () {
                        slideOutBar.button.fadeIn("fast");
                        slideOutBar.wrapper.hide();
                        slideOutBar.mainContent.html("<div class=\"so-loader\"></div>");
                        slideOutBar.loader.show();
                        if (fn != null) {
                            eval(fn);
                        }
                    }
                });
        }
      
    }
};

/******** ajax based menus ********/

var instantaspmenu = new Object();

function InstantASPMenu(id) {

    this.id = id;
    this.mnuid = null;
    this.imgFolder = null;
    this.$mnu = null;
    this.$caller = null;

    if (instantaspmenu[id] != null) {
        return instantaspmenu[id];
    } else {
        instantaspmenu[id] = this;
    }
    return this;

}

InstantASPMenu.prototype.initialize = function () { }

InstantASPMenu.prototype.showMenu = function (a, width, height, populateEvent, clickEvent, hideall) {

    // set option click event handler
    this.$caller = $(a);
    this.OnMenuOptionClick = clickEvent;
    this.OnPopulate = populateEvent;
    this.OnMenuClick = null;

    // setup unique name for our menu
    this.mnuid = new Date().getTime() + "_smMenu";

    // create menu
    this.$mnu = document.createElement("DIV");
    this.$mnu.id = this.mnuid;
    this.$mnu.className = "i-menu-box "
    this.$mnu.style.display = "none";

    // scroller
    var scroller = document.createElement("DIV");
    scroller.className = "sm_Scroller";

    // container
    var content = document.createElement("DIV");
    content.className = "sm_Menu";

    // add loader
    var loader = document.createElement("DIV");
    loader.className = "loading";
    loader.appendChild(document.createTextNode("Loading..."));

    content.appendChild(loader);
    scroller.appendChild(content)
    this.$mnu.appendChild(scroller);

    // add to dom
    if ($(a).parent("DIV").length = 1) {
        // if we have a tooltip add outside of tooltip
        $(a).parent("DIV").after(this.$mnu);
    } else {
        $(a).after(this.$mnu);
    }

      // show menu
    iasp_OpnMnu(window.event, a, this.$mnu.id, width + 'px', null, false, hideall);

    // raise populate menu
    this.OnPopulate(this.id, this.mnuid, a.href)

    return false;

}

/* menu helpers */

InstantASPMenu.prototype.select = function (id, selectids) {

    var self = InstantASPMenu.prototype.getInstance(id);
    if (selectids != null) {
        var arrids = selectids.split(",");
        for (var i = 0; i < arrids.length; i++) {
            var id = arrids[i];
            if (IsNumeric(id)) {
                var img = $('#' + self.mnuid + "_img" + id);
                if (img.length > 0) {
                    img.attr('src', self.imgFolder + "Misc_MnuTick.gif");   
                }
            }
        }

    }
    
}

InstantASPMenu.prototype.selectedText = function (id, selectids, format) {

    var s = ""
    format = (format == null) ? true : format;
    var self = InstantASPMenu.prototype.getInstance(id);
    if (selectids != null) {
        var arrids = selectids.split(",");
        for (var i = 0; i < arrids.length; i++) {
            var id = arrids[i];
            if (IsNumeric(id)) {
                var a = $('#' + self.mnuid + "_hyp" + id);
                var c = $('#' + self.mnuid + "_col" + id);
                if (a.length > 0) {
                    if (format) { s += "<div class=\"tLabel\""; }
                    if (c.length > 0 && format) {
                        if (c.css("color") != "" || c.css("background-color") != "") {                           
                            s += " style=\"";
                            if (c.css("color") != "") { s += "color: " + c.css("color") + "; "; }
                            if (c.css("background-color") != "") { s += "background-color: " + c.css("background-color") + ";"; }
                            s += "\""
                        }
                    }                
                    var split = (a.attr("data-name") != "") ? split = a.attr("data-name") : split = a.text();
                    if (format) {                    
                        var arr = split.split("/")
                        s += "><div class=\"left\">";
                        s += arr[arr.length - 1]
                    } else {
                        s += split;
                    }
                    if (format) {
                        s += "</div></div>";
                    } else {
                        s += ",";
                    }
                }
            }
        }

    }
    if (!format) {
        if (endsWith(s, ",")) { s = s.trimEnd(); }
    }
    return s;

}

InstantASPMenu.prototype.selectedIDs = function (id) {

    var s = ""
    var self = InstantASPMenu.prototype.getInstance(id);
    $(self.$mnu).each(function () {
        var mnu = $(this);
        var items = mnu.find("LI")
        if (items.length >= 1) {
            items.each(function () {
                var img = $(this).find(".sm_MenuImg");
                if (img.length > 0) {
                    if (img.attr('src').toLowerCase().indexOf("misc_mnutick.gif") >= 0) {
                        s += img.attr("data-id") + ",";
                    }
                }
            });
        }
    });

    if (endsWith(s, ",")) { s = s.trimEnd(); }
    return s;

}

InstantASPMenu.prototype.populateMenu = function (id, mnuid, url, urlargs, selectedids) {

    var mnu = $('#' + mnuid);
    var scroller = mnu.find(".sm_Scroller");
    var contents = mnu.find(".sm_Menu");
    var loader = mnu.find(".loading");
    var self = InstantASPMenu.prototype.getInstance(id);

    // raise menu click event
    if (self.OnMenuClick != null) {
        self.OnMenuClick(id);
    }

    // populate
    if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("Node");
            if (items.length > 0) {
                // create menu items    
                var ul = $("<ul>");
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    var li = InstantASPMenu.prototype.buildMenuOption(id, mnuid, nd)
                    ul.append(li);
                }
                contents.append(ul);
                // hide loader                  
                if (loader.length > 0) {
                    loader.css({ 'display': 'none' });
                }
                // set menu height
                InstantASPMenu.prototype.setMenuHeight(scroller, 300);
                // do we have selected IDs
                if (selectedids != null) {
                    InstantASPMenu.prototype.select(id, selectedids);
                }
                self.OnMenuLoad(id);
            } else {
                loader.text("No data could be retrieved...");
            }

        } else {
            loader.text("No data could be retrieved...");
        }
    };

    var arrURL = url.split("?");
    var params = arrURL[1];
    if (urlargs != null) { params += urlargs; }
    this.XmlHttp.Connect(arrURL[0], "GET", params, objXmlHttpHandler);

}

InstantASPMenu.prototype.buildMenuOption = function (id, mnuid, nd) {

    var self = InstantASPMenu.prototype.getInstance(id);
    var id = nd.getAttribute("ID") == null ? null : parseInt(nd.getAttribute("ID"));
    var text1 = nd.getAttribute("Text") == null ? "" : decodeURIComponent(nd.getAttribute("Text"));
    var text2 = nd.getAttribute("TextNonLocalized") == null ? "" : decodeURIComponent(nd.getAttribute("TextNonLocalized"));
    var name = nd.getAttribute("Name") == null ? "" : decodeURIComponent(nd.getAttribute("Name"));
    var bgcolor = nd.getAttribute("BackgroundColor") == null ? "" : decodeURIComponent(nd.getAttribute("BackgroundColor"));
    var fgcolor = nd.getAttribute("ForegroundColor") == null ? "" : decodeURIComponent(nd.getAttribute("ForegroundColor"));
    var selected = nd.getAttribute("Selected") == null ? false : nd.getAttribute("Selected");
    var text = (text1 != "") ? text1 : text2;
    var li = null;

    if (id > 0) {

        var img = document.createElement("IMG");
        img.id = self.mnuid + "_img" + id;
        img.className = "sm_MenuImg";
        img.style.verticalAlign = "middle";
        img.style.marginRight = "6px";
        img.setAttribute("data-id", id)
        if (selected) {
            img.src = self.imgFolder + "Misc_MnuTick.gif";
        } else {
            img.src = self.imgFolder + "Misc_MnuSpacer.gif";
        }

        var color = document.createElement("span");
        color.id = self.mnuid + "_col" + id;
        color.className = "colorBlock"
        color.style.color = fgcolor;
        color.style.background = bgcolor;
        color.appendChild(document.createTextNode(" "));

        var hyp = document.createElement("A");
        hyp.id = self.mnuid + "_hyp" + id;
        hyp.setAttribute('href', 'javascript:void(0);');
        hyp.setAttribute('onclick', 'return InstantASPMenu.prototype.clickMenu(\'' + self.id + '\',\'' + self.mnuid + '\', \'' + id + '\');');
        if (name != null) {
            hyp.setAttribute('data-name', name);
        }

        hyp.appendChild(img);
        if (fgcolor != "" || bgcolor != "") {
            hyp.appendChild(color);
        }
        hyp.appendChild(document.createTextNode(text));


        li = $("<li></li>");
        li.append(hyp);

    } else {

        if (id == -1) { // header

            var span = document.createElement("SPAN");
            span.appendChild(document.createTextNode(text));
            span.className = "title";

            li = $("<li></li>");
            li.append(span);

        } else if (id == -2) { // seperator

            var span = document.createElement("SPAN");
            span.appendChild(document.createTextNode(" "));
            span.className = "seperator";

            li = $("<li></li>");
            li.append(span);

        }

    }

    return li

}

/* click menu option, update tick and raise MenuClick event */
InstantASPMenu.prototype.clickMenu = function (id, mnuid, optionid) {

    var self = InstantASPMenu.prototype.getInstance(id);

    // update selection tick image
    var on = false;
    var img = iasp_FindControl(mnuid + "_img" + optionid);
    if (img != null) {
        if (img.src.toLowerCase().indexOf('misc_mnuspacer') >= 0) {
            img.src = self.imgFolder + "Misc_MnuTick.gif";
            on = true;
        } else {
            img.src = self.imgFolder + "Misc_MnuSpacer.gif";
        }
    }

    // rause our click event passed in through the caller
    return self.OnMenuOptionClick(id, optionid, on);

}

InstantASPMenu.prototype.getInstance = function (mnuid) {
    return instantaspmenu[mnuid];
}

InstantASPMenu.prototype.keepMenuVisible = function () {

    // ensure menu is visible
    var mnu = this.getMenu();
    mnu.style.display = "";

    // set page level variables for menu tracking
    iasp_MenusActive = true;
    iasp_MenuItems[iasp_MenuItems.length] = mnu.id;


}

InstantASPMenu.prototype.hideMenu = function (id) {
    iasp_HideAllMenus();
}

// ensure menus are set to correct height after ajax callback */
InstantASPMenu.prototype.setMenuHeight = function (div, height) {

    // div = sm_Scroller
    var wrapper = $(div).parent("DIV"); // sm_Container
    var inner = $(div).find(".sm_Menu"); // sm_Menu
    
    if (div.height() > height) {
        // accommodate for padding in scroller 
        div.css({ 'height': height, 'padding-bottom': '8px' });
        wrapper.css({ 'padding': '0px' });
        inner.css({ 'padding': '6px', 'width': inner.width() - 45 });
        // add scroller
        div.jScrollPane({ scrollbarWidth: 15, scrollbarMargin: 10 });
    } else {
        alert( inner.width());
        // accommodate for padding without scrroller
        inner.css({ 'width': inner.width() - 20 });
    }


}

InstantASPMenu.prototype.getMenu = function () {
    return iasp_FindControl(this.mnuid)
}

InstantASPMenu.prototype.OnPopulate = function (id, mnuid, url) { };
InstantASPMenu.prototype.OnMenuClick = function (id) { };
InstantASPMenu.prototype.OnMenuOptionClick = function (id, optionid, on) { };
InstantASPMenu.prototype.OnMenuLoad = function (id) { };

/* jQuery AJAX helpers */

var jAjax = {
    xhr: null,
    loadPanel: function (pnl, url, params, func) {
        $.ajax({
            url: url,
            type: "POST",
            cache: false,
            data: params,
            dataType: "html",
            async: true,
            success: function (data) {
                pnl.html(data);
                if (func != null) { eval(func()); }
            },
            error: function (xhr, ajaxOptions, thrownError) {
                this.handleCallBackError(xhr, thrownError);
            }

        });

    },
    handleScriptControlCallBackError: function (error, control) {

        if (error == null || typeof error == 'undefined') { return; }
        if (error.get_statusCode() == 0) { return; }

        var s = "The control with the identity \"" + control + "\" encountered an exception.\n\n";
        s += "Exception: "
        if (error.get_message() != null) {
            s += error.get_message();
        } else {
            s += "No exception details!";
        }
        s += "\n\URI: " + window.location + "\n\n";
        s += "Please try to refresh the web page. If this problem continues please contact InstantASP and include a copy of this error message.";
        error.responseText = s
        this.xhr = error,
        iasp_showAlert(null, "Sorry there was a problem. <a href=\"javascript:void(0)\" onclick=\"return jAjax.detailedCallBackError();\">View Details.", null, 'i-notify i-notify-error', 10000);
        return false;
    },
    handleCallBackError: function (xhr, thrownError) {

        this.xhr = xhr
        var ex = "";
        if (ex != null) {
            if (xhr.status != null) {
                // accommodate for request abortion (i.e. user clicks away from page before load is complete)
                if (xhr.status == "0") { return; }
                ex += "Status Code: " + xhr.status + " - " + xhr.statusText;
            }

            if (thrownError != null) {
                if (ex != "") { ex += ", "; }
                ex += "Error: " + thrownError;
            }
        }

        iasp_showAlert(null, "There was a problem. " + ex + ". <a href=\"javascript:void(0)\" onclick=\"return jAjax.detailedCallBackError();\">View Details.", null, 'i-notify i-notify-error', 10000);

    },
    detailedCallBackError: function () {
        if (this.xhr.responseText != null) {
            var s = "<textarea class=\"i-text-area\" style=\"width: 95%; height: 300px;\">" + this.xhr.responseText + "</textarea>";
            var p = new InstantASP_PopUp('iPopUp');
            p.width = "800";
            p.height = "400";
            p.useFrame = false;
            p.initialize();
            p.setContent("Server Response...", s);
        } else {
            alert("Sorry. Further details are not available. The server did not return a response.");
        }
        return false;
    }
};

/* extension methods */

Date.prototype.format = function (format) //author: meizz
{
    var o = {
        "M+": this.getMonth() + 1, //month
        "d+": this.getDate(),    //day
        "h+": this.getHours(),   //hour
        "m+": this.getMinutes(), //minute
        "s+": this.getSeconds(), //second
        "q+": Math.floor((this.getMonth() + 3) / 3),  //quarter
        "S": this.getMilliseconds() //millisecond
    }

    if (/(y+)/.test(format)) format = format.replace(RegExp.$1,
      (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o) if (new RegExp("(" + k + ")").test(format))
        format = format.replace(RegExp.$1,
          RegExp.$1.length == 1 ? o[k] :
            ("00" + o[k]).substr(("" + o[k]).length));
    return format;
}

String.prototype.trimStart = function (c) {
    if (this.length == 0) { return this; }
    c = c ? c : ' ';
    var i = 0;
    var val = 0;
    for (; this.charAt(i) == c && i < this.length; i++);
    return this.substring(i);
}

String.prototype.trimEnd = function (c) {
    if (this.length == 0) { return this; }
    c = c ? c : ' ';
    return this.substring(0, this.length - 1);
}

String.prototype.trim = function (c) {
    return this.trimStart(c).trimEnd(c);
}

function endsWith(s, char) {
    if (s.length == 0) { return s; }
    if (s.substr(-1) == char) { return true; }
    return false;
}

function showNavMenu(event, a) {

    var menuID = "Nav_smMenu";
   
    if (iasp_FindControl(menuID) == null) {

        // build menu  
        var div = document.createElement('div');
        div.id = menuID;
        div.className = "i-menu-box ";    
        div.style.width = "250px";

        // build   
        var menu = document.createElement('div');
        menu.className = "sm_Menu";
        menu.style.width = "230px";

        var newList = document.createElement('ui');     
        var lis = $('li[data-mobile="true"]');  
        var loaded = false; 
        if (loaded == false) {
            lis.each(function (ev) {
                var item = $(this);
                var link = item.find("a");             
                    var txt = link.attr("title");
                    if (typeof txt != 'undefined') {

                        var a = document.createElement('a');
                        a.setAttribute("href", link.attr("href"));
                        a.appendChild(document.createTextNode(txt));

                        var li = document.createElement('li');
                        li.appendChild(a);
                      
                        newList.appendChild(li);

                    }
              
            });
            loaded = true;
        }
        
        $(menu).append(newList);
        $(div).append(menu);
        
        document.body.appendChild(div);
        
    }

    iasp_OpnMnu(event, a, menuID, "250px")
    
}

/* jQuery transition effect */

jQuery.extend(jQuery.easing,
{
    def: 'easeOutQuad',
    easeInOutExpo: function (x, t, b, c, d) {
        if (t == 0) return b;
        if (t == d) return b + c;
        if ((t /= d / 2) < 1) return c / 2 * Math.pow(2, 10 * (t - 1)) + b;
        return c / 2 * (-Math.pow(2, -10 * --t) + 2) + b;
    }
});

