﻿"use strict";

var $iHttp = $iHttp || (function ($) {
    var _onError = null;
    var _onAlways = null;
    return {
        onError: function (onError) {
            _onError = onError;
        },
        onAlways: function (onAlways) {
            _onAlways = onAlways;
        },
        promise: function (config) {
            return $.ajax(config)
                .fail(function (xhr, ajaxOptions, thrownError) {
                    if (_onError) {
                        _onError(config, xhr, ajaxOptions, thrownError)
                    }
                })
                .always(function () {
                    if (_onAlways) {
                        _onAlways()
                    }
                });
        }
    };
}(jQuery));

var _kb = _kb || (function ($, w) {

    // API options
    var _opts = {
        url: "",
        version: "1",
        apiKey: ""
    };

    // proxy to $iHttp to set=up configuration before request
    var _http = function (config) {

        // update URL to include absolute URL
        config.url = _opts.url + config.url;

        // add basic authentication headers
        if (_opts.apiKey) {
            config.beforeSend = function (xhr) {
                xhr.setRequestHeader("Authorization", "Basic " + _opts.apiKey);
            }
        }

        // set content type & API version
        config.headers = {
            'Content-Type': 'application/json',
            'X-Api-Version': _opts.version
        };
                
        return $iHttp.promise(config);

    }

    // -----------------

    return {
        initHttp: function (opts) {
            _opts = opts;
        },
        onError: function (onError, config) {
            $iHttp.onError(onError, config);
        },
        onAlways: function (onAlways, config) {
            $iHttp.onAlways(onAlways, config);
        },
        search: {
            getResults: function (params, fn) {
                var pageIndex = (params.page_index ? params.page_index : 1);
                var pageSize = (params.page_size ? params.page_size : 1);
                _http({
                    url: "api/search?page_index=" + pageIndex + "&page_size=" + pageSize,
                    method: "POST",
                    data: JSON.stringify(params.args)
                }).done(function (data) {
                    fn(data);
                });
            }
        },
        tabs: {
            getTabs: function (fn) {
                _http({
                    url: "api/tabs",
                    method: "GET"
                }).done(function (data) {
                    fn(data);
                });
            }
        },
        tab: {
            getTab: function (params, fn) {
                _http({
                    url: "api/tab",
                    method: "GET",
                    data: params
                }).done(function (data) {
                    fn(data);
                });
            },
            postTab: function (ticket, fn) {
                _http({
                    url: "api/tab",
                    method: "POST",
                    data: JSON.stringify(ticket)
                }).done(function (data) {
                    fn(data);
                });
            },
            putTab: function (ticket, fn) {
                _http({
                    url: "api/tab",
                    method: "PUT",
                    data: JSON.stringify(ticket)
                }).done(function (data) {
                    fn(data);
                });
            },
            deleteTab: function (params, fn) {
                _http({
                    url: "api/tab",
                    method: "DELETE",
                    data: params
                }).done(function (data) {
                    fn(data);
                });
            }
        },
        tickets: {
            getTickets: function (params, fn) {
                var pageIndex = (params.page_index ? params.page_index : 1);
                var pageSize = (params.page_size ? params.page_size : 1);
                _http({
                    url: "api/tickets?page_index=" + pageIndex + "&page_size=" + pageSize,
                    method: "POST",
                    data: JSON.stringify(params.args)
                }).done(function (data) {
                    fn(data);
                });
            }
        },
        ticket: {
            getTicket: function (params, fn) {
                _http({
                    url: "api/ticket",
                    method: "GET",
                    data: params
                }).done(function (data) {
                    fn(data);
                });
            },
            postTicket: function (ticket, fn) {
                _http({
                    url: "api/ticket",
                    method: "POST",
                    data: JSON.stringify(ticket)
                }).done(function (data) {
                    fn(data);
                });
            },
            putTicket: function (ticket, fn) {
                _http({
                    url: "api/ticket",
                    method: "PUT",
                    data: JSON.stringify(ticket)
                }).done(function (data) {
                    fn(data);
                });
            },
            deleteTicket: function (params, fn) {
                _http({
                    url: "api/ticket",
                    method: "DELETE",
                    data: params
                }).done(function (data) {
                    fn(data);
                });
            }
        },
        articles: {
            getArticles: function (params, fn) {
                var pageIndex = (params.page_index ? params.page_index : 1);
                var pageSize = (params.page_size ? params.page_size : 1);
                _http({
                    url: "api/articles?page_index=" + pageIndex + "&page_size=" + pageSize,
                    method: "POST",
                    data: JSON.stringify(params.args)
                }).done(function (data) {
                    fn(data);
                });
            }
        },
        article: {
            getArticle: function (params, fn) {
                _http({
                    url: "api/article",
                    method: "GET",
                    data: params
                }).done(function (data) {
                    fn(data);
                });
            },
            postArticle: function (ticket, fn) {
                _http({
                    url: "api/article",
                    method: "POST",
                    data: JSON.stringify(ticket)
                }).done(function (data) {
                    fn(data);
                });
            },
            putArticle: function (ticket, fn) {
                _http({
                    url: "api/article",
                    method: "PUT",
                    data: JSON.stringify(ticket)
                }).done(function (data) {
                    fn(data);
                });
            },
            deleteArticle: function (params, fn) {
                _http({
                    url: "api/article",
                    method: "DELETE",
                    data: params
                }).done(function (data) {
                    fn(data);
                });
            }
        }

    }

}(jQuery, window));

// ---------------------------------
// USAGE
// ---------------------------------

// tickets


/*
$(document).ready(function () {
    
    // -------------------
    // set-up InstantKB web api
    // -------------------

    // optional base URL ad API key
    _kb.initHttp({ url: "", version: "1", apiKey: "1234:1234" });

    // triggers if errors occur during call backs
    _kb.onError(function (err) {
        var msg = $("<span>").html(err);
        $("#error").append(msg);
    })

    // triggers on every call back
    _kb.onAlways(function () {
        var msg = $("<span>").html("request complete<br>");
        $("#always").append(msg);
    })

    // -------------------
    // get & update ticket
    // -------------------
       
    _kb.ticket.getTicket({ id: 123 }, function(ticket) {
        if (ticket) {      
            ticket.title = "123";
            _kb.ticket.updateTickets(ticket, function (ticket) {
                
            });
        }
    });
  

    _kb.tickets.getTickets({
        pageIndex: 1,
        pageSize: 10,
        args: {
           keywords: "instantforum",
           tabId: 13,
           sortBy: "TicketRank",
           sortOrder: "desc"
       }
    }, function (tickets) {
        for (var i = 0; i < tickets.length; i++) {
            var val = $("<span>");
            val.html(tickets[i].title + "<br/>");
            $("#tickets").append(val);
        }
    });
    
    // get ticket
    _kb.ticket.getTicket({ id: 123 }, function (ticket) {
        if (ticket) {
            //alert("ticket updated " + JSON.stringify(ticket));
        }
    });
   

});
*/