"use strict";

/* ----------------------------------------------------------- */
// helpers
/* ----------------------------------------------------------- */

/* character counter for twitter ticket replies */
function ikb_TwitterCharCount($input, $count, e) {
    var maxLen = 140;   
    var len = $input.val().length;
    if (len >= maxLen) {     
        $input.val($input.val().substring(0, maxLen))
        $count.html(maxLen - $input.val().length);
    } else {
        $count.html(maxLen - len);
    }
}

/* generic delete confirmation for admin pages */
function ikb_ConfirmDelete(listid, deleteenum) {

    // get drop down list
    var list = iasp_FindControl(listid);
    if (list != null) {
        if (list.value == 0) { return false; }
        // is delete selected
        if (list.value == deleteenum) {
            return confirm(ikb_strDeleteItemConfirmation);
        }
    }
    return true;

}

/* tab mass action button event */
function ikb_ViewTabsMassActionClick(listid, movetolistid, deleteenum, deletemoveenum) {

    // get drop down list
    var list = iasp_FindControl(listid);
    var movetolist = iasp_FindControl(movetolistid);
    if (list != null && movetolist != null) {
        if (list.value == 0) { return false; }
        // is delete selected
        if (list.value == deleteenum) {
            return confirm(ikb_strDeleteTabConfirmation);
        }
        else if (list.value == deletemoveenum)
            if (movetolist.value == 0) { alert(ikb_strNoNewTabSelected); return false; }
        {
            return confirm(ikb_strDeleteTabMveConfirmation);
        }
    }
    return true;
}

/* show "move to tab" drop down list if you we choose to move centent when deleting tabs */
function ikb_ViewTabsMassActionSelectedIndexChanged(listid, movetolistid, deletemoveenum) {

    // get drop down list
    var list = iasp_FindControl(listid);
    var movetolist = iasp_FindControl(movetolistid);
    if (list != null && movetolist != null) {
        // is delete selected
        if (list.value == deletemoveenum) {
            movetolist.style.display = '';
        }
        else {
            movetolist.style.display = 'none';
        }
    }

}

function ikb_IsValidEmail(txt) {
    if (txt == null || txt.length == 0 || txt.val() == "") { return false }
    var val = txt.val().toLowerCase();
    if (val.indexOf("@") == -1) { return false; }
    var r = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return r.test(txt.val());
    return true;
}

/* Article Options (Send Via Email, Social Bookmarks etc) */
function ikb_SendArticleByEmail(btn, strCallBackURL) {
    
    var txt = $(btn).parent().find("input"),
        val = txt.val();
     
    // check we have a email
    if (!ikb_IsValidEmail(txt)) {
        txt.focus(); return;
    }

    // get url
    var arrURL = strCallBackURL.split("?");

    // setup xmlhttp
    var XmlHttp = new iasp_XmlHttpRequest();
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    // get result
                    var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                    // end loader
                    iasp_AjaxExtensionsEndRequest();
                    // was everything ok
                    if (identity == 0) {
                        iasp_showAlert(null, ikb_strSendProblem);                       
                    } else {
                        // hide menu
                        iasp_HideAllMenus();
                        // show alert
                        iasp_showAlert(null, ikb_strArticleSentSuccess);                       
                    }
                }
            }
        }
    };
    
    var strParams = arrURL[1] + "&key=" + encodeURI(val);   
    iasp_AjaxExtensionsInitializeRequest();  
    XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

/* hide homepage sections message shown to administrators on the homepage */
function ikb_HideSectionsTip(elToHide, ckName) {

    $("#" + elToHide).slideUp("fast");
    iasp_SetCookie(ckName, "1");

}

/* toggle table of contents in documentation tab for mobile view */
function ikb_ToggleDocsToc(a) {
    var toc = $(".docs-toc");
    var body = $(".docs-body");
    var btn = $(a);
    if (toc.css("left") == "0px") {
        btn.removeClass("selected");
        toc.show().stop().animate({
            'left': -$(window).width()
        }, {
            duration: 'fast', queue: true, complete: function () {

            }
        }, 'easeInOutExpo');
    } else {
        $(".rspFirstItem").css({ "height": $(".docs-body").height() }).show();
        toc.css({ "height": $(".docs-body").height(), "overflow": "auto", "display": "block", "left": -toc.width() });
        btn.addClass("selected");
        toc.show().stop().animate({
            'left': 0
        }, {
            duration: 'fast', queue: true, complete: function () {

            }
        }, 'easeInOutExpo');
    }
}

/* toggle mobile search in documentation tab */
function ikb_ToggleDocsSearch(a) {
    var el = $(".docs-mobile-search");
    var btn = $(a);
    if (el.is(":visible")) {
        el.hide();
        btn.removeClass("selected");
    } else {
        el.show();
        btn.addClass("selected");
    }
}

/* ----------------------------------------------------------- */
// tree view context menu options
/* ----------------------------------------------------------- */

/* staff root category context menu */
function ikb_rootNodeContextMenu(container, selNode, menuId, itemId) {

    if (container != null) {

        // get selected node
        var selNode = container.getSelNode();

        if (selNode != null) {

            switch (itemId) {
                case "0": // add category
                    var selNodeID = selNode.NodeID;
                    container.ctx_liveAdd(selNodeID, ikb_strDefaultNodeText);
                    break;
                case "2": // expand
                    container.expandAll();
                    iasp_HideAllMenus();
                    break;
                case "3": // collapse
                    container.collapseAll();
                    iasp_HideAllMenus();
                    break;
            }
        }
    }
}

/* staff category context menu */
function ikb_treeContextMenu(container, selNode, menuId, itemId) {

    if (container != null) {

        // get selected node
        var selNode = container.getSelNode();

        if (selNode != null) {

            switch (itemId) {
                case "0": // add category
                    var selNodeID = selNode.NodeID;
                    container.ctx_liveAdd(selNodeID, ikb_strDefaultNodeText);
                    break;
                case "1": // quick edit
                    container.liveNodeEditStart(selNode.ID);
                    break;
                case "2": // edit category detailed                 
                    var uri = container.Options.NodeEditURL + 'StaffEditCategory' + selNode.CategoryID + '-' + container.Options.TabID + '.aspx';
                    location = uri;               
                    break;
                case "3": // edit article (documentation view)
                    ikb_treeLiveEditArticle(container, function (node) {                       
                        if (node.ArticleID > 0) {
                            if (node.EditURL != null) {
                                location = node.EditURL;
                            } else {
                                location = node.NavigateURL;
                            }
                        } else {
                            if (node.CategoryID > 0) {
                                if (confirm("This category has no article. Would you like to create an article now?")) {
                                    location = node.NavigateURL;
                                }                                
                            }                         
                        }                                     
                    });               
                    break;
                case "4": // move up
                    // get orevious node
                    var dest = null; if (selNode.PrevNode != null) { dest = selNode.PrevNode; }
                    if (dest != null) {
                        // move node
                        container.moveChild(selNode, dest, 2)
                        // do callback
                        ikb_treeCallBack(container, selNode, container.Options.LiveMoveUpCallBackURL, "", "&id=" + selNode.CategoryID)
                    }
                    break;
                case "5": // move down
                    // get bext node  
                    var dest = null; if (selNode.NextNode != null) { dest = selNode.NextNode; }
                    if (dest != null) {
                        // move node
                        container.moveChild(selNode, dest, 3)
                        // do callback 
                        ikb_treeCallBack(container, selNode, container.Options.LiveMoveDownCallBackURL, "", "&id=" + selNode.CategoryID)
                    }
                    break;
                case "7": // delete 
                    iasp_HideAllMenus();
                    // confirm delete
                    if (confirm(ikb_strDeleteCategory)) {
                        // do loader
                        iasp_AjaxExtensionsInitializeRequest();
                        // delete node
                        container.remove();
                        // do callback
                        ikb_treeCallBack(container, selNode, container.Options.LiveDeleteCallBackURL, ikb_strProblemDeletingCategory, "&id=" + selNode.CategoryID)
                    }
                    break;
            }

            iasp_HideAllMenus();

        }
    }
}

/* staff root trouble shooter context menu */
function ikb_rootTroubleshooterNodeContextMenu(container, selNode, menuId, itemId) {

    if (container != null) {

        // get selected node
        var selNode = container.getSelNode();

        if (selNode != null) {

            switch (itemId) {
                case "0": // add category
                    var selNodeID = selNode.NodeID;
                    container.ctx_liveAdd(selNodeID, ikb_strDefaultTroubleshooterNodeText);
                    break;
                case "2": // expand
                    container.expandAll();
                    break;
                case "3": // collapse
                    container.collapseAll();
                    break;
            }

            iasp_HideAllMenus();
        }
    }
}

/* staff trouble shooter context menu */
function ikb_treeTroubleshooterContextMenu(container, selNode, menuId, itemId) {

    if (container != null) {

        // get selected node
        var selNode = container.getSelNode();

        if (selNode != null) {

            switch (itemId) {
                case "0": // add step
                    var selNodeID = selNode.NodeID;
                    container.ctx_liveAdd(selNodeID, ikb_strDefaultTroubleshooterNodeText);
                    break;
                case "1": // quick edit
                    container.liveNodeEditStart(selNode.ID);
                    break;
                case "2": // edut category detailed
                    if (selNode.NavigateURL.indexOf("javascript:") == -1) {
                        location = selNode.NavigateURL;
                    } else {
                        var loc = ""; loc = location.href;
                        var end = loc.indexOf("?");
                        var loc = loc.substring(0, end);
                        var uri = loc + "?StepID=" + selNode.CategoryID;
                        location = uri;
                    }
                    break;
                case "4": // move up
                    // get orevious node
                    var dest = null; if (selNode.PrevNode != null) { dest = selNode.PrevNode; }
                    if (dest != null) {
                        // move node
                        container.moveChild(selNode, dest, 2)
                        // do callback
                        ikb_treeCallBack(container, selNode, container.Options.LiveMoveUpCallBackURL, "", "&id=" + selNode.CategoryID)
                    }
                    break;
                case "5": // move down
                    // get bext node  
                    var dest = null; if (selNode.NextNode != null) { dest = selNode.NextNode; }
                    if (dest != null) {
                        // move node
                        container.moveChild(selNode, dest, 3)
                        // do callback 
                        ikb_treeCallBack(container, selNode, container.Options.LiveMoveDownCallBackURL, "", "&id=" + selNode.CategoryID)
                    }
                    break;
                case "7": // delete 
                    // confirm delete step
                    if (confirm(ikb_strDeleteTroubleshooterStep)) {
                        // delete node
                        container.remove();
                        // do callback
                        ikb_treeCallBack(container, selNode, container.Options.LiveDeleteCallBackURL, ikb_strProblemDeletingCategory, "&id=" + selNode.CategoryID)
                    }
                    break;
            }

            iasp_HideAllMenus();

        }
    }
}

/* save tree node update on text box blur */
function ikb_treeLiveSWriteAndNavigate(tree) {
    ikb_treeLiveWrite(tree, function (newNode) {
        iasp_AjaxExtensionsInitializeRequest();
        location = newNode.NavigateURL;
    });
}

/* save tree node update on text box blur */
function ikb_treeStaffLiveWriteAndNavigate(tree) {
    ikb_treeLiveWrite(tree, function (newNode) {
        //iasp_AjaxExtensionsInitializeRequest();
        //location = newNode.EditURL;
    });
}

function ikb_treeLiveWrite(tree, successCallback) {

    if (tree != null) {

        // get node
        var node = tree.SelectedNode;

        if (node != null) {

            // get url
            var arrURL = tree.Options.LiveWriteCallBackURL.split("?");

            // setup xmlhttp
            var XmlHttp = new iasp_XmlHttpRequest();
            var objXmlHttpHandler = function (obj) {
                if (obj.responseXML != null) {
                    var items = obj.responseXML.getElementsByTagName("result");
                    if (items.length > 0) {
                        for (var i = 0; i < items.length; i++) {
                            var nd = items[i];
                            // get result
                            var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                            var url = nd.getAttribute("url") == null ? "" : nd.getAttribute("url");
                            var editUrl = nd.getAttribute("editUrl") == null ? "" : nd.getAttribute("editUrl");
                            // end loader
                            iasp_AjaxExtensionsEndRequest();
                            // was everything OK
                            if (identity == 0) {
                                alert(ikb_strProblemSavingCategory);
                            } else {                            
                                tree.SelectedNode.CategoryID = identity;
                                tree.SelectedNode.NavigateURL = url;
                                tree.SelectedNode.EditURL = editUrl;
                                if (successCallback) {
                                    successCallback(tree.SelectedNode);
                                }
                            }
                        }
                      
                    }
                }
            };

            var categoryID = 0;
            if (node.ParentNode != null) {
                categoryID = node.ParentNode.CategoryID;
            }
       
            var strParams = arrURL[1] + "&id=" + node.CategoryID + "&ParentID=" + categoryID + "&Key=" + iasp_EncodeString(node.Text);          
            iasp_AjaxExtensionsInitializeRequest();     
            XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

        }
    }

}

function ikb_treeLiveEditArticle(tree, successCallback) {

    if (tree != null) {

        // get node
        var node = tree.SelectedNode;

        if (node != null) {
       
            // get url
            var arrURL = tree.Options.LiveEditArticleCallBackURL.split("?");

            // setup xmlhttp
            var XmlHttp = new iasp_XmlHttpRequest(); 
            var objXmlHttpHandler = function (obj) {
                if (obj.responseXML != null) {
                    var items = obj.responseXML.getElementsByTagName("result");
                    if (items.length > 0) {
                        for (var i = 0; i < items.length; i++) {
                            var nd = items[i];
                            // get result
                            var articleId = nd.getAttribute("articleId") == null ? 0 : nd.getAttribute("articleId");
                            var categoryId = nd.getAttribute("categoryId") == null ? 0 : nd.getAttribute("categoryId");
                            var url = nd.getAttribute("url") == null ? "" : nd.getAttribute("url");
                            var editUrl = nd.getAttribute("editUrl") == null ? "" : nd.getAttribute("editUrl");
                            // end loader
                            iasp_AjaxExtensionsEndRequest();
                            // was everything OK
                            if (articleId === 0 && categoryId === 0) {
                                alert("Could not obtain article for category");
                            } else {                           
                                tree.SelectedNode.ArticleID = articleId;
                                tree.SelectedNode.CategoryID = categoryId;
                                tree.SelectedNode.NavigateURL = url;
                                tree.SelectedNode.EditURL = editUrl;
                                if (successCallback) {
                                    successCallback(tree.SelectedNode);
                                }
                            }
                        }

                    }
                }
            };

            var categoryID = 0;
            if (node.ParentNode != null) {
                categoryID = node.ParentNode.CategoryID;
            }
  
            var strParams = arrURL[1] + "&id=" + node.CategoryID + "&ParentID=" + categoryID + "&Key=" + iasp_EncodeString(node.Text);         
            iasp_AjaxExtensionsInitializeRequest();  
            XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

        }
    }

}

function ikb_treeCallBack(tree, node, callbackURL, errMsg, params) {

    if (tree != null) {

        // do we have a specific node?
        if (node == null) { node = tree.SelectedNode; }

        if (node != null) {

            // get url
            var arrURL = callbackURL.split("?");

            // setup xmlhttp
            var XmlHttp = new iasp_XmlHttpRequest(); 
            var objXmlHttpHandler = function (obj) {
                if (obj.responseXML != null) {
                    var items = obj.responseXML.getElementsByTagName("result");
                    if (items.length > 0) {
                        for (var i = 0; i < items.length; i++) {
                            var nd = items[i];
                            // get result
                            var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                            // end loader
                            iasp_AjaxExtensionsEndRequest();
                            // was everything ok
                            if (identity == 0) { alert(errMsg); }
                        }
                    }
                }
            };

            // we need a category id   
            if (node.CategoryID > 0) {          
                var strParams = arrURL[1] + params           
                iasp_AjaxExtensionsInitializeRequest();          
                XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);
            }

        }
    }
}

function ikb_toggleTree(tree) {
    if (tree.Options.Expanded) {
        tree.collapseAll();
        tree.Options.Expanded = false;
    } else {
        tree.expandAll();
        tree.Options.Expanded = true;
    }
}

/* logout confirmation alert */
function ikb_logOut() {

    // disable body
    iasp_disableBody(null, null, false);

    if (confirm(ikb_strLogoutAlertText)) {
        return true;
    } else {
        // enable body if cancel
        iasp_enableBody();
        return false;
    }


}

/* show ajax based glossary tooltip */
function ikb_showGlossaryToopTip(el, intGlossaryTermID) {

    // tooltip width 
    var intWidth = 275;
    var arrURL = strGlossaryToolTipCallBackURL.split("?");

    // setup xmlhttp
    var XmlHttp = new iasp_XmlHttpRequest(); 
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];                  
                    var strValue = nd.getAttribute("value") == null ? 0 : nd.getAttribute("value");
                    // was everything ok
                    if (strValue == "") {
                        alert(ikb_strSendProblem);
                        iasp_DisableTip();
                    } else {
                        var $el = $(el); 
                        $el.attr("title", strValue);                                           
                        iasp_HideToolTip();
                        iasp_ShowToolTip($el, false, false);                          
                        $el.attr("title", "");                     
                    }
                }
            }
        }
    };

    // setup params
    var strParams = arrURL[1] + "&id=" + intGlossaryTermID;

    el.title = '<div class="i-spacing-small ikb-glossary-loader"><i class="fa fa-spinner fa-spin"></i></div>';
    el.setAttribute("data-width", "400");
    iasp_ShowToolTip($(el));
    
    // make request
    XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

/* ----------------------------------------------------------- */
// method to add standard replies to the rich text box within the staff CP
/* ----------------------------------------------------------- */

function ikb_AddStandardReply(intReplyID, strRTBClientID, strCallBackURL) {
      
    var editor = $find(strRTBClientID);

    // get url
    var arrURL = strCallBackURL.split("?");

    // setup xmlhttp
    var XmlHttp = new iasp_XmlHttpRequest(); 
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    // get result
                    var text = nd.getAttribute("text") == null ? "" : nd.getAttribute("text");
                    // end loader
                    iasp_AjaxExtensionsEndRequest();
                    // was everything ok
                    if (text == "") {
                        alert(ikb_strAddStandardReplyProblem);
                    } else {
                        editor.pasteHtml(text);
                        iasp_HideAllMenus();
                    }
                }
            }
        }
    };

    // setup params
    var strParams = arrURL[1] + "&ID=" + intReplyID;

    // setup loader
    iasp_AjaxExtensionsInitializeRequest();

    // make request
    XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

/* ----------------------------------------------------------- */
// live search for ticket submissions
/* ----------------------------------------------------------- */

var iaspls_timeoutID = null;
var lsDelay = 2;
var lsPageSze = 5;
var lsTxt = null
var lsRTB = null;

// text box change event
function ikb_lsTextSelChanged(txt, usetimeout) {
    lsTxt = txt;
    lsPageSze = 5;
    if (txt.value != "" && iaspls_timeoutID == null) {
        if (usetimeout) {
            iaspls_timeoutID = setTimeout(ikb_lsKeyDown, lsDelay * 1000)
        } else {
            ikb_lsKeyDown();
        }      
    }
}

// rich text box key down event for live suggestions
function ikb_lsEditorOnClientLoad(editor, args) {
     
    // initialize general editor settings
    Editor_OnClientLoad(editor, args);

    // add a timed event handler for live suggestions
    if (editor != null) {
        addEvent(editor.get_document(), 'keydown', function (e) {
            if (iaspls_timeoutID == null) {          
                lsPageSze = 5;        
                if (editor.get_text() != "") {
                    lsRTB = editor;               
                    iaspls_timeoutID = setTimeout(ikb_lsKeyDown, lsDelay * 1000)
                }
            }

        });
    }
}

function ikb_lsKeyDown() {
    
    var strKeywords = ""
    if (lsTxt != null) {
        strKeywords = lsTxt.value;
    }

    if (lsRTB != null) {
        strKeywords = strKeywords + " " + lsRTB.get_text()
    }

    if (ls != null) {

        var pnl = iasp_FindControl(ls.id);
        var pnlMore = iasp_FindControl(ls.more);
        var tr1 = iasp_FindControl(ls.tr1);
        var tr2 = iasp_FindControl(ls.tr2);

        // check for our settings array
        if (pnl != null && tr1 != null && tr2 != null) {

            if (strKeywords != "") {
                ikb_lsPopulate(lsPageSze, strKeywords, ls.callbackurl, pnl, pnlMore, tr1, tr2);
            } else {
                tr1.style.display = "none";
                tr2.style.display = "none";
                pnl.innerHTML = "";
                if (iaspls_timeoutID != null) { clearTimeout(iaspls_timeoutID); iaspls_timeoutID = null; }
            }
        }
    }
}

function ikb_lsMoreClick() {

    var pnlMore = iasp_FindControl(ls.more);
    if (pnlMore) {
        var $icon = $(pnlMore).find("i");
        if ($icon.length > 0) {
            $icon.removeClass("fa-chevron-downfa-search").addClass("fa-spinner").addClass("fa-spin");
        }     
    }

    lsPageSze += 5;
    ikb_lsKeyDown();
}

function ikb_lsPopulate(pageSize, strKeywords, strCallBackURL, pnl, pnlMore, tr1, tr2) {

    // get url
    var arrURL = strCallBackURL.split("?");
    var intTotal = 0;

    var XmlHttp = new iasp_XmlHttpRequest(); 
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var total = obj.responseXML.getElementsByTagName("total");       
            if (total.length > 0) {
                for (var i = 0; i < total.length; i++) {
                    var nd = total[i];
                    intTotal = parseInt(nd.firstChild.nodeValue)
                }
            }
            var items = obj.responseXML.getElementsByTagName("result");
            var s = "";
            if (items.length > 0) {
                s += "<h3 style='line-height: normal; display:block;'>" + ikb_strLiveResultsHeader + "</h3>";
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    var title = nd.getAttribute("title") == null ? "" : nd.getAttribute("title");
                    var rank = nd.getAttribute("rank") == null ? 0 : parseInt(nd.getAttribute("rank"));
                    var text = nd.getAttribute("text") == null ? "" : nd.getAttribute("text");
                    var navigateurl = nd.getAttribute("navigateurl") == null ? "" : nd.getAttribute("navigateurl");
                    s += "<div class=\"row\" style=\"margin-bottom: 16px;\">";
                    s += "<i class=\"fa fa-file-o i-margin-right-small\"></i><a href=\"" + navigateurl + "\" target=\"_blank\" class=\"primary\">" + title + "</a>";
                    if (rank > 0) {
                        s += "<span class=\"i-type-light\">";
                        s += " " + ibk_Rank.replace("[0]", rank)
                        s += "</span>";
                    }
                    s += "<br />";
                    s += "<span class=\"light-text\">";
                    s += text;
                    s += "</span>";
                    s += "</div>";
                }
            }

            if (typeof s != 'undefined' && s != null) {
                if (s != "") {
                    tr1.style.display = "";
                    tr2.style.display = "";                
                    if (pageSize >= intTotal) {
                        pnlMore.style.display = "none";
                    } else {
                        pnlMore.style.display = "";
                    }             
                    if (pnlMore) {
                        var $icon = $(pnlMore).find("i");
                        if ($icon.length > 0) {
                            $icon.removeClass("fa-spinner").removeClass("fa-spin").addClass("fa-chevron-down");
                        }
                    }

                    pnl.innerHTML = s;
                } else {
                    tr1.style.display = "none";
                    tr2.style.display = "none";
                    pnl.innerHTML = "";
                }
            } else {
                tr1.style.display = "none";
                tr2.style.display = "none";
                pnl.innerHTML = "";
            }

            // clear timeout
            if (iaspls_timeoutID != null) { clearTimeout(iaspls_timeoutID); iaspls_timeoutID = null; }         
          
        } else {

            // clear timeout
            if (iaspls_timeoutID != null) { clearTimeout(iaspls_timeoutID); iaspls_timeoutID = null; }

        }
    };
      
    var strParams = arrURL[1] + "&Keywords=" + iasp_EncodeString(strKeywords) + "&PageSize=" + pageSize + "&SearchUsing=1";      
    XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

/* ----------------------------------------------------------- */
// search suggestions
/* ----------------------------------------------------------- */

var searchSuggest = {
    timer: null,
    tabId: 0,
    $txt: null,
    $button: null,
    $tabs: null,
    $results: null,
    pageSize: 10,
    callbackUrl: null,
    XmlHttp: null,
    setResultsPosition: function () {

        var txt = searchSuggest.$txt;
        var el = $("#searchSuggest");
        var container = $(txt).parents(".i-search-input");
           
        var height = txt.offsetHeight + 4,
            top = $(txt).offset().top,
            left = iasp_GetOffsetLeft(txt),
            width = $(container).width(),
            bottom = top + height;

        el.css({ "left": left - 5, "top": bottom, "width": width });
       
    },
    buildResults: function() {

        var el = null;  
        if ($("#searchSuggest").length == 0) {
            el = $("<div id=\"searchSuggest\"></div>");        
            el.addClass("i-menu-box");
            $("body").append(el);  
        } else {
            el = $("#searchSuggest");
        }

        this.setResultsPosition(el);
        return el;

    },  
    keyDown: function (e, txt, tabId, tabs, url) {

        if ((e.keyCode && e.keyCode == 13)) {
            var pnl = searchSuggest.$results;
            pnl.hide().html("");
            var baseUrl = $(txt).data("searchurl");
            if (baseUrl != null && typeof baseUrl != 'undefined') {
                var url = $(txt).data("searchurl") + "?Keywords=" + encodeURIComponent(txt.value);         
                location = url;
            }
            return false;
        }

        this.tabId = tabId;
        this.$txt = txt;        
        this.$tabs = $("#" + tabs).find("input");      
        if (this.$button == null) {
            this.$button = $(txt).parent().parent().find(".i-search-button").find(".fa-search");
        }                
     
        this.$results = this.buildResults();

        iasp_HideAllMenus();
             
        if (this.callbackUrl == null) {
            this.callbackUrl = url;
            $(document).click(function () {
                if ($("#searchSuggest").is(":visible")) {
                    $("#searchSuggest").hide();
                    $(this.$txt).blur();
                }
            });
        }
         
        if (txt.value != "") {
            this.$button.removeClass("fa-search").addClass("fa-spinner").addClass("fa-spin");
            if (searchSuggest.timer == null) {
                if (e.keyCode != 0) {
                    searchSuggest.timer = window.setTimeout(function () {
                        searchSuggest.populate();
                    }, 1000);
                } else {
                    searchSuggest.populate();
                }
            }
        } else {            
            var pnl = searchSuggest.$results;
            pnl.hide().html("");
            searchSuggest.timer = null;
            searchSuggest.$button.removeClass("fa-spinner").removeClass("fa-spin").addClass("fa-search");
        }
        
        return true;

    },
    populate: function () {
            
        var total = 0, tabID = 0,
            url = this.callbackUrl.split("?"),
            txt = this.$txt,
            pnl = this.$results;
                  
        if (searchSuggest.$tabs.length > 0) {
            tabID = searchSuggest.$tabs.filter(":checked").val();
        } else {
            tabID = searchSuggest.tabId;
        }
      
        this.$button.removeClass("fa-search").addClass("fa-spinner").addClass("fa-spin");

        // setup xmlhttp
        if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
        var objXmlHttpHandler = function (obj) {
            if (obj.responseXML != null) {
                var total = obj.responseXML.getElementsByTagName("total");
                if (total.length > 0) {
                    for (var i = 0; i < total.length; i++) {
                        var nd = total[i];
                        total = parseInt(nd.firstChild.nodeValue)
                    }
                }
        
                var items = obj.responseXML.getElementsByTagName("result");             
                var s = "";
                s += '<div class="i-menu">';
                s += '<div class="menu">';

                if (items.length > 0) {

                    s += '<ul>';
                    for (var i = 0; i < items.length; i++) {

                        var nd = items[i];
                        var title = nd.getAttribute("title") == null ? "" : nd.getAttribute("title");
                        var rank = nd.getAttribute("rank") == null ? 0 : parseInt(nd.getAttribute("rank"));
                        var img = nd.getAttribute("img") == null ? "" : nd.getAttribute("img");
                        var text = nd.getAttribute("text") == null ? "" : nd.getAttribute("text");
                        var navigateurl = nd.getAttribute("navigateurl") == null ? "" : nd.getAttribute("navigateurl");
                        if (navigateurl) {
                            navigateurl += "?Keywords=" + encodeURI(txt.value);
                        }

                        s += "<li>";
                        s += "<a title=\"" + text + "\" href=\"" + navigateurl + "\">";
                        s += "<span class=\"padding\">";                     
                        if (img != "") {
                            s += "<img class=\"i-align-middle\" style=\"margin: 0; margin-right: 6px;\" src=\"" + img + "\"/>";
                        }
                        s += title;
                        if (rank > 0) {
                            s += " <span style=\"opacity: .5;\">" + ibk_Rank.replace("[0]", rank) + "</span>";
                        }
                        s += "</span></a>";
                        s += "</li>";
                    }
                    s += "</ul>";
                } else {
                    s += "<div class=\"results\">";
                    s += "<div class=\"padding\">";
                    s += "No results";
                    s += "</div>";
                    s += "</div>";
                }

                s += "</div>";
                s += "</div>";

                if (typeof s != 'undefined' && s != null) {
                    if (s != "") {                        
                        pnl.show()                 
                        pnl.html(s);
                    } else {                    
                        pnl.hide()
                        pnl.html("");
                    }
                } else {                
                    pnl.hide()
                    pnl.html("");
                }
                            
            }

            // clear timeout we don't want to keep hitting the db
            if (searchSuggest.timer != null) { clearTimeout(searchSuggest.timer); searchSuggest.timer = null; }
            searchSuggest.$button.removeClass("fa-spinner").removeClass("fa-spin").addClass("fa-search");

        };
                     
        // setup params
        var strParams = url[1] + "&Keywords=" + encodeURI(txt.value) + "&TabID=" + tabID + "&PageSize=" + searchSuggest.pageSize + "&SearchUsing=2";
     
        // make request
        this.XmlHttp.Connect(url[0], "GET", strParams, objXmlHttpHandler);
        
    }
}

/* ----------------------------------------------------------- */
// add related articles
/* ----------------------------------------------------------- */

var addRelatedArticles = {
    articleId: 0,   
    addURL: null, 
    XmlHttp: null,  
    save: function (id) {
        
        var url = this.postURL.split("?");
             
        if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
        var objXmlHttpHandler = function (obj) {
            if (obj.responseXML != null) {          
                var items = obj.responseXML.getElementsByTagName("result");
                if (items.length > 0) {
                    for (var i = 0; i < items.length; i++) {
                        var nd = items[i];                      
                        var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");                     
                        if (identity > 0) {                                                                      
                            iasp_showAlert(null, ikb_RelateSuccess);
                            manageRelatedArticles.populate();
                        } else {
                            iasp_showAlert(null, ikb_RelateError, null, "i-notify i-notify-error");
                           // alert(ikb_RelateError);
                        }
                    }
                }
            }                      
        };

        // setup params
        var strParams = url[1] + "&ArticleID=" + addRelatedArticles.articleId + "&ID=" + id;

        // make request
        this.XmlHttp.Connect(url[0], "GET", strParams, objXmlHttpHandler);
        
    }  
}

/* ----------------------------------------------------------- */
// manage related articles
/* ----------------------------------------------------------- */

var manageRelatedArticles = {
    articleId: 0,
    getURL: null,
    deleteURL: null,
    $results: null,
    $loader: null,
    XmlHttp: null,
    populate: function () {

        var url = this.getURL.split("?"),
            pnl = this.$results;
        
        if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
        var objXmlHttpHandler = function (obj) {
            if (obj.responseXML != null) {
             
                var items = obj.responseXML.getElementsByTagName("result");
                var s = "";
                if (items.length > 0) {                  
                    for (var i = 0; i < items.length; i++) {

                        var nd = items[i];
                        var id = nd.getAttribute("id") == null ? 0 : nd.getAttribute("id");
                        var title = nd.getAttribute("title") == null ? "" : nd.getAttribute("title");                        
                        var RelatedLinkID = nd.getAttribute("relatedLinkID") == null ? 0 : parseInt(nd.getAttribute("relatedLinkID"));
                        var navigateurl = nd.getAttribute("navigateurl") == null ? "" : nd.getAttribute("navigateurl");                                          
                        var img = nd.getAttribute("img") == null ? "" : nd.getAttribute("img");

                        s += "<div class=\"i-row\"><a data-id=\"" + RelatedLinkID + "\" onclick=\"manageRelatedArticles.deleteClick(this);\" title=\"Click to Remove Related Content\" href=\"javascript:void(0);\" class=\"article " + (RelatedLinkID > 0 ? "on" : "off") + "\" onmouseenter=\"iasp_ShowToolTip($(this));\" onmouseleave=\"iasp_HideToolTip($(this));\"><span class=\"padding\"><i class=\"fa fa-check\"></i><span class=\"title\">";
                        if (img != "") {
                            s += "<img class=\"align-middle\" style=\"margin-right: 6px;\" src=\"" + img + "\"/>";
                        }
                        s += title + "</span>";                                       
                        s += "</span></a>";

                        s += "<a class=\"i-btn i-btn-default\" target=\"_blank\" title=\"" + ibk_OpenInNewWindow + "\" href=\"" + navigateurl + "\" class=\"" + (RelatedLinkID > 0 ? "on" : "off") + "\" onmouseenter=\"iasp_ShowToolTip($(this));\" onmouseleave=\"iasp_HideToolTip($(this));\" data-position=\"left\"><span class=\"i-btn-bg\"></span><span>";
                        s += "<i class=\"fa fa-external-link\"></i>";
                        s += "</span></a></div>";


                    }
                   
                } else {
                    s += "<div class=\"i-no-results\">";
                    s += "<i class=\"fa fa-meh-o\"></i><br/>"
                    s += "<h2>No Related Articles</h2>";                
                    s += "</div>";
                }

                if (typeof s != 'undefined' && s != null) {
                    if (s != "") {
                        pnl.show()
                        pnl.html(s);                     
                    } else {
                        pnl.hide()
                        pnl.html("");                     
                    }
                } else {
                    pnl.hide()
                    pnl.html("");
                }
                
                manageRelatedArticles.$loader.hide();

            } else {
                
                manageRelatedArticles.$loader.hide();

                var s = "";
                s += "<div class=\"i-no-results\">";
                s += "<i class=\"fa fa-meh-o\"></i><br/>"
                s += "<h2>No Related Articles</h2>";
                s += "</div>";

                pnl.show()
                pnl.html(s);
            }

          
           
        };

        // setup params
        var strParams = url[1] + "&ArticleID=" + manageRelatedArticles.articleId;

        // make request
        this.XmlHttp.Connect(url[0], "GET", strParams, objXmlHttpHandler);

    },
    deleteClick: function (a) {

        var url =  this.deleteURL.split("?"),
            a = $(a),
            id = parseInt(a.data("id"));

      
        if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
        var objXmlHttpHandler = function (obj) {
            if (obj.responseXML != null) {
                var items = obj.responseXML.getElementsByTagName("result");
                if (items.length > 0) {
                    for (var i = 0; i < items.length; i++) {
                        var nd = items[i];
                        var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                        if (identity > 0) {
                            iasp_showAlert(null, ikb_ChangesSaved);
                            manageRelatedArticles.populate();
                            addRelatedArticles.populate();
                        } else {
                            alert("Problem deleting related content. Please try again.");
                        }
                    }
                }
            }
        };

        // setup params
        var strParams = url[1] + "&ArticleID=" + manageRelatedArticles.articleId + "&ID=" + id;

        // make request
        this.XmlHttp.Connect(url[0], "GET", strParams, objXmlHttpHandler);

    }
}

/* ----------------------------------------------------------- */
// manage link backs for articles
/* ----------------------------------------------------------- */

var linkBacks = {
    articleId: 0,
    getURL: null,
    deleteURL: null,
    $results: null,
    $loader: null,
    XmlHttp: null,
    populate: function () {

        var url = this.getURL.split("?"),
            pnl = this.$results;

        if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
        var objXmlHttpHandler = function (obj) {
            var s = "";
            if (obj.responseXML != null) {
                var items = obj.responseXML.getElementsByTagName("result");             
                if (items.length > 0) {
                    
                    for (var i = 0; i < items.length; i++) {

                        var nd = items[i];
                        var id = nd.getAttribute("id") == null ? 0 : nd.getAttribute("id");
                        var title = nd.getAttribute("title") == null ? "" : nd.getAttribute("title");
                        var RelatedLinkID = nd.getAttribute("relatedLinkID") == null ? 0 : parseInt(nd.getAttribute("relatedLinkID"));
                        var navigateurl = nd.getAttribute("navigateurl") == null ? "" : nd.getAttribute("navigateurl");
                        var img = nd.getAttribute("img") == null ? "" : nd.getAttribute("img");

                        s += "<div class=\"i-row\"><a data-id=\"" + RelatedLinkID + "\" onclick=\"linkBacks.deleteClick(this);\"  title=\"Click to Remove This Link Back\" href=\"javascript:void(0);\" onmouseenter=\"iasp_ShowToolTip($(this));\" onmouseleave=\"iasp_HideToolTip($(this));\" class=\"article " + (RelatedLinkID > 0 ? "on" : "off") + "\"><span class=\"padding\"><i class=\"fa fa-check\"></i><span class=\"title\">";
                        if (img != "") {
                            s += "<img class=\"i-align-middle\" style=\"margin-right: 6px;\" src=\"" + img + "\"/>";
                        }

                        s += title + "</span>";
                        s += "</span></a>";

                        s += "<a class=\"i-btn i-btn-default\" target=\"_blank\" title=\"" + ibk_OpenInNewWindow + "\" href=\"" + navigateurl + "\" class=\"" + (RelatedLinkID > 0 ? "on" : "off") + "\" onmouseenter=\"iasp_ShowToolTip($(this));\" onmouseleave=\"iasp_HideToolTip($(this));\" data-position=\"left\"><span class=\"i-btn-bg\"></span><span>";
                        s += "<i class=\"fa fa-external-link\"></i>";
                        s += "</span></a></div>";

                    }
              
                } else {

                    s += "<div class=\"i-no-results\">";
                    s += "<i class=\"fa fa-link\"></i><br/>"
                    s += "<h2>No Link Backs</h2>";
                    s += "</div>";

                }
                             
                pnl.show()
                pnl.html(s);                    

            } else {

                s += "<div class=\"i-no-results\">";
                s += "<i class=\"fa fa-link\"></i><br/>"
                s += "<h2>No Link Backs</h2>";
                s += "</div>";

                pnl.show()
                pnl.html(s);
           

            }

            linkBacks.$loader.hide();

        };

        // setup params
        var strParams = url[1] + "&ArticleID=" + linkBacks.articleId;

        // make request
        this.XmlHttp.Connect(url[0], "GET", strParams, objXmlHttpHandler);

    },
    deleteClick: function (a) {

        var url = this.deleteURL.split("?"),
            a = $(a),
            id = parseInt(a.data("id"));

        if (!confirm(ikb_DeleteLinkBack)) {
            return false;
        }
   
        linkBacks.$results.hide();
        linkBacks.$loader.show();

        if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
        var objXmlHttpHandler = function (obj) {
            if (obj.responseXML != null) {
                var items = obj.responseXML.getElementsByTagName("result");
                if (items.length > 0) {
                    for (var i = 0; i < items.length; i++) {
                        var nd = items[i];
                        var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                        if (identity > 0) {
                            linkBacks.populate();
                        } else {
                            alert("problem adding related artixcle");
                        }
                    }
                }
            }
        };

        // setup params
        var strParams = url[1] + "&ArticleID=" + linkBacks.articleId + "&ID=" + id;

        // make request
        this.XmlHttp.Connect(url[0], "GET", strParams, objXmlHttpHandler);

    }  
}

/* ----------------------------------------------------------- */
// helper for all r.a.d editor controls
/* ----------------------------------------------------------- */

function Editor_OnClientLoad(editor, args) {
        
    // clear tab index on editor buttons
    var contentArea = editor.get_contentArea(),
        textArea = editor.get_textArea(),
        toolbar = $get(editor.get_id() + "Top"),
        buttons = toolbar.getElementsByTagName("A");
     
    if (buttons != null && typeof buttons != 'undefined') {
        for (var i = 0; i < buttons.length; i++) {
            var a = buttons[i];
            a.tabIndex = -1;
            a.tabStop = false;
        }
    }

    // ensures tabs are handled in a consistent manner between browsers
    var shortcutManager = editor.get_shortCutManager();
    if (shortcutManager) {
        if (shortcutManager.findShortCutByName("InsertTabMozilla")) {
            shortcutManager.removeShortCut("InsertTabMozilla");
            editor.addShortCut("InsertTab", "TAB");
        }
    }
    
    // add text area CSS
    if (textArea != null && typeof textArea != 'undefined') {        
        textArea.className = "i-text-area";
    }

    // ensure menus are hidden on mouse down within the editor
    if (contentArea != null && typeof contentArea != 'undefined') {    
        addEvent(contentArea, 'mousedown', function () {           
            iasp_HideAllMenus();     
        });   
    }
    
    editor.get_filtersManager().add(new TelerikFilter.KBFilter());
        
}

function Editor_OnClientPasteHtml(sender, args) {
    return;   
}

function doHelpSearch(searchURL, txt) {

    var txt = iasp_FindControl(txt);

    if (txt != null) {
        if (txt.value != "Enter Keywords..." && txt.value != "") {
            location = searchURL + "?Keywords=" + iasp_EncodeString(txt.value);
        } else {
            txt.focus();
            txt.value = "";
        }
    }
    return false;

}

function ikb_updateSplitterCookie(sender) { 
    iasp_SetCookie('tocWidth', sender.get_width());
    showSplitterTable(sender.get_splitter());
}

function showSplitterTable(splitter) {
    if ($telerik.isIE) {
        splitter.getContainerElement().style.position = 'static';
    }
}

// ------------------------------------
// custom content filter for Telerik editor
// ------------------------------------

var TelerikFilter = window.TelerikFilter = {};

TelerikFilter.KBFilter = function () {
    TelerikFilter.KBFilter.initializeBase(this);
    this.set_isDom(false);
    this.set_enabled(true);
    this.set_name("InstantASP filter");
    this.set_description("");
};

TelerikFilter.KBFilter.prototype = {
    getHtmlContent: function (s) {          
        return clearnEditorHtml(s);
    },
    getDesignContent: function (s) {          
        return clearnEditorHtml(s);
    } 
};

// parses all editor html to remove tags automatically added 
// by browsers when working with content within the editor, mainly 
// default font sizes, empty pages, non breaking spaces etc
// take care to ensure we don't remove any tags 
// that could impact custom formatting
function clearnEditorHtml(s) {
 
    o = /&nbsp;https:\/\/+/ig;
    while (s.match(o)) { s = s.replace(o, 'https://'); }

    o = /&nbsp;http:\/\/+/ig;
    while (s.match(o)) { s = s.replace(o, 'http://'); }
    
    o = /&nbsp;http:\/\/+/ig;
    while (s.match(o)) { s = s.replace(o, 'http://'); }
    
    o = /<div style="[^"]*">&nbsp;<\/div>+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }

    o = /<p style="[^"]*">&nbsp;<\/p>+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }
        
    var o = /\sstyle="font-size:\s13px;"+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }
    
    o = /\sstyle="font-size:\s13.3333px;"+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }

    o = /\sstyle="font-size:\s10pt;"+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }

    o = /font-size:\s13.3333px;+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }
      
    o = /font-size:\s10pt;+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }
    
    o = /<p\sstyle="padding:\s0px;">+/ig;
    while (s.match(o)) { s = s.replace(o, '<p>'); }
    
    o = /<span><\/span>+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }

    // replace line breaks to ensure further regex's match correctly
    o = /\n/ig;
    while (s.match(o)) { s = s.replace(o, '___LINEBRAKE___'); }
 
    o = /<span>(.+?)<\/span>+/ig;
    while (s.match(o)) { s = s.replace(o, '$1'); }

    o = /<div>&nbsp;<\/div>+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }
    
    o = /<a href="[^"]*"><\/a>+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }
    
    o = /<a href="[^"]*">___LINEBRAKE___<\/a>+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }

    o = /<strong><\/strong>+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }
    
    o = /\.&nbsp;+/ig;
    while (s.match(o)) { s = s.replace(o, '. '); }
       
    o = /&nbsp;Hi&nbsp;+/ig;
    while (s.match(o)) { s = s.replace(o, 'Hi '); }

    o = /Hi&nbsp;+/ig;
    while (s.match(o)) { s = s.replace(o, 'Hi '); }

    o = /<p>&nbsp;Hi\s+/ig;
    while (s.match(o)) { s = s.replace(o, '<p>Hi '); }
    
    o = /\.\s<\/p>+/ig;
    while (s.match(o)) { s = s.replace(o, '.</p>'); }

    o = /\.\s&nbsp;<\/p>+/ig;
    while (s.match(o)) { s = s.replace(o, '.</p>'); }
     
    o = /\,\s<\/p>+/ig;
    while (s.match(o)) { s = s.replace(o, ',</p>'); }

    o = /\,\s&nbsp;<\/p>+/ig;
    while (s.match(o)) { s = s.replace(o, ',</p>'); }

    o = /\,&nbsp;<\/p>+/ig;
    while (s.match(o)) { s = s.replace(o, ',</p>'); }

    o = /\.&nbsp;<\/p>+/ig;
    while (s.match(o)) { s = s.replace(o, '.</p>'); }

    o = /<p>&nbsp;<\/p>+/ig;
    while (s.match(o)) { s = s.replace(o, ''); }
    
    // add our line breaks back again
    o = /___LINEBRAKE___/ig;
    while (s.match(o)) { s = s.replace(o, '\n'); }

    return s;
}

// ------------------------------------

// flag ticket
function ikb_FlagTicket(icon, id, callbackurl) {
    if (icon == null) { return; }
    if (icon.className.toLowerCase().indexOf("fa-star-o") >= 0) {
        ikb_FlagTicketCallBack(icon, callbackurl, true, id)
    } else {
        ikb_FlagTicketCallBack(icon, callbackurl, false, id)
    }
}

function ikb_FlagTicketCallBack(icon, strCallBackURL, bolFlag, intTicketID) {
    
    var arrURL = strCallBackURL.split("?");
    
    var XmlHttp = new iasp_XmlHttpRequest();
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    // get result
                    var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                    // was everything ok
                    if (identity == 0) {
                        iasp_showAlert(null, ikb_CallBackError);
                    } else {                    
                        if (bolFlag) {
                            $(icon).removeClass("fa-star-o").addClass("fa-star");
                        } else {
                            $(icon).removeClass("fa-star").addClass("fa-star-o");
                        }

                    }

                    // end loader
                    iasp_AjaxExtensionsEndRequest();

                }
            }
        }
    };
     
    var intFlag = 0;
    if (bolFlag) { intFlag = 1; }
    var strParams = arrURL[1] + "&ID=" + intTicketID + "&Update=" + intFlag;
    iasp_AjaxExtensionsInitializeRequest();
    XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

// execute rule ( run rule now )
function ikb_ExecuteRule(callbackUrl, pageIndex, returnUrl) {
    
    iasp_AjaxExtensionsInitializeRequest();
    iasp_AjaxExtensionsLoaderSetText("Executing Rule");
    ikb_ExecuteRuleCakkBack(callbackUrl, pageIndex, returnUrl);

}

function ikb_ExecuteRuleCakkBack(callbackUrl, pageIndex, returnUrl) {

    // get url
    var arrURL = callbackUrl.split("?");
      
    var XmlHttp = new iasp_XmlHttpRequest(); 
    var objXmlHttpHandler = function (obj) {    
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");      
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    // get result
                    var continueExecution = nd.getAttribute("continue") == null ? 0 : parseInt(nd.getAttribute("continue"));                 
                    iasp_AjaxExtensionsLoaderSetText("Executing Rule - Page " + pageIndex);                  
                    // was everything ok
                    if (continueExecution == 1) {                        
                        ikb_ExecuteRuleCakkBack(callbackUrl, pageIndex += 1, returnUrl);
                    } else {
                        location = returnUrl;
                    }

                }
            }
        }
    };
    
    var strParams = arrURL[1] + "&PageIndex=" + pageIndex;
    XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

// mark user as spam via admin CP
function ikb_MarkUserAsSpam(strCallBackURL, isSpam, userID, btnID) {
    
    var arrURL = strCallBackURL.split("?");

    var  XmlHttp = new iasp_XmlHttpRequest(); 
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    // get result
                    var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                    // was everything ok
                    if (identity == 0) {                     
                        iasp_showAlert(null, ikb_CallBackError);
                    } else {
                        if (isSpam === 1) {                      
                            iasp_showAlert(null, "User Marked As Spam Successfully");
                        } else {                         
                            iasp_showAlert(null, "User Moved To Customers");
                        }                     
                        iasp_HideAllMenus();
                        if (btnID) {
                            var btn = iasp_FindControl(btnID);
                            if (btn) {
                                btn.click();
                            }
                        }                        
                    }                    
                    iasp_AjaxExtensionsEndRequest();
                }
            }
        }
    };

    var strParams = arrURL[1] + "&ID=" + userID + "&Update=" + isSpam;       
    iasp_AjaxExtensionsInitializeRequest();
    XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

// add / update contact list
function ikb_InsertUpdateMemberList(listName, callBackURL, success, err) {

    var arrURL = callBackURL.split("?");
 
    var XmlHttp = new iasp_XmlHttpRequest(); 
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];                  
                    var identity = nd.getAttribute("identity") == null ? 0 : parseInt(nd.getAttribute("identity"));              
                    if (identity == 0) {                
                        if (err != null) {
                            err(ikb_CallBackError)
                        }
                    }  else if (identity == -1) {                      
                        if (err != null) {
                            err(ikb_ListAlreadyExists)
                        }
                    } else {                        
                        if (success != null) {
                            success({
                                id: identity,
                                value: listName
                            });
                        }                     
                    }                
                }
            }
        }
    };

    var strParams = arrURL[1] + "&Key=" + encodeURIComponent(listName);       
    XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

// update ticket status or priority
function ikb_UpdateTicket(intTicketID, intIdentity, strButID, strCallBackURL, success) {
    
    var arrURL = strCallBackURL.split("?");

    var XmlHttp = new iasp_XmlHttpRequest(); 
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    // get result
                    var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                    // was everything OK
                    if (identity == 0) {
                        alert(errMsg);
                    } else {               
                        iasp_HideAllMenus();
                        if (strButID != null) {
                            iasp_FindControl(strButID).click();
                        }
                        if (success != null) {
                            success(nd);
                        }                        
                    }
                    // end loader
                    iasp_AjaxExtensionsEndRequest();
                }
            }
        }
    };
    
    var strParams = arrURL[1] + "&TicketID=" + intTicketID + "&ID=" + intIdentity;
    iasp_AjaxExtensionsInitializeRequest();  
    XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

/* auto complete helpers */
function Users_AuthCompletePopulated(sender, e) {
    var users = sender.get_completionList().childNodes;    
    for (var i = 0; i < users.length; i++) {
        var listItem = users[i];
        var text = listItem.firstChild.nodeValue;
        var values = listItem._value.split("|");
        var photo = values[0];
        var uid = values[1];
        var email = values[2];
        var channel = values[3];
        var tooltip = "";
        if (email != "") {
            tooltip = email;
        } else {
            tooltip = channel;
        }
        listItem.innerHTML = '<span class="i-photo i-photo-small i-align-middle i-margin-right"><img src="' + photo + '" /></span><span class="channel" style="display:none;">' + channel + '</span><span class="email" style="display:none;">' + email + '</span><span class="uid" style="display:none;">' + uid + '</span><span class="text">' + text + '</span><span class="i-type-light i-margin-left">' + tooltip + '</span>';
    }
}

function OnUserAutoCompleteSelected(source, eventArgs) {
    var idx = source._selectIndex;
    var users = source.get_completionList().childNodes;   
    var $item = $(users[idx]);
    var text = $item.find(".text").html();    
    source.get_element().value = text;

}

//  auto-complete user name selection when sending tickets
function OnNewTicketUserAutoCompleteSelected(source, eventArgs) {
      
    // get data from the auto-complete list about user
    var idx = source._selectIndex,
        users = source.get_completionList().childNodes,
        $item = $(users[idx]),
        text = $item.find(".text").html(),
        uid = $item.find(".uid").html(),
        img = $item.find("img").attr("src"),
        email = $item.find(".email").html(),
        channel = $item.find(".channel").html(),
        tooltip = (email != "" ? email : channel);
    
    var $txt = $(source.get_element()),
        layerID = $txt.data("recipientBox"); // holds placeholder ID of layer that shows your name once released
    $txt.val(uid);
    
    var $el = $("#" + layerID);
    $el.find(".username").html(text);
    $el.find(".email").html(tooltip);
    $el.find(".uid").html(uid);
    $el.find(".channel").html(channel);
    $el.find(".i-photo").find("img").attr("src", img);
    $el.show();
    $txt.hide().after($el);

    $el.trigger('show');

    // stop event propagation to ensure menus that contain the auto-complete control
    // stay open when an item is selected from the auto-complete list
    window.event.stopPropagation();
        
}

/* show / hide ticket details when viewing a ticket */
function toggleTicketDetails(a, selector) {    
    var $a = $(a)
    var $el = $(selector);
    if ($el.is(":visible")) {
        $el.hide();
        $a.find("i").removeClass("fa-caret-down").addClass("fa-caret-right");   
    } else {
        $el.show();
        $a.find("i").removeClass("fa-caret-right").addClass("fa-caret-down");
    }
}

/* ----------------------------------------------------------- */
/* rate articles  */
/* ----------------------------------------------------------- */

var articleRating = {    
    callbackURL: null,
    $wrapper: null, // $('.ikb-article-feedback')
    $pane1: null,
    $pane2: null,
    $thankYou: null,
    $back: null,
    $next: null,
    $comments: null,
    currentRating: 0,
    init: function () {

        this.$pane1 = this.$wrapper.find(".step-one"),
        this.$pane2 = this.$wrapper.find(".step-two");
        this.$back = this.$wrapper.find(".back");
        this.$next = this.$wrapper.find(".next");
        this.$comments = this.$wrapper.find(".comments");
        this.$thankYou = this.$wrapper.find(".thank-you");

        this.$comments.keyup(function () {
            if ($(this).val() != "") {
                $(this).removeClass("i-input-error");
            } else {
                $(this).addClass("i-input-error");
            }
            
        });

        this.$back.click(function () {
            if (!$(this).hasClass('disabled')) {
                articleRating.showPane1();
            }
        })

        this.$next.click(function () {
            if (!$(this).hasClass('disabled')) {
                if (!articleRating.$pane2.is(":visible")) {
                     articleRating.showPane2();
                } else {
                    if (articleRating.$comments.val().trim() != "") {
                        articleRating.saveRating(false);
                        articleRating.showThankYou();
                    } else {                    
                        articleRating.$comments.focus();
                        articleRating.$comments.addClass("i-input-error");
                    }                    
                }
               
            }
        })

    },
    ratingClick: function (a) {

        var $a = $(a);
        if ($a.data('rating') != '') {
            this.currentRating = parseInt($a.data('rating'));
        }
        this.$wrapper.find('.ratings').find('a').each(function () {
            $(this).removeClass('selected');
        });            
        if (!this.$pane2.is(":visible")) {
            this.showPane2();
        }

        this.saveRating(true);

    },
    showPane1: function() {
        this.$pane1.slideDown('fast');
        this.$pane2.slideUp('fast');
        this.$thankYou.hide();
        this.$back.addClass('disabled');
        this.$next.find("span").html(ikb_Next);
        this.$next.show();
        this.$comments.removeClass("i-input-error");
    },
    showPane2: function() {
        this.$pane1.slideUp('fast');
        this.$pane2.slideDown('fast');
        this.$back.removeClass('disabled');
        this.$thankYou.hide();
        this.$next.find("span").html(ikb_SendFeedback);
        this.$comments.focus();
        this.$comments.removeClass("i-input-error");
    },
    showThankYou: function () {
        this.$thankYou.slideDown('test');
        this.$pane2.slideUp('fast');        
        this.$next.hide();
        this.$wrapper.find('.ratings').find('a').each(function () {
            $(this).removeClass('selected');
        });
    },
    saveRating: function (showAlert) {

        var arrURL = this.callbackURL.split("?");       
        var XmlHttp = new iasp_XmlHttpRequest(); 
        var objXmlHttpHandler = function (obj) {
            if (obj.responseXML != null) {
                var items = obj.responseXML.getElementsByTagName("result");
                if (items.length > 0) {
                    for (var i = 0; i < items.length; i++) {
                        var nd = items[i];
                        // get result
                        var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                        if (showAlert) {                         
                            if (identity == 0) {
                                iasp_showAlert(null, ikb_RateSuccessUpdate);
                            } else {
                                iasp_showAlert(null, ikb_RateSuccess);
                            }
                        }
                    
                        articleRating.$comments.val('');
                     
                    }
                }
            }
        };

        var strParams = arrURL[1] + "&Key=" + encodeURIComponent(this.$comments.val()) + "&EnumValue=" + this.currentRating;        
        XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);
        
    }
}

/* ----------------------------------------------------------- */
/* client side polling helper (for notifications within agent CP) */
/* ----------------------------------------------------------- */

var instantkbPolling = new Object();

function InstantKBPolling(id) {

    this.id = id;
    this.timer = null;
    this.callBackUrl = null;
    this.interval = 30;
    this.XmlHttp = null;
    this.debug = false;
    this.success = function (message) { };
        
    if (instantkbPolling[id] != null) { 
        return instantkbPolling[id];
    } else {     
        instantkbPolling[id] = this;
    }
    return this;
}

InstantKBPolling.prototype.init = function () {
    this.startPolling();
}

InstantKBPolling.prototype.startPolling = function () {

    var interval = Math.floor(this.interval * 1000);
    if (this.debug) {
        console.log("interval: " + interval + " - " + this.id);
    }
    
    var self = this;
    if (this.timer == null) {
        this.timer = window.setInterval(function () {
            self.fetchResults(self);
        }, interval);
    }    

}

InstantKBPolling.prototype.stopPolling = function () {
    this.timer = null;
}

InstantKBPolling.prototype.fetchResults = function (self) {
       
    var arrURL = self.callBackUrl.split("?"); 
    if (self.debug) {
        console.log("start poll - " + self.id)
        console.log("url - " + self.callBackUrl)
    }
    if (!self.XmlHttp) { self.XmlHttp = new iasp_XmlHttpRequest(); }
    var handler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    var message = nd.getAttribute("message") == null ? "" : nd.getAttribute("message");
                    if (self.debug) {
                        console.log("end poll: " + message + " - " + self.id);
                    }                   
                    if (self.success != null) {
                        self.success(message);
                    }                   
                }
            }
        }
    };

    self.XmlHttp.Connect(arrURL[0], "GET", arrURL[1], handler);
}

/* ----------------------------------------------------------- */
/* responsive asides */
/* ----------------------------------------------------------- */

var responsiveAsides = {
    $container: null,
    $extra: null,
    $body: null,
    $a: null,
    direction: null,
    toggleMenu: function (a, containerId) {

        this.$container = $(containerId);
        this.$extra = this.$container.find(".responsive-asides-extra");
        this.$body = this.$container.find(".responsive-asides-body");
        this.$a = $(a);

        if (this.direction == null) {
            if (this.$a.find(".fa-chevron-right").length == 0) {
                this.direction = "right";
            } else {
                this.direction = "left";
            }
        }

        if (!this.$extra.data("visible") || this.$extra.data("visible") == "false") {
            this.showExtra();
        } else {
            this.showBody();
        }

    },
    showExtra: function () {
        if (this.direction == "left") {
            this.showExtraFromLeft();
        } else {
            this.showExtraFromRight();
        }
    },
    showBody: function () {
        if (this.direction == "left") {
            this.showBodyFromRight();
        } else {
            this.showBodyFromLeft();
        }
    },
    showExtraFromLeft: function () {

        var pnl = this.$container;
        var left = this.$extra;
        var right = this.$body;
        var a = this.$a;

        a.addClass("selected");
        if (this.direction == "left") {
            a.find("i").removeClass("fa-chevron-right").addClass("fa-chevron-left");
        } else {
            a.find("i").removeClass("fa-chevron-left").addClass("fa-chevron-right");
        }
        pnl.css({ "height": left.height(), })
        left.css({ "left": (-pnl.width()), "z-index": 1, "position": "absolute" });
        right.css({ "z-index": 10, "left": 0, "position": "absolute" });

        left.show().stop().animate({
            'left': 0
        }, {
            duration: 'fast', queue: true, complete: function () {

            }
        }, 'easeInOutExpo');

        right.stop().animate({
            'left': pnl.width()
        }, {
            duration: 'fast', queue: true, complete: function () {
                left.css({ "position": "relative" });
                right.css({ "display": "none", "left": 0, "position": "relative" });
                pnl.css({ "height": "auto" })
                left.data("visible", "true");

            }
        }, 'easeInOutExpo');

    },
    showExtraFromRight: function () {

        var pnl = this.$container;
        if (!pnl) { return; }

        var left = this.$extra;
        var right = this.$body;
        var a = this.$a;

        a.addClass("selected");
        if (this.direction == "left") {
            a.find("i").removeClass("fa-chevron-right").addClass("fa-chevron-left");
        } else {
            a.find("i").removeClass("fa-chevron-left").addClass("fa-chevron-right");
        }
        pnl.css({ "height": left.height() })
        left.css({ "left": (pnl.width()), "z-index": 0, "position": "absolute" });
        right.css({ "z-index": 0, "left": 0, "position": "absolute" });

        left.show().stop().animate({
            'left': 0
        }, {
            duration: 'fast', queue: true, complete: function () {

            }
        }, 'easeInOutExpo');

        right.stop().animate({
            'left': -pnl.width()
        }, {
            duration: 'fast', queue: true, complete: function () {
                left.css({ "position": "relative" });
                right.css({ "display": "none", "left": 0, "position": "relative" });
                pnl.css({ "height": "auto" })
                left.data("visible", "true");

            }
        }, 'easeInOutExpo');

    },
    showBodyFromLeft: function () {

        var pnl = this.$container;
        if (!pnl) { return; }

        var left = this.$extra;
        var right = this.$body;
        var a = this.$a;

        if (right.is(":visible")) { return; }

        if (a) {
            a.removeClass("selected");
            if (this.direction == "left") {
                a.find("i").removeClass("fa-chevron-left").addClass("fa-chevron-right");
            } else {
                a.find("i").removeClass("fa-chevron-right").addClass("fa-chevron-left");
            }
        }

        pnl.css({ "height": right.height() })
        left.css({ "z-index": 0, "display": "inline-block", "position": "absolute" });
        right.css({ "z-index": 0, "left": -right.width(), "display": "inline-block", "position": "absolute" });

        left.stop().animate({
            'left': (left.width())
        }, {
            duration: 'fast', queue: true, complete: function () {

            }
        }, 'easeInOutExpo');
        right.stop().animate({
            'left': 0
        }, {
            duration: 'fast', queue: true, complete: function () {
                left.css({ "display": "none", "left": 0, "position": "relative" });
                right.css({ "position": "relative" });
                pnl.css({ "height": "auto" })
                left.data("visible", "false");

            }
        }, 'easeInOutExpo');

    },
    showBodyFromRight: function () {

        var pnl = this.$container;
        var left = this.$extra;
        var right = this.$body;
        var a = this.$a;

        if (right.is(":visible")) { return; }

        if (a) {
            a.removeClass("selected");
            if (this.direction == "left") {
                a.find("i").removeClass("fa-chevron-left").addClass("fa-chevron-right");
            } else {
                a.find("i").removeClass("fa-chevron-right").addClass("fa-chevron-left");
            }
        }

        pnl.css({ "height": right.height() })
        left.css({ "z-index": 0, "display": "inline-block", "position": "absolute" });
        right.css({ "z-index": 0, "left": right.width(), "display": "inline-block", "position": "absolute" });

        left.stop().animate({
            'left': (-left.width())
        }, {
            duration: 'fast', queue: true, complete: function () {

            }
        }, 'easeInOutExpo');
        right.stop().animate({
            'left': 0
        }, {
            duration: 'fast', queue: true, complete: function () {
                left.css({ "display": "none", "left": 0, "position": "relative" });
                right.css({ "position": "relative" });
                pnl.css({ "height": "auto" })
                left.data("visible", "false");

            }
        }, 'easeInOutExpo');

    }
}

/* ----------------------------------------------------------- */
/* get Google+ & Gravtar profile photos  */
/* ----------------------------------------------------------- */

var socialPhotos = {
    getGooglePhoto: function (a, success) {
               
        var email = $(a).data("email");
        var url = "http://picasaweb.google.com/data/entry/api/user/" + email + "?alt=json";
        
        this.showLoader();
        $.ajax({
            url: url,
            cache: false,
            method: "get",
            dataType: "json",
            async: true,
            success: function (data) {             
                if (data != null) {
                    var thumbUrl = data.entry.gphoto$thumbnail.$t;
                    if (thumbUrl) {                 
                        socialPhotos.setSelection(thumbUrl);
                    } else {
                        iasp_showAlert(null, "Sorry. No social profile could be found");
                    }
                } else {
                    iasp_showAlert(null, "Sorry. No social profile could be found");
                }
                socialPhotos.hideLoader();
            },
            error: function (xhr, ajaxOptions, thrownError) {                
                socialPhotos.hideLoader();
                if (xhr.status == "0") {
                    iasp_showAlert(null, "Sorry. No social profile could be found");
                    return;
                }                 
                jAjax.handleCallBackError(xhr, thrownError);           
            }
        });
    },
    getGravatarPhoto: function (a, success) {

        var email = $(a).data("email");
        var url = $(a).data("url");

        this.showLoader();
        $.ajax({
            url: url,
            cache: false,
            method: "get",
            dataType: "xml",
            async: true,
            success: function (data) {           
                if (data != null) {
                    var thumbUrl = null;
                    var $xml = $(data);
                    var $result = $xml.find("result");
                    if ($result.length > 0) {
                        thumbUrl = $result.attr("url");
                    }                             
                    if (thumbUrl) {                        
                        socialPhotos.setSelection(thumbUrl);
                    } else {
                        iasp_showAlert(null, "Sorry. No social profile could be found");
                    }
                } else {
                    iasp_showAlert(null, "Sorry. No social profile could be found");
                }
                socialPhotos.hideLoader();
            },
            error: function (xhr, ajaxOptions, thrownError) {
                socialPhotos.hideLoader();
                if (xhr.status == "0") {
                    iasp_showAlert(null, "Sorry. No social profile could be found");
                    return;
                }
                jAjax.handleCallBackError(xhr, thrownError);
            }
        });
    },
    showLoader: function () {
        $(".i-loader-overlay").show();
    },
    hideLoader: function () {
        $(".i-loader-overlay").hide();
    },
    setSelection:function(imageUrl) {
        var input = $(".ikb-social-photo-input");
        var img = $(".ikb-social-photo-img");
        input.val(imageUrl);
        img.attr("src", imageUrl);
        $("#useSocialPhoto").show();
        $("#selectSocialPhoto").hide();
    },
    cancelSelection: function () {        
        $("#useSocialPhoto").hide();
        $("#selectSocialPhoto").show();
    }
}

/* ----------------------------------------------------------- */
/* doc readt  */
/* ----------------------------------------------------------- */

$(document).ready(function () {

    // register custom content filter for RadEditor 
    // once to use within all editor instances
    if (Sys) { // ensure .NET client side has loaded
        if (typeof Telerik != 'undefined' && typeof Telerik.Web.UI.Editor != 'undefined') {
            if (Sys.__registeredTypes['TelerikFilter.KBFilter'] == null) {
                TelerikFilter.KBFilter.registerClass('TelerikFilter.KBFilter', Telerik.Web.UI.Editor.Filter);
            }
        }       
    }
    /* mobile bread-crumb */
    $(".bc ul").find("li.last").find("a").bind("click", function () {

        if ($(window).width() < 1024) {

            var menu = $(".bc-menu");
            if (menu.length == 0) {

                // close button
                var close = $('<a href="javascript:void(0);">');
                close.addClass("btn");
                close.append($('<i class="fa fa-times">'));
                close.bind("click", function () {
                    $(".bc-menu").stop().animate({
                        'left': "-230px"
                    }, 150, 'easeInOutExpo', function () {

                    });
                });

                // header
                var header = $('<div class="i-row bc-menu-header">');
                header.append(close);

                // menu
                menu = $('<div class="i-row">');
                menu.addClass("bc-menu");
                menu.css({ "left": "-230px" })

                // add
                menu.append(header);
                menu.append($(".bc").find("ul").clone())
                $("body").append(menu);

                menu.stop().animate({
                    'left': "0px"
                }, 150, 'easeInOutExpo', function () {

                });

            } else {

                if (menu.css("left") == "-230px") {
                    menu.stop().animate({
                        'left': "0px"
                    }, 150, 'easeInOutExpo', function () {

                    });
                } else {
                    menu.stop().animate({
                        'left': "-230px"
                    }, 150, 'easeInOutExpo', function () {

                    });
                }
            }

            return false;

        } else {
            return true;
        }
    });
});
