﻿"use strict";

/* social counts */
(function (win, doc, $) {

    var $loadingIndicator,
		$count;

    function featureTest(prop, unprefixedProp) {
        var style = doc.createElement('social').style,
			prefixes = 'webkit Moz o ms'.split(' ');

        if (unprefixedProp in style) {
            return true;
        }
        for (var j = 0, k = prefixes.length; j < k; j++) {
            if ((prefixes[j] + prop) in style) {
                return true;
            }
        }
        return false;
    }

    function removeFileName(src) {
        var split = src.split('/');
        split.pop();
        return split.join('/') + '/';
    }

    function resolveServiceDir() {
        var baseUrl;

        $('script').each(function () {
            var src = this.src || '',
				dir;
            if (src.match(SocialCount.scriptSrcRegex)) {
                baseUrl = removeFileName(src);
                return false;
            }
        });

        return baseUrl;
    }

    var SocialCount = {
        // For A-grade experience, require querySelector (IE8+) and not BlackBerry or touchscreen
        isGradeA: 'querySelectorAll' in doc && !win.blackberry && !('ontouchstart' in window) &&
			// Note that this feature test does not account for the Windows Phone version that includes IE9
			// IE 10 desktop (non-touch) returns 0 for msMaxTouchPoints
			(typeof window.navigator.msMaxTouchPoints === 'undefined' || window.navigator.msMaxTouchPoints === 0),
        minCount: 1,
        serviceUrl: 'service/index.php',
        initSelector: '.ikb-social-links',
        classes: {
            js: 'js',
            gradeA: 'grade-a',
            active: 'active',
            touch: 'touch',
            hover: 'hover',
            noTransforms: 'no-transforms',
            showCounts: 'counts',
            countContent: 'count',
            minCount: 'minimum',
            activateOnHover: 'activate-on-hover',
            activateOnClick: 'activate-on-click'
        },
        thousandCharacter: 'K',
        millionCharacter: 'M',
        missingResultText: '-',
        activateOnClick: false, // default is hover
        selectors: {
            facebook: '.facebook',
            twitter: '.twitter',
            googleplus: '.googleplus'
        },
        locale: (function () {
            var locale = doc.documentElement ? (doc.documentElement.lang || '') : '';
            locale = locale.replace(/\-/, '_');
            return locale.match(/\w{2}_\w{2}/) ? locale : '';
        })(),
        googleplusTooltip: 'table.gc-bubbleDefault',
        scriptSrcRegex: /socialcount[\w.]*.js/i,
        plugins: {
            init: [],
            bind: []
        },

        // private, but for testing
        cache: {},

        removeFileName: removeFileName,
        resolveServiceDir: resolveServiceDir,

        isCssAnimations: function () {
            return featureTest('AnimationName', 'animationName');
        },
        isCssTransforms: function () {
            return featureTest('Transform', 'transform');
        },
        getUrl: function ($el) {
            return $el.attr('data-url') || location.href;
        },
        // Currently only available on Twitter
        getShareText: function ($el) {
            return $el.attr('data-share-text') || '';
        },
        getFacebookAction: function ($el) {
            return ($el.attr('data-facebook-action') || 'like').toLowerCase();
        },
        isCountsEnabled: function ($el) {
            return $el.attr('data-counts') === 'true';
        },
        isSmallSize: function ($el) {
            return $el.is('.socialcount-small');
        },
        getCounts: function ($el, url) {
            var map = SocialCount.selectors,
				cache = SocialCount.cache,
				counts = {},
				$networkNode,
				$countNode,
				j;

            for (j in map) {
                $networkNode = $el.find(map[j]);
                $countNode = $networkNode.find('.' + SocialCount.classes.countContent);

                if ($countNode.length) {
                    counts[j] = $countNode;
                } else {
                    counts[j] = $count.clone();
                    $networkNode.append(counts[j]);
                }
            }

            if (!cache[url]) {
                cache[url] = $.ajax({
                    url: resolveServiceDir() + SocialCount.serviceUrl,
                    data: {
                        url: url
                    },
                    dataType: 'json'
                });
            }

            cache[url].done(function complete(data) {
                for (var j in data) {
                    if (data.hasOwnProperty(j)) {
                        if (counts[j] && data[j] > SocialCount.minCount) {
                            counts[j].addClass(SocialCount.classes.minCount)
								.html(SocialCount.normalizeCount(data[j]));
                        }
                    }
                }
            });

            return cache[url];
        },
        init: function ($el) {
            var facebookAction = SocialCount.getFacebookAction($el),
				classes = [facebookAction],
				isSmall = SocialCount.isSmallSize($el),
				url = SocialCount.getUrl($el),
				initPlugins = SocialCount.plugins.init,
				countsEnabled = SocialCount.isCountsEnabled($el);

            classes.push(SocialCount.classes.js);

            if (SocialCount.isGradeA) {
                classes.push(SocialCount.classes.gradeA);
            }
            if (!SocialCount.isCssTransforms()) {
                classes.push(SocialCount.classes.noTransforms);
            }
            if (countsEnabled) {
                classes.push(SocialCount.classes.showCounts);
            }
            if (SocialCount.activateOnClick) {
                classes.push(SocialCount.classes.activateOnClick);
            } else {
                classes.push(SocialCount.classes.activateOnHover);
            }
            if (SocialCount.locale) {
                classes.push(SocialCount.locale);
            }
            $el.addClass(classes.join(' '));

            for (var j = 0, k = initPlugins.length; j < k; j++) {
                initPlugins[j].call($el);
            }

            if (SocialCount.isGradeA) {
                SocialCount.bindEvents($el, url, facebookAction, isSmall);
            }

            if (countsEnabled && !isSmall) {
                SocialCount.getCounts($el, url);
            }
        },
        normalizeCount: function (count) {
            if (!count && count !== 0) {
                return SocialCount.missingResultText;
            }
            // > 1M
            if (count >= 1000000) {
                return Math.floor(count / 1000000) + SocialCount.millionCharacter;
            }
            // > 100K
            if (count >= 100000) {
                return Math.floor(count / 1000) + SocialCount.thousandCharacter;
            }
            if (count > 1000) {
                return (count / 1000).toFixed(1).replace(/\.0/, '') + SocialCount.thousandCharacter;
            }
            return count;
        },
        bindEvents: function ($el, url, facebookAction, isSmall) {
            
            function bind($a, html, jsUrl) {
                // IE bug (tested up to version 9) with :hover rules and iframes.
                var isTooltipActive = false,
					isHoverActive = false;

                $a.closest('li.counter').bind('mouseenter', function (event) {
                    var $li = $(this).closest('li');
                    $li.addClass(SocialCount.classes.hover);
                    isHoverActive = true;
                    $(document).on('mouseenter.socialcount mouseleave.socialcount', SocialCount.googleplusTooltip, function (event) {
                        isTooltipActive = event.type == 'mouseenter';
                        if (!isTooltipActive && !isHoverActive) {
                            $li.removeClass(SocialCount.classes.hover);
                        }
                    });
                }).bind('mouseleave', function (event) {
                    var self = this;
                    window.setTimeout(function () {
                        isHoverActive = false;

                        if (!isTooltipActive && !isHoverActive) {
                            $(document).off('.socialcount');
                            $(self).closest('li').removeClass(SocialCount.classes.hover);
                        }
                    }, 0);
                });

                $a.one(SocialCount.activateOnClick ? 'click' : 'mouseover', function (event) {
                    if (SocialCount.activateOnClick) {
                        event.preventDefault();
                        event.stopPropagation();
                    }

                    var $self = $(this),
						$parent = $self.closest('li'),
						$loading = $loadingIndicator.clone(),
						$content = $(html),
						$button = $('<div class="button"/>').append($content),
						js,
						$iframe,
						deferred = $.Deferred();

                    deferred.promise().always(function () {
                        // Remove Loader
                        var $iframe = $parent.find('iframe');

                        if ($iframe.length) {
                            $iframe.bind('load', function () {
                                $loading.remove();
                            });
                        } else {
                            $loading.remove();
                        }
                    });

                    $parent
						.addClass(SocialCount.classes.active)
						.append($loading)
						.append($button);

                    if (jsUrl) {
                        js = doc.createElement('script');
                        js.src = jsUrl;
                                               
                        // IE8 doesn't do script onload.
                        if (js.attachEvent) {
                            js.attachEvent('onreadystatechange', function () {
                                if (js.readyState === 'loaded' || js.readyState === 'complete') {
                                    deferred.resolve();
                                }
                            });
                        } else {
                            $(js).bind('load', deferred.resolve);
                        }

                        doc.body.appendChild(js);
                    } else if ($content.is('iframe')) {
                        deferred.resolve();
                    }
                });
            } // end bind()

            if (!isSmall) {
                           
                var shareText = SocialCount.getShareText($el);

                bind($el.find(SocialCount.selectors.facebook + ' a'),
					'<iframe src="//www.facebook.com/plugins/like.php?href=' + encodeURIComponent(url) +
						(SocialCount.locale ? '&locale=' + SocialCount.locale : '') +
						'&amp;send=false&amp;layout=button_count&amp;width=100&amp;show_faces=true&amp;action=' + facebookAction +
						'&amp;colorscheme=light&amp;font=arial&amp;height=21" scrolling="no" frameborder="0" style="border:none; overflow:hidden;" allowTransparency="true"></iframe>');

                bind($el.find(SocialCount.selectors.twitter + ' a'),
					 '<a href="https://twitter.com/share" class="twitter-share-button"' +
						' data-url="' + encodeURIComponent(url) + '"' +
						(shareText ? ' data-text="' + shareText + '"' : '') +
						' data-count="none" data-dnt="true">Tweet</a>',
					'//platform.twitter.com/widgets.js');

                bind($el.find(SocialCount.selectors.googleplus + ' a'),
					'<div class="g-plusone" data-size="medium" data-annotation="none"></div>',
					'//apis.google.com/js/plusone.js');
            }

            // Bind events on other non-stock widgets, like sharethis
            var bindPlugins = SocialCount.plugins.bind;
            for (var j = 0, k = bindPlugins.length; j < k; j++) {
                bindPlugins[j].call($el, bind, url, isSmall);
            }
        } // end bindEvents()
    };

    $(function () {
        // Thanks to http://codepen.io/ericmatthys/pen/FfcEL
        $loadingIndicator = $('<div>')
			.addClass('loading')
			.html(SocialCount.isCssAnimations() ? new Array(4).join('<div class="dot"></div>') : 'Loading');

        $count = $('<span>')
			.addClass(SocialCount.classes.countContent)
			.html('&#160;');

        $(SocialCount.initSelector).each(function () {
            var $el = $(this);
            SocialCount.init($el);
        });

        $(doc).ready(function () {
            $(SocialCount.initSelector).find("li").each(function () {
                $(this).animate({ "margin-left": 0 }, { duration: 350 });
            });
        });
    });

    window.SocialCount = SocialCount;

}(window, window.document, jQuery));

/* shake effect */
(function ($) {
    $.fn.shake = function (steps, duration, amount, vertical) {
        var s = steps || 3;
        var d = duration || 120;
        var a = amount || 5;
        var v = vertical || false;

        var cur = parseInt(this.css(v ? "top" : "left"), 10);
        if (isNaN(cur))
            cur = 0;

        var ds = d / s;

        if (v) {
            for (i = 0; i < s; i++)
                this.animate({ "top": cur + a + "px" }, ds).animate({ "top": cur - a + "px" }, ds);
            this.animate({ "top": cur }, 20);
        }
        else {
            for (i = 0; i < s; i++)
                this.animate({ "left": cur + a }, ds).animate({ "left": cur - a + "px" }, ds);
            this.animate({ "left": cur }, 20);
        }

        return this;
    }
})(jQuery);

/* color picker */
(function ($) {
    var ColorPicker = function () {
        var
			ids = {},
			inAction,
			charMin = 65,
			visible,
			tpl = '<div unselectable="on" class="i-color-picker"><div unselectable="on" class="i-color-picker-color"><div unselectable="on"><div></div></div></div><div unselectable="on" class="i-color-picker-hue"><div></div></div><div unselectable="on" class="i-color-picker-new-color"></div><div unselectable="on" class="i-color-picker-current-color"></div><div unselectable="on" class="i-color-picker-hex"><input type="text" maxlength="6" size="6" /></div><div unselectable="on" class="i-color-picker-rgb-r i-color-picker-field"><input type="text" maxlength="3" size="3" /><span></span></div><div unselectable="on" class="i-color-picker-rgb-g i-color-picker-field"><input type="text" maxlength="3" size="3" /><span></span></div><div unselectable="on" class="i-color-picker-rgb-b i-color-picker-field"><input type="text" maxlength="3" size="3" /><span></span></div><div unselectable="on" class="i-color-picker-hsb-h i-color-picker-field"><input type="text" maxlength="3" size="3" /><span unselectable="on"></span></div><div unselectable="on" class="i-color-picker-hsb-s i-color-picker-field"><input type="text" maxlength="3" size="3" /><span unselectable="on"></span></div><div unselectable="on" class="i-color-picker-hsb-b i-color-picker-field"><input type="text" maxlength="3" size="3" /><span unselectable="on"></span></div><div unselectable="on" class="i-color-picker-submit"></div></div>',
			defaults = {
			    eventName: 'click',
			    onShow: function () { },
			    onBeforeShow: function () { },
			    onHide: function () { },
			    onChange: function () { },
			    onSubmit: function () { },
			    color: 'ff0000',
			    livePreview: true,
			    flat: false
			},
			fillRGBFields = function (hsb, cal) {
			    var rgb = HSBToRGB(hsb);
			    $(cal).data('colorpicker').fields
					.eq(1).val(rgb.r).end()
					.eq(2).val(rgb.g).end()
					.eq(3).val(rgb.b).end();
			},
			fillHSBFields = function (hsb, cal) {
			    $(cal).data('colorpicker').fields
					.eq(4).val(hsb.h).end()
					.eq(5).val(hsb.s).end()
					.eq(6).val(hsb.b).end();
			},
			fillHexFields = function (hsb, cal) {
			    $(cal).data('colorpicker').fields
					.eq(0).val(HSBToHex(hsb)).end();
			},
			setSelector = function (hsb, cal) {
			    $(cal).data('colorpicker').selector.css('backgroundColor', '#' + HSBToHex({ h: hsb.h, s: 100, b: 100 }));
			    $(cal).data('colorpicker').selectorIndic.css({
			        left: parseInt(150 * hsb.s / 100, 10),
			        top: parseInt(150 * (100 - hsb.b) / 100, 10)
			    });
			},
			setHue = function (hsb, cal) {
			    $(cal).data('colorpicker').hue.css('top', parseInt(150 - 150 * hsb.h / 360, 10));
			},
			setCurrentColor = function (hsb, cal) {
			    $(cal).data('colorpicker').currentColor.css('backgroundColor', '#' + HSBToHex(hsb));
			},
			setNewColor = function (hsb, cal) {
			    $(cal).data('colorpicker').newColor.css('backgroundColor', '#' + HSBToHex(hsb));
			},
			keyDown = function (ev) {
			    var pressedKey = ev.charCode || ev.keyCode || -1;
			    if ((pressedKey > charMin && pressedKey <= 90) || pressedKey == 32) {
			        return false;
			    }
			    var cal = $(this).parent().parent();
			    if (cal.data('colorpicker').livePreview === true) {
			        change.apply(this);
			    }
			},
			change = function (ev) {
			    var cal = $(this).parent().parent(), col;
			    if (this.parentNode.className.indexOf('-hex') > 0) {
			        cal.data('colorpicker').color = col = HexToHSB(fixHex(this.value));
			    } else if (this.parentNode.className.indexOf('-hsb') > 0) {
			        cal.data('colorpicker').color = col = fixHSB({
			            h: parseInt(cal.data('colorpicker').fields.eq(4).val(), 10),
			            s: parseInt(cal.data('colorpicker').fields.eq(5).val(), 10),
			            b: parseInt(cal.data('colorpicker').fields.eq(6).val(), 10)
			        });
			    } else {
			        cal.data('colorpicker').color = col = RGBToHSB(fixRGB({
			            r: parseInt(cal.data('colorpicker').fields.eq(1).val(), 10),
			            g: parseInt(cal.data('colorpicker').fields.eq(2).val(), 10),
			            b: parseInt(cal.data('colorpicker').fields.eq(3).val(), 10)
			        }));
			    }
			    if (ev) {
			        fillRGBFields(col, cal.get(0));
			        fillHexFields(col, cal.get(0));
			        fillHSBFields(col, cal.get(0));
			    }
			    setSelector(col, cal.get(0));
			    setHue(col, cal.get(0));
			    setNewColor(col, cal.get(0));
			    cal.data('colorpicker').onChange.apply(cal, [col, HSBToHex(col), HSBToRGB(col)]);
			},
			blur = function (ev) {
			    var cal = $(this).parent().parent();
			    cal.data('colorpicker').fields.parent().removeClass('i-color-picker-focus');
			},
			focus = function () {
			    charMin = this.parentNode.className.indexOf('-hex') > 0 ? 70 : 65;
			    $(this).parent().parent().data('colorpicker').fields.parent().removeClass('i-color-picker-focus');
			    $(this).parent().addClass('i-color-picker-focus');
			},
			downIncrement = function (ev) {
			    var field = $(this).parent().find('input').focus();
			    var current = {
			        el: $(this).parent().addClass('i-color-picker-slider'),
			        max: this.parentNode.className.indexOf('-hsb-h') > 0 ? 360 : (this.parentNode.className.indexOf('-hsb') > 0 ? 100 : 255),
			        y: ev.pageY,
			        field: field,
			        val: parseInt(field.val(), 10),
			        preview: $(this).parent().parent().data('colorpicker').livePreview
			    };
			    $(document).bind('mouseup', current, upIncrement);
			    $(document).bind('mousemove', current, moveIncrement);
			},
			moveIncrement = function (ev) {
			    ev.data.field.val(Math.max(0, Math.min(ev.data.max, parseInt(ev.data.val + ev.pageY - ev.data.y, 10))));
			    if (ev.data.preview) {
			        change.apply(ev.data.field.get(0), [true]);
			    }
			    return false;
			},
			upIncrement = function (ev) {
			    change.apply(ev.data.field.get(0), [true]);
			    ev.data.el.removeClass('i-color-picker-slider').find('input').focus();
			    $(document).unbind('mouseup', upIncrement);
			    $(document).unbind('mousemove', moveIncrement);
			    return false;
			},
			downHue = function (ev) {
			    var current = {
			        cal: $(this).parent(),
			        y: $(this).offset().top
			    };
			    current.preview = current.cal.data('colorpicker').livePreview;
			    $(document).bind('mouseup', current, upHue);
			    $(document).bind('mousemove', current, moveHue);
			},
			moveHue = function (ev) {
			    change.apply(
					ev.data.cal.data('colorpicker')
						.fields
						.eq(4)
						.val(parseInt(360 * (150 - Math.max(0, Math.min(150, (ev.pageY - ev.data.y)))) / 150, 10))
						.get(0),
					[ev.data.preview]
				);
			    return false;
			},
			upHue = function (ev) {
			    fillRGBFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));
			    fillHexFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));
			    $(document).unbind('mouseup', upHue);
			    $(document).unbind('mousemove', moveHue);
			    return false;
			},
			downSelector = function (ev) {
			    var current = {
			        cal: $(this).parent(),
			        pos: $(this).offset()
			    };
			    current.preview = current.cal.data('colorpicker').livePreview;
			    $(document).bind('mouseup', current, upSelector);
			    $(document).bind('mousemove', current, moveSelector);
			},
			moveSelector = function (ev) {
			    change.apply(
					ev.data.cal.data('colorpicker')
						.fields
						.eq(6)
						.val(parseInt(100 * (150 - Math.max(0, Math.min(150, (ev.pageY - ev.data.pos.top)))) / 150, 10))
						.end()
						.eq(5)
						.val(parseInt(100 * (Math.max(0, Math.min(150, (ev.pageX - ev.data.pos.left)))) / 150, 10))
						.get(0),
					[ev.data.preview]
				);
			    return false;
			},
			upSelector = function (ev) {
			    fillRGBFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));
			    fillHexFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));
			    $(document).unbind('mouseup', upSelector);
			    $(document).unbind('mousemove', moveSelector);
			    return false;
			},
			enterSubmit = function (ev) {
			    $(this).addClass('i-color-picker-focus');
			},
			leaveSubmit = function (ev) {
			    $(this).removeClass('i-color-picker-focus');
			},
			clickSubmit = function (ev) {
			    var cal = $(this).parent();
			    var col = cal.data('colorpicker').color;
			    cal.data('colorpicker').origColor = col;
			    setCurrentColor(col, cal.get(0));
			    cal.data('colorpicker').onSubmit(col, HSBToHex(col), HSBToRGB(col), cal.data('colorpicker').el);
			},
			show = function (ev) {
			    var cal = $('#' + $(this).data('colorpickerId'));
			    cal.data('colorpicker').onBeforeShow.apply(this, [cal.get(0)]);
			    var pos = $(this).offset();
			    var viewPort = getViewport();
			    var top = pos.top + this.offsetHeight;
			    var left = pos.left;
			    if (top + 176 > viewPort.t + viewPort.h) {
			        top -= this.offsetHeight + 176;
			    }
			    if (left + 356 > viewPort.l + viewPort.w) {
			        left -= 356;
			    }
			    cal.css({ left: left + 'px', top: top + 'px' });
			    if (cal.data('colorpicker').onShow.apply(this, [cal.get(0)]) != false) {
			        cal.show();
			    }
			    $(document).bind('mousedown', { cal: cal }, hide);
			    return false;
			},
			hide = function (ev) {
			    if (!isChildOf(ev.data.cal.get(0), ev.target, ev.data.cal.get(0))) {
			        if (ev.data.cal.data('colorpicker').onHide.apply(this, [ev.data.cal.get(0)]) != false) {
			            ev.data.cal.hide();
			        }
			        $(document).unbind('mousedown', hide);
			    }
			},
			isChildOf = function (parentEl, el, container) {
			    if (parentEl == el) {
			        return true;
			    }
			    if (parentEl.contains) {
			        return parentEl.contains(el);
			    }
			    if (parentEl.compareDocumentPosition) {
			        return !!(parentEl.compareDocumentPosition(el) & 16);
			    }
			    var prEl = el.parentNode;
			    while (prEl && prEl != container) {
			        if (prEl == parentEl)
			            return true;
			        prEl = prEl.parentNode;
			    }
			    return false;
			},
			getViewport = function () {
			    var m = document.compatMode == 'CSS1Compat';
			    return {
			        l: window.pageXOffset || (m ? document.documentElement.scrollLeft : document.body.scrollLeft),
			        t: window.pageYOffset || (m ? document.documentElement.scrollTop : document.body.scrollTop),
			        w: window.innerWidth || (m ? document.documentElement.clientWidth : document.body.clientWidth),
			        h: window.innerHeight || (m ? document.documentElement.clientHeight : document.body.clientHeight)
			    };
			},
			fixHSB = function (hsb) {
			    return {
			        h: Math.min(360, Math.max(0, hsb.h)),
			        s: Math.min(100, Math.max(0, hsb.s)),
			        b: Math.min(100, Math.max(0, hsb.b))
			    };
			},
			fixRGB = function (rgb) {
			    return {
			        r: Math.min(255, Math.max(0, rgb.r)),
			        g: Math.min(255, Math.max(0, rgb.g)),
			        b: Math.min(255, Math.max(0, rgb.b))
			    };
			},
			fixHex = function (hex) {
			    var len = 6 - hex.length;
			    if (len > 0) {
			        var o = [];
			        for (var i = 0; i < len; i++) {
			            o.push('0');
			        }
			        o.push(hex);
			        hex = o.join('');
			    }
			    return hex;
			},
			HexToRGB = function (hex) {
			    var hex = parseInt(((hex.indexOf('#') > -1) ? hex.substring(1) : hex), 16);
			    return { r: hex >> 16, g: (hex & 0x00FF00) >> 8, b: (hex & 0x0000FF) };
			},
			HexToHSB = function (hex) {
			    return RGBToHSB(HexToRGB(hex));
			},
			RGBToHSB = function (rgb) {
			    var hsb = {
			        h: 0,
			        s: 0,
			        b: 0
			    };
			    var min = Math.min(rgb.r, rgb.g, rgb.b);
			    var max = Math.max(rgb.r, rgb.g, rgb.b);
			    var delta = max - min;
			    hsb.b = max;
			    if (max != 0) {

			    }
			    hsb.s = max != 0 ? 255 * delta / max : 0;
			    if (hsb.s != 0) {
			        if (rgb.r == max) {
			            hsb.h = (rgb.g - rgb.b) / delta;
			        } else if (rgb.g == max) {
			            hsb.h = 2 + (rgb.b - rgb.r) / delta;
			        } else {
			            hsb.h = 4 + (rgb.r - rgb.g) / delta;
			        }
			    } else {
			        hsb.h = -1;
			    }
			    hsb.h *= 60;
			    if (hsb.h < 0) {
			        hsb.h += 360;
			    }
			    hsb.s *= 100 / 255;
			    hsb.b *= 100 / 255;
			    return hsb;
			},
			HSBToRGB = function (hsb) {
			    var rgb = {};
			    var h = Math.round(hsb.h);
			    var s = Math.round(hsb.s * 255 / 100);
			    var v = Math.round(hsb.b * 255 / 100);
			    if (s == 0) {
			        rgb.r = rgb.g = rgb.b = v;
			    } else {
			        var t1 = v;
			        var t2 = (255 - s) * v / 255;
			        var t3 = (t1 - t2) * (h % 60) / 60;
			        if (h == 360) h = 0;
			        if (h < 60) { rgb.r = t1; rgb.b = t2; rgb.g = t2 + t3 }
			        else if (h < 120) { rgb.g = t1; rgb.b = t2; rgb.r = t1 - t3 }
			        else if (h < 180) { rgb.g = t1; rgb.r = t2; rgb.b = t2 + t3 }
			        else if (h < 240) { rgb.b = t1; rgb.r = t2; rgb.g = t1 - t3 }
			        else if (h < 300) { rgb.b = t1; rgb.g = t2; rgb.r = t2 + t3 }
			        else if (h < 360) { rgb.r = t1; rgb.g = t2; rgb.b = t1 - t3 }
			        else { rgb.r = 0; rgb.g = 0; rgb.b = 0 }
			    }
			    return { r: Math.round(rgb.r), g: Math.round(rgb.g), b: Math.round(rgb.b) };
			},
			RGBToHex = function (rgb) {
			    var hex = [
					rgb.r.toString(16),
					rgb.g.toString(16),
					rgb.b.toString(16)
			    ];
			    $.each(hex, function (nr, val) {
			        if (val.length == 1) {
			            hex[nr] = '0' + val;
			        }
			    });
			    return hex.join('');
			},
			HSBToHex = function (hsb) {
			    return RGBToHex(HSBToRGB(hsb));
			},
			restoreOriginal = function () {
			    var cal = $(this).parent();
			    var col = cal.data('colorpicker').origColor;
			    cal.data('colorpicker').color = col;
			    fillRGBFields(col, cal.get(0));
			    fillHexFields(col, cal.get(0));
			    fillHSBFields(col, cal.get(0));
			    setSelector(col, cal.get(0));
			    setHue(col, cal.get(0));
			    setNewColor(col, cal.get(0));
			};
        return {
            init: function (opt) {
                opt = $.extend({}, defaults, opt || {});
                if (typeof opt.color == 'string') {
                    opt.color = HexToHSB(opt.color);
                } else if (opt.color.r != undefined && opt.color.g != undefined && opt.color.b != undefined) {
                    opt.color = RGBToHSB(opt.color);
                } else if (opt.color.h != undefined && opt.color.s != undefined && opt.color.b != undefined) {
                    opt.color = fixHSB(opt.color);
                } else {
                    return this;
                }
                return this.each(function () {
                    if (!$(this).data('colorpickerId')) {
                        var options = $.extend({}, opt);
                        options.origColor = opt.color;
                        var id = 'collorpicker_' + parseInt(Math.random() * 1000);
                        $(this).data('colorpickerId', id);
                        var cal = $(tpl).attr('id', id);
                        if (options.flat) {
                            cal.appendTo(this).show();
                        } else {
                            cal.appendTo(document.body);
                        }
                        options.fields = cal
											.find('input')
												.bind('keyup', keyDown)
												.bind('change', change)
												.bind('blur', blur)
												.bind('focus', focus);
                        cal
							.find('span').bind('mousedown', downIncrement).end()
							.find('>div.i-color-picker-current-color').bind('click', restoreOriginal);
                        options.selector = cal.find('div.i-color-picker-color').bind('mousedown', downSelector);
                        options.selectorIndic = options.selector.find('div div');
                        options.el = this;
                        options.hue = cal.find('div.i-color-picker-hue div');
                        cal.find('div.i-color-picker-hue').bind('mousedown', downHue);
                        options.newColor = cal.find('div.i-color-picker-new-color');
                        options.currentColor = cal.find('div.i-color-picker-current-color');
                        cal.data('colorpicker', options);
                        cal.find('div.i-color-picker-submit')
							.bind('mouseenter', enterSubmit)
							.bind('mouseleave', leaveSubmit)
							.bind('click', clickSubmit);
                        fillRGBFields(options.color, cal.get(0));
                        fillHSBFields(options.color, cal.get(0));
                        fillHexFields(options.color, cal.get(0));
                        setHue(options.color, cal.get(0));
                        setSelector(options.color, cal.get(0));
                        setCurrentColor(options.color, cal.get(0));
                        setNewColor(options.color, cal.get(0));
                        if (options.flat) {
                            cal.css({
                                position: 'relative',
                                display: 'block'
                            });
                        } else {
                            $(this).bind(options.eventName, show);
                        }
                    }
                });
            },
            showPicker: function () {
                return this.each(function () {
                    if ($(this).data('colorpickerId')) {
                        show.apply(this);
                    }
                });
            },
            hidePicker: function () {
                return this.each(function () {
                    if ($(this).data('colorpickerId')) {
                        $('#' + $(this).data('colorpickerId')).hide();
                    }
                });
            },
            setColor: function (col) {

                if (typeof col == 'string') {
                    col = HexToHSB(col);
                } else if (col.r != undefined && col.g != undefined && col.b != undefined) {
                    col = RGBToHSB(col);
                } else if (col.h != undefined && col.s != undefined && col.b != undefined) {
                    col = fixHSB(col);
                } else {
                    return this;
                }
                return this.each(function () {
                    if ($(this).data('colorpickerId')) {
                        var cal = $('#' + $(this).data('colorpickerId'));

                        cal.data('colorpicker').color = col;
                        cal.data('colorpicker').origColor = col;
                        fillRGBFields(col, cal.get(0));
                        fillHSBFields(col, cal.get(0));
                        fillHexFields(col, cal.get(0));
                        setHue(col, cal.get(0));
                        setSelector(col, cal.get(0));
                        setCurrentColor(col, cal.get(0));
                        setNewColor(col, cal.get(0));
                    }
                });
            }
        };
    }();
    $.fn.extend({
        ColorPicker: ColorPicker.init,
        ColorPickerHide: ColorPicker.hidePicker,
        ColorPickerShow: ColorPicker.showPicker,
        ColorPickerSetColor: ColorPicker.setColor
    });
})(jQuery);

/* qTransform */
(function ($) {

    var div = document.createElement('div'),
      divStyle = div.style;

    //give props to those who dont have them
    $.cssProps.transform =
        divStyle.MozTransform === '' ? 'MozTransform' :
        (divStyle.msTransform === '' ? 'msTransform' :
        (divStyle.WebkitTransform === '' ? 'WebkitTransform' :
        (divStyle.OTransform === '' ? 'OTransform' :
        (divStyle.Transform === '' ? 'Transform' :
        false))));
    $.cssProps.transformOrigin =
        divStyle.MozTransformOrigin === '' ? 'MozTransformOrigin' :
        (divStyle.msTransformOrigin === '' ? 'msTransformOrigin' :
        (divStyle.WebkitTransformOrigin === '' ? 'WebkitTransformOrigin' :
        (divStyle.OTransformOrigin === '' ? 'OTransformOrigin' :
        (divStyle.TransformOrigin === '' ? 'TransformOrigin' :
        false))));

    //define supported or not
    $.support.transform = $.cssProps.transform !== false || divStyle.filter === '' ? true : false;
    $.support.transformOrigin = $.cssProps.transformOrigin !== false ? true : false;

    //if ONLY IE matrixes are supported (IE9 beta6 will use css3)
    $.support.matrixFilter = (divStyle.filter === '' && $.cssProps.transform === false) ?
        true : false;
    div = null;

    //stop if no form of transforms are supported
    if ($.support.transform === false)
        return;

    //opt out of letting jquery handle the units for custom setters/getters 
    $.cssNumber.skew =
    $.cssNumber.skewX =
    $.cssNumber.skewY =
    $.cssNumber.scale =
    $.cssNumber.scaleX =
    $.cssNumber.scaleY =
    $.cssNumber.rotate =
    $.cssNumber.matrix = true;

    $.cssNumber.transformOrigin =
    $.cssNumber.transformOriginX =
    $.cssNumber.transformOriginY = true;
    
    if ($.support.matrixFilter) {
        $.cssNumber.transformOrigin =
        $.cssNumber.transformOriginX =
        $.cssNumber.transformOriginY = true;

        $.cssProps.transformOrigin = 'matrixFilter';
    }

    $.cssHooks.transform = {
        set: function (elem, val, unit) {
            if ($.support.matrixFilter) {
                elem.style.filter = [val].join('');
            } else {
                elem.style[$.cssProps.transform] = val + '%';
            }
        },
        get: function (elem, computed) {
            if ($.support.matrixFilter) {
                return elem.style.filter;
            } else {
                return elem.style[$.cssProps.transform];
            }
        }
    };

    $.cssHooks.transformOrigin = {
        set: function (elem, val, unit) {
            if (!$.support.matrixFilter) {
                val = (typeof val === 'string') ? val : val + (unit || '%');
                elem.style[$.cssProps.transformOrigin] = val;
            } else {
                val = val.split(",");
                $.cssHooks.transformOriginX.set(elem, val[0]);
                if (val.length > 1) {
                    $.cssHooks.transformOriginY.set(elem, val[1]);
                }
            }
        },
        get: function (elem, computed) {
            if (!$.support.matrixFilter) {
                return elem.style[$.cssProps.transformOrigin];
            } else {
                var originX = $.data(elem, 'transformOriginX');
                var originY = $.data(elem, 'transformOriginY');
                return originX && originY && originX === originY ? originX : '50%';
            }
        }
    };

    $.fx.step.transformOrigin = function (fx) {
        $.cssHooks.transformOrigin.set(fx.elem, fx.now, fx.unit);
    };

    $.cssHooks.transformOriginX = {
        set: function (elem, val, unit) {
            if (!$.support.matrixFilter) {
                val = (typeof val === 'string') ? val : val + (unit || '%');
                elem.style[$.cssProps.transformOrigin + 'X'] = val;
            } else {
                $.data(elem, 'transformOriginX', unit ? val + unit : val);
                setIEMatrix(elem);
            }
        },
        get: function (elem, computed) {
            if (!$.support.matrixFilter) {
                return elem.style[$.cssProps.transformOrigin + 'X'];
            } else {
                var originX = $.data(elem, 'transformOriginX');
                switch (originX) {
                    case 'left': return '0%';
                    case 'center': return '50%';
                    case 'right': return '100%';
                }
                return originX ? originX : '50%';
            }
        }
    };

    $.fx.step.transformOriginX = function (fx) {
        $.cssHooks.transformOriginX.set(fx.elem, fx.now, fx.unit);
    };

    $.cssHooks.transformOriginY = {
        set: function (elem, val, unit) {
            if (!$.support.matrixFilter) {
                val = (typeof val === 'string') ? val : val + (unit || '%');
                elem.style[$.cssProps.transformOrigin + 'Y'] = val;
            } else {
                $.data(elem, 'transformOriginY', unit ? val + unit : val);
                setIEMatrix(elem);
            }
        },
        get: function (elem, computed) {
            if (!$.support.matrixFilter) {
                return elem.style[$.cssProps.transformOrigin + 'Y'];
            } else {
                var originY = $.data(elem, 'transformOriginY');
                switch (originY) {
                    case 'top': return '0%';
                    case 'center': return '50%';
                    case 'bottom': return '100%';
                }
                return originY ? originY : '50%';
            }
        }
    };

    $.fx.step.transformOriginY = function (fx) {
        $.cssHooks.transformOriginY.set(fx.elem, fx.now, fx.unit);
    };

    //create hooks for css transforms
    var rtn = function (v) { return v; };
    var xy = [['X', 'Y'], 'X', 'Y'];
    var abcdxy = [['A', 'B', 'C', 'D', 'X', 'Y'], 'A', 'B', 'C', 'D', 'X', 'Y']
    var props = [
        {
            prop: 'rotate',
            matrix: [function (v) { return Math.cos(v); },
                function (v) { return -Math.sin(v); },
                function (v) { return Math.sin(v); },
                function (v) { return Math.cos(v); }],
            unit: 'rad',
            subProps: [''],
            fnc: toRadian
        },
        {
            prop: 'scale',
            matrix: [[rtn, 0, 0, rtn],
                [rtn, 0, 0, 1],
                [1, 0, 0, rtn]],
            unit: '',
            subProps: xy,
            fnc: parseFloat,
            _default: 1
        },
        {
            prop: 'skew',
            matrix: [[1, rtn, rtn, 1],
                [1, rtn, 0, 1],
                [1, 0, rtn, 1]],
            unit: 'rad',
            subProps: xy,
            fnc: toRadian
        },
        {
            prop: 'translate',
            matrix: [[1, 0, 0, 1, rtn, rtn],
                [1, 0, 0, 1, rtn, 0],
                [1, 0, 0, 1, 0, rtn]],
            standardUnit: 'px',
            subProps: xy,
            fnc: parseFloat
        },
        {
            prop: 'matrix',
            matrix: [[rtn, rtn, rtn, rtn, rtn, rtn],
                [rtn, 0, 0, 1, 0, 0],
                [1, rtn, 0, 1, 0, 0],
                [1, 0, rtn, 1, 0, 0],
                [1, 0, 0, rtn, 0, 0],
                [1, 0, 0, 1, 0, rtn]],
            subProps: abcdxy,
            fnc: parseFloat
        }
    ];

    jQuery.each(props, function (n, prop) {
        jQuery.each(prop.subProps, function (num, sub) {
            var _cssProp, _prop = prop;

            if ($.isArray(sub)) {
                //composite transform
                _cssProp = _prop.prop;
                var _sub = sub;
                $.cssHooks[_cssProp] = {
                    set: function (elem, val, unit) {
                        jQuery.each(_sub, function (num, x) {
                            $.cssHooks[_cssProp + x].set(elem, val, unit);
                        });
                    },
                    get: function (elem, computed) {
                        var val = [];
                        jQuery.each(_sub, function (num, x) {
                            val.push($.cssHooks[_cssProp + x].get(elem, val));
                        });
                        //hack until jQuery supports animating multiple properties
                        return val[0] || val[1];
                    }
                }
            } else {
                //independent transfrom
                _cssProp = _prop.prop + sub;
                $.cssHooks[_cssProp] = {
                    set: function (elem, val, unit) {
                        $.data(elem, _cssProp, unit ? val + unit : val);

                        setCSSTransform(elem, _prop.fnc(unit ? val + unit : val), _cssProp,
                         _prop.unit || unit || _prop.standardUnit);
                    },
                    get: function (elem, computed) {

                        var p = $.data(elem, _cssProp);
                        //console.log(_cssProp+'get:'+p);
                        return p && p !== undefined ? p : _prop._default || 0;
                    }
                };
            }

            $.fx.step[_cssProp] = function (fx) {
                fx.unit = fx.unit === 'px' && $.cssNumber[_cssProp] ? _prop.standardUnit : fx.unit;
                var unit = ($.cssNumber[_cssProp] ? '' : fx.unit);
                $.cssHooks[_cssProp].set(fx.elem, fx.now, fx.unit);
            };
        })
    });

    function setCSSTransform(elem, val, prop, unit) {
        if ($.support.matrixFilter) {
            return setIEMatrix(elem, val);
        }

        //parse css string
        var allProps = parseCSSTransform(elem);

        //check for value to be set
        var a = /[X|Y]/.exec(prop);
        a = (a === null ? '' : a[0] ? a[0] : a);
        prop = /.*[^XY]/.exec(prop)[0];
        unit = unit === undefined ? '' : unit;

        //create return string
        var result = '';
        var wasUpdated = false;
        var arr;
        if (allProps !== null) {
            for (var item in allProps) {
                arr = allProps[item];
                if (prop === item) {
                    //update parsed data with new value
                    if (prop !== 'matrix') {
                        result += prop + '(';
                        result += a === 'X' || a === '' ? val + unit :
                            (arr[0] !== '' ? arr[0] : $.cssHooks[prop + 'X'].get(elem) + unit);
                        result += a === 'Y' ? ', ' + val + unit :
                            (arr[1] !== '' ? ', ' + arr[1] :
                            (prop + 'Y' in $.cssHooks ?
                                ', ' + $.cssHooks[prop + 'Y'].get(elem) + unit : ''));
                        result += ') ';
                    } else {
                        result += val + ' ';
                    }
                    wasUpdated = true;
                } else {
                    //dump parsed data to string
                    result += item + '(';
                    for (var i = 0; i < arr.length; i++) {
                        result += arr[i];
                        if (i < arr.length - 1 && arr[i + 1] !== '')
                            result += ', '
                        else
                            break;
                    }
                    result += ') ';
                }
            }
        }

        //if prop was not found to be updated, then dump data
        if (!wasUpdated)
            result += prop + a + '(' + val + unit + ') ';

        //set all transform properties
        elem.style[$.cssProps.transform] = result;
    }


    function parseCSSTransform(elem) {
        var props, prop, name, transform;
        //break up into single transform calls
        $(elem.style[$.cssProps.transform].replace(/(?:\,\s|\)|\()/g, "|").split(" "))
        //read each data point for the transform call
        .each(function (i, item) {
            if (item !== '') {
                if (props === undefined) props = {}
                prop = item.split("|");
                name = prop.shift();
                transform = /.*[^XY]/.exec(name)[0];
                if (!props[transform]) props[transform] = ['', '', '', '', '', ''];
                if (!/Y/.test(name)) props[transform][0] = prop[0];
                if (!/X/.test(name)) props[transform][1] = prop[1];
                if (prop.length == 6) {
                    props[transform][2] = prop[2];
                    props[transform][3] = prop[3];
                    props[transform][4] = prop[4];
                    props[transform][5] = prop[5];
                }
            }
        });

        return props !== undefined ? props : null;
    }

    function ieOrigin(o, n, percent) {
        return percent * (o - n);
    }

    function toRadian(value) {
        if (typeof value === 'number') {
            return parseFloat(value);
        }
        if (value.indexOf("deg") != -1) {
            return parseInt(value, 10) * (Math.PI * 2 / 360);
        } else if (value.indexOf("grad") != -1) {
            return parseInt(value, 10) * (Math.PI / 200);
        }
    }

    $.rotate = {
        radToDeg: function radToDeg(rad) {
            return rad * 180 / Math.PI;
        }
    };

    //special case for IE matrix
    function setIEMatrix(elem, mat) {
        var inverse, current, ang, org, originX, originY,
        runTransform = $.cssProps.transformOrigin === 'matrixFilter' ? true : false;

        current = [$.cssHooks.scaleX.get(elem),
                    toRadian($.cssHooks.skewY.get(elem)),
                    toRadian($.cssHooks.skewX.get(elem)),
                    $.cssHooks.scaleY.get(elem),
                    $.cssHooks.translateX.get(elem),
                    $.cssHooks.translateY.get(elem)];

        //start by multiply inverse of transform origin by matrix
        if (runTransform) {
            elem.style.filter = [
                "progid:DXImageTransform.Microsoft.Matrix"
                + "(M11=1,M12=0,M21=0,M22=1,SizingMethod='auto expand')"
            ].join('');
            var Wp = $.cssHooks.transformOriginX.get(elem);
            var Hp = $.cssHooks.transformOriginY.get(elem);
            Wp = Wp.indexOf('%') > 0 ?
                (/[\d]*/.exec(Wp) / 100) : Wp;
            Hp = Hp.indexOf('%') > 0 ?
                (/[\d]*/.exec(Hp) / 100) : Hp;

            var Wb = elem.offsetWidth;
            var Hb = elem.offsetHeight;
        }

        //multiply old matrix to new matrix
        if (typeof mat !== 'array' || mat.length !== 6) {
            mat = current;
        } else {
            mat = [((current[0] * mat[0]) + (current[1] * mat[2])),
                    ((current[0] * mat[1]) + (current[1] * mat[3])),
                    ((current[2] * mat[0]) + (current[3] * mat[2])),
                    ((current[2] * mat[1]) + (current[3] * mat[3])),
                    mat[4],
                    mat[5]
            ];
        }

        //multiply the transform and rotation matrixes
        ang = $.data(elem, 'rotate');
        if (ang) {
            ang = toRadian(ang);
            var cos = Math.cos(ang);
            var sin = Math.sin(ang);

            ang = [cos, -sin, sin, cos];
            mat = [((mat[0] * ang[0]) + (mat[1] * ang[2])),
                    ((mat[0] * ang[1]) + (mat[1] * ang[3])),
                    ((mat[2] * ang[0]) + (mat[3] * ang[2])),
                    ((mat[2] * ang[1]) + (mat[3] * ang[3])),
                    mat[4],
                    mat[5]
            ];
        }

        //apply the matrix as a IE filter
        elem.style.filter = [
            "progid:DXImageTransform.Microsoft.Matrix(",
            "M11=" + mat[0] + ", ",
            "M12=" + mat[1] + ", ",
            "M21=" + mat[2] + ", ",
            "M22=" + mat[3] + ", ",
            "SizingMethod='auto expand'",
            ")"
        ].join('');

        if (runTransform) {
            var Wo = elem.offsetWidth;
            var Ho = elem.offsetHeight;
            elem.style.position = 'relative';
            elem.style.left = Wp * (Wb - Wo) + (parseInt(mat[4]) || 0);
            elem.style.top = Hp * (Hb - Ho) + (parseInt(mat[5]) || 0);
        }
        //$('#console').append('<div> trans:'+Wp+":"+Wb+":"+Wo+":"+mat[4]+":"+elem.style.left+'</div>');


    }

})(jQuery);

/* block UI */
(function ($) {

    if (/1\.(0|1|2)\.(0|1|2)/.test($.fn.jquery) || /^1.1/.test($.fn.jquery)) {
        alert('blockUI requires jQuery v1.2.3 or later!  You are using v' + $.fn.jquery);
        return;
    }

    $.fn._fadeIn = $.fn.fadeIn;

    var noOp = function () { };

    // this bit is to ensure we don't call setExpression when we shouldn't (with extra muscle to handle
    // retarded userAgent strings on Vista)
    var mode = document.documentMode || 0;
    var setExpr = document.all && ((!mode) || mode < 8);
    var ie6 = document.all && /MSIE 6.0/.test(navigator.userAgent) && !mode;

    // global $ methods for blocking/unblocking the entire page
    $.blockUI = function (opts) { install(window, opts); };
    $.unblockUI = function (opts) { remove(window, opts); };

    // convenience method for quick growl-like notifications  (http://www.google.com/search?q=growl)
    $.growlUI = function (title, message, timeout, onClose) {
        var $m = $('<div class="growlUI"></div>');
        if (title) $m.append('<h1>' + title + '</h1>');
        if (message) $m.append('<h2>' + message + '</h2>');
        if (timeout == undefined) timeout = 3000;
        $.blockUI({
            message: $m, fadeIn: 700, fadeOut: 1000, centerY: false,
            timeout: timeout, showOverlay: false,
            onUnblock: onClose,
            css: $.blockUI.defaults.growlCSS
        });
    };

    // plugin method for blocking element content
    $.fn.block = function (opts) {
        return this.unblock({ fadeOut: 0 }).each(function () {
            if ($.css(this, 'position') == 'static')
                this.style.position = 'relative';
            if ($.browser.msie)
                this.style.zoom = 1; // force 'hasLayout'
            install(this, opts);
        });
    };

    // plugin method for unblocking element content
    $.fn.unblock = function (opts) {
        return this.each(function () {
            remove(this, opts);
        });
    };

    $.blockUI.version = 2.38; // 2nd generation blocking at no extra cost!

    // override these in your code to change the default behavior and style
    $.blockUI.defaults = {
        // message displayed when blocking (use null for no message)
        message: '<h1>Please wait...</h1>',

        title: null,   // title string; only used when theme == true
        draggable: true,  // only used when theme == true (requires jquery-ui.js to be loaded)
        theme: false, // set to true to use with jQuery UI themes
        css: {
            padding: 0,
            margin: 0,
            width: '30%',
            top: '40%',
            left: '35%',
            textAlign: 'center',
            color: '#000',
            border: '3px solid #aaa',
            backgroundColor: null,
            cursor: 'wait'
        },

        // minimal style set used when themes are used
        themedCSS: {
            width: '30%',
            top: '40%',
            left: '35%'
        },

        // styles for the overlay
        overlayCSS: {
            backgroundColor: '#000',
            opacity: 0.3,
            cursor: 'wait'
        },

        // styles applied when using $.growlUI
        growlCSS: {
            width: '350px',
            top: '10px',
            left: '',
            right: '10px',
            border: 'none',
            padding: '5px',
            opacity: 0.6,
            cursor: 'default',
            color: '#fff',
            backgroundColor: '#000',
            '-webkit-border-radius': '10px',
            '-moz-border-radius': '10px',
            'border-radius': '10px'
        },

        iframeSrc: /^https/i.test(window.location.href || '') ? 'javascript:false' : 'about:blank',
        forceIframe: false,
        baseZ: 10,
        centerX: true,
        centerY: true,
        allowBodyStretch: true,
        bindEvents: true,
        constrainTabKey: true,
        fadeIn: 200,
        fadeOut: 400,
        timeout: 0,
        showOverlay: true,
        focusInput: true,
        applyPlatformOpacityRules: true,
        onBlock: null,
        onUnblock: null,
        quirksmodeOffsetHack: 4,
        blockMsgClass: 'blockMsg'
    };

    // private data and functions follow...

    var pageBlock = null;
    var pageBlockEls = [];

    function install(el, opts) {
        var full = (el == window);
        var msg = opts && opts.message !== undefined ? opts.message : undefined;
        opts = $.extend({}, $.blockUI.defaults, opts || {});
        opts.overlayCSS = $.extend({}, $.blockUI.defaults.overlayCSS, opts.overlayCSS || {});
        var css = $.extend({}, $.blockUI.defaults.css, opts.css || {});
        var themedCSS = $.extend({}, $.blockUI.defaults.themedCSS, opts.themedCSS || {});
        msg = msg === undefined ? opts.message : msg;

        if (full && pageBlock)
            remove(window, { fadeOut: 0 });

        if (msg && typeof msg != 'string' && (msg.parentNode || msg.jquery)) {
            var node = msg.jquery ? msg[0] : msg;
            var data = {};
            $(el).data('blockUI.history', data);
            data.el = node;
            data.parent = node.parentNode;
            data.display = node.style.display;
            data.position = node.style.position;
            if (data.parent)
                data.parent.removeChild(node);
        }

        var z = opts.baseZ;

        // blockUI uses 3 layers for blocking, for simplicity they are all used on every platform;
        // layer1 is the iframe layer which is used to supress bleed through of underlying content
        // layer2 is the overlay layer which has opacity and a wait cursor (by default)
        // layer3 is the message content that is displayed while blocking

        var lyr1 = (document.all || opts.forceIframe)
		? $('<iframe class="blockUI" style="z-index:' + (z++) + ';display:none;border:none;margin:0;padding:0;position:absolute;width:100%;height:100%;top:0;left:0" src="' + opts.iframeSrc + '"></iframe>')
		: $('<div class="blockUI" style="display:none"></div>');

        var lyr2 = opts.theme
	 	? $('<div class="blockUI blockOverlay ui-widget-overlay" style="z-index:' + (z++) + ';display:none"></div>')
	 	: $('<div class="blockUI blockOverlay" style="z-index:' + (z++) + ';display:none;border:none;margin:0;padding:0;width:100%;height:100%;top:0;left:0"></div>');

        var lyr3, s;
        if (opts.theme && full) {
            s = '<div class="blockUI ' + opts.blockMsgClass + ' blockPage ui-dialog ui-widget ui-corner-all" style="z-index:' + z + ';display:none;position:fixed">' +
				'<div class="ui-widget-header ui-dialog-titlebar ui-corner-all blockTitle">' + (opts.title || '&nbsp;') + '</div>' +
				'<div class="ui-widget-content ui-dialog-content"></div>' +
			'</div>';
        }
        else if (opts.theme) {
            s = '<div class="blockUI ' + opts.blockMsgClass + ' blockElement ui-dialog ui-widget ui-corner-all" style="z-index:' + z + ';display:none;position:absolute">' +
				'<div class="ui-widget-header ui-dialog-titlebar ui-corner-all blockTitle">' + (opts.title || '&nbsp;') + '</div>' +
				'<div class="ui-widget-content ui-dialog-content"></div>' +
			'</div>';
        }
        else if (full) {
            s = '<div class="blockUI ' + opts.blockMsgClass + ' blockPage" style="z-index:' + z + ';display:none;position:fixed"></div>';
        }
        else {
            s = '<div class="blockUI ' + opts.blockMsgClass + ' blockElement" style="z-index:' + z + ';display:none;position:absolute"></div>';
        }
        lyr3 = $(s);

        // if we have a message, style it
        if (msg) {
            if (opts.theme) {
                lyr3.css(themedCSS);
                lyr3.addClass('ui-widget-content');
            }
            else
                lyr3.css(css);
        }

        // style the overlay
        if (!opts.theme && (!opts.applyPlatformOpacityRules || !($instantasp.isFirefox && /Linux/.test(navigator.platform))))
            lyr2.css(opts.overlayCSS);
        lyr2.css('position', full ? 'fixed' : 'absolute');

        // make iframe layer transparent in IE
        if (document.all || opts.forceIframe)
            lyr1.css('opacity', 0.0);

        //$([lyr1[0],lyr2[0],lyr3[0]]).appendTo(full ? 'body' : el);
        var layers = [lyr1, lyr2, lyr3], $par = full ? $('body') : $(el);
        $.each(layers, function () {
            this.appendTo($par);
        });

        if (opts.theme && opts.draggable && $.fn.draggable) {
            lyr3.draggable({
                handle: '.ui-dialog-titlebar',
                cancel: 'li'
            });
        }

        // ie7 must use absolute positioning in quirks mode and to account for activex issues (when scrolling)
        var expr = setExpr && (!$.boxModel || $('object,embed', full ? null : el).length > 0);
        if (ie6 || expr) {
            // give body 100% height
            if (full && opts.allowBodyStretch && $.boxModel)
                $('html,body').css('height', '100%');

            // fix ie6 issue when blocked element has a border width
            if ((ie6 || !$.boxModel) && !full) {
                var t = sz(el, 'borderTopWidth'), l = sz(el, 'borderLeftWidth');
                var fixT = t ? '(0 - ' + t + ')' : 0;
                var fixL = l ? '(0 - ' + l + ')' : 0;
            }

            // simulate fixed position
            $.each([lyr1, lyr2, lyr3], function (i, o) {
                var s = o[0].style;
                s.position = 'absolute';
                if (i < 2) {
                    full ? s.setExpression('height', 'Math.max(document.body.scrollHeight, document.body.offsetHeight) - (jQuery.boxModel?0:' + opts.quirksmodeOffsetHack + ') + "px"')
					 : s.setExpression('height', 'this.parentNode.offsetHeight + "px"');
                    full ? s.setExpression('width', 'jQuery.boxModel && document.documentElement.clientWidth || document.body.clientWidth + "px"')
					 : s.setExpression('width', 'this.parentNode.offsetWidth + "px"');
                    if (fixL) s.setExpression('left', fixL);
                    if (fixT) s.setExpression('top', fixT);
                }
                else if (opts.centerY) {
                    if (full) s.setExpression('top', '(document.documentElement.clientHeight || document.body.clientHeight) / 2 - (this.offsetHeight / 2) + (blah = document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop) + "px"');
                    s.marginTop = 0;
                }
                else if (!opts.centerY && full) {
                    var top = (opts.css && opts.css.top) ? parseInt(opts.css.top) : 0;
                    var expression = '((document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop) + ' + top + ') + "px"';
                    s.setExpression('top', expression);
                }
            });
        }

        // show the message
        if (msg) {
            if (opts.theme)
                lyr3.find('.ui-widget-content').append(msg);
            else
                lyr3.append(msg);
            if (msg.jquery || msg.nodeType)
                $(msg).show();
        }

        if ((document.all || opts.forceIframe) && opts.showOverlay)
            lyr1.show(); // opacity is zero
        if (opts.fadeIn) {
            var cb = opts.onBlock ? opts.onBlock : noOp;
            var cb1 = (opts.showOverlay && !msg) ? cb : noOp;
            var cb2 = msg ? cb : noOp;
            if (opts.showOverlay)
                lyr2._fadeIn(opts.fadeIn, cb1);
            if (msg)
                lyr3._fadeIn(opts.fadeIn, cb2);
        }
        else {
            if (opts.showOverlay)
                lyr2.show();
            if (msg)
                lyr3.show();
            if (opts.onBlock)
                opts.onBlock();
        }

        // bind key and mouse events
        bind(1, el, opts);

        if (full) {
            pageBlock = lyr3[0];
            pageBlockEls = $(':input:enabled:visible', pageBlock);
            if (opts.focusInput)
                setTimeout(focus, 20);
        }

        center(lyr3[0], opts.centerX, opts.centerY);

        if (opts.timeout) {
            // auto-unblock
            var to = setTimeout(function () {
                full ? $.unblockUI(opts) : $(el).unblock(opts);
            }, opts.timeout);
            $(el).data('blockUI.timeout', to);
        }
    };

    // remove the block
    function remove(el, opts) {
        var full = (el == window);
        var $el = $(el);
        var data = $el.data('blockUI.history');
        var to = $el.data('blockUI.timeout');
        if (to) {
            clearTimeout(to);
            $el.removeData('blockUI.timeout');
        }
        opts = $.extend({}, $.blockUI.defaults, opts || {});
        bind(0, el, opts); // unbind events

        var els;
        if (full) // crazy selector to handle odd field errors in ie6/7
            els = $('body').children().filter('.blockUI').add('body > .blockUI');
        else
            els = $('.blockUI', el);

        if (full)
            pageBlock = pageBlockEls = null;

        if (opts.fadeOut) {
            els.fadeOut(opts.fadeOut);
            setTimeout(function () { reset(els, data, opts, el); }, opts.fadeOut);
        }
        else
            reset(els, data, opts, el);
    };

    // move blocking element back into the DOM where it started
    function reset(els, data, opts, el) {
        els.each(function (i, o) {
            // remove via DOM calls so we don't lose event handlers
            if (this.parentNode)
                this.parentNode.removeChild(this);
        });

        if (data && data.el) {
            data.el.style.display = data.display;
            data.el.style.position = data.position;
            if (data.parent)
                data.parent.appendChild(data.el);
            $(el).removeData('blockUI.history');
        }

        if (typeof opts.onUnblock == 'function')
            opts.onUnblock(el, opts);
    };

    // bind/unbind the handler
    function bind(b, el, opts) {
        var full = el == window, $el = $(el);

        // don't bother unbinding if there is nothing to unbind
        if (!b && (full && !pageBlock || !full && !$el.data('blockUI.isBlocked')))
            return;
        if (!full)
            $el.data('blockUI.isBlocked', b);

        if (!opts.bindEvents || (b && !opts.showOverlay))
            return;

        var events = 'mousedown mouseup keydown keypress';
        b ? $(document).bind(events, opts, handler) : $(document).unbind(events, handler);

    };

    // event handler to suppress keyboard/mouse events when blocking
    function handler(e) {
        // allow tab navigation (conditionally)
        if (e.keyCode && e.keyCode == 9) {
            if (pageBlock && e.data.constrainTabKey) {
                var els = pageBlockEls;
                var fwd = !e.shiftKey && e.target === els[els.length - 1];
                var back = e.shiftKey && e.target === els[0];
                if (fwd || back) {
                    setTimeout(function () { focus(back) }, 10);
                    return false;
                }
            }
        }
        var opts = e.data;
        // allow events within the message content
        if ($(e.target).parents('div.' + opts.blockMsgClass).length > 0)
            return true;

        // allow events for content that is not being blocked
        return $(e.target).parents().children().filter('div.blockUI').length == 0;
    };

    function focus(back) {
        if (!pageBlockEls)
            return;
        var e = pageBlockEls[back === true ? pageBlockEls.length - 1 : 0];
        if (e)
            e.focus();
    };

    function center(el, x, y) {
        var p = el.parentNode, s = el.style;
        var l = ((p.offsetWidth - el.offsetWidth) / 2) - sz(p, 'borderLeftWidth');
        var t = ((p.offsetHeight - el.offsetHeight) / 2) - sz(p, 'borderTopWidth');
        if (x) s.left = l > 0 ? (l + 'px') : '0';
        if (y) s.top = t > 0 ? (t + 'px') : '0';
    };

    function sz(el, p) {
        return parseInt($.css(el, p)) || 0;
    };

})(jQuery);

/* Google suggest */
(function ($) {
    $.fn.googleSuggest = function (opts) {
        opts = $.extend({ term: "", service: 'web', secure: true }, opts);

        var services = {
            youtube: { client: 'youtube', ds: 'yt' },
            books: { client: 'books', ds: 'bo' },
            products: { client: 'products-cc', ds: 'sh' },
            news: { client: 'news-cc', ds: 'n' },
            images: { client: 'img', ds: 'i' },
            web: { client: 'psy', ds: '' },
            recipes: { client: 'psy', ds: 'r' }
        }, service = services[opts.service];

        var results = $(this);
        if (opts.term == "") {
            results.hide();
            return;
        }

        $.ajax({
            url: 'http' + (opts.secure ? 's' : '') + '://clients1.google.com/complete/search',
            dataType: 'jsonp',
            data: {
                q: opts.term,
                nolabels: 't',
                client: service.client,
                ds: service.ds
            },
            success: function (data) {
                if (data[1].length > 0) {
                    var html = "<ul class=\"i-list\">";
                    $.map(data[1], function (item) {
                        var text = $("<span>").html(item[0]).text();
                        html += "<li><a href=\"javascript:void(0);\" onclick=\"addTagSuggestion('" + text + "');\"><div class=\"padding\">" + text + "</div></a></li>";
                    });
                    html += "</ul>";                 
                    results.html(html);
                } else {
                    results.html("<ul class=\"navigation\"><li><div class=\"padding\">No Suggestions</div></li></ul>");
                }
                if (!results.is(":visible")) {
                    results.show();
                }

            }
        });

    }
})(jQuery);

/* Search Suggest */
(function ($) {
    "use strict";

    var suggest = {      
        opts: {
            url: "http://yourInstantKBURL/", // URL to InstantKB installation
            args: {}, // initial search arguments                                     
            parent: $("body"), // parent for the auto suggestion menu
            auto_suggest: true, // enable / disable auto suggestions
            page_size: 10, // page size for results     
            result_css: '', // if provided appended to the results menu CSS i-suggest X
            filter_content_types: [ 1, 2, 3, 5 ],
            onResultClick: null, // when you click a search result
            onFocus: null, // on focus of input element
            onBlur: null, // on blur of input element
            onTransitionEnd: null, // after any CSS transitions on input element
            onSubmit: null, // on enter key or clicking search button
            onTabChange: null // when tab selection changes
        },        
        elem: null,
        $elem: null,
        $input: null,
        $searchBtn: null,
        $filterBtn: null,
        menuId: "searchSuggest",
        init: function (options, elem) {

            var self = this;
            self.elem = elem;
            self.$elem = $(elem);
            self.opts = $.extend({}, this.opts, options);
            self.$input = self.$elem.find("input");
            self.$input.attr("autocomplete", "off");
            self.$searchBtn = self.$elem.find("[data-type='submit']");
            self.$filterBtn = self.$elem.find("[data-type='filter']");

            // allow set-up from data attributes
            self.opts.parent = (typeof self.$elem.data("parent") != "undefined" ? $(self.$elem.data("parent")) : self.opts.parent);
            self.opts.auto_suggest = (typeof self.$elem.data("autoSuggest") != "undefined" ? self.$elem.data("autoSuggest") : self.opts.auto_suggest);
            self.opts.page_size = (typeof self.$elem.data("pageSize") != "undefined" ? self.$elem.data("pageSize") : self.opts.page_size);                       
            self.opts.result_css = (typeof self.$elem.data("resultCss") != "undefined" ? self.$elem.data("resultCss") : '');

            // ensure unique ID for results menu
            if (self.$elem.attr("id")) {
                self.menuId = self.$elem.attr("id") + "_Menu";
            }

            // setup InstantKB api calls
            if (typeof _kb != 'undefined') {
                _kb.initHttp({ url: self.opts.url });
                _kb.onError(function (config, xhr, ajaxOptions, thrownError) {
                    jAjax.handleCallBackError(xhr, thrownError);
                })
            }

            // input events

            var typingTimer; //timer identifier
            var doneTypingInterval = 1000;  //time in ms, 5 second for example

            //on keyup, start the countdown
            this.$input.on('keyup', function (e) {

                if ((e.keyCode && e.keyCode == 13)) {
                    e.preventDefault();
                    clearTimeout(typingTimer);
                    self.setSearchArgs();
                    if (self.opts.onSubmit) {                        
                        return self.opts.onSubmit(self, e)
                    } else {                     
                        populateResults();
                        return false;
                    }
                }

                if ($(this).val() != "") {
                    clearTimeout(typingTimer);
                    typingTimer = setTimeout(populateResults, doneTypingInterval);
                } else {
                    clearTimeout(typingTimer);
                    self.getResultMenu().hide();
                }

            });

            // position results menu after any CSS transitions on input element
            this.$input.on("transitionend webkitTransitionEnd oTransitionEnd MSTransitionEnd", function (e) {
                self.setResultMenuPosition();
                if (self.opts.onTransitionEnd) {
                    self.opts.onTransitionEnd(self);
                }
            });

            // on focus clear the countdown
            this.$input.on('focus', function (e) {
                              
                iasp_HideAllMenus();

                if ($(this).val() != "") {
                    clearTimeout(typingTimer);
                    if (!self.getResultMenu().is(":visible")) {
                        populateResults();
                    }                    
                } else {
                    clearTimeout(typingTimer);                    
                }

                $(this).addClass("active");
                if (self.opts.onFocus) {                    
                    self.opts.onFocus(self);
                }

            });

            this.$input.on('blur', function (e) {
                if (!self.getResultMenu().is(":visible")) {
                    $(this).removeClass("active");
                }               
                if (self.opts.onBlur) {                     
                    self.opts.onBlur(self);
                }
            });

            //on keydown, clear the countdown 
            this.$input.on('keydown', function (e) {
                if ((e.keyCode && e.keyCode == 13)) {
                    e.preventDefault();
                    clearTimeout(typingTimer);
                    return false;
                }
                clearTimeout(typingTimer);
            });

            // button events
            this.$searchBtn.click(function (e) {
                e.preventDefault();
                iasp_HideAllMenus();
                if (self.$input.val() != "") {
                    self.setSearchArgs();
                    if (self.opts.onSubmit) {                        
                        return self.opts.onSubmit(self, e)
                    } else {
                        populateResults();
                        return false;
                    }
                } else {
                    self.$input.focus();
                }
                return false;
            });

            // filter events
            this.$filterBtn.click(function (e) {
                e.preventDefault();
                if (self.opts.parent[0].tagName == "BODY") {
                    self.getResultMenu().hide();
                }
                self.setSearchArgs();
                var menu = self.getFilterMenu();
                iasp_OpnMnu(e, $(this)[0], menu.attr("id"), '300px', '400px');
            });

            $(window).resize(function (e) {
                self.setResultMenuPosition();
            });

            // hide suggestion menu on document client
            $(document).click(function (e) {
              
                var menu = self.getResultMenu();
                if (menu.css("position") != "absolute") {
                    return;
                }
                              
                if (menu.is(":visible")) {
                    var target = e.target;
                    if (target) {                                           
                        if (target.tagName) {                          
                            if (target.tagName == "INPUT" ||
                                target.tagName == "A" ||
                                target.tagName == "I" ||
                                target.tagName == "LI" ||
                                target.tagName == "SPAN") {                            
                                return;
                            }
                        }
                    }
                    menu.hide();
                    if (!self.getResultMenu().is(":visible")) {
                        self.$input.removeClass("active");
                    }
                    if (self.opts.onBlur) {
                        self.opts.onBlur(self);
                    }
                }
            });

            function populateResults() {                
                self.populateResultMenu();
            }

        },
        getFilterMenu: function () {
            var filterMenuId = this.menuId + "_filters";
            if ($("#" + filterMenuId).length == 0) {
                var menuWrapper = $('<div class="i-menu-box">');
                menuWrapper.attr("id", filterMenuId);
                var menu = $('<div class="i-menu">');
                var list = $('<div class="menu">');
                list.html('<div class="i-loader-jumbo"><div class="i-loader i-loader-2x"></div></div>')
                menu.append(list);
                menuWrapper.append(menu);
                $("body").append(menuWrapper);
                this.populateFilterMenu();
            }
            return $("#" + filterMenuId);
        },
        getSelectedTabId: function () {
            var id = 0;
            this.getFilterMenu().find("a").each(function () {
                if ($(this).hasClass("selected")) {
                    id = parseInt($(this).data("tabId"));
                }
            });         
            return id;
        },
        setSearchArgs: function () {
            this.opts.args.keywords = this.$input.val();
            this.opts.args.tab_id = this.getSelectedTabId();        
        },
        populateFilterMenu: function () {

            var self = this;

            _kb.tabs.getTabs(function (results) {
                if (results) {

                    var ul = $("<ul>");
                    ul.append(buildAll());
                    for (var i = 0; i < results.length; i++) {
                        var tab = results[i];
                        if (isInTabContentTypes(tab)) {
                            ul.append(buildListItem(tab));
                        }                        
                    }

                    var menu = self.getFilterMenu();
                    menu.find(".i-loader-jumbo").hide();
                    menu.find(".menu").append(ul);
                    iasp_setMenuHeight(menu[0], '400px');

                } else {

                    var ul = $("<ul>");
                    ul.append(buildNoResults());
                                     
                    var menu = self.getFilterMenu();                          
                    menu.find(".i-loader-jumbo").hide();
                    menu.find(".menu").append(ul);
                }
            });

            function isInTabContentTypes(tab) {
                var output = false;
                var types = self.opts.filter_content_types;
                if (types) {
                    for (var i = 0; i <= types.length; i++) {                        
                        if (types[i] == tab.content_type) {
                            output = true;
                            break;
                        }
                    }
                }
                return output;
            }

            function buildAll() {

                var li = $("<li>");

                var span = $('<span class="padding">');
                span.attr("id", "all_smMenu");
                span.text("All");

                var a = $("<a>");
                a.attr("href", "javascript: void(0);");
                a.data("tabId", "0");
                a.addClass("selected");
                a.append(span);

                a.click(function () {
                    resetTabSelection();
                    $(this).addClass("selected");
                    if (self.opts.onTabChange) {
                        var id = parseInt($(this).data("tabId"));
                        self.opts.onTabChange(id);
                    }
                })

                li.append(a);
                return li;

            }

            function buildListItem(data) {

                var li = $("<li>");

                var img = null;
                if (data.image_url != "") {
                    img = $("<img>");
                    img.attr("src", data.image_url);
                    img.addClass("i-align-middle i-margin-right-small");
                }

                var text = $('<span>');
                text.text(data.display_text);

                var span = $('<span class="padding">');
             
                if (img != null) {
                    span.append(img);
                }
                span.append(text);

                var a = $("<a>");          
                a.attr("href", "javascript: void(0);");
                a.data("tabId", data.id);
                a.append(span);

                a.click(function () {
                    resetTabSelection();
                    $(this).addClass("selected");
                    if (self.opts.onTabChange) {
                        var id = parseInt($(this).data("tabId"));
                        self.opts.onTabChange(id);
                    }
                })

                li.append(a);
                return li;

            }

            function buildNoResults() {

                var span = $('<span>');
                span.addClass("padding");
                span.text("No Tabs Found!")

                var a = $("<a>");
                a.attr("href", "javascript:void(0);");          
                a.append(span);

                var li = $('<li>');
                li.append(a);

                return li;

            }
            
            function resetTabSelection() {
                self.getFilterMenu().find("a").removeClass("selected");
            }

        },
        getResultMenu: function () {
            if ($("#" + this.menuId).length == 0) {
                var $menu = $('<div id="' + this.menuId + '" class="i-suggest' + (this.opts.result_css != '' ? ' ' + this.opts.result_css : '') + '">');
                $menu.html('<div class="i-loader-jumbo"><div class="i-loader i-loader-2x"></div></div>')                
                if (this.opts.parent[0].tagName == "BODY") {
                    $menu.css({ "position": "absolute" });
                }
                this.opts.parent.append($menu);
            }
            return $("#" + this.menuId);
        },
        setResultMenuPosition: function () {
            var height = this.$elem.height(),
                width = this.$elem.width(),
                top = this.$elem.offset().top,
                left = this.$elem.offset().left,
                bottom = top + height;
            this.getResultMenu().css({
                "left": left,
                "top": bottom,
                "width": width
            });
        },
        populateResultMenu: function (pageIndex) {
                  
            pageIndex = pageIndex || 1;
                    
            var self = this;
            if (!self.opts.auto_suggest) { return; }
            self.getResultMenu().find("ul").hide();
            self.getResultMenu().find(".i-loader-jumbo").show();
            self.setResultMenuPosition();
            self.getResultMenu().show();
            self.setSearchArgs();
                   
            if (typeof _kb != 'undefined') {         
                _kb.search.getResults({
                    page_index: pageIndex,
                    page_size: self.opts.page_size,
                    args: self.opts.args
                }, function (results) {                
                    if (results.data) {

                        // remove previous results
                        self.getResultMenu().find("ul").remove();
                                            
                        // build results
                        var ul = $("<ul>");
                        for (var i = 0; i < results.data.length; i++) {
                            ul.append(buildListItem(results.data[i]));
                        }

                        // searching specific tab or content type allow for paging

                        var global = true;
                        if (self.opts.args.global_scope) {
                            global = (self.opts.args.global_scope == 0 ? true : false);
                        }

                        if (self.getSelectedTabId() > 0 || !global) {
                            if (results.total > results.page_size) {
                                ul.append(buildPager(results));
                            }
                        }

                        // hide loader / show results
                        self.getResultMenu().find(".i-loader-jumbo").hide();
                        self.getResultMenu().append(ul);
                        self.setResultMenuPosition();
                        
                    } else {

                        // no data
                        var ul = $("<ul>");
                        ul.append(buildNoResults());                   
                        self.getResultMenu().find(".i-loader-jumbo").hide();
                        self.getResultMenu().append(ul);

                    }
                });
            }

            function buildListItem(data) {

                var img = null;             
                if ((data.image) && (data.image != "")) {
                    img = $("<img>");
                    img.attr("src", data.image);
                    img.attr("title", data.tab_text);
                    img.addClass("i-align-middle i-margin-right-small");
                }

                var a = $("<a>");
                if (self.opts.onResultClick) {
                    a.attr("href", "javascript:void(0);");
                } else {
                    a.attr("href", data.url);
                    a.attr("target", "_blank");
                }
                
                var left = $("<span>");
                left.addClass("left");

                var title = $("<span>");
                title.addClass("padding");

                var text = $("<span>");
                text.text(data.title);

                if (img != null) {
                    title.append(img);
                }
                title.append(text);

                left.append(title);

                var right = null;
                if (data.rank > 0) {

                    right = $("<span>");
                    right.addClass("right");

                    var rightPadding = $("<span>");
                    rightPadding.addClass("padding");

                    var badge = $("<span>")
                    badge.addClass("i-label i-label-default")
                    badge.text(data.rank + "%");
                    badge.attr("title", data.rank + "% relevancy")
                    rightPadding.append(badge);
                    right.append(rightPadding);

                }
            
                a.append(left);
                if (right != null) {
                    a.append(right);
                }
                
                if (self.opts.onResultClick) {
                    a.click(function (e) {
                        self.opts.onResultClick(data, e);
                    })
                }

                var li = $('<li>');
                li.append(a);

                return li;
                
            }

            function buildPager(results) {

                var li = $('<li class="pager">');

                // left

                var left = $('<span class="pager-left">');
                if (results.page_index == 1) {
                    left.html("&nbsp;");
                } else {
                    left.append(buildPrev(results.page_index));
                }

                // center

                var center = $('<span class="pager-center">');
                center.append(buildInfo(results));

                // right

                var right = $('<span class="pager-right">');
                if (results.page_index == results.page_count) {
                    right.html("&nbsp;");
                } else {
                    right.append(buildNext(results.page_index));
                }

                li.append(left);
                li.append(center);
                li.append(right);

                return li;

            }

            function buildInfo(results) {

                var pages = "Page {0} of {1}";
                pages = pages.replace("{0}", results.page_index);
                pages = pages.replace("{1}", results.page_count);

                var total = "{0} results";
                if (results.total == 1) {
                    total = "{0} result";
                }
                total = total.replace("{0}", results.total);

                var span = $('<span>');
                span.text(pages + ", " + total)

                return span;

            }

            function buildPrev(pageIndex) {

                var span = $('<span>');
                span.addClass("padding");

                var icon = $("<i>");
                icon.addClass("fa fa-chevron-left");
                span.append(icon);

                var a = $("<a>");
                a.attr("href", "javascript:void(0);");
                a.css({ "textAlgn": "center" });
                a.append(span);

                a.click(function () {
                    if (pageIndex > 1) {                    
                        self.populateResultMenu(pageIndex -= 1);
                    }
                })

                return a;

            }

            function buildNext(pageIndex) {

                var span = $('<span>');
                span.addClass("padding");

                var icon = $("<i>");
                icon.addClass("fa fa-chevron-right");
                span.append(icon);

                var a = $("<a>");
                a.attr("href", "javascript:void(0);");
                a.append(span);

                a.click(function () {                   
                    self.populateResultMenu(pageIndex += 1);
                })

                return a;

            }

            function buildNoResults() {

                var span = $('<span>');
                span.addClass("padding");
                span.text("No Results Found!")

                var a = $("<span>");
                a.attr("href", "javascript:void(0);");
                a.css({ "textAlgn": "center" });
                a.append(span);

                var li = $('<li class="no-results">');
                li.append(a);

                return li;

            }

        }
    };

    $.fn.searchSuggest = function (options) {   
        return this.each(function () {
            if (!$.data(this, 'searchSuggest')) {
                var o = Object.create(suggest);
                o.init(options, this);
                $.data(this, 'searchSuggest', o);
            }
        });
    };
    
})(jQuery);

/* idTabs ~ Sean Catchpole - Version 2.2 - MIT/GPL */
(function () {
    var init = function () {
        (function ($) {
            $.fn.idTabs = function () {
                var s = {}; for (var i = 0; i < arguments.length; ++i) { var a = arguments[i]; switch (a.constructor) { case Object: $.extend(s, a); break; case Boolean: s.change = a; break; case Number: s.start = a; break; case Function: s.click = a; break; case String: if (a.charAt(0) == '.') s.selected = a; else if (a.charAt(0) == '!') s.event = a; else s.start = a; break; } }
                if (typeof s['return'] == "function")
                    s.change = s['return']; return this.each(function () { $.idTabs(this, s); });
            }
            $.idTabs = function (tabs, options) {
                var meta = ($.metadata) ? $(tabs).metadata() : {};
                var s = $.extend({}, $.idTabs.settings, meta, options);
                if (s.selected.charAt(0) == '.')
                { s.selected = s.selected.substr(1); }
                if (s.event.charAt(0) == '!')
                { s.event = s.event.substr(1); }
                if (s.start == null) { s.start = -1; }
                var showId = function () {
                    if ($(this).is('.' + s.selected))
                        return s.change;
                    var id = "#" + this.href.split('#')[1];
                    var aList = []; var idList = [];
                    $("a", tabs).each(function () {
                        if (this.href.match(/#/)) {
                            aList.push(this); idList.push("#" + this.href.split('#')[1]);
                        }
                    });
                    if (s.click && !s.click.apply(this, [id, idList, tabs, s]))
                        return s.change;
                    for (i in aList)
                        $(aList[i]).removeClass(s.selected);
                    for (i in idList) {
                        $(idList[i]).hide();
                        $(this).addClass(s.selected);
                        $(id).show();                    
                       
                    }
                    return s.change;
                }

                var list = $("a[href*='#']", tabs).unbind(s.event, showId).bind(s.event, showId);
                list.each(function () {
                    $("#" + this.href.split('#')[1]).hide();
                });
                var test = false;

                if ((test = list.filter('.' + s.selected)).length);
                else if (typeof s.start == "number" && (test = list.eq(s.start)).length);
                else if (typeof s.start == "string" && (test = list.filter("[href*='#" + s.start + "']")).length);
                if (test) { test.removeClass(s.selected); test.trigger(s.event); }

                return s;
            }
            $.idTabs.settings = { start: 0, change: false, click: null, selected: ".selected", event: "!click" }; $.idTabs.version = "2.2"; $(function () { $(".idTabs").idTabs(); });
        })(jQuery);
    }
    return init();;
})();

/* select on focus */
(function ($) {
    $.fn.selectOnFocus = function (opts) {        
        this.click(function () {
                    
            var text = $(this).text();
            var $input = $(this).find("input");

            if ($input.length === 0) {
                
                $input = $('<input style="display: inline-block; background: transparent !important; outline: 0 !important; border: 0 !important;" readonly="true" type=text>');
                $input.css({ "width": $(this).width() });
                if ($(this).attr("class") != "") {
                    $input.addClass($(this).attr("class"));
                }
                              
                $input.blur(function () {
                    $(this).parent().text(text);
                    $(this).hide();
                });          
                $input.click(function (e) {
                    $(this).select();
                    e.stopPropagation();
                });
                $input.dblclick(function (e) {
                    $(this).select();
                    e.stopPropagation();
                });
                $input.prop('value', text);
                                      
                $(this).text("");
                $(this).append($input);
                $input.focus().select();

            } else {
                
                $(this).empty();
                $(this).append($input);
                $input.focus().select();
            }
                   
      
        });
    }
})(jQuery);

/* tidy ticket text */
(function ($) {
    $.fn.tidyTicket = function (opts) {

        // hide link tooltip on document click
        $(document).click(function (e) {
            if (e.target != null) {
                if (e.target.className != "") {                    
                    if (e.target.className.toLowerCase().indexOf("ikb-link-info") >= 0) {                        
                        return;
                    }
                }              
            }
            $("#linkInfoTip").hide();
        })
              
        // set-up tool tip for hyper links so we can 
        // easily identity the URL links point to
        var $template = $('<div id="linkInfoTip" class="i-float-left ikb-link-info-tip ikb-box ikb-box-dark" style="position: absolute; left:0; top:22px; z-index: 2;"><div class="padding ikb-link-info-padding"><div class="i-type-bold ikb-link-info-text" style="white-space:nowrap; max-width: 400px; text-overflow: ellipsis; overflow: hidden;"></div></div></div>');
        this.find("a").each(function () {
            if ($(this).attr("target") != "_blank") {
                $(this).attr("target", "_blank");
            }
            $(this).data("title", $(this).attr("href"));
                  
            $(this).mouseenter(function () {

                var $tip = $("#linkInfoTip");
                if ($tip.length === 0) {
                    $tip = $template;
                    $tip.mouseleave(function () {
                        $("#linkInfoTip").hide();
                    });
                }                
                var title = $(this).data("title");
                if (title) {
                    title = title.toLowerCase();
                    title = title.replace("mailto:", "");
                }
                
                $tip.find(".ikb-link-info-text").unbind("click");               
                $tip.find(".ikb-link-info-text").text(title);
                $tip.find(".ikb-link-info-text").selectOnFocus();
                $(this).before($('<div style="display: inline !important; position: relative !important;"></div>').append($tip));
                $tip.show();
                                
                if (($tip.offset().left + $tip.width()) >= $(window).width()) {
                    $tip.css({ "margin-left": - Math.floor($tip.width() / 2) });
                } else {
                    $tip.css({ "margin-left": "0" });
                }
            });         

        });

    }
})(jQuery);

/* tidy table */
(function ($) {
    $.fn.tidyTable = function (opts) {
        var $table = this;   
        this.find("input").focus(function () {    
            $(this).closest("tr").find(".i-col-light").addClass("i-col-selected")
        })
        this.find("select").focus(function () {
            $(this).closest("tr").find(".i-col-light").addClass("i-col-selected")
        })
        this.find("input").blur(function () {
            $(this).closest("tr").find(".i-col-light").removeClass("i-col-selected")
        })
        this.find("select").blur(function () {
            $(this).closest("tr").find(".i-col-light").removeClass("i-col-selected")
        })
    }
})(jQuery);

/* editable table */
(function ($) {
    $.fn.editableGrid = function (opts) {

        $.fn.editableGrid.defaults = {         
            toggleRowCssOnHover: true,
            onChange: null
        }

        opts = $.extend({}, $.fn.editableGrid.defaults, opts || {});
        
        // get table and check boxes
        var $table = this, inputs = $table.find("input:checkbox");
                     
        // change css on row enter / leave
        if (opts.toggleRowCssOnHover) {
            this.find("tr").each(function (i) {
                $(this).mouseenter(function () {
                    $(this).find("td").each(function () {
                        if (!$(this).hasClass("i-col-header")) {
                            $(this).addClass("i-col-medium");
                        }
                    });

                });
                $(this).mouseleave(function () {
                    $(this).find("td").each(function () {
                        if (!$(this).hasClass("i-col-header")) {
                            $(this).removeClass("i-col-medium");
                        }
                    });
                });
            });
        }

        // ensure we can just click the column containing the selection check-box
        this.find(".i-row-select").click(function (event) {
            checkCheckBox($(this), event)
        });

        // handle mouse down (left & right click) on select all column
        this.find(".i-row-select-all").mousedown(function (e) {
            $(this).bind("contextmenu", function () {
                return false;
            });
            if (e.which === 3) {
                // invert selection on right click               
                $table.find(".i-row-select").find("input").click();
            } else {
                checkCheckBox($(this), e)
            }
        });

        // select / un-select all input change
        this.find(".i-row-select-all").find("input:checkbox").change(function (e) {
            var checked = $(this).is(":checked");
            var input = $table.find(".i-row-select").find("input:checkbox");
            input.prop("checked", checked);
            if (checked) {
                input.closest("tr").find("td").addClass("i-col-selected");
            } else {
                input.closest("tr").find("td").removeClass("i-col-selected");
            }
        });

        // single row select / un-select input change
        this.find(".i-row-select").find("input").change(function () {
            if ($(this).is(":checked")) {
                $(this).closest("tr").find("td").addClass("i-col-selected");
            } else {
                $(this).closest("tr").find("td").removeClass("i-col-selected");
            }
        });

        // monitor inputs for change 
        inputs.change(function () {

            var checked = $(this).is(":checked");
            var selected = 0;
            inputs.each(function (i) {
                if ($(this).is(":checked")) {
                    checked = true;
                    selected += 1;
                }
            });

            if (opts.onChange) {
                opts.onChange(selected)
            }
            
        });

        // helper for column click
        function checkCheckBox($col, event) {
            var el = event.target || event.srcElement;
            if (el && el.tagName) {
                if (el.tagName.toLowerCase() == "input") { return; }
                if (el.tagName.toLowerCase() == "label") { return; }
            }
            var ckb = $col.find('input')[0];
            if (ckb) {
                ckb.click();
            }

        }

        return this;

    }
})(jQuery);

/* stop watch jQuery plug-in (time worked tracker) - https://github.com/robcowie/jquery-stopwatch */
(function ($) {

    function incrementer(ct, increment) {
        return function () { ct += increment; return ct; };
    }

    function pad2(number) {
        return (number < 10 ? '0' : '') + number;
    }

    function defaultFormatMilliseconds(millis) {
        var x, seconds, minutes, hours;
        x = millis / 1000;
        seconds = Math.floor(x % 60);
        x /= 60;
        minutes = Math.floor(x % 60);
        x /= 60;
        hours = Math.floor(x % 24);
        // x /= 24;
        // days = Math.floor(x);
        return [pad2(hours), pad2(minutes), pad2(seconds)].join(':');
    }

    //NOTE: This is a the 'lazy func def' pattern described at http://michaux.ca/articles/lazy-function-definition-pattern
    function formatMilliseconds(millis, data) {
        // Use jintervals if available, else default formatter
        var formatter;
        if (typeof jintervals == 'function') {
            formatter = function (millis, data) { return jintervals(millis / 1000, data.format); };
        } else {
            formatter = defaultFormatMilliseconds;
        }
        formatMilliseconds = function (millis, data) {
            return formatter(millis, data);
        };
        return formatMilliseconds(millis, data);
    }

    var methods = {

        init: function (options) {         
            var defaults = {
                updateInterval: 1000,
                startTime: 0,
                format: '{HH}:{MM}:{SS}',
                formatter: formatMilliseconds
            };

            // if (options) { $.extend(settings, options); }

            return this.each(function () {
                var $this = $(this),
                    data = $this.data('stopwatch');

                // If the plugin hasn't been initialized yet
                if (!data) {
                    // Setup the stopwatch data
                    var settings = $.extend({}, defaults, options);
                    data = settings;
                    data.active = false;
                    data.target = $this;
                    data.elapsed = settings.startTime;
                    // create counter
                    data.incrementer = incrementer(data.startTime, data.updateInterval);
                    data.tick_function = function () {
                        var millis = data.incrementer();
                        data.elapsed = millis;
                        data.target.trigger('tick.stopwatch', [millis]);
                        data.target.stopwatch('render');
                    };
                    $this.data('stopwatch', data);
                }

            });
        },

        start: function () {
            return this.each(function () {
                var $this = $(this),
                    data = $this.data('stopwatch');
                // Mark as active
                data.active = true;
                data.timerID = setInterval(data.tick_function, data.updateInterval);
                $this.data('stopwatch', data);
            });
        },

        stop: function () {
            return this.each(function () {
                var $this = $(this),
                    data = $this.data('stopwatch');
                clearInterval(data.timerID);
                data.active = false;
                $this.data('stopwatch', data);
            });
        },

        destroy: function () {
            return this.each(function () {
                var $this = $(this),
                    data = $this.data('stopwatch');
                $this.stopwatch('stop').unbind('.stopwatch').removeData('stopwatch');
            });
        },

        render: function () {
            var $this = $(this),
                data = $this.data('stopwatch');
            $this.html(data.formatter(data.elapsed, data));
        },

        getTime: function () {
            var $this = $(this),
                data = $this.data('stopwatch');
            return data.elapsed;
        },

        toggle: function () {
            return this.each(function () {
                var $this = $(this);
                var data = $this.data('stopwatch');
                if (data.active) {
                    $this.stopwatch('stop');
                } else {
                    $this.stopwatch('start');
                }
            });
        },

        reset: function () {
            return this.each(function () {
                var $this = $(this);
                data = $this.data('stopwatch');
                data.incrementer = incrementer(data.startTime, data.updateInterval);
                data.elapsed = data.startTime;
                $this.data('stopwatch', data);
            });
        }
    };


    // Define the function
    $.fn.stopwatch = function (method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method === 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Method ' + method + ' does not exist on jQuery.stopwatch');
        }
    };

})(jQuery);

/* anchorific - automatically link H1, H2, H3 etc */
if (typeof Object.create !== 'function') {
    Object.create = function (obj) {
        function F() { }
        F.prototype = obj;
        return new F();
    };
}

(function ($, window, document, undefined) {
    "use strict";

    var Anchorific = {
        init: function (options, elem) {
            var self = this;

            self.elem = elem;
            self.$elem = $(elem);

            self.opt = $.extend({}, this.opt, options);

            self.headers = self.$elem.find('h1, h2, h3, h4, h5, h6');
            self.previous = 0;

            // Fix bug #1
            if (self.headers.length !== 0) {
                self.first = parseInt(self.headers.prop('nodeName').substring(1), null);
            }

            self.build();
        },
        opt: {
            navigation: '.anchorific', // position of navigation
            speed: 200, // speed of sliding back to top
            anchorClass: 'anchor', // class of anchor links
            anchorText: '', // prepended or appended to anchor headings
            top: '.top', // back to top button or link class
            spy: true, // scroll spy
            position: 'append', // position of anchor text
            spyOffset: !0 // specify heading offset for spy scrolling
        },
        build: function () {
            var self = this, obj, navigations = function () { };
            // when navigation configuration is set
            if (self.opt.navigation) {
                $(self.opt.navigation).append('<ul />');
                self.previous = $(self.opt.navigation).find('ul').last();
                navigations = function (obj) {
                    return self.navigations(obj);
                };
            }

            for (var i = 0; i < self.headers.length; i++) {
                obj = self.headers.eq(i);
                navigations(obj);
                self.anchor(obj);
            }

            if (self.opt.spy)
                self.spy();

            if (self.opt.top)
                self.back();
        },
        navigations: function (obj) {
            var self = this, link, list, which, name = self.name(obj);

            if (obj.attr('id') !== undefined)
                name = obj.attr('id');

            link = $('<a />').attr('href', '#' + name).text(obj.text());
            list = $('<li />').append(link);

            which = parseInt(obj.prop('nodeName').substring(1), null);
            list.attr('data-tag', which);

            self.subheadings(which, list);

            self.first = which;
        },
        subheadings: function (which, a) {
            var self = this, ul = $(self.opt.navigation).find('ul'),
				li = $(self.opt.navigation).find('li');

            if (which === self.first) {
                self.previous.append(a);
            } else if (which > self.first) {
                li.last().append('<ul />');
                // can't use cache ul; need to find ul once more
                $(self.opt.navigation).find('ul').last().append(a);
                self.previous = a.parent();
            } else {
                $('li[data-tag=' + which + ']').last().parent().append(a);
                self.previous = a.parent();
            }
        },
        name: function (obj) {
            var name = obj.text().replace(/[^\w\s]/gi, '')
								.replace(/\s+/g, '-')
								.toLowerCase();

            return name;
        },
        anchor: function (obj) {
            var self = this, name = self.name(obj), anchor, text = self.opt.anchorText,
				klass = self.opt.anchorClass, id;

            if (obj.attr('id') === undefined)
                obj.attr('id', name);

            id = obj.attr('id');

            anchor = $('<a />').attr('href', '#' + id).html(text).addClass(klass);

            if (self.opt.position === 'append') {
                obj.append(anchor);
            } else {
                obj.prepend(anchor);
            }
        },
        back: function () {
            var self = this, body = $('body, html'), top = $(self.opt.top);

            top.on('click', function (e) {
                e.preventDefault();

                body.animate({
                    'scrollTop': 0
                }, self.opt.speed);
            });
        },
        top: function (that) {
            var self = this, top = self.opt.top, back;

            if (top !== false) {
                back = ($(that).scrollTop() > 200) ?
						$(top).fadeIn() :
						$(top).fadeOut();
            }
        },
        spy: function () {
            var self = this, previous, current, list, top, prev;

            $(window).scroll(function (e) {
                // show links back to top
                self.top(this);
                // get all the header on top of the viewport
                current = self.headers.map(function (e) {
                    if (($(this).offset().top - $(window).scrollTop()) < self.opt.spyOffset) {
                        return this;
                    }
                });
                // get only the latest header on the viewport
                current = $(current).eq(current.length - 1);

                if (current && current.length) {
                    // get all li tag that contains href of # ( all the parents )
                    list = $('li:has(a[href="#' + current.attr('id') + '"])');

                    if (prev !== undefined) {
                        prev.removeClass('active');
                    }

                    list.addClass('active');
                    prev = list;
                }
            });
        }
    };

    $.fn.anchorific = function (options) {
        return this.each(function () {
            if (!$.data(this, 'anchorific')) {
                var anchor = Object.create(Anchorific);
                anchor.init(options, this);
                $.data(this, 'anchorific', anchor);
            }
        });
    };

})(jQuery, window, document);
