﻿"use strict";

/* HTTP proxy for API explorer */

var apiExplorer = apiExplorer || (function ($, w) {
     
    var _opts = null;
    
    var _http = function (config) {

        // update URL to include absolute URL
        config.url = _opts.url + config.url;

        // add basic authentication headers
        config.beforeSend = function (xhr) {
            xhr.setRequestHeader("Authorization", "Basic " + _opts.apiKey);
        }

        // set content type & API version
        config.headers = {
            'Content-Type': 'application/json',
            'X-Api-Version': _opts.version
        };

        // from js/sdk/webapi.ks
        return $iHttp.promise(config);

    }

    return {
        init: function (opts) {        
            _opts = opts;
        },
        onError: function (onError) {
            $iHttp.onError(onError);
        },
        onAlways: function (onAlways) {
            $iHttp.onAlways(onAlways);
        },
        submit: function (config, fn) {      
            _http(config).done(function (data, status, xhr) {
                fn(data, status, xhr, config);
            });
        }

    };

}(jQuery, window));

/* JSON expand / collapse plug-in */

!function ($) {

    $.fn.jJsonViewer = function (jjson) {
        return this.each(function () {
            var self = $(this);
            if (typeof jjson == 'string') {
                self.data('jjson', jjson);
            }
            else if (typeof jjson == 'object') {
                self.data('jjson', JSON.stringify(jjson))
            }
            else {
                self.data('jjson', '');
            }
            new JJsonViewer(self);
        });
    };

    function JJsonViewer(self) {             
        var json = $.parseJSON(self.data('jjson'));
        self.html('<ul class="jjson-container"></ul>');
        self.find(".jjson-container").css({ "max-width": (self.parent().innerWidth() - 12) });
        self.find(".jjson-container").append(json2html([json]));
    }

    function json2html(json) {
        var html = "";
        for (var key in json) {
            if (!json.hasOwnProperty(key)) {
                continue;
            }

            var value = json[key],
				type = typeof json[key];

            html = html + createElement(key, value, type);
        }
        return html;
    }

    function encode(value) {
        return $('<div/>').text(value).html();
    }

    function createElement(key, value, type) {
        var klass = "object",
        	open = "{",
        	close = "}";
        if ($.isArray(value)) {
            klass = "array";
            open = "[";
            close = "]";
        }
        if (value === null) {
            return '<li><span class="key">"' + encode(key) + '": </span><span class="null">"' + encode(value) + '"</span></li>';
        }
        if (type == "object") {
            var object = '<li><span class="expanded"></span><span class="key">"' + encode(key) + '": </span> <span class="open">' + open + '</span> <ul class="' + klass + '">';
            object = object + json2html(value);
            return object + '</ul><span class="close">' + close + '</span></li>';
        }
        if (type == "number" || type == "boolean") {
            return '<li><span class="key">"' + encode(key) + '": </span><span class="' + type + '">' + encode(value) + '</span></li>';
        }
        return '<li><span class="key">"' + encode(key) + '": </span><span class="' + type + '">"' + encode(value) + '"</span></li>';
    }

    $(document).on("click", '.jjson-container .expanded', function (event) {
        event.preventDefault();
        event.stopPropagation();
        $(this).addClass('collapsed').parent().find(">ul").hide();
    });

    $(document).on('click', '.jjson-container .expanded.collapsed', function (event) {
        event.preventDefault();
        event.stopPropagation();
        $(this).removeClass('collapsed').parent().find(">ul").show();
    });

}(window.jQuery);

/* convert query string parameters into JSON object */

var jq_deparam = null;
$.deparam = jq_deparam = function (params, coerce) {
    var obj = {},
      coerce_types = { 'true': !0, 'false': !1, 'null': null };
    $.each(params.replace(/\+/g, ' ').split('&'), function (j, v) {
        var param = v.split('='),
          key = decodeURIComponent(param[0]),
          val,
          cur = obj,
          i = 0,

          keys = key.split(']['),
          keys_last = keys.length - 1;

        if (/\[/.test(keys[0]) && /\]$/.test(keys[keys_last])) {
            keys[keys_last] = keys[keys_last].replace(/\]$/, '');
            keys = keys.shift().split('[').concat(keys);
            keys_last = keys.length - 1;
        } else {
            keys_last = 0;
        }

        if (param.length === 2) {
            val = decodeURIComponent(param[1]);

            // Coerce values.
            if (coerce) {
                val = val && !isNaN(val) ? +val              // number
                  : val === 'undefined' ? undefined         // undefined
                  : coerce_types[val] !== undefined ? coerce_types[val] // true, false, null
                  : val;                                                // string
            }

            if (keys_last) {

                for (; i <= keys_last; i++) {
                    key = keys[i] === '' ? cur.length : keys[i];
                    cur = cur[key] = i < keys_last
                      ? cur[key] || (keys[i + 1] && isNaN(keys[i + 1]) ? {} : [])
                      : val;
                }

            } else {

                if ($.isArray(obj[key])) {
                    obj[key].push(val);
                } else if (obj[key] !== undefined) {
                    obj[key] = [obj[key], val];
                } else {
                    obj[key] = val;
                }
            }

        } else if (key) {
            obj[key] = coerce
              ? undefined
              : '';
        }
    });
    return obj;
};
