﻿"use strict";

function initAPIExplorer(baseUrl) {

    var $hypGetAPIKey = $("#hypGetAPIKey"),
        $ddlAgents = $("#ddlAgents "),
        $txtAPIKey = $("#txtAPIKey"),
        $txtHiddenAPIKey = $("#txtHiddenAPIKey"),
        $ddlMethod = $("#ddlMethod"),
        $ddlVersion = $("#ddlVersion"),
        $ddlController = $("#ddlController"),
        $txtParams = $("#txtParams"),
        $txtJSON = $("#txtJSON"),
        $txtResponseJSON = $("#txtResponseJSON"),
        $hypSubmit = $("#hypSubmit"),
        $results = $("#results"),
        $response = $("#response"),
        $request = $("#request"),
        $error = $("#error"),
        $statusResponse = $("#statusResponse");

    // ----------------------
    // set-up API explorer
    // ----------------------

    apiExplorer.onError(function (config, xhr, ajaxOptions, thrownError) {
        $results.show();
        $response.hide();
        $request
            .find("pre").html(getRequestTemplate(config));
        $statusResponse
            .find("pre").html(getResponseTemplate(xhr, ajaxOptions, thrownError));
        $error
            .show()
            .find("pre")
            .empty()
            .jJsonViewer(xhr.responseText);
        $txtResponseJSON
                .val(JSON.stringify(xhr.responseText));
    })

    apiExplorer.onAlways(function () {
        var msg = $("<span>").html("request complete<br>");
        $("#always").append(msg);
        iasp_AjaxExtensionsEndRequest();
    })

    // ----------------------
    // bind events
    // ----------------------

    $(".i-tabs-o").idTabs();

    $ddlAgents.change(function () {
        $txtAPIKey.val($(this).val());
    });

    $txtAPIKey.focus(function () {
        $(this).select();
    });

    $ddlMethod.change(function () {
        if (isPostOrPut()) {
            $("#pnlParams").show();

            if ($ddlController.val() != "api/articles" &&
                $ddlController.val() != "api/search" &&
                $ddlController.val() != "api/tickets") {
                $("#txtParams").val("");
            }
            
        } else {
            $("#pnlParams").hide();
        }
        updateUIForMethodAndController();
    });

    $ddlController.change(function () {
        updateUIForMethodAndController();
    });

    $hypSubmit.click(function () {
               
        if ($txtAPIKey.val() == "") {
            return;
        }

        // show loader
        iasp_AjaxExtensionsInitializeRequest();

        /* convert query string parameters to JSON object
        /* $.deparam within apiexplore.js */
        var params = {},            
            method = $ddlMethod.val(),
            url = $ddlController.val();

        if ($txtParams.val() != "") {
            params = $.deparam($txtParams.val().replace("?", ""), true);
        }

        // finally stringify params for post & puts
        if (isPostOrPut()) {
            params = getObjectFromInputs();
            try {
                params = JSON.stringify(params)
            } catch (e) {
                alert("An error occurred parsing the supplied values! " + e)
            }
        }

        apiExplorer.init({
            url: baseUrl,
            version: parseInt($ddlVersion.val()),
            apiKey: $txtAPIKey.val()
        });
 
        // edge case for paged endpoints
        if (method == "POST") {
            if (url == "api/articles" || url == "api/search" ||  url == "api/tickets") {
                url = url + $txtParams.val();
            }
        }
        
        // if we have typed JSON used that
        if ($txtJSON.val() != "") {
            try {
                params = $txtJSON.val();
            } catch (e) {
                alert("An error occurred parsing the supplied JSON! " + e)
            }
        }
        
      
        
        // clear params for DELETE
        if (method == "DELETE") {
            url = url + $txtParams.val();
            params = {};
        }
            
        // make request
        apiExplorer.submit({
            url: url,
            method: $ddlMethod.val(),
            data: params
        }, function (data, statusText, xhr, config) {
            var result = JSON.stringify(data, null, 4);
            $results.show();
            $error.hide();
            $request
                .find("pre").html(getRequestTemplate(config));
            $statusResponse
                .find("pre").html(getResponseTemplate(xhr, null, statusText));
            $response
                .show()
                .find("pre")
                .jJsonViewer(result);
            $txtResponseJSON
                .val(JSON.stringify(data));
        });
    })

    // helpers

    function getObjectFromInputs() {

        var params = {};

        // build custom fields
        var $paramContainer = $("#paramsContainer");
        if ($paramContainer.is(":visible")) {
            var paramVal = "";
            $paramContainer.find("input").each(function (index) {
                if ($(this).val() != "") {
                    paramVal += $(this).val();
                    if (($paramContainer.find("input").length - 1) != index) {
                        if ($(this).data("type") == "name") {
                            paramVal += "=";
                        } else {
                            paramVal += "&";
                        }
                    }
                }
            });
            if (paramVal != "") {
                params = $.deparam(paramVal.replace("?", ""), true);
            }
        }
    }
    function updateUIForMethodAndController() {

        if ($ddlMethod.val() == "DELETE") {
            resetPostAndPut();
            switch ($ddlController.val()) {
                case "api/auth":
                    $txtParams.val("?app_secret=");
                    break;
                case "api/login":
                    $txtParams.val("");
                    break;
                case "api/tickets":
                    $txtParams.val("");
                    break;
                case "api/ticket":
                    $txtParams.val("?id=1");
                    break;
                case "api/reply":
                    $txtParams.val("?id=1");
                    break;
                case "api/articles":
                    $txtParams.val("");
                    break;
                case "api/article":
                    $txtParams.val("?id=1");
                    break;
                case "api/category":
                    $txtParams.val("?id=1");
                    break;
                case "api/user":
                    $txtParams.val("?id=1");
                    break;
                case "api/tab":
                    $txtParams.val("?id=1");
                    break;
                case "api/note":
                    $txtParams.val("?id=1");
                    break;
                case "api/status":
                    $txtParams.val("?id=1");
                    break;
                case "api/priority":
                    $txtParams.val("?id=1");
                    break;
                case "api/type":
                    $txtParams.val("?id=1");
                    break;
                case "api/level":
                    $txtParams.val("?id=1");
                    break;
                case "api/workflow":
                    $txtParams.val("?id=1");
                    break;
                case "api/workflowstep":
                    $txtParams.val("?id=1");
                    break;
                case "api/department":
                    $txtParams.val("?id=1");
                    break;
                case "api/field":
                    $txtParams.val("?id=1");
                    break;
                case "api/fieldtemplate":
                    $txtParams.val("?id=1");
                    break;
                case "api/picklist":
                    $txtParams.val("?id=1");
                    break;
                case "api/fieldtemplatedetail":
                    $txtParams.val("?id=1");
                    break;
                case "api/attachmenttype":
                    $txtParams.val("?id=1");
                    break;
                case "api/view":
                    $txtParams.val("?id=1");
                    break;
                case "api/search":
                    $txtParams.val("?page_index=1&page_size=10&keywords=example+keywords");
                    break;
                case "api/sla":
                    $txtParams.val("?id=1");
                    break;
                case "api/rule":
                    $txtParams.val("?id=1");
                    break;
                case "api/role":
                    $txtParams.val("?id=1");
                    break;
                case "api/term":
                    $txtParams.val("?id=1");
                    break;
                case "api/tag":
                    $txtParams.val("?id=1");
                    break;
                case "api/level":
                    $txtParams.val("?id=1");
                    break;
                case "api/list":
                    $txtParams.val("?id=1");
                    break;
                case "api/relatedlink":
                    $txtParams.val("?id=1");
                    break;
                default:
                    $txtParams.val("");
                    break;
            }
        }

        if ($ddlMethod.val() == "GET") {
            resetPostAndPut();
            switch ($ddlController.val()) {
                case "api/auth":
                    $txtParams.val("?app_secret=");
                    break;
                case "api/login":
                    $txtParams.val("?username=&password=");
                    break;
                case "api/tickets":
                    $txtParams.val("?page_index=1&page_size=20");
                    break;
                case "api/ticket":
                    $txtParams.val("?id=1");
                    break;
                case "api/reply":
                    $txtParams.val("?id=1");
                    break;
                case "api/articles":
                    $txtParams.val("?page_index=1&page_size=20");
                    break;
                case "api/article":
                    $txtParams.val("?id=1");
                    break;
                case "api/categories":
                    $txtParams.val("?tab_id=1&parent_id=0");
                    break;
                case "api/category":
                    $txtParams.val("?id=1");
                    break;
                case "api/users":
                    $txtParams.val("");
                    break;
                case "api/user":
                    $txtParams.val("?id=1");
                    break;
                case "api/tabs":
                    $txtParams.val("");
                    break;
                case "api/tab":
                    $txtParams.val("?id=1");
                    break;
                case "api/notes":
                    $txtParams.val("?ticket_id=1");
                    break;
                case "api/note":
                    $txtParams.val("?id=1");
                    break;
                case "api/statuses":
                    $txtParams.val("?tab_id=1");
                    break;
                case "api/status":
                    $txtParams.val("?id=1");
                    break;
                case "api/priorities":
                    $txtParams.val("?tab_id=1");
                    break;
                case "api/priority":
                    $txtParams.val("?id=1");
                    break;
                case "api/types":
                    $txtParams.val("?tab_id=1");
                    break;
                case "api/type":
                    $txtParams.val("?id=1");
                    break;
                case "api/levels":
                    $txtParams.val("?tab_id=1");
                    break;
                case "api/level":
                    $txtParams.val("?id=1");
                    break;
                case "api/lists":
                    $txtParams.val("");
                    break;
                case "api/list":
                    $txtParams.val("?id=1");
                    break;
                case "api/workflows":
                    $txtParams.val("?tab_id=1");
                    break;
                case "api/workflow":
                    $txtParams.val("?id=1");
                    break;
                case "api/workflowsteps":
                    $txtParams.val("?work_flow_id=1");
                    break;
                case "api/workflowstep":
                    $txtParams.val("?id=1");
                    break;
                case "api/departments":
                    $txtParams.val("");
                    break;
                case "api/department":
                    $txtParams.val("?id=1");
                    break;
                case "api/fields":
                    $txtParams.val("?tab_id=1");
                    break;
                case "api/field":
                    $txtParams.val("?id=1");
                    break;
                case "api/fieldtemplates":
                    $txtParams.val("?tab_id=1");
                    break;
                case "api/fieldtemplate":
                    $txtParams.val("?id=1");
                    break;
                case "api/fieldtemplatedetails":
                    $txtParams.val("?field_template_id=1");
                    break;
                case "api/fieldtemplatedetail":
                    $txtParams.val("?id=1");
                    break;
                case "api/picklistvalues":
                    $txtParams.val("?pick_list_id=1");
                    break;
                case "api/picklistvalue":
                    $txtParams.val("?id=1");
                    break;
                case "api/attachmenttypes":
                    $txtParams.val("?tab_id=1");
                    break;
                case "api/attachmenttype":
                    $txtParams.val("?id=1");
                    break;
                case "api/views":
                    $txtParams.val("?tab_id=1");
                    break;
                case "api/view":
                    $txtParams.val("?id=1");
                    break;
                case "api/search":
                    $txtParams.val("?page_index=1&page_size=20&keywords=test");
                    break;
                case "api/slas":
                    $txtParams.val("?tab_id=1");
                    break;
                case "api/sla":
                    $txtParams.val("?id=1");
                    break;
                case "api/rules":
                    $txtParams.val("?tab_id=1");
                    break;
                case "api/rule":
                    $txtParams.val("?id=1");
                    break;
                case "api/roles":
                    $txtParams.val("");
                    break;
                case "api/role":
                    $txtParams.val("?id=1");
                    break;
                case "api/terms":
                    $txtParams.val("?pageIndex=1&pageSize=20&prefix=a");
                    break;
                case "api/term":
                    $txtParams.val("?id=1");
                    break;
                case "api/tags":
                    $txtParams.val("?grouped=1&entity_id=0");
                    break;
                case "api/tag":
                    $txtParams.val("?id=1");
                    break;
                case "api/relatedlinks":
                    $txtParams.val("?article_id=1");
                    break;
                case "api/relatedlink":
                    $txtParams.val("?id=1");
                    break;

            }
        }
    }

    function isPostOrPut() {
        if ($ddlMethod.val() == "POST" || $ddlMethod.val() == "PUT") {
            return true;
        }
        return false;
    }

    function getRequestTemplate(config) {

        var s = "";

        s += config.method;
        s += " ";

        var virtualPath = config.url.replace(baseUrl, "");
        if ($ddlMethod.val() == "DELETE") {
            s += virtualPath;
        } else {
            s += virtualPath + $txtParams.val();
        }

        s += " HTTP/1.1<br/>";
        s += "Host: ";
        s += baseUrl;
        s += "<br/>";

        if ($txtAPIKey.val() != "") {
            s += "Authorization: Basic " + $txtAPIKey.val();
            s += "<br/>";
        }
      
        if (config.headers != null) {
            $.each(config.headers, function (key, value) {
                s += key + ": " + value;
                s += "<br/>";
            });
        }

        if (config.data != null && isPostOrPut()) {
            s += "<br/>";
            s += "data: ";
            s += JSON.stringify(config.data, null, 4);
        }


        return s;

    }

    function getResponseTemplate(xhr, ajaxOptions, thrownError) {
        var s = xhr.status;
        s += " ";
        s += xhr.statusText;
        return s;
    }

}

function resetPostAndPut() {
    resetPostAndPutJSON();
    resetPostAndPutInputs();
}

function resetPostAndPutInputs() {
    $("#paramsContainer").hide();
    $("#paramsContainer").empty();
}

function resetPostAndPutJSON() {
    $("#txtJSON").val("");
    $("#jsonContainer").hide();
}

function addJSON() {
    var $jsonContainer = $("#jsonContainer");
    if ($jsonContainer.is(":visible")) {
        resetPostAndPutJSON();
    } else {
        resetPostAndPutInputs();
        $jsonContainer.show();
    }
}

function addParam() {

    resetPostAndPutJSON();

    var $paramContainer = $("#paramsContainer");
    $paramContainer.show();
    var id = new Date().getTime();

    var newItem = $('<span class="i-row i-margin-bottom">');
    newItem.attr("id", id);

    var name = $('<input placeholder="name" class="i-text-box i-margin-right" style="width: 125px;" data-type="name" type="text"/>')
    var value = $('<input placeholder="value" class="i-text-box i-margin-right" style="width: 600px;" data-type="value" type="text"/>')
    var del = $('<a href="javascript:void(0);" class="i-btn i-btn-default"><span><i class="fa fa-times"></i></span></a>');
    del.data("id", id);

    newItem.append(name);
    newItem.append(value);
    newItem.append(del);

    del.click(function () {
        var id = $(this).data("id");
        $paramContainer.find("#" + id).remove();
    });

    $paramContainer.append(newItem);

}