﻿(function ($, doc, win, olark, opts) {

    $(doc).ready(function () {

        var callbackURL = opts.callbackURL;
    
        // -----------------
        // conversation start
        // -----------------

        olark('api.chat.onBeginConversation', function () {
                   
            getUser(function (user) {  });        

        });

        // -----------------
        // message to operator, message to visitor
        // -----------------
            
        var ticket = null;
        var user = null;

        olark('api.chat.onMessageToOperator', function (event) {

            getUser(function (user) {
                postMessageToOperator(user, ticket, event.message.body, function (newTicket) {
                    if (ticket == null) {
                        ticket = newTicket;
                    }         
                });
            });
                 
        });
        
        olark('api.chat.onMessageToVisitor', function (event) {
                              
            getUser(function (user) {
                postMessageToVisitor(user, ticket, event.message.body, function (newTicket) {
                    if (ticket == null) {
                        ticket = newTicket;
                    }
                });
            });
                   

        });

        // -----------------
        // send offline message
        // -----------------
        
        olark('api.chat.onOfflineMessageToOperator', function (event) {

            alert(event.message.body);


            // Example code
            yourAnalytics.track("sent_an_offline_message");

        });
        
        // -----------------
        // helpers
        // -----------------

        var user = null;
        function getUser(fn) {
            if (user == null) {
                olark('api.visitor.getDetails', function (details) {
                           
                    var data = {
                        fullName: details.fullName,
                        emailAddress: details.emailAddress,
                        phoneNumber: details.phoneNumber,
                        ip: details.ip,
                        country: details.country,
                        city: details.city,
                        browser: details.browser,
                        operatingSystem: details.operatingSystem
                    };
                                 
                    $.ajax({
                        type: "POST",
                        url: callbackURL + "&Action=ChatConversationStart",
                        cache: false,                        
                        contentType: "application/x-www-form-urlencoded; charset=utf-8",
                        data: data,
                        dataType: "xml",
                        async: true,
                        encode: true,
                        success: function (xml) {
                            var items = $(xml)[0].getElementsByTagName("result");
                            if (items.length > 0) {
                                for (var i = 0; i < items.length; i++) {
                                    var nd = items[i];                              
                                    var identity = nd.getAttribute("identity") == null ? 0 : parseInt(nd.getAttribute("identity"));
                                    if (identity > 0) {
                                        user = details;
                                        user.UserID = identity;
                                        fn(user)
                                    }         
                                }
                            }       
                        },
                        error: ajaxError
                    });

                });
            } else {
                fn(user)
            }            
        }

        function postMessageToOperator(user, ticket, message, fn) {
                    
            var data = {
                userId: user.UserID,
                ticketId: (ticket ? ticket.TicketID : 0),
                message: message
            };
                       
            $.ajax({
                type: "POST",
                url: callbackURL + "&Action=ChatMessageToOperator",
                cache: false,
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                data: data,
                dataType: "xml",
                async: true,
                encode: true,
                success: function (xml) {
                    var items = $(xml)[0].getElementsByTagName("result");
                    if (items.length > 0) {
                        for (var i = 0; i < items.length; i++) {
                            var nd = items[i];
                            var identity = nd.getAttribute("identity") == null ? 0 : parseInt(nd.getAttribute("identity"));
                            if (identity > 0) {
                                fn({
                                    TicketID: identity
                                });
                            }
                        }
                    }
                },
                error: ajaxError
            });

        }
        
        function postMessageToVisitor(user, ticket, message, fn) {

            var data = {
                userId: user.UserID,
                ticketId: (ticket ? ticket.TicketID : 0),
                message: message
            };
                   
            $.ajax({
                type: "POST",
                url: callbackURL + "&Action=ChatMessageToVisitor",
                cache: false,
                contentType: "application/x-www-form-urlencoded; charset=utf-8",
                data: data,
                dataType: "xml",
                async: true,
                encode: true,
                success: function (xml) {
                    var items = $(xml)[0].getElementsByTagName("result");
                    if (items.length > 0) {
                        for (var i = 0; i < items.length; i++) {
                            var nd = items[i];
                            var identity = nd.getAttribute("identity") == null ? 0 : parseInt(nd.getAttribute("identity"));
                            if (identity > 0) {
                                fn({
                                    TicketID: identity
                                });
                            }
                        }
                    }
                },
                error: ajaxError
            });

        }

        function ajaxError(xmlRequest) {

            if (xmlRequest.status != "0") {
                alert("Status Code: " + xmlRequest.status + ' \n\r ' +
                    "Status: " + xmlRequest.statusText + '\n\r' +
                    "Response: " + xmlRequest.responseText);
            }

        }

    });

})(jQuery, document, window, olark, olarkOpts);

