-- *****************************************************************************************
-- InstantKB.NET v1.2 from v1.1 update script.
-- This script will convert an InstantKB v1.1 database to a InstantKB v1.2 database. 
-- To run this script please select your database within query analyzer and run this script.
-- The script will delete all your previous stored procs, add the new database tables,
-- and set-up new relationships with your existing tables.
-- *****************************************************************************************

-- convert article body field to nText datatype

ALTER TABLE [dbo].[InstantKB_Articles] 
ALTER COLUMN AnswerText ntext
GO

-- add new column to InstantKB_Tree table

ALTER TABLE [dbo].[InstantKB_Tree] 
ADD IconPath nvarchar(255) NULL
GO

-- delete all existing sp's

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AddComments]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AddComments]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AddRating]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AddRating]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminAddAdmin]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminAddAdmin]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminAddArticle]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminAddArticle]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminAddAttachment]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminAddAttachment]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminAddCategory]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminAddCategory]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminAddCategoryRoles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminAddCategoryRoles]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminAddUser]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminAddUser]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminAddUserRole]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminAddUserRole]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminAddUserRoles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminAddUserRoles]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminApproveComment]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminApproveComment]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminDeleteArticle]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminDeleteArticle]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminDeleteAttachment]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminDeleteAttachment]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminDeleteCategory]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminDeleteCategory]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminDeleteComment]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminDeleteComment]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminDeleteRole]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminDeleteRole]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminDeleteTreeRoles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminDeleteTreeRoles]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminDeleteUser]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminDeleteUser]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminDeleteUserRoles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminDeleteUserRoles]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminGetAdminDetails]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminGetAdminDetails]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminGetCategoryInformation]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminGetCategoryInformation]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminGetNodes]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminGetNodes]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminGetUserDetails]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminGetUserDetails]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminLogin]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminLogin]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminSearchArticles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminSearchArticles]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminUpdateAdmin]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminUpdateAdmin]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminUpdateArticle]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminUpdateArticle]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminUpdateCategoryInformation]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminUpdateCategoryInformation]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminUpdateComment]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminUpdateComment]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminUpdateLastLogin]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminUpdateLastLogin]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminUpdateRole]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminUpdateRole]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_AdminUpdateUser]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_AdminUpdateUser]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_CheckUserRolesAgainstNodeID]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_CheckUserRolesAgainstNodeID]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetAdminLastLogin]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetAdminLastLogin]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetAllNodeIDs]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetAllNodeIDs]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetArticle]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetArticle]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetArticleCount]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetArticleCount]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetArticleRating]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetArticleRating]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetArticleTitle]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetArticleTitle]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetArticles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetArticles]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetAttachments]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetAttachments]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetAuthorEmail]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetAuthorEmail]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetAuthorName]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetAuthorName]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetComments]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetComments]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetKBStatisics]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetKBStatisics]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetLatestArticles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetLatestArticles]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetNavBarLinkInfo]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetNavBarLinkInfo]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetNodeIDForArticle]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetNodeIDForArticle]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetNodeRoleRelationships]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetNodeRoleRelationships]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetNodeTitle]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetNodeTitle]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetNodes]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetNodes]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetParentNodeIDs]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetParentNodeIDs]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetPopularArticles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetPopularArticles]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetRoles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetRoles]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetUserRoleRelationships]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetUserRoleRelationships]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetUserRoles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetUserRoles]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetUserRolesForDDL]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetUserRolesForDDL]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_GetUsers]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_GetUsers]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_IncrementArticleViews]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_IncrementArticleViews]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_ObtainDatabaseInformation]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_ObtainDatabaseInformation]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_doSearch]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_doSearch]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ikb_sp_hasChildren]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ikb_sp_hasChildren]
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS OFF 
GO

-- create updated sp's

CREATE Procedure ikb_sp_AddComments (
@comments nvarchar(1000),
@articleID int
) AS
INSERT INTO InstantKB_Comments (articleID, Comments, DateStamp, Approved) VALUES (@articleID, @comments, GetDate(), 0)
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AddRating (
@rating int,
@articleID int
) AS
INSERT INTO InstantKB_Ratings (rating, questionID) VALUES (@rating, @articleID)
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminAddAdmin(
@strFullName nvarchar(150),
@strEmailAddress nvarchar(150),
@strUserName nvarchar(150),
@strPassword nvarchar(150)
)  AS
INSERT INTO InstantKB_AdminUsr (FullName, EmailAddress, Username, KBPassword, DateCreated) VALUES (@strFullName, @strEmailAddress, @strUserName, @strPassword, GetDate())
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminAddArticle (
@strArticleQuestion varchar(500),
@strArticleKeywords varchar(500),
@strSuggestedBy varchar(150),
@strSuggestedByEmail varchar(150),
@intSuggestedFlag bit,
@strCategory varchar(75),
@strWYSIWYG ntext,
@strRelatedLinks varchar(800),
@strRelatedArticles varchar(200),
@strArticleStatus varchar(1),
@intAdminID int,
@strArticleType varchar(100)
)  AS

If (@strArticleKeywords = "")
BEGIN
	SET @strArticleKeywords = null
END

If (@strArticleQuestion = "")
BEGIN
	SET @strArticleQuestion = null
END

If (@strSuggestedBy = "")
BEGIN
	SET @strSuggestedBy = null
END
If (@strSuggestedByEmail = "")
BEGIN
	SET @strSuggestedByEmail = null
END
If (@intSuggestedFlag = "")
BEGIN
	SET @strSuggestedByEmail = null
END
If (@strCategory = "")
BEGIN
	SET @strCategory = null
END
If (@strRelatedLinks = "")
BEGIN
	SET @strRelatedLinks = null
END
If (@strRelatedArticles = "")
BEGIN
	SET @strRelatedArticles = null
END
If (@strArticleStatus = "")
BEGIN
	SET @strRelatedArticles = null
END
If (@intAdminID = "")
BEGIN
	SET @intAdminID = null
END
If (@strArticleType = "")
BEGIN
	SET @strArticleType = null
END
INSERT INTO InstantKB_Articles 
(QuestionText, Keywords, AnswerText, SuggestedBy, SuggestedByEmail, SuggestedFlag, RelatedLinks, RelatedArticles, DateStamp, LastModified, NoOfViews, PublishToWeb, AdminID, NodeID, ArticleType)
VALUES (@strArticleQuestion, @strArticleKeywords, @strWYSIWYG, @strSuggestedBy, @strSuggestedByEmail, @intSuggestedFlag, @strRelatedLinks, @strRelatedArticles, 
GetDate(), GetDate(), 1, @strArticleStatus, @intAdminID, @strCategory, @strArticleType)
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminAddAttachment (
@FileName nVarChar(150),
@articleID Int
)  AS
INSERT INTO InstantKB_Attachments (questionID, Document, DateStamp) VALUES (@articleID,@FileName, GetDate())
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminAddCategory(
@nodeID nvarchar(75),
@nodeName nvarchar(300),
@parentNodeID nvarchar(75),
@sortOrder int,
@customIcon nvarchar(75)
)  AS
If (@customIcon = "")
BEGIN
	SET @customIcon = null
END
INSERT INTO InstantKB_Tree (NodeID, NodeName, ParentNodeID, SortOrder, IconPath) VALUES (@nodeID,@nodeName, @parentNodeID, @sortOrder, @customIcon)
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminAddCategoryRoles (
@nodeID nvarchar(75),
@roleID int
)  AS
INSERT INTO InstantKB_TreeRoles (NodeID, RoleID) VALUES (@nodeID, @roleID)
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminAddUser (
@Username nvarchar(255),
@Password nvarchar(255),
@UserID int output
) AS

IF (@Username = "")
BEGIN 
	SET @Username = null
END

IF (@Password = "")
BEGIN 
	SET @Password = null
END

INSERT INTO InstantKB_Users (Username, [Password]) VALUES (@Username, @Password)
SET @UserID = (SELECT @@IDENTITY)

return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminAddUserRole (
@RoleName nvarchar(255)
)  AS
INSERT INTO InstantKB_Roles (RoleDescription) VALUES (@RoleName)
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminAddUserRoles (
@UserID int,
@RoleID int
)  AS
INSERT INTO InstantKB_UserRoles (UserID, RoleID) VALUES (@UserID, @RoleID)
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminApproveComment (
@commentID Int
)  AS
UPDATE InstantKB_Comments SET Approved = 1 WHERE commentID = @commentID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminDeleteArticle (
@articleID Int
)  AS
DELETE FROM InstantKB_Articles WHERE QuestionID = @articleID
DELETE FROM InstantKB_Attachments WHERE QuestionID = @articleID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminDeleteAttachment (
@attachmentID int,
@filename nvarchar(150) output
) AS
    
SET @filename = (SELECT document FROM InstantKB_Attachments WHERE AttachmentID =  @attachmentID)
DELETE FROM InstantKB_Attachments WHERE AttachmentID = @attachmentID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminDeleteCategory (
@categoryID nvarchar(75)
)  AS
DELETE FROM InstantKB_Tree WHERE NodeID = @categoryID
DELETE FROM InstantKB_Articles WHERE NodeID = @categoryID
DELETE FROM InstantKB_TreeRoles WHERE NodeID = @categoryID
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminDeleteComment (
@commentID Int
)  AS
DELETE FROM InstantKB_Comments WHERE commentID = @commentID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminDeleteRole (
@RoleID Int
)  AS

DELETE FROM InstantKB_Roles WHERE RoleID = @RoleID

return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminDeleteTreeRoles (
@NodeID nvarchar(75)
)  AS
DELETE FROM InstantKB_TreeRoles WHERE NodeID = @NodeID
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminDeleteUser (
@UserID int
)  AS
DELETE FROM InstantKB_Users WHERE UserID = @UserID
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminDeleteUserRoles (
@UserID int
)  AS
DELETE FROM InstantKB_UserRoles WHERE UserID = @UserID
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminGetAdminDetails (
@adminID int
) AS
    
SELECT FullName, EmailAddress, Username, KBPassword FROM InstantKB_AdminUsr WHERE UserID = @adminID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminGetCategoryInformation (
@nodeID nvarchar(75)
) AS
SELECT NodeName, ParentNodeID, SortOrder, IconPath FROM InstantKb_Tree WHERE NodeID = @nodeID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminGetNodes (
@ParentID nvarchar(75)
) AS

SELECT * FROM InstantKB_Tree WHERE ParentNodeID = @ParentID ORDER BY SortOrder DESC, NodeName ASC

return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminGetUserDetails (
@UserID int
) AS
    
SELECT* FROM InstantKB_Users WHERE UserID = @UserID
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminLogin (
@UserName nvarchar(255),
@PassWord nvarchar(255),
@UserID int output
) AS
    
IF Not exists (SELECT * FROM InstantKB_AdminUsr WHERE Username = @UserName AND KBPassword = @PassWord)
	BEGIN
		SET @UserID = 0
	END 
	ELSE
	BEGIN 
		SET @UserID = (SELECT UserID FROM InstantKB_AdminUsr WHERE Username = @UserName AND KBPassword = @PassWord)
	END
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminSearchArticles (
@strKeyword nvarchar(255)
) AS
SELECT QuestionText, LastModified, QuestionID, DateStamp, ArticleType, PublishToWeb FROM InstantKB_Articles
WHERE (QuestionText LIKE '%' + @strKeyword + '%' or AnswerText LIKE '%' + @strKeyword + '%' or Keywords LIKE '%' + @strKeyword + '%') AND (SuggestedFlag = 0) ORDER BY DateStamp DESC, LastModified DESC, QuestionText ASC
return


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminUpdateAdmin (
@strFullName nvarchar(150),
@strEmailAddress nvarchar(150),
@strUserName nvarchar(150),
@strPassword nvarchar(150),
@intAdminID int
)  AS
UPDATE InstantKB_AdminUsr
SET FullName = @strFullName,
EmailAddress = @strEmailAddress,
Username = @strUserName,
KBPassword = @strPassword
WHERE UserID = @intadminID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminUpdateArticle (
@strArticleQuestion varchar(500),
@strArticleKeywords varchar(500),
@strSuggestedBy varchar(150),
@strSuggestedByEmail varchar(150),
@strCategory varchar(75),
@strWYSIWYG ntext,
@strRelatedLinks varchar(800),
@strRelatedArticles varchar(200),
@strArticleStatus varchar(1),
@strPrevSuggestionBy varchar(10),
@strArticleType varchar(100),
@intAdminID int,
@intQuestionID int
)  AS

DECLARE @suggestedFlag int
If (@strArticleQuestion = "")
BEGIN
	SET @strArticleQuestion = null
END
If (@strArticleKeywords = "")
BEGIN
	SET @strArticleKeywords = null
END
If (@strSuggestedBy = "")
BEGIN
	SET @strSuggestedBy = null
END
If (@strSuggestedByEmail = "")
BEGIN
	SET @strSuggestedByEmail = null
END
If (@strCategory = "")
BEGIN
	SET @strCategory = null
END
If (@strRelatedLinks = "")
BEGIN
	SET @strRelatedLinks = null
END
If (@strRelatedArticles = "")
BEGIN
	SET @strRelatedArticles = null
END
If (@strArticleStatus = "")
BEGIN
	SET @strArticleStatus = null
END
If (@strArticleType = "")
BEGIN
	SET @strArticleType = null
END
If (@intAdminID = "")
BEGIN
	SET @intAdminID = null
END

IF (@strArticleStatus = "0" AND @strPrevSuggestionBy = "True") -- if article is not published within kb keep suggestedFlag as true
BEGIN
	SET @SuggestedFlag = 1
END
	ELSE -- only set suggested to false when a question has been approved
BEGIN
	SET @SuggestedFlag = 0
END
 
UPDATE InstantKB_Articles SET QuestionText = @strArticleQuestion,
Keywords = @strArticleKeywords,
AnswerText = @strWYSIWYG,
SuggestedBy = @strSuggestedBy,
SuggestedByEmail = @strSuggestedByEmail,
suggestedFlag = @suggestedFlag,
RelatedLinks = @strRelatedLinks,
RelatedArticles = @strRelatedArticles,
LastModified = GetDate(),
PublishToWeb = @strArticleStatus,
NodeID =  @strCategory,
AdminID = @intAdminID,
ArticleType = @strArticleType
WHERE QuestionID = @intQuestionID
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminUpdateCategoryInformation (
@NodeID varchar(75),
@NodeName varchar(300),
@ParentNodeID varchar(75),
@SortOrder int,
@IconPath varchar(75)
)  AS
DECLARE @suggestedFlag int
If (@NodeName = "")
BEGIN
	SET @NodeName = null
END
If (@SortOrder = "")
BEGIN
	SET @SortOrder = 0
END
If (@IconPath = "")
BEGIN
	SET @IconPath = null
END
UPDATE InstantKB_Tree SET NodeName = @NodeName, 
ParentNodeID = @ParentNodeID,
SortOrder = @SortOrder, IconPath = @IconPath WHERE NodeID = @NodeID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminUpdateComment (
@commentID Int,
@comment nvarchar(1000)
)  AS
UPDATE InstantKB_Comments SET comments = @comment WHERE commentID = @commentID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminUpdateLastLogin (
@adminID int
) AS
    
IF exists (SELECT * FROM InstantKB_AdminUsr WHERE UserID = @adminID)
BEGIN
	UPDATE InstantKB_AdminUsr SET LastLogin = GetDate() WHERE UserID = @adminID
END
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminUpdateRole (
@RoleID Int,
@RoleDescription nvarchar(255)
)  AS
UPDATE InstantKB_Roles SET RoleDescription = @RoleDescription WHERE RoleID = @RoleID
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_AdminUpdateUser (
@UserID Int,
@UserName nvarchar(255),
@Password nvarchar(255)
)  AS
UPDATE InstantKB_Users SET Username = @UserName, [Password] = @Password WHERE UserID = @UserID
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_CheckUserRolesAgainstNodeID (
@paramNodeID nvarchar(75),
@userRoles nvarchar(255),
@HasPermission bit OUTPUT
) AS

DECLARE @SQL nvarchar(1000) -- dynamic SQL statement
DECLARE @Delimiter char(1)
DECLARE @separator_position int
DECLARE @array_value varchar(5)
DECLARE @LoopCount int
DECLARE @NodeID varchar(75) -- output parameted from the dynamic SQL used to test existance of result
DECLARE @ParmDefinition nvarchar(500)

SET @LoopCount = 0
SET @Delimiter = ","
SET @NodeID = ""

SELECT @SQL = 'SELECT DISTINCT @NodeID = InstantKB_TreeRoles.NodeID FROM InstantKB_TreeRoles '
SELECT @SQL = @SQL + 'WHERE (InstantKB_TreeRoles.RoleID = 1 '

If (@userRoles <> "")

BEGIN

	SET @userRoles = @userRoles + @Delimiter

	WHILE patindex('%' + @Delimiter  + '%' , @userRoles) <> 0 -- loop until we find no more separators
	BEGIN
		SET @separator_position =  patindex('%' +  @Delimiter + '%' , @userRoles)  -- patindex matches the a pattern against a string
		SET @array_value = left(@userRoles, @separator_position - 1) -- array value holds each single keyword
		
		SELECT @SQL = @SQL + ' OR '
	
		-- @array_value holds the value of this element of the array		
		SELECT @SQL = @SQL + 'InstantKB_TreeRoles.RoleID = ' + @array_value 
		
		SET @LoopCount = + 1
		-- This replaces what we just processed with and empty string, pevents infinate loops
		SET @userRoles = stuff(@userRoles, 1, @separator_position, '')
	END

END

SELECT @SQL = @SQL + ') AND (InstantKB_TreeRoles.NodeID = "' + @paramNodeID + '")'

SET @ParmDefinition = N'@NodeID varchar(75) OUTPUT'
EXEC sp_ExecuteSQL @SQL, @ParmDefinition, @NodeID OUTPUT

IF (@NodeID <> "")
BEGIN
	SET @HasPermission = 1
END
ELSE
BEGIN
	SET @HasPermission = 0
END

RETURN
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetAdminLastLogin (
@adminID int,
@LastLogin smalldatetime output
) AS
    
SET @LastLogin = (SELECT LastLogin FROM InstantKB_AdminUsr WHERE UserID = @adminID)
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetAllNodeIDs 
AS
SELECT NodeID FROM InstantKb_Tree 
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetArticle (
@articleID int
) AS
    
SELECT * FROM InstantKB_Articles
WHERE QuestionID = @articleID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetArticleCount (
@nodeID nvarchar(255),
@intArticleCount int output
) AS
SET @intArticleCount = (SELECT COUNT(NodeID) AS Expr1 FROM InstantKB_Articles WHERE NodeID = @NodeID AND PublishToWeb = 1)
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetArticleRating (
@articleID int
) AS
    
SELECT rating FROM InstantKB_Ratings
WHERE QuestionID = @articleID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetArticleTitle (
@articleID int,
@articleTitle nvarchar(3000) output
) AS
    
SET @articleTitle = (SELECT QuestionText FROM InstantKB_Articles WHERE QuestionID = @articleID)
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetArticles (
@nodeID nvarchar(255)
) AS

IF (@nodeID = 'KBAdmin') -- if nodeID is kbadmin return all articles for update feature within the administration pages
BEGIN
	SELECT QuestionText, LastModified, QuestionID, DateStamp, ArticleType, PublishToWeb FROM InstantKB_Articles WHERE SuggestedFlag = 0 ORDER BY LastModified DESC, DateStamp DESC, QuestionText ASC
END
ELSE IF (@nodeID = 'Suggested') -- if nodeID is suggested return all articles for answer questions feature within the administration pages
BEGIN
	SELECT QuestionText, LastModified, QuestionID, DateStamp, ArticleType FROM InstantKB_Articles WHERE SuggestedFlag =1 ORDER BY LastModified DESC, DateStamp DESC, QuestionText ASC
END
ELSE -- else this stored proc is being used to grab only the knowledge base articles with a publishtoweb status for the main default.aspx page
BEGIN
	SELECT QuestionText, LastModified, QuestionID, ArticleType FROM InstantKB_Articles WHERE NodeID = @NodeID AND PublishToWeb = 1
	ORDER BY LastModified DESC, DateStamp DESC, QuestionText ASC
END 
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetAttachments (
@articleID int
) AS
    
SELECT * FROM InstantKB_Attachments
WHERE QuestionID = @articleID ORDER BY DateStamp DESC
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetAuthorEmail (
@adminID int,
@AuthorEmail nvarchar(150) output
) AS
    
SET @AuthorEmail = (SELECT EmailAddress FROM InstantKB_AdminUsr WHERE UserID = @adminID)
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetAuthorName (
@adminID int,
@AuthorName nvarchar(150) output
) AS
    
SET @AuthorName = (SELECT FullName FROM InstantKB_AdminUsr WHERE UserID = @adminID)
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetComments (
@articleID Int
)  AS
IF (@ArticleID = 0) 
BEGIN
	SELECT * FROM InstantKB_Comments ORDER BY DateStamp DESC
END
ELSE
BEGIN
	SELECT * FROM InstantKB_Comments WHERE ArticleID = @ArticleID AND Approved = 1 ORDER BY DateStamp DESC
END 
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetKBStatisics (
@TotalCategories int output,
@TotalArticles int output,
@QWaitingApproval int output,
@TotalComments int output,
@TotalCommentsWaitingApproval int output,
@TotalUsers int output,
@TotalUserRoles int output,
@PopularCategory nvarchar(75) output,
@LeastPopularCategory nvarchar(75) output
) AS
    
SET @TotalCategories = (SELECT Count(NodeID) FROM InstantKB_Tree)
SET @TotalArticles = (SELECT Count(QuestionID) FROM InstantKB_Articles WHERE SuggestedFlag = 0)
SET @QWaitingApproval = (SELECT Count(QuestionID) FROM InstantKB_Articles WHERE SuggestedFlag = 1 AND PublishToWeb = 0)
SET @TotalComments =  (SELECT Count(CommentID) FROM InstantKB_Comments WHERE Approved = 1)
SET @TotalCommentsWaitingApproval =  (SELECT Count(CommentID) FROM InstantKB_Comments WHERE Approved = 0)
SET @TotalUsers =  (SELECT Count(UserID) FROM InstantKB_Users)
SET @TotalUserRoles =  (SELECT Count(RoleID) FROM InstantKB_Roles)
SET @PopularCategory = (SELECT TOP 1 InstantKB_Tree.NodeID FROM InstantKB_Articles INNER JOIN 
InstantKB_Tree ON InstantKB_Articles.NodeID = InstantKB_Tree.NodeID GROUP BY InstantKB_Tree.NodeID, InstantKB_Tree.NodeName 
ORDER BY SUM(InstantKB_Articles.NoOfViews) DESC)
SET @LeastPopularCategory = (SELECT TOP 1 InstantKB_Tree.NodeID FROM InstantKB_Articles INNER JOIN 
InstantKB_Tree ON InstantKB_Articles.NodeID = InstantKB_Tree.NodeID GROUP BY InstantKB_Tree.NodeID, InstantKB_Tree.NodeName 
ORDER BY SUM(InstantKB_Articles.NoOfViews) ASC)

return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetLatestArticles (
@userRoles varchar(75)
)AS

DECLARE @SQL varchar(1000)
DECLARE @Delimiter char(1)
DECLARE @separator_position int -- This is used to locate each separator character
DECLARE @array_value varchar(1000) -- this holds each array value as it is returned
DECLARE @LoopCount int -- loop counter
SET @LoopCount = 0 -- used to count loops when ANY type search is selected
SET @Delimiter = ","

SELECT @SQL = 'SELECT DISTINCT TOP 10 QuestionText, LastModified, QuestionID, DateStamp, ArticleType, NoOfViews, LastModified FROM
InstantKB_Articles INNER JOIN InstantKB_Tree ON InstantKB_Articles.NodeID = InstantKB_Tree.NodeID INNER JOIN
InstantKB_TreeRoles ON InstantKB_Tree.NodeID = InstantKB_TreeRoles.NodeID WHERE (InstantKB_TreeRoles.RoleID = 1 '

If (@userRoles <> "")

BEGIN

	SET @userRoles = @userRoles + @Delimiter

	WHILE patindex('%' + @Delimiter  + '%' , @userRoles) <> 0 -- loop until we find no more separators
	BEGIN
		SET @separator_position =  patindex('%' +  @Delimiter + '%' , @userRoles)  -- patindex matches the a pattern against a string
		SET @array_value = left(@userRoles, @separator_position - 1) -- array value holds each single keyword
		
		SELECT @SQL = @SQL + ' OR '
	
		-- @array_value holds the value of this element of the array		
		SELECT @SQL = @SQL + 'InstantKB_TreeRoles.RoleID = ' + @array_value 
		
		SET @LoopCount = + 1
		-- This replaces what we just processed with and empty string, pevents infinate loops
		SET @userRoles = stuff(@userRoles, 1, @separator_position, '')
	END

END

SELECT @SQL = @SQL + ') AND (PublishToWeb = 1) ORDER BY InstantKB_Articles.LastModified DESC, InstantKB_Articles.DateStamp DESC, InstantKB_Articles.QuestionText ASC'

Exec (@SQL)

return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetNavBarLinkInfo (
@nodeID nvarchar(255)
) AS
    
SELECT * FROM InstantKb_Tree WHERE NodeID = @nodeID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetNodeIDForArticle (
@articleID int,
@nodeID nvarchar(75) output
) AS
    
SET @nodeID = (SELECT NodeID FROM InstantKB_Articles WHERE QuestionID = @articleID)
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetNodeRoleRelationships (
@NodeID varchar(75)
)AS
SELECT InstantKB_Roles.RoleID, InstantKB_Roles.RoleDescription FROM InstantKB_Tree 
INNER JOIN InstantKB_TreeRoles ON InstantKB_Tree.NodeID = InstantKB_TreeRoles.NodeID 
INNER JOIN InstantKB_Roles ON InstantKB_TreeRoles.RoleID = InstantKB_Roles.RoleID 
WHERE InstantKB_Tree.NodeID = @NodeID
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetNodeTitle (
@nodeID nvarchar(255),
@nodeName nvarchar(255) output
) AS
    
SET @nodeName = (SELECT NodeName FROM InstantKb_Tree WHERE NodeID = @nodeID)
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetNodes (
@ParentID nvarchar(75),
@userRoles nvarchar(255)
) AS

DECLARE @SQL varchar(1000)
DECLARE @Delimiter char(1)
DECLARE @separator_position int -- This is used to locate each separator character
DECLARE @array_value varchar(1000) -- this holds each array value as it is returned
DECLARE @LoopCount int -- loop counter

SET @LoopCount = 0 -- used to count loops when ANY type search is selected
SET @Delimiter = ","

SELECT @SQL = 'SELECT DISTINCT InstantKB_Tree.* FROM InstantKB_Tree INNER JOIN InstantKB_TreeRoles ON 
InstantKB_Tree.NodeID = InstantKB_TreeRoles.NodeID INNER JOIN InstantKB_Roles ON 
InstantKB_TreeRoles.RoleID = InstantKB_Roles.RoleID WHERE (InstantKB_TreeRoles.RoleID = 1 '

If (@userRoles <> "")

BEGIN

	SET @userRoles = @userRoles + @Delimiter

	WHILE patindex('%' + @Delimiter  + '%' , @userRoles) <> 0 -- loop until we find no more separators
	BEGIN
		SET @separator_position =  patindex('%' +  @Delimiter + '%' , @userRoles)  -- patindex matches the a pattern against a string
		SET @array_value = left(@userRoles, @separator_position - 1) -- array value holds each single keyword
		
		SELECT @SQL = @SQL + ' OR '
	
		-- @array_value holds the value of this element of the array		
		SELECT @SQL = @SQL + 'InstantKB_TreeRoles.RoleID = ' + @array_value 
		
		SET @LoopCount = + 1
		-- This replaces what we just processed with and empty string, pevents infinate loops
		SET @userRoles = stuff(@userRoles, 1, @separator_position, '')
	END

END

SELECT @SQL = @SQL + ') AND ParentNodeID = "' + @ParentID + '" ORDER BY InstantKB_Tree.SortOrder DESC, InstantKB_Tree.NodeName'

Exec (@SQL)

return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetParentNodeIDs (
@currentID varchar(75)
) AS
SELECT NodeID, ParentNodeID FROM InstantKb_Tree WHERE NodeID = @currentID
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetPopularArticles (
@userRoles varchar(75)
) AS

DECLARE @SQL varchar(1000)
DECLARE @Delimiter char(1)
DECLARE @separator_position int -- This is used to locate each separator character
DECLARE @array_value varchar(1000) -- this holds each array value as it is returned
DECLARE @LoopCount int -- loop counter
SET @LoopCount = 0 -- used to count loops when ANY type search is selected
SET @Delimiter = ","

SELECT @SQL = 'SELECT DISTINCT TOP 10 QuestionText, LastModified, QuestionID, DateStamp, ArticleType, NoOfViews, LastModified FROM
InstantKB_Articles INNER JOIN InstantKB_Tree ON InstantKB_Articles.NodeID = InstantKB_Tree.NodeID INNER JOIN
InstantKB_TreeRoles ON InstantKB_Tree.NodeID = InstantKB_TreeRoles.NodeID WHERE (InstantKB_TreeRoles.RoleID = 1 '

If (@userRoles <> "")

BEGIN

	SET @userRoles = @userRoles + @Delimiter

	WHILE patindex('%' + @Delimiter  + '%' , @userRoles) <> 0 -- loop until we find no more separators
	BEGIN
		SET @separator_position =  patindex('%' +  @Delimiter + '%' , @userRoles)  -- patindex matches the a pattern against a string
		SET @array_value = left(@userRoles, @separator_position - 1) -- array value holds each single keyword
		
		SELECT @SQL = @SQL + ' OR '
	
		-- @array_value holds the value of this element of the array		
		SELECT @SQL = @SQL + 'InstantKB_TreeRoles.RoleID = ' + @array_value 
		
		SET @LoopCount = + 1
		-- This replaces what we just processed with and empty string, pevents infinate loops
		SET @userRoles = stuff(@userRoles, 1, @separator_position, '')
	END

END

SELECT @SQL = @SQL + ') AND (PublishToWeb = 1) ORDER BY InstantKB_Articles.NoOfViews DESC, InstantKB_Articles.LastModified DESC'

Exec (@SQL)

return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetRoles
AS
SELECT RoleID, RoleDescription FROM InstantKB_Roles
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetUserRoleRelationships (
@UserID int
)AS
SELECT InstantKB_Roles.* FROM InstantKB_Users 
INNER JOIN InstantKB_UserRoles ON InstantKB_Users.UserID = InstantKB_UserRoles.UserID 
INNER JOIN InstantKB_Roles ON InstantKB_UserRoles.RoleID = InstantKB_Roles.RoleID
WHERE InstantKB_Users.UserID = @UserID
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetUserRoles (
@Username nvarchar(255),
@Password nvarchar(255)
) AS
    
DECLARE @userid int
SELECT @userid = UserID  FROM InstantKB_Users WHERE Username = @UserName AND [Password] = @Password
SELECT  InstantKB_Roles.RoleID FROM InstantKB_UserRoles INNER JOIN InstantKB_Roles ON InstantKB_UserRoles.RoleID = InstantKB_Roles.RoleID WHERE InstantKB_UserRoles.UserID = @userid
RETURN
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetUserRolesForDDL
AS
    
SELECT * FROM InstantKB_Roles
RETURN

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_GetUsers
AS
SELECT * FROM InstantKB_Users ORDER BY UserName ASC
return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_IncrementArticleViews (
@articleID Int
)  AS
UPDATE InstantKB_Articles 
SET NoOfViews = NoOfViews + 1
WHERE QuestionID = @articleID
return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_ObtainDatabaseInformation

AS

SET NOCOUNT ON

CREATE TABLE #TBLSize
 (Tblname varchar(80), 
 TblRows int,
 TblReserved varchar(80),
 TblData varchar(80),
 TblIndex_Size varchar(80),
 TblUnused varchar(80))

DECLARE @DBname varchar(80) 
DECLARE @tablename varchar(80) 

SELECT @DBname = DB_NAME(DB_ID())

DECLARE TblName_cursor CURSOR FOR 
SELECT NAME 
FROM sysobjects
WHERE xType = 'U'

OPEN TblName_cursor

FETCH NEXT FROM TblName_cursor 
INTO @tablename

WHILE @@FETCH_STATUS = 0
BEGIN
   INSERT INTO #tblSize(Tblname, TblRows, TblReserved, TblData, TblIndex_Size, TblUnused)
   EXEC Sp_SpaceUsed @tablename
      
   -- Get the next author.
   FETCH NEXT FROM TblName_cursor 
   INTO @tablename
END

CLOSE TblName_cursor
DEALLOCATE TblName_cursor

SELECT Tblname, TblRows,TblReserved,TblData,TblIndex_Size,TblUnused FROM #tblSize WHERE Tblname LIKE 'InstantKB_%' ORDER BY Tblname

DROP TABLE #TblSize

return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO



CREATE Procedure ikb_sp_doSearch (

@query nvarchar(4000), -- keywords passed into the procedure
@using nvarchar(50), -- type of search to perform - options are ALL, ANY and EXact
@search nvarchar(50), -- field to search options are full title and article id
@age datetime, -- daterange to search
@userRoles nvarchar(255) -- use-roles assocaited with user

) AS

DECLARE @SQL varchar(4000)
DECLARE @separator_position int -- This is used to locate each separator character
DECLARE @array_value varchar(4000) -- this holds each array value as it is returned
DECLARE @LoopCount int -- used to count loops when ANY type search is selected
DECLARE @separator varchar(1) -- separator used to split query at spaces when searching for any word
DECLARE @userRoleDelimiter varchar(1)  -- separator used to split user-role ids
DECLARE @LOperator varchar(5)

SET @separator = " " 
SET @LoopCount = 0 

SELECT @SQL = 'SELECT DISTINCT InstantKB_Articles.QuestionID, InstantKB_Articles.QuestionText, InstantKB_Articles.Keywords,  
		   InstantKB_Articles.ArticleType, InstantKB_Articles.LastModified, InstantKB_Articles.DateStamp FROM InstantKB_Articles 
		   INNER JOIN InstantKB_TreeRoles ON InstantKB_Articles.NodeID = InstantKB_TreeRoles.NodeID
		   INNER JOIN InstantKB_Roles ON InstantKB_TreeRoles.RoleID = InstantKB_Roles.RoleID'

IF (@using = "ex" and @search <> "articleID") -- all keywords search
BEGIN
	IF (@search = "full") -- search all fields
		BEGIN
			SELECT @SQL = @SQL + ' WHERE (QuestionText LIKE ''%' + @query  + '%'' or AnswerText LIKE  ''%' + @query + '%'' or
						    Keywords LIKE  ''%' + @query + '%'' or ArticleType LIKE  ''%' + @query + '%'')' 
		END
	IF (@search = "title") -- search title
		BEGIN
			SELECT @SQL = @SQL + ' WHERE (QuestionText LIKE ''%' + @query  + '%'' or Keywords LIKE  ''%' + @query + '%'' or ArticleType LIKE  ''%' + @query + '%'')' 
		END
END

IF ((@using = "any" or @using = "all") and @search <> "articleID") -- any word within search string - split words
BEGIN

SELECT @SQL = @SQL + ' WHERE '

	SET @query = @query + @separator
		
	-- Loop through the string searching for separtor characters
	WHILE patindex('%' + @separator + '%' , @query) <> 0 -- loop until we find no more separators
	BEGIN

		If (@using = "any") -- if its not the first loop append OR to SQL statement
		BEGIN
			SET @LOperator = " OR "
		END
		ELSE BEGIN
			SET @LOperator = " AND "
		END

		SET @separator_position =  patindex('%' + @separator + '%' , @query)  -- patindex matches the a pattern against a string
		SET @array_value = left(@query, @separator_position - 1) -- array value holds each single keyword
	
		If (@LoopCount <> 0) -- if its not the first loop append OR to SQL statement
		BEGIN
			SELECT @SQL = @SQL + @LOperator
		END

		-- @array_value holds the value of this element of the array
		
		IF (@search = "full") -- search all fields
		  BEGIN
			SELECT @SQL = @SQL + '(QuestionText LIKE ''%' + @array_value + '%'' OR AnswerText LIKE ''%' + @array_value + '%'' OR 
			ArticleType LIKE  ''%' + @array_value + '%'' OR Keywords LIKE  ''%' + @array_value + '%'')' 
		  END
		IF (@search = "title")
		  BEGIN
			SELECT @SQL = @SQL + '(QuestionText LIKE ''%' + @array_value + '%''  or Keywords LIKE  ''%' + @array_value + '%'' OR ArticleType = ''%' + @array_value + '%'')' 
		  END
	
		SET @LoopCount = + 1 -- increment loop count		
		SET @query = stuff(@query, 1, @separator_position, '') -- This replaces what we just processed with and empty string, pevents infinate loops
	END
END

IF (@search = "articleID") -- search for article ID
BEGIN
	If (IsNumeric(@query) = 1) 
	BEGIN
		SELECT @SQL = @SQL + ' WHERE (QuestionID = ' + @query + ')' -- if article ID search is number search the id field
	END
		ELSE
	BEGIN
		SELECT @SQL = @SQL + ' WHERE (QuestionText = ''%' + @query  + '%'')' -- else do search on title

	END
END

SELECT @SQL = @SQL + ' AND (InstantKB_TreeRoles.RoleID = 1'
If (@userRoles <> "")
BEGIN
	
	DECLARE @role_separator_position int -- This is used to locate each separator character
	DECLARE @role_array_value varchar(1000) -- this holds each array value as it is returned
	DECLARE @roleLoopCount int -- used to count loops when ANY type search is selected
	
	SET @roleLoopCount = 0 -- reset loop count
	SET @userRoleDelimiter = "," 
	SET @userRoles = @userRoles + @userRoleDelimiter

	WHILE patindex('%' + @userRoleDelimiter  + '%' , @userRoles) <> 0 -- loop until we find no more separators
	BEGIN
		SET @role_separator_position =  patindex('%' + @userRoleDelimiter + '%' , @userRoles)  -- patindex matches the a pattern against a string
		SET @role_array_value = left(@userRoles, @role_separator_position - 1) -- array value holds each single keyword
		
		SELECT @SQL = @SQL + ' OR '
	
		-- @array_value holds the value of this element of the array		
		SELECT @SQL = @SQL + 'InstantKB_TreeRoles.RoleID = ' + @role_array_value 
		
		SET @roleLoopCount = + 1
		-- This replaces what we just processed with and empty string, pevents infinate loops
		SET @userRoles = stuff(@userRoles, 1, @role_separator_position, '')
	END

END

SELECT @SQL = @SQL + ') AND (InstantKB_Articles.PublishToWeb = 1 AND InstantKB_Articles.DateStamp >= ''' + cast(@age as varchar) + ''') ORDER BY InstantKB_Articles.LastModified DESC, InstantKB_Articles.DateStamp DESC' 

Exec (@SQL)

return
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE Procedure ikb_sp_hasChildren (
@nodeID nvarchar(255),
@userRoles nvarchar(255),
@strResult bit OUTPUT
) AS

DECLARE @SQL nvarchar(1000) -- dynamic SQL statement
DECLARE @Delimiter char(1)
DECLARE @separator_position int
DECLARE @array_value varchar(5)
DECLARE @LoopCount int
DECLARE @ParentNodeID varchar(75) -- output parameted from the dynamic SQL used to test existance of result
DECLARE @ParmDefinition nvarchar(500)

SET @LoopCount = 0
SET @Delimiter = ","
SET @ParentNodeID = ""

SELECT @SQL = 'SELECT DISTINCT @ParentNodeID = InstantKB_Tree.ParentNodeID FROM InstantKB_Tree INNER JOIN 
InstantKB_TreeRoles ON InstantKB_Tree.NodeID = InstantKB_TreeRoles.NodeID INNER JOIN InstantKB_Roles ON
InstantKB_TreeRoles.RoleID = InstantKB_Roles.RoleID WHERE (InstantKB_TreeRoles.RoleID = 1 '

If (@userRoles <> "")

BEGIN

	SET @userRoles = @userRoles + @Delimiter

	WHILE patindex('%' + @Delimiter  + '%' , @userRoles) <> 0 -- loop until we find no more separators
	BEGIN
		SET @separator_position =  patindex('%' +  @Delimiter + '%' , @userRoles)  -- patindex matches the a pattern against a string
		SET @array_value = left(@userRoles, @separator_position - 1) -- array value holds each single keyword
		
		SELECT @SQL = @SQL + ' OR '
	
		-- @array_value holds the value of this element of the array		
		SELECT @SQL = @SQL + 'InstantKB_TreeRoles.RoleID = ' + @array_value 
		
		SET @LoopCount = + 1
		-- This replaces what we just processed with and empty string, pevents infinate loops
		SET @userRoles = stuff(@userRoles, 1, @separator_position, '')
	END

END

SELECT @SQL = @SQL + ') AND (ParentNodeID = "' + @nodeID + '")'

SET @ParmDefinition = N'@ParentNodeID varchar(75) OUTPUT'
EXEC sp_ExecuteSQL @SQL, @ParmDefinition, @ParentNodeID OUTPUT

IF (@ParentNodeID <> "")
BEGIN
	SET @strResult = 1
END
ELSE
BEGIN
	SET @strResult = 0
END

RETURN
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

-- create new database tables

CREATE TABLE [dbo].[InstantKB_Roles] (
	[RoleID] [int] IDENTITY (1, 1) NOT NULL ,
	[RoleDescription] [nvarchar] (255) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[InstantKB_TreeRoles] (
	[NodeRoleID] [int] IDENTITY (1, 1) NOT NULL ,
	[NodeID] [nvarchar] (75) NULL ,
	[RoleID] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[InstantKB_UserRoles] (
	[UserRoleID] [int] IDENTITY (1, 1) NOT NULL ,
	[UserID] [int] NULL ,
	[RoleID] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[InstantKB_Users] (
	[UserID] [int] IDENTITY (1, 1) NOT NULL ,
	[Username] [nvarchar] (255) NULL ,
	[Password] [nvarchar] (255) NULL 
) ON [PRIMARY]
GO

-- insert default user role

INSERT INTO InstantKB_Roles (RoleDescription) VALUES ('Public')
GO

-- associate all categories with the new public role

DECLARE @nodeID varchar(75)

DECLARE MSGCURSOR CURSOR FOR
SELECT NodeID FROM InstantKB_Tree

OPEN MSGCURSOR

FETCH NEXT FROM MSGCURSOR
INTO @nodeID

WHILE @@FETCH_STATUS = 0
BEGIN

	INSERT INTO InstantKB_TreeRoles (NodeID, RoleID) VALUES (@nodeID, 1)
	FETCH NEXT FROM MSGCURSOR
	INTO @nodeID
	
END

CLOSE MSGCURSOR
DEALLOCATE MSGCURSOR


PRINT "NOTE : Database created successfully. If you have recieved a warning above regarding the maximum row size you can safely ignore this. This message is due to a datatype conversion between InstantKB v1.1 and v1.2. This message will not effect how your application functions."

