/******************************************************
  Tables  Begin
******************************************************/
GO
----------------------------------------------------
-- InstantASP_Emails
----------------------------------------------------
CREATE TABLE InstantASP_Emails
(
EmailID                             INT IDENTITY(1,1) NOT NULL,
EmailTo                             NVARCHAR(255) DEFAULT ('') NOT NULL,
EmailCC                             NVARCHAR(255) DEFAULT ('') NOT NULL,
EmailBCC                            NTEXT,
EmailFrom                           NVARCHAR(255) DEFAULT ('') NOT NULL,
EmailSubject                        NVARCHAR(1500) DEFAULT ('') NOT NULL,
EmailBody                           NTEXT,
EmailPriority                       TINYINT DEFAULT (1) NOT NULL,
EmailAttempts                       TINYINT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantASP_EmailQueue_EmailID PRIMARY KEY CLUSTERED ( EmailID )
)

GO
----------------------------------------------------
-- InstantASP_Fields
----------------------------------------------------
CREATE TABLE InstantASP_Fields
(
FieldID                             INT IDENTITY(1,1) NOT NULL,
ApplicationID                       TINYINT DEFAULT (1) NOT NULL,
TabID                               INT NOT NULL,
FieldLabel                          NVARCHAR(100) DEFAULT ('') NOT NULL,
FieldLabelNonLocalized              NVARCHAR(300) DEFAULT ('') NOT NULL,
FieldDescLabel                      NVARCHAR(100) DEFAULT ('') NOT NULL,
FieldDescLabelNonLocalized          NVARCHAR(500) DEFAULT ('') NOT NULL,
FieldToolTip                        NVARCHAR(100) DEFAULT ('') NOT NULL,
FieldToolTipNonLocalized            NVARCHAR(400) DEFAULT ('') NOT NULL,
TableFieldName                      NVARCHAR(100) DEFAULT ('') NOT NULL,
FieldType                           TINYINT DEFAULT (1) NOT NULL,
PickListID                          INT DEFAULT (0) NOT NULL,
DefaultValue                        NVARCHAR(255) DEFAULT ('') NOT NULL,
StringSize                          INT DEFAULT (0) NOT NULL,
Format                              NVARCHAR(50) DEFAULT ('') NOT NULL,
RegExValidation                     NVARCHAR(255) DEFAULT ('') NOT NULL,
SortOrder                           INT DEFAULT (0) NOT NULL,
IsVisible                           BIT DEFAULT (1) NOT NULL,
IsEnabled                           BIT DEFAULT (1) NOT NULL,
IsRequired                          BIT DEFAULT (0) NOT NULL,
IsCustomField                       BIT DEFAULT (0) NOT NULL,
IsUserEditable                      BIT DEFAULT (1) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantASP_Fields_FieldID PRIMARY KEY CLUSTERED ( FieldID )
)

GO
----------------------------------------------------
-- InstantASP_FieldTemplateDetails
----------------------------------------------------
CREATE TABLE InstantASP_FieldTemplateDetails
(
FieldTemplateDetailID               INT IDENTITY(1,1) NOT NULL,
FieldTemplateID                     INT NOT NULL,
FieldID                             INT NOT NULL,
DetailDefaultValue                  NTEXT NOT NULL,
DetailIsRequired                    BIT DEFAULT (0) NOT NULL,
DetailIsVisible                     BIT DEFAULT (1) NOT NULL,
DetailIsEnabled                     BIT DEFAULT (1) NOT NULL,
DetailSortOrder                     INT NOT NULL,
CONSTRAINT PK_InstantASP_FieldGroupDetails PRIMARY KEY CLUSTERED ( FieldTemplateDetailID )
)

GO
----------------------------------------------------
-- InstantASP_FieldTemplates
----------------------------------------------------
CREATE TABLE InstantASP_FieldTemplates
(
FieldTemplateID                     INT IDENTITY(1,1) NOT NULL,
ApplicationID                       TINYINT NOT NULL,
TabID                               INT DEFAULT (1) NOT NULL,
Name                                NVARCHAR(255) NOT NULL,
NameNonLocalized                    NVARCHAR(255) DEFAULT ('') NOT NULL,
Description                         NVARCHAR(1000) NOT NULL,
IsRequired                          BIT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantASP_FieldTemplates PRIMARY KEY CLUSTERED ( FieldTemplateID )
)

GO
----------------------------------------------------
-- InstantASP_IgnoredSearchTerms
----------------------------------------------------
CREATE TABLE InstantASP_IgnoredSearchTerms
(
IgnoredSearchTermID                 INT IDENTITY(1,1) NOT NULL,
ApplicationID                       TINYINT DEFAULT (0) NOT NULL,
SearchText                          NVARCHAR(255) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantForum_SearchIgnoredTerms_IgnoredSearchTermID PRIMARY KEY CLUSTERED ( IgnoredSearchTermID )
)

GO
----------------------------------------------------
-- InstantASP_LanguageFilters
----------------------------------------------------
CREATE TABLE InstantASP_LanguageFilters
(
LanguageFilterID                    INT IDENTITY(1,1) NOT NULL,
ApplicationID                       TINYINT DEFAULT (0) NOT NULL,
SearchPattern                       NVARCHAR(255) DEFAULT ('') NOT NULL,
ReplacePattern                      NVARCHAR(255) DEFAULT ('') NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL
)

GO
----------------------------------------------------
-- InstantASP_PickLists
----------------------------------------------------
CREATE TABLE InstantASP_PickLists
(
PickListID                          INT IDENTITY(1,1) NOT NULL,
Name                                NVARCHAR(100) NOT NULL,
CONSTRAINT PK_InstantASP_DropDownLists PRIMARY KEY CLUSTERED ( PickListID )
)

GO
----------------------------------------------------
-- InstantASP_PickListValues
----------------------------------------------------
CREATE TABLE InstantASP_PickListValues
(
PickListValueID                     INT IDENTITY(1,1) NOT NULL,
PickListID                          INT NOT NULL,
Name                                NVARCHAR(255) DEFAULT ('') NOT NULL,
SortOrder                           INT DEFAULT (0) NOT NULL,
IsSelected                          BIT DEFAULT (0) NOT NULL,
CONSTRAINT PK_InstantASP_DropDownListValues PRIMARY KEY CLUSTERED ( PickListValueID )
)

GO
----------------------------------------------------
-- InstantASP_Roles
----------------------------------------------------
CREATE TABLE InstantASP_Roles
(
RoleID                              SMALLINT IDENTITY(1,1) NOT NULL,
RoleName                            NVARCHAR(200) DEFAULT (N'') NOT NULL,
RoleVisible                         BIT DEFAULT (0) NOT NULL,
OpenMarkUp                          NVARCHAR(255) DEFAULT ('') NOT NULL,
CloseMarkUp                         NVARCHAR(255) DEFAULT ('') NOT NULL,
AnonymousRole                       BIT DEFAULT (0) NOT NULL,
ActivationRole                      BIT DEFAULT (0) NOT NULL,
MemberRole                          BIT DEFAULT (0) NOT NULL,
ModeratorRole                       BIT DEFAULT (0) NOT NULL,
AdministratorRole                   BIT DEFAULT (0) NOT NULL,
BannedRole                          BIT DEFAULT (0) NOT NULL,
RequiredRole                        BIT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantASP_Roles_RoleID PRIMARY KEY CLUSTERED ( RoleID )
)

GO
----------------------------------------------------
-- InstantASP_ScheduledTasks
----------------------------------------------------
CREATE TABLE InstantASP_ScheduledTasks
(
TaskID                              INT IDENTITY(1,1) NOT NULL,
TaskName                            NVARCHAR(255) DEFAULT ('') NOT NULL,
TaskDescription                     NVARCHAR(500) DEFAULT ('') NOT NULL,
TaskFileName                        NVARCHAR(255) DEFAULT ('') NOT NULL,
TaskNextRunDate                     DATETIME DEFAULT (getdate()) NOT NULL,
TaskLastRunDate                     DATETIME,
TaskInterval                        SMALLINT DEFAULT (0) NOT NULL,
TaskIntervalType                    TINYINT DEFAULT (1) NOT NULL,
TaskEnabled                         BIT DEFAULT (0) NOT NULL,
TaskGuid                            NVARCHAR(75) DEFAULT ('') NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantForum_ScheduledTasks_TaskID PRIMARY KEY CLUSTERED ( TaskID )
)

GO
----------------------------------------------------
-- InstantASP_Searches
----------------------------------------------------
CREATE TABLE InstantASP_Searches
(
SearchItemID                        INT IDENTITY(1,1) NOT NULL,
Keywords                            NVARCHAR(255) DEFAULT ('') NOT NULL,
UserID                              INT DEFAULT (0) NOT NULL,
IPAddress                           NVARCHAR(20) DEFAULT ('') NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
ContentType                         SMALLINT DEFAULT (0) NOT NULL,
ApplicationID                       SMALLINT DEFAULT (0) NOT NULL
)

GO
----------------------------------------------------
-- InstantASP_Sessions
----------------------------------------------------
CREATE TABLE InstantASP_Sessions
(
SessionID                           INT IDENTITY(1,1) NOT NULL,
SessionIdentity                     NVARCHAR(100) DEFAULT ('') NOT NULL,
SessionData                         NVARCHAR(1000) DEFAULT ('') NOT NULL,
Expires                             DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantASP_Sessions_SessionID PRIMARY KEY CLUSTERED ( SessionID )
)

GO
----------------------------------------------------
-- InstantASP_Settings
----------------------------------------------------
CREATE TABLE InstantASP_Settings
(
SettingID                           TINYINT IDENTITY(1,1) NOT NULL,
SettingsXML                         NTEXT DEFAULT ('') NOT NULL,
CONSTRAINT PK_InstantASP_Settings_SettingID PRIMARY KEY CLUSTERED ( SettingID )
)

GO
----------------------------------------------------
-- InstantASP_Tags
----------------------------------------------------
CREATE TABLE InstantASP_Tags
(
TagID                               INT IDENTITY(1,1) NOT NULL,
ApplicationID                       TINYINT DEFAULT (0) NOT NULL,
TabID                               INT DEFAULT (0) NOT NULL,
RelatedEntityID                     INT DEFAULT (0) NOT NULL,
TagKeyword                          NVARCHAR(255) NOT NULL,
TagKeywordEncoded                   NVARCHAR(255) DEFAULT ('') NOT NULL,
UserID                              BIT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT [PK_InstantASP_Tags.TagID] PRIMARY KEY CLUSTERED ( TagID )
)

GO
----------------------------------------------------
-- InstantASP_Users
----------------------------------------------------
CREATE TABLE InstantASP_Users
(
UserID                              INT IDENTITY(1,1) NOT NULL,
PrimaryRoleID                       SMALLINT DEFAULT (1) NOT NULL,
Username                            NVARCHAR(155) DEFAULT (N'') NOT NULL,
LdapUsername                        NVARCHAR(255) DEFAULT (N'') NOT NULL,
EmailAddress                        NVARCHAR(155) DEFAULT ('') NOT NULL,
Password                            NVARCHAR(155) DEFAULT (N'') NOT NULL,
Culture                             NVARCHAR(10) DEFAULT (N'en-us') NOT NULL,
TimeZoneOffset                      FLOAT DEFAULT (0) NOT NULL,
ObserveDaylightSavingTime           BIT DEFAULT (0) NOT NULL,
DateTimeFormat                      NVARCHAR(1) DEFAULT ('g') NOT NULL,
FirstDayOfWeek                      TINYINT DEFAULT (0) NOT NULL,
FirstName                           NVARCHAR(155) DEFAULT ('') NOT NULL,
LastName                            NVARCHAR(155) DEFAULT ('') NOT NULL,
CompanyName                         NVARCHAR(155) DEFAULT ('') NOT NULL,
JobTitle                            NVARCHAR(155) DEFAULT ('') NOT NULL,
PublicEmail                         NVARCHAR(155) DEFAULT ('') NOT NULL,
WebAddress                          NVARCHAR(255) DEFAULT ('') NOT NULL,
BlogAddress                         NVARCHAR(255) DEFAULT ('') NOT NULL,
MSN                                 NVARCHAR(155) DEFAULT ('') NOT NULL,
Skype                               NVARCHAR(155) DEFAULT ('') NOT NULL,
YIM                                 NVARCHAR(155) DEFAULT ('') NOT NULL,
AIM                                 NVARCHAR(155) DEFAULT ('') NOT NULL,
ICQ                                 NVARCHAR(155) DEFAULT ('') NOT NULL,
Location                            NVARCHAR(155) DEFAULT ('') NOT NULL,
DOBDay                              TINYINT DEFAULT (0) NOT NULL,
DOBMonth                            TINYINT DEFAULT (0) NOT NULL,
DOBYear                             SMALLINT DEFAULT (0) NOT NULL,
ConfirmationCode                    NVARCHAR(25) DEFAULT ('') NOT NULL,
TotalVisits                         INT DEFAULT (1) NOT NULL,
CreatedDate                         DATETIME DEFAULT (getdate()) NOT NULL,
LastLoginDate                       DATETIME DEFAULT (getdate()) NOT NULL,
IPAddress                           NVARCHAR(20) DEFAULT (N'') NOT NULL,
CONSTRAINT PK_InstantASP_Users_UserID PRIMARY KEY CLUSTERED ( UserID )
)

GO
----------------------------------------------------
-- InstantASP_UsersRoles
----------------------------------------------------
CREATE TABLE InstantASP_UsersRoles
(
UserID                              INT DEFAULT (0) NOT NULL,
RoleID                              INT DEFAULT (0) NOT NULL
)

GO
----------------------------------------------------
-- InstantASP_Wrappers
----------------------------------------------------
CREATE TABLE InstantASP_Wrappers
(
WrapperID                           SMALLINT IDENTITY(1,1) NOT NULL,
WrapperName                         NVARCHAR(255) DEFAULT (N'') NOT NULL,
HeaderHTML                          NTEXT,
FooterHTML                          NTEXT,
CONSTRAINT PK_InstantASP_Wrappers_WrapperID PRIMARY KEY CLUSTERED ( WrapperID )
)

GO
----------------------------------------------------
-- InstantKB_ArticleCategories
----------------------------------------------------
CREATE TABLE InstantKB_ArticleCategories
(
ArticleID                           INT NOT NULL,
CategoryID                          INT NOT NULL
)

GO
----------------------------------------------------
-- InstantKB_ArticleCommentRatings
----------------------------------------------------
CREATE TABLE InstantKB_ArticleCommentRatings
(
CommentRatingID                     INT IDENTITY(1,1) NOT NULL,
CommentID                           INT NOT NULL,
HelpFul                             BIT DEFAULT (0) NOT NULL,
UserID                              INT DEFAULT (0) NOT NULL,
IPAddress                           NVARCHAR(20) DEFAULT ('') NOT NULL,
CONSTRAINT PK_InstantKB_ArticleCommentRatings PRIMARY KEY CLUSTERED ( CommentRatingID )
)

GO
----------------------------------------------------
-- InstantKB_ArticleComments
----------------------------------------------------
CREATE TABLE InstantKB_ArticleComments
(
CommentID                           INT IDENTITY(1,1) NOT NULL,
ArticleID                           INT NOT NULL,
UserID                              INT DEFAULT (0) NOT NULL,
Username                            NVARCHAR(255) DEFAULT ('') NOT NULL,
EmailAddress                        NVARCHAR(255) DEFAULT ('') NOT NULL,
WebAddress                          NVARCHAR(255) DEFAULT ('') NOT NULL,
Comments                            NTEXT DEFAULT ('') NOT NULL,
LastModifiedByUserID                INT DEFAULT (0) NOT NULL,
LastModifiedByUserName              NVARCHAR(255) DEFAULT ('') NOT NULL,
LastModifiedDateStamp               DATETIME DEFAULT (getdate()) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
AccessType                          TINYINT DEFAULT (0) NOT NULL,
TotalVotes                          INT DEFAULT (0) NOT NULL,
MarkedAsHelpful                     INT DEFAULT (0) NOT NULL,
CONSTRAINT PK_InstantKB_ArticleComments_CommentID PRIMARY KEY CLUSTERED ( CommentID )
)

GO
----------------------------------------------------
-- InstantKB_ArticleCustomFields
----------------------------------------------------
CREATE TABLE InstantKB_ArticleCustomFields
(
ArticleID                           INT NOT NULL,
CONSTRAINT PK_InstantKB_ArticleCustomFields PRIMARY KEY CLUSTERED ( ArticleID )
)

GO
----------------------------------------------------
-- InstantKB_ArticleRatings
----------------------------------------------------
CREATE TABLE InstantKB_ArticleRatings
(
ArticleRatingID                     INT IDENTITY(1,1) NOT NULL,
ArticleID                           INT NOT NULL,
ArticleRating                       INT DEFAULT (0) NOT NULL,
UserID                              INT DEFAULT (0) NOT NULL,
IPAddress                           NVARCHAR(20) DEFAULT ('') NOT NULL,
CONSTRAINT PK_InstantKB_ArticleRatings PRIMARY KEY CLUSTERED ( ArticleRatingID )
)

GO
----------------------------------------------------
-- InstantKB_ArticleRead
----------------------------------------------------
CREATE TABLE InstantKB_ArticleRead
(
ArticleReadID                       INT IDENTITY(1,1) NOT NULL,
ArticleReadArticleID                INT NOT NULL,
ArticleReadUserID                   INT NOT NULL,
ArticleReadDate                     DATETIME DEFAULT (getdate()) NOT NULL,
ArticleReadExpires                  DATETIME NOT NULL,
CONSTRAINT PK_InstantKB_ArticleRead PRIMARY KEY CLUSTERED ( ArticleReadID )
)

GO
----------------------------------------------------
-- InstantKB_ArticleRelatedArticles
----------------------------------------------------
CREATE TABLE InstantKB_ArticleRelatedArticles
(
ArticleID                           INT NOT NULL,
RelatedArticleID                    INT NOT NULL
)

GO
----------------------------------------------------
-- InstantKB_ArticleRelatedLinks
----------------------------------------------------
CREATE TABLE InstantKB_ArticleRelatedLinks
(
ArticleRelatedLinkID                INT IDENTITY(1,1) NOT NULL,
ArticleID                           INT DEFAULT (0) NOT NULL,
RedirectURL                         NVARCHAR(255) DEFAULT ('') NOT NULL,
Description                         NVARCHAR(255) DEFAULT ('') NOT NULL,
ViewCount                           INT DEFAULT (0) NOT NULL,
CONSTRAINT PK_InstantKB_ArticleRelatedLinks PRIMARY KEY CLUSTERED ( ArticleRelatedLinkID )
)

GO
----------------------------------------------------
-- InstantKB_ArticleRoles
----------------------------------------------------
CREATE TABLE InstantKB_ArticleRoles
(
ArticleID                           INT NOT NULL,
RoleID                              INT NOT NULL
)

GO
----------------------------------------------------
-- InstantKB_Articles
----------------------------------------------------
CREATE TABLE InstantKB_Articles
(
ArticleID                           INT IDENTITY(10000,1) NOT NULL,
TabID                               INT DEFAULT (1) NOT NULL,
ArticleParentID                     INT DEFAULT (0) NOT NULL,
ArticleCategoryID                   INT DEFAULT (0) NOT NULL,
ArticleTitle                        NVARCHAR(500) DEFAULT (N'') NOT NULL,
ArticleTitleEncoded                 NVARCHAR(500) DEFAULT ('') NOT NULL,
ArticleText                         NTEXT,
ArticlePercentComplete              SMALLINT DEFAULT (0) NOT NULL,
ArticleRating                       INT DEFAULT (0) NOT NULL,
ArticleViews                        INT DEFAULT (0) NOT NULL,
ArticleTypeID                       INT DEFAULT (0) NOT NULL,
ArticleLevelID                      INT DEFAULT (0) NOT NULL,
ArticleStatusID                     INT DEFAULT (0) NOT NULL,
ArticlePriorityID                   INT DEFAULT (0) NOT NULL,
ArticleAccessType                   TINYINT DEFAULT (0) NOT NULL,
ArticleWorkFlowStepID               INT DEFAULT (0) NOT NULL,
ArticleCreatedUserID                INT DEFAULT (0) NOT NULL,
ArticleCreatedUsername              NVARCHAR(255) DEFAULT ('') NOT NULL,
ArticleCreatedDate                  DATETIME DEFAULT (getdate()) NOT NULL,
ArticleModifiedUserID               INT DEFAULT (0) NOT NULL,
ArticleModifiedUsername             NVARCHAR(255) DEFAULT ('') NOT NULL,
ArticleModifiedDate                 DATETIME DEFAULT (getdate()) NOT NULL,
ArticleAssignedUserID               INT DEFAULT (0) NOT NULL,
ArticleAssignedUsername             NVARCHAR(255) DEFAULT ('') NOT NULL,
ArticleAssignedDate                 DATETIME,
ArticleSuggestedUserID              INT DEFAULT (0) NOT NULL,
ArticleSuggestedUsername            NVARCHAR(255) DEFAULT ('') NOT NULL,
ArticleSuggestedEmail               NVARCHAR(255) DEFAULT ('') NOT NULL,
ArticleSuggestedDate                DATETIME,
ArticleReportedUserID               INT DEFAULT (0) NOT NULL,
ArticleReportedUsername             NVARCHAR(255) DEFAULT ('') NOT NULL,
ArticleReportedDate                 DATETIME,
ArticleDueDate                      DATETIME,
ArticleReviewDate                   DATETIME,
ArticleExpiresDate                  DATETIME,
ArticlePassword                     NVARCHAR(255) DEFAULT ('') NOT NULL,
TotalRatings                        INT DEFAULT (0) NOT NULL,
AttachmentCount                     SMALLINT DEFAULT (0) NOT NULL,
CommentCount                        INT DEFAULT (0) NOT NULL,
RelatedLinkCount                    SMALLINT DEFAULT (0) NOT NULL,
RelatedArticleCount                 SMALLINT DEFAULT (0) NOT NULL,
TagCount                            SMALLINT DEFAULT (0) NOT NULL,
ArticleDownloadFile                 NVARCHAR(255) DEFAULT ('') NOT NULL,
ArticleDownloadLink                 NVARCHAR(255) DEFAULT ('') NOT NULL,
ArticleDownloadPassword             NVARCHAR(255) DEFAULT ('') NOT NULL,
CONSTRAINT PK_InstantKB_Articles_ArticleID PRIMARY KEY CLUSTERED ( ArticleID )
)

GO
----------------------------------------------------
-- InstantKB_Attachments
----------------------------------------------------
CREATE TABLE InstantKB_Attachments
(
AttachmentID                        INT IDENTITY(1,1) NOT NULL,
UserID                              INT DEFAULT (0) NOT NULL,
RelatedEntityID                     INT NOT NULL,
AttachmentType                      TINYINT DEFAULT (0) NOT NULL,
FileName                            NVARCHAR(255) DEFAULT (N'') NOT NULL,
DisplayFileName                            NVARCHAR(255) DEFAULT (N'') NOT NULL,
AttachmentBLOB                      IMAGE,
ContentType                         NVARCHAR(100) DEFAULT (N'') NOT NULL,
ContentLength                       INT DEFAULT (0) NOT NULL,
Views                               INT DEFAULT (0) NOT NULL,
Password                            NVARCHAR(255) DEFAULT ('') NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantKB_ArticleAttachments PRIMARY KEY CLUSTERED ( AttachmentID )
)

GO
----------------------------------------------------
-- InstantKB_AttachmentTypes
----------------------------------------------------
CREATE TABLE InstantKB_AttachmentTypes
(
AttachmentTypeID                    INT IDENTITY(1,1) NOT NULL,
TabID                               INT NOT NULL,
Extension                           NVARCHAR(15) DEFAULT ('') NOT NULL,
Icon                                NVARCHAR(255) DEFAULT ('') NOT NULL,
CONSTRAINT PK_InstantKB_AttachmentTypes PRIMARY KEY CLUSTERED ( AttachmentTypeID )
)

GO
----------------------------------------------------
-- InstantKB_Categories
----------------------------------------------------
CREATE TABLE InstantKB_Categories
(
CategoryID                          INT IDENTITY(1,1) NOT NULL,
CategoryParentID                    INT DEFAULT (0) NOT NULL,
TabID                               INT DEFAULT (1) NOT NULL,
DataViewID                          INT DEFAULT (0) NOT NULL,
CategoryIcon                        NVARCHAR(150) DEFAULT (N'') NOT NULL,
CategoryName                        NVARCHAR(255) DEFAULT (N'') NOT NULL,
CategoryDescription                 NTEXT DEFAULT ('') NOT NULL,
CategorySortOrder                   INT DEFAULT (0) NOT NULL,
CategoryExpanded                    BIT DEFAULT (0) NOT NULL,
UserID                              INT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
ArticleCount                        INT DEFAULT (0) NOT NULL,
CONSTRAINT PK_InstantKB_Categories_CategoryID PRIMARY KEY CLUSTERED ( CategoryID )
)

GO
----------------------------------------------------
-- InstantKB_CategoryRoles
----------------------------------------------------
CREATE TABLE InstantKB_CategoryRoles
(
CategoryID                          INT NOT NULL,
RoleID                              SMALLINT NOT NULL,
PermissionID                        SMALLINT DEFAULT (0) NOT NULL
)

GO
----------------------------------------------------
-- InstantKB_DataViews
----------------------------------------------------
CREATE TABLE InstantKB_DataViews
(
DataViewID                          INT IDENTITY(1,1) NOT NULL,
UserID                              INT DEFAULT (0) NOT NULL,
TabID                               INT DEFAULT (1) NOT NULL,
Name                                NVARCHAR(255) DEFAULT ('') NOT NULL,
Description                         NTEXT DEFAULT ('') NOT NULL,
Columns                             NVARCHAR(1500) DEFAULT ('*') NOT NULL,
SortBy                              NVARCHAR(255) DEFAULT (1) NOT NULL,
SortOrder                           TINYINT DEFAULT (1) NOT NULL,
PageSize                            INT DEFAULT (10) NOT NULL,
AccessType                          TINYINT DEFAULT (0) NOT NULL,
DataViewType                        TINYINT DEFAULT (0) NOT NULL,
IsRequired                          BIT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantKB_DataViews PRIMARY KEY CLUSTERED ( DataViewID )
)

GO
----------------------------------------------------
-- InstantKB_Departments
----------------------------------------------------
CREATE TABLE InstantKB_Departments
(
DepartmentID                        INT IDENTITY(1,1) NOT NULL,
DepartmentName                      NVARCHAR(255) DEFAULT ('') NOT NULL,
IsDefault                           BIT DEFAULT (0) NOT NULL,
AccessType                          TINYINT DEFAULT (1) NOT NULL,
PermissionID                        INT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
SortOrder                           INT DEFAULT (0) NOT NULL,
CONSTRAINT PK_InstantKB_Departments PRIMARY KEY CLUSTERED ( DepartmentID )
)

GO
----------------------------------------------------
-- InstantKB_Glossary
----------------------------------------------------
CREATE TABLE InstantKB_Glossary
(
GlossaryTermID                      INT IDENTITY(1,1) NOT NULL,
GlossaryTerm                        NVARCHAR(255) DEFAULT (N'') NOT NULL,
GlossaryTermDesc                    NTEXT DEFAULT (N'') NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantKB_Glossary PRIMARY KEY CLUSTERED ( GlossaryTermID )
)

GO
----------------------------------------------------
-- InstantKB_Levels
----------------------------------------------------
CREATE TABLE InstantKB_Levels
(
LevelID                             INT IDENTITY(1,1) NOT NULL,
LevelTabID                          TINYINT DEFAULT (1) NOT NULL,
LevelName                           NVARCHAR(50) NOT NULL,
LevelSortOrder                      INT DEFAULT (0) NOT NULL,
LevelAccessType                     TINYINT DEFAULT (1) NOT NULL,
CONSTRAINT PK_InstantKB_Levels PRIMARY KEY CLUSTERED ( LevelID )
)

GO
----------------------------------------------------
-- InstantKB_Notes
----------------------------------------------------
CREATE TABLE InstantKB_Notes
(
NoteID                              INT IDENTITY(1,1) NOT NULL,
AdminNotes                          NTEXT DEFAULT ('') NOT NULL,
StaffNotes                          NTEXT DEFAULT ('') NOT NULL,
CONSTRAINT PK_InstantKB_Notes PRIMARY KEY CLUSTERED ( NoteID )
)

GO
----------------------------------------------------
-- InstantKB_Notifications
----------------------------------------------------
CREATE TABLE InstantKB_Notifications
(
NotificationID                      INT IDENTITY(1,1) NOT NULL,
RelatedEntityID                     INT DEFAULT (0) NOT NULL,
UserID                              INT DEFAULT (0) NOT NULL,
NotificationEmailAddress            NVARCHAR(255) DEFAULT ('') NOT NULL,
NotificationType                    TINYINT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantKB_Notifications PRIMARY KEY CLUSTERED ( NotificationID )
)

GO
----------------------------------------------------
-- InstantKB_PermissionSets
----------------------------------------------------
CREATE TABLE InstantKB_PermissionSets
(
PermissionID                        INT IDENTITY(1,1) NOT NULL,
PermissionName                      NVARCHAR(255) NOT NULL,
SettingsXML                         NTEXT DEFAULT ('') NOT NULL,
Required                            BIT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantKB_PermissionSets PRIMARY KEY CLUSTERED ( PermissionID )
)

GO
----------------------------------------------------
-- InstantKB_PermissionSetsRoles
----------------------------------------------------
CREATE TABLE InstantKB_PermissionSetsRoles
(
PermissionRoleID                    INT IDENTITY(1,1) NOT NULL,
PermissionID                        SMALLINT NOT NULL,
RoleID                              SMALLINT NOT NULL,
CONSTRAINT PK_InstantKB_PermissionSetsRoles PRIMARY KEY CLUSTERED ( PermissionRoleID )
)

GO
----------------------------------------------------
-- InstantKB_PermissionSetsTabs
----------------------------------------------------
CREATE TABLE InstantKB_PermissionSetsTabs
(
PermissionSetsTabsID                INT IDENTITY(1,1) NOT NULL,
PermissionID                        INT NOT NULL,
TabID                               INT NOT NULL,
SettingsXML                         NTEXT DEFAULT ('') NOT NULL,
CONSTRAINT PK_InstantKB_PermissionSetsTabs PRIMARY KEY CLUSTERED ( PermissionSetsTabsID )
)

GO
----------------------------------------------------
-- InstantKB_Priorities
----------------------------------------------------
CREATE TABLE InstantKB_Priorities
(
PriorityID                          INT IDENTITY(1,1) NOT NULL,
PriorityTabID                       INT DEFAULT (1) NOT NULL,
PriorityName                        NVARCHAR(255) NOT NULL,
PrioritySortOrder                   INT DEFAULT (0) NOT NULL,
PriorityForegroundColor             NVARCHAR(50) DEFAULT ('') NOT NULL,
PriorityBackgroundColor             NVARCHAR(50) DEFAULT ('') NOT NULL,
PriorityImage                       NVARCHAR(50) DEFAULT ('') NOT NULL,
PriorityAccessType                  TINYINT DEFAULT (1) NOT NULL,
CONSTRAINT PK_InstantKB_Priorities PRIMARY KEY CLUSTERED ( PriorityID )
)

GO
----------------------------------------------------
-- InstantKB_Settings
----------------------------------------------------
CREATE TABLE InstantKB_Settings
(
SettingID                           INT IDENTITY(1,1) NOT NULL,
SettingText                         NVARCHAR(255) DEFAULT ('') NOT NULL,
SettingDesc                         NVARCHAR(255) DEFAULT ('') NOT NULL,
SettingsXML                         NTEXT DEFAULT ('') NOT NULL,
CONSTRAINT PK_InstantKB_Settings PRIMARY KEY CLUSTERED ( SettingID )
)

GO
----------------------------------------------------
-- InstantKB_StaffPermissionSets
----------------------------------------------------
CREATE TABLE InstantKB_StaffPermissionSets
(
PermissionID                        INT IDENTITY(1,1) NOT NULL,
PermissionName                      NVARCHAR(255) DEFAULT ('') NOT NULL,
SettingsXML                         NTEXT DEFAULT ('') NOT NULL,
IsRequired                          BIT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantKB_StaffPermissionSets_PermissionID PRIMARY KEY CLUSTERED ( PermissionID )
)

GO
----------------------------------------------------
-- InstantKB_StaffPermissionSetsTabs
----------------------------------------------------
CREATE TABLE InstantKB_StaffPermissionSetsTabs
(
StaffPermissionSetsTabsID           INT IDENTITY(1,1) NOT NULL,
PermissionID                        INT NOT NULL,
TabID                               INT NOT NULL,
SettingsXML                         NTEXT DEFAULT ('') NOT NULL,
CONSTRAINT PK_InstantKB_StaffPermissionSetsTabs PRIMARY KEY CLUSTERED ( StaffPermissionSetsTabsID )
)

GO
----------------------------------------------------
-- InstantKB_Status
----------------------------------------------------
CREATE TABLE InstantKB_Status
(
StatusID                            INT IDENTITY(1,1) NOT NULL,
StatusTabID                         INT DEFAULT (1) NOT NULL,
StatusName                          NVARCHAR(255) DEFAULT (N'') NOT NULL,
StatusSortOrder                     INT DEFAULT (0) NOT NULL,
StatusForegroundColor               NVARCHAR(50) DEFAULT ('') NOT NULL,
StatusBackgroundColor               NVARCHAR(50) DEFAULT ('') NOT NULL,
StatusImage                         NVARCHAR(50) DEFAULT ('') NOT NULL,
StatusAccessType                    TINYINT DEFAULT (1) NOT NULL,
CONSTRAINT PK_InstantKB_Status PRIMARY KEY CLUSTERED ( StatusID )
)

GO
----------------------------------------------------
-- InstantKB_TabRoles
----------------------------------------------------
CREATE TABLE InstantKB_TabRoles
(
TabID                               INT NOT NULL,
RoleID                              INT NOT NULL
)

GO
----------------------------------------------------
-- InstantKB_Tabs
----------------------------------------------------
CREATE TABLE InstantKB_Tabs
(
TabID                               INT IDENTITY(1,1) NOT NULL,
TabLabel                            NVARCHAR(100) DEFAULT ('') NOT NULL,
TabLabelNonLocalized                NVARCHAR(255) DEFAULT ('') NOT NULL,
TabTooltip                          NVARCHAR(100) DEFAULT ('') NOT NULL,
TabTooltipNonLocalized              NVARCHAR(255) DEFAULT ('') NOT NULL,
TabIcon                             NVARCHAR(255) DEFAULT ('') NOT NULL,
TabContentType                      TINYINT DEFAULT (0) NOT NULL,
TabContentTypeName                  NVARCHAR(255) DEFAULT ('') NOT NULL,
TabContentTypeNameNonLocalized      NVARCHAR(255) DEFAULT ('') NOT NULL,
FieldTemplateID                     INT DEFAULT (0) NOT NULL,
TabRedirectURL                      NVARCHAR(255) DEFAULT ('') NOT NULL,
TabClickCount                       INT DEFAULT (0) NOT NULL,
IsCustomTab                         BIT DEFAULT (0) NOT NULL,
SortOrder                           INT DEFAULT (0) NOT NULL,
CONSTRAINT PK_InstantKB_Tabs_TabID PRIMARY KEY CLUSTERED ( TabID )
)

GO
----------------------------------------------------
-- InstantKB_TroubleshooterSteps
----------------------------------------------------
CREATE TABLE InstantKB_TroubleshooterSteps
(
StepID                              INT IDENTITY(1,1) NOT NULL,
ParentStepID                        CHAR(10) DEFAULT (0) NOT NULL,
ArticleID                           INT DEFAULT (0) NOT NULL,
Title                               NVARCHAR(255) DEFAULT ('') NOT NULL,
Text                                NTEXT DEFAULT ('') NOT NULL,
UserID                              INT NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
SortOrder                           INT DEFAULT (0) NOT NULL,
CONSTRAINT PK_InstantKB_TroubleshootingSteps PRIMARY KEY CLUSTERED ( StepID )
)

GO
----------------------------------------------------
-- InstantKB_Types
----------------------------------------------------
CREATE TABLE InstantKB_Types
(
TypeID                              INT IDENTITY(1,1) NOT NULL,
TypeTabID                           INT DEFAULT (1) NOT NULL,
TypeName                            NVARCHAR(255) DEFAULT (N'') NOT NULL,
TypeIcon                            NVARCHAR(255) DEFAULT ('') NOT NULL,
TypeSortOrder                       INT DEFAULT (0) NOT NULL,
CONSTRAINT PK_InstantKB_Types PRIMARY KEY CLUSTERED ( TypeID )
)

GO
----------------------------------------------------
-- InstantKB_UserDepartments
----------------------------------------------------
CREATE TABLE InstantKB_UserDepartments
(
UserDepartmentID                    INT IDENTITY(1,1) NOT NULL,
UserID                              INT NOT NULL,
DepartmentID                        INT NOT NULL,
CONSTRAINT PK_InstantKB_UserDepartments PRIMARY KEY CLUSTERED ( UserDepartmentID )
)

GO
----------------------------------------------------
-- InstantKB_UserLevels
----------------------------------------------------
CREATE TABLE InstantKB_UserLevels
(
UserLevelID                         INT IDENTITY(1,1) NOT NULL,
Description                         NVARCHAR(100) DEFAULT ('') NOT NULL,
ImageURL                            NVARCHAR(255) DEFAULT ('') NOT NULL,
NoOfBlocks                          TINYINT DEFAULT (0) NOT NULL,
RecognitionPoints                   INT DEFAULT (0) NOT NULL,
CONSTRAINT PK_InstantKB_UserLevels PRIMARY KEY CLUSTERED ( UserLevelID )
)

GO
----------------------------------------------------
-- InstantKB_Users
----------------------------------------------------
CREATE TABLE InstantKB_Users
(
UserID                              INT NOT NULL,
IsAnonymous                         BIT DEFAULT (0) NOT NULL,
PermissionID                        INT DEFAULT (0) NOT NULL,
StaffPermissionID                   INT DEFAULT (0) NOT NULL,
PrimaryDeptID                       INT DEFAULT (0) NOT NULL,
RecognitionPoints                   INT DEFAULT (0) NOT NULL,
Skin                                NVARCHAR(100) DEFAULT (N'') NOT NULL,
MemberLevelTitle                    NVARCHAR(100) DEFAULT ('') NOT NULL,
MemberLevelImage                    NVARCHAR(255) DEFAULT ('') NOT NULL,
PhotoImage                          NVARCHAR(255) DEFAULT ('') NOT NULL,
Interests                           NVARCHAR(255) DEFAULT ('') NOT NULL,
Signature                           NTEXT DEFAULT ('') NOT NULL,
Notes                               NTEXT DEFAULT ('') NOT NULL,
CONSTRAINT PK_InstantKB_Users PRIMARY KEY CLUSTERED ( UserID )
)

GO
----------------------------------------------------
-- InstantKB_WhosOn
----------------------------------------------------
CREATE TABLE InstantKB_WhosOn
(
WhosOnID                            INT IDENTITY(1,1) NOT NULL,
CurrentTask                         INT DEFAULT (1) NOT NULL,
SessionIdentity                     NVARCHAR(100) DEFAULT (N'') NOT NULL,
Username                            NVARCHAR(255) NOT NULL,
UserID                              INT DEFAULT (0) NOT NULL,
PrimaryRoleID                       INT DEFAULT (0) NOT NULL,
CategoryID                          INT DEFAULT (0) NOT NULL,
CategoryName                        NVARCHAR(255) DEFAULT (N'') NOT NULL,
ArticleID                           INT DEFAULT (0) NOT NULL,
ArticleTitle                        NVARCHAR(255) DEFAULT (N'') NOT NULL,
IPAddress                           NVARCHAR(50) DEFAULT (N'') NOT NULL,
IsAnonymous                         BIT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
Expires                             DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantKB_WhosOn PRIMARY KEY CLUSTERED ( WhosOnID )
)

GO
----------------------------------------------------
-- InstantKB_WorkFlowDepartments
----------------------------------------------------
CREATE TABLE InstantKB_WorkFlowDepartments
(
WorkFlowDepartmentsID               INT IDENTITY(1,1) NOT NULL,
WorkFlowID                          INT NOT NULL,
DepartmentID                        INT NOT NULL,
CONSTRAINT PK_InstantKB_WorkFlowDepartments PRIMARY KEY CLUSTERED ( WorkFlowDepartmentsID )
)

GO
----------------------------------------------------
-- InstantKB_WorkFlows
----------------------------------------------------
CREATE TABLE InstantKB_WorkFlows
(
WorkFlowID                          SMALLINT IDENTITY(1,1) NOT NULL,
TabID                               INT DEFAULT (0) NOT NULL,
WorkFlowName                        NVARCHAR(255) DEFAULT (N'') NOT NULL,
WorkFlowDescription                 NTEXT,
IsDefault                           BIT DEFAULT (0) NOT NULL,
DateStamp                           DATETIME DEFAULT (getdate()) NOT NULL,
CONSTRAINT PK_InstantKB_WorkFlows PRIMARY KEY CLUSTERED ( WorkFlowID )
)

GO
----------------------------------------------------
-- InstantKB_WorkFlowSteps
----------------------------------------------------
CREATE TABLE InstantKB_WorkFlowSteps
(
WorkFlowStepID                      INT IDENTITY(1,1) NOT NULL,
WorkFlowID                          INT NOT NULL,
Name                                NVARCHAR(50) DEFAULT ('') NOT NULL,
FieldTemplateID                     INT DEFAULT (0) NOT NULL,
EditUserIDs                         NVARCHAR(750) DEFAULT ('') NOT NULL,
ChangeActionsXml                    NTEXT DEFAULT ('') NOT NULL,
SortOrder                           INT DEFAULT (0) NOT NULL,
CONSTRAINT PK_InstantKB_WorkFlowSteps PRIMARY KEY CLUSTERED ( WorkFlowStepID )
)

GO
----------------------------------------------------
-- InstantKB_WorkFlowStepsNextSteps
----------------------------------------------------
CREATE TABLE InstantKB_WorkFlowStepsNextSteps
(
WorkFlowStepID                      INT NOT NULL,
WorkFlowNextStepID                  INT NOT NULL
)

GO

/******************************************************
  Tables  End
******************************************************/
GO
/******************************************************
  Foreign keys  Begin
******************************************************/
GO
/*-------- Foreign Keys-----------------*/
ALTER TABLE InstantASP_FieldTemplateDetails
    ADD CONSTRAINT FK_InstantASP_FieldTemplateDetails_InstantASP_FieldTemplates FOREIGN KEY( FieldTemplateID )
    REFERENCES [InstantASP_FieldTemplates] ( FieldTemplateID )
    ON UPDATE NO ACTION
    ON DELETE CASCADE;

GO

/******************************************************
  Foreign keys  End
******************************************************/
GO
/******************************************************
  Stored procedures  Begin
******************************************************/
GO
----------------------------------------------------
-- iasp_sp_ActivateUserAccount
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_ActivateUserAccount (
@intUserID int,
@strKey nvarchar(25),
@intRoleID int,
@bitFound bit output
) AS

SET NOCOUNT ON 

/* If a matching confirmation key and user identity are found this proc moves the user to the role specified in the @intRoleID input parameter */

IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE (UserID = @intUserID AND ConfirmationCode = @strKey))
BEGIN /* We have a match */

	-- Reset permission ID to zero to ensure the application uses the permissions set associated with the primary role identity 
	-- Also update the users primary role association and remove the confirmation code as they are now confirmed
	UPDATE InstantASP_Users SET PrimaryRoleID = @intRoleID, ConfirmationCode ='' WHERE  (UserID = @intUserID)

	-- Indicate this was a success 
	SET @bitFound = 1
END
ELSE
BEGIN
	SET @bitFound = 0
END

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteAllQueuedEmails
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_DeleteAllQueuedEmails
 AS

SET NOCOUNT ON 

/* Deletes all queued email within InstantASP_Emails */

DELETE FROM InstantASP_Emails

GO


----------------------------------------------------
-- iasp_sp_DeleteTag 
----------------------------------------------------
GO

CREATE PROCEDURE iasp_sp_DeleteTag (
@intApplicationID tinyint,
@strTag nvarchar(255)
) AS
SET NOCOUNT ON 

/* Deletes all tags for a specific entity (article, download, post) from the InstantASP_Tags table */

DELETE FROM InstantASP_Tags WHERE (InstantASP_Tags.ApplicationID = @intApplicationID AND
 InstantASP_Tags.TagKeyword = @strTag OR InstantASP_Tags.TagKeywordEncoded = @strTag)

RETURN
GO

----------------------------------------------------
-- iasp_sp_DeleteField
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_DeleteField (
@intFieldID int
) AS
SET NOCOUNT ON 

/* Deletes a field from the InstantASP_Fields table */

DELETE FROM InstantASP_Fields WHERE (InstantASP_Fields.FieldID = @intFieldID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteFieldTemplate
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_DeleteFieldTemplate(
@intFieldTemplateID int
) AS
SET NOCOUNT ON 

/* Deletes a field template and associated template details from InstantASP_FieldTemplates and InstantASP_FieldTemplateDetails */

-- delete InstantASP_FieldTemplates
DELETE FROM InstantASP_FieldTemplates WHERE (InstantASP_FieldTemplates.FieldTemplateID = @intFieldTemplateID)

-- delete InstantASP_FieldTemplateDetails
DELETE  FROM InstantASP_FieldTemplateDetails WHERE (InstantASP_FieldTemplateDetails.FieldTemplateID = @intFieldTemplateID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteFieldTemplateDetail
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_DeleteFieldTemplateDetail(
@intFieldTemplateDetailID int
) AS
SET NOCOUNT ON 

/* Deletes a field template detail InstantASP_FieldTemplateDetails */

-- delete InstantASP_FieldTemplateDetails
DELETE  FROM InstantASP_FieldTemplateDetails WHERE (InstantASP_FieldTemplateDetails.FieldTemplateDetailID = @intFieldTemplateDetailID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteIgnoredSearchTerm
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_DeleteIgnoredSearchTerm (
@intIgnoredSearchTermID int
)
AS

SET NOCOUNT ON 

/* Deletes an ignored search term from the InstantASP_IgnoredSearchTerms table table */

DELETE FROM InstantASP_IgnoredSearchTerms WHERE (InstantASP_IgnoredSearchTerms.IgnoredSearchTermID = @intIgnoredSearchTermID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteLanguageFilter
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_DeleteLanguageFilter (
@intLanguageFilterID int
) AS
SET NOCOUNT ON 

/* Deletes a language filter from the InstantASP_LanguageFilters table */

DELETE FROM InstantASP_LanguageFilters WHERE (InstantASP_LanguageFilters.LanguageFilterID = @intLanguageFilterID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeletePickListValue
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_DeletePickListValue (
@intPickListValueID int
) AS
SET NOCOUNT ON 

/* Deletes a pick list value from the InstantASP_PickListValues table */

DELETE FROM InstantASP_PickListVAlues WHERE PickListValueID = @intPickListValueID

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteQueuedEmails
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_DeleteQueuedEmails (
@strIdentities nvarchar(2000)
) AS

SET NOCOUNT ON 

/* Accepts a comma delimited list of email identities and loops through this list removing emails matching the identities */

DECLARE @SQL nvarchar(1500)
DECLARE @Separator varchar(1)
DECLARE @Value varchar(255)
DECLARE @SepPosition int
DECLARE @LoopCount int

SET  @Separator = ','
SET @LoopCount = 0
SET @strIdentities = @strIdentities + @Separator

WHILE patindex('%' + @Separator + '%' , @strIdentities) <> 0 -- loop until we find no more separators

	BEGIN
	
		SET @SepPosition =  patindex('%' + @Separator + '%' , @strIdentities)  -- patindex matches the a pattern against a string
		SET @Value = left(@strIdentities, @SepPosition - 1) -- array value holds each single keyword
		
		/* Delete email as this has now been successfully sent */	
		 DELETE FROM InstantASP_Emails WHERE EmailID = @Value  
		
		SET @LoopCount = + 1 -- increment loop count		
		SET @strIdentities = stuff(@strIdentities, 1, @SepPosition, '') -- This replaces what we just processed with and empty string, pevents infinate loops
	END
GO
----------------------------------------------------
-- iasp_sp_DeleteRole
----------------------------------------------------
GO



CREATE PROCEDURE iasp_sp_DeleteRole (
@intRoleID smallint,
@intMoveToRoleID smallint
) AS
SET NOCOUNT ON 

/* Deletes a role from the InstantASP_Roles table and moves any users belonging to that role to a new role */

-- update users primary role within InstantASP_Users to new role
IF (@intMoveToRoleID > 0)
BEGIN
	-- update users primary role identity
	UPDATE InstantASP_Users SET InstantASP_Users.PrimaryRoleID = @intMoveToRoleID WHERE (InstantASP_Users.PrimaryRoleID = @intRoleID)
END

-- add new role relationship to InstantASP_UsersRoles for each user within the old role we are deleting
DECLARE @intUserID int
DECLARE MSGCURSOR CURSOR FOR SELECT InstantASP_Users.UserID FROM InstantASP_Users
(nolock) WHERE (InstantASP_Users.PrimaryRoleID = @intMoveToRoleID)
	
OPEN MSGCURSOR
	
FETCH NEXT FROM MSGCURSOR
INTO @intUserID
	
WHILE @@FETCH_STATUS = 0
BEGIN
	
	-- check to ensure the user / role relationship does not already exist
	IF NOT EXISTS(SELECT UserID FROM InstantASP_UsersRoles WHERE InstantASP_UsersRoles.UserID = @intUserID AND InstantASP_UsersRoles.RoleID = @intMoveToRoleID)
	BEGIN
		-- add the user / role relationship
		INSERT INTO InstantASP_UsersRoles (UserID, RoleID) VALUES (@intUserID, @intMoveToRoleID)
	END

	-- fetch next user within old role
	FETCH NEXT FROM MSGCURSOR
	INTO @intUserID
	
END

-- delete the role from the InstantASP_Roles table, this also cascades deletes to InstantASP_UsersRoles for the old role
DELETE FROM InstantASP_Roles WHERE (InstantASP_Roles.RoleID = @intRoleID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteScheduledTask
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_DeleteScheduledTask (
@intTaskID int
)
AS

SET NOCOUNT ON 

/* Deletes a task from the InstantASP_ScheduledTasks table */

DELETE FROM InstantASP_ScheduledTasks WHERE (InstantASP_ScheduledTasks.TaskID = @intTaskID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteSessionData
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_DeleteSessionData (
@strSessionIdentity nvarchar(200)
)
AS

SET NOCOUNT ON 

/* Removes session data from the sessions table for a specific session identity */

DELETE FROM InstantASP_Sessions WHERE (InstantASP_Sessions.SessionIdentity = @strSessionIdentity)

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteTableColumn
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_DeleteTableColumn (
@strTableName nvarchar(255),
@strFieldName nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Add a olumn to a table */

DECLARE @strSQL nvarchar(255)
SET @strSQL = 'ALTER TABLE ' + @strTableName + ' DROP COLUMN ' + @strFieldName

-- execute
EXECUTE sp_executesql @strSQL

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteTagsForEntity
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_DeleteTagsForEntity (
@intApplicationID tinyint,
@intRelatedEntityID int
) AS
SET NOCOUNT ON 

/* Deletes all tags for a specific entity (article, download, post) from the InstantASP_Tags table */

DELETE FROM InstantASP_Tags WHERE (InstantASP_Tags.ApplicationID = @intApplicationID AND InstantASP_Tags.RelatedEntityID = @intRelatedEntityID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteUser
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_DeleteUser (
@intUserID int
)
AS

SET NOCOUNT ON 

/* Deletes a user from the InstantASP_Users table, role deletes are cascaded */

DELETE FROM InstantASP_Users WHERE (InstantASP_Users.UserID = @intUserID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteUserRole
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_DeleteUserRole (
@intUserID int,
@intRoleID smallint
) AS

SET NOCOUNT ON 

/* Deletes a user & role association from the InstantASP_UsersRoles table */

DELETE FROM InstantASP_UsersRoles  WHERE (UserID = @intUserID AND RoleID = @intRoleID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_DeleteUserRoles
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_DeleteUserRoles (
@intUserID int
)
AS

SET NOCOUNT ON 

/* Deletes all roles associated to a specific user from the InstantASP_UsersRoles table */

DELETE FROM InstantASP_UsersRoles WHERE (InstantASP_UsersRoles.UserID = @intUserID)
GO
----------------------------------------------------
-- iasp_sp_DeleteWrapper
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_DeleteWrapper (
@intWrapperID smallint
)
AS

SET NOCOUNT ON 

/* Delets a wrapper from the InstantASP_Wrappers table */

DELETE FROM InstantASP_Wrappers WHERE (InstantASP_Wrappers.WrapperID = @intWrapperID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_ExecuteSQL
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_ExecuteSQL (
@strSQL ntext
)
AS

SET NOCOUNT ON 

/* Executes any dynamic SQL, dynamic SQL is sometimes generated in code as opposed to stored procedures for performance reasons, 
    for example cursors are bad we would rather reiterate through records in code also building complex sql is preferred in code as SQL Server concateination is pants */

EXECUTE sp_executesql @strSQL
GO
----------------------------------------------------
-- iasp_sp_ExpireSessionData
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_ExpireSessionData (
@strDateTime nvarchar(255)
)
AS

SET NOCOUNT ON 

/* Removes expired data from the sessions table */

DELETE FROM InstantASP_Sessions WHERE (InstantASP_Sessions.Expires <= @strDateTime) -- tidy session data 

RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertQueuedEmail
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_InsertQueuedEmail (
@strEmailTo nvarchar(255),
@strEmailCC nvarchar(255),
@strEmailBCC ntext,
@strEmailFrom nvarchar(255),
@strEmailSubject nvarchar(1500),
@strEmailBody ntext,
@intEmailPriority tinyint
) AS

SET NOCOUNT ON 

/* Inserts a new email into the InstantASP_Emails mail queue */

INSERT INTO InstantASP_Emails(EmailTo, EmailCC, EmailBCC, EmailFrom, EmailSubject, EmailBody, EmailPriority, DateStamp) VALUES
(@strEmailTo, @strEmailCC, @strEmailBCC, @strEmailFrom, @strEmailSubject, @strEmailBody, @intEmailPriority, GetDate())
GO
----------------------------------------------------
-- iasp_sp_InsertSessionData
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_InsertSessionData (
@strSessionID nvarchar(100),
@strSessionData nvarchar(1000),
@intExpires int
)
AS

DECLARE @DataKey nvarchar(255)
SET @DataKey = SUBSTRING(@strSessionData,1,CHARINDEX(':',@strSessionData)-1)

/* Adds new information that needs to be persistent throughout current session */

SET NOCOUNT ON 
	
	DELETE FROM InstantASP_Sessions WHERE (SessionIdentity = @strSessionID AND SessionData LIKE @DataKey + ':%') -- remove any existing session data
	INSERT INTO InstantASP_Sessions (SessionIdentity, SessionData, Expires) VALUES (@strSessionID, @strSessionData, DateAdd(n, @intExpires,GetDate())) -- add new session data

RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertTableColumn
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_InsertTableColumn (
@strTableName nvarchar(255),
@strFieldName nvarchar(255),
@strFieldDataType nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Add a olumn to a table */

DECLARE @strSQL nvarchar(255)
SET @strSQL = 'ALTER TABLE ' + @strTableName + ' ADD ' + @strFieldName + ' ' + @strFieldDataType

-- execute
EXECUTE sp_executesql @strSQL

RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertUpdateField
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_InsertUpdateField (
@intFieldID int,
@intApplicationID int,
@strFieldLabel nvarchar(255),
@strFieldLabelNonLocalized nvarchar(255),
@strFieldDescLabel nvarchar(255),
@strFieldDescLabelNonLocalized nvarchar(255),
@intFieldType int,
@intTabID int,
@intPickListID int,
@intStringSize int,
@strDefaultValue nvarchar(255),
@strFormat nvarchar(255),
@strRegExValidation nvarchar(255),
@intSortOrder int,
@bolIsRequired bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a field within the InstantASP_Fields table */

-- is this an update or insert?
IF (@intFieldID = 0)
BEGIN

	-- insert the field
	INSERT INTO InstantASP_Fields (ApplicationID, FieldLabel, FieldLabelNonLocalized, FieldDescLabel, FieldDescLabelNonLocalized, FieldType, TabID, PickListID, StringSize, DefaultValue, [Format], RegExValidation, SortOrder, IsEnabled, IsCustomField, IsRequired, DateStamp) VALUES
	(@intApplicationID, @strFieldLabel, @strFieldLabelNonLocalized, @strFieldDescLabel, @strFieldDescLabelNonLocalized, @intFieldType, @intTabID, @intPickListID, @intStringSize, @strDefaultValue, @strFormat, @strRegExValidation, @intSortOrder, 1, 1, @bolIsRequired, GetDate())

	-- set output parameter
	SET @intIdentity = @@IDENTITY
	
	-- create custom field name
	DECLARE @strCustomFieldName nvarchar(255)
	SET @strCustomFieldName = 'CustomField_' + CAST(@intIdentity AS nvarchar(255)) 
		
	-- add custom field names
	UPDATE InstantASP_Fields SET 
	FieldLabelNonLocalized = @strCustomFieldName, 
	TableFieldName = @strCustomFieldName
	WHERE (InstantASP_Fields.FieldID = @intIdentity)
	
	-- if this field type requires a pick list create one and assoicate with field
	-- Field types that required pick lists are CheckBoxList, RadioButtonLists, Select and Multiple Select lists
	IF (@intFieldType = 4 OR @intFieldType = 6 OR @intFieldType = 12 OR @intFieldType = 13)
	BEGIN
		
		-- holds the new pick list identity
		DECLARE @intPickListIdentity int
		-- add the pick list
		EXEC iasp_sp_InsertUpdatePickList 0, @strCustomFieldName, @intPickListId out
		-- get the new pick list identity
		SELECT @intPickListIdentity = (SELECT @intPickListId)
		-- update pick list identity within fields table
		UPDATE InstantASP_Fields SET PickListID = @intPickListIdentity WHERE InstantASP_Fields.FieldID = @intIdentity
	
	END		

END
ELSE -- we are updating an existing field
BEGIN
	
	-- update field
	UPDATE InstantASP_Fields SET 
	ApplicationID = @intApplicationID, 
	FieldLabel = @strFieldLabel, 
	FieldLabelNonLocalized = @strFieldLabelNonLocalized, 
	FieldDescLabel = @strFieldDescLabel, 
	FieldDescLabelNonLocalized = @strFieldDescLabelNonLocalized, 
	StringSize = @intStringSize, 
	DefaultValue = @strDefaultValue, 
	[Format] = @strFormat, 
	RegExValidation = @strRegExValidation,
	IsRequired = @bolIsRequired,
	DateStamp = GetDate()
	WHERE (InstantASP_Fields.FieldID = @intFieldID)

	-- set output parameter
	SET @intIdentity = @intFieldID
END

RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertUpdateFieldTemplate
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_InsertUpdateFieldTemplate (
@intFieldTemplateID int,
@intApplicationID int,
@intTabID int,
@strFieldTemplateName nvarchar(255),
@strFieldTemplateNameNonLocalized nvarchar(255),
@strFieldTemplateDesc nvarchar(255),
@bolCopyFieldsToTemplate bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a field template within the InstantASP_FieldTemplate table */

-- is this an update or insert?
IF (@intFieldTemplateID = 0)
BEGIN

	-- insert
	INSERT INTO InstantASP_FieldTemplates (ApplicationID, TabID, [Name], NameNonLocalized, [Description], DateStamp) VALUES
	(@intApplicationID, @intTabID, @strFieldTemplateName, @strFieldTemplateNameNonLocalized, @strFieldTemplateDesc, GetDate())

	-- set output parameter
	SET @intIdentity = @@IDENTITY

	-- do we need to copy existing fields from InstantASP_Fields into InstantASP_FeidlTemplateDetails
	IF (@bolCopyFieldsToTemplate = 1) 
	BEGIN
		-- clone fields matching content type within InstantASP_Fields into InstantASP_FieldTemplateDetails
		INSERT INTO InstantASP_FieldTemplateDetails (FieldTemplateID, FieldID, DetailDefaultValue, DetailSortOrder, DetailIsRequired, DetailIsVisible, DetailIsEnabled)
		(SELECT @intIdentity AS FieldTemplateId, FieldID, DefaultValue, SortOrder, IsRequired, IsVisible, IsEnabled FROM InstantASP_Fields WHERE ApplicationID = @intApplicationID AND TabID = @intTabID AND IsUserEditable = 1)
	END

	
END
ELSE -- we are updating an existing record
BEGIN
	
	-- update field
	UPDATE InstantASP_FieldTemplates SET 
	ApplicationID = @intApplicationID, 
	TabID = @intTabID,
	[Name] = @strFieldTemplateName, 
	NameNonLocalized = @strFieldTemplateNameNonLocalized,
	[Description] = @strFieldTemplateDesc,
	DateStamp = GetDate()
	WHERE (InstantASP_FieldTemplates.FieldTemplateID = @intFieldTemplateID)

	-- set output parameter
	SET @intIdentity = @intFieldTemplateID
END

RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertUpdateFieldTemplateDetail
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_InsertUpdateFieldTemplateDetail (
@intFieldTemplateDetailID int,
@intFieldTemplateID int,
@intFieldID int,
@strDefaultValue nvarchar(255),
@bolIsRequired bit,
@bolIsVisible bit,
@bolIsEnabled bit,
@intSortOrder int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a field template detail within the InstantASP_FieldTemplateDetails table */

-- is this an update or insert?
IF (@intFieldTemplateDetailID = 0)
BEGIN

	-- insert
	INSERT INTO InstantASP_FieldTemplateDetails (FieldTemplateID, FieldID, DetailDefaultValue, DetailIsRequired, DetailIsVisible, DetailIsEnabled, DetailSortOrder) VALUES
	(@intFieldTemplateID, @intFieldID, @strDefaultValue, @bolIsRequired, @bolIsVisible, @bolIsEnabled, @intSortOrder)

	-- set output parameter
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating an existing record
BEGIN
	
	-- update 
	UPDATE InstantASP_FieldTemplateDetails SET 
	FieldTemplateID = @intFieldTemplateID, 
	FieldID = @intFieldID, 
	DetailDefaultValue = @strDefaultValue, 
	DetailIsRequired = @bolIsRequired,
	DetailIsVisible = @bolIsVisible,
	DetailIsEnabled = @bolIsEnabled,
	DetailSortOrder = @intSortOrder
	WHERE (InstantASP_FieldTemplateDetails.FieldTemplateDetailID = @intFieldTemplateDetailID)

	-- set output parameter
	SET @intIdentity = @intFieldTemplateDetailID

END

RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertUpdateIgnoredSearchTerm
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_InsertUpdateIgnoredSearchTerm (
@intIgnoredSearchTermID int,
@intApplicationID tinyint,
@strSearchText nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates an ignored search terms within the InstantASP_IgnoredSearchTerms table */

-- is this an update or insert?
IF (@intIgnoredSearchTermID = 0)
BEGIN
	
	IF NOT EXISTS(SELECT IgnoredSearchTermID FROM InstantASP_IgnoredSearchTerms WHERE SearchText = @strSearchText AND ApplicationID = @intApplicationID)
	BEGIN
		-- insert the term
		INSERT INTO InstantASP_IgnoredSearchTerms (ApplicationID, SearchText) VALUES
		(@intApplicationID, @strSearchText)
	
		-- return the terms new identity
		SET @intIdentity = @@IDENTITY
		RETURN
	END

END
ELSE -- we are updating an existing term
BEGIN
	-- update the wrapper
	UPDATE InstantASP_IgnoredSearchTerms SET
	ApplicationID = @intApplicationID,
	SearchText = @strSearchText
	WHERE InstantASP_IgnoredSearchTerms.IgnoredSearchTermID = @intIgnoredSearchTermID

	-- return the role identity
	SET @intIdentity = @intIgnoredSearchTermID
	RETURN
END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertUpdateLanguageFilter
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_InsertUpdateLanguageFilter (
@intLanguageFilterID int,
@intApplicationID int,
@strSearchPattern nvarchar(255),
@strReplacePattern nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a language filter within InstantASP_LanguageFilters table */

-- is this an update or insert?
IF (@intLanguageFilterID = 0)
BEGIN

	-- insert the filter
	INSERT INTO InstantASP_LanguageFilters (ApplicationID, SearchPattern, ReplacePattern, DateStamp) VALUES
	(@intApplicationID, @strSearchPattern, @strReplacePattern, GetDate())

	-- return identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating an existing filter
BEGIN
	
	-- update field
	UPDATE InstantASP_LanguageFilters SET 
	ApplicationID = @intApplicationID, 
	SearchPattern = @strSearchPattern, 
	ReplacePattern = @strReplacePattern
	WHERE (InstantASP_LanguageFilters.LanguageFilterID = @intLanguageFilterID)

	-- set output parameter
	SET @intIdentity = @intLanguageFilterID
END

RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertUpdatePickList
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_InsertUpdatePickList (
@intPickListID int,
@strName as nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a pick list within the InstantASP_PickLists table */

-- is this an update or insert?
IF (@intPickListID = 0)
BEGIN

	-- insert the pick list
	INSERT INTO InstantASP_PickLists ([Name]) VALUES (@strName)

	-- return the field identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating 
BEGIN
	
	-- return the  identity
	SET @intIdentity = @intPickListID
END

RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertUpdatePickListValue
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_InsertUpdatePickListValue (
@intPickListValueID int,
@intPickListID int,
@strName as nvarchar(255),
@intSortOrder int,
@bolIsSelected bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a pick list value within the InstantASP_PickListVAlues table */

-- is this an update or insert?
IF (@intPickListValueID = 0)
BEGIN

	-- insert the pick list value
	INSERT INTO InstantASP_PickListValues (PickListID, [Name], SortOrder, IsSelected) VALUES (@intPickListID, @strName, @intSortOrder, @bolIsSelected)

	-- set identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating 
BEGIN

	UPDATE InstantASP_PickListValues SET
	PickListID = @intPickListID,
	[Name] = @strName,
	SortOrder = @intSortOrder,
	IsSelected = @bolIsSelected
	WHERE PickListValueID = @intPickListValueID
	
	-- return the  identity
	SET @intIdentity = @intPickListID
END

RETURN

GO

----------------------------------------------------
-- iasp_sp_InsertUpdateRole
----------------------------------------------------
GO

CREATE PROCEDURE iasp_sp_InsertUpdateRole (
@intRoleID int,
@strRoleName nvarchar(200),
@bitRoleVisible bit,
@strOpenMarkUp nvarchar(255),
@strCloseMarkUp nvarchar(255),
@bolAdministrator bit,
@bolModerator bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a user role within the InstantASP_Roles table */

-- is this an update or insert?
IF (@intRoleID = 0)
BEGIN
	-- insert the role
	INSERT INTO InstantASP_Roles (RoleName, RoleVisible, OpenMarkUp, CloseMarkUp, AdministratorRole, ModeratorRole) VALUES
	(@strRoleName, @bitRoleVisible, @strOpenMarkUp, @strCloseMarkUp, @bolAdministrator, @bolModerator)

	-- return the roles new identity
	SET @intIdentity = @@IDENTITY
END
ELSE -- we are updating an existing role
BEGIN
	-- update the role
	UPDATE InstantASP_Roles SET
	RoleName = @strRoleName,
	RoleVisible = @bitRoleVisible,
	OpenMarkUp = @strOpenMarkUp,
	CloseMarkUp = @strCloseMarkUp,
	AdministratorRole = @bolAdministrator,
	ModeratorRole = @bolModerator
	WHERE InstantASP_Roles.RoleID = @intRoleID

	-- return the role identity
	SET @intIdentity = @intRoleID
END

RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertUpdateScheduledTask
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_InsertUpdateScheduledTask (
@intTaskID int,
@strTaskName nvarchar(255),
@strTaskDescription nvarchar(500),
@strTaskFileName nvarchar(255),
@strTaskNextRunDate nvarchar(255),
@intTaskInterval int,
@intTaskIntervalType tinyint,
@bitTaskEnabled bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a scheduled task within the InstantASP_ScheduledTasks table */

-- is this an update or insert?
IF (@intTaskID = 0)
BEGIN
	-- insert the role
	INSERT INTO InstantASP_ScheduledTasks (TaskName, TaskDescription, TaskFileName, TaskNextRunDate, TaskInterval, TaskIntervalType, TaskEnabled, DateStamp) VALUES
	(@strTaskName, @strTaskDescription, @strTaskFileName, @strTaskNextRunDate, @intTaskInterval, @intTaskIntervalType, @bitTaskEnabled, GetDate())

	-- return the tasks new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating an existing task
BEGIN
	-- update the task
	UPDATE InstantASP_ScheduledTasks SET
	TaskName = @strTaskName,
	TaskDescription = @strTaskDescription,
	TaskFileName = @strTaskFileName,
	TaskNextRunDate = @strTaskNextRunDate,
	TaskInterval = @intTaskInterval,
	TaskIntervalType = @intTaskIntervalType,
	TaskEnabled = @bitTaskEnabled
	WHERE InstantASP_ScheduledTasks.TaskID = @intTaskID

	-- return the task identity
	SET @intIdentity = @intTaskID
	RETURN
END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertUpdateSettings
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_InsertUpdateSettings (
@intSettingID int,
@strSettingsXML ntext,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a setting within InstantASP_Settings */

-- is this an update or insert?
IF (@intSettingID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantASP_Settings (SettingsXML) 
	VALUES (@strSettingsXML)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantASP_Settings SET
	SettingsXML = @strSettingsXML
	WHERE InstantASP_Settings.SettingID = @intSettingID

	-- return the identity
	SET @intIdentity = @intSettingID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertUpdateTag
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_InsertUpdateTag (
@intTagID int,
@intApplicationID tinyint,
@intTabID int,
@intRelatedEntityID int,
@strTagKeyword nvarchar(255),
@strTagKeywordEncoded nvarchar(255),
@intUserID int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a tag within the InstantASP_Tags table */

-- is this an update or insert?
IF (@intTagID = 0)
BEGIN

	-- check to ensure tag does not already exist
	IF EXISTS(SELECT TagID FROM InstantASP_Tags WHERE (InstantASP_Tags.ApplicationID = @intApplicationID AND InstantASP_Tags.TagKeyword = @strTagKeyword AND RelatedEntityID = @intRelatedEntityID))
	BEGIN 

		SET @intIdentity = -1
		
	END
	ELSE
	BEGIN
		-- insert
		INSERT INTO InstantASP_Tags (ApplicationID,TabID, RelatedEntityID, TagKeyword, TagKeywordEncoded, UserID, DateStamp) VALUES
		(@intApplicationID, @intTabID, @intRelatedEntityID, @strTagKeyword, @strTagKeywordEncoded, @intUserID, GetDate())

		-- set output parameter
		SET @intIdentity = @@IDENTITY

	END

	RETURN

	
END
ELSE -- we are updating an existing record
BEGIN
	
	-- update tag
	UPDATE InstantASP_Tags SET 
	ApplicationID = @intApplicationID, 
	TabID = @intTabID,
	RelatedEntityID = @intRelatedEntityID,
	TagKeyword = @strTagKeyword, 
	TagKeywordEncoded = @strTagKeywordEncoded,
	UserID = @intUserID,
	DateStamp = GetDate()
	WHERE (InstantASP_Tags.TagID = @intTagID)

	-- set output parameter
	SET @intIdentity = @intTagID
END

RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertUpdateUser
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_InsertUpdateUser (
@intUserID int,
@intPrimaryRoleID int,
@strUsername nvarchar(155),
@strEmailAddress nvarchar(155),
@strPassword nvarchar(155),
@strCulture nvarchar(10),
@dbTimeZoneOffSet float,
@bolObserveDST bit,
@strDateTimeFormat nvarchar(10),
@intFirstDayOfWeek tinyint,
@strFirstName nvarchar(155),
@strLastName nvarchar(155),
@strCompanyName nvarchar(155),
@strJobTitle nvarchar(155),
@strPublicEmail nvarchar(155),
@strWebAddress nvarchar(255),
@strBlogAddress nvarchar(255),
@strMSN nvarchar(155),
@strSkype nvarchar(155),
@strAIM nvarchar(155),
@strYIM nvarchar(155),
@strICQ nvarchar (155),
@strLocation nvarchar(155),
@intDOBDay tinyint,
@intDOBMonth tinyint,
@intDOBYear int,
@strIPAddress nvarchar(20),
@strLdapUsername nvarchar(255),
@intIdentity int output
) 
AS

SET NOCOUNT ON 

/* Inserts or updates a user within InstantASP_Users */

-- is this an update or insert?
IF (@intUserID = 0)
BEGIN

	-- insert user
	INSERT INTO InstantASP_Users (PrimaryRoleID, Username, EmailAddress, [Password], Culture, TimeZoneOffset, ObserveDaylightSavingTime, DateTimeFormat, FirstDayOfWeek, FirstName, LastName, CompanyName, JobTitle, PublicEmail, WebAddress, BlogAddress, MSN, Skype, YIM, AIM, ICQ, Location, DOBDay, DOBMonth, DOBYear, IPAddress, LdapUsername) VALUES
	(@intPrimaryRoleID, @strUsername, @strEmailAddress, @strPassword, @strCulture, @dbTimeZoneOffSet, @bolObserveDST, @strDateTimeFormat, @intFirstDayOfWeek, @strFirstName, @strLastName, @strCompanyName, @strJobTitle, @strPublicEmail, @strWebAddress, @strBlogAddress, @strMSN, @strSkype, @strYIM, @strAIM, @strICQ, @strLocation, @intDOBDay, @intDOBMonth, @intDOBYear, @strIPAddress, @strLdapUsername)

	-- set output parameter
	SET @intIdentity = @@IDENTITY


	
END
ELSE -- we are updating an existing record
BEGIN
	
	-- update user
	UPDATE InstantASP_Users SET 
	PrimaryRoleID = @intPrimaryRoleID,
	Username = @strUsername,
	EmailAddress = @strEmailAddress,
	[Password] = @strPassword,
	Culture = @strCulture,
	TimeZoneOffset = @dbTimeZoneOffSet,
	ObserveDaylightSavingTime = @bolObserveDST,
	DateTimeFormat = @strDateTimeFormat,
	FirstDayOfWeek = @intFirstDayOfWeek,
	FirstName = @strFirstName,
	LastName = @strLastName,
	CompanyName = @strCompanyName,
	JobTitle = @strJobTitle,
	PublicEmail = @strPublicEmail,
	WebAddress = @strWebAddress,
	BlogAddress = @strBlogAddress,
	MSN = @strMSN,
	Skype = @strSkype,
	YIM = @strYIM,
	AIM = @strAIM,
	ICQ = @strICQ,
	Location = @strLocation,
	DOBDay = @intDOBDay,
	DOBMonth = @intDOBMonth,
	DOBYear = @intDOBYear,
	IPAddress = @strIPAddress,
	LdapUsername = @strLdapUsername
	WHERE (InstantASP_Users.UserID = @intUserID)

	-- set output parameter
	SET @intIdentity = @intUserID

END

RETURN

GO
----------------------------------------------------
-- iasp_sp_InsertUpdateWrapper
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_InsertUpdateWrapper (
@intWrapperID int,
@strWrapperName nvarchar(255),
@strWrapperHeader ntext,
@strWrapperFooter ntext,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a HTML wrapper within the InstantASP_Roles table */

-- is this an update or insert?
IF (@intWrapperID = 0)
BEGIN
	-- insert the role
	INSERT INTO InstantASP_Wrappers (WrapperName, HeaderHTML, FooterHTML) VALUES
	(@strWrapperName, @strWrapperHeader, @strWrapperFooter)

	-- return the wrappers new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating an existing wrapper
BEGIN
	-- update the wrapper
	UPDATE InstantASP_Wrappers SET
	WrapperName = @strWrapperName,
	HeaderHTML = @strWrapperHeader,
	FooterHTML = @strWrapperFooter
	WHERE InstantASP_Wrappers.WrapperID = @intWrapperID

	-- return the role identity
	SET @intIdentity = @intWrapperID
	RETURN
END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- iasp_sp_InsertUser
----------------------------------------------------
GO



CREATE PROCEDURE iasp_sp_InsertUser (
@strEmailAddress nvarchar(255),
@strPassword nvarchar(255),
@strUsername nvarchar(255),
@intPrimaryRoleID int,
@strCulture nvarchar(20),
@strIPAddress nvarchar(20),
@dblTimeZoneOffset float,
@bitObserveDaylightSavingTime bit,
@strDateTimeFormat char(1),
@strConfirmationCode nvarchar(25),
@strLdapUsername nvarchar(255),
@intIdentity int output
) AS
SET NOCOUNT ON 
/* Ensure the email address is not already present within the table */
IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE InstantASP_Users.EmailAddress = @strEmailAddress)
BEGIN 
	SET @intIdentity = 0
	RETURN
END
/* Ensure the username is not already present within the table */
IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE InstantASP_Users.Username = @strUsername)
BEGIN 
	SET @intIdentity = -1
	RETURN
END
/* Inserts a new user into the InstantASP_Users table and returns the new user identity */
INSERT INTO InstantASP_Users (EmailAddress, Username, [Password], PrimaryRoleID, Culture, IPAddress, TimeZoneOffset, ObserveDaylightSavingTime, DateTimeFormat, TotalVisits, CreatedDate, LastLoginDate, ConfirmationCode, LdapUsername)
VALUES (@strEmailAddress, @strUsername, @strPassword, @intPrimaryRoleID, @strCulture, @strIPAddress, @dblTimeZoneOffset, @bitObserveDaylightSavingTime, @strDateTimeFormat, 0, GetDate(), GetDate(), @strConfirmationCode, @strLdapUsername)
SET @intIdentity = @@IDENTITY
RETURN

GO
----------------------------------------------------
-- iasp_sp_InsertUserRole
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_InsertUserRole (
@intUserID int,
@intRoleID smallint
) AS

SET NOCOUNT ON 

/* Inserts a new user & role association to the InstantASP_UsersRoles table */

-- check to ensure we don't already have the role association
IF NOT EXISTS(SELECT RoleID From InstantASP_UsersRoles WHERE UserID = @intUserID AND RoleID = @intRoleID)
BEGIN
	INSERT INTO InstantASP_UsersRoles (UserID, RoleID) VALUES (@intUserID, @intRoleID)
END

RETURN
GO
----------------------------------------------------
-- iasp_sp_SelectAdministrator
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_SelectAdministrator (
@intUserID int
) 
AS

SET NOCOUNT ON 

/* Returns all information for a specific administrator */

SELECT * FROM InstantASP_Administrators (nolock) WHERE (InstantASP_Administrators.UserID = @intUserID)
GO
----------------------------------------------------
-- iasp_sp_SelectExpiredScheduledTasks
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_SelectExpiredScheduledTasks (
@strDateTime nvarchar(255)
)
AS

SET NOCOUNT ON 

/* Select all tasks where the run at date has passed the current date ie tasks we need to run */

SELECT * FROM InstantASP_ScheduledTasks WHERE (InstantASP_ScheduledTasks.TaskNextRunDate <= @strDateTime) -- tidy session data 

RETURN
GO
----------------------------------------------------
-- iasp_sp_SelectFields
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectFields (
@intApplicationID int
) AS
SET NOCOUNT ON 

/* Select a collection of fields */

SELECT * FROM InstantASP_Fields WHERE (InstantASP_Fields.ApplicationID = @intApplicationID) ORDER BY SortOrder ASC
GO
----------------------------------------------------
-- iasp_sp_SelectFieldsPaged
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectFieldsPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	FieldID int
)

-- insert data 
INSERT INTO #PageIndex (FieldID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantASP_Fields.* FROM #PageIndex IPI JOIN InstantASP_Fields ON InstantASP_Fields.FieldID = IPI.FieldID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- iasp_sp_SelectFieldTemplateDetails
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectFieldTemplateDetails (
@intFieldTemplateID int
) AS
SET NOCOUNT ON 

/* Select all fields for a specific field template */

SELECT InstantASP_Fields.*, InstantASP_FieldTemplateDetails.* FROM InstantASP_Fields INNER JOIN InstantASP_FieldTemplateDetails ON
InstantASP_Fields.FieldID = InstantASP_FieldTemplateDetails.FieldID WHERE InstantASP_FieldTemplateDetails.FieldTemplateID = @intFieldTemplateID
ORDER BY InstantASP_FieldTemplateDetails.DetailSortOrder ASC
GO
----------------------------------------------------
-- iasp_sp_SelectFieldTemplates
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectFieldTemplates (
@intApplicationID int
) AS
SET NOCOUNT ON 

/* Select a field group from the InstantASP_FieldTemplates table */

SELECT * FROM InstantASP_FieldTemplates WHERE ApplicationID = @intApplicationID
GO
----------------------------------------------------
-- iasp_sp_SelectFieldTemplatesPaged
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectFieldTemplatesPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	FieldTemplateID int
)

-- insert data 
INSERT INTO #PageIndex (FieldTemplateID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantASP_FieldTemplates.* FROM #PageIndex IPI JOIN InstantASP_FieldTemplates ON InstantASP_FieldTemplates.FieldTemplateID = IPI.FieldTemplateID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- iasp_sp_SelectIgnoredSearchTerms
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_SelectIgnoredSearchTerms (
@intApplicationID tinyint
)
AS

SET NOCOUNT ON 

/* Select all ignored search terms */
/* These are words that just typically add more noise to a search such as and, or, this, that, of, then etc */
/* Note how we sort via the clustered primary key for performance */

SELECT * FROM InstantASP_IgnoredSearchTerms (nolock)
WHERE (InstantASP_IgnoredSearchTerms.ApplicationID = @intApplicationID)
ORDER BY InstantASP_IgnoredSearchTerms.IgnoredSearchTermID DESC
GO
----------------------------------------------------
-- iasp_sp_SelectIgnoredSearchTermsPaged
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectIgnoredSearchTermsPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	IgnoredSearchTermID int
)

-- insert data 
INSERT INTO #PageIndex (IgnoredSearchTermID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantASP_IgnoredSearchTerms.* FROM #PageIndex IPI JOIN InstantASP_IgnoredSearchTerms ON InstantASP_IgnoredSearchTerms.IgnoredSearchTermID = IPI.IgnoredSearchTermID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- iasp_sp_SelectLanguageFilters
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectLanguageFilters (
@intApplicationID int
) AS
SET NOCOUNT ON 

/* Select a collection of language ilters from InstantASP_LanguageFilters */

SELECT * FROM InstantASP_LanguageFilters WHERE (InstantASP_LanguageFilters.ApplicationID = @intApplicationID)
GO
----------------------------------------------------
-- iasp_sp_SelectLanguageFiltersPaged
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectLanguageFiltersPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	LanguageFilterID int
)

-- insert data 
INSERT INTO #PageIndex (LanguageFilterID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantASP_LanguageFilters.* FROM #PageIndex IPI JOIN InstantASP_LanguageFilters ON InstantASP_LanguageFilters.LanguageFilterID = IPI.LanguageFilterID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- iasp_sp_SelectPickListValues
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectPickListValues (
@intPickListID int
) AS
SET NOCOUNT ON 

/* Select a values for a specific pick list */

IF (@intPickListID > 0)
BEGIN
	SELECT * FROM InstantASP_PickListValues WHERE PickListID = @intPickListID ORDER BY SortOrder ASC
END
ELSE
BEGIN
	SELECT * FROM InstantASP_PickListValues ORDER BY SortOrder ASC
END
GO
----------------------------------------------------
-- iasp_sp_SelectQueuedEmails
----------------------------------------------------
GO



CREATE PROCEDURE iasp_sp_SelectQueuedEmails (
@intResultLimit int
)
AS
SET NOCOUNT ON 
/* Returns emails within current queue ordered by priority */
DECLARE @strSQL nvarchar(500)
SELECT @strSQL = 'SELECT TOP ' + CAST(@intResultLimit as nvarchar(25)) + ' * FROM InstantASP_Emails (nolock) ORDER BY DateStamp DESC, EmailPriority ASC'
EXECUTE sp_executesql @strSQL
GO
----------------------------------------------------
-- iasp_sp_SelectRole
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_SelectRole (
@strRoleName nvarchar(255)
)
AS

SET NOCOUNT ON 

/* Returns All Information for a specific Role */

SELECT * FROM InstantASP_Roles (nolock) WHERE RoleName = @strRoleName
GO
----------------------------------------------------
-- iasp_sp_SelectRoleByID
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectRoleByID (
@intRoleID int
)
AS

SET NOCOUNT ON 

/* Returns All Information for a specific Role */

SELECT * FROM InstantASP_Roles (nolock) WHERE RoleID = @intRoleID
GO
----------------------------------------------------
-- iasp_sp_SelectRoles
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectRoles 
AS

SET NOCOUNT ON 

/* Returns all roles */

SELECT * FROM InstantASP_Roles (nolock) ORDER BY RoleID ASC
GO
----------------------------------------------------
-- iasp_sp_SelectRolesPaged
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectRolesPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	RoleID int
)

-- insert data 
INSERT INTO #PageIndex (RoleID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantASP_Roles.* FROM #PageIndex IPI JOIN InstantASP_Roles ON InstantASP_Roles.RoleID = IPI.RoleID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- iasp_sp_SelectScheduledTasks
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_SelectScheduledTasks 
AS

SET NOCOUNT ON 

/* Returns all scheduled tasks */

SELECT * FROM InstantASP_ScheduledTasks (nolock) ORDER BY InstantASP_ScheduledTasks.DateStamp DESC
GO
----------------------------------------------------
-- iasp_sp_SelectSessionData
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_SelectSessionData (
@strSessionID nvarchar(255)
)
AS

SET NOCOUNT ON 

/* Returns all session information for a specific session identity */

SELECT SessionData FROM InstantASP_Sessions (nolock) WHERE SessionIdentity = @strSessionID
GO
----------------------------------------------------
-- iasp_sp_SelectSettings
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_SelectSettings 
AS

SET NOCOUNT ON 

/* Selects application settings that can be shared across InstantASP applications */

SELECT * FROM InstantASP_Settings (nolock)
GO
----------------------------------------------------
-- iasp_sp_SelectSQLStatistics
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_SelectSQLStatistics
AS

SET NOCOUNT ON 

/* Selects important SQL Server diagnostics information*/

SELECT @@VERSION AS Version, @@LANGUAGE AS Language, @@CONNECTIONS AS Connections, @@IDLE AS IDLE, @@IO_BUSY AS IOBusy, 
@@PACK_RECEIVED AS PackReceived, @@PACK_SENT AS PackSent, @@PACKET_ERRORS AS PackErrors, @@TOTAL_READ AS TotalReads, @@TOTAL_WRITE AS TotalWrites,
@@TOTAL_ERRORS AS TotalErrors
GO
----------------------------------------------------
-- iasp_sp_SelectStoredProcedures
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_SelectStoredProcedures
AS

SELECT Name FROM sysobjects WHERE
(xtype = 'p') AND (name NOT LIKE 'dt%')
ORDER BY name
GO
----------------------------------------------------
-- iasp_sp_SelectTables
----------------------------------------------------
GO




CREATE Procedure iasp_sp_SelectTables
AS

SET NOCOUNT ON

CREATE TABLE #TBLSize (TableName varchar(100), TableRows int, TableReserved varchar(80), TableData varchar(80), TableIndexSize varchar(80), TableUnused varchar(80))

DECLARE @TableName varchar(80) 

DECLARE MSGCURSOR CURSOR FOR SELECT NAME FROM sysobjects WHERE xType = 'U'

OPEN MSGCURSOR

FETCH NEXT FROM MSGCURSOR 
INTO @TableName

	WHILE @@FETCH_STATUS = 0
	BEGIN
	
	   INSERT INTO #tblSize(TableName, TableRows, TableReserved, TableData, TableIndexSize, TableUnused)
	   EXEC Sp_SpaceUsed @TableName
	      
	   -- Get the next table.
	   FETCH NEXT FROM MSGCURSOR 
	   INTO @TableName
	END

CLOSE MSGCURSOR
DEALLOCATE MSGCURSOR

-- select on the instant tables
SELECT TableName, TableRows, TableReserved, TableData, TableIndexSize, TableUnused
FROM #tblSize WHERE (TableName LIKE 'Instant%')  ORDER BY TableName 

DROP TABLE #TblSize

return
GO
----------------------------------------------------
-- iasp_sp_SelectTags
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectTags (
@intApplicationID int,
@intRelatedEntityId int
) AS
SET NOCOUNT ON 

/* Select all content tags for a specific application */

IF (@intRelatedEntityId > 0)
BEGIN
	SELECT TagID, RelatedEntityID, TagKeyword, TagKeywordEncoded
	FROM InstantASP_Tags WHERE (ApplicationID = @intApplicationID AND RelatedEntityID = @intRelatedEntityId)
	ORDER BY TagKeyword

END
ELSE -- just return all tags
BEGIN
	SELECT TagID, RelatedEntityID, TagKeyword, TagKeywordEncoded
	FROM InstantASP_Tags WHERE (ApplicationID = @intApplicationID)
	ORDER BY TagKeyword
END
GO
----------------------------------------------------
-- iasp_sp_SelectTagsByPrefixText
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectTagsByPrefixText (
@intApplicationID int,
@strPrefixText nvarchar(255)
) AS
SET NOCOUNT ON 

/* Select tags by prefix text and application */

DECLARE @SQL nvarchar(1000)
SELECT @SQL = 'SELECT MAX(TagID) AS TagID, TagKeyword, MAX(RelatedEntityID) AS RelatedEntityID, TagKeywordEncoded FROM InstantASP_Tags WHERE (ApplicationID = ' + 
CAST(@intApplicationID AS nVarChar(10)) + ' AND TagKeyword  LIKE ''' + CAST(@strPrefixText AS nVarChar(255)) + '%'') GROUP BY TagKeyword, TagKeywordEncoded ORDER BY TagKeyword'

-- ensure we use sp_executesql to cache execution plan for dynamic query
EXECUTE sp_executesql @SQL
GO
----------------------------------------------------
-- iasp_sp_SelectTagsForEntities
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectTagsForEntities (
@intApplicationID int,
@strRelatedEntityIds nvarchar(2000)
) AS
SET NOCOUNT ON 

/* Select tags for multiple entities */

DECLARE @SQL nvarchar(4000)
SELECT @SQL = '

SELECT TagID, RelatedEntityID, TagKeyword, TagKeywordEncoded FROM InstantASP_Tags 
WHERE (ApplicationID = ' +   CAST(@intApplicationID AS nVarChar(5)) + ' AND RelatedEntityID IN (' + CAST(@strRelatedEntityIds AS nVarChar(2000)) + ')) ORDER BY TagKeyword'

-- ensure we use sp_executesql to cache execution plan for dynamic query
EXECUTE sp_executesql @SQL
GO
----------------------------------------------------
-- iasp_sp_SelectTagsGroupedByKeyword
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectTagsGroupedByKeyword (
@intApplicationID int,
@intRelatedEntityId int
) AS
SET NOCOUNT ON 
/* Select content tags for a specific application */

IF (@intRelatedEntityId >0)
BEGIN
	SELECT TagKeyword, TagKeywordEncoded, COUNT(TagID) AS TagCount
	FROM InstantASP_Tags WHERE (ApplicationID = @intApplicationID AND RelatedEntityID = @intRelatedEntityId)
	GROUP BY TagKeyword, TagKeywordEncoded ORDER BY TagKeyword
END
ELSE -- just return all tags
BEGIN
	SELECT TagKeyword, TagKeywordEncoded, COUNT(TagID) AS TagCount
	FROM InstantASP_Tags WHERE (ApplicationID = @intApplicationID)
	GROUP BY TagKeyword, TagKeywordEncoded ORDER BY TagKeyword
END
GO
----------------------------------------------------
-- iasp_sp_SelectTagsGroupedByKeywordForTabID
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectTagsGroupedByKeywordForTabID (
@intApplicationID int,
@intTabID int
) AS
SET NOCOUNT ON 

/* Select content tags for a specific application and tab */

SELECT TagKeyword, COUNT(TagID) AS TagCount
FROM InstantASP_Tags WHERE (ApplicationID = @intApplicationID AND TabID = @intTabID)
GROUP BY TagKeyword ORDER BY TagKeyword, TagCount
GO
----------------------------------------------------
-- iasp_sp_SelectTagsGroupedByKeywordForUserID
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_SelectTagsGroupedByKeywordForUserID (
@intApplicationID int,
@intUserID int
) AS
SET NOCOUNT ON 

/* Select content tags for a specific application and user */

SELECT TagKeyword, TagKeywordEncoded, COUNT(TagID) AS TagCount
FROM InstantASP_Tags WHERE (ApplicationID = @intApplicationID AND UserID = @intUserID)
GROUP BY TagKeyword, TagKeywordEncoded ORDER BY TagKeyword
GO
----------------------------------------------------
-- iasp_sp_SelectUserCountForRoles
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_SelectUserCountForRoles (
@intRoleID int,
@bitPrimary bit,
@intCount int output
) AS

SET NOCOUNT ON 

/* Counts the primary or secondary users belonging to any role */

IF (@bitPrimary = 1)
BEGIN
	SET @intCount = (SELECT COUNT(InstantASP_Users.UserID) FROM InstantASP_Users (nolock) INNER JOIN
              InstantASP_UsersRoles ON InstantASP_Users.UserID = InstantASP_UsersRoles.UserID 
	WHERE (InstantASP_Users.PrimaryRoleID = @intRoleID) AND (InstantASP_UsersRoles.RoleID = @intRoleID))
END
ELSE
BEGIN
	SET @intCount = (SELECT COUNT(InstantASP_Users.UserID) FROM InstantASP_Users (nolock)  INNER JOIN
              InstantASP_UsersRoles ON InstantASP_Users.UserID = InstantASP_UsersRoles.UserID 
	WHERE (InstantASP_Users.PrimaryRoleID <> @intRoleID) AND (InstantASP_UsersRoles.RoleID = @intRoleID))
END
GO
----------------------------------------------------
-- iasp_sp_SelectUserData
----------------------------------------------------
GO



CREATE PROCEDURE iasp_sp_SelectUserData (
@strUsername nvarchar(255),
@strPassword nvarchar(255),
@strEncyptedPassword nvarchar(255),
@intLoginUsing int,
@intUserID int
) AS
SET NOCOUNT ON 
DECLARE @RoleNames nvarchar(600)
/* @intLoginUsing determines if we should use the username or email address field for the login field
    @intLoginUsing = 1 we use the email address
    @intLoginUsing = 2 we use the username */

-- @intLocalUserID is used to return a second query with all user roles
DECLARE @intLocalUserID int

/* If we have a user identity use this to select data */
IF (@intUserID > 0)
BEGIN	
	SELECT * FROM InstantASP_Users (nolock) WHERE (InstantASP_Users.UserID = @intUserID)
	SET @intLocalUserID = @intUserID
END
ELSE
BEGIN
	
	-- check member based on email or username (see above) and password
	IF (@strPassword <> '' AND @strEncyptedPassword <> '')
	BEGIN
		-- login using email address
		IF  (@intLoginUsing = 1) 
		BEGIN
			SELECT * FROM InstantASP_Users IU (nolock) WHERE (IU.EmailAddress = @strUsername)  AND (IU.[Password] = @strPassword OR IU.[Password] = @strEncyptedPassword)
			SET @intLocalUserID = (SELECT IU.UserID FROM InstantASP_Users IU (nolock) WHERE (IU.EmailAddress = @strUsername)  AND (IU.[Password] = @strPassword OR IU.[Password] = @strEncyptedPassword))
		END
		ELSE IF   (@intLoginUsing = 2) -- login using username
		BEGIN
			SELECT * FROM InstantASP_Users IU (nolock) WHERE (IU.Username = @strUsername)  AND (IU.[Password] = @strPassword OR IU.[Password] = @strEncyptedPassword)
			SET @intLocalUserID = (SELECT IU.UserID FROM InstantASP_Users IU (nolock) WHERE (IU.Username = @strUsername)  AND (IU.[Password] = @strPassword OR IU.[Password] = @strEncyptedPassword))
		END
	END
	ELSE
	BEGIN
		SELECT * FROM InstantASP_Users IU (nolock) WHERE (IU.EmailAddress = @strUsername OR IU.Username = @strUsername)
		SET @intLocalUserID = (SELECT IU.UserID FROM InstantASP_Users IU (nolock) WHERE (IU.EmailAddress = @strUsername OR IU.Username = @strUsername))
	END
END

-- select roles for user
EXEC iasp_sp_SelectUserRoles @intLocalUserID

RETURN
GO
----------------------------------------------------
-- iasp_sp_SelectUserRoles
----------------------------------------------------
GO



CREATE PROCEDURE iasp_sp_SelectUserRoles (
@intUserID int
) AS
SET NOCOUNT ON 

---- select all roles associated with a user
SELECT InstantASP_Roles.* FROM InstantASP_UsersRoles INNER JOIN
InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantASP_UsersRoles.UserID = @intUserID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_SelectWrappers
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_SelectWrappers 
AS

SET NOCOUNT ON 

/* Selects all available wrappers from the InstantASP_Wrappers table */

SELECT * FROM InstantASP_Wrappers (nolock) ORDER BY InstantASP_Wrappers.WrapperID DESC
GO
----------------------------------------------------
-- iasp_sp_ShrinkDatabase
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_ShrinkDatabase
@strDatabaseName nvarchar(75),
@intPercentage int

/* Attempts to shrink the database */
AS DBCC SHRINKDATABASE (@strDatabaseName, @intPercentage)
GO
----------------------------------------------------
-- iasp_sp_UpdateAdminNotes
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_UpdateAdminNotes (
@intUserID int,
@strMessage ntext,
@intIdentity int output
)
AS

SET NOCOUNT ON 

/* Updates an admins notes within the InstantASP_Administrators table */

-- if notes do not already exists insert a new row
IF NOT EXISTS(SELECT AdministratorID FROM InstantASP_Administrators (nolock) WHERE InstantASP_Administrators.UserID = @intUserID)
BEGIN

	-- insert administrator with notes
	INSERT INTO InstantASP_Administrators (UserID, Notes) VALUES (@intUserID, @strMessage)

	-- return administrator record identity
	SET @intIdentity = (SELECT AdministratorID FROM InstantASP_Administrators WHERE InstantASP_Administrators.UserID = @intUserID)

END
ELSE -- we already have a record so simply update
BEGIN

	-- update existing record
	UPDATE InstantASP_Administrators SET InstantASP_Administrators.Notes = @strMessage
	WHERE (InstantASP_Administrators.UserID = @intUserID)

	-- return administrator record identity
	SET @intIdentity = (SELECT InstantASP_Administrators.AdministratorID FROM InstantASP_Administrators WHERE InstantASP_Administrators.UserID = @intUserID)

END
GO
----------------------------------------------------
-- iasp_sp_UpdateEmailAttempts
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_UpdateEmailAttempts (
@strIdentities nvarchar(2000)
) AS
SET NOCOUNT ON 
/* Accepts a comma delimited list of email identities and loops through this list incrementing retry count for failed emails */
DECLARE @Separator varchar(1)
DECLARE @Value varchar(255)
DECLARE @SepPosition int
DECLARE @LoopCount int
SET  @Separator = ','
SET @LoopCount = 0
SET @strIdentities = @strIdentities + @Separator
WHILE patindex('%' + @Separator + '%' , @strIdentities) <> 0 -- loop until we find no more separators
	BEGIN
	
		SET @SepPosition =  patindex('%' + @Separator + '%' , @strIdentities)  -- patindex matches the a pattern against a string
		SET @Value = left(@strIdentities, @SepPosition - 1) -- array value holds each single keyword
		
		/* Update email attempts */
		 UPDATE InstantASP_Emails SET InstantASP_Emails.EmailAttempts = InstantASP_Emails.EmailAttempts + 1 WHERE InstantASP_Emails.EmailID = @Value  
		
		SET @LoopCount = + 1 -- increment loop count		
		SET @strIdentities = stuff(@strIdentities, 1, @SepPosition, '') -- This replaces what we just processed with and empty string, pevents infinate loops
	END
GO
----------------------------------------------------
-- iasp_sp_UpdateField
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_UpdateField (
@intFieldID int,
@strDefaultValue nvarchar(255),
@bolIsVisible bit,
@bolIsEnabled bit,
@bolIsRequired bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Updates basic field information  within the InstantASP_Fields table */
	
UPDATE InstantASP_Fields SET 
DefaultValue = @strDefaultValue,
IsVisible = @bolIsVisible,
IsEnabled = @bolIsEnabled,
IsRequired = @bolIsRequired
WHERE (InstantASP_Fields.FieldID = @intFieldID)

-- set output parameter
SET @intIdentity = @intFieldID

RETURN
GO
----------------------------------------------------
-- iasp_sp_UpdateFieldSortOrder
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_UpdateFieldSortOrder (
@intFieldID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a fields sort order within InstantASP_Fields */

UPDATE InstantASP_Fields SET SortOrder = @intSortOrder WHERE (InstantASP_Fields.FieldID = @intFieldID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_UpdateFieldTemplateDateStamp
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_UpdateFieldTemplateDateStamp (
@intFieldTemplateID int
) AS

SET NOCOUNT ON 

/* Updates the datastamp field within InstantASP_FieldTemplates */
	
UPDATE InstantASP_FieldTemplates SET DateStamp = GetDate()
WHERE (InstantASP_FieldTemplates.FieldTemplateID = @intFieldTemplateID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_UpdateFieldTemplateDetailSortOrder
----------------------------------------------------
GO
CREATE PROCEDURE iasp_sp_UpdateFieldTemplateDetailSortOrder (
@intFieldTemplateDetailID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a field template details sort order within InstantASP_FieldTemplateDetails */

UPDATE InstantASP_FieldTemplateDetails SET DetailSortOrder = @intSortOrder WHERE (InstantASP_FieldTemplateDetails.FieldTemplateDetailID = @intFieldTemplateDetailID)

RETURN
GO
----------------------------------------------------
-- iasp_sp_UpdateLastLoginDate
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_UpdateLastLoginDate (
@intUserID int
)
AS

SET NOCOUNT ON 

UPDATE InstantASP_Users SET LastLoginDate = GetDate(), TotalVisits = TotalVisits + 1 WHERE UserID = @intUserID
GO
----------------------------------------------------
-- iasp_sp_UpdateLastLoginDateByEmailAddress
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_UpdateLastLoginDateByEmailAddress (
@strEmailAddress nvarchar(255)
)
AS

SET NOCOUNT ON 

UPDATE InstantASP_Users SET LastLoginDate = GetDate(), TotalVisits = TotalVisits + 1 WHERE EmailAddress = @strEmailAddress
GO
----------------------------------------------------
-- iasp_sp_UpdateRegistrationDetails
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_UpdateRegistrationDetails (
@intUserID int,
@strUsername nvarchar(255),
@strEmailAddress nvarchar(255),
@strPassword nvarchar(255),
@intPrimaryRoleID int,
@strConfirmationCode nvarchar(25),
@intReturnCode int output
)
AS

SET NOCOUNT ON 

/* Updates a users primary login details */

-- Check to see if username already exists for any other user

IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE Username = @strUsername AND UserID <> @intUserID)
BEGIN
	SET @intReturnCode = - 1
	RETURN
END 

-- Check to see if email address already exists for any other user

IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE EmailAddress = @strEmailAddress AND UserID <> @intUserID)
BEGIN
	SET @intReturnCode = - 2
	RETURN
END 

-- update primary details

UPDATE InstantASP_Users SET Username = @strUsername, EmailAddress = @strEmailAddress, 
[Password] = @strPassword, PrimaryRoleID = @intPrimaryRoleID WHERE InstantASP_Users.UserID = @intUserID

-- if we have a new confirmation code update the ConfirmationCode column

IF (@strConfirmationCode != '')
BEGIN
	UPDATE InstantASP_Users SET  ConfirmationCode = @strConfirmationCode WHERE InstantASP_Users.UserID = @intUserID 
END

-- set returnCode ouput parameter to user identity

SET @intReturnCode = @intUserID
GO
----------------------------------------------------
-- iasp_sp_UpdateScheduledTaskGuid
----------------------------------------------------
GO





CREATE PROCEDURE iasp_sp_UpdateScheduledTaskGuid (
@intTaskID int,
@strTaskGuid nvarchar(75)
)
AS

SET NOCOUNT ON 

/* Updates a tasks GUID identifier used whilsts the task is running to ensure it's from the task manager */

-- update settings
UPDATE InstantASP_ScheduledTasks SET 
TaskGuid = @strTaskGuid
WHERE InstantASP_ScheduledTasks.TaskID = @intTaskID
GO
----------------------------------------------------
-- iasp_sp_UpdateScheduledTaskRunInformation
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_UpdateScheduledTaskRunInformation (
@intTaskID int,
@strTaskLastRunDate nvarchar(100),
@strTaskNextRunDate nvarchar(100)
)
AS

SET NOCOUNT ON 

/* Updates a tasks next run date within the InstantASP_ScheduledTasks table */

-- update settings
UPDATE InstantASP_ScheduledTasks SET 
TaskLastRunDate = @strTaskLastRunDate,
TaskNextRunDate = @strTaskNextRunDate
WHERE InstantASP_ScheduledTasks.TaskID = @intTaskID
GO
----------------------------------------------------
-- iasp_sp_UpdateUsersCulture
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_UpdateUsersCulture (
@intUserID int,
@strCulture nvarchar(20)
)
AS

SET NOCOUNT ON 

/* Updates a users culture setting within the InstantASP_Users table */

-- update settings
UPDATE InstantASP_Users SET 
Culture = @strCulture WHERE InstantASP_Users.UserID = @intUserID
GO
----------------------------------------------------
-- iasp_sp_UpdateUsersEmailAddress
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_UpdateUsersEmailAddress (
@intUserID int,
@strEmailAddress nvarchar(255),
@intReturnCode int output
)
AS

SET NOCOUNT ON 

/* Updates a users primary email address within the InstantASP_Users table */

-- check to see if email address already exists for any other user

IF EXISTS(SELECT InstantASP_Users.UserID FROM InstantASP_Users (nolock) WHERE (InstantASP_Users.EmailAddress = @strEmailAddress AND InstantASP_Users.UserID <> @intUserID))
BEGIN
	SET @intReturnCode = - 1
	RETURN
END 

-- update email address
UPDATE InstantASP_Users SET InstantASP_Users.EmailAddress = @strEmailAddress WHERE (InstantASP_Users.UserID = @intUserID)

-- set returnCode ouput parameter to user identity
SET @intReturnCode = @intUserID
GO
----------------------------------------------------
-- iasp_sp_UpdateUserSettings
----------------------------------------------------
GO



CREATE PROCEDURE iasp_sp_UpdateUserSettings (
@intUserID int,
@strCulture nvarchar(20),
@dblTimeZoneOffset float,
@bitObserveDaylightSavingTime bit,
@strDateTimeFormat nvarchar(1),
@intFirstDayOfWeek tinyint,
@intIdentity int output
)
AS
SET NOCOUNT ON 
/* Updates a users settings within the InstantASP_Users table */
-- update settings
UPDATE InstantASP_Users SET 
Culture = @strCulture, 
TimeZoneOffset = @dblTimeZoneOffset, 
ObserveDaylightSavingTime = @bitObserveDaylightSavingTime,
DateTimeFormat = @strDateTimeFormat,
FirstDayOfWeek = @intFirstDayOfWeek
WHERE InstantASP_Users.UserID = @intUserID
-- returns users identity, used to ensure transaction was successfull 
SET @intIdentity = (SELECT UserID FROM InstantASP_Users (nolock) WHERE InstantASP_Users.UserID = @intUserID)
GO
----------------------------------------------------
-- iasp_sp_UpdateUsersPassword
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_UpdateUsersPassword (
@intUserID int,
@strPassword nvarchar(255)
)
AS

SET NOCOUNT ON 

/* Updates a users password within the InstantASP_Users table */

-- update password
UPDATE InstantASP_Users SET InstantASP_Users.[Password] = @strPassword WHERE (InstantASP_Users.UserID = @intUserID)
GO
----------------------------------------------------
-- iasp_sp_UpdateUsersPrimaryRole
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_UpdateUsersPrimaryRole (
@intUserID int,
@intRoleID smallint,
@intReturnCode int output
)
AS

SET NOCOUNT ON 

/* Updates a users primary role within the InstantASP_Users table, also checks to ensure primary role relationship exists within InstantASP_UsersRoles */

-- update primary role
UPDATE InstantASP_Users SET InstantASP_Users.PrimaryRoleID = @intRoleID WHERE (InstantASP_Users.UserID = @intUserID)

-- deteremine if relationship exists
IF NOT EXISTS(SELECT InstantASP_UsersRoles.RoleID FROM InstantASP_UsersRoles (nolock) WHERE (InstantASP_UsersRoles.UserID = @intUserID AND InstantASP_UsersRoles.RoleID = @intRoleID))
BEGIN
	-- we did not find a relationship for the primary role so add one
	INSERT INTO InstantASP_UsersRoles (UserID, RoleID) VALUES (@intUserID, @intRoleID)
END

-- set returnCode ouput parameter to user identity
IF (@@ERROR <> 0)
BEGIN
	SET @intReturnCode = -1
END
ELSE
BEGIN
	SET @intReturnCode = @intUserID
END
GO
----------------------------------------------------
-- iasp_sp_UpdateUsersUsername
----------------------------------------------------
GO




CREATE PROCEDURE iasp_sp_UpdateUsersUsername (
@intUserID int,
@strUsername nvarchar(255),
@intReturnCode int output
)
AS

SET NOCOUNT ON 

/* Updates a users username within the InstantASP_Users table */

-- check to see if username already exists for any other user

IF EXISTS(SELECT InstantASP_Users.UserID FROM InstantASP_Users (nolock) WHERE (Username = @strUsername AND InstantASP_Users.UserID <> @intUserID))
BEGIN
	SET @intReturnCode = - 1
	RETURN
END 

-- update username
UPDATE InstantASP_Users SET InstantASP_Users.Username = @strUsername WHERE (InstantASP_Users.UserID = @intUserID)

-- set returnCode ouput parameter to user identity
SET @intReturnCode = @intUserID
GO
----------------------------------------------------
-- ikb_sp_CleanTables
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_CleanTables (
@strDateTime nvarchar(255)
)
AS

SET NOCOUNT ON 

/* Cleans all tables of any expired data */

-- delete expired who's on data
EXEC ikb_sp_DeleteWhosOnData @strDateTime

-- delete expired attachments
--EXEC if_sp_DeleteTemporaryAttachments @strDateTime

-- delete expired search results
--EXEC if_sp_DeleteTemporarySearchResults @strDateTime

-- delete expired topic read information
EXEC ikb_sp_DeleteExpiredArticleRead @strDateTime

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteArticle
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteArticle (
@intArticleID int
) AS
SET NOCOUNT ON 

/* Delete an article from InstantKB_Articles */
DELETE FROM InstantKB_Articles WHERE (InstantKB_Articles.ArticleID = @intArticleID)

/* Delete any tags */
DELETE FROM InstantASP_Tags WHERE (RelatedEntityID = @intArticleID AND ApplicationID = 2)

/* Delete article attachments */
DELETE FROM InstantKB_Attachments WHERE (RelatedEntityID = @intArticleID AND AttachmentType = 1)

/* Delete article comments */
DELETE FROM InstantKB_ArticleComments WHERE (ArticleID = @intArticleID)

/* Delete article categories from InstantKB_ArticleCategories */
EXEC ikb_sp_DeleteArticleCategories @intArticleID

/* Delete article roles from InstantKB_ArticleRoles */
EXEC ikb_sp_DeleteArticleRoles @intArticleID

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteArticleCategories
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteArticleCategories (
@intArticleID int
) AS

SET NOCOUNT ON 

/* Delete all article category relaationships from InstantKB_ArticleCategories */

DELETE FROM InstantKB_ArticleCategories WHERE (ArticleID = @intArticleID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteArticleCategory
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteArticleCategory (
@intArticleID int,
@intCategoryID int
) AS

SET NOCOUNT ON 

/* Delete a specific article & category relaationship from InstantKB_ArticleCategories */

DELETE FROM InstantKB_ArticleCategories WHERE (ArticleID = @intArticleID AND CategoryID = @intCategoryID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteArticleComment
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteArticleComment (
@intCommentID int
) AS
SET NOCOUNT ON 

/* Deletes a comment from InstantKB_ArticleComments table */

DELETE FROM InstantKB_ArticleComments WHERE (InstantKB_ArticleComments.CommentID = @intCommentID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteArticleRelatedLinks
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteArticleRelatedLinks (
@intArticleID int
) AS
SET NOCOUNT ON 

/* Deletes all related links for an article from InstantKB_ArticleRelatedLinks */

DELETE FROM InstantKB_ArticleRelatedLinks WHERE (InstantKB_ArticleRelatedLinks.ArticleID = @intArticleID)

-- update related link count in articles tabl
UPDATE InstantKB_Articles SET InstantKB_Articles.RelatedLinkCount = 0 WHERE (InstantKB_Articles.ArticleID = @intArticleID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteArticleRole
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteArticleRole (
@intArticleID int,
@intRoleID int
) AS

SET NOCOUNT ON 

/* Delete a specific article & article relaationship from InstantKB_ArticleRoles */

DELETE FROM InstantKB_ArticleRoles WHERE (ArticleID = @intArticleID AND RoleID = @intRoleID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteArticleRoles
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteArticleRoles (
@intArticleID int
) AS

SET NOCOUNT ON 

/* Delete all article role relaationships from InstantKB_ArticleRoles */

DELETE FROM InstantKB_ArticleRoles WHERE (ArticleID = @intArticleID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteAttachment
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteAttachment (
@intAttachmentID int
) AS
SET NOCOUNT ON 

/* Deletes an attachment InstantKB_Attachments table */

DELETE FROM InstantKB_Attachments WHERE (InstantKB_Attachments.AttachmentID = @intAttachmentID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteAttachmentType
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteAttachmentType (
@intAttachmentTypeID int
) AS
SET NOCOUNT ON 

/* Delete an attachment type from InstantKB_AttachmentTypes */

DELETE FROM InstantKB_AttachmentTypes WHERE (InstantKB_AttachmentTypes.AttachmentTypeID = @intAttachmentTypeID)



RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteCategory
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteCategory (
@intCategoryID int
) AS
SET NOCOUNT ON 

/* Deletes a category from the InstantKB_Categories table */

DELETE FROM InstantKB_Categories WHERE (InstantKB_Categories.CategoryID = @intCategoryID)

-- delete category roles

DELETE FROM InstantKB_CategoryRoles WHERE (InstantKB_CategoryRoles.CategoryID = @intCategoryID)

-- delete article relationships

DELETE FROM InstantKB_ArticleCategories WHERE (InstantKB_ArticleCategories.CategoryID = @intCategoryID)

-- reset articles

UPDATE InstantKB_Articles SET InstantKB_Articles.ArticleCategoryID = 0 WHERE (InstantKB_Articles.ArticleCategoryID = @intCategoryID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteCategoryRoles
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteCategoryRoles (
@intCategoryID int
)
AS
SET NOCOUNT ON 
/* Delete all roles associated to a specific category from the InstantKB_CategoriesRoles table */
DELETE FROM InstantKB_CategoryRoles WHERE (InstantKB_CategoryRoles.CategoryID = @intCategoryID)
GO
----------------------------------------------------
-- ikb_sp_DeleteDepartment
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteDepartment (
@intDepartmentID int
)
AS
SET NOCOUNT ON 

/* Deletes a department from the InstantKB_Departments table */

DELETE FROM InstantKB_Departments WHERE (InstantKB_Departments.DepartmentID = @intDepartmentID)

-- get default department identity
DECLARE @intDefaultDepartmentID int
SET @intDefaultDepartmentID = (SELECT TOP 1 DepartmentID FROM InstantKB_Departments WHERE IsDefault = 1)

IF (@intDefaultDepartmentID > 0)
BEGIN

	-- move users in this dept to the default dept
	UPDATE InstantKB_Users SET 
	PRimaryDeptID = @intDefaultDepartmentID
	WHERE PRimaryDeptID = @intDepartmentID

	-- update primary dept within InstantKB_UserDepartments
	UPDATE InstantKB_UserDepartments
	SET DepartmentID = @intDefaultDepartmentID
	WHERE DepartmentID = @intDepartmentID

END

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteExpiredArticleRead
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteExpiredArticleRead (
@strDateTime nvarchar(255)
)
AS

SET NOCOUNT ON 

/* Removes any expired article read information within the InstantKB_ArticleRead table */

DELETE FROM InstantKB_ArticleRead WHERE (InstantKB_ArticleRead.ArticleReadExpires <= @strDateTime)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteGlossaryTerm
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteGlossaryTerm (
@intGlossaryTermID int
) AS
SET NOCOUNT ON 

/* Deletes a glossary term from InstantKB_Glossary table */

DELETE FROM InstantKB_Glossary WHERE (InstantKB_Glossary.GlossaryTermID = @intGlossaryTermID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteLevel
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteLevel (
@intLevelID int
) AS
SET NOCOUNT ON 

/* Deletes a level from the InstantKB_Levels  table */

DELETE FROM InstantKB_Levels WHERE (InstantKB_Levels.LevelID = @intLevelID)

-- reset article table

UPDATE InstantKB_Articles SET ArticleLevelID = 0 WHERE InstantKB_Articles.ArticleLevelID = @intLevelID

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteNotifications
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteNotifications (
@intRelatedEntityID int,
@intNotificationType int
) 
AS

/* Delete a set of notifications from InstantKB_Notifications */

SET NOCOUNT ON 

DELETE FROM InstantKB_Notifications 
WHERE (RelatedEntityID = @intRelatedEntityID AND NotificationType = @intNotificationType)
GO
----------------------------------------------------
-- ikb_sp_DeletePermissionSet
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeletePermissionSet (
@intPermissionID int
)
AS
SET NOCOUNT ON 

/* Deletes a specific permission set from the InstantKB_PermissionSets table */
DELETE FROM InstantKB_PermissionSets WHERE (InstantKB_PermissionSets.PermissionID = @intPermissionID)

/* Delete all tab permission sets from InstantKB_PermissionSetsTabs */
DELETE FROM InstantKB_PermissionSetsTabs WHERE (InstantKB_PermissionSetsTabs.PermissionID = @intPermissionID)

/* Delete all role permission set relationships from InstantKB_PermissionSetsRoles */
DELETE FROM InstantKB_PermissionSetsRoles WHERE (InstantKB_PermissionSetsRoles.PermissionID = @intPermissionID)
GO
----------------------------------------------------
-- ikb_sp_DeletePermissionSetsRole
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeletePermissionSetsRole (
@intRoleID int
)
AS
SET NOCOUNT ON 
/* Delete a permission sets associations for a role from the InstantKB_PermissionSetsRoles table */
DELETE FROM InstantKB_PermissionSetsRoles WHERE (InstantKB_PermissionSetsRoles.RoleID = @intRoleID)
GO
----------------------------------------------------
-- ikb_sp_DeletePermissionSetsRoles
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeletePermissionSetsRoles
AS
SET NOCOUNT ON 
/* Delete a permission sets associations for all rolesfrom the InstantKB_PermissionSetsRoles table */
DELETE FROM InstantKB_PermissionSetsRoles
GO
----------------------------------------------------
-- ikb_sp_DeletePriority
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeletePriority (
@intPriorityID int
) AS
SET NOCOUNT ON 

/* Deletes a priority from the InstantKB_Priorities  table */

DELETE FROM InstantKB_Priorities WHERE (InstantKB_Priorities.PriorityID = @intPriorityID)

-- reset article table

UPDATE InstantKB_Articles SET ArticlePriorityID = 0 WHERE InstantKB_Articles.ArticlePriorityID = @intPriorityID

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteStaffPermissionSet
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteStaffPermissionSet (
@intPermissionID int
)
AS
SET NOCOUNT ON 
/* Deletes a specific permission set from the InstantKB_StaffPermissionSets table */
DELETE FROM InstantKB_StaffPermissionSets WHERE (InstantKB_StaffPermissionSets.PermissionID = @intPermissionID)

/* Delete tab permission sets from InstantKB_StaffPermissionSetsTabs */
DELETE FROM InstantKB_StaffPermissionSetsTabs WHERE (InstantKB_StaffPermissionSetsTabs.PermissionID = @intPermissionID)
GO
----------------------------------------------------
-- ikb_sp_DeleteStatus
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteStatus (
@intStatusID int
) AS
SET NOCOUNT ON 

/* Deletes a status from the InstantKB_Status  table */

DELETE FROM InstantKB_Status WHERE (InstantKB_Status.StatusID = @intStatusID)

-- reset article table

UPDATE InstantKB_Articles SET ArticleStatusID = 0 WHERE InstantKB_Articles.ArticleStatusID = @intStatusID

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteTab
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteTab (
@intTabID int,
@intMoveToTabID int,
@intApplicationID int
) AS
SET NOCOUNT ON 

/* Deletes a tab from the InstantKB_Tabs table */
DELETE FROM InstantKB_Tabs WHERE (InstantKB_Tabs.TabID = @intTabID)

/* Delete tab roles from InstantKB_TabRoles */
DELETE FROM InstantKB_TabRoles WHERE (InstantKB_TabRoles.TabID = @intTabID)

/* Delete fields for tab */
DELETE FROM InstantASP_Fields WHERE (InstantASP_Fields.ApplicationID = @intApplicationID AND InstantASP_Fields.TabID = @intTabID)

/* Delete field templates for tab */
DELETE FROM InstantASP_FieldTemplates WHERE (InstantASP_FieldTemplates.ApplicationID = @intApplicationID AND InstantASP_FieldTemplates.TabID = @intTabID)

/* Delete any categories belonging to this tab */
DELETE FROM InstantKB_Categories WHERE (TabID = @intTabID)

/* Clean tab;es */
DELETE FROM InstantKB_DataViews WHERE TabID = @intTabID
DELETE FROM InstantKB_PermissionSetsTabs WHERE TabID = @intTabID
DELETE FROM InstantKB_StaffPermissionSetsTabs WHERE TabID = @intTabID
DELETE FROM InstantKB_Levels WHERE LevelTabID = @intTabID
DELETE FROM InstantKB_Priorities WHERE PriorityTabID = @intTabID
DELETE FROM InstantKB_Status WHERE StatusTabID = @intTabID
DELETE FROM InstantKB_Types WHERE TypeTabID = @intTabID
DELETE FROM InstantKB_WorkFlows WHERE TabID = @intTabID

/* Do we have a new tab for content within the deleted tab */
IF (@intMoveToTabID > 0)
BEGIN

	-- ensure we are moving to a different tab
	IF (@intTabID <> @intMoveToTabID)
	BEGIN
		-- move content within tab to new tab
		EXEC ikb_sp_MoveArticlesBetweenTabs @intTabID, @intMoveToTabID
	END

END
ELSE
BEGIN

	-- we don't have a tab to move to simply delete all content
	DELETE FROM InstantKB_Articles WHERE (ArticleID = @intTabID)

END


RETURN
GO

----------------------------------------------------
-- ikb_sp_DeleteTabRole
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteTabRole (
@intTabID int,
@intRoleID int
) AS

SET NOCOUNT ON 

/* Deletes a specific role for a tab from the InstantKB_TabRoles table */

DELETE FROM InstantKB_TabRoles WHERE (InstantKB_TabRoles.TabID = @intTabID AND InstantKB_TabRoles.RoleID = @intRoleID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteTabRoles
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteTabRoles (
@intTabID int
) AS

SET NOCOUNT ON 

/* Deletes all the roles assocaited with a tab from the InstantKB_TabRoles table */

DELETE FROM InstantKB_TabRoles WHERE (InstantKB_TabRoles.TabID = @intTabID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteTroubleshooterStep
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteTroubleshooterStep (
@intStepID int
) AS
SET NOCOUNT ON 

/* Deletes a troubleshooter step from InstantKB_TroubleshooterSteps */

DELETE FROM InstantKB_TroubleshooterSteps WHERE (InstantKB_TroubleshooterSteps.StepID = @intStepID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteType
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteType (
@intTypeID int
) AS
SET NOCOUNT ON 

/* Deletes a type from the InstantKB_Types  table */

DELETE FROM InstantKB_Types WHERE (InstantKB_Types.TypeID = @intTypeID)

-- reset article table

UPDATE InstantKB_Articles SET ArticleTypeID = 0 WHERE InstantKB_Articles.ArticleTypeID = @intTypeID

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteUser
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteUser (
@intUserID int
)
AS

SET NOCOUNT ON 

/* Deletes a user from the InstantKB_Users table, role deletes are cascaded */

DELETE FROM InstantKB_Users WHERE (InstantKB_Users.UserID = @intUserID)

EXEC iasp_sp_DeleteUser @intUserID
GO
----------------------------------------------------
-- ikb_sp_DeleteUserDepartment
----------------------------------------------------
GO




CREATE PROCEDURE ikb_sp_DeleteUserDepartment (
@intUserID int,
@intDepartmentID int
) AS

SET NOCOUNT ON 

/* Deletes a user & role association from the InstantKB_UserDepartments table */

DELETE FROM InstantKB_UserDepartments  WHERE (UserID = @intUserID AND DepartmentID = @intDepartmentID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteUserDepartments
----------------------------------------------------
GO




CREATE PROCEDURE ikb_sp_DeleteUserDepartments (
@intUserID int
) AS

SET NOCOUNT ON 

/* Deletes all user & department association from the InstantKB_UserDepartments table */

DELETE FROM InstantKB_UserDepartments  WHERE (UserID = @intUserID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteUserLevel
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteUserLevel (
@intUserLevelID int
) AS
SET NOCOUNT ON 

/* Deletes a user level from the InstantKB_UserLevels  table */

DELETE FROM InstantKB_UserLevels WHERE (InstantKB_UserLevels.UserLevelID = @intUserLevelID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteView
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteView (
@intDataViewID int
) AS
SET NOCOUNT ON 

/* Deletes a tab from the InstantKB_DataViews */

DELETE FROM InstantKB_DataViews WHERE (InstantKB_DataViews.DataViewID = @intDataViewID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteWhosOnData
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteWhosOnData (
@strDateTime nvarchar(255)
)
AS
SET NOCOUNT ON 
/* Removes expired WhosOn data */
DELETE FROM InstantKB_WhosOn WHERE (InstantKB_WhosOn.Expires <= @strDateTime) 
RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteWorkFlow
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteWorkFlow(
@intWorkFlowID int
) AS
SET NOCOUNT ON 

/* Deletes a workflow and related steps from InstantKB_WorkFlows and InstantKB_WorkFlowSteps */

-- delete workdlow
DELETE FROM InstantKB_WorkFlows WHERE (InstantKB_WorkFlows.WorkFlowID = @intWorkFlowID)

-- delete workflow steps
DELETE  FROM InstantKB_WorkFlowSteps WHERE (InstantKB_WorkFlowSteps.WorkFlowID = @intWorkFlowID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteWorkFlowDepartment
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteWorkFlowDepartment (
@intWorkFlowID int,
@intDepartmentID int
) AS

SET NOCOUNT ON 

/* Deletes a specific department for a workflow from InstantKB_WorkFlowDepartments table */

DELETE FROM InstantKB_WorkFlowDepartments WHERE (InstantKB_WorkFlowDepartments.WorkFlowID = @intWorkFlowID AND InstantKB_WorkFlowDepartments.DepartmentID = @intDepartmentID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteWorkFlowDepartments
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteWorkFlowDepartments (
@intWorkFlowID int
) AS

SET NOCOUNT ON 

/* Deletes all the departments associated with a workflow from the InstantKB_WorkFlowDepartments table */

DELETE FROM InstantKB_WorkFlowDepartments WHERE (InstantKB_WorkFlowDepartments.WorkFlowID = @intWorkFlowID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteWorkFlowStep
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteWorkFlowStep (
@intWorkFlowStepID int
) AS
SET NOCOUNT ON 

/* Deletes a workflow step from the InstantKB_WorkFlowSteps table */
DELETE FROM InstantKB_WorkFlowSteps WHERE (InstantKB_WorkFlowSteps.WorkFlowStepID = @intWorkFlowStepID)

-- reset article table

UPDATE InstantKB_Articles SET ArticleWorkflowStepID = 0 WHERE InstantKB_Articles.ArticleWorkflowStepID = @intWorkFlowStepID


RETURN
GO
----------------------------------------------------
-- ikb_sp_DeleteWorkFlowStepNextSteps
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_DeleteWorkFlowStepNextSteps (
@intWorkFlowStepID int
) AS

SET NOCOUNT ON 

/* Adds new next steps to a workflow step */

DELETE FROM InstantKB_WorkFlowStepsNextSteps WHERE (WorkFlowStepID = @intWorkFlowStepID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertArticleCategory
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertArticleCategory (
@intArticleID int,
@intCategoryID int
) AS

SET NOCOUNT ON 

/* Inserts a category relationship for an artcle */

IF NOT EXISTS (SELECT ArticleID FROM InstantKB_ArticleCategories WHERE (ArticleID = @intArticleID AND CategoryID = @intCategoryID))
BEGIN
	INSERT INTO InstantKB_ArticleCategories (ArticleID, CategoryID) VALUES (@intArticleID, @intCategoryID)
END

RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertArticleCommentRating
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertArticleCommentRating (
@intCommentID int,
@bolHelpful bit,
@intUserID int,
@strIPAddress nvarchar(255),
@intIdentity int output
)
AS

SET NOCOUNT ON 

DECLARE @intCommentRatingID int

IF (@intUserID > 0)
BEGIN
SET @intCommentRatingID = (SELECT TOP 1 CommentRatingID FROM InstantKB_ArticleCommentRatings WHERE (CommentID = @intCommentID) AND (UserID = @intUserID))
END
ELSE
BEGIN
SET @intCommentRatingID = (SELECT TOP 1 CommentRatingID FROM InstantKB_ArticleCommentRatings WHERE (CommentID = @intCommentID) AND (IPAddress = @strIPAddress))
END

SET @intCommentRatingID = IsNull(@intCommentRatingID,0)

-- check to see if user has already rated article
IF (@intCommentRatingID <> 0)
BEGIN

	UPDATE InstantKB_ArticleCommentRatings SET
	UserID = @intUserID,
	CommentID = @intCommentID,
	Helpful = @bolHelpful,
	IPAddress = @strIPAddress
	WHERE InstantKB_ArticleCommentRatings.CommentRatingID = @intCommentRatingID	
		
	-- set to new inserted identity	
	SET @intIdentity = 0

END
ELSE
BEGIN

	-- user has not previously rated article
	INSERT INTO InstantKB_ArticleCommentRatings (UserID, CommentID, Helpful, IPAddress) VALUES (@intUserID, @intCommentID, @bolHelpful, @strIPAddress)
	
	-- set to new inserted identity	
	SET @intIdentity = @@IDENTITY

END

-- update counts
EXEC ikb_sp_UpdateArticleCommentRating @intCommentID

GO
----------------------------------------------------
-- ikb_sp_InsertArticleRating
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertArticleRating (
@intArticleID int,
@intRating tinyint,
@intUserID int,
@strIPAddress nvarchar(255),
@intIdentity int output
)
AS

SET NOCOUNT ON 

DECLARE @intArticleRatingID int

IF (@intUserID > 0) 
BEGIN
SET @intArticleRatingID = (SELECT TOP 1 ArticleRatingID FROM InstantKB_ArticleRatings WHERE (ArticleID = @intArticleID AND UserID = @intUserID))
END
ELSE
BEGIN
SET @intArticleRatingID = (SELECT TOP 1 ArticleRatingID FROM InstantKB_ArticleRatings WHERE (ArticleID = @intArticleID AND IPAddress = @strIPAddress))
END


SET @intArticleRatingID = IsNull(@intArticleRatingID,0)

-- check to see if user has already rated article
IF (@intArticleRatingID <> 0)
BEGIN

	UPDATE InstantKB_ArticleRatings SET
	UserID = @intUserID,
	ArticleID = @intArticleID,
	ArticleRating = @intRating,
	IPAddress = @strIPAddress
	WHERE InstantKB_ArticleRatings.ArticleRatingID = @intArticleRatingID	
		
	-- set to new inserted identity	
	SET @intIdentity = 0

END
ELSE
BEGIN

	-- user has not previously rated article
	INSERT INTO InstantKB_ArticleRatings (UserID, ArticleID, ArticleRating, IPAddress) VALUES (@intUserID, @intArticleID, @intRating, @strIPAddress)
	
	-- set to new inserted identity	
	SET @intIdentity = @@IDENTITY

END

-- update articles table with mean number
EXEC ikb_sp_UpdateArticleRatingMeanNumber @intArticleID

GO
----------------------------------------------------
-- ikb_sp_InsertArticleRead
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertArticleRead (
@intArticleID int,
@intUserID int,
@dtArticleReadExpires datetime
)
AS
SET NOCOUNT ON 

/* Remove any old view data we may have for this user and article */
DELETE FROM InstantKB_ArticleRead WHERE (InstantKB_ArticleRead.ArticleReadArticleID = @intArticleID AND InstantKB_ArticleRead.ArticleReadUserID = @intUserID)

/* Add new read data to table */
INSERT INTO InstantKB_ArticleRead (ArticleReadArticleID, ArticleReadUserID, ArticleReadDate, ArticleReadExpires) VALUES (@intArticleID, @intUserID, GetDate(), @dtArticleReadExpires)

GO 
----------------------------------------------------
-- ikb_sp_InsertArticleRole
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertArticleRole (
@intArticleID int,
@intRoleID int
) AS

SET NOCOUNT ON 

/* Inserts a role relationship for an artcle */

INSERT INTO InstantKB_ArticleRoles (ArticleID, RoleID) VALUES (@intArticleID, @intRoleID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertAttachment
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertAttachment (
@intUserID int,
@intRelatedEntityID int,
@intAttachmentType tinyint,
@strFileName nvarchar(255),
@strDisplayFileName nvarchar(255),
@strContentType nvarchar(100),
@intContentLength int,
@binPostedFile image, 
@intIdentity int output
)
AS

SET NOCOUNT ON 

/* Inserts a new attachment into InstantKB_Attachments */

INSERT INTO InstantKB_Attachments (UserID, RelatedEntityID, AttachmentType, [Filename], DisplayFileName, ContentType, ContentLength, AttachmentBLOB) VALUES
(@intUserID, @intRelatedEntityID, @intAttachmentType, @strFileName, @strDisplayFileName, @strContentType, @intContentLength, @binPostedFile)

-- return the new identity

SET @intIdentity = @@IDENTITY

RETURN

GO
----------------------------------------------------
-- ikb_sp_InsertCategoryRole
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertCategoryRole (
@intCategoryID int,
@intRoleID int,
@intPermissionID int
)
AS
SET NOCOUNT ON 
/* Inserts a new relationship into the InstantKB_CategoriesRoles table to link a category to a specific user role */
INSERT INTO InstantKB_CategoryRoles (CategoryID, RoleID, PermissionID) VALUES (@intCategoryID, @intRoleID, @intPermissionID)
GO
----------------------------------------------------
-- ikb_sp_InsertCustomFieldColumn
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertCustomFieldColumn (
@intFieldType int,
@intContentType int,
@intTableFieldName nvarchar(255)
) AS

SET NOCOUNT ON 

DECLARE @strSQL nvarchar(255)

-- set the table we need to update based on the content type
DECLARE @strCustomFieldTable nvarchar(255)
SET @strCustomFieldTable = 'InstantKB_ArticleCustomFields' -- articles
IF (@intContentType = 4) -- tickets
	SET @strCustomFieldTable = 'InstantKB_TicketCustomFields'
IF (@intContentType = 5) -- users
	SET @strCustomFieldTable = 'InstantKB_UserCustomFields'
IF (@intContentType = 6) -- feedback form
	SET @strCustomFieldTable = 'InstantKB_FeedbackCustomFields'

-- set the column data type depending on the field type
DECLARE @strDataType nvarchar(255)
SET @strDataType = 'nvarchar(255)'

-- build the SQL
SET @strSQL = 'ALTER TABLE ' + @strCustomFieldTable + ' ADD ' + @intTableFieldName + ' ' + @strDataType

-- execute the alter statement
EXECUTE sp_executesql @strSQL

RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertPermissionSetRole
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertPermissionSetRole (
@intPermissionID int,
@intRoleID int
)
AS
SET NOCOUNT ON 
/* Inserts a new relationship into the InstantKB_PermissionSetsRoles table to link a permission set to a specific role */
INSERT INTO InstantKB_PermissionSetsRoles (PermissionID, RoleID) VALUES (@intPermissionID, @intRoleID)
GO
----------------------------------------------------
-- ikb_sp_InsertTabRole
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertTabRole (
@intTabID int,
@intRoleID int
) AS

SET NOCOUNT ON 

/* Inserts a specific role for a tab from the InstantKB_TabRoles table */

INSERT INTO InstantKB_TabRoles (TabID, RoleID) VALUES (@intTabID, @intRoleID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateArticle
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateArticle (
@intArticleID int,
@intArticleParentID int,
@intArticleCategoryID int,
@strArticleTitle nvarchar(500),
@strArticleText ntext,
@intArticlePercentComplete int,
@intArticleTypeID int,
@intArticleLevelID int,
@intArticleStatusID int,
@intArticlePriorityID int,
@intArticleAccessType tinyint,
@intArticleWorkFlowStepID int,
@intArticleCreatedUserID int,
@intArticleModifiedUserID int,
@intArticleAssignedUserID int,
@dtArticleAssignedDate datetime,
@intArticleSuggestedUserID int,
@strArticleSuggestedUsername nvarchar(255),
@strArticleSuggestedEmail nvarchar(255),
@dtArticleSuggestedDate datetime,
@intArticleReportedUserID int,
@dtArticleReportedDate datetime,
@dtArticleDueDate datetime,
@dtArticleReviewDate datetime,
@dtArticleExpiresDate datetime,
@intTabID int,
@strArticleTitleEncoded nvarchar(500),
@strArticleDownloadFile nvarchar(255),
@strArticleDownloadLink nvarchar(255),
@strArticleDownloadPassword nvarchar(255),
@bolUpdateLastModified bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a article within the InstantKB_Articles table */

-- setup variables to hold usernames obtained from identities

DECLARE @dtArticleModifiedDate datetime
DECLARE @strArticleModifiedUsername nvarchar(255)

DECLARE @strArticleCreatedUsername nvarchar(255)
DECLARE @strArticleAssignedUsername nvarchar(255)
DECLARE @strArticleReportedUsername nvarchar(255)

SET @strArticleCreatedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleCreatedUserID))
SET @strArticleAssignedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleAssignedUserID))
SET @strArticleReportedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleReportedUserID))
SET @strArticleModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleModifiedUserID))
SET @dtArticleModifiedDate = GetDate()

-- is this an update or insert?
IF (@intArticleID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Articles 
		(ArticleParentID, 
		ArticleCategoryID,
		ArticleTitle, 
		ArticleTitleEncoded,
		ArticleText, 
		ArticlePercentComplete, 
		ArticleTypeID, 
		ArticleLevelID, 
		ArticleStatusID, 
		ArticlePriorityID, 
		ArticleAccessType, 
		ArticleWorkFlowStepID, 
		ArticleCreatedUserID, 
		ArticleCreatedUsername, 
		ArticleCreatedDate, 
		ArticleModifiedUserID, 
		ArticleModifiedUsername,
		ArticleModifiedDate,
		ArticleAssignedUserID,
		ArticleAssignedUsername,
		ArticleAssignedDate,
		ArticleSuggestedUserID,
		ArticleSuggestedUsername,
		ArticleSuggestedEmail,
		ArticleSuggestedDate,
		ArticleReportedUserID,
		ArticleReportedUsername,
		ArticleReportedDate,
		ArticleDueDate,
		ArticleReviewDate,
		ArticleExpiresDate,
		TabID,
		ArticleDownloadFile,
		ArticleDownloadLink, 
		ArticleDownloadPassword)
	VALUES 
		(@intArticleParentID,
		@intArticleCategoryID,
		@strArticleTitle,
		@strArticleTitleEncoded,
		@strArticleText,
		@intArticlePercentComplete,
		@intArticleTypeID,
		@intArticleLevelID,
		@intArticleStatusID,
		@intArticlePriorityID,
		@intArticleAccessType,
		@intArticleWorkFlowStepID,
		@intArticleCreatedUserID,
		IsNull(@strArticleCreatedUsername,''),
		GetDate(),
		@intArticleModifiedUserID,
		IsNull(@strArticleModifiedUsername,''),
		GetDate(),		
		@intArticleAssignedUserID,
		IsNull(@strArticleAssignedUsername,''),
		@dtArticleAssignedDate,
		@intArticleSuggestedUserID,
		@strArticleSuggestedUsername,
		@strArticleSuggestedEmail,
		@dtArticleSuggestedDate,
		@intArticleReportedUserID,
		IsNull(@strArticleReportedUsername,''),
		@dtArticleReportedDate,
		@dtArticleDueDate,
		@dtArticleReviewDate,
		@dtArticleExpiresDate,
		@intTabID,
		@strArticleDownloadFile,
		@strArticleDownloadLink,
		@strArticleDownloadPassword)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update modified by?
	IF (@bolUpdateLastModified = 0)
	BEGIN
		SET @dtArticleModifiedDate = (SELECT ArticleModifiedDate FROM InstantKB_Articles WHERE ArticleID = @intArticleID)
		SET @intArticleModifiedUserID = (SELECT ArticleModifiedUserID FROM InstantKB_Articles WHERE ArticleID = @intArticleID)
		SET @intArticleModifiedUserID = (SELECT ArticleModifiedUserID FROM InstantKB_Articles WHERE ArticleID = @intArticleID)
	END

	-- update
	UPDATE InstantKB_Articles SET
	ArticleParentID = @intArticleParentID, 
	ArticleCategoryID = @intArticleCategoryID,
	ArticleTitle = @strArticleTitle, 
	ArticleTitleEncoded = @strArticleTitleEncoded,
	ArticleText = @strArticleText, 
	ArticlePercentComplete = @intArticlePercentComplete, 
	ArticleTypeID = @intArticleTypeID, 
	ArticleLevelID = @intArticleLevelID, 
	ArticleStatusID = @intArticleStatusID, 
	ArticlePriorityID = @intArticlePriorityID, 
	ArticleAccessType = @intArticleAccessType,
	ArticleWorkFlowStepID = @intArticleWorkFlowStepID, 
	ArticleModifiedUserID = @intArticleModifiedUserID, 
	ArticleModifiedUsername = IsNull(@strArticleModifiedUsername,''),
	ArticleModifiedDate = @dtArticleModifiedDate,
	ArticleAssignedUserID = @intArticleAssignedUserID,
	ArticleAssignedUsername = IsNull(@strArticleAssignedUsername,''),
	ArticleAssignedDate = @dtArticleAssignedDate,
	ArticleSuggestedUserID = @intArticleSuggestedUserID,
	ArticleSuggestedUsername = @strArticleSuggestedUsername,
	ArticleSuggestedEmail = @strArticleSuggestedEmail,
	ArticleSuggestedDate = @dtArticleSuggestedDate,
	ArticleReportedUserID = @intArticleReportedUserID,
	ArticleReportedUsername = IsNull(@strArticleReportedUsername,''),
	ArticleReportedDate = @dtArticleReportedDate,
	ArticleDueDate = @dtArticleDueDate,
	ArticleReviewDate = @dtArticleReviewDate,
	ArticleExpiresDate = @dtArticleExpiresDate,
	TabID = @intTabID,
	ArticleDownloadFile = @strArticleDownloadFile,
	ArticleDownloadLink = @strArticleDownloadLink,
	ArticleDownloadPassword = @strArticleDownloadPassword
	WHERE InstantKB_Articles.ArticleID = @intArticleID

	-- return the identity
	SET @intIdentity = @intArticleID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateArticleComment
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateArticleComment (
@intCommentID int,
@intUserID int,
@strUsername nvarchar(255),
@strEmailAddress nvarchar(255),
@strWebAddress nvarchar(255),
@intArticleID int,
@strComments ntext,
@intAccessType tinyint,
@intLastModifiedByUserID int,
@strLastModifiedByUsername nvarchar(255),
@intIdentity int output
)
AS
SET NOCOUNT ON 

IF (@intCommentID = 0)
BEGIN

	/* Insert comment into InstantKB_ArticleComments */
	INSERT INTO InstantKB_ArticleComments ( UserID, Username,  EmailAddress, WebAddress, ArticleID, Comments, AccessType, LastModifiedByUserID, LastModifiedByUsername, LastModifiedDateStamp, DateStamp) 
	VALUES (@intUserID, @strUsername, @strEmailAddress, @strWebAddress, @intArticleID, @strComments, @intAccessType, @intLastModifiedByUserID, @strLastModifiedByUsername, GetDate(), GetDate())

	-- set return identity
	SET @intIdentity = @@IDENTITY

END
ELSE
BEGIN

	UPDATE InstantKB_ArticleComments SET
	UserID = @intUserID,
	Username = @strUsername,
	EmailAddress = @strEmailAddress,
	WebAddress = @strWebAddress,
	ArticleID = @intArticleID,
	Comments = @strComments,
	AccessType = @intAccessType,
	LastModifiedByUserID = @intLastModifiedByUserID,
	LastModifiedByUsername = @strLastModifiedByUsername,
	LastModifiedDateStamp = GetDate()
	WHERE (InstantKB_ArticleComments.CommentID = @intCommentID)

	-- set return identity
	SET @intIdentity = @intCommentID
	
END


-- update article to indicate comments
DECLARE @intTotalComments int
SET @intTotalComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE InstantKB_ArticleComments.ArticleID = @intArticleID AND AccessType = 1)
UPDATE InstantKB_Articles SET InstantKB_Articles.CommentCount = @intTotalComments WHERE (InstantKB_Articles.ArticleID = @intArticleID)


RETURN @intIdentity
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateArticleRelatedLink
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateArticleRelatedLink (
@intArticleRelatedLinkID int,
@intArticleID int,
@strRedirectURL nvarchar(255),
@strDescription nvarchar(255),
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a article related link within InstantKB_ArticleRelatedLinks table */

-- is this an update or insert?
IF (@intArticleRelatedLinkID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_ArticleRelatedLinks (ArticleID,RedirectURL, ViewCount, [Description]) 
	VALUES (@intArticleID, @strRedirectURL, 0, @strDescription)

	-- increment related link count in articles table
	UPDATE InstantKB_Articles SET RelatedLinkCount = RelatedLinkCount + 1 WHERE (ArticleID = @intArticleID)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_ArticleRelatedLinks SET
	ArticleID = @intArticleID,
	RedirectURL = @strRedirectURL,
	[Description] = @strDescription
	WHERE InstantKB_ArticleRelatedLinks.ArticleRelatedLinkID = @intArticleRelatedLinkID

	-- return the identity
	SET @intIdentity = @intArticleRelatedLinkID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateAttachmentType
----------------------------------------------------
GO

CREATE PROCEDURE ikb_sp_InsertUpdateAttachmentType (
@intAttachmentTypeID int, 
@intTabID int,
@strExtension nvarchar(15), 
@strIcon nvarchar(100),
@intIdentity int output
)
AS

SET NOCOUNT ON 

/* Inserts a new attachment type or updates an existing attachment type within the InstantKB_AttachmentTypes table */

IF (@intAttachmentTypeID = 0) -- we are inserting a new forum
BEGIN

	-- add new attachment type	
	INSERT INTO InstantKB_AttachmentTypes (TabID, Extension, Icon)
	 VALUES (@intTabID, @strExtension, @strIcon)

	-- set the output parameter to the new attachment type identity
	SET @intIdentity = @@IDENTITY
	
END
ELSE -- we are updating an existing attachment type
BEGIN 
	
	-- update existing forum
	UPDATE InstantKB_AttachmentTypes SET
	TabID = @intTabID,
	Extension = @strExtension,
	Icon = @strIcon
	WHERE InstantKB_AttachmentTypes.AttachmentTypeID = @intAttachmentTypeID

	-- update output parameter to indicate this was a success
	SET @intIdentity = @intAttachmentTypeID

END
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateCategory
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateCategory (
@intCategoryID int,
@intCategoryParentID int,
@intTabID int,
@intDataViewID int,
@strCategoryName nvarchar(255),
@strCategoryDescription ntext,
@intCategorySortOrder int,
@strCategoryIcon nvarchar(255),
@bolCategoryExpanded bit,
@intUserID int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a category within InstantKB_Categories */

-- is this an update or insert?
IF (@intCategoryID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Categories (CategoryParentID, TabID, DataViewID, CategoryName, CategoryDescription, CategorySortOrder, CategoryIcon, CategoryExpanded, UserID, DateStamp) 
	VALUES (@intCategoryParentID,@intTabID, @intDataViewID, @strCategoryName, @strCategoryDescription, @intCategorySortOrder, @strCategoryIcon, @bolCategoryExpanded, @intUserID, GetDate())

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Categories SET
	CategoryParentID = @intCategoryParentID,
	TabID = @intTabID,
	DataViewID = @intDataViewID,
	CategoryName = @strCategoryName,
	CategoryDescription = @strCategoryDescription,
	CategorySortOrder = @intCategorySortOrder,
	CategoryIcon = @strCategoryIcon,
	CategoryExpanded = @bolCategoryExpanded,
	UserID = @intUserID,
	DateStamp = GetDate()
	WHERE InstantKB_Categories.CategoryID = @intCategoryID

	-- return the identity
	SET @intIdentity = @intCategoryID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateDepartment
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateDepartment (
@intDepartmentID int,
@strDepartmentName nvarchar(255),
@intPermissionID int,
@intAccessType tinyint,
@intSortOrder int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a department within InstantKB_Departments */

-- is this an update or insert?
IF (@intDepartmentID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Departments (DepartmentName, PermissionID, AccessType, SortOrder) 
	VALUES (@strDepartmentName, @intPermissionID, @intAccessType, @intSortOrder)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Departments SET
	DepartmentName = @strDepartmentName,
	PermissionID = @intPermissionID,
	AccessType = @intAccessType,
	SortOrder = @intSortOrder
	WHERE InstantKB_Departments.DepartmentID = @intDepartmentID

	-- return the identity
	SET @intIdentity = @intDepartmentID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateGlossaryTerm
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateGlossaryTerm (
@intGlossaryTermID int,
@strGlossaryTerm nvarchar(255),
@strGlossaryTermDesc ntext,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a glossary term within InstantKB_Glossary table */

-- is this an update or insert?
IF (@intGlossaryTermID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Glossary (GlossaryTerm, GlossaryTermDesc) VALUES (@strGlossaryTerm, @strGlossaryTermDesc)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Glossary SET
	GlossaryTerm = @strGlossaryTerm,
	GlossaryTermDesc = @strGlossaryTermDesc
	WHERE InstantKB_Glossary.GlossaryTermID = @intGlossaryTermID

	-- return the identity
	SET @intIdentity = @intGlossaryTermID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateLevel
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateLevel (
@intLevelID int,
@strLevelName nvarchar(255),
@intLevelSortOrder int,
@intLevelAccessType tinyint,
@intLevelTabID int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a level within InstantKB_Levels table */

-- is this an update or insert?
IF (@intLevelID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Levels (LevelName, LevelSortOrder,LevelAccessType, LevelTabID) 
	VALUES (@strLevelName, @intLevelSortOrder, @intLevelAccessType, @intLevelTabID)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Levels SET
	LevelName = @strLevelName,
	LevelSortOrder = @intLevelSortOrder,
	LevelAccessType = @intLevelAccessType,
	LevelTabID = @intLevelTabID
	WHERE InstantKB_Levels.LevelID = @intLevelID

	-- return the identity
	SET @intIdentity = @intLevelID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateNotification
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateNotification (
@intNotificationID int,
@intRelatedEntityID int,
@intUserID int,
@strNotificationEmailAddress nvarchar(255),
@intNotificationType int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a notification within InstantKB_Notifications  */

-- is this an update or insert?
IF (@intNotificationID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Notifications (RelatedEntityID, UserID, NotificationEmailAddress, NotificationType, DateStamp)
	VALUES (@intRelatedEntityID, @intUserID, @strNotificationEmailAddress, @intNotificationType, GetDate())

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Notifications SET
	RelatedEntityID = @intRelatedEntityID,
	UserID = @intUserID,
	NotificationEmailAddress = @strNotificationEmailAddress,
	NotificationType = @intNotificationType,
	DateStamp = GetDate()
	WHERE InstantKB_Notifications.NotificationID = @intNotificationID

	-- return the identity
	SET @intIdentity = @intNotificationID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdatePermissionSet
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdatePermissionSet (
@intPermissionID int,
@strPermissionName nvarchar(255),
@strSettingsXML ntext,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a permission set within InstantKB_StaffPermissionSets */

-- is this an update or insert?
IF (@intPermissionID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_PermissionSets (PermissionName, SettingsXML, DateStamp) 
	VALUES (@strPermissionName, @strSettingsXML, GetDate())

	-- return the  new identity
	SET @intIdentity = @@IDENTITY

	-- add tab permissions
	DECLARE @intTabID int
	DECLARE MSGCURSOR1 CURSOR FOR SELECT TabID FROM InstantKB_Tabs 
		
	OPEN MSGCURSOR1
		
	FETCH NEXT FROM MSGCURSOR1
	INTO @intTabID
		
	WHILE @@FETCH_STATUS = 0
	BEGIN
						
		INSERT INTO InstantKB_PermissionSetsTabs (PermissionID, TabID) VALUES (@intIdentity, @intTabID)
				
		FETCH NEXT FROM MSGCURSOR1
		INTO @intTabID
	
	END
		
	CLOSE MSGCURSOR1
	DEALLOCATE MSGCURSOR1

	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_PermissionSets SET
	PermissionName = @strPermissionName,
	SettingsXML = @strSettingsXML,
	DateStamp = GetDate()
	WHERE InstantKB_PermissionSets.PermissionID = @intPermissionID

	-- return the identity
	SET @intIdentity = @intPermissionID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdatePriority
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdatePriority (
@intPriorityID int,
@strPriorityName nvarchar(255),
@strPriorityForegroundColor nvarchar(50),
@strPriorityBackgroundColor nvarchar(50),
@intPrioritySortOrder int,
@intPriorityAccessType tinyint,
@intPriorityTabID int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a priority within InstantKB_Priority table */

-- is this an update or insert?
IF (@intPriorityID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Priorities (PriorityName, PriorityForegroundColor, PriorityBackgroundColor, PrioritySortOrder, PriorityAccessType, PriorityTabID) 
	VALUES (@strPriorityName, @strPriorityForegroundColor, @strPriorityBackgroundColor, @intPrioritySortOrder, @intPriorityAccessType, @intPriorityTabID)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Priorities SET
	PriorityName = @strPriorityName,
	PriorityForegroundColor = @strPriorityForegroundColor,
	PriorityBackgroundColor = @strPriorityBackgroundColor,
	PrioritySortOrder = @intPrioritySortOrder,
	PriorityAccessType = @intPriorityAccessType,
	PriorityTabID = @intPriorityTabID
	WHERE InstantKB_Priorities.PriorityID = @intPriorityID

	-- return the identity
	SET @intIdentity = @intPriorityID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateSettings
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateSettings (
@intSettingID int,
@strSettingsXML ntext,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a setting within InstantASP_Settings */

-- is this an update or insert?
IF (@intSettingID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Settings (SettingsXML) 
	VALUES (@strSettingsXML)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Settings SET
	SettingsXML = @strSettingsXML
	WHERE InstantKB_Settings.SettingID = @intSettingID

	-- return the identity
	SET @intIdentity = @intSettingID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateStaffPermissionSet
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateStaffPermissionSet (
@intPermissionID int,
@strPermissionName nvarchar(255),
@strSettingsXML ntext,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a staff permission set within InstantKB_StaffPermissionSets */

-- is this an update or insert?
IF (@intPermissionID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_StaffPermissionSets (PermissionName, SettingsXML, DateStamp) 
	VALUES (@strPermissionName, @strSettingsXML, GetDate())
	
	-- add entry to InstantKB_StaffPermissionSetsTabs 
	INSERT INTO InstantKB_StaffPermissionSetsTabs (PermissionID, TabID)
	SELECT @@IDENTITY AS PermissionID, TabID FROM InstantKB_Tabs

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_StaffPermissionSets SET
	PermissionName = @strPermissionName,
	SettingsXML = @strSettingsXML,
	DateStamp = GetDate()
	WHERE InstantKB_StaffPermissionSets.PermissionID = @intPermissionID

	-- return the identity
	SET @intIdentity = @intPermissionID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateStaffTabPermissionSet
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateStaffTabPermissionSet (
@intStaffPermissionSetsTabsID int,
@intPermissionID int,
@intTabID int,
@strSettingsXML ntext,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a staff tab permission set within InstantKB_StaffPermissionSetsTabs */

-- is this an update or insert?
IF (@intPermissionID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_StaffPermissionSetsTabs (PermissionID, TabID, SettingsXML) 
	VALUES (@intPermissionID, @intTabID, @strSettingsXML)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_StaffPermissionSetsTabs SET
	PermissionID = @intPermissionID,
	TabID = @intTabID,
	SettingsXML = @strSettingsXML
	WHERE InstantKB_StaffPermissionSetsTabs.StaffPermissionSetsTabsID = @intStaffPermissionSetsTabsID

	-- return the identity
	SET @intIdentity = @intStaffPermissionSetsTabsID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateStatus
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateStatus(
@intStatusID int,
@strStatusName nvarchar(255),
@strStatusForegroundColor nvarchar(50),
@strStatusBackgroundColor nvarchar(50),
@intStatusSortOrder int,
@intStatusAccessType tinyint,
@intStatusTabID int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a status within InstantKB_Status table */

-- is this an update or insert?
IF (@intStatusID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Status (StatusName, StatusForegroundColor, StatusBackgroundColor, StatusSortOrder, StatusAccessType, StatusTabID) 
	VALUES (@strStatusName, @strStatusForegroundColor, @strStatusBackgroundColor, @intStatusSortOrder, @intStatusAccessType, @intStatusTabID)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Status SET
	StatusName = @strStatusName,
	StatusForegroundColor = @strStatusForegroundColor,
	StatusBackgroundColor = @strStatusBackgroundColor,
	StatusSortOrder = @intStatusSortOrder,
	StatusAccessType = @intStatusAccessType,
	StatusTabID = @intStatusTabID
	WHERE InstantKB_Status.StatusID = @intStatusID

	-- return the identity
	SET @intIdentity = @intStatusID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateTab
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateTab (
@intTabID int,
@strTabLabel nvarchar(255),
@strTabLabelNonLocalized nvarchar(255),
@strTabToolTip nvarchar(255),
@strTabToolTipNonLocalized nvarchar(255),
@strTabRedirectURL nvarchar(255),
@intFieldTemplateID int,
@bolIsCustomTab bit,
@intSortOrder int,
@intTabContentType tinyint,
@strTabIcon nvarchar(255),
@strTabContentTypeNameNonLocalized nvarchar(255),
@bolDupeExistingFields bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a custom tab into the InstantKB_Tabs table */

-- is this an update or insert?
IF (@intTabID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Tabs (TabLabel, TabLabelNonLocalized, TabTooltip, TabTooltipNonLocalized, TabRedirectURL, FieldTemplateID, IsCustomTab, SortOrder, TabContentType, TabIcon, TabContentTypeNameNonLocalized) VALUES
	(@strTabLabel, @strTabLabelNonLocalized, @strTabToolTip, @strTabToolTipNonLocalized, @strTabRedirectURL,@intFieldTemplateID, @bolIsCustomTab, @intSortOrder, @intTabContentType, @strTabIcon, @strTabContentTypeNameNonLocalized)

		-- return the  new identity
	SET @intIdentity = @@IDENTITY

	-- if we are creating a tab that will host content then we need to duplicate the existing tabs matching the new tabs content tab
	IF (@bolDupeExistingFields = 1)
	BEGIN

		-- get the default tab identity we'll be cloning
		DECLARE @intDefaultTabID int
		SET @intDefaultTabID = (SELECT TabID FROM InstantKB_Tabs WHERE (InstantKB_Tabs.TabContentType = @intTabContentType AND InstantKB_Tabs.IsCustomTab = 0))

		-- clone fields for new tab
		INSERT INTO InstantASP_Fields (ApplicationID, TabID, FieldLabel, FieldLabelNonLocalized, FieldDescLabel, FieldDescLabelNonLocalized, 
		TableFieldName, FieldType, PickListID, StringSize, [Format], RegExValidation, SortOrder, IsVisible, IsEnabled, IsRequired, IsCustomField, IsUserEditable) 
		(SELECT ApplicationID, @intIdentity AS TabID, FieldLabel, FieldLabelNonLocalized, FieldDescLabel, FieldDescLabelNonLocalized, 
		TableFieldName, FieldType, PickListID, StringSize,  [Format], RegExValidation, SortOrder, IsVisible, IsEnabled, IsRequired, IsCustomField, IsUserEditable
		FROM InstantASP_Fields WHERE ApplicationID = 2  AND IsCustomField = 0 AND TabID = @intDefaultTabID)

		-- add user permission sets for tab
		INSERT INTO InstantKB_PermissionSetsTabs (PermissionID, TabID)
		SELECT PermissionID, @intIdentity FROM InstantKB_PermissionSets
		
		-- add staff permission sets for tab
		INSERT INTO InstantKB_StaffPermissionSetsTabs (PermissionID, TabID)
		SELECT PermissionID, @intIdentity FROM InstantKB_StaffPermissionSets

		-- view are not required
		DECLARE @bolIsRequired bit; SET @bolIsRequired = 1

		-- date stamp for view
		DECLARE @dtDateStamp datetime; SET @dtDateStamp = GetDate()

		-- clone default views
		INSERT INTO InstantKB_DataViews (UserID, TabID, [Name], [Description], [Columns], SortBy, SortOrder, PageSize, AccessType, DataViewType, IsRequired, DateStamp) 
		(SELECT UserID, @intIdentity AS TabID, [Name], [Description], [Columns], SortBy, SortOrder, PageSize, AccessType, DataViewType, @bolIsRequired As IsRequired, @dtDateStamp As DateStamp FROM InstantKB_DataViews
		WHERE (InstantKB_DataViews.TabID = @intDefaultTabID and UserID = 0 AND IsRequired = 1))

		-- clone default statues
		INSERT INTO InstantKB_Status (StatusTabID, StatusName, StatusSortOrder, StatusForegroundColor, StatusBackgroundColor, StatusImage, StatusAccessType) 
		SELECT @intIdentity AS StatusTabID, StatusName, StatusSortOrder, StatusForegroundColor, StatusBackgroundColor, StatusImage, StatusAccessType FROM InstantKB_Status 
		WHERE (InstantKB_Status.StatusTabID = @intDefaultTabID)
		
		-- clone default priorities
		INSERT INTO InstantKB_Priorities (PriorityTabID, PriorityName, PrioritySortOrder, PriorityForegroundColor, PriorityBackgroundColor, PriorityImage, PriorityAccessType)
		SELECT @intIdentity AS PriorityTabID, PriorityName, PrioritySortOrder, PriorityForegroundColor, PriorityBackgroundColor, PriorityImage, PriorityAccessType FROM InstantKB_Priorities
		WHERE (InstantKB_Priorities.PriorityTabID = @intDefaultTabID)

		-- clone default levels
		INSERT INTO InstantKB_Levels (LevelTabID, LevelName, LevelSortOrder, LevelAccessType)
		SELECT @intIdentity AS LevelTabID, LevelName, LevelSortOrder, LevelAccessType FROM InstantKB_Levels
		WHERE (InstantKB_Levels.LevelID = @intDefaultTabID)

		-- close default types
		INSERT INTO InstantKB_Types (TypeTabID, TypeName, TypeIcon, TypeSortOrder)
		SELECT @intIdentity AS TypeTabID, TypeName, TypeIcon, TypeSortOrder FROM InstantKB_Types
		WHERE (InstantKB_Types.TypeTabID = @intDefaultTabID)

		-- clone attachment types
		INSERT INTO InstantKB_ATtachmentTypes (TabID, Extension, Icon)
		SELECT @intIdentity AS TabID,  Extension, Icon FROM InstantKB_ATtachmentTypes
		WHERE (InstantKB_ATtachmentTypes.TabID = @intDefaultTabID)


	END		

	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Tabs SET
	TabLabel = @strTabLabel,
	TabLabelNonLocalized = @strTabLabelNonLocalized,
	TabTooltip = @strTabToolTip,
	TabTooltipNonLocalized = @strTabToolTipNonLocalized,
	TabRedirectURL = @strTabRedirectURL,
	FieldTemplateID = @intFieldTemplateID,
	IsCustomTab = @bolIsCustomTab,
	TabContentType = @intTabContentType,
	TabIcon = @strTabIcon,
	TabContentTypeNameNonLocalized = @strTabContentTypeNameNonLocalized,
	SortOrder = @intSortOrder
	WHERE InstantKB_Tabs.TabID = @intTabID

	-- return the identity
	SET @intIdentity = @intTabID
	RETURN

END

RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateTabPermissionSet
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateTabPermissionSet (
@intPermissionSetsTabsID int,
@intPermissionID int,
@intTabID int,
@strSettingsXML ntext,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a tab permission set within InstantKB_PermissionSetsTabs */

-- is this an update or insert?
IF (@intPermissionID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_PermissionSetsTabs (PermissionID, TabID, SettingsXML) 
	VALUES (@intPermissionID, @intTabID, @strSettingsXML)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_PermissionSetsTabs SET
	PermissionID = @intPermissionID,
	TabID = @intTabID,
	SettingsXML = @strSettingsXML
	WHERE InstantKB_PermissionSetsTabs.PermissionSetsTabsID = @intPermissionSetsTabsID

	-- return the identity
	SET @intIdentity = @intPermissionSetsTabsID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateTroubleshooterStep
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateTroubleshooterStep (
@intStepID int,
@intParentStepID int,
@intArticleID int,
@strTitle nvarchar(255),
@strText ntext,
@intUserID int,
@intSortOrder int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a troubleshooter step within InstantKB_TroubleshooterSteps */

-- is this an update or insert?
IF (@intStepID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_TroubleshooterSteps (ParentStepID, ArticleID, Title, Text, UserID, DateStamp, SortOrder) 
	VALUES (@intParentStepID, @intArticleID, @strTitle, @strText, @intUserID, GetDate(), @intSortOrder)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating
BEGIN

	UPDATE InstantKB_TroubleShooterSteps SET
	ParentStepID = @intParentStepID,
	ArticleID = @intArticleID,
	Title = @strTitle,
	Text = @strText,
	UserID = @intUserID,
	DateStamp = GetDate(),
	SortOrder = @intSortOrder
	WHERE InstantKB_TroubleShooterSteps.StepID = @intStepID
	
		-- return the identity
	SET @intIdentity = @intStepID

END

-- get username
DECLARE @strUsername nvarchar(255)
SET @strUsername = (SELECT Username FROM InstantASP_Users WHERE UserID = @intUserID)

-- update guide last modified details
UPDATE InstantKB_Articles SET 	
ArticleModifiedUserID = @intUserID,
ArticleModifiedUsername = @strUsername,
ArticleModifiedDate = GetDate()
WHERE (InstantKB_Articles.ArticleID = @intArticleID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateType
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateType (
@intTypeID int,
@strTypeName nvarchar(255),
@intTypeSortOrder int,
@intTypeTabID int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a type within InstantKB_Types table */

-- is this an update or insert?
IF (@intTypeID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Types (TypeName, TypeSortOrder, TypeTabID) VALUES (@strTypeName, @intTypeSortOrder, @intTypeTabID)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Types SET
	TypeName = @strTypeName,
	TypeSortOrder = @intTypeSortOrder,
	TypeTabID = @intTypeTabID
	WHERE InstantKB_Types.TypeID = @intTypeID

	-- return the identity
	SET @intIdentity = @intTypeID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateUser
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateUser (
@intUserID int,
@bolIsAnonymous bit,
@intPermissionID int,
@intStaffPermissionID int,
@intPrimaryDeptID int,
@intRecognitionPoints int,
@strSkin nvarchar(10),
@strMemberLevelTitle nvarchar(155),
@strMemberLevelImage nvarchar(155),
@strPhotoImage nvarchar(155),
@strInterests nvarchar(255),
@strSignature ntext,
@strNotes ntext,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a user within InstantKB_Users */

-- is this an update or insert?
IF NOT EXISTS(SELECT UserID FROM InstantKB_Users WHERE InstantKB_Users.UserID = @intUserID)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Users (UserID, IsAnonymous, PermissionID, StaffPermissionID, PrimaryDeptID, RecognitionPoints, Skin, MemberLevelTitle, MemberLevelImage, PhotoImage, Interests, Signature, Notes) VALUES
	(@intUserID, @bolIsAnonymous, @intPermissionID, @intStaffPermissionID, @intPrimaryDeptID, @intRecognitionPoints, @strSkin, @strMemberLevelTitle, @strMemberLevelImage, @strPhotoImage, @strInterests, @strSignature, @strNotes)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY

	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Users SET
	IsAnonymous = @bolIsAnonymous,
	PermissionID = @intPermissionID,
	StaffPermissionID = @intStaffPermissionID,
	PrimaryDeptID = @intPrimaryDeptID,
	RecognitionPoints = @intRecognitionPoints,
	Skin = @strSkin,
	MemberLevelTitle = @strMemberLevelTitle,
	MemberLevelImage = @strMemberLevelImage,
	PhotoImage = @strPhotoImage,
	Interests = @strInterests,
	Signature = @strSignature,
	Notes = @strNotes
	WHERE InstantKB_Users.UserID = @intUserID

	-- return the identity
	SET @intIdentity = @intUserID

	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateUserLevel
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateUserLevel (
@intUserLevelID int, 
@strDescription nvarchar(255),
@intRecognitionPoints int,
@intNoOfBlocks tinyint,
@strImageURL nvarchar(255),
@intIdentity int output
)
AS

SET NOCOUNT ON 

/* Inserts a new user level or updates an existing user level within the InstantKB_UserLevels table */

BEGIN TRANSACTION

IF (@intUserLevelID = 0) -- we are inserting a new user level
BEGIN

	-- add new user level	
	INSERT INTO InstantKB_UserLevels (RecognitionPoints, [Description], ImageURL, NoOfBlocks) 
	 VALUES (@intRecognitionPoints, @strDescription, @strImageURL, @intNoOfBlocks)

	-- set the output parameter the new records
	SET @intIdentity = @@IDENTITY

END
ELSE -- we are updating an existing user level
BEGIN 
	
	-- update existing forum
	UPDATE InstantKB_UserLevels SET
	RecognitionPoints = @intRecognitionPoints,
	[Description] = @strDescription,
	ImageURL = @strImageURL,
	NoOfBlocks = @intNoOfBlocks
	WHERE InstantKB_UserLevels.UserLevelID = @intUserLevelID

	-- update output parameter to indicate this was a success
	SET @intIdentity = @intUserLevelID

END

-- did we have any problems?
IF @@ERROR <> 0
BEGIN
	-- yep roll back 
	ROLLBACK TRANSACTION

	-- set the output parameter to indicate we had a problem
	SET @intIdentity = -1
END

-- commit the transaction
COMMIT TRANSACTION
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateView
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateView (
@intDataViewID int,
@intUserID int,
@strName nvarchar(255),
@strDescription ntext,
@strColumns nvarchar(1000),
@strSortBy nvarchar(255),
@intSortOrder tinyint,
@intPageSize int,
@intAccessType tinyint,
@intDataViewType tinyint,
@intTabID int,
@IsRequired bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a custom view into the InstantKB_DataViews table */

-- is this an update or insert?
IF (@intDataViewID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_DataViews (UserID, [Name], [Description], [Columns], SortBy, SortOrder, PageSize, AccessType, DataViewType, TabID, IsRequired, DateStamp) VALUES
	(@intUserID, @strName, @strDescription, @strColumns, @strSortBy, @intSortOrder, @intPageSize, @intAccessType, @intDataViewType, @intTabID, @IsRequired, GetDate())

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_DataViews SET
	[Name] = @strName,
	[Description] = @strDescription,
	[Columns] = @strColumns,
	SortBy = @strSortBy,
	SortOrder = @intSortOrder,
	PageSize = @intPageSize,
	AccessType = @intAccessType,
	DataViewType = @intDataViewType,
	DateStamp = GetDate()
	WHERE InstantKB_DataViews.DataViewID = @intDataViewID

	-- return the identity
	SET @intIdentity = @intDataViewID
	RETURN

END

SET @intIdentity = 0
RETURN

GO
----------------------------------------------------
-- ikb_sp_InsertUpdateWorkFlow
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateWorkFlow (
@intWorkFlowID int,
@strWorkFlowName nvarchar(255),
@strWorkFlowDescription ntext,
@intTabID int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a work flow within the InstantKB_WorkFlows table */

-- is this an update or insert?
IF (@intWorkFlowID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_WorkFlows (WorkFlowName, WorkFlowDescription, TabID) VALUES (@strWorkFlowName, @strWorkFlowDescription, @intTabID)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_WorkFlows SET
	WorkFlowName = @strWorkFlowName,
	WorkFlowDescription = @strWorkFlowDescription
	WHERE InstantKB_WorkFlows.WorkFlowID = @intWorkFlowID

	-- return the identity
	SET @intIdentity = @intWorkFlowID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUpdateWorkFlowStep
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertUpdateWorkFlowStep (
@intWorkFlowStepID int,
@intWorkFlowID int,
@strName nvarchar(255),
@intSortOrder int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a workflow step within InstantKB_WorkFlowSteps table */

-- is this an update or insert?
IF (@intWorkFlowStepID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_WorkFlowSteps (WorkFlowID, [Name], SortOrder) VALUES (@intWorkFlowID, @strName, @intSortOrder)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_WorkFlowSteps SET
	[Name] = @strName
	WHERE InstantKB_WorkFlowSteps.WorkFlowStepID = @intWorkFlowStepID

	-- return the identity
	SET @intIdentity = @intWorkFlowStepID
	RETURN

END

SET @intIdentity = 0
RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertUserDepartment
----------------------------------------------------
GO




CREATE PROCEDURE ikb_sp_InsertUserDepartment (
@intUserID int,
@intDepartmentID smallint
) AS

SET NOCOUNT ON 

/* Inserts a new user & department association to the InstantKB_UserDepartments table */

-- check to ensure we don't already have the role association
IF NOT EXISTS(SELECT DepartmentID From InstantKB_UserDepartments WHERE UserID = @intUserID AND DepartmentID = @intDepartmentID)
BEGIN
	INSERT INTO InstantKB_UserDepartments (UserID, DepartmentID) VALUES (@intUserID, @intDepartmentID)
END

RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertWhosOn
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertWhosOn (
@intCurrentTask int,
@strUsername nvarchar(255),
@intUserID int,
@intCategoryID int,
@strCategoryName nvarchar(255),
@intArticleID int,
@strArticleTitle nvarchar(255),
@strIPAddress nvarchar(50),
@bitIsAnonymous bit,
@strSessionID nvarchar(200),
@intExpires int,
@intPrimaryRoleID int,
@intArticleReadExpires int
)
AS
SET NOCOUNT ON 

/* Delete any previous session activity within the who's on table */
DELETE FROM InstantKB_WhosOn WHERE (InstantKB_WhosOn.SessionIdentity = @strSessionID)

-- get current datetime
DECLARE @dtDateTimeNow datetime
SET @dtDateTimeNow = GetDate()

-- are we an authenticated user?
IF (@intUserID > 0) 
BEGIN 
	-- delete all previous instances of the user from the who's on table
	DELETE FROM InstantKB_WhosOn WHERE (InstantKB_WhosOn.UserID = @intUserID) 

	/* update read tracker */
	IF (@intArticleID > 0 AND @intCurrentTask = 4)
	BEGIN		
		DECLARE @dtArticleReadExpires datetime
		SET @dtArticleReadExpires = DateAdd(d, @intArticleReadExpires, @dtDateTimeNow)
		EXEC ikb_sp_InsertArticleRead @intArticleID, @intUserID, @dtArticleReadExpires
	END
END

/* update article view count */
IF (@intArticleID > 0 AND @intCurrentTask = 4)
BEGIN		
	UPDATE InstantKB_Articles SET InstantKB_Articles.ArticleViews = (InstantKB_Articles.ArticleViews + 1) WHERE (InstantKB_Articles.ArticleID = @intArticleID)
END

/* Insert who's on information into database */
INSERT INTO InstantKB_WhosOn (CurrentTask, Username, UserID, CategoryID, CategoryName, ArticleID, ArticleTitle, IPAddress, IsAnonymous, SessionIdentity, Expires, PrimaryRoleID)
VALUES (@intCurrentTask, @strUsername, @intUserID, @intCategoryID, @strCategoryName, @intArticleID, @strArticleTitle, @strIPAddress, @bitIsAnonymous, @strSessionID,  DateAdd(n, @intExpires, @dtDateTimeNow), @intPrimaryRoleID)
GO
----------------------------------------------------
-- ikb_sp_InsertWorkFlowDepartment
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertWorkFlowDepartment (
@intWorkFlowID int,
@intDepartmentID int
) AS

SET NOCOUNT ON 

/* Inserts a specific department for a workflow within InstantKB_WorkFlowDepartments table */

INSERT INTO InstantKB_WorkFlowDepartments (WorkFlowID, DepartmentID) VALUES (@intWorkFlowID, @intDepartmentID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_InsertWorkFlowStepNextStep
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_InsertWorkFlowStepNextStep (
@intWorkFlowStepID int,
@intWorkFlowNextStepID int
) AS

SET NOCOUNT ON 

/* Adds new next steps to a workflow step */

INSERT INTO InstantKB_WorkFlowStepsNextSteps (WorkFlowStepID, WorkFlowNextStepID) VALUES (@intWorkFlowStepID, @intWorkFlowNextStepID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_SelectArticle
----------------------------------------------------
GO

CREATE PROCEDURE ikb_sp_MoveArticlesBetweenTabs (
@intOldTabID int,
@intNewTabID int
) AS
SET NOCOUNT ON 

-- delete any article & category relationships
DELETE FROM InstantKB_ArticleCategories WHERE ArticleID IN 
	(SELECT ArticleID FROM InstantKB_Articles WHERE TabID = @intOldTabID)

	-- move articles
UPDATE InstantKB_Articles SET 
TabID = @intNewTabID,
ArticleWorkFlowStepID = 0,
ArticleCategoryID = 0,
ArticleTypeID = 0,
ArticleLevelID = 0,
ArticleStatusID = 0,
ArticlePriorityID = 0
WHERE (TabID = @intOldTabID)	

RETURN
GO

----------------------------------------------------
-- ikb_sp_SelectArticle
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectArticle (
@intArticleID int,
@strArticleTitleEncoded nvarchar(500),
@intUserID int
) AS
SET NOCOUNT ON 

/* Select an article and related data */

DECLARE @SQL nvarchar(2000)
SELECT @SQL = 'SELECT  InstantKB_Articles.*, InstantKB_ArticleCustomFields.*, InstantKB_Types.*, InstantKB_Levels.*, InstantKB_Status.*, InstantKB_Priorities.*,  InstantKB_WorkFlowSteps.* 
FROM InstantKB_Articles WITH (NOLOCK) LEFT OUTER JOIN InstantKB_Types ON InstantKB_Articles.ArticleTypeID = InstantKB_Types.TypeID LEFT OUTER JOIN
InstantKB_WorkFlowSteps ON InstantKB_Articles.ArticleWorkFlowStepID = InstantKB_WorkFlowSteps.WorkFlowStepID LEFT OUTER JOIN
InstantKB_Priorities ON InstantKB_Articles.ArticlePriorityID = InstantKB_Priorities.PriorityID LEFT OUTER JOIN
InstantKB_Status ON InstantKB_Articles.ArticleStatusID = InstantKB_Status.StatusID LEFT OUTER JOIN
InstantKB_Levels ON InstantKB_Articles.ArticleLevelID = InstantKB_Levels.LevelID LEFT OUTER JOIN
InstantKB_ArticleCustomFields ON InstantKB_Articles.ArticleID = InstantKB_ArticleCustomFields.ArticleID '

-- search by encoded title or article identity
IF (@strArticleTitleEncoded <> '')
BEGIN
	SELECT @SQL = @SQL + ' WHERE InstantKB_Articles.ArticleTitleEncoded =  ''' + CAST(@strArticleTitleEncoded As nVarChar(500)) + ''''
END
ELSE
BEGIN
	SELECT @SQL = @SQL + ' WHERE InstantKB_Articles.ArticleID =  ' + CAST(@intArticleID As nVarChar(20)) 
END

-- if we have a user idenity we need to filter content based on roles
-- we can pass in -1 as a parameter to this proc to skip the role checking
IF (@intUserID >= 0)
BEGIN
	SELECT @SQL = @SQL + ' AND EXISTS (SELECT InstantKB_ArticleRoles.RoleID FROM InstantKB_ArticleRoles WHERE InstantKB_ArticleRoles.ArticleID = InstantKB_Articles.ArticleID AND InstantKB_ArticleRoles.RoleID IN ('
	-- filterarticle based on roles
	IF (@intUserID = 0) -- anonymous users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.AnonymousRole = 1)'
	END
	ELSE IF (@intUserID > 0) -- authenticated users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN
		InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantASP_UsersRoles.UserID = ' + CAST(@intUserID As nVarChar(15)) + '))'
	END
	SELECT @SQL = @SQL + '))'
END

-- ensure we use sp_executesql to cache execution plan for dynamic query
EXECUTE sp_executesql @SQL
GO
----------------------------------------------------
-- ikb_sp_SelectArticleCategories
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectArticleCategories (
@intArticleID int,
@intUserID int
) AS
SET NOCOUNT ON 
/* Returns categories based on the current user identity */
DECLARE @SQL nvarchar(2000)
-- the where exists clause below saves us from having to use a distinct statement
-- where exists is always faster than performing a distinct selection
-- this is because articles can have multiple roles associated with them
-- so we must only select articles that are associated with the same roles as the user
SELECT @SQL = 'SELECT InstantKB_Categories.* FROM InstantKB_ArticleCategories 
	INNER JOIN InstantKB_Categories ON InstantKB_ArticleCategories.CategoryID = InstantKB_Categories.CategoryID 
	WHERE InstantKB_ArticleCategories.ArticleID =  ' + CAST(@intArticleID As nVarChar(20)) 

-- if we have a user idenity we need to filter content based on roles
IF (@intUserID > -1)
BEGIN
	SELECT @SQL = @SQL + ' AND EXISTS (SELECT InstantKB_CategoryRoles.RoleID FROM InstantKB_CategoryRoles WHERE InstantKB_CategoryRoles.CategoryID = InstantKB_Categories.CategoryID AND InstantKB_CategoryRoles.RoleID IN ('
	-- filterarticle based on roles
	IF (@intUserID = 0) -- anonymous users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.AnonymousRole = 1)'
	END
	ELSE IF (@intUserID > 0) -- authenticated users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN
		InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantASP_UsersRoles.UserID = ' + CAST(@intUserID As nVarChar(15)) + '))'
	END
	SELECT @SQL = @SQL + '))'
END

-- ensure we use sp_executesql to cache execution plan for dynamic query
EXECUTE sp_executesql @SQL
GO
----------------------------------------------------
-- ikb_sp_SelectArticleComment
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectArticleComment (
@intCommentID int
) AS
SET NOCOUNT ON
 
/* Returns all single comment from InstantKB_ArticleComments */

SELECT InstantKB_ArticleComments.*, InstantKB_Users.MemberLevelTitle, InstantKB_Users.MemberLevelImage, InstantKB_Users.PhotoImage, InstantKB_Users.RecognitionPoints, InstantKB_ArticleComments.UserID, 
InstantKB_ArticleComments.Username, InstantKB_ArticleComments.EmailAddress, InstantKB_ArticleComments.WebAddress, InstantKB_Articles.TabID,
(SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName FROM InstantKB_Users 
JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID 
RIGHT OUTER JOIN InstantKB_ArticleComments ON InstantASP_Users.UserID = InstantKB_ArticleComments.UserID 
JOIN InstantKB_Articles ON InstantKB_ArticleComments.ArticleID = InstantKB_Articles.ArticleID
WHERE (InstantKB_ArticleComments.CommentID = @intCommentID)
GO
----------------------------------------------------
-- ikb_sp_SelectArticleComments
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectArticleComments (
@intArticleID int,
@intAccessType tinyint,
@intSortOrder tinyint
) AS
SET NOCOUNT ON
 
/* Returns all anonymous and member public comments for an article */


IF (@intAccessType > 0)
BEGIN
	SELECT InstantKB_Users.MemberLevelTitle, InstantKB_Users.MemberLevelImage, InstantKB_Users.PhotoImage,(SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName, InstantKB_Users.RecognitionPoints, InstantKB_ArticleComments.* FROM InstantKB_Users
	INNER JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID RIGHT OUTER JOIN InstantKB_ArticleComments ON InstantASP_Users.UserID = InstantKB_ArticleComments.UserID 
	WHERE (InstantKB_ArticleComments.ArticleID = @intArticleID AND InstantKB_ArticleComments.AccessType = @intAccessType) ORDER BY
	CASE 
	WHEN @intSortOrder = 1 THEN DateStamp 
	END DESC,
	CASE
	WHEN @intSortOrder = 2 THEN DateStamp 
	END ASC,
	CASE
	WHEN @intSortOrder = 3 THEN MarkedAsHelpFul 
	END	DESC
END
ELSE
BEGIN
	SELECT InstantKB_Users.MemberLevelTitle, InstantKB_Users.MemberLevelImage, InstantKB_Users.PhotoImage,  (SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName, InstantKB_Users.RecognitionPoints, InstantKB_ArticleComments.* FROM InstantKB_Users 
	INNER JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID RIGHT OUTER JOIN InstantKB_ArticleComments ON InstantASP_Users.UserID = InstantKB_ArticleComments.UserID 
	WHERE (InstantKB_ArticleComments.ArticleID = @intArticleID) ORDER BY
	CASE 
	WHEN @intSortOrder = 1 THEN DateStamp 
	END DESC,
	CASE
	WHEN @intSortOrder = 2 THEN DateStamp 
	END ASC,
	CASE
	WHEN @intSortOrder = 3 THEN MarkedAsHelpFul 
	END	DESC
END

GO
----------------------------------------------------
-- ikb_sp_SelectArticleCommentsPaged
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectArticleCommentsPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	CommentID int
)

-- insert data 
INSERT INTO #PageIndex (CommentID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantKB_Users.MemberLevelTitle, InstantKB_Users.MemberLevelImage, InstantKB_Users.PhotoImage, InstantKB_Users.RecognitionPoints, InstantKB_ArticleComments.*,
(SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName FROM #PageIndex IPI 
 JOIN InstantKB_ArticleComments ON InstantKB_ArticleComments.CommentID = IPI.CommentID
 LEFT  OUTER JOIN InstantASP_Users ON InstantKB_ArticleComments.UserID = InstantASP_Users.UserID 
LEFT  OUTER JOIN InstantKB_Users ON InstantKB_ArticleComments.UserID = InstantKB_Users.UserID 
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- ikb_sp_SelectArticleRead
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectArticleRead (
@intUserID int
)
AS

SET NOCOUNT ON 

SELECT * FROM InstantKB_ArticleRead (nolock) WHERE (InstantKB_ArticleRead.ArticleReadUserID = @intUserID)
GO
----------------------------------------------------
-- ikb_sp_SelectArticleRelatedLinks
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectArticleRelatedLinks (
@intArticleID int
) AS
SET NOCOUNT ON
 
/* Selects all related links for a specific article from InstantKB_ArticleRelatedLinks */

SELECT * FROM InstantKB_ArticleRelatedLinks WHERE (InstantKB_ArticleRelatedLinks.ArticleID = @intArticleID)
GO
----------------------------------------------------
-- ikb_sp_SelectArticleRoles
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectArticleRoles (
@intArticleID int
) AS
SET NOCOUNT ON 

/* Selects all roles for a specific article */

SELECT InstantASP_Roles.* FROM InstantKB_ArticleRoles INNER JOIN
InstantASP_Roles ON InstantKB_ArticleRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantKB_ArticleRoles.ArticleID = @intArticleID)
GO
----------------------------------------------------
-- ikb_sp_SelectArticles
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectArticles (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLFullTextMaxRank nvarchar(4000)
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	ArticleID int, Rank int, MaxRank int, SortBy sql_variant
)

-- insert data 
INSERT INTO #PageIndex (ArticleID, Rank, SortBy)
EXECUTE sp_executesql @strSQLPopulate

-- do we need to return our full text max rank
DECLARE @intMaxRank int
IF (@strSQLFullTextMaxRank <> '')
BEGIN

	-- insert full text max rank
	INSERT INTO #PageIndex (MaxRank)
	EXECUTE sp_executesql @strSQLFullTextMaxRank
	-- set max rank
	SET @intMaxRank = (SELECT MaxRank FROM #PageIndex WHERE #PageIndex.IndexID = @@IDENTITY)
	DELETE FROM #PageIndex WHERE #PageIndex.IndexID = @@IDENTITY
	UPDATE #PageIndex SET MaxRank = @intMaxRank

END

-- select the data to return
SELECT InstantKB_Articles.* FROM #PageIndex IPI LEFT OUTER JOIN InstantKB_Articles ON InstantKB_Articles.ArticleID = IPI.ArticleID  
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID
GO
----------------------------------------------------
-- ikb_sp_SelectArticlesPaged
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectArticlesPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit,
@strSQLFullTextMaxRank nvarchar(4000)
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
IF (@intRowsToReturn > 0) 
BEGIN
	SET ROWCOUNT @intRowsToReturn
END

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex

-- set upperbound only if we have a pagesize
IF (@intRowsToReturn > 0) 
BEGIN
	SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1
END
ELSE
BEGIN
	SET @intPageUpperBound = (SELECT COUNT(ArticleID) FROM InstantKB_Articles)
END

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	ArticleID int, Rank int, MaxRank int, SortBy sql_variant
)

-- insert data 
INSERT INTO #PageIndex (ArticleID, Rank, SortBy)
EXECUTE sp_executesql @strSQLPopulate

-- do we need to return our full text max rank
DECLARE @intMaxRank int
IF (@strSQLFullTextMaxRank <> '')
BEGIN

	-- insert full text max rank
	INSERT INTO #PageIndex (MaxRank)
	EXECUTE sp_executesql @strSQLFullTextMaxRank
	-- set max rank
	SET @intMaxRank = (SELECT MaxRank FROM #PageIndex WHERE #PageIndex.IndexID = @@IDENTITY)
	DELETE FROM #PageIndex WHERE #PageIndex.IndexID = @@IDENTITY
	UPDATE #PageIndex SET MaxRank = @intMaxRank

END

-- select the data to return
SELECT IPI.Rank, IPI.MaxRank, InstantKB_Articles.*, InstantKB_ArticleCustomFields.*, InstantKB_Types.*, InstantKB_Levels.*, InstantKB_Status.*, InstantKB_Priorities.*,  InstantKB_WorkFlowSteps.* FROM #PageIndex IPI 
LEFT OUTER JOIN InstantKB_Articles ON InstantKB_Articles.ArticleID = IPI.ArticleID  
LEFT OUTER JOIN InstantKB_Types ON InstantKB_Articles.ArticleTypeID = InstantKB_Types.TypeID 
LEFT OUTER JOIN InstantKB_WorkFlowSteps ON InstantKB_Articles.ArticleWorkFlowStepID = InstantKB_WorkFlowSteps.WorkFlowStepID 
LEFT OUTER JOIN InstantKB_Priorities ON InstantKB_Articles.ArticlePriorityID = InstantKB_Priorities.PriorityID 
LEFT OUTER JOIN InstantKB_Status ON InstantKB_Articles.ArticleStatusID = InstantKB_Status.StatusID 
LEFT OUTER JOIN InstantKB_Levels ON InstantKB_Articles.ArticleLevelID = InstantKB_Levels.LevelID 
LEFT OUTER JOIN InstantKB_ArticleCustomFields ON InstantKB_Articles.ArticleID = InstantKB_ArticleCustomFields.ArticleID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- ikb_sp_SelectArticleTroubleshootingSteps
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectArticleTroubleshootingSteps (
@intArticleID int
) AS
SET NOCOUNT ON 
/* Returns troubleshooting steps based on the article identity */

SELECT * FROM InstantKB_TroubleshootingSteps WHERE StepArticleID = @intArticleID
GO
----------------------------------------------------
-- ikb_sp_SelectAttachment
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectAttachment (
@intAttachmentID int,
@intUserID int
)
AS

SET NOCOUNT ON 

/* Select a single attachment from InstantKB_Attachments */

-- get the article this attachmentb belongs to
DECLARE @intArticleID int
SET @intArticleID = (SELECT ArticleID FROM InstantKB_Articles WHERE ArticleID = 
(SELECT RelatedEntityID FROM InstantKB_Attachments WHERE InstantKB_Attachments.AttachmentID = @intAttachmentID))

-- select the attachment with role check on article to ensure user has access
IF (@intUserID > 0) 
BEGIN
	SELECT InstantKB_Attachments.* FROM InstantKB_Attachments WHERE InstantKB_Attachments.AttachmentID = @intAttachmentID 
	AND EXISTS (
	SELECT InstantKB_ArticleRoles.RoleID FROM InstantKB_ArticleRoles WHERE InstantKB_ArticleRoles.ArticleID = @intArticleID AND InstantKB_ArticleRoles.RoleID IN (
	SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE InstantASP_UsersRoles.UserID = @intUserID)
	)
END
ELSE
BEGIN
	SELECT InstantKB_Attachments.* FROM InstantKB_Attachments WHERE InstantKB_Attachments.AttachmentID = @intAttachmentID 
	AND EXISTS (
	SELECT InstantKB_ArticleRoles.RoleID FROM InstantKB_ArticleRoles WHERE InstantKB_ArticleRoles.ArticleID = @intArticleID AND InstantKB_ArticleRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles WHERE AnonymousRole = 1)
	)
END

GO
----------------------------------------------------
-- ikb_sp_SelectAttachmentLength
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectAttachmentLength (
@intUserID int,
@intCurrentLength int output
) AS
SET NOCOUNT ON 
/* Returns the total current length for all attachments and all attachments associated to a specific user */
IF (@intUserID >= 0) 
BEGIN
	SET @intCurrentLength = (SELECT SUM(InstantKB_Attachments.ContentLength) FROM InstantKB_Attachments (nolock) WHERE InstantKB_Attachments.UserID = @intUserID)
END
ELSE IF (@intUserID < 0) 
BEGIN
	SET @intCurrentLength = (SELECT SUM(InstantKB_Attachments.ContentLength) FROM InstantKB_Attachments (nolock))
END
GO
----------------------------------------------------
-- ikb_sp_SelectAttachments
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectAttachments (
@intRelatedEntityID int,
@intAttachmentType int
) AS
SET NOCOUNT ON 

/* Returns attachments based on the entity identity and attachment type */

IF (@intAttachmentType > 0)
BEGIN
	SELECT * FROM InstantKB_Attachments WHERE (RelatedEntityID = @intRelatedEntityID AND AttachmentType = @intAttachmentType) ORDER BY DateStamp DESC
END
ELSE
BEGIN
	SELECT * FROM InstantKB_Attachments WHERE (RelatedEntityID = @intRelatedEntityID) ORDER BY DateStamp DESC
END
GO
----------------------------------------------------
-- ikb_sp_SelectAttachmentTypes
----------------------------------------------------
GO

CREATE PROCEDURE ikb_sp_SelectAttachmentTypes
@intTabID int
AS

SET NOCOUNT ON 


IF (@intTabID > 0)
BEGIN
	SELECT * FROM InstantKB_AttachmentTypes (nolock) WHERE (InstantKB_AttachmentTypes.TabID = @intTabID)
END
ELSE
BEGIN
	SELECT * FROM InstantKB_AttachmentTypes (nolock)
END
GO
----------------------------------------------------
-- ikb_sp_SelectCategories
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectCategories (
@intUserID int,
@intTabID int
) AS
SET NOCOUNT ON 

/* Select categories that are associated with the same roles as user */
DECLARE @SQL nvarchar(2000)

SELECT @SQL = 'SELECT InstantKB_Categories.* FROM InstantKB_Categories (nolock) '

IF (@intTabID > 0) -- do we have a tab identity
BEGIN
SELECT @SQL = @SQL + 'WHERE (InstantKB_Categories.TabID = ' + CAST(@intTabID AS nVarChar(15)) + ') '
END

-- should we enable the role check
IF (@intUserID >= 0)
BEGIN
	-- did we also search by tab
	IF (@intTabID > 0) 
	BEGIN
		SELECT @SQL = @SQL + 'AND '
	END
	ELSE
	BEGIN
		SELECT @SQL = @SQL + 'WHERE '
	END

	SELECT @SQL = @SQL + 'EXISTS (SELECT InstantKB_CategoryRoles.RoleID FROM InstantKB_CategoryRoles WHERE InstantKB_CategoryRoles.CategoryID = InstantKB_Categories.CategoryID AND InstantKB_CategoryRoles.RoleID IN '
	-- filter categories based on roles
	IF (@intUserID = 0) -- anonymous users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.AnonymousRole = 1)'
	END
	ELSE IF (@intUserID > 0) -- authenticated users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN
		InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantASP_UsersRoles.UserID = ' + CAST(@intUserID As nVarChar(15)) + '))'
	END	
	SELECT @SQL = @SQL + ') '
END

SELECT @SQL = @SQL + 'ORDER BY InstantKB_Categories.CategorySortOrder ASC'

-- ensure we use sp_executesql to cache execution plan for dynamic query
EXECUTE sp_executesql @SQL
GO
----------------------------------------------------
-- ikb_sp_SelectCategoryRoles
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectCategoryRoles (
@intCategoryID int
) AS
SET NOCOUNT ON 
/* Returns all roles and associated permission set for the @intCategoryID category */
SELECT InstantKB_CategoryRoles.RoleID, InstantASP_Roles.RoleName, InstantKB_CategoryRoles.PermissionID 
FROM  InstantKB_CategoryRoles INNER JOIN InstantASP_Roles ON InstantKB_CategoryRoles.RoleID = InstantASP_Roles.RoleID 
WHERE (InstantKB_CategoryRoles.CategoryID = @intCategoryID)
GO
----------------------------------------------------
-- ikb_sp_SelectCategoryRolesByPermissionID
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectCategoryRolesByPermissionID (
@intPermissionID int
) AS
SET NOCOUNT ON 
/* Returns all categories and roles associated with a specific permission set */
SELECT DISTINCT InstantKB_CategoriesRoles.CategoryID, InstantKB_CategoriesRoles.PermissionID 
FROM InstantKB_CategoriesRoles WHERE (InstantKB_CategoriesRoles.PermissionID = @intPermissionID)
GO
----------------------------------------------------
-- ikb_sp_SelectDataViews
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectDataViews (
@intTabID int,
@intUserID int
)
AS

SET NOCOUNT ON 

/* select view based on user identity from InstantKB_DataViews */

-- select default dataviews
IF (@intUserID >= 0) 
BEGIN
	SELECT * FROM InstantKB_DataViews (nolock) WHERE (InstantKB_DataViews.TabID = @intTabID AND InstantKB_DataViews.UserID = @intUserID)
END 
ELSE
BEGIN
	SELECT * FROM InstantKB_DataViews (nolock) WHERE (InstantKB_DataViews.TabID = @intTabID)
END
GO
----------------------------------------------------
-- ikb_sp_SelectDataViewsPaged
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectDataViewsPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	DataViewID int
)

-- insert data 
INSERT INTO #PageIndex (DataViewID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantKB_DataViews.* FROM #PageIndex IPI JOIN InstantKB_DataViews ON InstantKB_DataViews.DataViewID = IPI.DataViewID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- ikb_sp_SelectDepartments
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectDepartments 
AS

SET NOCOUNT ON 

SELECT * FROM InstantKB_Departments ORDER BY SortOrder ASC
GO
----------------------------------------------------
-- ikb_sp_SelectDepartmentsByUserID
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectDepartmentsByUserID (
@intUserID int
) AS
SET NOCOUNT ON 

/* Select departments for a user */

SELECT InstantKB_Departments.* FROM InstantKB_UserDepartments INNER JOIN 
InstantKB_Departments ON InstantKB_UserDepartments.DepartmentID = InstantKB_Departments.DepartmentID 
WHERE InstantKB_UserDepartments.UserID = @intUserID
GO
----------------------------------------------------
-- ikb_sp_SelectDepartmentsPaged
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectDepartmentsPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	DepartmentID int
)

-- insert data 
INSERT INTO #PageIndex (DepartmentID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantKB_Departments.* FROM #PageIndex IPI JOIN InstantKB_Departments ON InstantKB_Departments.DepartmentID = IPI.DepartmentID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- ikb_sp_SelectGlossaryTerm
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectGlossaryTerm (
@intGlossaryTermID int
)
AS

SET NOCOUNT ON 

SELECT * FROM InstantKB_Glossary WHERE (InstantKB_Glossary.GlossaryTermID = @intGlossaryTermID)
GO
----------------------------------------------------
-- ikb_sp_SelectGlossaryTerms
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectGlossaryTerms 
AS

SET NOCOUNT ON 

SELECT * FROM InstantKB_Glossary ORDER BY GlossaryTerm ASC
GO
----------------------------------------------------
-- ikb_sp_SelectGlossaryTermsPaged
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectGlossaryTermsPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	GlossaryTermID int
)

-- insert data 
INSERT INTO #PageIndex (GlossaryTermID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT  InstantKB_Glossary.* FROM #PageIndex IPI 
 JOIN InstantKB_Glossary ON InstantKB_Glossary.GlossaryTermID = IPI.GlossaryTermID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- ikb_sp_SelectLevels
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectLevels 
AS

SET NOCOUNT ON 

SELECT * FROM InstantKB_Levels ORDER BY LevelSortOrder ASC
GO
----------------------------------------------------
-- ikb_sp_SelectNotes
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectNotes 
AS

SET NOCOUNT ON 

SELECT * FROM InstantKB_Notes
GO
----------------------------------------------------
-- ikb_sp_SelectNotifications
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectNotifications (
@intRelatedEntityID int,
@intNotificationType int
) 
AS

SET NOCOUNT ON 

SELECT InstantASP_Users.Username, InstantASP_Users.EmailAddress, InstantKB_Notifications.* FROM InstantKB_Notifications 
LEFT OUTER JOIN InstantASP_Users ON InstantKB_Notifications.UserID = InstantASP_Users.UserID
WHERE (RelatedEntityID = @intRelatedEntityID AND NotificationType = @intNotificationType)
GO
----------------------------------------------------
-- ikb_sp_SelectPermissionSet
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectPermissionSet (
@intPermissionID int
)
AS
SET NOCOUNT ON 

/* Select a specific  perission set and and all tab permission */

SELECT InstantKB_PermissionSets.* FROM InstantKB_PermissionSets  WITH (nolock) WHERE PermissionID = @intPermissionID

SELECT InstantKB_PermissionSetsTabs.*, InstantKB_Tabs.TabContentType FROM  InstantKB_PermissionSetsTabs WITH (nolock) 
INNER JOIN InstantKB_Tabs ON InstantKB_PermissionSetsTabs.TabID = InstantKB_Tabs.TabID WHERE InstantKB_PermissionSetsTabs.PermissionID = @intPermissionID
GO
----------------------------------------------------
-- ikb_sp_SelectPermissionSetForRole
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectPermissionSetForRole (
@intRoleID int
)
AS

SET NOCOUNT ON 

/* Returns a permission set for a specific user role */

SELECT InstantKB_PermissionSets.* FROM  InstantKB_PermissionSets INNER JOIN
InstantKB_PermissionSetsRoles  (nolock) ON InstantKB_PermissionSets.PermissionID = InstantKB_PermissionSetsRoles.PermissionID
WHERE InstantKB_PermissionSetsRoles.RoleID = @intRoleID
GO
----------------------------------------------------
-- ikb_sp_SelectPermissionSets
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectPermissionSets
AS
SET NOCOUNT ON 

/* Returns all permission sets*/
SELECT InstantKB_PermissionSets.* FROM InstantKB_PermissionSets WITH (nolock)

/* Select tab permissions for permission set from InstantKB_PermissionSetsTabs */
SELECT InstantKB_PermissionSetsTabs.*, InstantKB_Tabs.TabContentType FROM  InstantKB_PermissionSetsTabs WITH (nolock) 
INNER JOIN InstantKB_Tabs ON InstantKB_PermissionSetsTabs.TabID = InstantKB_Tabs.TabID
GO
----------------------------------------------------
-- ikb_sp_SelectPermissionSetsPaged
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectPermissionSetsPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	PermissionID int
)

-- insert data 
INSERT INTO #PageIndex (PermissionID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantKB_PermissionSets.* FROM #PageIndex IPI
JOIN InstantKB_PermissionSets ON InstantKB_PermissionSets.PermissionID = IPI.PermissionID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- ikb_sp_SelectPriorities
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectPriorities
AS

SET NOCOUNT ON 

/* Select all priorities from InstantKB_Priorities */

SELECT * FROM InstantKB_Priorities ORDER BY PrioritySortOrder ASC
GO
----------------------------------------------------
-- ikb_sp_SelectRolesForPermissionSet
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectRolesForPermissionSet (
@intPermissionID int
)
AS
SET NOCOUNT ON 
/* Returns all roles associated with a specific permission set from the InstantForum_PermissionSetsRoles table */
SELECT InstantASP_Roles.* FROM InstantKB_PermissionSetsRoles INNER JOIN
InstantASP_Roles ON InstantKB_PermissionSetsRoles.RoleID = InstantASP_Roles.RoleID
WHERE InstantKB_PermissionSetsRoles.PermissionID = @intPermissionID
GO
----------------------------------------------------
-- ikb_sp_SelectSettings
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectSettings 
AS
SET NOCOUNT ON 
/* Select application settings */
SELECT * FROM InstantKB_Settings (nolock)
GO
----------------------------------------------------
-- ikb_sp_SelectStaff
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectStaff 
AS

SET NOCOUNT ON 

DECLARE @intStaffRoleID int

-- select staff members from InstantASP_Users
SELECT InstantASP_Users.UserID, InstantASP_Users.Username FROM InstantKB_Users 
INNER JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID
WHERE EXISTS (
	SELECT RoleID FROM InstantASP_UsersRoles WHERE  InstantASP_UsersRoles.UserID =  InstantASP_Users.UserID AND InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles WHERE ModeratorRole = 1)
	)
GO
----------------------------------------------------
-- ikb_sp_SelectStaffPermissionSet
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectStaffPermissionSet (
@intPermissionID int
)
AS
SET NOCOUNT ON 

/* Select a specific staff perission set and and all tab permission */

SELECT InstantKB_StaffPermissionSets.* FROM InstantKB_StaffPermissionSets  WITH (nolock) WHERE PErmissionID = @intPermissionID

SELECT InstantKB_StaffPermissionSetsTabs.*, InstantKB_Tabs.TabContentType FROM  InstantKB_StaffPermissionSetsTabs WITH (nolock) 
INNER JOIN InstantKB_Tabs ON InstantKB_StaffPermissionSetsTabs.TabID = InstantKB_Tabs.TabID WHERE InstantKB_StaffPermissionSetsTabs.PermissionID = @intPermissionID
GO
----------------------------------------------------
-- ikb_sp_SelectStaffPermissionSets
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectStaffPermissionSets
AS
SET NOCOUNT ON 

/* Returns all staff permission sets*/
SELECT InstantKB_StaffPermissionSets.* FROM InstantKB_StaffPermissionSets

RETURN
GO
----------------------------------------------------
-- ikb_sp_SelectStaffPermissionSetsPaged
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectStaffPermissionSetsPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	PermissionID int
)

-- insert data 
INSERT INTO #PageIndex (PermissionID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantKB_StaffPermissionSets.* FROM #PageIndex IPI
 JOIN InstantKB_StaffPermissionSets ON InstantKB_StaffPermissionSets.PermissionID = IPI.PermissionID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- ikb_sp_SelectStatisticsForAdmin
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectStatisticsForAdmin 
AS

SET NOCOUNT ON 



DECLARE @intTotalCustomTabs int
DECLARE @intTotalRoles int
DECLARE @intTotalAwaitingActivation int
DECLARE @intTotalStaff int
DECLARE @intTotalAdmins int
DECLARE @intTotalDepartments int
DECLARE @intTotalFieldTemplates int
DECLARE @intTotalCustomFields int
DECLARE @intTotalWorkFlows int
DECLARE @intTotalWorkFlowSteps int
DECLARE @intTotalWrappers int
DECLARE @intTotalPermissionSets int
DECLARE @intTotalStaffPermissionSets int
-- general counts


SET @intTotalCustomTabs = (SELECT COUNT(TabID) FROM InstantKB_Tabs (nolock) WHERE IsCustomTab = 1)
SET @intTotalRoles = (SELECT COUNT(RoleID) FROM InstantASP_Roles (nolock))
SET @intTotalAwaitingActivation = (SELECT COUNT(UserID) FROM InstantASP_Users WHERE EXISTS (SELECT RoleID FROM InstantASP_UsersRoles WHERE InstantASP_Users.UserID = InstantASP_UsersRoles.UserID AND InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.ActivationRole = 1)))
SET @intTotalStaff = (SELECT COUNT(UserID) FROM InstantASP_Users WHERE EXISTS (SELECT RoleID FROM InstantASP_UsersRoles WHERE InstantASP_Users.UserID = InstantASP_UsersRoles.UserID AND InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.ModeratorRole = 1)))
SET @intTotalAdmins = (SELECT COUNT(UserID) FROM InstantASP_Users WHERE EXISTS (SELECT RoleID FROM InstantASP_UsersRoles WHERE InstantASP_Users.UserID = InstantASP_UsersRoles.UserID AND InstantASP_UsersRoles.RoleID IN (SELECT RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.AdministratorRole = 1)))
SET @intTotalDepartments = (SELECT COUNT(DepartmentID) FROM InstantKB_Departments)
SET @intTotalFieldTemplates = (SELECT COUNT(FieldTemplateID) FROM InstantASP_FieldTemplates WHERE ApplicationID = 2)
SET @intTotalCustomFields = (SELECT COUNT(FieldID) FROM InstantASP_Fields WHERE ApplicationID = 2 AND IsCustomField =1)
SET @intTotalWorkFlows = (SELECT COUNT(WorkFlowID) FROM InstantKB_WorkFlows)
SET @intTotalWorkFlowSteps = (SELECT COUNT(WorkFlowStepID) FROM InstantKB_WorkFlowSteps)
SET @intTotalWrappers = (SELECT COUNT(WrapperID) FROM InstantASP_Wrappers)
SET @intTotalWrappers = (SELECT COUNT(WrapperID) FROM InstantASP_Wrappers)
SET @intTotalPermissionSets = (SELECT COUNT(PermissionID) FROM InstantKB_PermissionSets)
SET @intTotalStaffPermissionSets = (SELECT COUNT(PermissionID) FROM InstantKB_StaffPermissionSets)

SELECT 
@intTotalCustomTabs As TotalCustomTabs,
@intTotalRoles As TotalRoles,
@intTotalAwaitingActivation As TotalAwaitingActivation,
@intTotalStaff As TotalStaff,
@intTotalAdmins As TotalAdmins,
@intTotalDepartments As TotalDepartments,
@intTotalFieldTemplates As TotalFieldTemplates,
@intTotalCustomFields As TotalCustomFields,
@intTotalWorkFlows As TotalWorkFlows,
@intTotalWorkFlowSteps As TotalWorkFlowSteps,
@intTotalWrappers As TotalWrappers,
@intTotalPermissionSets As TotalPermissionSets,
@intTotalStaffPermissionSets As TotalStaffPermissionSets
GO
----------------------------------------------------
-- ikb_sp_SelectStatisticsForTab
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectStatisticsForTab (
@intTabID int,
@intUserID int
)
AS

SET NOCOUNT ON 

DECLARE @intTotalCategories int
DECLARE @intTotalLiveArticles int
DECLARE @intTotalPrivateArticles int
DECLARE @intTotalLiveComments int
DECLARE @intTotalPrivateomments int
DECLARE @intOverdueArticles int
DECLARE @intDueForReview int
DECLARE @intAssignedToMe int


IF (@intTabID = 0) -- general stats
BEGIN

	SET @intTotalCategories = (SELECT COUNT(CategoryID) FROM InstantKB_Categories (nolock))
	SET @intTotalLiveArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.ArticleAccessType = 1))
	SET @intTotalPrivateArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.ArticleAccessType = 2))
	SET @intTotalLiveComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE (InstantKB_ArticleComments.AccessType = 1))
	SET @intTotalPrivateomments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE (InstantKB_ArticleComments.AccessType = 2))
	SET @intOverdueArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.ArticleDueDate >= DATEADD(day,-90,GetDate()) AND InstantKB_Articles.ArticleDueDate <= GetDate()))
	SET @intDueForReview = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.ArticleReviewDate >= DATEADD(day,-90,GetDate()) AND InstantKB_Articles.ArticleReviewDate <= GetDate()))
	SET @intAssignedToMe = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.ArticleAssignedUserID = @intUserID))

END
ELSE -- rab specific stats
BEGIN

	SET @intTotalCategories = (SELECT COUNT(CategoryID) FROM InstantKB_Categories (nolock) WHERE (InstantKB_Categories.TabID = @intTabID))
	SET @intTotalLiveArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.TabID = @intTabID AND InstantKB_Articles.ArticleAccessType = 1))
	SET @intTotalPrivateArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.TabID = @intTabID AND InstantKB_Articles.ArticleAccessType = 2))	
	SET @intTotalLiveComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments (nolock)  INNER JOIN InstantKB_Articles ON InstantKB_ArticleComments.ArticleID = InstantKB_Articles.ArticleID WHERE (InstantKB_Articles.TabID = @intTabID AND InstantKB_ArticleComments.AccessType = 1))
	SET @intTotalPrivateomments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments (nolock)  INNER JOIN InstantKB_Articles ON InstantKB_ArticleComments.ArticleID = InstantKB_Articles.ArticleID WHERE (InstantKB_Articles.TabID = @intTabID AND InstantKB_ArticleComments.AccessType = 2))
	SET @intOverdueArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.TabID = @intTabID AND InstantKB_Articles.ArticleDueDate <= GetDate()))
	SET @intDueForReview = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.TabID = @intTabID AND (InstantKB_Articles.ArticleReviewDate >= DATEADD(day,-90,GetDate()) AND InstantKB_Articles.ArticleReviewDate <= GetDate())))
	SET @intAssignedToMe = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.TabID = @intTabID AND (InstantKB_Articles.ArticleDueDate >= DATEADD(day,-90,GetDate()) AND InstantKB_Articles.ArticleAssignedUserID <= @intUserID)))

END

SELECT
@intTotalCategories As TotalCategories,
@intTotalLiveArticles As TotalLiveArticles, 
@intTotalPrivateArticles As TotalPrivateArticles,
@intTotalLiveComments As TotalLiveComments,
@intTotalPrivateomments As TotalPrivateComments,
@intOverdueArticles As OverdueArticles,
@intDueForReview As DueForReview,
@intAssignedToMe As AssignedToMe
GO
----------------------------------------------------
-- ikb_sp_SelectStatisticsForUser
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectStatisticsForUser (
@intUserID int
)
AS

SET NOCOUNT ON 

/* Select statistics for a single user within the knowledgebase */


DECLARE @intTotalLiveComments int
DECLARE @intTotalPrivateComments int


SET @intTotalLiveComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE (UserID = @intUserID AND AccessType = 1))
SET @intTotalPrivateComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE (UserID = @intUserID AND AccessType = 2))


SELECT @intTotalLiveComments As TotalLiveComments, @intTotalPrivateComments As TotalPrivateComments
GO
----------------------------------------------------
-- ikb_sp_SelectStatisticsForUsers
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectStatisticsForUsers
AS

SET NOCOUNT ON 

/* Select essential statistics from the application */

-- setup member information

DECLARE @intTotalMembers int
DECLARE @intLatestMemberUserID int
DECLARE @strLatestMemberUsername nvarchar(255)
DECLARE @dtLatestMemberJoined datetime

SET @intTotalMembers = (SELECT COUNT(UserID) FROM InstantASP_Users (nolock))
SET @intLatestMemberUserID = (SELECT MAX(UserID) FROM InstantASP_Users (nolock))
SET @strLatestMemberUsername = (SELECT Username FROM InstantASP_Users (nolock) WHERE UserID = @intLatestMemberUserID)
SET @dtLatestMemberJoined = (SELECT CreatedDate FROM InstantASP_Users (nolock) WHERE UserID = @intLatestMemberUserID)

-- setup knowledge base information

DECLARE @intTotallLiveKnowledgeBaseArticles int
DECLARE @intTotalLiveTroubleshottingGuides int
DECLARE @intTotalLiveDownloads int
DECLARE @intTotalLiveComments int

SET @intTotallLiveKnowledgeBaseArticles = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.TabID = 1 AND InstantKB_Articles.ArticleAccessType = 1))
SET @intTotalLiveTroubleshottingGuides = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.TabID = 2 AND InstantKB_Articles.ArticleAccessType = 1))
SET @intTotalLiveDownloads = (SELECT COUNT(ArticleID) FROM InstantKB_Articles (nolock) WHERE (InstantKB_Articles.TabID = 3 AND InstantKB_Articles.ArticleAccessType = 1))
SET @intTotalLiveComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments (nolock) WHERE (InstantKB_ArticleComments.AccessType = 1))

SELECT @intTotalMembers As TotalMembers,@intLatestMemberUserID As LatestMemberUserID, @strLatestMemberUsername As LatestMemberUsername, @dtLatestMemberJoined As LatestMemberJoined, 
@intTotallLiveKnowledgeBaseArticles As TotalLiveKnowledgeBaseArticles, @intTotalLiveTroubleshottingGuides As TotalLiveTroubleshootingGuides, @intTotalLiveDownloads As TotalLiveDownloads, @intTotalLiveComments As TotalLiveComments
GO
----------------------------------------------------
-- ikb_sp_SelectStatisticsStaff
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectStatisticsStaff (
@dtCurrentDateTime datetime
)
AS

SET NOCOUNT ON 

/* Select staff statisics */

DECLARE @intTotalKnowledgebaseComments int
DECLARE @intTotalLiveKnowledgebaseComments int

-- total comment counts
SET @intTotalKnowledgebaseComments = (SELECT COUNT(InstantKB_Articles.ArticleID) 
FROM InstantKB_Articles JOIN InstantKB_ArticleComments ON InstantKB_Articles.ArticleID = InstantKB_ArticleComments.ArticleID WHERE InstantKB_Articles.TabID = 1)
SET @intTotalLiveKnowledgebaseComments = (SELECT COUNT(InstantKB_Articles.ArticleID) 
FROM InstantKB_Articles JOIN InstantKB_ArticleComments ON InstantKB_Articles.ArticleID = InstantKB_ArticleComments.ArticleID WHERE InstantKB_Articles.TabID = 1 AND InstantKB_ArticleComments.AccessType = 1)

-- create select list

SELECT @intTotalKnowledgebaseComments As TotalKnowledgebaseComments,
@intTotalLiveKnowledgebaseComments As TotalLiveKnowledgebaseComments
GO
----------------------------------------------------
-- ikb_sp_SelectStatus
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectStatus 
AS

SET NOCOUNT ON 

SELECT * FROM InstantKB_Status ORDER BY StatusSortOrder ASC
GO
----------------------------------------------------
-- ikb_sp_SelectTabRoles
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectTabRoles (
@intTabID int
)
AS

SET NOCOUNT ON 

/* Select the roles associated with a tab from the InstantKB_TabRoles table */

SELECT InstantASP_Roles.* FROM InstantKB_TabRoles INNER JOIN 
InstantASP_Roles ON InstantKB_TabRoles.RoleID = InstantASP_Roles.RoleID 
WHERE (InstantKB_TabRoles.TabID = @intTabID)
GO
----------------------------------------------------
-- ikb_sp_SelectTabs
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectTabs 
AS

SET NOCOUNT ON 

/* Select all tabs from the InstantKB_tabs table */

SELECT * FROM InstantKB_Tabs ORDER BY InstantKB_Tabs.SortOrder ASC
GO
----------------------------------------------------
-- ikb_sp_SelectTabsByUserID
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectTabsByUserID (
@intUserID int
) AS
SET NOCOUNT ON 

/* Select tabs associated with the same roles as user */

-- filter tabs based on roles
IF (@intUserID = 0) -- anonymous users
BEGIN

	SELECT InstantKB_Tabs.* FROM InstantKB_Tabs (nolock) WHERE 
	EXISTS (SELECT InstantKB_TabRoles.RoleID FROM InstantKB_TabRoles WHERE InstantKB_TabRoles.TabID = InstantKB_Tabs.TabID AND InstantKB_TabRoles.RoleID IN 
	(SELECT InstantASP_Roles.RoleID FROM InstantASP_Roles WHERE InstantASP_Roles.AnonymousRole = 1)) ORDER BY InstantKB_Tabs.SortOrder ASC

END
ELSE IF (@intUserID > 0) -- authenticated users
BEGIN

	SELECT InstantKB_Tabs.* FROM InstantKB_Tabs (nolock) WHERE 
	EXISTS (SELECT InstantKB_TabRoles.RoleID FROM InstantKB_TabRoles WHERE InstantKB_TabRoles.TabID = InstantKB_Tabs.TabID AND InstantKB_TabRoles.RoleID IN 
	(SELECT InstantASP_Roles.RoleID FROM InstantASP_UsersRoles INNER JOIN
	InstantASP_Roles ON InstantASP_UsersRoles.RoleID = InstantASP_Roles.RoleID WHERE (InstantASP_UsersRoles.UserID = @intUserID))) ORDER BY InstantKB_Tabs.SortOrder ASC

END
GO
----------------------------------------------------
-- ikb_sp_SelectTicketFolders
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectTicketFolders (
@intUserID int
) AS

SET NOCOUNT ON 

/* Returns all available ticket folders for a user */

SELECT InstantKB_TicketFolders.*  FROM InstantKB_TicketFolders (nolock) WHERE (UserID = @intUserID) ORDER BY SortOrder ASC
GO
----------------------------------------------------
-- ikb_sp_SelectTroubleshooterSteps
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectTroubleshooterSteps (
@intArticleID int
)
AS

SET NOCOUNT ON 

/* Select all troubleshooter steps for a specific article from InstantKB_TroubleshooterSteps */

SELECT * FROM InstantKB_TroubleshooterSteps WHERE ArticleID = @intArticleID ORDER BY SortOrder ASC
GO
----------------------------------------------------
-- ikb_sp_SelectTypes
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectTypes 
AS

SET NOCOUNT ON 

SELECT * FROM InstantKB_Types ORDER BY TypeSortOrder ASC
GO
----------------------------------------------------
-- ikb_sp_SelectUserByUserID
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectUserByUserID (
@intUserID int
) AS

SET NOCOUNT ON 

/* Select general user information within first record set */
SELECT InstantKB_Users.* FROM InstantKB_Users  (nolock) WHERE (InstantKB_Users.UserID = @intUserID)

/* Select tabs for user within second record set */
EXEC ikb_sp_SelectTabsByUserID @intUserID

/* Select departments for user in third record set */
EXEC ikb_sp_SelectDepartmentsByUserID @intUserID
GO
----------------------------------------------------
-- ikb_sp_SelectUserLevels
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectUserLevels
AS

SET NOCOUNT ON 

SELECT * FROM InstantKB_UserLevels ORDER BY InstantKB_UserLevels.RecognitionPoints ASC
GO
----------------------------------------------------
-- ikb_sp_SelectUsersPaged
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectUsersPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	UserID int
)

-- insert data 
INSERT INTO #PageIndex (UserID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT  InstantASP_Users.*, InstantKB_Users.*, InstantASP_Roles.RoleName, InstantASP_Roles.OpenMarkUp, InstantASP_Roles.CloseMarkUp FROM #PageIndex IPI 
INNER JOIN InstantKB_Users ON InstantKB_Users.UserID = IPI.UserID  
INNER JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID
INNER JOIN InstantASP_Roles ON InstantASP_Users.PrimaryRoleID = InstantASP_Roles.RoleID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- ikb_sp_SelectWhosOn
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectWhosOn (
@intCategoryID int,
@intArticleID int
)
AS
SET NOCOUNT ON 
/* If have a article ID then only return information for specific article */
IF (@intArticleID > 0)
BEGIN
	SELECT InstantKB_WhosOn.Username, InstantKB_WhosOn.CurrentTask, InstantKB_WhosOn.UserID, InstantASP_Roles.OpenMarkUp, InstantASP_Roles.CloseMarkUp, InstantKB_WhosOn.IsAnonymous, 
	InstantKB_WhosOn.DateStamp, InstantKB_WhosOn.CategoryID, InstantKB_WhosOn.CategoryName, InstantKB_WhosOn.ArticleID, InstantKB_WhosOn.ArticleTitle, InstantKB_WhosOn.IPAddress 
	FROM InstantKB_WhosOn (nolock) LEFT OUTER JOIN InstantASP_Roles ON InstantKB_WhosOn.PrimaryRoleID = InstantASP_Roles.RoleID
	WHERE InstantKB_WhosOn.ArticleID = @intArticleID ORDER BY InstantKB_WhosOn.DateStamp DESC
END
/* If have a category ID then only return information for specific category */
ELSE IF (@intCategoryID > 0)
BEGIN
	SELECT InstantKB_WhosOn.Username, InstantKB_WhosOn.CurrentTask, InstantKB_WhosOn.UserID, InstantASP_Roles.OpenMarkUp, InstantASP_Roles.CloseMarkUp, InstantKB_WhosOn.IsAnonymous, 
	InstantKB_WhosOn.DateStamp, InstantKB_WhosOn.CategoryID, InstantKB_WhosOn.CategoryName, InstantKB_WhosOn.ArticleID, InstantKB_WhosOn.ArticleTitle, InstantKB_WhosOn.IPAddress 
	FROM InstantKB_WhosOn (nolock) LEFT OUTER JOIN InstantASP_Roles ON InstantKB_WhosOn.PrimaryRoleID = InstantASP_Roles.RoleID
	WHERE InstantKB_WhosOn.CategoryID = @intCategoryID ORDER BY InstantKB_WhosOn.DateStamp DESC
END
ELSE
/* Return all Who's On Information */
BEGIN
	SELECT InstantKB_WhosOn.Username, InstantKB_WhosOn.CurrentTask, InstantKB_WhosOn.UserID, InstantASP_Roles.OpenMarkUp, InstantASP_Roles.CloseMarkUp, InstantKB_WhosOn.IsAnonymous, 
	InstantKB_WhosOn.DateStamp, InstantKB_WhosOn.CategoryID, InstantKB_WhosOn.CategoryName, InstantKB_WhosOn.ArticleID, InstantKB_WhosOn.ArticleTitle, InstantKB_WhosOn.IPAddress 
	FROM InstantKB_WhosOn (nolock) LEFT OUTER JOIN InstantASP_Roles ON InstantKB_WhosOn.PrimaryRoleID = InstantASP_Roles.RoleID
	ORDER BY InstantKB_WhosOn.DateStamp DESC
END
GO
----------------------------------------------------
-- ikb_sp_SelectWorkflowDepartments
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectWorkflowDepartments 
AS

SET NOCOUNT ON 

SELECT InstantKB_Departments.*, InstantKB_WorkFlowDepartments.WorkFlowID  FROM InstantKB_Departments 
JOIN InstantKB_WorkFlowDepartments ON InstantKB_Departments.DepartmentID = InstantKB_WorkFlowDepartments.DepartmentID 
ORDER BY InstantKB_Departments.SortOrder ASC
GO
----------------------------------------------------
-- ikb_sp_SelectWorkFlows
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectWorkFlows (
@intUserID int
)
AS

SET NOCOUNT ON 

/* Select categories that are associated with the same roles as user */
DECLARE @SQL nvarchar(3000)

SELECT @SQL = 'SELECT InstantKB_WorkFlows.* FROM InstantKB_WorkFlows (nolock) '

IF (@intUserID >= 0)
BEGIN

	SELECT @SQL = @SQL + ' WHERE EXISTS (SELECT InstantKB_WorkFlowDepartments.DepartmentID FROM InstantKB_WorkFlowDepartments 
	WHERE InstantKB_WorkFlowDepartments.WorkFlowID = InstantKB_WorkFlows.WorkFlowID AND InstantKB_WorkFlowDepartments.DepartmentID IN '

	IF (@intUserID = 0) -- anonymous users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantKB_Departments.DepartmentID FROM InstantKB_Departments WHERE InstantKB_Departments.IsDefault = 1)'
	END
	ELSE IF (@intUserID > 0) -- authenticated users
	BEGIN
		SELECT @SQL = @SQL + '(SELECT InstantKB_Departments.DepartmentID FROM InstantKB_UserDepartments INNER JOIN
		InstantKB_Departments ON InstantKB_UserDepartments.DepartmentID = InstantKB_Departments.DepartmentID WHERE (InstantKB_UserDepartments.UserID = ' + CAST(@intUserID As nVarChar(20)) + '))'
	END
	SELECT @SQL = @SQL + ') '
END

SELECT @SQL = @SQL + 'ORDER BY InstantKB_WorkFlows.DAteStamp DESC'

-- ensure we use sp_executesql to cache execution plan for dynamic query
EXECUTE sp_executesql @SQL
GO
----------------------------------------------------
-- ikb_sp_SelectWorkFlowsPaged
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectWorkFlowsPaged (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	WorkFlowID int
)

-- insert data 
INSERT INTO #PageIndex (WorkFlowID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantKB_WorkFlows.* FROM #PageIndex IPI JOIN InstantKB_WorkFlows ON InstantKB_WorkFlows.WorkFlowID = IPI.WorkFlowID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount
GO
----------------------------------------------------
-- ikb_sp_SelectWorkFlowStepNextSteps
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectWorkFlowStepNextSteps (
@intWorkFlowStepID int
)
AS

SET NOCOUNT ON 

/* Select the next steps associated with a workflow step */

SELECT InstantKB_WorkFlowSteps.* FROM InstantKB_WorkFlowStepsNextSteps INNER JOIN InstantKB_WorkFlowSteps ON InstantKB_WorkFlowStepsNextSteps.WorkFlowNextStepID = InstantKB_WorkFlowSteps.WorkFlowStepID
WHERE (InstantKB_WorkFlowStepsNextSteps.WorkFlowStepID = @intWorkFlowStepID) ORDER BY InstantKB_WorkFlowSteps.SortOrder ASC
GO
----------------------------------------------------
-- ikb_sp_SelectWorkFlowSteps
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_SelectWorkFlowSteps
AS

SET NOCOUNT ON 

SELECT * FROM InstantKB_WorkFlowSteps  ORDER BY SortOrder ASC
GO
----------------------------------------------------
-- ikb_sp_UpdateArticleAccessType
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateArticleAccessType (
@intArticleID int,
@intAccessType tinyint
)
AS

SET NOCOUNT ON 

/*Updates a articles access type within InstantKB)InstantKB_Articles */

UPDATE InstantKB_Articles SET ArticleAccessType = @intAccessType WHERE (InstantKB_Articles.ArticleID = @intArticleID)
GO
----------------------------------------------------
-- ikb_sp_UpdateArticleAttachmentCount
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateArticleAttachmentCount (
@intArticleID int,
@intOperator int
)
AS
SET NOCOUNT ON 

/* Ensure we have a article identity */
IF (@intArticleID > 0)
BEGIN
	/* Increments article view count */
	UPDATE InstantKB_Articles SET InstantKB_Articles.AttachmentCount =  InstantKB_Articles.AttachmentCount + @intOperator WHERE (InstantKB_Articles.ArticleID = @intArticleID)
END
GO
----------------------------------------------------
-- ikb_sp_UpdateArticleCommentAccessType
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateArticleCommentAccessType (
@intCommentID int,
@intAccessType tinyint
)
AS

SET NOCOUNT ON 

/*Updates a comments access type within InstantKB)InstantKB_ArticleComments */

UPDATE InstantKB_ArticleComments SET AccessType = @intAccessType WHERE (InstantKB_ArticleComments.CommentID = @intCommentID)

-- update article to indicate comments
DECLARE @intArticleID int
DECLARE @intTotalComments int
SET @intArticleID = (SELECT ArticleID FROM InstantKB_ArticleComments WHERE InstantKB_ArticleComments.CommentID = @intCommentID)
SET @intTotalComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE InstantKB_ArticleComments.ArticleID = @intArticleID AND AccessType = 1)
UPDATE InstantKB_Articles SET InstantKB_Articles.CommentCount = @intTotalComments WHERE (InstantKB_Articles.ArticleID = @intArticleID)
GO
----------------------------------------------------
-- ikb_sp_UpdateArticleCommentRating
----------------------------------------------------
GO
CREATE Procedure ikb_sp_UpdateArticleCommentRating (
@intCommentID int
) AS

SET NOCOUNT ON 

-- counts
DECLARE @intTotalVotes int
DECLARE @intMarkedAsHelpful int

SET @intTotalVotes = (SELECT COUNT(InstantKB_ArticleCommentRatings.CommentRatingID) FROM InstantKB_ArticleCommentRatings (nolock) WHERE (InstantKB_ArticleCommentRatings.CommentID = @intCommentID))
SET @intMarkedAsHelpful =  (SELECT COUNT(InstantKB_ArticleCommentRatings.CommentRatingID) FROM InstantKB_ArticleCommentRatings (nolock) WHERE (InstantKB_ArticleCommentRatings.CommentID = @intCommentID AND Helpful = 1))

-- update articles table
UPDATE InstantKB_ArticleComments SET MarkedAsHelpful = @intMarkedAsHelpful, TotalVotes = @intTotalVotes WHERE (InstantKB_ArticleComments.CommentID = @intCommentID)
GO
----------------------------------------------------
-- ikb_sp_UpdateArticleRatingMeanNumber
----------------------------------------------------
GO
CREATE Procedure ikb_sp_UpdateArticleRatingMeanNumber (
@intArticleID int
) AS

SET NOCOUNT ON 

-- counts
DECLARE @intTotalVotes int
DECLARE @intTotalRating int

SET @intTotalVotes = (SELECT COUNT(InstantKB_ArticleRatings.ArticleRatingID) FROM InstantKB_ArticleRatings (nolock) WHERE (InstantKB_ArticleRatings.ArticleID = @intArticleID))
SET @intTotalRating =  (SELECT SUM(InstantKB_ArticleRatings.ArticleRating) FROM InstantKB_ArticleRatings (nolock) WHERE (InstantKB_ArticleRatings.ArticleID = @intArticleID))

IF (@intTotalVotes = null)
BEGIN
	SET @intTotalVotes = 0
END


IF (@intTotalRating = null)
BEGIN
	SET @intTotalRating = 0
END

-- mean number
DECLARE @intRating int
IF(@intTotalVotes > 0)
BEGIN
	SET @intRating = (@intTotalRating / @intTotalVotes)
END
ELSE
BEGIN
	SET @intRating = 0
END

-- update articles table
UPDATE InstantKB_Articles SET ArticleRating = @intRating, TotalRatings = @intTotalVotes WHERE (ArticleID = @intArticleID)
GO
----------------------------------------------------
-- ikb_sp_UpdateArticleViewCount
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateArticleViewCount (
@intArticleID int,
@intOperator int
)
AS
SET NOCOUNT ON 

/* Ensure we have a article identity */
IF (@intArticleID > 0)
BEGIN
	/* Increments article view count */
	UPDATE InstantKB_Articles SET InstantKB_Articles.ArticleViews =  InstantKB_Articles.ArticleViews + @intOperator WHERE (InstantKB_Articles.ArticleID = @intArticleID)
END
GO
----------------------------------------------------
-- ikb_sp_UpdateAttachmentPassword
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateAttachmentPassword (
@intAttachmentID int,
@strPassword nvarchar(255)
)
AS

SET NOCOUNT ON 

/* Updates an attachments password within InstantKB_Attachments */
 
UPDATE InstantKB_Attachments SET 
InstantKB_Attachments.Password = @strPassword 
WHERE AttachmentID = @intAttachmentID
GO
----------------------------------------------------
-- ikb_sp_UpdateAttachmentViewCount
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateAttachmentViewCount (
@intAttachmentID int,
@intIncrement int
)
AS

SET NOCOUNT ON 

/* Updates an attachments view count, typically called when a user requests an attachment */
 
UPDATE InstantKB_Attachments SET 
InstantKB_Attachments.[Views] = InstantKB_Attachments.[Views] + @intIncrement 
WHERE AttachmentID = @intAttachmentID
GO
----------------------------------------------------
-- ikb_sp_UpdateCategorySortOrder
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateCategorySortOrder (
@intCategoryID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a category sort order within InstantKB_Categories */

UPDATE InstantKB_Categories SET InstantKB_Categories.CategorySortOrder = @intSortOrder WHERE (InstantKB_Categories.CategoryID = @intCategoryID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_UpdateDepartmentPermissionID
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateDepartmentPermissionID (
@intDepartmentID int,
@intPermissionID  int
)
AS
SET NOCOUNT ON 

/* Updates the permission id fields for a specific department */

UPDATE InstantKB_Departments SET InstantKB_Departments.PermissionID =  @intPermissionID WHERE (InstantKB_Departments.DepartmentID = @intDepartmentID)
GO
----------------------------------------------------
-- ikb_sp_UpdateLevelSortOrder
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateLevelSortOrder (
@intLevelID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a level sort order within InstantKB_Levels */

UPDATE InstantKB_Levels SET LevelSortOrder = @intSortOrder WHERE (InstantKB_Levels.LevelID = @intLevelID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_UpdateNotes
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateNotes (
@strStaffNotes ntext,
@strAdminNotes ntext
)
AS
SET NOCOUNT ON 

/* Update staff & admin notes */


DECLARE @intCount int
SET @intCount = (SELECT COUNT(NoteID) FROM InstantKB_Notes)

IF  (@intCount = 0)
BEGIN
	INSERT INTO InstantKB_Notes (StaffNotes, AdminNotes) VALUES (@strStaffNotes, @strAdminNotes)
END
ELSE
BEGIN
	UPDATE InstantKB_Notes SET StaffNotes = @strStaffNotes, AdminNotes = @strAdminNotes
END
GO
----------------------------------------------------
-- ikb_sp_UpdatePrioritySortOrder
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdatePrioritySortOrder (
@intPriorityID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a priority sort order within InstantKB_Priorities */

UPDATE InstantKB_Priorities SET PrioritySortOrder = @intSortOrder WHERE (InstantKB_Priorities.PriorityID = @intPriorityID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_UpdateRecognitionPoints
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateRecognitionPoints (
@intUserID int,
@intIncrement int
)
AS

SET NOCOUNT ON 

/* Updates a members  recognition points within InstantKB_Users */
 
DECLARE @intCurrentPoints int
SET @intCurrentPoints = (SELECT RecognitionPoints FROM InstantKB_Users WHERE (UserID = @intUserID))

DECLARE @intNewValue int
SET @intNewValue = @intCurrentPoints + @intIncrement

IF (@intNewValue < 0)
	SET @intNewValue = 0

UPDATE InstantKB_Users SET 
InstantKB_Users.RecognitionPoints = @intNewValue 
WHERE (InstantKB_Users.UserID = @intUserID)
GO
----------------------------------------------------
-- ikb_sp_UpdateStatusSortOrder
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateStatusSortOrder (
@intStatusID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a status sort order within InstantKB_Types */

UPDATE InstantKB_Status SET StatusSortOrder = @intSortOrder WHERE (InstantKB_Status.StatusID = @intStatusID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_UpdateTabSortOrder
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateTabSortOrder (
@intTabID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a tabs sort order within InstantKB_Tabs */

UPDATE InstantKB_Tabs SET SortOrder = @intSortOrder WHERE (InstantKB_Tabs.TabID = @intTabID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_UpdateTicketViewCount
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateTicketViewCount (
@intTicketID int,
@intOperator int
)
AS
SET NOCOUNT ON 

/* Ensure we have a ticket identity */
IF (@intTicketID > 0)
BEGIN
	/* Increments ticket view count */
	UPDATE InstantKB_Tickets SET InstantKB_Tickets.TicketViews =  InstantKB_Tickets.TicketViews + @intOperator WHERE (InstantKB_Tickets.TicketId = @intTicketID)
END
GO
----------------------------------------------------
-- ikb_sp_UpdateTroubleshooterStepSortOrder
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateTroubleshooterStepSortOrder (
@intStepID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a troubleshooter step sort order within InstantKB_TtroubleshooterSteps */

UPDATE InstantKB_TroubleshooterSteps SET InstantKB_TroubleshooterSteps.SortOrder = @intSortOrder WHERE (InstantKB_TroubleshooterSteps.StepID = @intStepID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_UpdateTypeSortOrder
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateTypeSortOrder (
@intTypeID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a types sort order within InstantKB_Types */

UPDATE InstantKB_Types SET TypeSortOrder = @intSortOrder WHERE (InstantKB_Types.TypeID = @intTypeID)

RETURN
GO
----------------------------------------------------
-- ikb_sp_UpdateWorkFlowStepChangeActions
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateWorkFlowStepChangeActions (
@intWorkFlowStepID int,
@strChangeActionsXml ntext
)
AS

SET NOCOUNT ON 

/* Updates the change actions XML for work flow steps within InstantKB_WorkFlowSteps */

UPDATE InstantKB_WorkFlowSteps SET ChangeActionsXml = @strChangeActionsXml WHERE (WorkFlowStepID = @intWorkFlowStepID)
GO
----------------------------------------------------
-- ikb_sp_UpdateWorkFlowStepEditUserIDs
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateWorkFlowStepEditUserIDs (
@intWorkFlowStepID int,
@strEditUserIds nvarchar(750)
)
AS

SET NOCOUNT ON 

/* Updates the staff members who can edit content in this workflow step */

UPDATE InstantKB_WorkFlowSteps SET EditUserIDs = @strEditUserIds WHERE (WorkFlowStepID = @intWorkFlowStepID)
GO
----------------------------------------------------
-- ikb_sp_UpdateWorkFlowStepFieldTemplate
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateWorkFlowStepFieldTemplate (
@intWorkFlowStepID int,
@intFieldTemplateID int
)
AS

SET NOCOUNT ON 

/* Updates the field template for work flow steps within InstantKB_WorkFlowSteps */

UPDATE InstantKB_WorkFlowSteps SET FieldTemplateID = @intFieldTemplateID WHERE (WorkFlowStepID = @intWorkFlowStepID)
GO
----------------------------------------------------
-- ikb_sp_UpdateWorkFlowStepSortOrder
----------------------------------------------------
GO
CREATE PROCEDURE ikb_sp_UpdateWorkFlowStepSortOrder (
@intWorkFlowStepID int,
@intSortOrder int
) AS
SET NOCOUNT ON 

/* Updates a workflow step sort order within InstantKB_Tabs */

UPDATE InstantKB_WorkFlowSteps SET SortOrder = @intSortOrder WHERE (InstantKB_WorkFlowSteps.WorkFlowStepID = @intWorkFlowStepID)

RETURN
GO

/******************************************************
  Stored procedures  End
******************************************************/
GO
/******************************************************
  Indexes  Begin
******************************************************/
GO
CREATE NONCLUSTERED INDEX IX_InstantKB_Categories_TabID ON InstantKB_Categories ( TabID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_Tabs_SortOrder ON InstantKB_Tabs ( SortOrder ) 
WITH FILLFACTOR = 60

GO
CREATE NONCLUSTERED INDEX IX_InstantASP_UsersRoles_UserID ON InstantASP_UsersRoles ( UserID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_ArticleCommentRatings ON InstantKB_ArticleCommentRatings ( CommentID,UserID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_ArticleComments_ArticleID ON InstantKB_ArticleComments ( ArticleID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_ArticleRelatedArticles ON InstantKB_ArticleRelatedArticles ( ArticleID,RelatedArticleID ) 
WITH FILLFACTOR = 60

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_ArticleRelatedLinks ON InstantKB_ArticleRelatedLinks ( ArticleID ) 
WITH FILLFACTOR = 60

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_Articles ON InstantKB_Articles ( TabID,ArticleCategoryID,ArticleAssignedUserID,ArticleAccessType,ArticleCreatedUserID,ArticleWorkFlowStepID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_Attachments ON InstantKB_Attachments ( RelatedEntityID,UserID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_WorkFlowSteps_WorkFlowID ON InstantKB_WorkFlowSteps ( WorkFlowID ) 
WITH FILLFACTOR = 50

GO
CREATE NONCLUSTERED INDEX IX_InstantASP_Fields_ApplicationID ON InstantASP_Fields ( ApplicationID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantASP_Fields_TabID ON InstantASP_Fields ( TabID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_Levels_LevelTabID ON InstantKB_Levels ( LevelTabID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_Notifications_UserID ON InstantKB_Notifications ( UserID ) 
WITH FILLFACTOR = 50

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_Priorities_PriorityTabID ON InstantKB_Priorities ( PriorityTabID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_TroubleshooterSteps ON InstantKB_TroubleshooterSteps ( ArticleID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_Types_TypeTabID ON InstantKB_Types ( TypeTabID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantASP_UsersRoles_RoleID ON InstantASP_UsersRoles ( RoleID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_ArticleRoles_ArticleID ON InstantKB_ArticleRoles ( ArticleID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_CategoryRoles_CategoryID ON InstantKB_CategoryRoles ( CategoryID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_Notifications_RelatedEntityID ON InstantKB_Notifications ( RelatedEntityID ) 
WITH FILLFACTOR = 50

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_TabRoles_TabID ON InstantKB_TabRoles ( TabID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_UserDepartments_UserID ON InstantKB_UserDepartments ( UserID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_WorkFlowDepartments_WorkFlowID ON InstantKB_WorkFlowDepartments ( WorkFlowID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_WorkFlows_TabID ON InstantKB_WorkFlows ( TabID ) 
WITH FILLFACTOR = 50

GO
CREATE NONCLUSTERED INDEX IX_InstantASP_FieldTemplates ON InstantASP_FieldTemplates ( ApplicationID,TabID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_ArticleComments_AccessType ON InstantKB_ArticleComments ( AccessType ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_ArticleRead ON InstantKB_ArticleRead ( ArticleReadArticleID ) 
WITH FILLFACTOR = 10

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_ArticleRoles_RoleID ON InstantKB_ArticleRoles ( RoleID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_CategoryRoles_RoleID ON InstantKB_CategoryRoles ( RoleID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_DataViews_UserID ON InstantKB_DataViews ( UserID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_PermissionSetsTabs ON InstantKB_PermissionSetsTabs ( TabID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_StaffPermissionSetsTabs_TabID ON InstantKB_StaffPermissionSetsTabs ( TabID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_Status_StatusName_StatusTabID ON InstantKB_Status ( StatusTabID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_TabRoles_RoleID ON InstantKB_TabRoles ( RoleID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_UserDepartments_DepartmentID ON InstantKB_UserDepartments ( DepartmentID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_WorkFlowDepartments_DepartmentID ON InstantKB_WorkFlowDepartments ( DepartmentID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_ArticleComments_UserID ON InstantKB_ArticleComments ( UserID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_ArticleRatings ON InstantKB_ArticleRatings ( ArticleID,UserID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantASP_Tags_RelatedEntityID ON InstantASP_Tags ( RelatedEntityID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantASP_FieldTemplateDetails ON InstantASP_FieldTemplateDetails ( FieldTemplateID ) 
WITH FILLFACTOR = 40

GO
CREATE NONCLUSTERED INDEX IX_InstantASP_Tags_ApplicationID ON InstantASP_Tags ( ApplicationID ) 
WITH FILLFACTOR = 30

GO
CREATE NONCLUSTERED INDEX IX_InstantKB_WhosOn_SessionIdentity ON InstantKB_WhosOn ( SessionIdentity ) 
WITH FILLFACTOR = 10

GO

/******************************************************
  Indexes  End
******************************************************/
GO

-----------------------------------------------------------
--Insert data into InstantASP_Roles
-----------------------------------------------------------

DELETE FROM InstantASP_Roles
GO

IF (IDENT_SEED('InstantASP_Roles') IS NOT NULL )	SET IDENTITY_INSERT InstantASP_Roles ON

INSERT INTO InstantASP_Roles (RoleID,RoleName,RoleVisible,OpenMarkup,CloseMarkup,AnonymousRole,ActivationRole,MemberRole,ModeratorRole,AdministratorRole,BannedRole,RequiredRole) VALUES('1','Anonymous / Guest',1,'','',1,0,0,0,0,0,1)
INSERT INTO InstantASP_Roles (RoleID,RoleName,RoleVisible,OpenMarkup,CloseMarkup,AnonymousRole,ActivationRole,MemberRole,ModeratorRole,AdministratorRole,BannedRole,RequiredRole) VALUES('2','Registered Member',1,'','',0,0,1,0,0,0,1)
INSERT INTO InstantASP_Roles (RoleID,RoleName,RoleVisible,OpenMarkup,CloseMarkup,AnonymousRole,ActivationRole,MemberRole,ModeratorRole,AdministratorRole,BannedRole,RequiredRole) VALUES('3','Awaiting Activation',1,'<font color=''#A2A2A2''>','</font>',0,1,0,0,0,0,1)
INSERT INTO InstantASP_Roles (RoleID,RoleName,RoleVisible,OpenMarkup,CloseMarkup,AnonymousRole,ActivationRole,MemberRole,ModeratorRole,AdministratorRole,BannedRole,RequiredRole) VALUES('4','Moderator / Staff',1,'<b><i>','</i></b>',0,0,0,1,0,0,1)
INSERT INTO InstantASP_Roles (RoleID,RoleName,RoleVisible,OpenMarkup,CloseMarkup,AnonymousRole,ActivationRole,MemberRole,ModeratorRole,AdministratorRole,BannedRole,RequiredRole) VALUES('5','Administrator',1,'<b>','</b>',0,0,0,0,1,0,1)
INSERT INTO InstantASP_Roles (RoleID,RoleName,RoleVisible,OpenMarkup,CloseMarkup,AnonymousRole,ActivationRole,MemberRole,ModeratorRole,AdministratorRole,BannedRole,RequiredRole) VALUES('6','Banned Member',0,'<strike>','</strike>',0,0,0,0,0,1,1)

IF (IDENT_SEED('InstantASP_Roles') IS NOT NULL )	SET IDENTITY_INSERT InstantASP_Roles OFF

GO


-----------------------------------------------------------
--Insert data into InstantASP_IgnoredSearchTerms
-----------------------------------------------------------

DELETE FROM InstantASP_IgnoredSearchTerms WHERE ApplicationID = 2


IF (IDENT_SEED('InstantASP_IgnoredSearchTerms') IS NOT NULL )	SET IDENTITY_INSERT InstantASP_IgnoredSearchTerms ON

INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('1','2','\band\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('2','2','\bof\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('3','2','\bthe\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('4','2','\bthis\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('5','2','\bthat\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('6','2','\ban\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('7','2','\ba\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('8','2','\bon\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('9','2','\bhave\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('10','2','\bfrom\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('11','2','\bjust\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('12','2','\bour\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('13','2','\bhas\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('14','2','\bhave\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('15','2','\bvery\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('16','2','\bare\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('17','2','\bto\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('18','2','\bwill\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('19','2','\bthem\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('20','2','\bso\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('21','2','\bsome\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('22','2','\bwhere\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('23','2','\bsee\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('24','2','\bwe\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('25','2','\buse\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('26','2','\bor\b')
INSERT INTO InstantASP_IgnoredSearchTerms (IgnoredSearchTermID,ApplicationID, SearchText) VALUES('27','2','\band\b')

IF (IDENT_SEED('InstantASP_IgnoredSearchTerms') IS NOT NULL )	SET IDENTITY_INSERT InstantASP_IgnoredSearchTerms OFF

GO



-----------------------------------------------------------
--Insert data into InstantASP_Users
-----------------------------------------------------------

DELETE FROM InstantASP_Users
GO

IF (IDENT_SEED('InstantASP_Users') IS NOT NULL )	SET IDENTITY_INSERT InstantASP_Users ON
INSERT INTO InstantASP_Users (UserID,EmailAddress,Password,Username,PrimaryRoleID,Culture,IPAddress,TimeZoneOffset,ObserveDaylightSavingTime,DateTimeFormat,TotalVisits,ConfirmationCode,FirstDayOfWeek) VALUES('1','admin@admin.com','admin','Administrator','5','','127.0.0.1',-7,0,'','0','','0')
IF (IDENT_SEED('InstantASP_Users') IS NOT NULL )	SET IDENTITY_INSERT InstantASP_Users OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_Users
-----------------------------------------------------------

DELETE FROM InstantKB_Users
GO

IF (IDENT_SEED('InstantKB_Users') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Users ON
INSERT INTO InstantKB_Users (UserID,IsAnonymous,PermissionID,StaffPermissionID,PrimaryDeptID,RecognitionPoints,Skin,MemberLevelTitle,MemberLevelImage,PhotoImage,Interests,Signature,Notes) VALUES('1',0,'0','0','1','0','','','','','','','')IF (IDENT_SEED('InstantKB_Users') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Users OFF

GO

-----------------------------------------------------------
--Insert data into InstantASP_UsersRoles
-----------------------------------------------------------

DELETE FROM InstantASP_UsersRoles
GO

IF (IDENT_SEED('InstantASP_UsersRoles') IS NOT NULL )	SET IDENTITY_INSERT InstantASP_UsersRoles ON
INSERT INTO InstantASP_UsersRoles (UserID,RoleID) VALUES (1,1)
INSERT INTO InstantASP_UsersRoles (UserID,RoleID) VALUES (1,2)
INSERT INTO InstantASP_UsersRoles (UserID,RoleID) VALUES (1,3)
INSERT INTO InstantASP_UsersRoles (UserID,RoleID) VALUES (1,4)
INSERT INTO InstantASP_UsersRoles (UserID,RoleID) VALUES (1,5)
INSERT INTO InstantASP_UsersRoles (UserID,RoleID) VALUES (1,6)
IF (IDENT_SEED('InstantASP_UsersRoles') IS NOT NULL )	SET IDENTITY_INSERT InstantASP_UsersRoles OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_UserLevels
-----------------------------------------------------------

DELETE FROM InstantKB_UserLevels
GO 

IF (IDENT_SEED('InstantKB_UserLevels') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_UserLevels ON
INSERT INTO InstantKB_UserLevels (UserLevelID,Description,ImageURL,NoOfBlocks,RecognitionPoints) VALUES('1','New Member','','0','0')
INSERT INTO InstantKB_UserLevels (UserLevelID,Description,ImageURL,NoOfBlocks,RecognitionPoints) VALUES('2','Junior Member','','2','15')
INSERT INTO InstantKB_UserLevels (UserLevelID,Description,ImageURL,NoOfBlocks,RecognitionPoints) VALUES('3','Respected Member','','4','30')
INSERT INTO InstantKB_UserLevels (UserLevelID,Description,ImageURL,NoOfBlocks,RecognitionPoints) VALUES('4','Support Guru','','6','60')
INSERT INTO InstantKB_UserLevels (UserLevelID,Description,ImageURL,NoOfBlocks,RecognitionPoints) VALUES('5','Supreme Being','','8','120')
IF (IDENT_SEED('InstantKB_UserLevels') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_UserLevels OFF

GO


-----------------------------------------------------------
--Insert data into InstantKB_AttachmentTypes
-----------------------------------------------------------

DELETE FROM InstantKB_AttachmentTypes
GO 

IF (IDENT_SEED('InstantKB_AttachmentTypes') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_AttachmentTypes ON

-- knowledgebase attachment types

INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('1','1','.ascx','ascx.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('2','1','.aspx','aspx.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('3','1','.avi','avi.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('4','1','.bmp','bmp.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('5','1','.chm','chm.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('6','1','.config','config.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('7','1','.cs','cs.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('8','1','.csproj','csproj.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('9','1','.css','css.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('10','1','.doc','doc.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('11','1','.gif','gif.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('12','1','.htm','htm.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('13','1','.inf','inf.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('14','1','.jpg','jpg.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('15','1','.js','js.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('16','1','.mdb','mdb.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('17','1','.mov','mov.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('18','1','.pdf','pdf.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('19','1','.png','png.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('20','1','.pub','pub.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('21','1','.rar','rar.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('22','1','.sln','sln.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('23','1','.sql','sql.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('24','1','.txt','txt.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('25','1','.vb','vb.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('26','1','.vbproj','vbproj.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('27','1','.vbs','vbs.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('28','1','.vsd','vsd.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('29','1','.xls','xls.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('30','1','.xml','xml.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('31','1','.xsn','xsn.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('32','1','.zip','zip.png')

-- troubleshooter attachment types

INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('33','2','.ascx','ascx.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('34','2','.aspx','aspx.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('35','2','.avi','avi.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('36','2','.bmp','bmp.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('37','2','.chm','chm.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('38','2','.config','config.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('39','2','.cs','cs.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('40','2','.csproj','csproj.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('41','2','.css','css.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('42','2','.doc','doc.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('43','2','.gif','gif.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('44','2','.htm','htm.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('45','2','.inf','inf.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('46','2','.jpg','jpg.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('47','2','.js','js.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('48','2','.mdb','mdb.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('49','2','.mov','mov.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('50','2','.pdf','pdf.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('51','2','.png','png.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('52','2','.pub','pub.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('53','2','.rar','rar.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('54','2','.sln','sln.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('55','2','.sql','sql.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('56','2','.txt','txt.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('57','2','.vb','vb.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('58','2','.vbproj','vbproj.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('59','2','.vbs','vbs.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('60','2','.vsd','vsd.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('61','2','.xls','xls.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('62','2','.xml','xml.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('63','2','.xsn','xsn.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('64','2','.zip','zip.png')

-- download attachment types

INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('65','3','.ascx','ascx.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('66','3','.aspx','aspx.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('67','3','.avi','avi.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('68','3','.bmp','bmp.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('69','3','.chm','chm.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('70','3','.config','config.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('71','3','.cs','cs.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('72','3','.csproj','csproj.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('73','3','.css','css.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('74','3','.doc','doc.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('75','3','.gif','gif.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('76','3','.htm','htm.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('77','3','.inf','inf.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('78','3','.jpg','jpg.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('79','3','.js','js.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('80','3','.mdb','mdb.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('81','3','.mov','mov.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('82','3','.pdf','pdf.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('83','3','.png','png.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('84','3','.pub','pub.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('85','3','.rar','rar.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('86','3','.sln','sln.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('87','3','.sql','sql.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('88','3','.txt','txt.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('89','3','.vb','vb.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('90','3','.vbproj','vbproj.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('91','3','.vbs','vbs.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('92','3','.vsd','vsd.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('93','3','.xls','xls.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('94','3','.xml','xml.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('95','3','.xsn','xsn.png')
INSERT INTO InstantKB_AttachmentTypes (AttachmentTypeID, TabID, Extension, Icon) VALUES('96','3','.zip','zip.png')



IF (IDENT_SEED('InstantKB_AttachmentTypes') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_AttachmentTypes OFF

GO



-----------------------------------------------------------
--Insert data into InstantASP_Fields
-----------------------------------------------------------

DELETE FROM InstantASP_Fields WHERE ApplicationID = 2
GO

IF (IDENT_SEED('InstantASP_Fields') IS NOT NULL )	SET IDENTITY_INSERT InstantASP_Fields ON

-- article fields

INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('1','2','1','Field_ArticleID','Article ID','','','','','ArticleID','2','0','','0','','','1',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('2','2','1','FieldSeperator_Info','Seperator','','','','','','14','0','','0','','','2',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('3','2','1','Field_ArticleTitle','Article Title','','','','','ArticleTitle','1','0','','500','','','3',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('4','2','1','Field_ArticleWorkFlowStepID','Workflow Step','','','','','ArticleWorkFlowStepID','4','0','','0','','','4',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('5','2','1','Field_ArticleText','Article Text','','','','','ArticleText','10','0','','16','','','6',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('6','2','1','FieldSeperator_Category','Seperator','','','','','','14','0','','0','','','7',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('7','2','1','Field_ArticleCategory','Article Primary Category','Field_ArticleCategoryDesc','','','','ArticleCategoryID','4','0','','0','','','8',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('8','2','1','Field_ArticleSecondaryCategories','Article Secondary Categories','Field_ArticleSecondaryCategoriesDesc','','','','ArticleSecondaryCategories','13','0','','0','','','9',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('9','2','1','FieldSeperator_MemberGroups','Seperator','','','','','','14','0','','0','','','10',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('10','2','1','Field_ArticleRoles','Article Roles','Field_ArticleRolesDesc','','','','ArticleRoles','13','0','','0','','','11',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('11','2','1','FieldSeperator_UserInfo','Seperator','','','','','','14','0','','0','','','12',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('12','2','1','Field_ArticleCreatedUserID','Created By','','','','','ArticleCreatedUserID','4','0','','0','','','13',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('13','2','1','Field_ArticleCreatedDate','Created Date','','','','','ArticleCreatedDate','3','0','','0','','','14',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('14','2','1','Field_ArticleModifiedUserID','Modified By','','','','','ArticleModifiedUserID','4','0','','0','','','15',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('15','2','1','Field_ArticleModifiedDate','Modified Date','','','','','ArticleModifiedDate','3','0','','0','','','16',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('16','2','1','Field_ArticleReportedUserID','Reported By','','','','','ArticleReportedUserID','4','0','','0','','','17',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('17','2','1','Field_ArticleReportedDate','Reported Date','','','','','ArticleReportedDate','3','0','','0','','','18',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('18','2','1','Field_ArticleAssignedUserID','Assigned To','','','','','ArticleAssignedUserID','4','0','','0','','','19',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('19','2','1','Field_ArticleAssignedDate','Assiigned Date','','','','','ArticleAssignedDate','3','0','','0','','','20',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('20','2','1','FieldSeperator_SuggestedInfo','Seperator','','','','','','14','0','','0','','','21',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('21','2','1','Field_ArticleSuggestedUsername','Suggested By','','','','','ArticleSuggestedUsername','1','0','','0','','','21',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('22','2','1','Field_ArticleSuggestedEmail','Email Address','','','','','ArticleSuggestedEmail','1','0','','0','','','21',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('23','2','1','Field_ArticleSuggestedDate','Suggested Date','','','','','ArticleSuggestedDate','3','0','','0','','','22',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('24','2','1','FieldSeperator_General','Seperator','','','','','','14','0','','0','','','23',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('25','2','1','Field_ArticleTypeID','Article Type','','','','','ArticleTypeID','4','0','','0','','','24',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('26','2','1','Field_ArticleLevelID','Article Level','','','','','ArticleLevelID','4','0','','0','','','25',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('27','2','1','Field_ArticleStatusID','Article Status','','','','','ArticleStatusID','4','0','','0','','','26',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('28','2','1','Field_ArticlePriorityID','Article Priority','','','','','ArticlePriorityID','4','0','','0','','','27',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('29','2','1','Field_ArticleRating','Article Rating','','','','','ArticleRating','2','0','','0','','','28',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('30','2','1','Field_ArticleViews','Article Views','','','','','ArticleViews','2','0','','0','','','29',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('31','2','1','Field_ArticleReviewDate','Review Date','','','','','ArticleReviewDate','3','0','','0','','','30',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('32','2','1','Field_ArticleDueDate','Due Date','','','','','ArticleDueDate','3','0','','0','','','31',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('33','2','1','Field_ArticleExpiresDate','Expiry Date','','','','','ArticleExpiresDate','3','0','','0','','','32',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('34','2','1','Field_ArticlePercentComplete','Percent Complete','','','','','ArticlePercentComplete','2','0','','0','','','33',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('35','2','1','FieldSeperator_Access','Seperator','','','','','','14','0','','0','','','34',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('36','2','1','Field_ArticleAccessType','Access Type','','','','','ArticleAccessType','4','0','','0','','','35',1,1,1,0,1)

-- guide fields

INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('37','2','2','Field_ArticleID','Article ID','','','','','ArticleID','2','0','','0','','','1',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('38','2','2','FieldSeperator_GuideInfo','Seperator','','','','','','14','0','','0','','','2',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('39','2','2','Field_StepTitle','Step Title','','','','','ArticleTitle','1','0','','500','','','3',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('40','2','2','Field_ArticleWorkFlowStepID','Workflow Step','','','','','ArticleWorkFlowStepID','4','0','','0','','','4',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('41','2','2','Field_ArticleText','Article Text','','','','','ArticleText','10','0','','16','','','6',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('42','2','2','FieldSeperator_Category','Seperator','','','','','','14','0','','0','','','7',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('43','2','2','Field_ArticleCategory','Article Primary Category','Field_ArticleCategoryDesc','','','','ArticleCategoryID','4','0','','0','','','8',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('44','2','2','Field_ArticleSecondaryCategories','Article Secondary Categories','Field_ArticleSecondaryCategoriesDesc','','','','ArticleSecondaryCategories','13','0','','0','','','9',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('45','2','2','FieldSeperator_MemberGroups','Seperator','','','','','','14','0','','0','','','10',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('46','2','2','Field_ArticleRoles','Article Roles','Field_ArticleRolesDesc','','','','ArticleRoles','13','0','','0','','','11',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('47','2','2','Field_ArticleCreatedUserID','Created By','','','','','ArticleCreatedUserID','4','0','','0','','','13',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('48','2','2','Field_ArticleCreatedDate','Created Date','','','','','ArticleCreatedDate','3','0','','0','','','14',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('49','2','2','Field_ArticleModifiedUserID','Modified By','','','','','ArticleModifiedUserID','4','0','','0','','','15',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('50','2','2','Field_ArticleModifiedDate','Modified Date','','','','','ArticleModifiedDate','3','0','','0','','','16',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('51','2','2','FieldSeperator_General','Seperator','','','','','','14','0','','0','','','23',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('52','2','2','Field_ArticleTypeID','Article Type','','','','','ArticleTypeID','4','0','','0','','','24',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('53','2','2','Field_ArticleLevelID','Article Level','','','','','ArticleLevelID','4','0','','0','','','25',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('54','2','2','Field_ArticleStatusID','Article Status','','','','','ArticleStatusID','4','0','','0','','','26',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('55','2','2','Field_ArticlePriorityID','Article Priority','','','','','ArticlePriorityID','4','0','','0','','','27',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('56','2','2','Field_ArticleRating','Article Rating','','','','','ArticleRating','2','0','','0','','','28',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('57','2','2','Field_ArticleViews','Article Views','','','','','ArticleViews','2','0','','0','','','29',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('58','2','2','Field_ArticleReviewDate','Review Date','','','','','ArticleReviewDate','3','0','','0','','','30',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('59','2','2','Field_ArticleDueDate','Due Date','','','','','ArticleDueDate','3','0','','0','','','31',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('60','2','2','Field_ArticleExpiresDate','Expiry Date','','','','','ArticleExpiresDate','3','0','','0','','','32',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('61','2','2','Field_ArticlePercentComplete','Percent Complete','','','','','ArticlePercentComplete','2','0','','0','','','33',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('62','2','2','FieldSeperator_Access','Seperator','','','','','','14','0','','0','','','34',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('63','2','2','Field_ArticleAccessType','Access Type','','','','','ArticleAccessType','4','0','','0','','','35',1,1,1,0,1)

-- download fields

INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('64','2','3','Field_ArticleID','Article ID','','','','','ArticleID','2','0','','0','','','1',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('65','2','3','FieldSeperator_DownloadInfo','Seperator','','','','','','14','0','','0','','','2',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('66','2','3','Field_DownloadTitle','Title','','','','','ArticleTitle','1','0','','500','','','3',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('67','2','3','Field_ArticleWorkFlowStepID','Workflow Step','','','','','ArticleWorkFlowStepID','4','0','','0','','','5',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('68','2','3','Field_DownloadText','Download Text','','','','','ArticleText','10','0','','16','','','6',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('69','2','3','FieldSeperator_Download','Seperator','','','','','','14','0','','0','','','7',1,1,0,0,1)

INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('70','2','3','Field_DownloadFile','Upload File','Field_DownloadFileDesc','','','','ArticleDownloadFile','15','0','','','','','8',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('71','2','3','Field_DownloadExternalLink','External Link','Field_DownloadExternalLinkDesc','','','','ArticleDownloadLink','1','0','http://','500','','','9',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('72','2','3','FieldSeperator_Category','Seperator','','','','','','14','0','','0','','','10',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('73','2','3','Field_ArticleCategory','Article Primary Category','Field_ArticleCategoryDesc','','','','ArticleCategoryID','4','0','','0','','','11',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('74','2','3','Field_ArticleSecondaryCategories','Article Secondary Categories','Field_ArticleSecondaryCategoriesDesc','','','','ArticleSecondaryCategories','13','0','','0','','','12',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('75','2','3','FieldSeperator_MemberGroups','Seperator','','','','','','14','0','','0','','','13',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('76','2','3','Field_ArticleRoles','Article Roles','Field_ArticleRolesDesc','','','','ArticleRoles','13','0','','0','','','14',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('77','2','3','Field_ArticleCreatedUserID','Created By','','','','','ArticleCreatedUserID','4','0','','0','','','15',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('78','2','3','Field_ArticleCreatedDate','Created Date','','','','','ArticleCreatedDate','3','0','','0','','','16',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('79','2','3','Field_ArticleModifiedUserID','Modified By','','','','','ArticleModifiedUserID','4','0','','0','','','17',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('80','2','3','Field_ArticleModifiedDate','Modified Date','','','','','ArticleModifiedDate','3','0','','0','','','18',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('81','2','3','FieldSeperator_General','Seperator','','','','','','14','0','','0','','','19',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('82','2','3','Field_ArticleTypeID','Article Type','','','','','ArticleTypeID','4','0','','0','','','20',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('83','2','3','Field_ArticleStatusID','Article Status','','','','','ArticleStatusID','4','0','','0','','','21',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('84','2','3','Field_ArticlePriorityID','Article Priority','','','','','ArticlePriorityID','4','0','','0','','','22',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('85','2','3','Field_ArticleRating','Article Rating','','','','','ArticleRating','2','0','','0','','','23',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('86','2','3','Field_ArticleViews','Views','','','','','ArticleViews','2','0','','0','','','41',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('87','2','3','Field_DownloadSize','Download Size','','','','','ArticleDownloadSize','2','0','','0','','','24',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('88','2','3','Field_ArticleReviewDate','Review Date','','','','','ArticleReviewDate','3','0','','0','','','25',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('89','2','3','Field_ArticleExpiresDate','Expiry Date','','','','','ArticleExpiresDate','3','0','','0','','','26',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('90','2','3','FieldSeperator_Access','Seperator','','','','','','14','0','','0','','','27',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES ('91','2','3','Field_ArticleAccessType','Access Type','','','','','ArticleAccessType','4','0','','0','','','28',1,1,1,0,1)

-- ricket fields

/*

INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('37','2','4','Field_TicketID','TicketID','','','','','TicketID','1','0','','0','','','1',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('38','2','4','FieldSeperator_TicketInformation','Seperator','','','','','','14','0','','0','','','6',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('39','2','4','Field_TicketTitle','Ticket Title','','','','','TicketTitle','1','0','','0','','','7',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('40','2','4','Field_TicketText','Ticket Text','','','','','TicketText','7','0','','0','','','8',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('41','2','4','FieldSeperator_TicketSender','Seperator','','','','','','14','0','','0','','','2',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('42','2','4','Field_TicketCreatedUserID','Full Name','','','','','TicketCreatedUserID','1','0','','0','','','3',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('43','2','4','Field_TicketCreatedDate','Created Date','','','','','TicketCreatedDate','3','0','','0','','','9',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('44','2','4','Field_TicketModifiedUserID','Modified By','','','','','TicketModifiedUserID','1','0','','0','','','10',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('45','2','4','Field_TicketModifiedDate','Modified Date','','','','','TicketModifiedDate','3','0','','0','','','11',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('46','2','4','Field_TicketAssignedUserID','Assigned To','','','','','TicketAssignedUserID','4','0','','0','','','12',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('47','2','4','Field_TicketAssignedDate','Assigned Date','','','','','TicketAssignedDate','3','0','','0','','','13',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('48','2','4','Field_TicketTypeID','Type','','','','','TicketTypeID','4','0','','0','','','14',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('49','2','4','Field_TicketStatusID','Status','','','','','TicketStatusID','4','0','','0','','','15',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('50','2','4','Field_TicketPriorityID','Priority','','','','','TicketPriorityID','4','0','','0','','','5',1,1,0,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('51','2','4','Field_TicketDepartmentID','Department','','','','','TicketDepartmentID','12','0','','0','','','16',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('52','2','4','Field_TicketViews','Views','','','','','TicketViews','2','0','','0','','','17',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('53','2','4','Field_TicketReplies','Replies','','','','','TicketReplies','2','0','','0','','','18',1,1,0,0,0)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('54','2','4','Field_TicketCreatedEmailAddress','Email Address','','','','','TicketCreatedEmailAddress','1','0','','0','','','4',1,1,1,0,1)
INSERT INTO InstantASP_Fields (FieldID,ApplicationID,TabID,FieldLabel,FieldLabelNonLocalized,FieldDescLabel,FieldDescLabelNonLocalized,FieldToolTip,FieldToolTipNonLocalized,TableFieldName,FieldType,PickListID,DefaultValue,StringSize,Format,RegExValidation,SortOrder,IsVisible,IsEnabled,IsRequired,IsCustomField,IsUserEditable) VALUES('55','2','4','Field_TicketEmailQueue','Email Queue','','','','','TicketEmailQueue','4','0','','0','','','19',1,1,0,0,0)

*/

IF (IDENT_SEED('InstantASP_Fields') IS NOT NULL )	SET IDENTITY_INSERT InstantASP_Fields OFF


-----------------------------------------------------------
--Insert data into InstantASP_FieldTemplates
-----------------------------------------------------------

DELETE FROM InstantASP_FieldTemplates 
DELETE FROM InstantASP_FieldTemplateDetails
GO

IF (IDENT_SEED('InstantASP_FieldTemplates') IS NOT NULL )	SET IDENTITY_INSERT InstantASP_FieldTemplates ON

INSERT INTO InstantASP_FieldTemplates (FieldTemplateID, ApplicationID, [Name], NameNonLocalized, Description, TabID, IsRequired) VALUES (1, 2, 'ArticleTemplate', '', '', 1, 1)
INSERT INTO InstantASP_FieldTemplates (FieldTemplateID, ApplicationID, [Name], NameNonLocalized, Description, TabID, IsRequired) VALUES (2, 2, 'GuideTemplate', '', '', 2, 1)
INSERT INTO InstantASP_FieldTemplates (FieldTemplateID, ApplicationID, [Name], NameNonLocalized, Description, TabID, IsRequired) VALUES (3, 2, 'DownloadTemplate', '', '', 3, 1)
--INSERT INTO InstantASP_FieldTemplates (FieldTemplateID, ApplicationID, [Name], NameNonLocalized, Description, TabID, IsRequired) VALUES (4, 2, 'TicketTemplate', '', '', 4, 1)

IF (IDENT_SEED('InstantASP_FieldTemplates') IS NOT NULL )	SET IDENTITY_INSERT InstantASP_FieldTemplates OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_PermissionSets
-----------------------------------------------------------

DELETE FROM InstantKB_PermissionSets
GO

IF (IDENT_SEED('InstantKB_PermissionSets') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_PermissionSets ON
INSERT INTO InstantKB_PermissionSets (PermissionID,PermissionName,SettingsXML,Required) VALUES('1','Anonymous Visitors','',0)
INSERT INTO InstantKB_PermissionSets (PermissionID,PermissionName,SettingsXML,Required) VALUES('2','Registered Members','',0)
INSERT INTO InstantKB_PermissionSets (PermissionID,PermissionName,SettingsXML,Required) VALUES('3','Awaiting Activation','',0)
INSERT INTO InstantKB_PermissionSets (PermissionID,PermissionName,SettingsXML,Required) VALUES('4','Moderators / Staff','',0)
INSERT INTO InstantKB_PermissionSets (PermissionID,PermissionName,SettingsXML,Required) VALUES('5','Administrators','',0)
INSERT INTO InstantKB_PermissionSets (PermissionID,PermissionName,SettingsXML,Required) VALUES('6','Banned','',0)
IF (IDENT_SEED('InstantKB_PermissionSets') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_PermissionSets OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_PermissionSetsRoles
-----------------------------------------------------------

DELETE FROM InstantKB_PermissionSetsRoles
GO

IF (IDENT_SEED('InstantKB_PermissionSetsRoles') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_PermissionSetsRoles ON
INSERT INTO InstantKB_PermissionSetsRoles (PermissionRoleID,PermissionID,RoleID) VALUES('1','1','1')
INSERT INTO InstantKB_PermissionSetsRoles (PermissionRoleID,PermissionID,RoleID) VALUES('2','2','2')
INSERT INTO InstantKB_PermissionSetsRoles (PermissionRoleID,PermissionID,RoleID) VALUES('3','3','3')
INSERT INTO InstantKB_PermissionSetsRoles (PermissionRoleID,PermissionID,RoleID) VALUES('4','4','4')
INSERT INTO InstantKB_PermissionSetsRoles (PermissionRoleID,PermissionID,RoleID) VALUES('5','5','5')
INSERT INTO InstantKB_PermissionSetsRoles (PermissionRoleID,PermissionID,RoleID) VALUES('6','6','6')
IF (IDENT_SEED('InstantKB_PermissionSetsRoles') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_PermissionSetsRoles OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_PermissionSetsTabs
-----------------------------------------------------------

DELETE FROM InstantKB_PermissionSetsTabs

IF (IDENT_SEED('InstantKB_PermissionSetsTabs') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_PermissionSetsTabs ON
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('1','1','1','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('2','1','2','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('3','1','3','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('4','1','4','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('5','2','1','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('6','2','2','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('7','2','3','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('8','2','4','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('9','3','1','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('10','3','2','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('11','3','3','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('12','3','4','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('13','4','1','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('14','4','2','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('15','4','3','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('16','4','4','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('17','5','1','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('18','5','2','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('19','5','3','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('20','5','4','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('21','6','1','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('22','6','2','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('23','6','3','')
INSERT INTO InstantKB_PermissionSetsTabs (PermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('24','6','4','')
IF (IDENT_SEED('InstantKB_PermissionSetsTabs') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_PermissionSetsTabs OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_StaffPermissionSets
-----------------------------------------------------------

DELETE FROM InstantKB_StaffPermissionSets 
GO

IF (IDENT_SEED('InstantKB_StaffPermissionSets') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_StaffPermissionSets ON

INSERT INTO InstantKB_StaffPermissionSets (PermissionID,PermissionName,SettingsXML,IsRequired) VALUES('1','Default Permissions','',1)

IF (IDENT_SEED('InstantKB_StaffPermissionSets') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_StaffPermissionSets OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_StaffPermissionSetsTabs
-----------------------------------------------------------

DELETE FROM InstantKB_StaffPermissionSetsTabs
GO

IF (IDENT_SEED('InstantKB_StaffPermissionSetsTabs') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_StaffPermissionSetsTabs ON

INSERT INTO InstantKB_StaffPermissionSetsTabs (StaffPermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('1','1','1','')
INSERT INTO InstantKB_StaffPermissionSetsTabs (StaffPermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('2','1','2','')
INSERT INTO InstantKB_StaffPermissionSetsTabs (StaffPermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('3','1','3','')
--INSERT INTO InstantKB_StaffPermissionSetsTabs (StaffPermissionSetsTabsID,PermissionID,TabID,SettingsXML) VALUES('4','1','4','')

IF (IDENT_SEED('InstantKB_StaffPermissionSetsTabs') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_StaffPermissionSetsTabs OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_Departments
-----------------------------------------------------------

DELETE FROM InstantKB_Departments 
GO

IF (IDENT_SEED('InstantKB_Departments') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Departments ON

INSERT INTO InstantKB_Departments (DepartmentID, DepartmentName, AccessType, PermissionID) VALUES (1, 'Default Department', 1,1)

IF (IDENT_SEED('InstantKB_Departments') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Departments OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_UserDepartments
-----------------------------------------------------------

DELETE FROM InstantKB_UserDepartments
GO

INSERT INTO InstantKB_UserDepartments (UserID, DepartmentID) VALUES (1, 1)

GO

-----------------------------------------------------------
--Insert data into InstantKB_WorkFlows
-----------------------------------------------------------

DELETE FROM InstantKB_WorkFlows
GO

IF (IDENT_SEED('InstantKB_WorkFlows') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_WorkFlows ON

INSERT INTO InstantKB_WorkFlows (WorkFlowID, WorkFlowName, TabID, IsDefault) VALUES (1, 'Article Approval', 1, 1)
INSERT INTO InstantKB_WorkFlows (WorkFlowID, WorkFlowName, TabID, IsDefault) VALUES (2, 'Guide Approval', 2, 1)
INSERT INTO InstantKB_WorkFlows (WorkFlowID, WorkFlowName, TabID, IsDefault) VALUES (3, 'Download Approval', 3, 1)
--INSERT INTO InstantKB_WorkFlows (WorkFlowID, WorkFlowName, TabID, IsDefault) VALUES (4, 'Tickets', 4, 1)

IF (IDENT_SEED('InstantKB_WorkFlows') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_WorkFlows OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_WorkFlowSteps
-----------------------------------------------------------

DELETE FROM InstantKB_WorkFlowSteps
GO

-- insert default workflow steps
IF (IDENT_SEED('InstantKB_WorkFlowSteps') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_WorkFlowSteps ON

INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (1, 1, 'In Draft' , 0, '', 1)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (2, 1, '1st Review' , 0, '', 2)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (3, 1, '2nd Review' , 0, '', 3)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (4, 1, '3rd Review' , 0, '', 4)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (5, 1, 'Publish To Web' , 0, '', 5)

INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (6, 2, 'In Draft' , 0, '', 1)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (7, 2, '1st Review' , 0, '', 2)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (8, 2, '2nd Review' , 0, '', 3)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (9, 2, '3rd Review' , 0, '', 4)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (10, 2, 'Publish To Web' , 0, '', 5)

INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (11, 3, 'In Draft' , 0, '', 1)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (12, 3, '1st Review' , 0, '', 2)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (13, 3, '2nd Review' , 0, '', 3)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (14, 3, '3rd Review' , 0, '', 4)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (15, 3, 'Publish To Web' , 0, '', 5)

/*
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (161, 4, 'New Ticket' , 0, '', 1)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (17, 4, 'Validated Ticket' , 0, '', 2)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (18, 4, 'Under Investigation' , 0, '', 3)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (19, 4, 'Resolved Ticket' , 0, '', 4)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (20, 4, 'Reopened Ticket' , 0, '', 5)
INSERT INTO InstantKB_WorkFlowSteps (WorkFlowStepID, WorkFlowID, [Name], FieldTemplateID, ChangeActionsXml, SortOrder) VALUES (21, 4, 'Closed Ticket' , 0, '', 6)
*/

IF (IDENT_SEED('InstantKB_WorkFlowSteps') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_WorkFlowSteps OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_WorkFlowDepartments
-----------------------------------------------------------

DELETE FROM InstantKB_WorkFlowDepartments
GO

INSERT INTO InstantKB_WorkFlowDepartments (WorkFlowID, DepartmentID) VALUES (1, 1)
INSERT INTO InstantKB_WorkFlowDepartments (WorkFlowID, DepartmentID) VALUES (2, 1)
INSERT INTO InstantKB_WorkFlowDepartments (WorkFlowID, DepartmentID) VALUES (3, 1)
INSERT INTO InstantKB_WorkFlowDepartments (WorkFlowID, DepartmentID) VALUES (4, 1)

GO

-----------------------------------------------------------
--Insert data into InstantKB_Tabs
-----------------------------------------------------------

DELETE FROM InstantKB_Tabs
DELETE FROM InstantKB_TabRoles
GO

IF (IDENT_SEED('InstantKB_Tabs') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Tabs ON

INSERT INTO InstantKB_Tabs (TabID,TabContentType,TabLabel,TabLabelNonLocalized,TabTooltip,TabTooltipNonLocalized,TabIcon,FieldTemplateID,TabRedirectURL,TabClickCount,IsCustomTab,SortOrder, TabContentTypeName) VALUES('1','1','TabStrip_1','','TabStrip_ToolTip1','','Knowledgebase.gif','0','','0',0,'4','TabStrip_ContentType1')
INSERT INTO InstantKB_Tabs (TabID,TabContentType,TabLabel,TabLabelNonLocalized,TabTooltip,TabTooltipNonLocalized,TabIcon,FieldTemplateID,TabRedirectURL,TabClickCount,IsCustomTab,SortOrder, TabContentTypeName) VALUES('2','2','TabStrip_2','','TabStrip_ToolTip2','','Troubleshooter.gif','0','','0',0,'5','TabStrip_ContentType2')
INSERT INTO InstantKB_Tabs (TabID,TabContentType,TabLabel,TabLabelNonLocalized,TabTooltip,TabTooltipNonLocalized,TabIcon,FieldTemplateID,TabRedirectURL,TabClickCount,IsCustomTab,SortOrder, TabContentTypeName) VALUES('3','3','TabStrip_3','','TabStrip_ToolTip3','','Downloads.gif','0','','0',0,'7','TabStrip_ContentType3')
--INSERT INTO InstantKB_Tabs (TabID,TabContentType,TabLabel,TabLabelNonLocalized,TabTooltip,TabTooltipNonLocalized,TabIcon,FieldTemplateID,TabRedirectURL,TabClickCount,IsCustomTab,SortOrder, TabContentTypeName) VALUES('4','4','TabStrip_4','','TabStrip_ToolTip4','','Tickets.gif','0','','0',0,'9','TabStrip_ContentType4')

IF (IDENT_SEED('InstantKB_Tabs') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Tabs OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_TabRoles
-----------------------------------------------------------

DELETE FROM InstantKB_TabRoles
GO

INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('1','1')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('2','1')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('3','1')
--INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('4','1')

INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('1','2')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('2','2')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('3','2')
--INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('4','2')

INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('1','3')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('2','3')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('3','3')
--INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('4','3')

INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('1','4')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('2','4')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('3','4')
--INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('4','4')

INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('1','5')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('2','5')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('3','5')
--INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('4','5')

INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('1','6')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('2','6')
INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('3','6')
--INSERT INTO InstantKB_TabRoles (TabID,RoleID) VALUES('4','6')

GO

-----------------------------------------------------------
--Insert data into InstantKB_DataViews
-----------------------------------------------------------

DELETE FROM InstantKB_DataViews
GO

IF (IDENT_SEED('InstantKB_DataViews') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_DataViews ON

INSERT INTO InstantKB_DataViews (DataViewID,UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('1','0','1','Latest Articles','','ArticleIcon,ArticleTitle,ArticleModifiedDate','ArticleModifiedDate','1','5','1','1',1,GetDate())
INSERT INTO InstantKB_DataViews (DataViewID,UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('2','0','1','Popular Articles','','ArticleIcon,ArticleTitle,ArticleRating','ArticleRating','1','5','1','2',1,GetDate())
INSERT INTO InstantKB_DataViews (DataViewID,UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('3','0','1','Category','','ArticleIcon,ArticleTitle,ArticleModifiedDate','ArticleModifiedDate','1','10','1','3',1,GetDate())
INSERT INTO InstantKB_DataViews (DataViewID,UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('4','0','1','Manage Articles','','ArticleIcon,ArticleTitle,ArticleModifiedDate','ArticleModifiedDate','1','10','1','4',1,GetDate())

INSERT INTO InstantKB_DataViews (DataViewID,UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('5','0','2','Latest Guides','','ArticleIcon,ArticleTitle,ArticleModifiedDate','ArticleModifiedDate','1','5','1','1',1,GetDate())
INSERT INTO InstantKB_DataViews (DataViewID,UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('6','0','2','Popular Guides','','ArticleIcon,ArticleTitle,ArticleRating','ArticleRating','1','5','1','2',1,GetDate())
INSERT INTO InstantKB_DataViews (DataViewID,UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('7','0','2','Category','','ArticleIcon,ArticleTitle,ArticleModifiedDate','ArticleModifiedDate','1','10','1','3',1,GetDate())
INSERT INTO InstantKB_DataViews (DataViewID,UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('8','0','2','Manage Guides','','ArticleIcon,ArticleTitle,ArticleModifiedDate','ArticleModifiedDate','1','10','1','4',1,GetDate())

INSERT INTO InstantKB_DataViews (DataViewID,UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('9','0','3','Latest Downloads','','ArticleIcon,ArticleTitle,ArticleModifiedDate','ArticleModifiedDate','1','5','1','1',1,GetDate())
INSERT INTO InstantKB_DataViews (DataViewID,UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('10','0','3','Popular Downloads','','ArticleIcon,ArticleTitle,ArticleRating','ArticleRating','1','5','1','2',1,GetDate())
INSERT INTO InstantKB_DataViews (DataViewID,UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('11','0','3','Category','','ArticleIcon,ArticleTitle,ArticleModifiedDate','ArticleModifiedDate','1','10','1','3',1,GetDate())
INSERT INTO InstantKB_DataViews (DataViewID,UserID,TabID,Name,Description,Columns,SortBy,SortOrder,PageSize,AccessType,DataViewType,IsRequired,DateStamp) VALUES('12','0','3','Manage Downloads','','ArticleIcon,ArticleTitle,ArticleModifiedDate','ArticleModifiedDate','1','10','1','4',1,GetDate())

IF (IDENT_SEED('InstantKB_DataViews') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_DataViews OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_Levels
-----------------------------------------------------------


DELETE FROM InstantKB_Levels
GO

IF (IDENT_SEED('InstantKB_Levels') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Levels ON

INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('1','1','Novice','1','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('2','1','Beginner','2','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('3','1','Intermediate','3','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('4','1','Aadvanced','3','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('5','1','Expert','4','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('6','2','Novice','1','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('7','2','Beginner','2','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('8','2','Intermediate','3','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('9','2','Aadvanced','3','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('10','2','Expert','4','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('11','3','Novice','1','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('12','3','Beginner','2','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('13','3','Intermediate','3','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('34','3','Aadvanced','3','1')
INSERT INTO InstantKB_Levels (LevelID,LevelTabID,LevelName,LevelSortOrder,LevelAccessType) VALUES('15','3','Expert','4','1')

IF (IDENT_SEED('InstantKB_Levels') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Levels OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_Settings
-----------------------------------------------------------

DELETE FROM InstantKB_Settings
GO
IF (IDENT_SEED('InstantKB_Settings') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Settings ON
INSERT INTO InstantKB_Settings (SettingID,SettingText,SettingDesc,SettingsXML) VALUES('1','AdminSettings_General','AdminSettings_GeneralDesc','')
INSERT INTO InstantKB_Settings (SettingID,SettingText,SettingDesc,SettingsXML) VALUES('2','AdminSettings_Settings','AdminSettings_SettingsDesc','')
INSERT INTO InstantKB_Settings (SettingID,SettingText,SettingDesc,SettingsXML) VALUES('3','AdminSettings_Email','AdminSettings_EmailDesc','')
INSERT INTO InstantKB_Settings (SettingID,SettingText,SettingDesc,SettingsXML) VALUES('4','AdminSettings_RegistrationLogin','AdminSettings_RegistrationLoginDesc','')
INSERT INTO InstantKB_Settings (SettingID,SettingText,SettingDesc,SettingsXML) VALUES('5','AdminSettings_MemberRecognitionPoints','AdminSettings_MemberRecognitionPointsDesc','')
INSERT INTO InstantKB_Settings (SettingID,SettingText,SettingDesc,SettingsXML) VALUES('6','AdminSettings_BadLanguage','AdminSettings_BadLanguageDesc','')
INSERT INTO InstantKB_Settings (SettingID,SettingText,SettingDesc,SettingsXML) VALUES('7','AdminSettings_IgnoredSearchTerms','AdminSettings_IgnoredSearchTermsDesc','')
INSERT INTO InstantKB_Settings (SettingID,SettingText,SettingDesc,SettingsXML) VALUES('8','AdminSettings_DatabaseTables','AdminSettings_DatabaseTablesDesc','')
IF (IDENT_SEED('InstantKB_Settings') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Settings OFF
GO



-----------------------------------------------------------
--Insert data into InstantKB_Types
-----------------------------------------------------------

DELETE FROM InstantKB_Types
GO

IF (IDENT_SEED('InstantKB_Types') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Types ON

-- article types
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('1','BUG','','1','1')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('2','ERRDOC','','2','1')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('3','ERRMSG','','3','1')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('4','FAQ','','4','1')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('5','FIX','','5','1')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('6','HOTFIX','','6','1')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('7','HOWTO','','7','1')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('8','INFO','','8','1')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('10','FEAT','','9','1')

-- guide types
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('11','HOWTO','','1','2')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('12','FAQ','','2','2')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('13','ERRMSG','','3','2')

-- download types
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('14','HOTFIX','','1','3')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('15','PATCH','','2','3')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('16','RELEASE','','3','3')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('17','BETA','','4','3')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('18','SAMPLE','','4','3')
INSERT INTO InstantKB_Types (TypeID,TypeName,TypeIcon,TypeSortOrder,TypeTabID) VALUES('19','SCRIPT','','4','3')

IF (IDENT_SEED('InstantKB_Types') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Types OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_Status
-----------------------------------------------------------

DELETE FROM InstantKB_Status
GO

IF (IDENT_SEED('InstantKB_Status') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Status ON

-- article status
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('1','Open','1','','','','1','1')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('2','Assigned','2','','','','1','1')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('3','In Draft','3','','','','1','1')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('4','In Review','4','','','','1','1')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('5','On Hold','5','','','','1','1')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('6','Closed','6','','','','1','1')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('7','Published','7','','','','1','1')

-- troubleshooter status
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('8','Open','1','','','','1','2')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('9','Assigned','2','','','','1','2')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('10','In Draft','3','','','','1','2')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('11','In Review','4','','','','1','2')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('12','On Hold','5','','','','1','2')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('13','Closed','6','','','','1','2')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('14','Published','7','','','','1','2')

-- download status
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('15','Open','1','','','','1','3')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('16','In Draft','3','','','','1','3')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('17','In Review','4','','','','1','3')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('18','On Hold','5','','','','1','3')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('19','Closed','6','','','','1','3')
INSERT INTO InstantKB_Status (StatusID,StatusName,StatusSortOrder,StatusForegroundColor,StatusBackgroundColor,StatusImage,StatusAccessType,StatusTabID) VALUES('20','Published','7','','','','1','3')


IF (IDENT_SEED('InstantKB_Status') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Status OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_Priorities
-----------------------------------------------------------

DELETE FROM InstantKB_Priorities
GO

IF (IDENT_SEED('InstantKB_Priorities') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Priorities ON

INSERT INTO InstantKB_Priorities (PriorityID,PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('1','Urgent','1','white','red','Flag_Red.gif','1','1')
INSERT INTO InstantKB_Priorities (PriorityID,PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('2','High','2','ghostwhite','darkorange','Flag_Orange.gif','1','1')
INSERT INTO InstantKB_Priorities (PriorityID,PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('3','Medium','3','cornflowerblue','yellow','Flag_Yellow.gif','1','1')
INSERT INTO InstantKB_Priorities (PriorityID,PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('4','Low','4','cornflowerblue','white','Flag_Blue.gif','1','1')
INSERT INTO InstantKB_Priorities (PriorityID,PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('5','Urgent','1','white','red','Flag_Red.gif','1','2')
INSERT INTO InstantKB_Priorities (PriorityID,PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('6','High','2','ghostwhite','darkorange','Flag_Orange.gif','1','2')
INSERT INTO InstantKB_Priorities (PriorityID,PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('7','Medium','3','cornflowerblue','yellow','Flag_Yellow.gif','2','2')
INSERT INTO InstantKB_Priorities (PriorityID,PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('8','Low','4','cornflowerblue','white','Flag_Blue.gif','1','2')
INSERT INTO InstantKB_Priorities (PriorityID,PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('9','Urgent','1','white','red','Flag_Red.gif','1','3')
INSERT INTO InstantKB_Priorities (PriorityID,PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('10','High','2','ghostwhite','darkorange','Flag_Orange.gif','1','3')
INSERT INTO InstantKB_Priorities (PriorityID,PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('11','Medium','3','cornflowerblue','yellow','Flag_Yellow.gif','2','3')
INSERT INTO InstantKB_Priorities (PriorityID,PriorityName,PrioritySortOrder,PriorityForegroundColor,PriorityBackgroundColor,PriorityImage,PriorityAccessType,PriorityTabID) VALUES('12','Low','4','cornflowerblue','white','Flag_Blue.gif','1','3')

IF (IDENT_SEED('InstantKB_Priorities') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Priorities OFF

GO



/******************************************************
  Insert data   Begin
******************************************************/
GO

-----------------------------------------------------------
--Insert data into InstantKB_Articles
-----------------------------------------------------------

DELETE FROM InstantKB_Articles
GO

IF (IDENT_SEED('InstantKB_Articles') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Articles ON
INSERT INTO InstantKB_Articles (ArticleID,TabID,ArticleParentID,ArticleCategoryID,ArticleTitle,ArticleTitleEncoded, ArticleText,ArticlePercentComplete,ArticleRating,ArticleViews,ArticleTypeID,ArticleLevelID,ArticleStatusID,ArticlePriorityID,ArticleAccessType,ArticleWorkFlowStepID,ArticleCreatedUserID,ArticleCreatedUsername,ArticleCreatedDate,ArticleModifiedUserID,ArticleModifiedUsername,ArticleModifiedDate,ArticleAssignedUserID,ArticleAssignedUsername,ArticleAssignedDate,ArticleSuggestedUserID,ArticleSuggestedUsername,ArticleSuggestedEmail,ArticleSuggestedDate,ArticleReportedUserID,ArticleReportedUsername,ArticleReportedDate,ArticleDueDate,ArticleReviewDate,ArticleExpiresDate,ArticlePassword,TotalRatings,AttachmentCount,CommentCount,TagCount) VALUES('50000','1','0','1','Welcome to InstantKB.NET 2.0','Welcome-to-InstantKB.NET-2.0','Thank you for purchasing InstantKB.NET 2.0. <br /><br />To get started you can login using the default administrator account. To login click the login link above and use the email address and password below...<br /><br />Email: <strong>admin@admin.com</strong><br />Password: <strong>admin</strong><br /><br />Once logged in click the <strong>Staff CP</strong> link to access the Staff Control Panel or the <strong>Admin CP</strong> link to access the Administrator Control Panel. Both links will appear in the <strong>top-right corner</strong> once logged in.<br /><br />For further information please consult our knowledgebase @ <a href="http://kb.instantasp.co.uk/Tags/InstantKB.NET" target="_blank">http://kb.instantasp.co.uk/Tags/InstantKB.NET</a><br /><br />Should you have any questions please dont hesitate to <a target="_blank" href="http://my.instantasp.co.uk/">open a support ticket</a> or <a target="_blank" href="http://www.instantasp.co.uk/Contact/">contact us</a>.<br /><br />thank you for your support. We hop you enjoy InstantKB.NET 2.0 :)','100','0','0','8','1','7','4','1','0','1','Administrator',GetDate(),'1','Administrator',GetDate(),'0','',NULL,'0','','',NULL,'0','',NULL,NULL,NULL,NULL,'','0','0','1','0')

IF (IDENT_SEED('InstantKB_Articles') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Articles OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_ArticleComments
-----------------------------------------------------------

DELETE FROM InstantKB_ArticleComments
GO

IF (IDENT_SEED('InstantKB_ArticleComments') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_ArticleComments ON

INSERT INTO InstantKB_ArticleComments (CommentID,ArticleID,UserID,Username,EmailAddress,WebAddress,Comments,LastModifiedByUserID,LastModifiedByUserName, LastModifiedDateStamp, DateStamp,AccessType) VALUES('1','50000','1','Administrator','admin@admin.com','','This is just a sample comment :)','1','Administrator',GetDate(),GetDate(),'1')

IF (IDENT_SEED('InstantKB_ArticleComments') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_ArticleComments OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_Categories
-----------------------------------------------------------

DELETE FROM InstantKB_Categories
GO

IF (IDENT_SEED('InstantKB_Categories') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Categories ON
INSERT INTO InstantKB_Categories (CategoryID,CategoryParentID,TabID,DataViewID,CategoryIcon,CategoryName,CategoryDescription,CategorySortOrder,CategoryExpanded,UserID,ArticleCount) VALUES('1','0','1','0','','Welcome to InstantKB.NET 2.0','','0',0,'1','0')
IF (IDENT_SEED('InstantKB_Categories') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_Categories OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_CategoryRoles
-----------------------------------------------------------

DELETE FROM InstantKB_CategoryRoles
GO 

IF (IDENT_SEED('InstantKB_CategoryRoles') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_CategoryRoles ON
INSERT INTO InstantKB_CategoryRoles (CategoryID,RoleID,PermissionID) VALUES('1','1','0')
INSERT INTO InstantKB_CategoryRoles (CategoryID,RoleID,PermissionID) VALUES('1','2','0')
INSERT INTO InstantKB_CategoryRoles (CategoryID,RoleID,PermissionID) VALUES('1','3','0')
INSERT INTO InstantKB_CategoryRoles (CategoryID,RoleID,PermissionID) VALUES('1','4','0')
INSERT INTO InstantKB_CategoryRoles (CategoryID,RoleID,PermissionID) VALUES('1','5','0')
INSERT INTO InstantKB_CategoryRoles (CategoryID,RoleID,PermissionID) VALUES('1','6','0')
IF (IDENT_SEED('InstantKB_CategoryRoles') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_CategoryRoles OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_ArticleCategories
-----------------------------------------------------------

DELETE FROM InstantKB_ArticleCategories
GO

IF (IDENT_SEED('InstantKB_ArticleCategories') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_ArticleCategories ON
INSERT INTO InstantKB_ArticleCategories (ArticleID,CategoryID) VALUES('50000','1')
INSERT INTO InstantKB_ArticleCategories (ArticleID,CategoryID) VALUES('50000','1')
IF (IDENT_SEED('InstantKB_ArticleCategories') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_ArticleCategories OFF

GO

-----------------------------------------------------------
--Insert data into InstantKB_ArticleRoles
-----------------------------------------------------------

DELETE FROM InstantKB_ArticleRoles
GO

IF (IDENT_SEED('InstantKB_ArticleRoles') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_ArticleRoles ON
INSERT INTO InstantKB_ArticleRoles (ArticleID,RoleID) VALUES('50000','1')
INSERT INTO InstantKB_ArticleRoles (ArticleID,RoleID) VALUES('50000','2')
INSERT INTO InstantKB_ArticleRoles (ArticleID,RoleID) VALUES('50000','3')
INSERT INTO InstantKB_ArticleRoles (ArticleID,RoleID) VALUES('50000','4')
INSERT INTO InstantKB_ArticleRoles (ArticleID,RoleID) VALUES('50000','5')
INSERT INTO InstantKB_ArticleRoles (ArticleID,RoleID) VALUES('50000','6')
IF (IDENT_SEED('InstantKB_ArticleRoles') IS NOT NULL )	SET IDENTITY_INSERT InstantKB_ArticleRoles OFF

GO

-----------------------------------------------------------
--Insert data into InstantASP_Tags
-----------------------------------------------------------

DELETE FROM InstantASP_Tags
GO

