
/****** Update an existing InstantKB.NET 2.x installation to InstantKB.NET 2.0.3 ******/

-- add LdapUsername column to InstantASP_Users

ALTER TABLE InstantASP_Users ADD LdapUsername				NVARCHAR(255) DEFAULT('') NOT NULL;

-- update InsertUpdateUser stored procedure

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [iasp_sp_InsertUpdateUser] (
@intUserID int,
@intPrimaryRoleID int,
@strUsername nvarchar(155),
@strEmailAddress nvarchar(155),
@strPassword nvarchar(155),
@strCulture nvarchar(10),
@dbTimeZoneOffSet float,
@bolObserveDST bit,
@strDateTimeFormat nvarchar(10),
@intFirstDayOfWeek tinyint,
@strFirstName nvarchar(155),
@strLastName nvarchar(155),
@strCompanyName nvarchar(155),
@strJobTitle nvarchar(155),
@strPublicEmail nvarchar(155),
@strWebAddress nvarchar(255),
@strBlogAddress nvarchar(255),
@strMSN nvarchar(155),
@strSkype nvarchar(155),
@strAIM nvarchar(155),
@strYIM nvarchar(155),
@strICQ nvarchar (155),
@strLocation nvarchar(155),
@intDOBDay tinyint,
@intDOBMonth tinyint,
@intDOBYear int,
@strIPAddress nvarchar(20),
@strLdapUsername nvarchar(255),
@intIdentity int output
) 
AS

SET NOCOUNT ON 

/* Inserts or updates a user within InstantASP_Users */

-- is this an update or insert?
IF (@intUserID = 0)
BEGIN

	-- insert user
	INSERT INTO InstantASP_Users (PrimaryRoleID, Username, EmailAddress, [Password], Culture, TimeZoneOffset, ObserveDaylightSavingTime, DateTimeFormat, FirstDayOfWeek, FirstName, LastName, CompanyName, JobTitle, PublicEmail, WebAddress, BlogAddress, MSN, Skype, YIM, AIM, ICQ, Location, DOBDay, DOBMonth, DOBYear, IPAddress, LdapUsername) VALUES
	(@intPrimaryRoleID, @strUsername, @strEmailAddress, @strPassword, @strCulture, @dbTimeZoneOffSet, @bolObserveDST, @strDateTimeFormat, @intFirstDayOfWeek, @strFirstName, @strLastName, @strCompanyName, @strJobTitle, @strPublicEmail, @strWebAddress, @strBlogAddress, @strMSN, @strSkype, @strYIM, @strAIM, @strICQ, @strLocation, @intDOBDay, @intDOBMonth, @intDOBYear, @strIPAddress, @strLdapUsername)

	-- set output parameter
	SET @intIdentity = @@IDENTITY


	
END
ELSE -- we are updating an existing record
BEGIN
	
	-- update user
	UPDATE InstantASP_Users SET 
	PrimaryRoleID = @intPrimaryRoleID,
	Username = @strUsername,
	EmailAddress = @strEmailAddress,
	[Password] = @strPassword,
	Culture = @strCulture,
	TimeZoneOffset = @dbTimeZoneOffSet,
	ObserveDaylightSavingTime = @bolObserveDST,
	DateTimeFormat = @strDateTimeFormat,
	FirstDayOfWeek = @intFirstDayOfWeek,
	FirstName = @strFirstName,
	LastName = @strLastName,
	CompanyName = @strCompanyName,
	JobTitle = @strJobTitle,
	PublicEmail = @strPublicEmail,
	WebAddress = @strWebAddress,
	BlogAddress = @strBlogAddress,
	MSN = @strMSN,
	Skype = @strSkype,
	YIM = @strYIM,
	AIM = @strAIM,
	ICQ = @strICQ,
	Location = @strLocation,
	DOBDay = @intDOBDay,
	DOBMonth = @intDOBMonth,
	DOBYear = @intDOBYear,
	IPAddress = @strIPAddress,
	LdapUsername = @strLdapUsername
	WHERE (InstantASP_Users.UserID = @intUserID)

	-- set output parameter
	SET @intIdentity = @intUserID

END

RETURN
