

---------------------------------------------------

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE iasp_sp_DeleteTag (
@intApplicationID tinyint,
@strTag nvarchar(255)
) AS
SET NOCOUNT ON 

/* Deletes all tags for a specific entity (article, download, post) from the InstantASP_Tags table */

DELETE FROM InstantASP_Tags WHERE (InstantASP_Tags.ApplicationID = @intApplicationID AND
 InstantASP_Tags.TagKeyword = @strTag OR InstantASP_Tags.TagKeywordEncoded = @strTag)

RETURN
GO

---------------------------------------------------

ALTER TABLE InstantKB_Attachments Add DisplayFileName nvarchar(255)  DEFAULT('')  NOT NULL 

---------------------------------------------------

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_InsertAttachment] (
@intUserID int,
@intRelatedEntityID int,
@intAttachmentType tinyint,
@strFileName nvarchar(255),
@strDisplayFileName nvarchar(255),
@strContentType nvarchar(100),
@intContentLength int,
@binPostedFile image, 
@intIdentity int output
)
AS

SET NOCOUNT ON 

/* Inserts a new attachment into InstantKB_Attachments */

INSERT INTO InstantKB_Attachments (UserID, RelatedEntityID, AttachmentType, [Filename], DisplayFileName, ContentType, ContentLength, AttachmentBLOB) VALUES
(@intUserID, @intRelatedEntityID, @intAttachmentType, @strFileName, @strDisplayFileName, @strContentType, @intContentLength, @binPostedFile)

-- return the new identity

SET @intIdentity = @@IDENTITY

RETURN


---------------------------------------------------

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_InsertArticleCommentRating] (
@intCommentID int,
@bolHelpful bit,
@intUserID int,
@strIPAddress nvarchar(255),
@intIdentity int output
)
AS

SET NOCOUNT ON 

DECLARE @intCommentRatingID int

IF (@intUserID > 0)
BEGIN
SET @intCommentRatingID = (SELECT TOP 1 CommentRatingID FROM InstantKB_ArticleCommentRatings WHERE (CommentID = @intCommentID) AND (UserID = @intUserID))
END
ELSE
BEGIN
SET @intCommentRatingID = (SELECT TOP 1 CommentRatingID FROM InstantKB_ArticleCommentRatings WHERE (CommentID = @intCommentID) AND (IPAddress = @strIPAddress))
END

SET @intCommentRatingID = IsNull(@intCommentRatingID,0)

-- check to see if user has already rated article
IF (@intCommentRatingID <> 0)
BEGIN

	UPDATE InstantKB_ArticleCommentRatings SET
	UserID = @intUserID,
	CommentID = @intCommentID,
	Helpful = @bolHelpful,
	IPAddress = @strIPAddress
	WHERE InstantKB_ArticleCommentRatings.CommentRatingID = @intCommentRatingID	
		
	-- set to new inserted identity	
	SET @intIdentity = 0

END
ELSE
BEGIN

	-- user has not previously rated article
	INSERT INTO InstantKB_ArticleCommentRatings (UserID, CommentID, Helpful, IPAddress) VALUES (@intUserID, @intCommentID, @bolHelpful, @strIPAddress)
	
	-- set to new inserted identity	
	SET @intIdentity = @@IDENTITY

END

-- update counts
EXEC ikb_sp_UpdateArticleCommentRating @intCommentID

GO


---------------------------------------------------


GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_InsertArticleRating] (
@intArticleID int,
@intRating tinyint,
@intUserID int,
@strIPAddress nvarchar(255),
@intIdentity int output
)
AS

SET NOCOUNT ON 

DECLARE @intArticleRatingID int

IF (@intUserID > 0) 
BEGIN
SET @intArticleRatingID = (SELECT TOP 1 ArticleRatingID FROM InstantKB_ArticleRatings WHERE (ArticleID = @intArticleID AND UserID = @intUserID))
END
ELSE
BEGIN
SET @intArticleRatingID = (SELECT TOP 1 ArticleRatingID FROM InstantKB_ArticleRatings WHERE (ArticleID = @intArticleID AND IPAddress = @strIPAddress))
END


SET @intArticleRatingID = IsNull(@intArticleRatingID,0)

-- check to see if user has already rated article
IF (@intArticleRatingID <> 0)
BEGIN

	UPDATE InstantKB_ArticleRatings SET
	UserID = @intUserID,
	ArticleID = @intArticleID,
	ArticleRating = @intRating,
	IPAddress = @strIPAddress
	WHERE InstantKB_ArticleRatings.ArticleRatingID = @intArticleRatingID	
		
	-- set to new inserted identity	
	SET @intIdentity = 0

END
ELSE
BEGIN

	-- user has not previously rated article
	INSERT INTO InstantKB_ArticleRatings (UserID, ArticleID, ArticleRating, IPAddress) VALUES (@intUserID, @intArticleID, @intRating, @strIPAddress)
	
	-- set to new inserted identity	
	SET @intIdentity = @@IDENTITY

END

-- update articles table with mean number
EXEC ikb_sp_UpdateArticleRatingMeanNumber @intArticleID

GO


----------------------------------------------------

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_SelectArticleComments] (
@intArticleID int,
@intAccessType tinyint,
@intSortOrder tinyint
) AS
SET NOCOUNT ON
 
/* Returns all anonymous and member public comments for an article */


IF (@intAccessType > 0)
BEGIN
	SELECT InstantKB_Users.MemberLevelTitle, InstantKB_Users.MemberLevelImage, InstantKB_Users.PhotoImage,(SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName, InstantKB_Users.RecognitionPoints, InstantKB_ArticleComments.* FROM InstantKB_Users
	INNER JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID RIGHT OUTER JOIN InstantKB_ArticleComments ON InstantASP_Users.UserID = InstantKB_ArticleComments.UserID 
	WHERE (InstantKB_ArticleComments.ArticleID = @intArticleID AND InstantKB_ArticleComments.AccessType = @intAccessType) ORDER BY
	CASE 
	WHEN @intSortOrder = 1 THEN DateStamp 
	END DESC,
	CASE
	WHEN @intSortOrder = 2 THEN DateStamp 
	END ASC,
	CASE
	WHEN @intSortOrder = 3 THEN MarkedAsHelpFul 
	END	DESC
END
ELSE
BEGIN
	SELECT InstantKB_Users.MemberLevelTitle, InstantKB_Users.MemberLevelImage, InstantKB_Users.PhotoImage,  (SELECT InstantASP_Roles.RoleName From InstantASP_Roles WHERE RoleID = InstantASP_Users.PrimaryRoleID) AS RoleName, InstantKB_Users.RecognitionPoints, InstantKB_ArticleComments.* FROM InstantKB_Users 
	INNER JOIN InstantASP_Users ON InstantKB_Users.UserID = InstantASP_Users.UserID RIGHT OUTER JOIN InstantKB_ArticleComments ON InstantASP_Users.UserID = InstantKB_ArticleComments.UserID 
	WHERE (InstantKB_ArticleComments.ArticleID = @intArticleID) ORDER BY
	CASE 
	WHEN @intSortOrder = 1 THEN DateStamp 
	END DESC,
	CASE
	WHEN @intSortOrder = 2 THEN DateStamp 
	END ASC,
	CASE
	WHEN @intSortOrder = 3 THEN MarkedAsHelpFul 
	END	DESC
END





----------------------------------------------------

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER PROCEDURE [iasp_sp_InsertUser] (
@strEmailAddress nvarchar(255),
@strPassword nvarchar(255),
@strUsername nvarchar(255),
@intPrimaryRoleID int,
@strCulture nvarchar(20),
@strIPAddress nvarchar(20),
@dblTimeZoneOffset float,
@bitObserveDaylightSavingTime bit,
@strDateTimeFormat char(1),
@strConfirmationCode nvarchar(25),
@strLdapUsername nvarchar(255),
@intIdentity int output
) AS
SET NOCOUNT ON 
/* Ensure the email address is not already present within the table */
IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE InstantASP_Users.EmailAddress = @strEmailAddress)
BEGIN 
	SET @intIdentity = 0
	RETURN
END
/* Ensure the username is not already present within the table */
IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE InstantASP_Users.Username = @strUsername)
BEGIN 
	SET @intIdentity = -1
	RETURN
END
/* Inserts a new user into the InstantASP_Users table and returns the new user identity */
INSERT INTO InstantASP_Users (EmailAddress, Username, [Password], PrimaryRoleID, Culture, IPAddress, TimeZoneOffset, ObserveDaylightSavingTime, DateTimeFormat, TotalVisits, CreatedDate, LastLoginDate, ConfirmationCode, LdapUsername)
VALUES (@strEmailAddress, @strUsername, @strPassword, @intPrimaryRoleID, @strCulture, @strIPAddress, @dblTimeZoneOffset, @bitObserveDaylightSavingTime, @strDateTimeFormat, 0, GetDate(), GetDate(), @strConfirmationCode, @strLdapUsername)
SET @intIdentity = @@IDENTITY
RETURN
