-----------------------------------------------------------
-- InstantKB 2011-2 to 2014
-----------------------------------------------------------

ALTER TABLE InstantASP_Users ADD RecognitionPoints  		INT DEFAULT(0) NOT NULL;
ALTER TABLE InstantASP_Users ADD PasswordHash  				IMAGE DEFAULT('') NOT NULL;
ALTER TABLE InstantASP_Users ADD PasswordSalt  				INT DEFAULT(0) NOT NULL;
ALTER TABLE InstantASP_Users ADD GooglePlus  				nvarchar(100) DEFAULT('') NOT NULL;
ALTER TABLE InstantKb_Articles ADD ArticleImageUrl  		nvarchar(255) DEFAULT('') NOT NULL;

GO

CREATE TABLE InstantASP_ViewState
(
[Key]							nvarchar(255) DEFAULT ('') NOT NULL,
Value                           nvarchar(max) DEFAULT ('') NOT NULL,
DateStamp						DateTime DEFAULT(GetDate()) NOT NULL
)
ON [PRIMARY]

GO

CREATE PROCEDURE [iasp_sp_InsertViewState] (
@strKey nvarchar(255),
@strValue nvarchar(max)
)
AS

/* Adds view state inforamtion */

SET NOCOUNT ON 
		
	INSERT INTO InstantASP_ViewState ([Key], Value) 
	VALUES (@strKey, @strValue) -- add new session data

RETURN


GO


CREATE PROCEDURE [iasp_sp_SelectViewState] (
@strKey nvarchar(255)
)
AS

/* Adds view state inforamtion */

SET NOCOUNT ON 
		
SELECT Value FROM InstantASP_ViewState WHERE [Key] = @strKey

RETURN

GO

ALTER PROCEDURE [iasp_sp_SelectUserData] (
@strUsername nvarchar(255),
@strPassword nvarchar(255),
@strEncyptedPassword nvarchar(255),
@intLoginUsing int,
@intUserID int
) AS
SET NOCOUNT ON 
DECLARE @RoleNames nvarchar(600)
/* @intLoginUsing determines if we should use the username or email address field for the login field
    @intLoginUsing = 1 we use the email address
    @intLoginUsing = 2 we use the username */

-- @intLocalUserID is used to return a second query with all user roles
DECLARE @intLocalUserID int

/* If we have a user identity use this to select data */
IF (@intUserID > 0)
BEGIN	
	SELECT * FROM InstantASP_Users WITH (nolock) WHERE (InstantASP_Users.UserID = @intUserID)
	SET @intLocalUserID = @intUserID
END
ELSE
BEGIN
	
		-- check member based on email or username (see above) and password
		IF (@strPassword <> '' OR @strEncyptedPassword <> '')
	BEGIN
		-- login using email address
		IF  (@intLoginUsing = 1) 
		BEGIN
			SELECT * FROM InstantASP_Users IU WITH (nolock) WHERE (IU.EmailAddress = @strUsername)  AND (IU.[Password] = @strPassword OR IU.[Password] = @strEncyptedPassword)
			SET @intLocalUserID = (SELECT IU.UserID FROM InstantASP_Users IU WITH (nolock) WHERE (IU.EmailAddress = @strUsername)  AND (IU.[Password] = @strPassword OR IU.[Password] = @strEncyptedPassword))
		END
		ELSE IF   (@intLoginUsing = 2) -- login using username
		BEGIN
			SELECT * FROM InstantASP_Users IU WITH (nolock) WHERE (IU.Username = @strUsername)  AND (IU.[Password] = @strPassword OR IU.[Password] = @strEncyptedPassword)
			SET @intLocalUserID = (SELECT IU.UserID FROM InstantASP_Users IU WITH (nolock) WHERE (IU.Username = @strUsername)  AND (IU.[Password] = @strPassword OR IU.[Password] = @strEncyptedPassword))
		END
	END
	ELSE
	BEGIN
	
		SELECT * FROM InstantASP_Users IU WITH (nolock) WHERE (IU.EmailAddress = @strUsername OR IU.Username = @strUsername OR IU.UsernameEncoded = @strUsername OR IU.OpenID = @strUsername)
		SET @intLocalUserID = (SELECT IU.UserID FROM InstantASP_Users IU WITH (nolock) WHERE (IU.EmailAddress = @strUsername OR IU.Username = @strUsername OR IU.UsernameEncoded = @strUsername OR IU.OpenID = @strUsername))
	
	END
END

-- select roles for user
EXEC iasp_sp_SelectUserRoles @intLocalUserID

RETURN

GO


ALTER PROCEDURE [iasp_sp_InsertUpdateUser] (
@intUserID int,
@intPrimaryRoleID int,
@strUsername nvarchar(155),
@strUsernameEncoded nvarchar(155),
@strEmailAddress nvarchar(155),
@strPassword nvarchar(155),
@intPasswordSalt int,
@strCulture nvarchar(10),
@dbTimeZoneOffSet float,
@bolObserveDST bit,
@strDateTimeFormat nvarchar(20),
@intFirstDayOfWeek tinyint,
@strFirstName nvarchar(155),
@strLastName nvarchar(155),
@strCompanyName nvarchar(155),
@strJobTitle nvarchar(155),
@strPublicEmail nvarchar(155),
@strWebAddress nvarchar(255),
@strBlogAddress nvarchar(255),
@strOpenID nvarchar(255),
@strPhotoImage nvarchar(200),
@strMSN nvarchar(155),
@strSkype nvarchar(155),
@strAIM nvarchar(155),
@strYIM nvarchar(155),
@strICQ nvarchar (155),
@strTwitter nvarchar (75),
@strFacebook nvarchar (75),
@strGooglePlus nvarchar (75),
@strLinkedIn nvarchar (75),
@strMySpace nvarchar(100),
@strYouTube nvarchar(100),
@strLocation nvarchar(155),
@intDOBDay tinyint,
@intDOBMonth tinyint,
@intDOBYear int,
@strUserLevelTitle nvarchar(100),
@strUserLevelImageURL nvarchar(100),
@strIPAddress nvarchar(20),
@strLdapUsername nvarchar(255),
@strConfirmationCode nvarchar(50),
@intRecognitionPoints int,
@intIdentity int output

) 
AS

SET NOCOUNT ON 

/* Inserts or updates a user within InstantASP_Users */

-- is this an update or insert?
IF (@intUserID = 0)
BEGIN

	/* Ensure the username is not already present within the table */
	IF (@strUsername <> '')
	BEGIN
		IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE InstantASP_Users.Username = @strUsername OR InstantASP_Users.UsernameEncoded = @strUsernameEncoded)
		BEGIN 
			SET @intIdentity = -1
			RETURN
		END
	END
	
	/* Ensure the email address is not already present within the table */
	IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE InstantASP_Users.EmailAddress = @strEmailAddress)
	BEGIN 
		SET @intIdentity = -2
		RETURN
	END

	-- insert user
	INSERT INTO InstantASP_Users (
	PrimaryRoleID, 
	Username, 
	UsernameEncoded,
	EmailAddress, 
	[Password], 
	PasswordSalt,
	Culture, 
	TimeZoneOffset, 
	ObserveDaylightSavingTime, 
	DateTimeFormat, 
	FirstDayOfWeek, 
	FirstName, 
	LastName, 
	CompanyName, 
	JobTitle, 
	PublicEmail, 
	WebAddress, 
	BlogAddress, 
	OpenID,
	PhotoImage, 	
	MSN, 
	Skype, 
	YIM, 
	AIM, 
	ICQ, 
	Twitter, 
	Facebook, 
	GooglePlus,
	LinkedIn, 
	MySpace,
	YouTube,
	Location, 
	DOBDay, 
	DOBMonth, 
	DOBYear, 
	UserLevelTitle, 
	UserLevelImageURL, 
	IPAddress, 
	LdapUsername,
	ConfirmationCode,
	RecognitionPoints,
	TotalVisits 
	) 
	VALUES
	(
	@intPrimaryRoleID, 
	@strUsername, 
	@strUsernameEncoded,
	@strEmailAddress, 
	@strPassword, 
	@intPasswordSalt,
	@strCulture, 
	@dbTimeZoneOffSet, 
	@bolObserveDST, 
	@strDateTimeFormat, 
	@intFirstDayOfWeek, 
	@strFirstName, 
	@strLastName, 
	@strCompanyName, 
	@strJobTitle, 
	@strPublicEmail, 
	@strWebAddress, 
	@strBlogAddress, 
	@strOpenID, 
	@strPhotoImage, 
	@strMSN, 
	@strSkype, 
	@strYIM, 
	@strAIM, 
	@strICQ, 
	@strTwitter, 
	@strFacebook, 
	@strGooglePlus,
	@strLinkedIn, 
	@strMySpace, 
	@strYouTube, 
	@strLocation, 
	@intDOBDay, 
	@intDOBMonth, 
	@intDOBYear, 
	@strUserLevelTitle, 
	@strUserLevelImageURL, 
	@strIPAddress, 
	@strLdapUsername, 
	@strConfirmationCode,
	@intRecognitionPoints, 0)

	-- set output parameter
	SET @intIdentity = @@IDENTITY


	
END
ELSE -- we are updating an existing record
BEGIN

	IF (@strUsername <> '')
	BEGIN
		IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE Username = @strUsername AND UserID <> @intUserID)
		BEGIN
			SET @intIdentity = - 1
			RETURN
		END 
	END

	-- Check to see if email address already exists for any other user

	IF EXISTS(SELECT UserID FROM InstantASP_Users WHERE EmailAddress = @strEmailAddress AND UserID <> @intUserID)
	BEGIN
		SET @intIdentity = - 2
		RETURN
	END 

	-- update user
	UPDATE InstantASP_Users SET 
	PrimaryRoleID = @intPrimaryRoleID,
	Username = @strUsername,
	UsernameEncoded = @strUsernameEncoded,
	EmailAddress = @strEmailAddress,
	[Password] = @strPassword,
	PasswordSalt = @intPasswordSalt,
	Culture = @strCulture,
	TimeZoneOffset = @dbTimeZoneOffSet,
	ObserveDaylightSavingTime = @bolObserveDST,
	DateTimeFormat = @strDateTimeFormat,
	FirstDayOfWeek = @intFirstDayOfWeek,
	FirstName = @strFirstName,
	LastName = @strLastName,
	CompanyName = @strCompanyName,
	JobTitle = @strJobTitle,
	PublicEmail = @strPublicEmail,
	WebAddress = @strWebAddress,
	BlogAddress = @strBlogAddress,
	OpenID = @strOpenID,
	PhotoImage = @strPhotoImage,
	MSN = @strMSN,
	Skype = @strSkype,
	YIM = @strYIM,
	AIM = @strAIM,
	ICQ = @strICQ,
	Twitter = @strTwitter,
	Facebook = @strFacebook,
	GooglePlus = @strGooglePlus,
	LinkedIn = @strLinkedIn,
	MySpace = @strMySpace,
	YouTube = @strYouTube,
	Location = @strLocation,
	DOBDay = @intDOBDay,
	DOBMonth = @intDOBMonth,
	DOBYear = @intDOBYear,
	IPAddress = @strIPAddress,
	UserLevelTitle = @strUserLevelTitle,
	UserLevelImageURL = @strUserLevelImageURL,
	LdapUsername = @strLdapUsername,
	ConfirmationCode = @strConfirmationCode,
	RecognitionPoints = @intRecognitionPoints
	WHERE (InstantASP_Users.UserID = @intUserID)

	-- set output parameter
	SET @intIdentity = @intUserID

END

RETURN


GO

-----------------------------------------

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_InsertUpdateUser] (
@intUserID int,
@bolIsAnonymous bit,
@intPermissionID int,
@intStaffPermissionID int,
@intPrimaryDeptID int,
@intRecognitionPoints int,
@strSkin nvarchar(100),
@strMemberLevelTitle nvarchar(155),
@strMemberLevelImage nvarchar(155),
@strPhotoImage nvarchar(155),
@strInterests nvarchar(255),
@strSignature ntext,
@strNotes ntext,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a user within InstantKB_Users */

-- is this an update or insert?
IF NOT EXISTS(SELECT UserID FROM InstantKB_Users WHERE InstantKB_Users.UserID = @intUserID)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Users (UserID, IsAnonymous, PermissionID, StaffPermissionID, PrimaryDeptID, RecognitionPoints, Skin, MemberLevelTitle, MemberLevelImage, PhotoImage, Interests, Signature, Notes) VALUES
	(@intUserID, @bolIsAnonymous, @intPermissionID, @intStaffPermissionID, @intPrimaryDeptID, @intRecognitionPoints, @strSkin, @strMemberLevelTitle, @strMemberLevelImage, @strPhotoImage, @strInterests, @strSignature, @strNotes)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY

	RETURN

END
ELSE -- we are updating
BEGIN

	-- update
	UPDATE InstantKB_Users SET
	IsAnonymous = @bolIsAnonymous,
	PermissionID = @intPermissionID,
	StaffPermissionID = @intStaffPermissionID,
	PrimaryDeptID = @intPrimaryDeptID,
	RecognitionPoints = @intRecognitionPoints,
	Skin = @strSkin,
	MemberLevelTitle = @strMemberLevelTitle,
	MemberLevelImage = @strMemberLevelImage,
	PhotoImage = @strPhotoImage,
	Interests = @strInterests,
	Signature = @strSignature,
	Notes = @strNotes
	WHERE InstantKB_Users.UserID = @intUserID

	-- return the identity
	SET @intIdentity = @intUserID

	RETURN

END

SET @intIdentity = 0
RETURN


GO

--------------------------------


ALTER PROCEDURE [ikb_sp_InsertUpdateArticle] (
@intArticleID int,
@intArticleParentID int,
@intArticleCategoryID int,
@strArticleTitle nvarchar(500),
@strArticleText ntext,
@intArticlePercentComplete int,
@intArticleTypeID int,
@intArticleLevelID int,
@intArticleStatusID int,
@intArticlePriorityID int,
@intArticleAccessType tinyint,
@intArticleWorkFlowStepID int,
@intArticleCreatedUserID int,
@intArticleModifiedUserID int,
@intArticleAssignedUserID int,
@dtArticleAssignedDate datetime,
@intArticleSuggestedUserID int,
@strArticleSuggestedUsername nvarchar(255),
@strArticleSuggestedEmail nvarchar(255),
@dtArticleSuggestedDate datetime,
@intArticleReportedUserID int,
@dtArticleReportedDate datetime,
@dtArticleDueDate datetime,
@dtArticleReviewDate datetime,
@dtArticleExpiresDate datetime,
@intTabID int,
@strArticleTitleEncoded nvarchar(500),
@strArticleDownloadFile nvarchar(255),
@strArticleDownloadLink nvarchar(255),
@strArticleDownloadPassword nvarchar(255),
@strArticleImageUrl nvarchar(255),
@bolUpdateLastModified bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a article within the InstantKB_Articles table */

-- setup variables to hold usernames obtained from identities

DECLARE @dtArticleModifiedDate datetime
DECLARE @strArticleModifiedUsername nvarchar(255)

DECLARE @strArticleCreatedUsername nvarchar(255)
DECLARE @strArticleAssignedUsername nvarchar(255)
DECLARE @strArticleReportedUsername nvarchar(255)

SET @strArticleCreatedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleCreatedUserID))
SET @strArticleAssignedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleAssignedUserID))
SET @strArticleReportedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleReportedUserID))
SET @strArticleModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleModifiedUserID))
SET @dtArticleModifiedDate = GetDate()

-- is this an update or insert?
IF (@intArticleID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Articles 
		(ArticleParentID, 
		ArticleCategoryID,
		ArticleTitle, 
		ArticleTitleEncoded,
		ArticleText, 
		ArticlePercentComplete, 
		ArticleTypeID, 
		ArticleLevelID, 
		ArticleStatusID, 
		ArticlePriorityID, 
		ArticleAccessType, 
		ArticleWorkFlowStepID, 
		ArticleCreatedUserID, 
		ArticleCreatedUsername, 
		ArticleCreatedDate, 
		ArticleModifiedUserID, 
		ArticleModifiedUsername,
		ArticleModifiedDate,
		ArticleAssignedUserID,
		ArticleAssignedUsername,
		ArticleAssignedDate,
		ArticleSuggestedUserID,
		ArticleSuggestedUsername,
		ArticleSuggestedEmail,
		ArticleSuggestedDate,
		ArticleReportedUserID,
		ArticleReportedUsername,
		ArticleReportedDate,
		ArticleDueDate,
		ArticleReviewDate,
		ArticleExpiresDate,
		TabID,
		ArticleDownloadFile,
		ArticleDownloadLink, 
		ArticleDownloadPassword,
		ArticleImageUrl
	)
	VALUES 
		(@intArticleParentID,
		@intArticleCategoryID,
		@strArticleTitle,
		@strArticleTitleEncoded,
		@strArticleText,
		@intArticlePercentComplete,
		@intArticleTypeID,
		@intArticleLevelID,
		@intArticleStatusID,
		@intArticlePriorityID,
		@intArticleAccessType,
		@intArticleWorkFlowStepID,
		@intArticleCreatedUserID,
		IsNull(@strArticleCreatedUsername,''),
		GetDate(),
		@intArticleModifiedUserID,
		IsNull(@strArticleModifiedUsername,''),
		GetDate(),		
		@intArticleAssignedUserID,
		IsNull(@strArticleAssignedUsername,''),
		@dtArticleAssignedDate,
		@intArticleSuggestedUserID,
		@strArticleSuggestedUsername,
		@strArticleSuggestedEmail,
		@dtArticleSuggestedDate,
		@intArticleReportedUserID,
		IsNull(@strArticleReportedUsername,''),
		@dtArticleReportedDate,
		@dtArticleDueDate,
		@dtArticleReviewDate,
		@dtArticleExpiresDate,
		@intTabID,
		@strArticleDownloadFile,
		@strArticleDownloadLink,
		@strArticleDownloadPassword, 
		@strArticleImageUrl
	)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update modified by?
	IF (@bolUpdateLastModified = 0)
	BEGIN
		SET @dtArticleModifiedDate = (SELECT ArticleModifiedDate FROM InstantKB_Articles WHERE ArticleID = @intArticleID)
		SET @intArticleModifiedUserID = (SELECT ArticleModifiedUserID FROM InstantKB_Articles WHERE ArticleID = @intArticleID)
	SET @intArticleModifiedUserID = (SELECT ArticleModifiedUserID FROM InstantKB_Articles WHERE ArticleID = @intArticleID)
	END

	-- update
	UPDATE InstantKB_Articles SET
	ArticleParentID = @intArticleParentID, 
	ArticleCategoryID = @intArticleCategoryID,
	ArticleTitle = @strArticleTitle, 
	ArticleTitleEncoded = @strArticleTitleEncoded,
	ArticleText = @strArticleText, 
	ArticlePercentComplete = @intArticlePercentComplete, 
	ArticleTypeID = @intArticleTypeID, 
	ArticleLevelID = @intArticleLevelID, 
	ArticleStatusID = @intArticleStatusID, 
	ArticlePriorityID = @intArticlePriorityID, 
	ArticleAccessType = @intArticleAccessType,
	ArticleWorkFlowStepID = @intArticleWorkFlowStepID, 
	ArticleModifiedUserID = @intArticleModifiedUserID, 
	ArticleModifiedUsername = IsNull(@strArticleModifiedUsername,''),
	ArticleModifiedDate = @dtArticleModifiedDate,
	ArticleAssignedUserID = @intArticleAssignedUserID,
	ArticleAssignedUsername = IsNull(@strArticleAssignedUsername,''),
	ArticleAssignedDate = @dtArticleAssignedDate,
	ArticleSuggestedUserID = @intArticleSuggestedUserID,
	ArticleSuggestedUsername = @strArticleSuggestedUsername,
	ArticleSuggestedEmail = @strArticleSuggestedEmail,
	ArticleSuggestedDate = @dtArticleSuggestedDate,
	ArticleReportedUserID = @intArticleReportedUserID,
	ArticleReportedUsername = IsNull(@strArticleReportedUsername,''),
	ArticleReportedDate = @dtArticleReportedDate,
	ArticleDueDate = @dtArticleDueDate,
	ArticleReviewDate = @dtArticleReviewDate,
	ArticleExpiresDate = @dtArticleExpiresDate,
	TabID = @intTabID,
	ArticleDownloadFile = @strArticleDownloadFile,
	ArticleDownloadLink = @strArticleDownloadLink,
	ArticleDownloadPassword = @strArticleDownloadPassword,
	ArticleImageUrl = @strArticleImageUrl
	WHERE InstantKB_Articles.ArticleID = @intArticleID

	-- return the identity
	SET @intIdentity = @intArticleID
	RETURN

END

SET @intIdentity = 0
RETURN


GO

------------------------------------------------------

ALTER TABLE InstantKb_ArticleComments ADD IPAddress  		nvarchar(20) DEFAULT('') NOT NULL;

GO

ALTER PROCEDURE [ikb_sp_InsertUpdateArticleComment] (
@intCommentID int,
@intUserID int,
@strUsername nvarchar(255),
@strEmailAddress nvarchar(255),
@strWebAddress nvarchar(255),
@intArticleID int,
@strComments ntext,
@intAccessType tinyint,
@intLastModifiedByUserID int,
@strLastModifiedByUsername nvarchar(255),
@strIPAddress nvarchar(20),
@intIdentity int output
)
AS
SET NOCOUNT ON 

IF (@intCommentID = 0)
BEGIN

	/* Insert comment into InstantKB_ArticleComments */
	INSERT INTO InstantKB_ArticleComments ( UserID, Username,  EmailAddress, WebAddress, ArticleID, Comments, AccessType, LastModifiedByUserID, LastModifiedByUsername, LastModifiedDateStamp, IPAddress, DateStamp) 
	VALUES (@intUserID, @strUsername, @strEmailAddress, @strWebAddress, @intArticleID, @strComments, @intAccessType, @intLastModifiedByUserID, @strLastModifiedByUsername, GetDate(), @strIPAddress, GetDate())

	-- set return identity
	SET @intIdentity = @@IDENTITY

END
ELSE
BEGIN

	UPDATE InstantKB_ArticleComments SET
	UserID = @intUserID,
	Username = @strUsername,
	EmailAddress = @strEmailAddress,
	WebAddress = @strWebAddress,
	ArticleID = @intArticleID,
	Comments = @strComments,
	AccessType = @intAccessType,
	LastModifiedByUserID = @intLastModifiedByUserID,
	LastModifiedByUsername = @strLastModifiedByUsername,
	LastModifiedDateStamp = GetDate(),
	IPAddress = @strIPAddress
	WHERE (InstantKB_ArticleComments.CommentID = @intCommentID)

	-- set return identity
	SET @intIdentity = @intCommentID
	
END


-- update article to indicate comments
DECLARE @intTotalComments int
SET @intTotalComments = (SELECT COUNT(CommentID) FROM InstantKB_ArticleComments WHERE InstantKB_ArticleComments.ArticleID = @intArticleID AND AccessType = 1)
UPDATE InstantKB_Articles SET InstantKB_Articles.CommentCount = @intTotalComments WHERE (InstantKB_Articles.ArticleID = @intArticleID)

RETURN @intIdentity

GO

-- add new homepage sections setting
IF NOT EXISTS(SELECT InstantKB_Settings.SettingID FROM InstantKB_Settings WHERE SettingText = 'AdminSettings_HomeLayout') 
BEGIN
	INSERT INTO InstantKB_Settings (SettingText,SettingDesc,SettingsXML) VALUES('AdminSettings_HomeLayout','AdminSettings_HomeLayoutDesc','')
END

------------------------
-- BETA 1 to BETA 2
------------------------

GO

ALTER TABLE InstantKB_ArticleRead ADD IPAddress  		nvarchar(30) DEFAULT('') NOT NULL;
ALTER TABLE InstantKB_ArticleRead ADD Referrer  		nvarchar(250) DEFAULT('') NOT NULL;
ALTER TABLE InstantASP_Searches ADD Results  			int DEFAULT(0) NOT NULL;
ALTER TABLE InstantKB_WorkFlowSteps ADD MarkedAsClosed	tinyint DEFAULT(0) NOT NULL;
ALTER TABLE InstantKB_ArticleRatings ADD DateStamp		datetime DEFAULT(GetDate());

GO

UPDATE InstantKB_ArticleRatings SET DateStamp = NULL;

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [dbo].[ikb_sp_InsertArticleRead] (
@intArticleID int,
@intUserID int,
@strIPAddress nvarchar(30),
@strReferrer nvarchar(250),
@dtArticleReadExpires datetime
)
AS
SET NOCOUNT ON 

/* Add new read data to table */
INSERT INTO InstantKB_ArticleRead (
	ArticleReadArticleID, 
	ArticleReadUserID, 
	IPAddress, 
	Referrer, 
	ArticleReadDate, 
	ArticleReadExpires
) VALUES (
	@intArticleID, 
	@intUserID,
	 @strIPAddress, 
	 @strReferrer, 
	 GetDate(), 
	 @dtArticleReadExpires
 )


GO
----

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_InsertWhosOn] (
@intCurrentTask int,
@strUsername nvarchar(255),
@intUserID int,
@intCategoryID int,
@strCategoryName nvarchar(255),
@intArticleID int,
@strArticleTitle nvarchar(255),
@strIPAddress nvarchar(50),
@bitIsAnonymous bit,
@strSessionID nvarchar(200),
@intExpires int,
@intPrimaryRoleID int,
@intArticleReadExpires int,
@strReferrer nvarchar(250)
)
AS
SET NOCOUNT ON 

/* Delete any previous session activity within the who's on table */
DELETE FROM InstantKB_WhosOn WHERE (InstantKB_WhosOn.SessionIdentity = @strSessionID)

-- get current datetime
DECLARE @dtDateTimeNow datetime
SET @dtDateTimeNow = GetDate()

-- are we an authenticated user?
IF (@intUserID > 0) 
BEGIN 
	-- delete all previous instances of the user from the who's on table
	DELETE FROM InstantKB_WhosOn WHERE (InstantKB_WhosOn.UserID = @intUserID) 
END

/* update article view count */
IF (@intArticleID > 0 AND @intCurrentTask = 4)
BEGIN		

	-- track article read 
	DECLARE @dtArticleReadExpires datetime	
	IF (@intArticleReadExpires <= 0) 
	BEGIN
		SET @dtArticleReadExpires = DateAdd(yy, 75, @dtDateTimeNow)
	END 
	ELSE
	BEGIN
		SET @dtArticleReadExpires = DateAdd(d, @intArticleReadExpires, @dtDateTimeNow)
	END
	EXEC ikb_sp_InsertArticleRead @intArticleID, @intUserID, @strIPAddress, @strReferrer, @dtArticleReadExpires

	-- update view count for article
	UPDATE InstantKB_Articles SET InstantKB_Articles.ArticleViews = (InstantKB_Articles.ArticleViews + 1) WHERE (InstantKB_Articles.ArticleID = @intArticleID)

END

/* Insert who's on information into database */
INSERT INTO InstantKB_WhosOn (CurrentTask, Username, UserID, CategoryID, CategoryName, ArticleID, ArticleTitle, IPAddress, IsAnonymous, SessionIdentity, Expires, PrimaryRoleID)
VALUES (@intCurrentTask, @strUsername, @intUserID, @intCategoryID, @strCategoryName, @intArticleID, @strArticleTitle, @strIPAddress, @bitIsAnonymous, @strSessionID,  DateAdd(n, @intExpires, @dtDateTimeNow), @intPrimaryRoleID)

GO

--------------

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE iasp_sp_InsertSearchTerm (
@strKeywords nvarchar(255),
@intUserID int,
@strIPAddress nvarchar(30),
@intContentType int,
@intApplicationID tinyint,
@intResults int,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a user search within the InstantASP_Searches table */

-- insert the term
INSERT INTO InstantASP_Searches (
	Keywords, 
	UserID,
	IPAddress,
	ContentType,
	ApplicationID,
	Results,
	DateStamp
) VALUES
(
	@strKeywords, 
	@intUserID,
	@strIPAddress,
	@intContentType,
	@intApplicationID,
	@intResults,
	GetDate()
)
	
-- return the terms new identity
SET @intIdentity = @@IDENTITY
RETURN
	

GO

----------

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [iasp_sp_SelectSearchTermsPaged] (
@intPageIndex int,
@intPageSize int,
@strSQLPopulate nvarchar(4000),
@strSQLCount nvarchar(4000),
@bolReturnRecordCount bit
)
AS

SET NOCOUNT ON

-- vars
DECLARE @intPageLowerBound int
DECLARE @intPageUpperBound int
DECLARE @intRowsToReturn int

-- set page index to zero based ordinal
SET @intPageIndex = (@intPageIndex - 1)

-- set the row count
SET @intRowsToReturn = @intPageSize * (@intPageIndex + 1)
SET ROWCOUNT @intRowsToReturn

-- set the bounds
SET @intPageLowerBound = @intPageSize * @intPageIndex
SET @intPageUpperBound = @intPageLowerBound + @intPageSize + 1

-- create  temporary table
CREATE TABLE #PageIndex 
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	SearchItemID int
)

-- insert data 
INSERT INTO #PageIndex (SearchItemID)
EXECUTE sp_executesql @strSQLPopulate

-- select the data to return
SELECT InstantASP_Searches.* 
FROM #PageIndex IPI JOIN InstantASP_Searches ON InstantASP_Searches.SearchItemID = IPI.SearchItemID
WHERE IPI.IndexID > @intPageLowerBound AND IPI.IndexID < @intPageUpperBound 
ORDER BY IPI.IndexID

-- do we need to return a rcord count?
IF (@bolReturnRecordCount =1)
	EXECUTE sp_executesql @strSQLCount

GO

----------------------------------------------------
-- ikb_sp_UpdateWorkFlowStepMarkAsClosed
----------------------------------------------------
GO

CREATE PROCEDURE ikb_sp_UpdateWorkFlowStepMarkAsClosed (
@intWorkFlowStepID int,
@intMarkedAsClosed int
)
AS

SET NOCOUNT ON 

/* set marked as closed action */
UPDATE InstantKB_WorkFlowSteps SET MarkedAsClosed = @intMarkedAsClosed WHERE (WorkFlowStepID = @intWorkFlowStepID)

GO

----------------------------------------------------
-- ikb_sp_SelectArticleRead
----------------------------------------------------

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_SelectArticleRead] (
@intUserID int
)
AS

SET NOCOUNT ON 

SELECT TOP 1000 
MAX(ArticleReadID) AS ArticleReadID,
MAX(ArticleReadArticleID) AS ArticleReadArticleID, 
MAX(ArticleReadDate) AS ArticleReadDate,
MAX(ArticleReadUserID) AS ArticleReadUserID,
MAX(ArticleReadExpires) AS ArticleReadExpires
FROM InstantKB_ArticleRead (nolock) 
WHERE (InstantKB_ArticleRead.ArticleReadUserID = @intUserID)
GROUP BY ArticleReadArticleID

GO
