
/* Update InstantKB.NET 2.0.0 to 2.0.1 */

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [iasp_sp_InsertUpdateField] (
@intFieldID int,
@intApplicationID int,
@strFieldLabel nvarchar(255),
@strFieldLabelNonLocalized nvarchar(255),
@strFieldDescLabel nvarchar(255),
@strFieldDescLabelNonLocalized nvarchar(255),
@intFieldType int,
@intTabID int,
@intPickListID int,
@intStringSize int,
@strDefaultValue nvarchar(255),
@strFormat nvarchar(255),
@strRegExValidation nvarchar(255),
@intSortOrder int,
@bolIsRequired bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a field within the InstantASP_Fields table */

-- is this an update or insert?
IF (@intFieldID = 0)
BEGIN

	-- insert the field
	INSERT INTO InstantASP_Fields (ApplicationID, FieldLabel, FieldLabelNonLocalized, FieldDescLabel, FieldDescLabelNonLocalized, FieldType, TabID, PickListID, StringSize, DefaultValue, [Format], RegExValidation, SortOrder, IsEnabled, IsCustomField, IsRequired, DateStamp) VALUES
	(@intApplicationID, @strFieldLabel, @strFieldLabelNonLocalized, @strFieldDescLabel, @strFieldDescLabelNonLocalized, @intFieldType, @intTabID, @intPickListID, @intStringSize, @strDefaultValue, @strFormat, @strRegExValidation, @intSortOrder, 1, 1, @bolIsRequired, GetDate())

	-- set output parameter
	SET @intIdentity = @@IDENTITY
	
	-- create custom field name
	DECLARE @strCustomFieldName nvarchar(255)
	SET @strCustomFieldName = 'CustomField_' + CAST(@intIdentity AS nvarchar(255)) 
		
	-- add custom field names
	UPDATE InstantASP_Fields SET 
	FieldLabelNonLocalized = @strCustomFieldName, 
	TableFieldName = @strCustomFieldName
	WHERE (InstantASP_Fields.FieldID = @intIdentity)
	
	-- if this field type requires a pick list create one and assoicate with field
	-- Field types that required pick lists are CheckBoxList, RadioButtonLists, Select and Multiple Select lists
	IF (@intFieldType = 4 OR @intFieldType = 6 OR @intFieldType = 12 OR @intFieldType = 13)
	BEGIN
		
		-- holds the new pick list identity
		DECLARE @intPickListIdentity int
		-- add the pick list
		EXEC iasp_sp_InsertUpdatePickList 0, @strCustomFieldName, @intPickListId out
		-- get the new pick list identity
		SELECT @intPickListIdentity = (SELECT @intPickListId)
		-- update pick list identity within fields table
		UPDATE InstantASP_Fields SET PickListID = @intPickListIdentity WHERE InstantASP_Fields.FieldID = @intIdentity
	
	END		

END
ELSE -- we are updating an existing field
BEGIN
	
	-- update field
	UPDATE InstantASP_Fields SET 
	ApplicationID = @intApplicationID, 
	FieldLabel = @strFieldLabel, 
	FieldLabelNonLocalized = @strFieldLabelNonLocalized, 
	FieldDescLabel = @strFieldDescLabel, 
	FieldDescLabelNonLocalized = @strFieldDescLabelNonLocalized, 
	StringSize = @intStringSize, 
	DefaultValue = @strDefaultValue, 
	[Format] = @strFormat, 
	RegExValidation = @strRegExValidation,
	IsRequired = @bolIsRequired,
	DateStamp = GetDate()
	WHERE (InstantASP_Fields.FieldID = @intFieldID)

	-- set output parameter
	SET @intIdentity = @intFieldID
END

RETURN
