
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_DeleteDepartment] (
@intDepartmentID int
)
AS
SET NOCOUNT ON 

/* Deletes a department from the InstantKB_Departments table */

DELETE FROM InstantKB_Departments WHERE (InstantKB_Departments.DepartmentID = @intDepartmentID)

-- get default department identity
DECLARE @intDefaultDepartmentID int
SET @intDefaultDepartmentID = (SELECT TOP 1 DepartmentID FROM InstantKB_Departments WHERE IsDefault = 1)

IF (@intDefaultDepartmentID > 0)
BEGIN

	-- move users in this dept to the default dept
	UPDATE InstantKB_Users SET 
	PRimaryDeptID = @intDefaultDepartmentID
	WHERE PrimaryDeptID = @intDepartmentID

	-- update primary dept within InstantKB_UserDepartments
	UPDATE InstantKB_UserDepartments
	SET DepartmentID = @intDefaultDepartmentID
	WHERE DepartmentID = @intDepartmentID

END

RETURN
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [ikb_sp_InsertUpdateArticle] (
@intArticleID int,
@intArticleParentID int,
@intArticleCategoryID int,
@strArticleTitle nvarchar(500),
@strArticleText ntext,
@intArticlePercentComplete int,
@intArticleTypeID int,
@intArticleLevelID int,
@intArticleStatusID int,
@intArticlePriorityID int,
@intArticleAccessType tinyint,
@intArticleWorkFlowStepID int,
@intArticleCreatedUserID int,
@intArticleModifiedUserID int,
@intArticleAssignedUserID int,
@dtArticleAssignedDate datetime,
@intArticleSuggestedUserID int,
@strArticleSuggestedUsername nvarchar(255),
@strArticleSuggestedEmail nvarchar(255),
@dtArticleSuggestedDate datetime,
@intArticleReportedUserID int,
@dtArticleReportedDate datetime,
@dtArticleDueDate datetime,
@dtArticleReviewDate datetime,
@dtArticleExpiresDate datetime,
@intTabID int,
@strArticleTitleEncoded nvarchar(500),
@strArticleDownloadFile nvarchar(255),
@strArticleDownloadLink nvarchar(255),
@strArticleDownloadPassword nvarchar(255),
@bolUpdateLastModified bit,
@intIdentity int output
) AS

SET NOCOUNT ON 

/* Inserts or updates a article within the InstantKB_Articles table */

-- setup variables to hold usernames obtained from identities

DECLARE @dtArticleModifiedDate datetime
DECLARE @strArticleModifiedUsername nvarchar(255)

DECLARE @strArticleCreatedUsername nvarchar(255)
DECLARE @strArticleAssignedUsername nvarchar(255)
DECLARE @strArticleReportedUsername nvarchar(255)

SET @strArticleCreatedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleCreatedUserID))
SET @strArticleAssignedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleAssignedUserID))
SET @strArticleReportedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleReportedUserID))
SET @strArticleModifiedUsername = (SELECT Username FROM InstantASP_Users WHERE (UserID = @intArticleModifiedUserID))
SET @dtArticleModifiedDate = GetDate()

-- is this an update or insert?
IF (@intArticleID = 0)
BEGIN
	-- insert 
	INSERT INTO InstantKB_Articles 
		(ArticleParentID, 
		ArticleCategoryID,
		ArticleTitle, 
		ArticleTitleEncoded,
		ArticleText, 
		ArticlePercentComplete, 
		ArticleTypeID, 
		ArticleLevelID, 
		ArticleStatusID, 
		ArticlePriorityID, 
		ArticleAccessType, 
		ArticleWorkFlowStepID, 
		ArticleCreatedUserID, 
		ArticleCreatedUsername, 
		ArticleCreatedDate, 
		ArticleModifiedUserID, 
		ArticleModifiedUsername,
		ArticleModifiedDate,
		ArticleAssignedUserID,
		ArticleAssignedUsername,
		ArticleAssignedDate,
		ArticleSuggestedUserID,
		ArticleSuggestedUsername,
		ArticleSuggestedEmail,
		ArticleSuggestedDate,
		ArticleReportedUserID,
		ArticleReportedUsername,
		ArticleReportedDate,
		ArticleDueDate,
		ArticleReviewDate,
		ArticleExpiresDate,
		TabID,
		ArticleDownloadFile,
		ArticleDownloadLink, 
		ArticleDownloadPassword)
	VALUES 
		(@intArticleParentID,
		@intArticleCategoryID,
		@strArticleTitle,
		@strArticleTitleEncoded,
		@strArticleText,
		@intArticlePercentComplete,
		@intArticleTypeID,
		@intArticleLevelID,
		@intArticleStatusID,
		@intArticlePriorityID,
		@intArticleAccessType,
		@intArticleWorkFlowStepID,
		@intArticleCreatedUserID,
		IsNull(@strArticleCreatedUsername,''),
		GetDate(),
		@intArticleModifiedUserID,
		IsNull(@strArticleModifiedUsername,''),
		GetDate(),		
		@intArticleAssignedUserID,
		IsNull(@strArticleAssignedUsername,''),
		@dtArticleAssignedDate,
		@intArticleSuggestedUserID,
		@strArticleSuggestedUsername,
		@strArticleSuggestedEmail,
		@dtArticleSuggestedDate,
		@intArticleReportedUserID,
		IsNull(@strArticleReportedUsername,''),
		@dtArticleReportedDate,
		@dtArticleDueDate,
		@dtArticleReviewDate,
		@dtArticleExpiresDate,
		@intTabID,
		@strArticleDownloadFile,
		@strArticleDownloadLink,
		@strArticleDownloadPassword)

	-- return the  new identity
	SET @intIdentity = @@IDENTITY
	RETURN

END
ELSE -- we are updating
BEGIN

	-- update modified by?
	IF (@bolUpdateLastModified = 0)
	BEGIN
		SET @dtArticleModifiedDate = (SELECT ArticleModifiedDate FROM InstantKB_Articles WHERE ArticleID = @intArticleID)
		SET @intArticleModifiedUserID = (SELECT ArticleModifiedUserID FROM InstantKB_Articles WHERE ArticleID = @intArticleID)
	SET @intArticleModifiedUserID = (SELECT ArticleModifiedUserID FROM InstantKB_Articles WHERE ArticleID = @intArticleID)
	END

	-- update
	UPDATE InstantKB_Articles SET
	ArticleParentID = @intArticleParentID, 
	ArticleCategoryID = @intArticleCategoryID,
	ArticleTitle = @strArticleTitle, 
	ArticleTitleEncoded = @strArticleTitleEncoded,
	ArticleText = @strArticleText, 
	ArticlePercentComplete = @intArticlePercentComplete, 
	ArticleTypeID = @intArticleTypeID, 
	ArticleLevelID = @intArticleLevelID, 
	ArticleStatusID = @intArticleStatusID, 
	ArticlePriorityID = @intArticlePriorityID, 
	ArticleAccessType = @intArticleAccessType,
	ArticleWorkFlowStepID = @intArticleWorkFlowStepID, 
	ArticleModifiedUserID = @intArticleModifiedUserID, 
	ArticleModifiedUsername = IsNull(@strArticleModifiedUsername,''),
	ArticleModifiedDate = @dtArticleModifiedDate,
	ArticleAssignedUserID = @intArticleAssignedUserID,
	ArticleAssignedUsername = IsNull(@strArticleAssignedUsername,''),
	ArticleAssignedDate = @dtArticleAssignedDate,
	ArticleSuggestedUserID = @intArticleSuggestedUserID,
	ArticleSuggestedUsername = @strArticleSuggestedUsername,
	ArticleSuggestedEmail = @strArticleSuggestedEmail,
	ArticleSuggestedDate = @dtArticleSuggestedDate,
	ArticleReportedUserID = @intArticleReportedUserID,
	ArticleReportedUsername = IsNull(@strArticleReportedUsername,''),
	ArticleReportedDate = @dtArticleReportedDate,
	ArticleDueDate = @dtArticleDueDate,
	ArticleReviewDate = @dtArticleReviewDate,
	ArticleExpiresDate = @dtArticleExpiresDate,
	TabID = @intTabID,
	ArticleDownloadFile = @strArticleDownloadFile,
	ArticleDownloadLink = @strArticleDownloadLink,
	ArticleDownloadPassword = @strArticleDownloadPassword
	WHERE InstantKB_Articles.ArticleID = @intArticleID

	-- return the identity
	SET @intIdentity = @intArticleID
	RETURN

END

SET @intIdentity = 0
RETURN
