Imports System.Web
Imports System.Data.SqlClient
Imports InstantASP.Common.Configuration
Imports InstantASP.Common.Providers
Imports InstantASP.Common.ComponentModel

Namespace InstantASP.InstantKB.Pages

    Partial Class [Global]
        Inherits HttpApplication

        Protected Sub Session_Start(sender As Object, e As System.EventArgs)

            ' bundles and minify resources runs if InstantASP_DebugMode
            ' appSetting is set to true in web.config
            ' <add key="InstantASP_DebugMode" value="true" />
            Dim App As System.Web.HttpApplication = DirectCast(System.Web.HttpContext.Current.ApplicationInstance, System.Web.HttpApplication)
            InstantASP.Common.Deployment.DeployManager.Deploy(App)

        End Sub

        Protected Sub Application_Start(sender As Object, e As System.EventArgs)

            ' register dependencies
            ComponentFactory.RegisterComponent(Of Common.Application.SettingsController)().AsSingleton()
            ComponentFactory.RegisterComponent(Of Common.Cache.Caching)().AsSingleton()
            ComponentFactory.RegisterComponent(Of Common.Cache.Durations)().AsSingleton()

            ' register providers
            Dim installer = New ProviderInstaller()
            installer.Install()

        End Sub

        Protected Sub Application_Stop(sender As Object, e As System.EventArgs)

        End Sub


    End Class

End Namespace
