<%@ Control Language="vb" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<InstantASP:Summary id="ctlSummary" Runat="Server"/>	

<asp:UpdateProgress ID="ctlUpdateProgress" Visible="false" runat="Server" />
<asp:UpdatePanel ID="ctlUpdatePanel" Runat="Server"/>

<InstantASP:PanelBar Text="LogonControl_Logon1" TableName="tblLogon" id="ctlLoginControls" runat="Server">
	<InstantASP:Table id="tblLogon" Width="100%" Cellpadding="9" Cellspacing="1" Runat="Server">
	<tr>
	    <td class="PanelBar_SubHeader" colspan="2">
	        <InstantASP:Label Text="LogonControl_Logon2" id="lblSubHeader" Runat="server"/>
	    </td>
	</tr>
	<tr>
	<td style="width: 30%;" class="TableCell_Light">
	
	    <InstantASP:Label id="lblUsername1" CssClass="SmallTxtBold" Runat="server"/><br />
	    <InstantASP:Label id="lblUsername2" CssClass="SmallTxt" runat="server"/>
	    
	</td>
	<td class="TableCell_Light">
	
	    <InstantASP:TextBox CssClass="FormInputText" id="txtUserName" runat="Server"/> 
	    	
	    <InstantASP:CalloutValidatorExtender id="txtUsernameRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	        <RequiredFieldValidator ControlToValidate="txtUserName"/>
	    </InstantASP:CalloutValidatorExtender>
	    
        <InstantASP:CalloutValidatorExtender id="txtUsernameRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
	        <RegExValidator ControlToValidate="txtUserName" ErrorMessage="LogonControl_EmailAddressInvalid" ValidationExpression="\S+@\S+\.\S{2,4}"/>
	    </InstantASP:CalloutValidatorExtender>
	    
   </td>
   </tr>
   <tr>
	<td style="width: 30%;" class="TableCell_Light">
	
	    <InstantASP:Label Text="LogonControl_LogonPassword1" id="lblPassword1" CssClass="SmallTxtBold" Runat="server"/><br />
	    <InstantASP:Label Text="LogonControl_LogonPassword2" id="lblPassword2" CssClass="SmallTxt" Runat="server"/>
	    
	</td>	    
	<td class="TableCell_Light">
	
	    <InstantASP:TextBox CssClass="FormInputText" TextMode="Password" id="txtPassword" runat="Server"/> 
	    	    	
	    <InstantASP:CalloutValidatorExtender id="txtPasswordRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	        <RequiredFieldValidator ControlToValidate="txtPassword" ErrorMessage="LogonControl_PasswordRequired"/>
	    </InstantASP:CalloutValidatorExtender>
	    
        <InstantASP:CalloutValidatorExtender id="txtPasswordRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
	        <RegExValidator ControlToValidate="txtPassword" ErrorMessage="LogonControl_PasswordLength" ValidationExpression="\S{4,32}"/>
	    </InstantASP:CalloutValidatorExtender>

	</td>
	</tr>
	<tr>
	<td style="width: 30%;" class="TableCell_Light">&nbsp;</td>
	<td class="TableCell_Light">
	
	    <asp:Button id="butLogon" CausesValidation="True" CssClass="FormButtonBig" runat="server"/> 
	    <InstantASP:Button id="butRegister" CausesValidation="False" DisableAfterClick="True" 
	    CssClass="FormButtonBig" Text="Button_Register" DisabledText="Button_PleaseWait" runat="server"/>
	    
	</td></tr>
	</InstantASP:Table>
</InstantASP:PanelBar>

<InstantASP:Spacer id="lblSpacer" Runat="Server"/>

<InstantASP:PanelBar Text="LogonControl_LogonOptions" TableName="tblLogonOptions" id="ctlLoginOptions" runat="Server">

	<InstantASP:Table id="tblLogonOptions" Width="100%" Cellpadding="0" Cellspacing="1" Runat="Server">
	<tr><td class="TableCell_Light">
	
	<table width="100%" cellpadding="9" cellspacing="0">
	<tr><td style="width:50%;" valign="top">
		
		<InstantASP:RoundedTable Text="LogonControl_LogonOptions" id="ctlLoginOptionsRoundedTable" Runat="Server">		
			<InstantASP:Table Width="100%" Cellpadding="9" Cellspacing="1" Runat="Server">
				<tr><td class="SmallTxt">
				
					<InstantASP:CheckBox id="ckbRememberMe" Text="LogonControl_RememberMe" runat="server"/><br />
					<InstantASP:CheckBox id="ckbLogonAnonymous" Text="LogonControl_AnonymousLogin" runat="server"/>
								
				</td></tr>
			</InstantASP:Table>
		</InstantASP:RoundedTable> 
		
	</td><td style="width:50%;" valign="top">
	
		<InstantASP:RoundedTable Text="LogonControl_AdditionalOptions" id="ctlLoginAdditionalOptionsRoundedTable" Runat="Server">
		
			<InstantASP:Table Width="100%" Cellpadding="9" Cellspacing="1" Runat="Server">
				<tr><td class="SmallTxt">
				
					<InstantASP:Hyperlink id="hypForgotPassword" 
					CssClass="SmlLinks" Text="LogonControl_ForgotPassword" runat="server"/><br />
					<InstantASP:Hyperlink id="hypSendValidationCode" CssClass="SmlLinks"
					Text="LogonControl_SendValidationEmail" runat="server"/><InstantASP:Spacer Runat="Server"/>
			
				</td></tr>
			</InstantASP:Table>
		</InstantASP:RoundedTable> 
		
	</td></tr></table>
	
	</td></tr>
	</InstantASP:Table>
	
</InstantASP:PanelBar>
