﻿<%@ Control Language="vb" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>

<div class="row">
    <div class="col-9">
        
        <div class="row" style="width: 99%;">
            <InstantASP:PanelBar id="ctlReportPanel" TableName="tblReport" Text="AdminHeader_SearchActivity" Runat="Server">
            <InstantASP:Panel ID="tblReport" class="row" runat="server">	      
                <div style="padding: 12px;">
                    <div class="chart-no-results" id="ctlSearchChartNoResults" runat="server">
                        <h1>No Data</h1>
                    </div>
                     <telerik:RadHtmlChart runat="server"  ID="ctlSearchChart">
                          <PlotArea>
                               <CommonTooltipsAppearance  Shared="true" Visible="true" Color="White">
                                      <SharedTemplate>                                          
                                      #= kendo.format(\'{0:D}\', category)#
                                           # for (var i = 0; i < points.length; i++) { #
                                                <div>#: points[i].series.name#: #: points[i].value #</div>
                                           # } #
                                      </SharedTemplate>
                                </CommonTooltipsAppearance>
                               <Series>
                                    <telerik:AreaSeries Name="Members" DataFieldY="UserSearches">
                                        <LineAppearance LineStyle="Smooth" />
                                        <Appearance FillStyle-BackgroundColor="#62C55A">                                                                           
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.UserTickets#
                                              </ClientTemplate>
                                         </LabelsAppearance>                                  
                                    </telerik:AreaSeries>
                                    <telerik:AreaSeries Name="Anonymous" DataFieldY="AnonymousSearches">
                                        <LineAppearance LineStyle="Smooth" />
                                        <Appearance FillStyle-BackgroundColor="#6A99DE">                                                                           
                                        </Appearance>                         
                                         <LabelsAppearance Visible="false">
                                              <ClientTemplate>
                                                   #=dataItem.UserTickets#
                                              </ClientTemplate>
                                         </LabelsAppearance>                                  
                                    </telerik:AreaSeries>                              
                               </Series>
                               <XAxis Visible="true" Name="Date"  Type="Date" DataLabelsField="ReadDate">
                                    <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                                    <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                                   <LabelsAppearance  Step="2" />
                               </XAxis>
                               <YAxis>
                                    <MajorGridLines Color="#EFEFEF" Width="1"></MajorGridLines>
                                    <MinorGridLines Color="#F7F7F7" Width="1"></MinorGridLines>
                                    <LabelsAppearance DataFormatString="{0}" />                                 
                               </YAxis>
                          </PlotArea>                     
                          <Legend>                          
                               <Appearance Visible="true" Position="Bottom" />
                          </Legend>
                     </telerik:RadHtmlChart>
                </div>
            </InstantASP:Panel>
        </InstantASP:PanelBar>
        </div>
    </div>
    <div class="col-3">
        
       <InstantASP:PanelBar id="ctlFilterPanelBar" TableName="tblFilterPanelBar" Text="AdminHeader_Filter" Runat="Server">
        <InstantASP:Table ID="tblFilterPanelBar" class="tbl" runat="server">
                <tr>
                    <td class="Tablecell_Light">                        
                        Start Date:<br />
                        <telerik:RadDatePicker ID="ddlStartDate" runat="server" /><br /><br />
                        End Date:<br />
                        <telerik:RadDatePicker ID="ddlEndDate" runat="server" />
                        <br /><br /> 
                        <InstantASP:Button ID="butFilter" TextNonLocalized="Update Reports" CssClass="FormButtonSmall" runat="server" />
                    </td>
                </tr>
            </InstantASP:Table> 
        </InstantASP:PanelBar>
	   
    </div>
</div>

<InstantASP:Spacer runat="server" />

<div class="row">
    <div class="col-6">

        <div style="width: 99%">
            <InstantASP:PanelBar id="ctlSearches" TableName="ctlSearchesGrid" Text="AdminHeader_AllSearches" Runat="Server">
                <InstantASP:DataGrid ID="ctlSearchesGrid" AutoGenerateColumns="False" Width="100%" NoRecordsText="AdminHeader_NoReportData"
                CssClass="tbl" ShowHeader="true" AllowPaging="False" NoRecordsTableCellCssClass="TableCell_Light" 
                AllowCustomPaging="True" Runat="Server">
                <Columns>                        
		  	        <InstantASP:TemplateColumn ItemStyle-Width="50%" HeaderText="AdminHeader_SearchTerm"
                     ItemStyle-CssClass="TableCell_Light" HeaderStyle-CssClass="pb_sh">
	                    <ItemTemplate>	         
                             <InstantASP:Hyperlink id="hypTitle" EnableViewState="False" Runat="Server">
                                <span>
                                    <InstantASP:Label ID="lblTitle" CssClass="bold" runat="server"/><br />			                	          
                                </span>
                            </InstantASP:Hyperlink> 
	                    </ItemTemplate>	
                    </InstantASP:TemplateColumn>    
                    <InstantASP:TemplateColumn ItemStyle-Width="30%"  HeaderText="AdminHeader_Date"
                     ItemStyle-CssClass="TableCell_Light" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="center" HeaderStyle-CssClass="pb_sh">
	                    <ItemTemplate>	     
                            <InstantASP:Label ID="lblDateStamp" runat="server"/><br />			                	                                  
	                    </ItemTemplate>	
                    </InstantASP:TemplateColumn>      
                    <InstantASP:TemplateColumn ItemStyle-Width="20%"  HeaderText="AdminHeader_Results"
                     ItemStyle-CssClass="TableCell_Light" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="center" HeaderStyle-CssClass="pb_sh">
	                    <ItemTemplate>	     
                            <InstantASP:Label ID="lblResults" runat="server"/><br />			                	                                  
	                    </ItemTemplate>	
                    </InstantASP:TemplateColumn>             	            
                </Columns>
                </InstantASP:DataGrid>
            </InstantASP:PanelBar>
            <InstantKBWebControls:PagingOptions id="ctlFooterPagingOptions" Orientation="Bottom" Runat="Server" />
        </div>

        

    </div>
    <div class="col-6">


          <InstantASP:PanelBar id="ctlTopSearches" TableName="ctlTopSearchesGrid" Text="AdminHeader_TopSearches" Runat="Server">
            <InstantASP:DataGrid ID="ctlTopSearchesGrid" AutoGenerateColumns="False" Width="100%" NoRecordsText="AdminHeader_NoReportData"
            CssClass="tbl" ShowHeader="true" AllowPaging="False" NoRecordsTableCellCssClass="TableCell_Light" 
            AllowCustomPaging="True" Runat="Server">
            <Columns>                        
		  	    <InstantASP:TemplateColumn ItemStyle-Width="60%" HeaderText="AdminHeader_SearchTerm"
                 ItemStyle-CssClass="TableCell_Light" HeaderStyle-CssClass="pb_sh">
	                <ItemTemplate>	         
                         <InstantASP:Hyperlink id="hypTitle" EnableViewState="False" Runat="Server">
                            <span>
                                <InstantASP:Label ID="lblTitle" CssClass="bold" runat="server"/>		                	          
                            </span>
                        </InstantASP:Hyperlink>                         
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>     
                <InstantASP:TemplateColumn ItemStyle-Width="20%"  HeaderText="AdminHeader_Searches"
                 ItemStyle-CssClass="TableCell_Light" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="center" HeaderStyle-CssClass="pb_sh">
	                <ItemTemplate>	    
                        <InstantASP:Label ID="lblCount" runat="server"/><br />			                	                                  
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>                                      
                <InstantASP:TemplateColumn ItemStyle-Width="20%"  HeaderText="AdminHeader_Results"
                 ItemStyle-CssClass="TableCell_Light" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="center" HeaderStyle-CssClass="pb_sh">
	                <ItemTemplate>	    
                        <InstantASP:Label ID="lblResults" runat="server"/><br />			                	                                  
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>                         	            
            </Columns>
            </InstantASP:DataGrid>
        </InstantASP:PanelBar>
        
        <InstantASP:Spacer runat="server" />
        
        <InstantASP:PanelBar id="ctlTopSearchNoResults" TableName="ctlTopSearchNoResultsGrid" Text="AdminHeader_KeywordSuggestions" Runat="Server">
            <InstantASP:DataGrid ID="ctlTopSearchNoResultsGrid" AutoGenerateColumns="False" Width="100%" NoRecordsText="AdminHeader_NoReportData"
            CssClass="tbl" ShowHeader="true" AllowPaging="False" NoRecordsTableCellCssClass="TableCell_Light" 
            AllowCustomPaging="True" Runat="Server">
            <Columns>                        
		  	    <InstantASP:TemplateColumn ItemStyle-Width="60%" HeaderText="DataViewType_UserTickets"
                 ItemStyle-CssClass="TableCell_Light" HeaderStyle-CssClass="pb_sh">
	                <ItemTemplate>	         
                         <InstantASP:Hyperlink id="hypTitle" EnableViewState="False" Runat="Server">
                            <span>
                                <InstantASP:Label ID="lblTitle" CssClass="bold" runat="server"/>		                	          
                            </span>
                        </InstantASP:Hyperlink>                         
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>       
                <InstantASP:TemplateColumn ItemStyle-Width="20%"  HeaderText="AdminHeader_Searches"
                 ItemStyle-CssClass="TableCell_Light" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="center" HeaderStyle-CssClass="pb_sh">
	                <ItemTemplate>	    
                        <InstantASP:Label ID="lblSearches" runat="server"/><br />			                	                                  
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>   
                <InstantASP:TemplateColumn ItemStyle-Width="20%"  HeaderText="AdminHeader_Results"
                 ItemStyle-CssClass="TableCell_Light" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="center" HeaderStyle-CssClass="pb_sh">
	                <ItemTemplate>	    
                        <InstantASP:Label ID="lblResults" runat="server"/><br />			                	                                  
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>             	            
            </Columns>
            </InstantASP:DataGrid>
        </InstantASP:PanelBar>


        <InstantASP:Spacer runat="server" />

        <InstantASP:PanelBar id="ctlTopSearchUsers" TableName="ctlTopSearchUsersGrid" Text="AdminHeader_TopSearchesByUser" Runat="Server">
            <InstantASP:DataGrid ID="ctlTopSearchUsersGrid" AutoGenerateColumns="False" Width="100%" NoRecordsText="AdminHeader_NoReportData"
            CssClass="tbl" ShowHeader="true" AllowPaging="False" NoRecordsTableCellCssClass="TableCell_Light" 
            AllowCustomPaging="True" Runat="Server">
            <Columns>                        
		  	    <InstantASP:TemplateColumn ItemStyle-Width="80%" HeaderText="DataViewType_UserTickets"
                 ItemStyle-CssClass="TableCell_Light" HeaderStyle-CssClass="pb_sh">
	                <ItemTemplate>	         
                         <InstantASP:Hyperlink id="hypTitle" EnableViewState="False" Runat="Server">
                            <span>
                                <InstantASP:Label ID="lblTitle" CssClass="bold" runat="server"/>		                	          
                            </span>
                        </InstantASP:Hyperlink>                         
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>       
                <InstantASP:TemplateColumn ItemStyle-Width="20%"  HeaderText="AdminHeader_Searches"
                 ItemStyle-CssClass="TableCell_Light" ItemStyle-HorizontalAlign="center" HeaderStyle-HorizontalAlign="center" HeaderStyle-CssClass="pb_sh">
	                <ItemTemplate>	    
                        <InstantASP:Label ID="lblViews" runat="server"/><br />			                	                                  
	                </ItemTemplate>	
                </InstantASP:TemplateColumn>             	            
            </Columns>
            </InstantASP:DataGrid>
        </InstantASP:PanelBar>
        
    </div>

</div>

