<%@ Control Language="vb" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<InstantASP:PanelBar Text="Register_Title" TableName="tblRegister" id="ctlPanelBar" runat="Server">
	<InstantASP:Table id="tblRegister" class="tbl" Runat="Server">
	<tr>
	    <td class="pb_sh" colspan="2">
	        <InstantASP:Label Text="Register_UserDetails" id="lblSubHeader" Runat="server"/>
	    </td>
	</tr>
	<tr>
	    <td style="width: 30%;" class="TableCell_Light">
    	
	        <InstantASP:Label Text="Register_UserName" CssClass="SmallTxtBold" id="lblUsername1" Runat="server"/><br />
	        <InstantASP:Label Text="Register_UserNameDescription" Visible="false" id="lblUsername2" Runat="Server"/>
	    
	    </td>
	    <td class="TableCell_Light"> 
	
	        <InstantASP:TextBox CssClass="FormInputText" id="txtUserName" TabIndex="1" runat="Server"/>
	  	
	        <InstantASP:CalloutValidatorExtender id="txtUsernameRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtUserName" ErrorMessage="Register_UserNameRequired"/>
	        </InstantASP:CalloutValidatorExtender>
    	    
	    </td>
	</tr>
	<tr>
	    <td style="width: 30%;" class="TableCell_Light">
        	
	        <InstantASP:Label Text="Register_EmailAddress" CssClass="SmallTxtBold" id="lblEmailAddress1" Runat="server"/><br />
	        <InstantASP:Label Text="Register_EmailAddressDescription" Visible="false" id="lblEmailAddress2" Runat="Server"/>
        	
	    </td>
	    <td class="TableCell_Light">
    	
	        <InstantASP:TextBox CssClass="FormInputText" id="txtEmailAddress" TabIndex="2" runat="Server"/>

	        <InstantASP:CalloutValidatorExtender id="txtEmailAddressRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtEmailAddress" ErrorMessage="Register_EmailAddressRequired"/>
	        </InstantASP:CalloutValidatorExtender>
    	    
            <InstantASP:CalloutValidatorExtender id="txtEmailAddressRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
	            <RegExValidator ControlToValidate="txtEmailAddress" ErrorMessage="Register_EmailAddressInvalid" ValidationExpression="\S+@\S+\.\S{2,4}"/>
	        </InstantASP:CalloutValidatorExtender>
	    
	    </td>
	</tr>
	<tr>
	    <td style="width: 30%;" class="TableCell_Light">
    	
	        <InstantASP:Label Text="Register_Password1" CssClass="SmallTxtBold" id="lblPassword1" Runat="server"/><br />
	        <InstantASP:Label Text="Register_Password1Description" Visible="false" id="lblPassword2" Runat="Server"/>
    	
	    </td>
	    <td class="TableCell_Light">
    	
	        <InstantASP:TextBox TextMode="Password" TabIndex="3" CssClass="FormInputText" id="txtPassword" runat="Server"/> 
    	    
	        <InstantASP:CalloutValidatorExtender id="txtPasswordRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtPassword" ErrorMessage="Register_Password1Required"/>
	        </InstantASP:CalloutValidatorExtender>
    	    
            <InstantASP:CalloutValidatorExtender id="txtPasswordRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
	            <RegExValidator ControlToValidate="txtPassword" ErrorMessage="Register_PasswordLength" ValidationExpression="\S{4,32}"/>
	        </InstantASP:CalloutValidatorExtender>
        	
	    </td>
	</tr>
	
	<tr>
	    <td style="width: 30%;" class="TableCell_Light">
    	
	        <InstantASP:Label Text="Register_Password2" id="lblConfirmPassword1" CssClass="SmallTxtBold" Runat="server"/><br />
	        <InstantASP:Label Text="Register_Password2Description" Visible="false" id="lblConfirmPassword2" Runat="Server"/>
        	
	    </td>
	    <td class="TableCell_Light">
    	
	        <InstantASP:TextBox TextMode="Password" TabIndex="4" CssClass="FormInputText" id="txtPasswordConfirmation" runat="Server" /> 
	        	        
	        <InstantASP:CalloutValidatorExtender id="txtPasswordConfirmationRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtPasswordConfirmation" ErrorMessage="Register_Password2Required"/>
	        </InstantASP:CalloutValidatorExtender>
    	    
            <InstantASP:CalloutValidatorExtender id="txtPasswordConfirmationCompareValidator" ShortErrorMessage="InvalidMatch" Runat="Server">
	            <CompareValidator ControlToValidate="txtPasswordConfirmation" ControlToCompare="txtPassword" ErrorMessage="Register_Password2NoMatch"/>
	        </InstantASP:CalloutValidatorExtender>
	    	
	    </td>
	</tr>
	<tr visible="False" runat="Server">
	    <td class="pb_sh" colspan="2">
	    
	        <InstantASP:Label Text="Register_OptionalSettings" id="lblSettings" Runat="server"/>
	        
	    </td>
	</tr>
	
	 <tr>
	    <td style="width: 30%;" class="TableCell_Light">
	    
	        <InstantASP:Label Text="Register_TimeZone" CssClass="SmallTxtBold" id="lblTimeZone1" Runat="server"/><br />
	        <InstantASP:Label Text="Register_TimeZoneDescription" id="lblTimeZone2" Runat="Server"/>
	        
	        </td>
	    <td class="TableCell_Light">
    	    
	        <InstantASP:TimeZones TabIndex="6" CssClass="FormInputDropDown" Width="70%" id="ddlTimeZones" runat="Server"/>
	        <br /><br />
	        <InstantASP:CheckBox id="ckbObserveDaylightSavingTime" Text="Register_ObserveDaylightSavingTime" Runat="Server"/>
	    
	    </td>
	</tr>
	
	<tr id="trVerificationImage1" runat="server">
	    <td class="pb_sh" colspan="2">
	        <InstantASP:Label Text="SecurityCode_Title" id="lblCaptchaHeader" Runat="server"/>
	    </td>
	</tr>
	<tr id="trVerificationImage2" runat="server">
	    <td style="width: 30%;" class="TableCell_Light">
    	
	        <InstantASP:Label Text="SecurityCode_ConfirmCode" id="lblSecurityCode1" CssClass="SmallTxtBold" Runat="server"/><br />
	        <InstantASP:Label Text="SecurityCode_SecurityCodeDescription" id="lblSecurityCode2" Runat="Server"/>
        	
	    </td>
	    <td class="TableCell_Light">
    	
            <div style="float: left; margin-right: 8px;">
                <div class="Captcha">
                <InstantASP:Image id="imgCaptchaImage" Runat="Server"/>
                </div>
            </div>
        	<div style="float: left; margin-top: 9px;">
                <InstantASP:TextBox CssClass="FormInputText" Width="150" TabIndex="8" id="txtCaptchaCode"  runat="Server"/> 
        	     	        
                <InstantASP:CalloutValidatorExtender id="txtCaptchaCodeRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
                    <RequiredFieldValidator ControlToValidate="txtCaptchaCode" ErrorMessage="Register_CaptchaCodeRequired"/>
                </InstantASP:CalloutValidatorExtender>
            </div>
            
    	    	
	    </td>
	</tr>	
	<tr>
	    <td style="width: 30%;" class="TableCell_Light">&nbsp;</td>
	    <td class="TableCell_Light">
	        <asp:Button ID="butSubmit" runat="Server"
                CausesValidation="True" CssClass="FormButtonBig" />
	    </td>
	</tr>
	</InstantASP:Table>	
</InstantASP:PanelBar>

<InstantASP:Spacer Runat="Server"/>

<InstantASP:PanelBar Text="Register_OptionsTitle" TableName="tblRegisterOptions" id="ctlRegisterOptions" runat="Server">
	<InstantASP:Table id="tblRegisterOptions" class="tbl" Runat="Server">
	<tr>
        <td class="TableCell_Light">
	
		    <InstantASP:RoundedTable Text="Register_LoginOptionsTitle" TableName="tblRegisterOptionsRoundedTableLeft" 
		    id="ctlRegisterOptionsRoundedTableLeft" Runat="Server">
		
			    <InstantASP:Table id="tblRegisterOptionsRoundedTableLeft" class="tbl" Runat="Server">
				    <tr>
                        <td>
				
					    <InstantASP:CheckBox id="ckbRememberMe" Text="LogonControl_RememberMe" runat="server"/><br />
					    <InstantASP:CheckBox id="ckbAnonymous" Text="LogonControl_AnonymousLogin" runat="server"/>
				
				    </td></tr>
			    </InstantASP:Table>
		    </InstantASP:RoundedTable> 
	
	    </td>
	</tr>
	</InstantASP:Table>	
</InstantASP:PanelBar>