<%@ Control Language="vb" %>
<%@ Register tagPrefix="InstantASP" Namespace="InstantASP.Common.UI.WebControls" Assembly="InstantASP.Common.UI" %>
<%@ Register tagPrefix="InstantKB" Namespace="InstantASP.InstantKB.UI.Controls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register tagPrefix="InstantKBWebControls" Namespace="InstantASP.InstantKB.UI.WebControls" Assembly="InstantASP.InstantKB.UI" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<asp:UpdateProgress ID="ctlUpdateProgress" Visible="False" runat="Server" />
<asp:UpdatePanel ID="ctlUpdatePanel" Runat="Server"/>

<InstantASP:Summary id="ctlSummary" Runat="Server"/>

<InstantASP:PanelBar TableName="tblUserCPEditRegistrationDetails" id="ctlPanelBar" runat="Server">
	<InstantASP:Table id="tblUserCPEditRegistrationDetails" class="tbl responsive-tbl" Runat="Server">
	<tr>
	    <td class="pb_sh" colspan="2">
	        <InstantASP:Label Text="Register_UserDetails" id="lblSubHeader" Runat="server"/>
	    </td>
	</tr>
	<tr>
	    <td style="width: 50%;" class="TableCell_Light">
    	
	        <InstantASP:Label Text="Register_UserName" CssClass="bold" id="lblUsername1" Runat="server"/><br />
	        <InstantASP:Label Text="Register_UserNameDescription" id="lblUsername2" Runat="Server"/>
	    
	    </td>
	    <td class="TableCell_Light"> 
	
	        <InstantASP:TextBox CssClass="FormInputText" id="txtUserName" TabIndex="1" runat="Server"/>
	  	
	        <InstantASP:CalloutValidatorExtender id="txtUsernameRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtUserName" ErrorMessage="Register_UserNameRequired"/>
	        </InstantASP:CalloutValidatorExtender>
    	    
	    </td>
	</tr>
	<tr>
	    <td style="width: 50%;" class="TableCell_Light">
        	
	        <InstantASP:Label Text="Register_EmailAddress" CssClass="bold" id="lblEmailAddress1" Runat="server"/><br />
	        <InstantASP:Label Text="Register_EmailAddressDescription" id="lblEmailAddress2" Runat="Server"/>
        	
	    </td>
	    <td class="TableCell_Light">
    	
	        <InstantASP:TextBox CssClass="FormInputText" id="txtEmailAddress" TabIndex="2" runat="Server"/>

	        <InstantASP:CalloutValidatorExtender id="txtEmailAddressRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtEmailAddress" ErrorMessage="Register_EmailAddressRequired"/>
	        </InstantASP:CalloutValidatorExtender>
    	    
            <InstantASP:CalloutValidatorExtender id="txtEmailAddressRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
	            <RegExValidator ControlToValidate="txtEmailAddress" ErrorMessage="Register_EmailAddressInvalid" ValidationExpression="\S+@\S+\.\S{2,4}"/>
	        </InstantASP:CalloutValidatorExtender>
	    
	    </td>
	</tr>
	<tr>
	    <td style="width: 50%;" class="TableCell_Light">
    	
	        <InstantASP:Label Text="Register_Password1" CssClass="bold" id="lblPassword1" Runat="server"/><br />
	        <InstantASP:Label Text="Register_Password1Description" id="lblPassword2" Runat="Server"/>
    	
	    </td>
	    <td class="TableCell_Light">
    	
	        <InstantASP:TextBox TextMode="Password" TabIndex="3" CssClass="FormInputText" id="txtPassword" runat="Server"/> 
    	    
	        <InstantASP:CalloutValidatorExtender id="txtPasswordRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtPassword" ErrorMessage="Register_Password1Required"/>
	        </InstantASP:CalloutValidatorExtender>
    	    
            <InstantASP:CalloutValidatorExtender id="txtPasswordRegExValidator" ShortErrorMessage="InvalidField" Runat="Server">
	            <RegExValidator ControlToValidate="txtPassword" ErrorMessage="Register_PasswordLength" ValidationExpression="\S{4,32}"/>
	        </InstantASP:CalloutValidatorExtender>
        	
	    </td>
	</tr>
	
	<tr>
	    <td style="width: 50%;" class="TableCell_Light">
    	
	        <InstantASP:Label Text="Register_Password2" id="lblConfirmPassword1" CssClass="bold" Runat="server"/><br />
	        <InstantASP:Label Text="Register_Password2Description" id="lblConfirmPassword2" Runat="Server"/>
        	
	    </td>
	    <td class="TableCell_Light">
    	
	        <InstantASP:TextBox TextMode="Password" TabIndex="4" CssClass="FormInputText" id="txtPasswordConfirmation" runat="Server" /> 
	        	        
	        <InstantASP:CalloutValidatorExtender id="txtPasswordConfirmationRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
	            <RequiredFieldValidator ControlToValidate="txtPasswordConfirmation" ErrorMessage="Register_Password2Required"/>
	        </InstantASP:CalloutValidatorExtender>
    	    
            <InstantASP:CalloutValidatorExtender id="txtPasswordConfirmationCompareValidator" ShortErrorMessage="InvalidMatch" Runat="Server">
	            <CompareValidator ControlToValidate="txtPasswordConfirmation" ControlToCompare="txtPassword" ErrorMessage="Register_Password2NoMatch"/>
	        </InstantASP:CalloutValidatorExtender>
	    	
	    </td>
	</tr>
	<tr id="Tr1" visible="False" runat="Server">
	    <td class="pb_sh" colspan="2">
	    
	        <InstantASP:Label Text="Register_OptionalSettings" id="lblSettings" Runat="server"/>
	        
	    </td>
	</tr>
		
	<tr id="trVerificationImage1" runat="server">
	    <td class="pb_sh" colspan="2">
	        <InstantASP:Label Text="SecurityCode_Title" id="lblCaptchaHeader" Runat="server"/>
	    </td>
	</tr>
	<tr id="trVerificationImage2" runat="server">
	    <td style="width: 30%;" class="TableCell_Light">
    	
	        <InstantASP:Label Text="SecurityCode_ConfirmCode" id="lblSecurityCode1" CssClass="bold" Runat="server"/><br />
	        <InstantASP:Label Text="SecurityCode_SecurityCodeDescription" id="lblSecurityCode2" Runat="Server"/>
        	
	    </td>
	    <td class="TableCell_Light">
    	
            <div style="float: left; margin-right: 8px;">
                <div class="Captcha">
                <InstantASP:Image id="imgCaptchaImage" Runat="Server"/>
                </div>
            </div>
        	<div style="float: left; margin-top: 9px;">
                <InstantASP:TextBox CssClass="FormInputText" Width="100" TabIndex="8" id="txtCaptchaCode"  runat="Server"/> 
        	     	        
                <InstantASP:CalloutValidatorExtender id="txtCaptchaCodeRequiredFieldValidator" ShortErrorMessage="RequiredField" Runat="Server">
                    <RequiredFieldValidator ControlToValidate="txtCaptchaCode" ErrorMessage="Register_CaptchaCodeRequired"/>
                </InstantASP:CalloutValidatorExtender>
            </div>
            
    	    	
	    </td>
	</tr>	
	<tr>
	    <td style="width: 30%;" class="TableCell_Light" colspan="2" align="center">
	        <asp:Button ID="butSubmit" runat="Server"  CausesValidation="True" CssClass="FormButtonBig" />
	    </td>
	</tr>
	</InstantASP:Table>
	
</InstantASP:PanelBar>