
// preload images
function ikb_PreloadImages(CurrentSkin) {
    if (document.images) {
        arImageList = new Array();
        var arImageSrc = new Array(CurrentSkin + "Images/Misc_Rating1.gif",
		CurrentSkin + "Images/Misc_Rating2.gif",
		CurrentSkin + "Images/Misc_Rating3.gif",
		CurrentSkin + "Images/Misc_Rating4.gif",
		CurrentSkin + "Images/Misc_Rating5.gif",
		CurrentSkin + "Images/Misc_AjaxLoading.gif");
        for (counter in arImageSrc) {
            arImageList[counter] = new Image();
            arImageList[counter].src = arImageSrc[counter];
        }
    }
}

/* script to pick up enter key for simple menu search */
function ikb_SimpleSearchKeyPress(butid) {

    try {
        if ((event.keyCode && event.keyCode == 13)) {
            iasp_FindControl(butid).click();
            return false;
        } else return true;

    }
    catch (e) { };

}

/* enter we have search terms in simple menu site wide search in mainnavigation.ascx */
function ikb_SimpleSearchValidate(strKeywords) {


    if (strKeywords != "") {
        return true;

    } else {
        return false;
    }
}

/* generic delete confirmation for admin pages */
function ikb_ConfirmDelete(listid, deleteenum) {

    // get drop down list
    var list = iasp_FindControl(listid);
    if (list != null) {
        if (list.value == 0) { return false; }
        // is delete selected
        if (list.value == deleteenum) {
            return confirm(ikb_strDeleteItemConfirmation);
        }
    }
    return true;

}

/* tab mass action button event */
function ikb_ViewTabsMassActionClick(listid, movetolistid, deleteenum, deletemoveenum) {

    // get drop down list
    var list = iasp_FindControl(listid);
    var movetolist = iasp_FindControl(movetolistid);
    if (list != null && movetolist != null) {
        if (list.value == 0) { return false; }
        // is delete selected
        if (list.value == deleteenum) {
            return confirm(ikb_strDeleteTabConfirmation);
        }
        else if (list.value == deletemoveenum)
            if (movetolist.value == 0) { alert(ikb_strNoNewTabSelected); return false; }
        {
            return confirm(ikb_strDeleteTabMveConfirmation);
        }
    }
    return true;
}

/* show "move to tab" drop down list if you we choose to move centent when deleting tabs */
function ikb_ViewTabsMassActionSelectedIndexChanged(listid, movetolistid, deletemoveenum) {

    // get drop down list
    var list = iasp_FindControl(listid);
    var movetolist = iasp_FindControl(movetolistid);
    if (list != null && movetolist != null) {
        // is delete selected
        if (list.value == deletemoveenum) {
            movetolist.style.display = '';
        }
        else {
            movetolist.style.display = 'none';
        }
    }

}

/* Article Options (Send Via Email, Social Bookmarks etc) */
function ikb_SendArticleByEmail(strToEmail, strCallBackURL) {

    // check we have a email
    if (strToEmail == "") {
        alert(ikb_strEmailRequired); return;
    }

    // get url
    var arrURL = strCallBackURL.split("?");

    // setup xmlhttp
    if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    // get result
                    var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                    // end loader
                    iasp_AjaxExtensionsEndRequest();
                    // was everything ok
                    if (identity == 0) {
                        alert(ikb_strSendProblem);
                    } else {
                        // hide menu
                        iasp_HideAllMenus();
                        // show alert
                        alert(ikb_strArticleSentSuccess);
                    }
                }
            }
        }
    };

    // setup params
    var strParams = arrURL[1] + "&key=" + iasp_EncodeString(strToEmail);
    // setup loader
    iasp_AjaxExtensionsInitializeRequest();
    // make request
    this.XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

/* ----------------------------------------------------------- */
// treeview context menu options
/* ----------------------------------------------------------- */

/* staff root category context menu */
function ikb_rootNodeContextMenu(container, selNode, menuId, itemId) {

    if (container != null) {

        // get selected node
        var selNode = container.getSelNode();

        if (selNode != null) {

            switch (itemId) {
                case "0": // add category
                    var selNodeID = selNode.NodeID;
                    container.ctx_liveAdd(selNodeID, ikb_strDefaultNodeText);
                    break;
                case "2": // expand
                    container.expandAll();
                    iasp_HideAllMenus();
                    break;
                case "3": // collapse
                    container.collapseAll();
                    iasp_HideAllMenus();
                    break;
            }
        }
    }
}

/* staff category context menu */
function ikb_treeContextMenu(container, selNode, menuId, itemId) {

    if (container != null) {

        // get selected node
        var selNode = container.getSelNode();

        if (selNode != null) {

            switch (itemId) {
                case "0": // add category
                    var selNodeID = selNode.NodeID;
                    container.ctx_liveAdd(selNodeID, ikb_strDefaultNodeText);
                    break;
                case "1": // quick edit
                    container.liveNodeEditStart(selNode.ID);
                    break;
                case "2": // edit category detailed                                                   
                    if (selNode.NavigateURL.indexOf("javascript:") == -1) {
                        location = selNode.NavigateURL;
                    } else {
                        var uri = container.Options.NodeEditURL + 'StaffEditCategory' + selNode.CategoryID + '-' + container.Options.TabID + '.aspx';
                        location = uri;
                    }
                    break;
                case "4": // move up
                    // get orevious node
                    var dest = null; if (selNode.PrevNode != null) { dest = selNode.PrevNode; }
                    if (dest != null) {
                        // move node
                        container.moveChild(selNode, dest, 2)
                        // do callback
                        ikb_treeCallBack(container, selNode, container.Options.LiveMoveUpCallBackURL, "", "&id=" + selNode.CategoryID)
                    }
                    break;
                case "5": // move down
                    // get bext node  
                    var dest = null; if (selNode.NextNode != null) { dest = selNode.NextNode; }
                    if (dest != null) {
                        // move node
                        container.moveChild(selNode, dest, 3)
                        // do callback 
                        ikb_treeCallBack(container, selNode, container.Options.LiveMoveDownCallBackURL, "", "&id=" + selNode.CategoryID)
                    }
                    break;
                case "7": // delete 
                    iasp_HideAllMenus();
                    // confirm delete
                    if (confirm(ikb_strDeleteCategory)) {
                        // do loader
                        iasp_AjaxExtensionsInitializeRequest();
                        // delete node
                        container.remove();
                        // do callback
                        ikb_treeCallBack(container, selNode, container.Options.LiveDeleteCallBackURL, ikb_strProblemDeletingCategory, "&id=" + selNode.CategoryID)
                    }
                    break;
            }

            iasp_HideAllMenus();

        }
    }
}

/* staff root troubleshooter context menu */
function ikb_rootTroubleshooterNodeContextMenu(container, selNode, menuId, itemId) {

    if (container != null) {

        // get selected node
        var selNode = container.getSelNode();

        if (selNode != null) {

            switch (itemId) {
                case "0": // add category
                    var selNodeID = selNode.NodeID;
                    container.ctx_liveAdd(selNodeID, ikb_strDefaultTroubleshooterNodeText);
                    break;
                case "2": // expand
                    container.expandAll();
                    break;
                case "3": // collapse
                    container.collapseAll();
                    break;
            }

            iasp_HideAllMenus();
        }
    }
}

/* staff troubleshooter context menu */
function ikb_treeTroubleshooterContextMenu(container, selNode, menuId, itemId) {

    if (container != null) {

        // get selected node
        var selNode = container.getSelNode();

        if (selNode != null) {

            switch (itemId) {
                case "0": // add step
                    var selNodeID = selNode.NodeID;
                    container.ctx_liveAdd(selNodeID, ikb_strDefaultTroubleshooterNodeText);
                    break;
                case "1": // quick edit
                    container.liveNodeEditStart(selNode.ID);
                    break;
                case "2": // edut category detailed
                    if (selNode.NavigateURL.indexOf("javascript:") == -1) {
                        location = selNode.NavigateURL;
                    } else {
                        var loc = ""; loc = location.href;
                        var end = loc.indexOf("?");
                        var loc = loc.substring(0, end);
                        var uri = loc + "?StepID=" + selNode.CategoryID;
                        location = uri;
                    }
                    break;
                case "4": // move up
                    // get orevious node
                    var dest = null; if (selNode.PrevNode != null) { dest = selNode.PrevNode; }
                    if (dest != null) {
                        // move node
                        container.moveChild(selNode, dest, 2)
                        // do callback
                        ikb_treeCallBack(container, selNode, container.Options.LiveMoveUpCallBackURL, "", "&id=" + selNode.CategoryID)
                    }
                    break;
                case "5": // move down
                    // get bext node  
                    var dest = null; if (selNode.NextNode != null) { dest = selNode.NextNode; }
                    if (dest != null) {
                        // move node
                        container.moveChild(selNode, dest, 3)
                        // do callback 
                        ikb_treeCallBack(container, selNode, container.Options.LiveMoveDownCallBackURL, "", "&id=" + selNode.CategoryID)
                    }
                    break;
                case "7": // delete 
                    // confirm delete step
                    if (confirm(ikb_strDeleteTroubleshooterStep)) {
                        // delete node
                        container.remove();
                        // do callback
                        ikb_treeCallBack(container, selNode, container.Options.LiveDeleteCallBackURL, ikb_strProblemDeletingCategory, "&id=" + selNode.CategoryID)
                    }
                    break;
            }

            iasp_HideAllMenus();

        }
    }
}

/* save tree node update on textbox blur */
function ikb_treeLiveWrite(tree) {

    if (tree != null) {

        // get node
        var node = tree.SelectedNode;

        if (node != null) {

            // get url
            var arrURL = tree.Options.LiveWriteCallBackURL.split("?");

            // setup xmlhttp
            if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
            var objXmlHttpHandler = function (obj) {
                if (obj.responseXML != null) {
                    var items = obj.responseXML.getElementsByTagName("result");
                    if (items.length > 0) {
                        for (var i = 0; i < items.length; i++) {
                            var nd = items[i];
                            // get result
                            var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                            // end loader
                            iasp_AjaxExtensionsEndRequest();
                            // was everything OK
                            if (identity == 0) {
                                alert(ikb_strProblemSavingCategory);
                            } else {
                                tree.SelectedNode.CategoryID = identity;
                            }
                        }
                    }
                }
            };

            var categoryID = 0;
            if (node.ParentNode != null) {
                categoryID = node.ParentNode.CategoryID;
            }
            // setup params
            var strParams = arrURL[1] + "&id=" + node.CategoryID + "&ParentID=" + categoryID + "&Key=" + iasp_EncodeString(node.Text);
            // setup loader
            iasp_AjaxExtensionsInitializeRequest();
            // make request
            this.XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

        }
    }
}

function ikb_treeCallBack(tree, node, callbackURL, errMsg, params) {

    if (tree != null) {

        // do we have a specific node?
        if (node == null) { node = tree.SelectedNode; }

        if (node != null) {

            // get url
            var arrURL = callbackURL.split("?");

            // setup xmlhttp
            if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
            var objXmlHttpHandler = function (obj) {
                if (obj.responseXML != null) {
                    var items = obj.responseXML.getElementsByTagName("result");
                    if (items.length > 0) {
                        for (var i = 0; i < items.length; i++) {
                            var nd = items[i];
                            // get result
                            var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                            // end loader
                            iasp_AjaxExtensionsEndRequest();
                            // was everything ok
                            if (identity == 0) { alert(errMsg); }
                        }
                    }
                }
            };

            // we need a category id to delete   
            if (node.CategoryID > 0) {
                // setup params
                var strParams = arrURL[1] + params
                // setup loader
                iasp_AjaxExtensionsInitializeRequest();
                // make request
                this.XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);
            }

        }
    }
}

function ikb_toggleTree(tree) {
    if (tree.Options.Expanded) {
        tree.collapseAll();
        tree.Options.Expanded = false;
    } else {
        tree.expandAll();
        tree.Options.Expanded = true;
    }
}

/* ----------------------------------------------------------- */
// logout confirmation alert
/* ----------------------------------------------------------- */

function ikb_logOut() {

    // disable body
    iasp_disableBody(null, null, false);

    if (confirm(ikb_strLogoutAlertText)) {
        return true;
    }
    else {
        // enable body if cancel
        iasp_enableBody();
        return false;
    }


}

/* ----------------------------------------------------------- */
// show ajax based glossary tooltip
/* ----------------------------------------------------------- */

function ikb_showGlossaryToopTip(el, intGlossaryTermID) {

    // tooltip width 
    var intWidth = 275;
    var intShowForSecs = 5;

    // get url
    var arrURL = strGlossaryToolTipCallBackURL.split("?");

    // setup xmlhttp
    if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    // get result
                    var strValue = nd.getAttribute("value") == null ? 0 : nd.getAttribute("value");
                    // was everything ok
                    if (strValue == "") {
                        alert(ikb_strSendProblem);
                        iasp_DisableTip();
                    } else {

                        var $el = $(el);
                        el.title = strValue;
                        iasp_hideToolTip();
                        iasp_showTip($el);
                        $el.bind("mouseleave", function () {
                            iasp_hideToolTip();
                        });

                        
                        
                    }
                }
            }
        }
    };

    // setup params
    var strParams = arrURL[1] + "&id=" + intGlossaryTermID;
    // show loading tooltip
    el.title = "Loading...";
    el.setAttribute("data-width", "400");
    iasp_showTip($(el));
    // make request
    this.XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

/* ----------------------------------------------------------- */
// main navigation forum search
/* ----------------------------------------------------------- */

function kbSearch(txtID, defaultVal, installURL, pageURL) {

    // loop through inputs as we may have dynamically added the textbox ie. appendChild(txt)
    var t = null;
    var everything = document.getElementsByTagName('input');
    var everythinglength = everything.length;
    for (var i = 0; i < everythinglength; i++) {
        try {
            if (everything[i].id == txtID) {
                t = everything[i];
            }
        }
        catch (e) {
            t = null;
        }
    }

    if (t != null) {
        if (t.value != defaultVal) {
            if (t.value != "") {
                if (installURL != null) { // SEO URLs enabled   
                    if (pageURL != null) {
                        location = installURL + pageURL + "?Keywords=" + t.value;
                    } else {
                        location = installURL + "Search/?Keywords=" + t.value;
                    }
                } else {
                    if (pageURL != null) {
                        location = pageURL + "?Keywords=" + t.value;
                    } else {
                        location = "Search.aspx?Keywords=" + t.value;
                    }
                }
                return;
            }
        }
        if (installURL != null) { // SEO URLs enabled   
            if (pageURL != null) {
                location = installURL + pageURL;
            } else {
                location = installURL + "/Search/";
            }
        } else {
            if (pageURL != null) {
                location = pageURL;
            } else {
                location = "Search.aspx";
            }
        }
    }

}

/* ----------------------------------------------------------- */
// method to add standard replies to the rich text box within the staff CP
/* ----------------------------------------------------------- */

function ikb_AddStandardReply(intReplyID, strRTBClientID, strCallBackURL) {

    var editor = $find(strRTBClientID);

    // get url
    var arrURL = strCallBackURL.split("?");

    // setup xmlhttp
    if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    // get result
                    var text = nd.getAttribute("text") == null ? "" : nd.getAttribute("text");
                    // end loader
                    iasp_AjaxExtensionsEndRequest();
                    // was everything ok
                    if (text == "") {
                        alert(ikb_strAddStandardReplyProblem);
                    } else {

                        editor.pasteHtml(text);
                    }
                }
            }
        }
    };

    // setup params
    var strParams = arrURL[1] + "&ID=" + intReplyID;
    // setup loader
    iasp_AjaxExtensionsInitializeRequest();
    // make request
    this.XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

/* ----------------------------------------------------------- */
// live search for ticket submissions
/* ----------------------------------------------------------- */

var iaspls_timeoutID = null;
var lsDelay = 2;
var lsPageSze = 5;
var lsTxt = null
var lsRTB = null;

// text box change event
function ikb_lsTextSelChanged(txt, usetimeout) {
    lsTxt = txt;
    lsPageSze = 5;
    if (txt.value != "" && iaspls_timeoutID == null) {
        if (usetimeout) {
            iaspls_timeoutID = setTimeout(ikb_lsKeyDown, lsDelay * 1000)
        } else {
            ikb_lsKeyDown();
        }      
    }
}

// rich text box key down event for live suggestions
function ikb_lsEditorOnClientLoad(editor, args) {
     
    // initialize general editor settings
    Editor_OnClientLoad(editor, args);

    // add a timed event handler for live suggestions
    if (editor != null) {
        addEvent(editor.get_document(), 'keydown', function (e) {
            if (iaspls_timeoutID == null) {          
                lsPageSze = 5;        
                if (editor.get_text() != "") {
                    lsRTB = editor;               
                    iaspls_timeoutID = setTimeout(ikb_lsKeyDown, lsDelay * 1000)
                }
            }

        });
    }
}

function ikb_lsKeyDown() {
    
    var strKeywords = ""
    if (lsTxt != null) {
        strKeywords = lsTxt.value;
    }

    if (lsRTB != null) {
        strKeywords = strKeywords + " " + lsRTB.get_text()
    }

    if (ls != null) {

        var pnl = iasp_FindControl(ls.id);
        var pnlMore = iasp_FindControl(ls.more);
        var tr1 = iasp_FindControl(ls.tr1);
        var tr2 = iasp_FindControl(ls.tr2);

        // check for our settings array
        if (pnl != null && tr1 != null && tr2 != null) {

            if (strKeywords != "") {
                ikb_lsPopulate(lsPageSze, strKeywords, ls.callbackurl, pnl, pnlMore, tr1, tr2);
            } else {
                tr1.style.display = "none";
                tr2.style.display = "none";
                pnl.innerHTML = "";
                if (iaspls_timeoutID != null) { clearTimeout(iaspls_timeoutID); iaspls_timeoutID = null; }
            }
        }
    }
}

function ikb_lsMoreClick() {
    lsPageSze += 5;
    ikb_lsKeyDown(true);
}

function ikb_lsPopulate(pageSize, strKeywords, strCallBackURL, pnl, pnlMore, tr1, tr2) {

    // get url
    var arrURL = strCallBackURL.split("?");
    var intTotal = 0;

    // setup xmlhttp
    if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var total = obj.responseXML.getElementsByTagName("total");       
            if (total.length > 0) {
                for (var i = 0; i < total.length; i++) {
                    var nd = total[i];
                    intTotal = parseInt(nd.firstChild.nodeValue)
                }
            }
            var items = obj.responseXML.getElementsByTagName("result");
            var s = "";
            if (items.length > 0) {
                s += "<h3 style='line-height: normal; display:block;'>" + ikb_strLiveResultsHeader + "</h3><br/>";
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    var title = nd.getAttribute("title") == null ? "" : nd.getAttribute("title");
                    var rank = nd.getAttribute("rank") == null ? 0 : parseInt(nd.getAttribute("rank"));
                    var text = nd.getAttribute("text") == null ? "" : nd.getAttribute("text");
                    var navigateurl = nd.getAttribute("navigateurl") == null ? "" : nd.getAttribute("navigateurl");
                    s += "<div class=\"row\" style=\"margin-bottom: 16px;\">";
                    s += "<i class=\"fa fa-file-o\" style=\"margin-right: 12px;\"></i><a href=\"" + navigateurl + "\" target=\"_blank\" class=\"primary\">" + title + "</a>";
                    if (rank > 0) {
                        s += "<span class=\"SmallGrayText\">";
                        s += " " + ibk_Rank.replace("[0]", rank)
                        s += "</span>";
                    }
                    s += "<br />";
                    s += text;
                    s += "</div>";
                }
            }

            if (typeof s != 'undefined' && s != null) {
                if (s != "") {
                    tr1.style.display = "";
                    tr2.style.display = "";                
                    if (pageSize >= intTotal) {
                        pnlMore.style.display = "none";
                    } else {
                        pnlMore.style.display = "";
                    }
                    pnl.innerHTML = s;
                } else {
                    tr1.style.display = "none";
                    tr2.style.display = "none";
                    pnl.innerHTML = "";
                }
            } else {
                tr1.style.display = "none";
                tr2.style.display = "none";
                pnl.innerHTML = "";
            }

            // clear timeout
            if (iaspls_timeoutID != null) { clearTimeout(iaspls_timeoutID); iaspls_timeoutID = null; }         
          
        } else {

            // clear timeout
            if (iaspls_timeoutID != null) { clearTimeout(iaspls_timeoutID); iaspls_timeoutID = null; }

        }
    };

    // setup params
    var strParams = arrURL[1] + "&Keywords=" + iasp_EncodeString(strKeywords) + "&PageSize=" + pageSize + "&SearchUsing=1";
    
    // make request
    this.XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

/* ----------------------------------------------------------- */
// search suggestions
/* ----------------------------------------------------------- */

var searchSuggest = {
    timer: null,
    tabId: 0,
    $txt: null,
    $button: null,
    $tabs: null,
    $results: null,
    pageSize: 10,
    callbackUrl: null,
    setResultsPosition: function () {

        var txt = searchSuggest.$txt;
        var el = $("#searchSuggest");
        var container = $(txt).parents(".input_BG");
           
        var height = txt.offsetHeight + 4,
            top = iasp_GetOffsetTop(txt),
            left = iasp_GetOffsetLeft(txt),
            width = $(container).width(),
            bottom = top + height;

        el.css({ "left": left - 1, "top": bottom, "width": width });
       
    },
    buildResults: function() {

        var el = null;  
        if ($("#searchSuggest").length == 0) {
            el = $("<div id=\"searchSuggest\"></div>");
            el.css({ "display": "none" });
            el.addClass("search-suggest-menu");
            $("body").append(el);  
        } else {
            el = $("#searchSuggest");
        }

        this.setResultsPosition(el);
        return el;

    },  
    keyDown: function (e, txt, tabId, tabs, url) {
               
        
        if ((e.keyCode && e.keyCode == 13)) {
            var pnl = searchSuggest.$results;
            pnl.hide().html("");
            var baseUrl = $(txt).data("searchurl");
            if (baseUrl != null && typeof baseUrl != 'undefined') {
                var url = $(txt).data("searchurl") + "?Keywords=" + encodeURIComponent(txt.value);         
                location = url;
            }
            return false;
        }

        this.tabId = tabId;
        this.$txt = txt;        
        this.$tabs = $("#" + tabs).find("input");
        this.$results = this.buildResults();
        if (this.$button == null) {
            this.$button = $(txt).parent().parent().find(".search-button").find(".fa-search");
        }
                   
        iasp_HideAllMenus();
             
        if (this.callbackUrl == null) {
            this.callbackUrl = url;
            $(document).click(function () {
                if ($("#searchSuggest").is(":visible")) {
                    $("#searchSuggest").hide();
                    $(this.$txt).blur();
                }
            });
        }
         
        if (txt.value != "") {          
            if (searchSuggest.timer == null) {
                if (e.keyCode != 0) {
                    searchSuggest.timer = window.setTimeout(function () {
                        searchSuggest.populate();
                    }, 1000);
                } else {
                    searchSuggest.populate();
                }
            }
        } else {            
            var pnl = searchSuggest.$results;
            pnl.hide().html("");
            searchSuggest.timer = null;
            searchSuggest.$button.removeClass("fa-spinner").removeClass("fa-spin").addClass("fa-search");
        }
        
        return true;

    },
    populate: function () {
            
        var total = 0, tabID = 0,
            url = this.callbackUrl.split("?"),
            txt = this.$txt,
            pnl = this.$results;
                    
        var tabID = 0;
       
        if (searchSuggest.$tabs.length > 0) {
            tabID = searchSuggest.$tabs.filter(":checked").val();
        } else {
            tabID = searchSuggest.tabId;
        }
      
        // setup xmlhttp
        if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
        var objXmlHttpHandler = function (obj) {
            if (obj.responseXML != null) {
                var total = obj.responseXML.getElementsByTagName("total");
                if (total.length > 0) {
                    for (var i = 0; i < total.length; i++) {
                        var nd = total[i];
                        total = parseInt(nd.firstChild.nodeValue)
                    }
                }
        
                var items = obj.responseXML.getElementsByTagName("result");             
                var s = "";
                if (items.length > 0) {
                    s += "<div class=\"results\">";
                    for (var i = 0; i < items.length; i++) {
                        var nd = items[i];
                        var title = nd.getAttribute("title") == null ? "" : nd.getAttribute("title");
                        var rank = nd.getAttribute("rank") == null ? 0 : parseInt(nd.getAttribute("rank"));
                        var img = nd.getAttribute("img") == null ? "" : nd.getAttribute("img");
                        var text = nd.getAttribute("text") == null ? "" : nd.getAttribute("text");
                        var navigateurl = nd.getAttribute("navigateurl") == null ? "" : nd.getAttribute("navigateurl");
                        if (navigateurl) {
                            navigateurl += "?Keywords=" + encodeURI(txt.value);
                        }

                        s += "<a title=\"" + text + "\" href=\"" + navigateurl + "\"><span class=\"padding\"><span class=\"title\">";

                        if (img != "") {
                            s += "<img class=\"align-middle\" style=\"margin-right: 6px;\" src=\"" + img + "\"/>";
                        }

                        s += title + "</span>";

                        if (rank > 0) {
                            s += " " + ibk_Rank.replace("[0]", rank)
                        }
                        //s += "<br />";
                        //s += text;
                        s += "</span></a>";
                    }
                    s += "</div>";
                } else {
                    s += "<div class=\"results\">";
                    s += "<div class=\"padding\">";
                    s += "No results";
                    s += "</div>";
                    s += "</div>";
                }

                if (typeof s != 'undefined' && s != null) {
                    if (s != "") {                    
                        pnl.show()                 
                        pnl.html(s);
                    } else {                    
                        pnl.hide()
                        pnl.html("");
                    }
                } else {                
                    pnl.hide()
                    pnl.html("");
                }
                            
            }

            // clear timeout we don't want to keep hitting the db
            if (searchSuggest.timer != null) { clearTimeout(searchSuggest.timer); searchSuggest.timer = null; }
            searchSuggest.$button.removeClass("fa-spinner").removeClass("fa-spin").addClass("fa-search");

        };
                     
        // setup params
        var strParams = url[1] + "&Keywords=" + encodeURI(txt.value) + "&TabID=" + tabID + "&PageSize=" + searchSuggest.pageSize + "&SearchUsing=2";
        this.$button.removeClass("fa-search").addClass("fa-spinner").addClass("fa-spin");

        // make request
        this.XmlHttp.Connect(url[0], "GET", strParams, objXmlHttpHandler);
        
    }
}

/* ----------------------------------------------------------- */
// helper for all r.a.d editor controls
/* ----------------------------------------------------------- */

function Editor_OnClientLoad(editor, args) {
        
    // clear tab index on editor buttons
    var contentArea = editor.get_contentArea(),
        textArea = editor.get_textArea(),
        toolbar = $get(editor.get_id() + "Top"),
        buttons = toolbar.getElementsByTagName("A");
    
    if (buttons != null && typeof buttons != 'undefined') {
        for (var i = 0; i < buttons.length; i++) {
            var a = buttons[i];
            a.tabIndex = -1;
            a.tabStop = false;
        }
    }

    if (textArea != null && typeof textArea != 'undefined') {        
        textArea.className = "FormInputTextArea";
    }

    // ensure menus are hidden on mouse down within the editor
    if (contentArea != null && typeof contentArea != 'undefined') {      
        addEvent(contentArea, 'mousedown', function () {           
            iasp_HideAllMenus();
        });
    }
    
}

function Editor_OnClientPasteHtml(sender, args) {

    return;
   
}

function doHelpSearch(searchURL, txt) {

    var txt = iasp_FindControl(txt);

    if (txt != null) {
        if (txt.value != "Enter Keywords..." && txt.value != "") {
            location = searchURL + "?Keywords=" + iasp_EncodeString(txt.value);
        } else {
            txt.focus();
            txt.value = "";
        }
    }
    return false;

}

function ikb_updateSplitterCookie(sender) { 
    iasp_SetCookie('tocWidth', sender.get_width());
    showSplitterTable(sender.get_splitter());
}

function showSplitterTable(splitter) {
    if ($telerik.isIE) {
        splitter.getContainerElement().style.position = 'static';
    }
}

/* ----------------------------------------------------------- */
// flag ticket
/* ----------------------------------------------------------- */

function ikb_FlagTicket(img, id, callbackurl) {

    if (img == null) { return; }

    if (img.src.toLowerCase().indexOf("flagoff.gif") >= 0) {
        ikb_FlagTicketCallBack(img, callbackurl, true, id)
    } else {
        ikb_FlagTicketCallBack(img, callbackurl, false, id)
    }


}

function ikb_FlagTicketCallBack(img, strCallBackURL, bolFlag, intTicketID) {

    // get url
    var arrURL = strCallBackURL.split("?");

    // setup xmlhttp
    if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    // get result
                    var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                    // was everything ok
                    if (identity == 0) {
                        alert(errMsg);
                    } else {

                        var tr = iasp_GetContainer(img, "TR")
                        if (tr == null) { return; }

                        if (bolFlag) {
                            img.src = img.src.toLowerCase().replace("flagoff.gif", "flagon.gif")
                            var td = tr.getElementsByTagName("TD");
                            for (var i = 0; i < td.length; i++) {
                                if (td[i].className == "TableCell_Light") {
                                    td[i].className = "TableCell_Flagged";
                                }
                            }
                        } else {
                            img.src = img.src.toLowerCase().replace("flagon.gif", "flagoff.gif")
                            var td = tr.getElementsByTagName("TD");
                            for (var i = 0; i < td.length; i++) {
                                if (td[i].className == "TableCell_Flagged") {
                                    td[i].className = "TableCell_Light";
                                }
                            }

                        }


                    }

                    // end loader
                    iasp_AjaxExtensionsEndRequest();

                }
            }
        }
    };

    // setup params
    var intFlag = 0;
    if (bolFlag) { intFlag = 1; }
    var strParams = arrURL[1] + "&ID=" + intTicketID + "&Update=" + intFlag;
    // setup loader
    iasp_AjaxExtensionsInitializeRequest();
    // make request
    this.XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

// update ticket status or priority
function ikb_UpdateTicket(intTicketID, intIdentity, strButID, strCallBackURL) {

    // get url
    var arrURL = strCallBackURL.split("?");

    // setup xmlhttp
    if (!this.XmlHttp) { this.XmlHttp = new iasp_XmlHttpRequest(); }
    var objXmlHttpHandler = function (obj) {
        if (obj.responseXML != null) {
            var items = obj.responseXML.getElementsByTagName("result");
            if (items.length > 0) {
                for (var i = 0; i < items.length; i++) {
                    var nd = items[i];
                    // get result
                    var identity = nd.getAttribute("identity") == null ? 0 : nd.getAttribute("identity");
                    // was everything ok
                    if (identity == 0) {
                        alert(errMsg);
                    } else {
                        iasp_HideAllMenus();
                        iasp_FindControl(strButID).click();
                    }
                    // end loader
                    iasp_AjaxExtensionsEndRequest();

                }
            }
        }
    };


    var strParams = arrURL[1] + "&TicketID=" + intTicketID + "&ID=" + intIdentity;
    // setup loader    
    iasp_AjaxExtensionsInitializeRequest();
    // make request
    this.XmlHttp.Connect(arrURL[0], "GET", strParams, objXmlHttpHandler);

}

$(document).ready(function () {

    initAdminNavigation();
    
    /* mobile bread-crumb */
    $(".bc ul").find("li.last").find("a").bind("click", function () {
        if ($(window).width() < 1024) {
                  
            var menu = $(".bc-menu");
            if (menu.length == 0)
            {                
                // close button
                var close = $('<a href="javascript:void(0);">');
                close.addClass("btn");
                close.append($('<i class="fa fa-plus rotate45">'));
                close.bind("click", function () {                   
                    $(".bc-menu").stop().animate({
                        'left': "-230px"
                    }, 150, 'easeInOutExpo', function () {

                    });
                });

                // header
                var header = $('<div class="row">');
                header.append(close);
                // menu
                menu = $('<div class="row">');                               
                menu.addClass("bc-menu");
                menu.css({ "left": "-230px"})

                // add
                menu.append(header);
                menu.append($(".bc").find("ul").clone())                        
                $("body").append(menu);

                menu.stop().animate({
                    'left': "0px"
                }, 150, 'easeInOutExpo', function () {

                });

            } else {

                if (menu.css("left") == "-230px") {
                    menu.stop().animate({
                        'left': "0px"
                    }, 150, 'easeInOutExpo', function () {

                    });
                } else {
                    menu.stop().animate({
                        'left': "-230px"
                    }, 150, 'easeInOutExpo', function () {

                    });
                }
            }
            
            return false;

        } else {
            return true;
        }
    });


});

function ikb_ShowMobileMenu() {
    
 
    var menu = $(".mobile-menu");        
    if (menu.css("left") == "-230px") {             
        menu.stop().animate({
            'left': "0px"
        }, 150, 'easeInOutExpo', function () {

        });
    } else {        
        menu.stop().animate({
            'left': "-230px"
        }, 150, 'easeInOutExpo', function () {        
        });
    }

}

function ikb_ShowMobileSearch() {
    
    var menu = $(".mobile-search");
    if (menu.css("right") == "-230px") {
        menu.stop().animate({
            'right': "0px"
        }, 150, 'easeInOutExpo', function () {

        });
    } else {
        menu.stop().animate({
            'right': "-230px"
        }, 150, 'easeInOutExpo', function () {
        });
    }

}


function ikb_ShowMobileControlPanelMenu() {

    var a = $(".control-panel-mobile-bars");
    var menu = $(".control-panel-left");   
    if (menu.css("right") == "-230px") {

        a.stop().animate({
            'right': "230px"
        }, 150, 'easeInOutExpo', function () {
            $(".control-panel-mobile-bars").find("i").removeClass("fa-angle-left").addClass("fa-angle-right");
        });

        menu.stop().animate({
            'right': "0px"
        }, 150, 'easeInOutExpo', function () {

        });
    } else {

        a.stop().animate({
            'right': "0px"
        }, 150, 'easeInOutExpo', function () {
            $(".control-panel-mobile-bars").find("i").removeClass("fa-angle-right").addClass("fa-angle-left");
        });

        menu.stop().animate({
            'right': "-230px"
        }, 150, 'easeInOutExpo', function () {

        });
    }

}

function initAdminNavigation() {

    var smlnav = $(".admin-small-nav"),
        nav = $(".admin-body-nav"),
        body = $(".admin-body-main"),
        margin = $(".admin-body-margin"),
        cookieName = "ikb_admin_nav_state",
        state = iasp_GetCookie(cookieName);

    if (state) {
        expand();
    }
    
    // expand / collapse navigation within the staff & admin CP
    $(".admin-body-nav-toggle a").click(function () {        
        if (nav.is(":visible")) {
            collapse();
            iasp_UpdateCookie($(this), false, cookieName);
        } else {
            expand(true);
            iasp_UpdateCookie($(this), true, cookieName);
        }
    });

    function expand(animate) {
        
        var isPhone = false;
        // for smaller screens slide everything right
        if ($(window).width() < 500) {
            isPhone = true;
        }

        if (isPhone) {
            // hide side bar
            $(".admin-body").css({ 'background-position': "-260px" })
            // if we are on a small screen slide everything to the right
            // this avoids the content being squeezed and wrapping
            body.css({ "width": "100%" });
            margin.css({ "overflow": "hidden" });
        } else {
            body.css({ "width": "auto" });
            margin.css({ "overflow": "auto" });
        }

        if (animate) {

            // animate
            smlnav.stop().animate({
                'width': "0px"
            }, 150, 'easeInOutExpo', function () {

                smlnav.hide();
                nav.show();
                          
                $(".admin-body").stop().animate({
                    'background-position': "-60px"
                }, 150, 'easeInOutExpo');

                body.stop().animate({
                    'marginLeft': "200px"
                }, 150, 'easeInOutExpo');

                nav.stop().animate({
                    'width': "200px"
                }, 150, 'easeInOutExpo');

                margin.stop().animate({
                    'marginLeft': "0px"
                }, 150, 'easeInOutExpo');

            });

        } else {

            // no animation   
            smlnav.css({ 'width': "0px" });
            smlnav.hide();
            nav.show();

            $(".admin-body").css({'background-position': "-60px" });
            body.css({'marginLeft': "200px" });
            nav.css({ 'width': "200px"});
            margin.css({'marginLeft': "0px"});
            
        }

        $(".admin-body-nav-toggle a").find("i")
            .removeClass("fa-angle-right")
            .addClass("fa-angle-left");
        
    }

    function collapse() {

        var isPhone = false;
        // for smaller screens slide everything right
        if ($(window).width() < 500) {
            isPhone = true;
        }

        var pos = "-200px";
        if (isPhone) {
            pos = "-260px"
        }
        $(".admin-body").stop().animate({
            'background-position': pos
        }, 150, 'easeInOutExpo');
                   
        margin.css({ "overflow": "auto" }).stop().animate({
            'marginLeft': "60px"
        }, 150, 'easeInOutExpo');

        nav.stop().animate({
            'width': "0px"
        }, 150, 'easeInOutExpo', function () {
            nav.hide();
            smlnav.show();
            smlnav.stop().animate({
                'width': "60px"
            }, 350, 'easeInOutExpo');
        });

        body.stop().animate({
            'marginLeft': "0px"
        }, 150, 'easeInOutExpo');

        $(".admin-body-nav-toggle a").find("i")
            .addClass("fa-angle-right")
            .removeClass("fa-angle-left");

    }
        
}

function ikb_AdminSearch(event, txt, tabId, tabs, callbackUrl) {
    
    txt = iasp_FindControl(txt);
    searchSuggest.keyDown(event, txt, tabId, tabs, callbackUrl);

    return false;

}

/* populate hidden input when selecting tabs in search menu */
function ikb_SearchTabChanged(rb, txt) {
    txt = $("#" + txt);
    if (txt.length > 0)
    {              
        var id = $(rb).find("input").filter(":checked").val();
        txt.val(id);
    }

}

/* set the default tab search menu value based on hidden input */
function ikb_InitSearchTabMenu(rb, txt) {
    rb = $("#" + rb);
    txt = $("#" + txt);   
    rb.find("input").each(function () {
        var input = $(this);      
        if (input.val() === txt.val()) {            
            input.prop('checked', true);
        }
    });
}