﻿/***********************************
scrolling
************************************/

(function ($) {

    $.jScrollPane = {
        active: []
    };
    $.fn.jScrollPane = function (settings) {
        settings = $.extend({}, $.fn.jScrollPane.defaults, settings);

        var rf = function () { return false; };

        return this.each(
		function () {
		    var $this = $(this);
		    var paneEle = this;
		    var currentScrollPosition = 0;
		    var paneWidth;
		    var paneHeight;
		    var trackHeight;
		    var trackOffset = settings.topCapHeight;
		    var $container;

		    if ($(this).parent().is('.jScrollPaneContainer')) {
		        $container = $(this).parent();
		        currentScrollPosition = settings.maintainPosition ? $this.position().top : 0;
		        var $c = $(this).parent();
		        paneWidth = $c.innerWidth();
		        paneHeight = $c.outerHeight();
		        $('>.jScrollPaneTrack, >.jScrollArrowUp, >.jScrollArrowDown, >.jScrollCap', $c).remove();
		        $this.css({ 'top': 0 });
		    } else {
		        $this.data('originalStyleTag', $this.attr('style'));
		        // Switch the element's overflow to hidden to ensure we get the size of the element without the scrollbars [http://plugins.jquery.com/node/1208]
		        $this.css('overflow', 'hidden');
		        this.originalPadding = $this.css('paddingTop') + ' ' + $this.css('paddingRight') + ' ' + $this.css('paddingBottom') + ' ' + $this.css('paddingLeft');
		        this.originalSidePaddingTotal = (parseInt($this.css('paddingLeft')) || 0) + (parseInt($this.css('paddingRight')) || 0);
		        paneWidth = $this.innerWidth();
		        paneHeight = $this.innerHeight();
                               
		        $container = $('<div></div>')
					.attr({ 'class': 'jScrollPaneContainer' })
					.css(
						{
						    'height': paneHeight + 'px',
						    'width': paneWidth + 'px'
						}
					);
		        if (settings.enableKeyboardNavigation) {
		            $container.attr(
						'tabindex',
						settings.tabIndex
					);
		        }
		        $this.wrap($container);
		        $container = $this.parent();

		    }
        
		    trackHeight = paneHeight;            		
		    var p = this.originalSidePaddingTotal;
		    var realPaneWidth = paneWidth - settings.scrollbarWidth - settings.scrollbarMargin - p;

		    var cssToApply = {
		        'height': 'auto',
		        'width': realPaneWidth + 'px'
		    }

		    if (settings.scrollbarOnLeft) {
		        cssToApply.paddingLeft = settings.scrollbarMargin + settings.scrollbarWidth + 'px';
		    } else {
		        cssToApply.paddingRight = settings.scrollbarMargin + 'px';
		    }

		    $this.css(cssToApply);

		    var contentHeight = $this.outerHeight();
		    var percentInView = paneHeight / contentHeight;

		    var isScrollable = percentInView < .99;    
		    $container[isScrollable ? 'addClass' : 'removeClass']('jScrollPaneScrollable');

		    if (isScrollable) {                     

		        $container.append(
					$('<div></div>').addClass('jScrollCap jScrollCapTop').css({ height: settings.topCapHeight }),
					$('<div></div>').attr({ 'class': 'jScrollPaneTrack' }).css({ 'width': settings.scrollbarWidth + 'px' }).append(
						$('<div></div>').attr({ 'class': 'jScrollPaneDrag' }).css({ 'width': settings.scrollbarWidth + 'px' }).append(
							$('<div></div>').attr({ 'class': 'jScrollPaneDragTop' }).css({ 'width': settings.scrollbarWidth + 'px' }),
							$('<div></div>').attr({ 'class': 'jScrollPaneDragBottom' }).css({ 'width': settings.scrollbarWidth + 'px' })
						)
					),
					$('<div></div>').addClass('jScrollCap jScrollCapBottom').css({ height: settings.bottomCapHeight })
				);
                        
		        var $track = $('.jScrollPaneTrack', $container);
		        var $drag = $('.jScrollPaneTrack .jScrollPaneDrag', $container);
                             
		        var currentArrowDirection;
		        var currentArrowTimerArr = []; // Array is used to store timers since they can stack up when dealing with keyboard events. This ensures all timers are cleaned up in the end, preventing an acceleration bug.
		        var currentArrowInc;
		        var whileArrowButtonDown = function () {
		            if (currentArrowInc > 4 || currentArrowInc % 4 == 0) {
		                positionDrag(dragPosition + currentArrowDirection * mouseWheelMultiplier);
		            }
		            currentArrowInc++;
		        };

		        if (settings.enableKeyboardNavigation) {
		            $container.bind(
						'keydown.jscrollpane',
						function (e) {
						    switch (e.keyCode) {
						        case 38: //up
						            currentArrowDirection = -1;
						            currentArrowInc = 0;
						            whileArrowButtonDown();
						            currentArrowTimerArr[currentArrowTimerArr.length] = setInterval(whileArrowButtonDown, 100);
						            return false;
						        case 40: //down
						            currentArrowDirection = 1;
						            currentArrowInc = 0;
						            whileArrowButtonDown();
						            currentArrowTimerArr[currentArrowTimerArr.length] = setInterval(whileArrowButtonDown, 100);
						            return false;
						        case 33: // page up
						            scrollTo(0);
						            return false;
						        case 34: // page down
						            scrollTo(9999999999);
						            return false;
						        default:
						    }
						}
					).bind(
						'keyup.jscrollpane',
						function (e) {
						    if (e.keyCode == 38 || e.keyCode == 40) {
						        for (var i = 0; i < currentArrowTimerArr.length; i++) {
						            clearInterval(currentArrowTimerArr[i]);
						        }
						        return false;
						    }
						}
					);
		        }
                     
		        if (settings.showArrows) {

		            var currentArrowButton;
		            var currentArrowInterval;

		            var onArrowMouseUp = function (event) {
		                $('html').unbind('mouseup', onArrowMouseUp);
		                currentArrowButton.removeClass('jScrollActiveArrowButton');
		                clearInterval(currentArrowInterval);
		            };
		            var onArrowMouseDown = function () {
		                $('html').bind('mouseup', onArrowMouseUp);
		                currentArrowButton.addClass('jScrollActiveArrowButton');
		                currentArrowInc = 0;
		                whileArrowButtonDown();
		                currentArrowInterval = setInterval(whileArrowButtonDown, 100);
		            };
		            $container
						.append(
							$('<a></a>')
								.attr(
									{
									    'href': 'javascript:;',
									    'class': 'jScrollArrowUp',
									    'tabindex': -1
									}
								)
								.css(
									{
									    'width': settings.scrollbarWidth + 'px',
									    'top': settings.topCapHeight + 'px'
									}
								)
								.html('Scroll up')
								.bind('mousedown', function () {
								    currentArrowButton = $(this);
								    currentArrowDirection = -1;
								    onArrowMouseDown();
								    this.blur();
								    return false;
								})
								.bind('click', rf),
							$('<a></a>')
								.attr(
									{
									    'href': 'javascript:;',
									    'class': 'jScrollArrowDown',
									    'tabindex': -1
									}
								)
								.css(
									{
									    'width': settings.scrollbarWidth + 'px',
									    'bottom': settings.bottomCapHeight + 'px'
									}
								)
								.html('Scroll down')
								.bind('mousedown', function () {
								    currentArrowButton = $(this);
								    currentArrowDirection = 1;
								    onArrowMouseDown();
								    this.blur();
								    return false;
								})
								.bind('click', rf)
						);
		            var $upArrow = $('>.jScrollArrowUp', $container);
		            var $downArrow = $('>.jScrollArrowDown', $container);
		        }

		        if (settings.arrowSize) {
		            trackHeight = paneHeight - settings.arrowSize - settings.arrowSize;
		            trackOffset += settings.arrowSize;
		        } else if ($upArrow) {
		            var topArrowHeight = $upArrow.height();
		            settings.arrowSize = topArrowHeight;
		            trackHeight = paneHeight - topArrowHeight - $downArrow.height();
		            trackOffset += topArrowHeight;
		        }
		        trackHeight -= settings.topCapHeight + settings.bottomCapHeight;
		        $track.css({ 'height': trackHeight + 'px', top: trackOffset + 'px' })

		        var $pane = $(this).css({ 'position': 'absolute', 'overflow': 'visible' });

		        var currentOffset;
		        var maxY;
		        var mouseWheelMultiplier;
		        var dragPosition = 0;		   
		        var dragMiddle = percentInView * paneHeight / 2;
		        var getPos = function (event, c) {
		            var p = c == 'X' ? 'Left' : 'Top';
		            return event['page' + c] || (event['client' + c] + (document.documentElement['scroll' + p] || document.body['scroll' + p])) || 0;
		        };

		        var ignoreNativeDrag = function () { return false; };

		        var initDrag = function () {		     
		            ceaseAnimation();		            
		            currentOffset = $drag.offset();                   
		            currentOffset.top -= dragPosition;		          
		            maxY = trackHeight - $drag.height();		           
		            mouseWheelMultiplier = 2 * settings.wheelSpeed * maxY / contentHeight;		     
		        };

		        var onStartDrag = function (event) {
		            initDrag();
		            dragMiddle = getPos(event, 'Y') - dragPosition - currentOffset.top;
		            $('html').bind('mouseup', onStopDrag).bind('mousemove', updateScroll).bind('mouseleave', onStopDrag)
		            if ($.browser.msie) {
		                $('html').bind('dragstart', ignoreNativeDrag).bind('selectstart', ignoreNativeDrag);
		            }
		            return false;
		        };
		        var onStopDrag = function () {
		            $('html').unbind('mouseup', onStopDrag).unbind('mousemove', updateScroll);
		            dragMiddle = percentInView * paneHeight / 2;
		            if ($.browser.msie) {
		                $('html').unbind('dragstart', ignoreNativeDrag).unbind('selectstart', ignoreNativeDrag);
		            }
		        };
		        var positionDrag = function (destY) {		           
		            destY = destY < 0 ? 0 : (destY > maxY ? maxY : destY);
		            dragPosition = destY;		          
		            $drag.css({ 'top': destY + 'px' });
		            var p = destY / maxY;
		            $this.data('jScrollPanePosition', (paneHeight - contentHeight) * -p);
		            $pane.css({ 'top': ((paneHeight - contentHeight) * p) + 'px' });
		            $this.trigger('scroll');
		            if (settings.showArrows) {
		                $upArrow[destY == 0 ? 'addClass' : 'removeClass']('disabled');
		                $downArrow[destY == maxY ? 'addClass' : 'removeClass']('disabled');
		            }
		        };
		        var updateScroll = function (e) {
		            positionDrag(getPos(e, 'Y') - currentOffset.top - dragMiddle);
		        };

		        var dragH = Math.max(Math.min(percentInView * (paneHeight - settings.arrowSize * 2), settings.dragMaxHeight), settings.dragMinHeight);

		        $drag.css(
					{ 'height': dragH + 'px' }
				).bind('mousedown', onStartDrag);

		        var trackScrollInterval;
		        var trackScrollInc;
		        var trackScrollMousePos;

		        var doTrackScroll = function () {
		            if (trackScrollInc > 8 || trackScrollInc % 4 == 0) {
		                positionDrag((dragPosition - ((dragPosition - trackScrollMousePos) / 2)));
		            }
		            trackScrollInc++;
		        };

		        var onStopTrackClick = function () {
		            clearInterval(trackScrollInterval);
		            $('html').unbind('mouseup', onStopTrackClick).unbind('mousemove', onTrackMouseMove);
		        };
		        var onTrackMouseMove = function (event) {
		            trackScrollMousePos = getPos(event, 'Y') - currentOffset.top - dragMiddle;
		        };
		        var onTrackClick = function (event) {
		            initDrag();
		            onTrackMouseMove(event);
		            trackScrollInc = 0;
		            $('html').bind('mouseup', onStopTrackClick).bind('mousemove', onTrackMouseMove);
		            trackScrollInterval = setInterval(doTrackScroll, 100);
		            doTrackScroll();
		            return false;
		        };

		        $track.bind('mousedown', onTrackClick);

		        $container.bind(
					'mousewheel',
					function (event, delta) {                      
					    if (event.ctrlKey) {
					        return
					    }
                        event.preventDefault();                       
                        event.stopPropagation();                     
                        delta = delta || (event.originalEvent.wheelDelta ? event.originalEvent.wheelDelta / 120 : (event.originalEvent.detail) ? -event.originalEvent.detail / 3 : 0);                    
                        initDrag();                       
                        ceaseAnimation();                    
                        var d = dragPosition;					
					    positionDrag(dragPosition - delta * mouseWheelMultiplier);
					    var dragOccured = d != dragPosition;
					    return !dragOccured;
					}
				);

		        var _animateToPosition;
		        var _animateToInterval;
		        function animateToPosition() {
		            var diff = (_animateToPosition - dragPosition) / settings.animateStep;
		            if (diff > 1 || diff < -1) {
		                positionDrag(dragPosition + diff);
		            } else {
		                positionDrag(_animateToPosition);
		                ceaseAnimation();
		            }
		        }
		        var ceaseAnimation = function () {
		            if (_animateToInterval) {
		                clearInterval(_animateToInterval);
		                delete _animateToPosition;
		            }
		        };
		        var scrollTo = function (pos, preventAni) {

		            if (typeof pos == "string") {
		                // Legal hash values aren't necessarily legal jQuery selectors so we need to catch any
		                // errors from the lookup...
		                try {
		                    $e = $(pos, $this);
		                } catch (err) {
		                    return;
		                }
		                if (!$e.length) return;
		                pos = $e.offset().top - $this.offset().top;
		            }
		            ceaseAnimation();
		            var maxScroll = contentHeight - paneHeight;
		            pos = pos > maxScroll ? maxScroll : pos;
		            $this.data('jScrollPaneMaxScroll', maxScroll);
		            var destDragPosition = pos / maxScroll * maxY;
		            if (preventAni || !settings.animateTo) {
		                positionDrag(destDragPosition);
		            } else {
		                $container.scrollTop(0);
		                _animateToPosition = destDragPosition;
		                _animateToInterval = setInterval(animateToPosition, settings.animateInterval);
		            }
		        };

		        $this[0].scrollTo = scrollTo;

		        $this[0].scrollBy = function (delta) {
		            var currentPos = -parseInt($pane.css('top')) || 0;
		            scrollTo(currentPos + delta);
		        };


		        initDrag();

		        scrollTo(-currentScrollPosition, true);

		        // Deal with it when the user tabs to a link or form element within this scrollpane
		        $('*', this).bind(
					'focus',
					function (event) {
					    return;
					    var $e = $(this);

					    // loop through parents adding the offset top of any elements that are relatively positioned between
					    // the focused element and the jScrollPaneContainer so we can get the true distance from the top
					    // of the focused element to the top of the scrollpane...
					    var eleTop = 0;

					    var preventInfiniteLoop = 100;

					    while ($e[0] != $this[0]) {
					        eleTop += $e.position().top;
					        $e = $e.offsetParent();
					        if (!preventInfiniteLoop--) {
					            return;
					        }
					    }

					    var viewportTop = -parseInt($pane.css('top')) || 0;
					    var maxVisibleEleTop = viewportTop + paneHeight;
					    var eleInView = eleTop > viewportTop && eleTop < maxVisibleEleTop;
					    if (!eleInView) {
					        var destPos = eleTop - settings.scrollbarMargin;
					        if (eleTop > viewportTop) { // element is below viewport - scroll so it is at bottom.
					            destPos += $(this).height() + 15 + settings.scrollbarMargin - paneHeight;
					        }
					        scrollTo(destPos);
					    }
					}
				)


		        if (settings.observeHash) {
		            if (location.hash && location.hash.length > 1) {
		                setTimeout(function () {
		                    // scrollTo(location.hash);
		                }, $.browser.safari ? 100 : 0);
		            }

		            // use event delegation to listen for all clicks on links and hijack them if they are links to
		            // anchors within our content...
		            $(document).bind('click', function (e) {
		                $target = $(e.target);
		                if ($target.is('a')) {
		                    var h = $target.attr('href');
		                    if (h && h.substr(0, 1) == '#' && h.length > 1) {
		                        setTimeout(function () {
		                            scrollTo(h, !settings.animateToInternalLinks);
		                        }, $.browser.safari ? 100 : 0);
		                    }
		                }
		            });
		        }

		        // Deal with dragging and selecting text to make the scrollpane scroll...
		        function onSelectScrollMouseDown(e) {
		            $(document).bind('mousemove.jScrollPaneDragging', onTextSelectionScrollMouseMove);
		            $(document).bind('mouseup.jScrollPaneDragging', onSelectScrollMouseUp);

		        }

		        var textDragDistanceAway;
		        var textSelectionInterval;

		        function onTextSelectionInterval() {
		            direction = textDragDistanceAway < 0 ? -1 : 1;
		            $this[0].scrollBy(textDragDistanceAway / 2);
		        }

		        function clearTextSelectionInterval() {
		            if (textSelectionInterval) {
		                clearInterval(textSelectionInterval);
		                textSelectionInterval = undefined;
		            }
		        }

		        function onTextSelectionScrollMouseMove(e) {
		            var offset = $this.parent().offset().top;
		            var maxOffset = offset + paneHeight;
		            var mouseOffset = getPos(e, 'Y');
		            textDragDistanceAway = mouseOffset < offset ? mouseOffset - offset : (mouseOffset > maxOffset ? mouseOffset - maxOffset : 0);
		            if (textDragDistanceAway == 0) {
		                clearTextSelectionInterval();
		            } else {
		                if (!textSelectionInterval) {
		                    textSelectionInterval = setInterval(onTextSelectionInterval, 100);
		                }
		            }
		        }

		        function onSelectScrollMouseUp(e) {
		            $(document)
					  .unbind('mousemove.jScrollPaneDragging')
					  .unbind('mouseup.jScrollPaneDragging');
		            clearTextSelectionInterval();
		        }

		        $container.bind('mousedown.jScrollPane', onSelectScrollMouseDown);

		        $.jScrollPane.active.push($this[0]);

		    } else {
		        $this.css(
					{
					    'height': paneHeight + 'px',
					    'width': paneWidth - this.originalSidePaddingTotal + 'px',
					    'padding': this.originalPadding
					}
				);
		        $this[0].scrollTo = $this[0].scrollBy = function () { };
		        // clean up listeners
		        $this.parent().unbind('mousewheel').unbind('mousedown.jScrollPane').unbind('keydown.jscrollpane').unbind('keyup.jscrollpane');
		    }

		}
	)
    };

    $.fn.jScrollPaneRemove = function () {
        $(this).each(function () {
            $this = $(this);
            var $c = $this.parent();
            if ($c.is('.jScrollPaneContainer')) {
                $this.css(
				{
				    'top': '',
				    'height': '',
				    'width': '',
				    'padding': '',
				    'overflow': '',
				    'position': ''
				}
			);
                $this.attr('style', $this.data('originalStyleTag'));
                $c.after($this).remove();
            }
        });
    }

    // added by InstantASP to support toggling scroll bar visibility
    $.fn.jScrollPaneHide = function () {
        $(this).each(function () {
            $this = $(this);
            var $c = $this.parent();
            if ($c.is('.jScrollPaneContainer')) {
                //var $a = $($c.after().html());
                $c.find("DIV").each(function () {
                    if ($(this).is('.jScrollPaneTrack')) {
                        $(this).css({ 'display': 'none' });
                        return;
                    }
                });
            }
        });
    }

    $.fn.jScrollPaneShow = function () {
        $(this).each(function () {
            $this = $(this);
            var $c = $this.parent();
            if ($c.is('.jScrollPaneContainer')) {
                $c.find("DIV").each(function () {
                    if ($(this).is('.jScrollPaneTrack')) {
                        $(this).css({ 'display': '' });
                        return;
                    }
                });
            }
        });
    }

    $.fn.jScrollPaneResize = function (h, w, scrollbarWidth) {
        if (scrollbarWidth == null) { scrollbarWidth = 15; }
        $(this).css({ 'height': h, 'width': w });
        $(this).each(function () {
            var $c = $(this).parent();
            if ($c.is('.jScrollPaneContainer')) {
                $c.css({ 'height': h, 'width': w });
            }

            $(this).jScrollPane({ scrollbarWidth: scrollbarWidth });

        });
    }

    $.fn.jScrollHorizontalPaneResize = function (h, w) {

        // reset css
        $(this).css({ 'width': '', 'overflow': '', 'position': '' });
        // get content width        
        var contentWidth = $(this).outerWidth();
        var ieWidth = 0;
        $(this).children().each(
        function (i, elem) {
            if ($(elem).outerWidth() > ieWidth) {
                ieWidth = $(elem).outerWidth();
            }
        });
        if (ieWidth > contentWidth) { contentWidth = ieWidth; }

        $(this).each(function () {
            var $c = $(this).parent();
            $(this).css({ 'height': h, 'width': w });
            if ($c.is('.jScrollPaneContainer')) {
                $c.css({ 'height': h, 'width': w });
            }
            $(this).jScrollHorizontalPane({ contentWidth: contentWidth });
        });

    }

    $.fn.jScrollPane.defaults = {
        scrollbarWidth: 15,
        scrollbarMargin: 0,
        wheelSpeed: 40,
        showArrows: false,
        arrowSize: 0,
        animateTo: false,
        dragMinHeight: 1,
        dragMaxHeight: 99999,
        animateInterval: 100,
        animateStep: 3,
        maintainPosition: true,
        scrollbarOnLeft: false,
        reinitialiseOnImageLoad: false,
        tabIndex: 0,
        enableKeyboardNavigation: true,
        animateToInternalLinks: false,
        topCapHeight: 0,
        bottomCapHeight: 0,
        observeHash: true
    };

    // clean up the scrollTo expandos
    $(window)
	.bind('unload', function () {
	    var els = $.jScrollPane.active;
	    for (var i = 0; i < els.length; i++) {
	        els[i].scrollTo = els[i].scrollBy = null;
	    }
	}
);

})(jQuery);

(function ($) {

var _jscr_originalSizes = new Array();
var _jscr_differenceSizes = new Array();
var _jscr_previousWindowSize = new Array();
var _jscr_originalPercentages = new Array();
var _jscr_trackInt = new Array();
var _jscr_originalPos = new Array();
var _jscr_globalProperties = new Array();

jQuery.jScrollHorizontalPane = {
    active: []
};

jQuery.fn.jScrollHorizontalPane = function (settings) {

    settings = jQuery.extend(
		{
		    scrollbarHeight: 15,
		    scrollbarMargin: 5,
		    wheelSpeed: 18,
		    showArrows: false,
		    contentWidth: 100,
		    arrowSize: 10,
		    animateTo: false,
		    dragMinWidth: 1,
		    dragMaxWidth: 99999,
		    animateInterval: 100,
		    animateStep: 3,
		    maintainPosition: true,
		    resize: true,
		    minimumWidth: 200,
		    reset: false
		}, settings
	);

    return this.each(
		function () {
		    if (settings.reset == true) {
		        jQuery.fn.jScrollHorizontalPane.reset();
		    }

		    //This holds each one of the intervals, defaulting with one at the beginning.
		    var $this = jQuery(this);
		    var mouseWheelNext = 0;
		    var mouseWheelMove = false;
		    var currentId = $this.attr('id');

		    if (currentId == undefined) {
		        currentId = $this.attr('class');
		    }

		    var previousWindow = _jscr_previousWindowSize[currentId];
		    _jscr_originalPos[currentId] = -1;
		    _jscr_globalProperties[currentId] = settings;
		    _jscr_previousWindowSize[currentId] = $(window).width();

		    //On initial load, set values needed for percentage resizing.
		    if (_jscr_originalSizes[currentId] == undefined) {

		        //ie6 hack, since jquery width doesnt get the right value on an inproper refresh
		        if ((jQuery.browser.msie) && (parseInt(jQuery.browser.version) == 6)) {
		            var outerWidth = parseInt($this.outerWidth()) - parseInt($this.offset().left);
		            _jscr_differenceSizes[currentId] = $this.offset().left / $(window).width();
		        } else {
		            var outerWidth = $this.outerWidth();
		            _jscr_differenceSizes[currentId] = $this.position().left / $(window).width();
		        }

		        percentageWidth = (outerWidth / $(window).width());
		        _jscr_originalPercentages[currentId] = percentageWidth;
		        _jscr_originalSizes[currentId] = $(window).width();
		    } else {
		        percentageWidth = _jscr_originalPercentages[currentId];
		        diff = _jscr_differenceSizes[currentId] - (($this.offset().left + _jscr_originalPos[currentId]) / $(window).width());
		        percentageWidth = percentageWidth + diff;
		    }

		    if (jQuery(this).parent().is('.jScrollPaneContainer')) {

		        var currentScrollPosition = settings.maintainPosition ? $this.offset({ relativeTo: jQuery(this).parent()[0] }).left : 0;
		        var $c = jQuery(this).parent();
		        var paneWidth = $c.outerWidth();
		        var paneHeight = $c.innerHeight();
		        var rightPos = $this.offset().left + _jscr_originalPos[currentId] + paneWidth;

		        if ((previousWindow != $(window).width()) && ((rightPos > $(window).width()) || (previousWindow < $(window).width())) && (settings.resize == true)) {

		            if ($(window).width() >= _jscr_originalSizes[currentId]) {
		                paneWidth = ($(window).width() * percentageWidth);
		            } else {
		                //Give the outside edge a 10 px buffer margin
		                paneWidth = $(window).width() - ($this.offset().left + _jscr_originalPos[currentId]) - 10;
		            }

		            if (paneWidth < settings.minimumWidth) {
		                paneWidth = settings.minimumWidth;
		            }

		            jQuery(this).parent().css(
						{
						    'height': paneHeight + 'px',
						    'width': paneWidth + 'px'
						}
					);
		        }

		        var trackWidth = paneWidth;
		        if ($c.unmousewheel) {

		            if ($.browser.opera) {
		                $c.unbind("mousewheel", fn = function () { });
		            } else {
		                $c.unmousewheel();
		            }
		        }

		        jQuery('>.jScrollPaneTrackHoz, >.jScrollArrowLeft, >.jScrollArrowRight', $c).remove();
		        $this.css({ 'left': 0 });
		        _jscr_originalPos[currentId] = -1;

		    } else {

		        $this.data('originalStyleTag', $this.attr('style'));
		        var currentScrollPosition = 0;
		        this.originalPadding = $this.css('paddingTop') + ' ' + $this.css('paddingRight') + ' ' + $this.css('paddingBottom') + ' ' + $this.css('paddingLeft');
		        this.originalSidePaddingTotal = (parseInt($this.css('paddingLeft')) || 0) + (parseInt($this.css('paddingRight')) || 0);
		        var paneWidth = $this.outerWidth();
		        var rightPos = $this.offset().left + _jscr_originalPos[currentId] + paneWidth;

		        if ((rightPos) > $(window).width()) {
		            paneWidth = $(window).width() * percentageWidth;
		        }

		        if (paneWidth < settings.minimumWidth) {
		            paneWidth = settings.minimumWidth;
		        }

		        var paneHeight = $this.innerHeight();
		        var trackWidth = paneWidth;

		        $this.wrap(
					jQuery('<div></div>').attr(
						{ 'class': 'jScrollPaneContainer' }
					).css(
						{
						    'height': paneHeight + 'px',
						    'width': paneWidth + 'px'
						}
					)
				);

		    }
		    var p = this.originalSidePaddingTotal;

		    var contentWidth = $this.outerWidth();
		    if (settings.contentWidth > $this.outerWidth()) {
		        contentWidth = settings.contentWidth;
		    }

		    var percentInView = paneWidth / contentWidth;

		    if (percentInView < 0.99) {

		        var $container = $this.parent();
		        $container.append(
					jQuery('<div></div>').attr({ 'class': 'jScrollPaneTrackHoz' }).css({ 'height': settings.scrollbarHeight + 'px' }).append(
						jQuery('<div></div>').attr({ 'class': 'jScrollPaneDragHoz' }).css({ 'height': settings.scrollbarHeight + 'px' }).append(
							jQuery('<div></div>').attr({ 'class': 'jScrollPaneDragLeft' }).css({ 'height': settings.scrollbarHeight + 'px' }),
							jQuery('<div></div>').attr({ 'class': 'jScrollPaneDragRight' }).css({ 'height': settings.scrollbarHeight + 'px' })
						)
					)
				);

		        var $track = jQuery('>.jScrollPaneTrackHoz', $container);
		        var $drag = jQuery('>.jScrollPaneTrackHoz .jScrollPaneDragHoz', $container);
		        var $pane = jQuery(this).css({ 'position': 'absolute', 'overflow': 'visible' });

		        var currentOffset;
		        var maxX;
		        var mouseWheelMultiplier;

		        // store this in a seperate variable so we can keep track more accurately than just updating the css property..
		        var dragPosition = 0;
		        var dragMiddle = percentInView * paneWidth / 2;

		        var getPos = function (event, c) {
		            var p = c == 'X' ? 'Left' : 'Bottom';
		            return event['page' + c] || (event['client' + c] + (document.documentElement['scroll' + p] || document.body['scroll' + p])) || 0;
		        };

		        var ignoreNativeDrag = function () { return false; };
		        var currentInterval = 0;
		        var direction = 1;
		        var arrowUp = false;
		        var intervalMove = false;
		        _jscr_trackInt[currentId] = -1; ;

		        var initDrag = function () {                               
		            ceaseAnimation();		      
		            currentOffset = $drag.offset(false);		           
		            currentOffset.left -= dragPosition;
		            maxX = trackWidth - $drag[0].offsetWidth;
		            mouseWheelMultiplier = 2 * settings.wheelSpeed * maxX / contentWidth;
		          
		        };


		        var onStartDrag = function (event) {
		            if (isNaN(dragPosition)) { dragPosition = 0; }
		            initDrag();
		            dragMiddle = getPos(event, 'X') - dragPosition - currentOffset.left;
		            jQuery('body').bind('mouseup', onStopDrag).bind('mousemove', updateScroll);
		            if (jQuery.browser.msie) {
		                jQuery('body').bind('dragstart', ignoreNativeDrag).bind('selectstart', ignoreNativeDrag);
		            }
		            return false;
		        };
		        var onStopDrag = function () {
		            jQuery('body').unbind('mouseup', onStopDrag).unbind('mousemove', updateScroll);
		            dragMiddle = percentInView * paneWidth / 2;
		            if (jQuery.browser.msie) {
		                jQuery('body').unbind('dragstart', ignoreNativeDrag).unbind('selectstart', ignoreNativeDrag);
		            }
		        };
		        var positionDrag = function (destX) {
		            //Figure out if we need to adjust because of intervals.
		            //evaluateIntervals(dragPosition, destX);
		            destX = destX < 0 ? 0 : (destX > maxX ? maxX : destX);
		            dragPosition = destX;

		            $drag.css({ 'left': destX + 'px' });
		            var p = destX / maxX;
		            _jscr_originalPos[currentId] = (paneWidth - contentWidth) * p * -1;
		            $pane.css({ 'left': ((paneWidth - contentWidth) * p) + 'px' });
		            $this.trigger('scroll');
		        };

		        var updateScroll = function (e) {
		            positionDrag(getPos(e, 'X') - currentOffset.left - dragMiddle);
		        };

		        var arrowSize = 0;
		        if (settings.showArrows == true) {
		            arrowSize = settings.arrowSize;
		        }

		        var dragH = Math.max(Math.min(percentInView * (paneWidth - arrowSize * 2), settings.dragMaxWidth), settings.dragMinWidth);
		        $drag.css(
					{ 'width': dragH + 'px' }
				).bind('mousedown', onStartDrag);

		        var trackScrollInterval;
		        var trackScrollInc;
		        var trackScrollMousePos;
		        var doTrackScroll = function () {
		            if (trackScrollInc > 8 || trackScrollInc % 4 == 0) {
		                positionDrag((dragPosition - ((dragPosition - trackScrollMousePos) / 2)));
		            }
		            trackScrollInc++;
		        };

		        var onStopTrackClick = function () {
		            clearInterval(trackScrollInterval);
		            jQuery('body').unbind('mouseup', onStopTrackClick).unbind('mousemove', onTrackMouseMove);
		        };
		        var onTrackMouseMove = function (event) {
		            trackScrollMousePos = getPos(event, 'X') - currentOffset.left - dragMiddle;
		        };
		        var onTrackClick = function (event) {
		            initDrag();
		            onTrackMouseMove(event);
		            trackScrollInc = 0;
		            jQuery('body').bind('mouseup', onStopTrackClick).bind('mousemove', onTrackMouseMove);
		            trackScrollInterval = setInterval(doTrackScroll, 100);
		            doTrackScroll();
		        };

		        $track.bind('mousedown', onTrackClick);

		        var _animateToPosition;
		        var _animateToInterval;
		        function animateToPosition() {

		            var diff = (_animateToPosition - dragPosition) / settings.animateStep;

		            if ((diff > 1 || diff < -1) && ((dragPosition + diff + $drag.width()) < (paneWidth))) {
		                positionDrag(dragPosition + diff);
		            } else {
		                positionDrag(_animateToPosition);
		                ceaseAnimation();
		            }
		        }
		        var ceaseAnimation = function () {
		            if (_animateToInterval) {
		                clearInterval(_animateToInterval);
		                delete _animateToPosition;
		            }
		        };
		        var scrollTo = function (pos, preventAni) {
		            if (typeof pos == "string") {
		                $e = jQuery(pos, this);

		                if (!$e.length) return;
		                pos = $e.position().left;
		            }

		            ceaseAnimation();
		            var destDragPosition = -pos / (paneWidth - contentWidth) * maxX;
		            if (!preventAni || settings.animateTo) {
		                _animateToPosition = destDragPosition;
		                _animateToInterval = setInterval(animateToPosition, settings.animateInterval);

		            } else {
		                positionDrag(destDragPosition);
		            }
		        };

		        $this[0].scrollTo = scrollTo;
		        $this[0].scrollBy = function (delta) {
		            var currentPos = -parseInt($pane.css('left')) || 0;
		            scrollTo(currentPos + delta);
		        };
                
		        initDrag();

		        scrollTo(-currentScrollPosition, true);

		        jQuery.jScrollHorizontalPane.active.push($this[0]);

		    } else {
		        var scrollTo = function (pos, preventAni) { }
		        $this[0].scrollTo = scrollTo;

		        $this.css(
					{
					    'height': paneHeight - this.originalSidePaddingTotal + 'px',
					    'width': paneWidth + 'px',
					    'padding': this.originalPadding
					}
				);
		        // remove from active list?
		    }

		}
	)
};

jQuery.fn.jScrollHorizontalPane.reset = function () {
    _jscr_originalSizes = new Array();
    _jscr_differenceSizes = new Array();
    _jscr_previousWindowSize = new Array();
    _jscr_originalPercentages = new Array();
    _jscr_trackInt = new Array();
    _jscr_originalPos = new Array();
    _jscr_globalProperties = new Array();
}

// clean up the scrollTo expandos
jQuery(window)
	.bind('unload', function () {
	    var els = jQuery.jScrollHorizontalPane.active;
	    for (var i = 0; i < els.length; i++) {
	        els[i].scrollTo = els[i].scrollBy = null;
	    }
	}
);

})(jQuery);

/***********************************
social counts
************************************/

; (function (win, doc, $) {

    var $loadingIndicator,
		$count;

    function featureTest(prop, unprefixedProp) {
        var style = doc.createElement('social').style,
			prefixes = 'webkit Moz o ms'.split(' ');

        if (unprefixedProp in style) {
            return true;
        }
        for (var j = 0, k = prefixes.length; j < k; j++) {
            if ((prefixes[j] + prop) in style) {
                return true;
            }
        }
        return false;
    }

    function removeFileName(src) {
        var split = src.split('/');
        split.pop();
        return split.join('/') + '/';
    }

    function resolveServiceDir() {
        var baseUrl;

        $('script').each(function () {
            var src = this.src || '',
				dir;
            if (src.match(SocialCount.scriptSrcRegex)) {
                baseUrl = removeFileName(src);
                return false;
            }
        });

        return baseUrl;
    }

    var SocialCount = {
        // For A-grade experience, require querySelector (IE8+) and not BlackBerry or touchscreen
        isGradeA: 'querySelectorAll' in doc && !win.blackberry && !('ontouchstart' in window) &&
			// Note that this feature test does not account for the Windows Phone version that includes IE9
			// IE 10 desktop (non-touch) returns 0 for msMaxTouchPoints
			(typeof window.navigator.msMaxTouchPoints === 'undefined' || window.navigator.msMaxTouchPoints === 0),
        minCount: 1,
        serviceUrl: 'service/index.php',
        initSelector: '.kb-socialcount',
        classes: {
            js: 'js',
            gradeA: 'grade-a',
            active: 'active',
            touch: 'touch',
            hover: 'hover',
            noTransforms: 'no-transforms',
            showCounts: 'counts',
            countContent: 'count',
            minCount: 'minimum',
            activateOnHover: 'activate-on-hover',
            activateOnClick: 'activate-on-click'
        },
        thousandCharacter: 'K',
        millionCharacter: 'M',
        missingResultText: '-',
        activateOnClick: false, // default is hover
        selectors: {
            facebook: '.facebook',
            twitter: '.twitter',
            googleplus: '.googleplus'
        },
        locale: (function () {
            var locale = doc.documentElement ? (doc.documentElement.lang || '') : '';
            locale = locale.replace(/\-/, '_');
            return locale.match(/\w{2}_\w{2}/) ? locale : '';
        })(),
        googleplusTooltip: 'table.gc-bubbleDefault',
        scriptSrcRegex: /socialcount[\w.]*.js/i,
        plugins: {
            init: [],
            bind: []
        },

        // private, but for testing
        cache: {},

        removeFileName: removeFileName,
        resolveServiceDir: resolveServiceDir,

        isCssAnimations: function () {
            return featureTest('AnimationName', 'animationName');
        },
        isCssTransforms: function () {
            return featureTest('Transform', 'transform');
        },
        getUrl: function ($el) {
            return $el.attr('data-url') || location.href;
        },
        // Currently only available on Twitter
        getShareText: function ($el) {
            return $el.attr('data-share-text') || '';
        },
        getFacebookAction: function ($el) {
            return ($el.attr('data-facebook-action') || 'like').toLowerCase();
        },
        isCountsEnabled: function ($el) {
            return $el.attr('data-counts') === 'true';
        },
        isSmallSize: function ($el) {
            return $el.is('.socialcount-small');
        },
        getCounts: function ($el, url) {
            var map = SocialCount.selectors,
				cache = SocialCount.cache,
				counts = {},
				$networkNode,
				$countNode,
				j;

            for (j in map) {
                $networkNode = $el.find(map[j]);
                $countNode = $networkNode.find('.' + SocialCount.classes.countContent);

                if ($countNode.length) {
                    counts[j] = $countNode;
                } else {
                    counts[j] = $count.clone();
                    $networkNode.append(counts[j]);
                }
            }

            if (!cache[url]) {
                cache[url] = $.ajax({
                    url: resolveServiceDir() + SocialCount.serviceUrl,
                    data: {
                        url: url
                    },
                    dataType: 'json'
                });
            }

            cache[url].done(function complete(data) {
                for (var j in data) {
                    if (data.hasOwnProperty(j)) {
                        if (counts[j] && data[j] > SocialCount.minCount) {
                            counts[j].addClass(SocialCount.classes.minCount)
								.html(SocialCount.normalizeCount(data[j]));
                        }
                    }
                }
            });

            return cache[url];
        },
        init: function ($el) {
            var facebookAction = SocialCount.getFacebookAction($el),
				classes = [facebookAction],
				isSmall = SocialCount.isSmallSize($el),
				url = SocialCount.getUrl($el),
				initPlugins = SocialCount.plugins.init,
				countsEnabled = SocialCount.isCountsEnabled($el);

            classes.push(SocialCount.classes.js);

            if (SocialCount.isGradeA) {
                classes.push(SocialCount.classes.gradeA);
            }
            if (!SocialCount.isCssTransforms()) {
                classes.push(SocialCount.classes.noTransforms);
            }
            if (countsEnabled) {
                classes.push(SocialCount.classes.showCounts);
            }
            if (SocialCount.activateOnClick) {
                classes.push(SocialCount.classes.activateOnClick);
            } else {
                classes.push(SocialCount.classes.activateOnHover);
            }
            if (SocialCount.locale) {
                classes.push(SocialCount.locale);
            }
            $el.addClass(classes.join(' '));

            for (var j = 0, k = initPlugins.length; j < k; j++) {
                initPlugins[j].call($el);
            }

            if (SocialCount.isGradeA) {
                SocialCount.bindEvents($el, url, facebookAction, isSmall);
            }

            if (countsEnabled && !isSmall) {
                SocialCount.getCounts($el, url);
            }
        },
        normalizeCount: function (count) {
            if (!count && count !== 0) {
                return SocialCount.missingResultText;
            }
            // > 1M
            if (count >= 1000000) {
                return Math.floor(count / 1000000) + SocialCount.millionCharacter;
            }
            // > 100K
            if (count >= 100000) {
                return Math.floor(count / 1000) + SocialCount.thousandCharacter;
            }
            if (count > 1000) {
                return (count / 1000).toFixed(1).replace(/\.0/, '') + SocialCount.thousandCharacter;
            }
            return count;
        },
        bindEvents: function ($el, url, facebookAction, isSmall) {
            
            function bind($a, html, jsUrl) {
                // IE bug (tested up to version 9) with :hover rules and iframes.
                var isTooltipActive = false,
					isHoverActive = false;

                $a.closest('li.counter').bind('mouseenter', function (event) {
                    var $li = $(this).closest('li');
                    $li.addClass(SocialCount.classes.hover);
                    isHoverActive = true;
                    $(document).on('mouseenter.socialcount mouseleave.socialcount', SocialCount.googleplusTooltip, function (event) {
                        isTooltipActive = event.type == 'mouseenter';
                        if (!isTooltipActive && !isHoverActive) {
                            $li.removeClass(SocialCount.classes.hover);
                        }
                    });
                }).bind('mouseleave', function (event) {
                    var self = this;
                    window.setTimeout(function () {
                        isHoverActive = false;

                        if (!isTooltipActive && !isHoverActive) {
                            $(document).off('.socialcount');
                            $(self).closest('li').removeClass(SocialCount.classes.hover);
                        }
                    }, 0);
                });

                $a.one(SocialCount.activateOnClick ? 'click' : 'mouseover', function (event) {
                    if (SocialCount.activateOnClick) {
                        event.preventDefault();
                        event.stopPropagation();
                    }

                    var $self = $(this),
						$parent = $self.closest('li'),
						$loading = $loadingIndicator.clone(),
						$content = $(html),
						$button = $('<div class="button"/>').append($content),
						js,
						$iframe,
						deferred = $.Deferred();

                    deferred.promise().always(function () {
                        // Remove Loader
                        var $iframe = $parent.find('iframe');

                        if ($iframe.length) {
                            $iframe.bind('load', function () {
                                $loading.remove();
                            });
                        } else {
                            $loading.remove();
                        }
                    });

                    $parent
						.addClass(SocialCount.classes.active)
						.append($loading)
						.append($button);

                    if (jsUrl) {
                        js = doc.createElement('script');
                        js.src = jsUrl;
                                               
                        // IE8 doesn't do script onload.
                        if (js.attachEvent) {
                            js.attachEvent('onreadystatechange', function () {
                                if (js.readyState === 'loaded' || js.readyState === 'complete') {
                                    deferred.resolve();
                                }
                            });
                        } else {
                            $(js).bind('load', deferred.resolve);
                        }

                        doc.body.appendChild(js);
                    } else if ($content.is('iframe')) {
                        deferred.resolve();
                    }
                });
            } // end bind()

            if (!isSmall) {
                           
                var shareText = SocialCount.getShareText($el);

                bind($el.find(SocialCount.selectors.facebook + ' a'),
					'<iframe src="//www.facebook.com/plugins/like.php?href=' + encodeURIComponent(url) +
						(SocialCount.locale ? '&locale=' + SocialCount.locale : '') +
						'&amp;send=false&amp;layout=button_count&amp;width=100&amp;show_faces=true&amp;action=' + facebookAction +
						'&amp;colorscheme=light&amp;font=arial&amp;height=21" scrolling="no" frameborder="0" style="border:none; overflow:hidden;" allowTransparency="true"></iframe>');

                bind($el.find(SocialCount.selectors.twitter + ' a'),
					 '<a href="https://twitter.com/share" class="twitter-share-button"' +
						' data-url="' + encodeURIComponent(url) + '"' +
						(shareText ? ' data-text="' + shareText + '"' : '') +
						' data-count="none" data-dnt="true">Tweet</a>',
					'//platform.twitter.com/widgets.js');

                bind($el.find(SocialCount.selectors.googleplus + ' a'),
					'<div class="g-plusone" data-size="medium" data-annotation="none"></div>',
					'//apis.google.com/js/plusone.js');
            }

            // Bind events on other non-stock widgets, like sharethis
            var bindPlugins = SocialCount.plugins.bind;
            for (var j = 0, k = bindPlugins.length; j < k; j++) {
                bindPlugins[j].call($el, bind, url, isSmall);
            }
        } // end bindEvents()
    };

    $(function () {
        // Thanks to http://codepen.io/ericmatthys/pen/FfcEL
        $loadingIndicator = $('<div>')
			.addClass('loading')
			.html(SocialCount.isCssAnimations() ? new Array(4).join('<div class="dot"></div>') : 'Loading');

        $count = $('<span>')
			.addClass(SocialCount.classes.countContent)
			.html('&#160;');

        $(SocialCount.initSelector).each(function () {
            var $el = $(this);
            SocialCount.init($el);
        });

        $(doc).ready(function () {
            $(SocialCount.initSelector).find("li").each(function () {
                $(this).animate({ "margin-left": 0 }, { duration: 350 });
            });
        });
    });

    window.SocialCount = SocialCount;

}(window, window.document, jQuery));

/***********************************
responsive images
************************************/

; (function (win, doc, $) {

    $(win).load(function () {
        var className = "responsive-image";
        $("img." + className).each(function () {
            var div = $('<div class="responsive-image">');
            $(this)
                .css({ "width": null, "height": null })
                .removeClass(className)
                .wrap(div);
        });

    });

}(window, window.document, jQuery));


/* shake effect */
(function () {
    jQuery.fn.shake = function (steps, duration, amount, vertical) {
        var s = steps || 3;
        var d = duration || 120;
        var a = amount || 5;
        var v = vertical || false;

        var cur = parseInt(this.css(v ? "top" : "left"), 10);
        if (isNaN(cur))
            cur = 0;

        var ds = d / s;

        if (v) {
            for (i = 0; i < s; i++)
                this.animate({ "top": cur + a + "px" }, ds).animate({ "top": cur - a + "px" }, ds);
            this.animate({ "top": cur }, 20);
        }
        else {
            for (i = 0; i < s; i++)
                this.animate({ "left": cur + a }, ds).animate({ "left": cur - a + "px" }, ds);
            this.animate({ "left": cur }, 20);
        }

        return this;
    }
})();

/***********************************
qtransform
************************************/

(function ($) {

    var div = document.createElement('div'),
      divStyle = div.style;

    //give props to those who dont have them
    $.cssProps.transform =
        divStyle.MozTransform === '' ? 'MozTransform' :
        (divStyle.msTransform === '' ? 'msTransform' :
        (divStyle.WebkitTransform === '' ? 'WebkitTransform' :
        (divStyle.OTransform === '' ? 'OTransform' :
        (divStyle.Transform === '' ? 'Transform' :
        false))));
    $.cssProps.transformOrigin =
        divStyle.MozTransformOrigin === '' ? 'MozTransformOrigin' :
        (divStyle.msTransformOrigin === '' ? 'msTransformOrigin' :
        (divStyle.WebkitTransformOrigin === '' ? 'WebkitTransformOrigin' :
        (divStyle.OTransformOrigin === '' ? 'OTransformOrigin' :
        (divStyle.TransformOrigin === '' ? 'TransformOrigin' :
        false))));

    //define supported or not
    $.support.transform = $.cssProps.transform !== false || divStyle.filter === '' ? true : false;
    $.support.transformOrigin = $.cssProps.transformOrigin !== false ? true : false;

    //if ONLY IE matrixes are supported (IE9 beta6 will use css3)
    $.support.matrixFilter = (divStyle.filter === '' && $.cssProps.transform === false) ?
        true : false;
    div = null;

    //stop if no form of transforms are supported
    if ($.support.transform === false)
        return;

    //opt out of letting jquery handle the units for custom setters/getters 
    $.cssNumber.skew =
    $.cssNumber.skewX =
    $.cssNumber.skewY =
    $.cssNumber.scale =
    $.cssNumber.scaleX =
    $.cssNumber.scaleY =
    $.cssNumber.rotate =
    $.cssNumber.matrix = true;

    $.cssNumber.transformOrigin =
    $.cssNumber.transformOriginX =
    $.cssNumber.transformOriginY = true;
    
    if ($.support.matrixFilter) {
        $.cssNumber.transformOrigin =
        $.cssNumber.transformOriginX =
        $.cssNumber.transformOriginY = true;

        $.cssProps.transformOrigin = 'matrixFilter';
    }

    $.cssHooks.transform = {
        set: function (elem, val, unit) {
            if ($.support.matrixFilter) {
                elem.style.filter = [val].join('');
            } else {
                elem.style[$.cssProps.transform] = val + '%';
            }
        },
        get: function (elem, computed) {
            if ($.support.matrixFilter) {
                return elem.style.filter;
            } else {
                return elem.style[$.cssProps.transform];
            }
        }
    };

    $.cssHooks.transformOrigin = {
        set: function (elem, val, unit) {
            if (!$.support.matrixFilter) {
                val = (typeof val === 'string') ? val : val + (unit || '%');
                elem.style[$.cssProps.transformOrigin] = val;
            } else {
                val = val.split(",");
                $.cssHooks.transformOriginX.set(elem, val[0]);
                if (val.length > 1) {
                    $.cssHooks.transformOriginY.set(elem, val[1]);
                }
            }
        },
        get: function (elem, computed) {
            if (!$.support.matrixFilter) {
                return elem.style[$.cssProps.transformOrigin];
            } else {
                var originX = $.data(elem, 'transformOriginX');
                var originY = $.data(elem, 'transformOriginY');
                return originX && originY && originX === originY ? originX : '50%';
            }
        }
    };

    $.fx.step.transformOrigin = function (fx) {
        $.cssHooks.transformOrigin.set(fx.elem, fx.now, fx.unit);
    };

    $.cssHooks.transformOriginX = {
        set: function (elem, val, unit) {
            if (!$.support.matrixFilter) {
                val = (typeof val === 'string') ? val : val + (unit || '%');
                elem.style[$.cssProps.transformOrigin + 'X'] = val;
            } else {
                $.data(elem, 'transformOriginX', unit ? val + unit : val);
                setIEMatrix(elem);
            }
        },
        get: function (elem, computed) {
            if (!$.support.matrixFilter) {
                return elem.style[$.cssProps.transformOrigin + 'X'];
            } else {
                var originX = $.data(elem, 'transformOriginX');
                switch (originX) {
                    case 'left': return '0%';
                    case 'center': return '50%';
                    case 'right': return '100%';
                }
                return originX ? originX : '50%';
            }
        }
    };

    $.fx.step.transformOriginX = function (fx) {
        $.cssHooks.transformOriginX.set(fx.elem, fx.now, fx.unit);
    };

    $.cssHooks.transformOriginY = {
        set: function (elem, val, unit) {
            if (!$.support.matrixFilter) {
                val = (typeof val === 'string') ? val : val + (unit || '%');
                elem.style[$.cssProps.transformOrigin + 'Y'] = val;
            } else {
                $.data(elem, 'transformOriginY', unit ? val + unit : val);
                setIEMatrix(elem);
            }
        },
        get: function (elem, computed) {
            if (!$.support.matrixFilter) {
                return elem.style[$.cssProps.transformOrigin + 'Y'];
            } else {
                var originY = $.data(elem, 'transformOriginY');
                switch (originY) {
                    case 'top': return '0%';
                    case 'center': return '50%';
                    case 'bottom': return '100%';
                }
                return originY ? originY : '50%';
            }
        }
    };

    $.fx.step.transformOriginY = function (fx) {
        $.cssHooks.transformOriginY.set(fx.elem, fx.now, fx.unit);
    };

    //create hooks for css transforms
    var rtn = function (v) { return v; };
    var xy = [['X', 'Y'], 'X', 'Y'];
    var abcdxy = [['A', 'B', 'C', 'D', 'X', 'Y'], 'A', 'B', 'C', 'D', 'X', 'Y']
    var props = [
        {
            prop: 'rotate',
            matrix: [function (v) { return Math.cos(v); },
                function (v) { return -Math.sin(v); },
                function (v) { return Math.sin(v); },
                function (v) { return Math.cos(v); }],
            unit: 'rad',
            subProps: [''],
            fnc: toRadian
        },
        {
            prop: 'scale',
            matrix: [[rtn, 0, 0, rtn],
                [rtn, 0, 0, 1],
                [1, 0, 0, rtn]],
            unit: '',
            subProps: xy,
            fnc: parseFloat,
            _default: 1
        },
        {
            prop: 'skew',
            matrix: [[1, rtn, rtn, 1],
                [1, rtn, 0, 1],
                [1, 0, rtn, 1]],
            unit: 'rad',
            subProps: xy,
            fnc: toRadian
        },
        {
            prop: 'translate',
            matrix: [[1, 0, 0, 1, rtn, rtn],
                [1, 0, 0, 1, rtn, 0],
                [1, 0, 0, 1, 0, rtn]],
            standardUnit: 'px',
            subProps: xy,
            fnc: parseFloat
        },
        {
            prop: 'matrix',
            matrix: [[rtn, rtn, rtn, rtn, rtn, rtn],
                [rtn, 0, 0, 1, 0, 0],
                [1, rtn, 0, 1, 0, 0],
                [1, 0, rtn, 1, 0, 0],
                [1, 0, 0, rtn, 0, 0],
                [1, 0, 0, 1, 0, rtn]],
            subProps: abcdxy,
            fnc: parseFloat
        }
    ];

    jQuery.each(props, function (n, prop) {
        jQuery.each(prop.subProps, function (num, sub) {
            var _cssProp, _prop = prop;

            if ($.isArray(sub)) {
                //composite transform
                _cssProp = _prop.prop;
                var _sub = sub;
                $.cssHooks[_cssProp] = {
                    set: function (elem, val, unit) {
                        jQuery.each(_sub, function (num, x) {
                            $.cssHooks[_cssProp + x].set(elem, val, unit);
                        });
                    },
                    get: function (elem, computed) {
                        var val = [];
                        jQuery.each(_sub, function (num, x) {
                            val.push($.cssHooks[_cssProp + x].get(elem, val));
                        });
                        //hack until jQuery supports animating multiple properties
                        return val[0] || val[1];
                    }
                }
            } else {
                //independent transfrom
                _cssProp = _prop.prop + sub;
                $.cssHooks[_cssProp] = {
                    set: function (elem, val, unit) {
                        $.data(elem, _cssProp, unit ? val + unit : val);

                        setCSSTransform(elem, _prop.fnc(unit ? val + unit : val), _cssProp,
                         _prop.unit || unit || _prop.standardUnit);
                    },
                    get: function (elem, computed) {

                        var p = $.data(elem, _cssProp);
                        //console.log(_cssProp+'get:'+p);
                        return p && p !== undefined ? p : _prop._default || 0;
                    }
                };
            }

            $.fx.step[_cssProp] = function (fx) {
                fx.unit = fx.unit === 'px' && $.cssNumber[_cssProp] ? _prop.standardUnit : fx.unit;
                var unit = ($.cssNumber[_cssProp] ? '' : fx.unit);
                $.cssHooks[_cssProp].set(fx.elem, fx.now, fx.unit);
            };
        })
    });

    function setCSSTransform(elem, val, prop, unit) {
        if ($.support.matrixFilter) {
            return setIEMatrix(elem, val);
        }

        //parse css string
        var allProps = parseCSSTransform(elem);

        //check for value to be set
        var a = /[X|Y]/.exec(prop);
        a = (a === null ? '' : a[0] ? a[0] : a);
        prop = /.*[^XY]/.exec(prop)[0];
        unit = unit === undefined ? '' : unit;

        //create return string
        var result = '';
        var wasUpdated = false;
        var arr;
        if (allProps !== null) {
            for (var item in allProps) {
                arr = allProps[item];
                if (prop === item) {
                    //update parsed data with new value
                    if (prop !== 'matrix') {
                        result += prop + '(';
                        result += a === 'X' || a === '' ? val + unit :
                            (arr[0] !== '' ? arr[0] : $.cssHooks[prop + 'X'].get(elem) + unit);
                        result += a === 'Y' ? ', ' + val + unit :
                            (arr[1] !== '' ? ', ' + arr[1] :
                            (prop + 'Y' in $.cssHooks ?
                                ', ' + $.cssHooks[prop + 'Y'].get(elem) + unit : ''));
                        result += ') ';
                    } else {
                        result += val + ' ';
                    }
                    wasUpdated = true;
                } else {
                    //dump parsed data to string
                    result += item + '(';
                    for (var i = 0; i < arr.length; i++) {
                        result += arr[i];
                        if (i < arr.length - 1 && arr[i + 1] !== '')
                            result += ', '
                        else
                            break;
                    }
                    result += ') ';
                }
            }
        }

        //if prop was not found to be updated, then dump data
        if (!wasUpdated)
            result += prop + a + '(' + val + unit + ') ';

        //set all transform properties
        elem.style[$.cssProps.transform] = result;
    }


    function parseCSSTransform(elem) {
        var props, prop, name, transform;
        //break up into single transform calls
        $(elem.style[$.cssProps.transform].replace(/(?:\,\s|\)|\()/g, "|").split(" "))
        //read each data point for the transform call
        .each(function (i, item) {
            if (item !== '') {
                if (props === undefined) props = {}
                prop = item.split("|");
                name = prop.shift();
                transform = /.*[^XY]/.exec(name)[0];
                if (!props[transform]) props[transform] = ['', '', '', '', '', ''];
                if (!/Y/.test(name)) props[transform][0] = prop[0];
                if (!/X/.test(name)) props[transform][1] = prop[1];
                if (prop.length == 6) {
                    props[transform][2] = prop[2];
                    props[transform][3] = prop[3];
                    props[transform][4] = prop[4];
                    props[transform][5] = prop[5];
                }
            }
        });

        return props !== undefined ? props : null;
    }

    function ieOrigin(o, n, percent) {
        return percent * (o - n);
    }

    function toRadian(value) {
        if (typeof value === 'number') {
            return parseFloat(value);
        }
        if (value.indexOf("deg") != -1) {
            return parseInt(value, 10) * (Math.PI * 2 / 360);
        } else if (value.indexOf("grad") != -1) {
            return parseInt(value, 10) * (Math.PI / 200);
        }
    }

    $.rotate = {
        radToDeg: function radToDeg(rad) {
            return rad * 180 / Math.PI;
        }
    };

    //special case for IE matrix
    function setIEMatrix(elem, mat) {
        var inverse, current, ang, org, originX, originY,
        runTransform = $.cssProps.transformOrigin === 'matrixFilter' ? true : false;

        current = [$.cssHooks.scaleX.get(elem),
                    toRadian($.cssHooks.skewY.get(elem)),
                    toRadian($.cssHooks.skewX.get(elem)),
                    $.cssHooks.scaleY.get(elem),
                    $.cssHooks.translateX.get(elem),
                    $.cssHooks.translateY.get(elem)];

        //start by multiply inverse of transform origin by matrix
        if (runTransform) {
            elem.style.filter = [
                "progid:DXImageTransform.Microsoft.Matrix"
                + "(M11=1,M12=0,M21=0,M22=1,SizingMethod='auto expand')"
            ].join('');
            var Wp = $.cssHooks.transformOriginX.get(elem);
            var Hp = $.cssHooks.transformOriginY.get(elem);
            Wp = Wp.indexOf('%') > 0 ?
                (/[\d]*/.exec(Wp) / 100) : Wp;
            Hp = Hp.indexOf('%') > 0 ?
                (/[\d]*/.exec(Hp) / 100) : Hp;

            var Wb = elem.offsetWidth;
            var Hb = elem.offsetHeight;
        }

        //multiply old matrix to new matrix
        if (typeof mat !== 'array' || mat.length !== 6) {
            mat = current;
        } else {
            mat = [((current[0] * mat[0]) + (current[1] * mat[2])),
                    ((current[0] * mat[1]) + (current[1] * mat[3])),
                    ((current[2] * mat[0]) + (current[3] * mat[2])),
                    ((current[2] * mat[1]) + (current[3] * mat[3])),
                    mat[4],
                    mat[5]
            ];
        }

        //multiply the transform and rotation matrixes
        ang = $.data(elem, 'rotate');
        if (ang) {
            ang = toRadian(ang);
            var cos = Math.cos(ang);
            var sin = Math.sin(ang);

            ang = [cos, -sin, sin, cos];
            mat = [((mat[0] * ang[0]) + (mat[1] * ang[2])),
                    ((mat[0] * ang[1]) + (mat[1] * ang[3])),
                    ((mat[2] * ang[0]) + (mat[3] * ang[2])),
                    ((mat[2] * ang[1]) + (mat[3] * ang[3])),
                    mat[4],
                    mat[5]
            ];
        }

        //apply the matrix as a IE filter
        elem.style.filter = [
            "progid:DXImageTransform.Microsoft.Matrix(",
            "M11=" + mat[0] + ", ",
            "M12=" + mat[1] + ", ",
            "M21=" + mat[2] + ", ",
            "M22=" + mat[3] + ", ",
            "SizingMethod='auto expand'",
            ")"
        ].join('');

        if (runTransform) {
            var Wo = elem.offsetWidth;
            var Ho = elem.offsetHeight;
            elem.style.position = 'relative';
            elem.style.left = Wp * (Wb - Wo) + (parseInt(mat[4]) || 0);
            elem.style.top = Hp * (Hb - Ho) + (parseInt(mat[5]) || 0);
        }
        //$('#console').append('<div> trans:'+Wp+":"+Wb+":"+Wo+":"+mat[4]+":"+elem.style.left+'</div>');


    }

})(jQuery);

