
var instantaspDragDropSession=null;

function InstantASPDragDropAction() {}

InstantASPDragDropAction.INSERT="I";
InstantASPDragDropAction.APPEND="A";

function InstantASPDragDropSession(sObj, sDt) {
 this.srcObj=sObj;
 this.srcData=sDt;
 this.destObj=null;
 this.destData=null;
 this.action=null;
 this.consume = function () {this.srcObj=null; this.srcData=null; this.destObj=null; this.destData=null; this.action=null;}
}

function InstantASPTreeDragDrop(treeId) {
 this.tId = treeId;
 this.tree = instantaspTree[treeId];
 this.tree.treeOnMouseUp = ddMouseUp;
 this.tree.treeOnMouseDown = ddMouseDown;
 this.tree.ddHandler=this;
 this.startDrag=startDrag;
 this.endDrag=endDrag;
 this.onNodeDrag=onNodeDrag;
 this.onNodeDrop=onNodeDrop;
 return this;
}

function onNodeDrag(e) {
 if (e.shiftKey) {
  instantaspDragDropSession.action=InstantASPDragDropAction.INSERT;
 } else {
  instantaspDragDropSession.action=InstantASPDragDropAction.APPEND;
 }
}

function onNodeDrop(e) {
 if (!instantaspDragDropSession) {return;}
 if(!instantaspDragDropSession.action) {return;}
 if (instantaspDragDropSession.srcObj.tId==instantaspDragDropSession.destObj.tId) { 
  switch (instantaspDragDropSession.action) {
   case InstantASPDragDropAction.INSERT:
    this.tree.moveChild(instantaspDragDropSession.srcData, instantaspDragDropSession.destData, 2);
    break;
   case InstantASPDragDropAction.APPEND: 
    this.tree.moveChild(instantaspDragDropSession.srcData, instantaspDragDropSession.destData, 1);
    break;
  }
 } else { 
  switch (instantaspDragDropSession.action) {
   case InstantASPDragDropAction.INSERT:
    with (instantaspDragDropSession.srcData) { 
     var nNd = instantaspDragDropSession.destObj.addBefore(null, instantaspDragDropSession.destData.NodeID, Text, NavigateURL, (Icon?Icon.join(","):Icon), Expanded, Checked, CallBackURL); 
     if (FirstChild) duplicateNode(FirstChild, nNd);
    } 
    instantaspDragDropSession.destObj.reloadNode(instantaspDragDropSession.destData.ParentNode.NodeID);
    break;
   case InstantASPDragDropAction.APPEND: 
    with (instantaspDragDropSession.srcData) { 
     var nNd = instantaspDragDropSession.destObj.append(null, instantaspDragDropSession.destData.NodeID, Text, NavigateURL, (Icon?Icon.join(","):Icon), Expanded, Checked, CallBackURL); 
     if (FirstChild) { 
      duplicateNode(FirstChild, nNd); 
      instantaspDragDropSession.destObj.reloadNode(nNd.NodeID); 
     }
    } 
    instantaspDragDropSession.destObj.expandNode(instantaspDragDropSession.destData.NodeID);
    break;
  }
 }
}

function duplicateNode(n, newNd) {
 do {
  var cN=instantaspDragDropSession.destObj.add(null, newNd.NodeID, n.Text, n.NavigateURL,  (n.Icon?n.Icon.join(","):n.Icon), n.Expanded, n.Checked, n.CallBackURL);
  if (n.FirstChild) { duplicateNode(n.FirstChild, cN); }
  n=n.NextNode;
 } 
 while (n);
}

function startDrag(e) {
 var g=InstantASP_FindControl("ddGesture");
 var scrOffX = window.scrollX?window.scrollX:document.body.scrollLeft; 
 var scrOffY = window.scrollY?window.scrollY:document.body.scrollTop; 
 g.style.left=e.clientX+scrOffX+5+"px";
 g.style.top=e.clientY+scrOffY+5+"px";
 g.style.zIndex=1;
 if (g.style.display=="none") {
  var imgEl=InstantASP_FindControl("ic_"+instantaspDragDropSession.srcData.ID);
  g.innerHTML="<table cellpadding=0 cellspacing=0><td><img src=\""+imgEl.src+"\"></td><td><a class=\"node\">"+instantaspDragDropSession.srcData.Text+"</a></td></table>";
  g.style.display="";
 }
 this.onNodeDrag(e);
}

function endDrag(e) { 
 var g = InstantASP_FindControl("ddGesture");
 g.innerHTML = "";
 g.style.display = "none";
 document.onmousemove = null;
 document.onmouseup = null;
 document.onmousedown = function() { return true;};
 document.onselectstart = function() { return true;};
 document.onselectstart = function() { return true;};
 this.onNodeDrop(e);
}

InstantASPTree.prototype.ddHandler=null;

InstantASPTree.prototype.unloadChild = function(src) {
 var pr = src.ParentNode;
 if (pr.LastChild.equals(src)) pr.LastChild=src.PrevNode; 
 if (pr.FirstChild.equals(src)) pr.FirstChild=src.NextNode;
 if (src.PrevNode!=null) src.PrevNode.NextNode=src.NextNode; 
 if (src.NextNode!=null) src.NextNode.PrevNode=src.PrevNode; src.NextNode=null; src.PrevNode=null; src.ParentNode=null;
 if (this.SelectedNode) { 
  var tmp=this.SelectedNode; 
  while(tmp) { 
   if (tmp.equals(src)) {this.SelectedNode=null; return;} 
   tmp=tmp.ParentNode; 
  }
 }
};

InstantASPTree.prototype.moveChild = function (src, dest, type) {
 if (!src || !dest) {return;}
 if (src.equals(dest)) {return;}
 var tmp=dest;
 while(tmp.ParentNode) { 
  if (tmp.equals(src)) {return;} 
  tmp = tmp.ParentNode; 
 }
 switch (type) {
  case 1:
	   if (src.equals(this.RootNode)) {return;}
	   if (src.ParentNode.equals(dest)) {return;}
	   var srcPr=src.ParentNode;      
	   this.unloadChild(src);
	   this.reloadNode(srcPr.NodeID);
	   src.ParentNode=dest;
	   if (dest.LastChild==null) {
		dest.FirstChild=src;
		dest.LastChild=src;
	   } else {
		var t=dest.FirstChild;
		if (this.Options.Sort!="no") { 
		 do { if (this.Options.Sort=="asc" ? this.compareNode(t, src) : this.compareNode(src, t)) break; t = t.NextNode;} 
		 while (t!=null); {
		  if (t!=null) { if (t.PrevNode==null) { t.PrevNode=src; dest.FirstChild=src; } 
		  else { src.PrevNode=t.PrevNode; t.PrevNode.NextNode=src; t.PrevNode=src; } src.NextNode=t; }
		 }
		}
		if (this.Options.Sort=="no" || t==null) { 
		 src.PrevNode = dest.LastChild; 
		 dest.LastChild.NextNode = src; 
		 dest.LastChild = src; 
		}
	   }
	   this.reloadNode(dest.NodeID);
	   this.expandNode(dest.NodeID);
	   break;
  case 2: 
	   if (dest.equals(this.RootNode)) {return;}
	   if (src.NextNode && dest.equals(src.NextNode)) {return;}
	   var srcPr=src.ParentNode;
	   this.unloadChild(src);
	   this.reloadNode(srcPr.NodeID);
	   src.ParentNode=dest.ParentNode;
	   if (dest.PrevNode==null) {dest.PrevNode=src; dest.ParentNode.FirstChild=src;} 
	   else {src.PrevNode=dest.PrevNode; dest.PrevNode.NextNode=src; dest.PrevNode=src;} 
	   src.NextNode=dest;
	   this.reloadNode(dest.ParentNode.NodeID);
	   break;
  case 3: 
	   if (dest.equals(this.RootNode)) return;
	   if (src.PrevNode && dest.equals(src.PrevNode)) return;
	   var srcPr=src.ParentNode;
	   this.unloadChild(src);
	   this.reloadNode(srcPr.NodeID);
	   src.ParentNode=dest.ParentNode;
	   if (dest.NextNode==null) { dest.NextNode=src; dest.ParentNode.LastChild=src; } 
	   else { src.NextNode=dest.NextNode; dest.NextNode.PrevNode=src; dest.NextNode=src; } 
	   src.PrevNode=dest;
	   this.reloadNode(dest.ParentNode.NodeID);
	   break;
  }
};

function ddMouseUp(e) {
 var ndId=(e.srcElement?e.srcElement.id:e.target.id).split("_")[1];
 var nd = this.NodeList[ndId];
 if (!instantaspDragDropSession) return false;instantaspDragDropSession.destObj=this;instantaspDragDropSession.destData=nd;
 this.ddHandler.endDrag(e);instantaspDragDropSession=null;
}

function ddMouseDown(e) {
 var ddHd = this.ddHandler;
 var ndId = (e.srcElement?e.srcElement.id:e.target.id).split("_")[1];
 var nd = this.NodeList[ndId];
 instantaspDragDropSession=new InstantASPDragDropSession(this, nd);
 document.onmousemove=function(ev) {ddHd.startDrag((ev?ev:event));};
 document.onmouseup=function(ev) {instantaspDragDropSession.action=null;ddHd.endDrag((ev?ev:event));};
 document.onselectstart=function() { return false;};
 document.onmousedown=function() { return false;};
 document.ondragstart=function() { return false;};
}
