/*======================================================================/*
// InstantForum.NET	 InstantASP Limited.							//
// http://www.instantasp.co.uk/											//
\*======================================================================*/

/* ----------------------------------------------------------- */
// Browser Sniff
/* ----------------------------------------------------------- */

var InstantASP_UserAgent = navigator.userAgent.toLowerCase();
var InstantASP_BrowserVer = navigator.appVersion
var InstantASP_Opera = (InstantASP_UserAgent.indexOf('opera')!=-1); 
var InstantASP_Opera8 = ((InstantASP_UserAgent.indexOf('opera 8')!=-1||InstantASP_UserAgent.indexOf('opera/8')!=-1)?1:0); 
var InstantASP_NS4 = (document.layers)?true:false; 
var InstantASP_IE4 = (document.all && !document.getElementById)?true:false;
var InstantASP_IE5 = (document.all && document.getElementById)?true:false;
var InstantASP_IsIE = (InstantASP_IE4 || InstantASP_IE5)?true:false;
var InstantASP_NS6 = (!document.all && document.getElementById)?true:false;
var InstantASP_FireFox = (InstantASP_UserAgent.indexOf("firefox/")!=-1);
var InstantASP_Chrome = (InstantASP_UserAgent.indexOf("chrome/")!=-1);

/* ----------------------------------------------------------- */
// Get a reference to an object on the client                   
/* ----------------------------------------------------------- */

function InstantASP_FindControl(strControlName) {
	var objReturn = '';
		if (InstantASP_IE5 || InstantASP_NS6 || InstantASP_Opera || InstantASP_Opera8)
		{objReturn = document.getElementById(strControlName);}
		else if (InstantASP_IE4) {objReturn = document.all[strControlName];}
		else if (InstantASP_NS4) {objReturn = document.layers[strControlName];}
	return objReturn;
}

/* ----------------------------------------------------------- */
// XmlHttpRequest    
/* ----------------------------------------------------------- */

function InstantASP_XmlHttpRequest()    {
  var XmlHttp, bComplete = false;
  try { XmlHttp = new ActiveXObject("Msxml2.XMLHTTP"); }
  catch (e) { try { XmlHttp = new ActiveXObject("Microsoft.XMLHTTP"); }
  catch (e) { try { XmlHttp = new XMLHttpRequest(); }
  catch (e) { XmlHttp = false; }}}
  if (!XmlHttp) return null;

  this.Connect = function(sURL, sMethod, sVars, oEvent) { 
    if (!XmlHttp) return false;
    bComplete = false;
    sMethod = sMethod.toUpperCase();

    try {
      if (sMethod == "GET") { 
	    XmlHttp.open(sMethod, sURL+"?"+sVars, true);
        sVars = "";
      } else {
        XmlHttp.open(sMethod, sURL, true);
        XmlHttp.setRequestHeader("Method", "POST "+sURL+" HTTP/1.1");
        XmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
      }
      XmlHttp.onreadystatechange = function() {
        if (XmlHttp.readyState == 4 && XmlHttp.status == 200 && !bComplete) {
          bComplete = true; oEvent(XmlHttp);
        }
	  };
      XmlHttp.send(sVars);
    } catch(e) {return false;}
    return true;
  };
  return this;
}

// Retrieve text of an XML document element, including elements using namespaces

function InstantASP_GetElementTextNS(prefix, local, parentElem, index) {
    var result = "";
    if (prefix && InstantASP_IE4||InstantASP_IE5) {
        result = parentElem.getElementsByTagName(prefix + ":" + local)[index];
    } else {
        result = parentElem.getElementsByTagName(local)[index];
    }

    if (result) {
        if (result.childNodes.length > 1) {
            return result.childNodes[1].nodeValue;
        } else {
            return result.firstChild.nodeValue;    		
        }
    } else {
        return "";
    }
}

// encode a string for including within a URL      

function InstantASP_EncodeString(strInput) {
	if (!strInput) {return '';}
	strInput = strInput.replace(/^\s*/, ' ');
	strInput = strInput.replace(/\s+/, ' ');
	strInput = strInput.replace(/\+/g, '%2B');
	strInput = strInput.replace(/\"/g,'%22')
	strInput = strInput.replace(/\'/g, '\'')	
	return encodeURI(strInput);
}

/* ----------------------------------------------------------- */
// PanelBar Control
/* ----------------------------------------------------------- */

// expand / collapse a single panel bar

var iasp_transition = null;

function InstantASP_PanelBarToggle(strTrId, strImgId, strTrFooterId, strSkin, strCkiePrefix, strCkieName, bolState, strExImg, strColImg, strGroupName) {
     
	objContent = InstantASP_FindControl(strTrId);
	objImage = InstantASP_FindControl(strImgId);

    if (iasp_transition == null) {
        iasp_transition = new InstantASPTransition;
        iasp_transition.UseFade = false;
        iasp_transition.ExpandTransition = -1;
        iasp_transition.CollapseTransition = -1;
    }
		 
		 
	if (objContent.style.display == "none") { // expand
	
		// should we collpase the rest of the group
		if (strGroupName != "") {
           InstantASP_PanelBarGroupToggle(strGroupName, strCkiePrefix, strCkieName, 0, strSkin);
        }
		
		// display controls
		if (objImage != null) {objImage.src = strSkin + strColImg;}	
					
        if (iasp_transition!=null) {
            objContent.style.height = '';
            iasp_transition.ExpandDiv(objContent);
            
        } else {
           objContent.style.display = "block";
		}

		// update cookie
		if (bolState) {InstantASP_UpdateCookie(strTrId, false, strCkiePrefix + strCkieName);} 
		else {InstantASP_UpdateCookie(strTrId, true, strCkiePrefix + strCkieName);}
		
	} else { // collapse
	
		// hide controls
		if (objImage != null) {objImage.src = strSkin + strExImg;}	

        if (iasp_transition!=null) {
            objContent.style.height = '';
            iasp_transition.CollapseDiv(objContent);
            
        } else {
            if (objContent != null) {objContent.style.display = "none";}
        }


		// update cookie
		if (bolState) {InstantASP_UpdateCookie(strTrId, true, strCkiePrefix + strCkieName);}
		else {InstantASP_UpdateCookie(strTrId, false, strCkiePrefix + strCkieName);}
		
	}
}


// expand / collapse a group of panel bars

function InstantASP_PanelBarGroupToggle(strGroupName, strCkiePrefix, strCkieName, bolState, strSkin, strExImg, strColImg) {

	if (InstantASP_IsIE || InstantASP_Opera || InstantASP_NS6)	{
	
		    if (iasp_transition == null) {
            iasp_transition = new InstantASPTransition;
            iasp_transition.UseFade = false;
            iasp_transition.ExpandTransition = -1;
            iasp_transition.CollapseTransition = -1;
        }
    
   
		// toggle all divs matching object name
		tr = document.getElementsByTagName("DIV");
		for (var i = 0; i < tr.length; i++) { 
		    if (tr[i].id.indexOf(strGroupName) >= 0) {
			    if (bolState) {

                    if (iasp_transition!=null) {
                         tr[i].style.height = '';
                        iasp_transition.ExpandDiv(tr[i]);
                    } else {
                        tr[i].style.display = "block";
                    }

    			    if (strCkieName != "") {
			            InstantASP_UpdateCookie(tr[i].id, true, strCkiePrefix + strCkieName);
			        }
    			    
                } else {

                    tr[i].style.display = "none"; 

    			     if (strCkieName != "") {
		                InstantASP_UpdateCookie(tr[i].id, false, strCkiePrefix + strCkieName);
    		        }
		        }
    		
		    }
		}
	
		// change all images matching object name
		input = document.getElementsByTagName("img");
		for (var i = 0; i < input.length; i++) { 
			if (input[i].id.indexOf(strGroupName) >= 0) {
				if (bolState) 
					{input[i].src = strSkin + "Images/Misc_Collapse.gif";}
					else
					{input[i].src = strSkin + "Images/Misc_Expand.gif";}
			}
		}
	}
}


/* ----------------------------------------------------------- */
// Simple Menu Control
/* ----------------------------------------------------------- */

var InstantASP_MenusActive = false; // determines if a menu is active
var InstantASP_MenuItems = new Array(); // holds a collection of current active menus
var InstantASP_MenuLeft = 0;
var InstantASP_MenuRight = 0;
var InstantASP_MenuTop = 0;
var InstantASP_MenuBottom = 0;
 var currentSize = null;
 
// Set-up event handlers					   
if (InstantASP_IE4 || InstantASP_IE5 || InstantASP_Opera) {
	document.onclick = InstantASP_HideAllMenusOnClick;
	document.onscroll = InstantASP_HideAllMenusOnClick;
	window.onload = InstantASP_TrackResize; // manually track windows.resize to accomodate for IE bug
}    
else if (InstantASP_NS6) { 
	document.addEventListener("mousedown", InstantASP_HideAllMenusOnClick, true);
	window.addEventListener("resize", InstantASP_HideAllMenus, false);
} 
else if (InstantASP_NS4) {
	document.onmousedown = InstantASP_HideAllMenusOnClick;
	window.captureEvents(Event.MOUSEMOVE);
}

// code to resolve resize event fire bug when using .appendChild within IE
// why? Because the <body> element was resized to accomodate the newly added <div> (menu) tag, and 
// IE fails to make any distinction between the window (or viewport) and the <body> element resizing
function InstantASP_Resized()   {
    currentSize = InstantASP_GetViewPortSize();
    if (currentSize[0] != g_prevSize[0] || currentSize[1] != g_prevSize[1]) {
         g_prevSize = currentSize;
         InstantASP_HideAllMenus();
    }
}

// track page resizing
function InstantASP_TrackResize()
{  
    window.g_prevSize = InstantASP_GetViewPortSize();
    setInterval(InstantASP_Resized, 25);
}

// Open Menu on MouseOver Event
function iasp_OpnMnuMouseOver(Caller, InnerHTML, Width, height) {
	if (InstantASP_MenusActive) {iasp_OpnMnu(Caller, InnerHTML, Width, height);}	
}

// Open Menu on MouseClick Event
function iasp_OpnMnu(Caller, displayID, Width, Height) {
    
    var mnuDivID = Caller.id + "_smMenu";
	
	// determine if we can create elements dynamically
	if (!document.createElement) {return false;}
	
	// check to see if item is already within active menu array if so just quit and return false
	for (count = 0; count < InstantASP_MenuItems.length; count++)	{
		if (InstantASP_MenuItems[count] == mnuDivID) {
			return false;
		}
	}
	
	// hide any menus that maybe open
	InstantASP_HideAllMenus();
	InstantASP_MenuItems[InstantASP_MenuItems.length] = mnuDivID;
	InstantASP_MenusActive = true;
	
	// create the div layer container for this menu
	InstantASP_CreateLayer(displayID, mnuDivID, Width, Height);
        
    // get object references to div layer and div_layer that called this function
	var div_layer = InstantASP_FindControl(mnuDivID);
	    
        // set default offset for div layer from the caller div
    var offsetTopDefault = Caller.offsetHeight + 4;
    	             	
	// position div layer relative to the opening link  
	var intTop = InstantASP_GetOffsetTop(Caller) + offsetTopDefault;
	var intLeft = InstantASP_GetOffsetLeft(Caller); 	

  	// set position of controls
    div_layer.style.top = intTop + "px";
    div_layer.style.left = intLeft + "px";
     	   
    //  calculate left and top positions of current div layer
    if (InstantASP_IE4 || InstantASP_IE5 || InstantASP_Opera) { 
 		InstantASP_MenuLeft = div_layer.style.posLeft;
		InstantASP_MenuTop = div_layer.style.posTop - offsetTopDefault; 
	} else if (InstantASP_NS6) {
		InstantASP_MenuLeft = InstantASP_StyleWidthToInt(div_layer.style.left);
		InstantASP_MenuTop = InstantASP_StyleWidthToInt(div_layer.style.top);
	}
	
	// calculate right and bottom positions of current div layer
	InstantASP_MenuRight = parseInt(InstantASP_MenuLeft) + parseInt(mnu_extent.x);			
	InstantASP_MenuBottom = parseInt(InstantASP_MenuTop) + parseInt(mnu_extent.y);
		
	// attempt to keep menu on screen			
	if (InstantASP_IE4 || InstantASP_IE5 || InstantASP_Opera || InstantASP_NS6) { 	
 		win_width = document.body.clientWidth;
		if (InstantASP_MenuRight > win_width) {
			div_layer.style.left = win_width - parseInt(mnu_extent.x) - 12 + "px";
		}
		
		win_height = document.body.clientHeight;
		if (win_height > 0) {		
		    if ((InstantASP_MenuTop + parseInt(mnu_extent.y)) > win_height) {
			    div_layer.style.top = win_height - (parseInt(mnu_extent.y) - 12) + "px";
		    }
		}
		
	}
	
			
    // show menu	 
	 div_layer.style.display = '';	 

		
}

// Create div to hold menu
function InstantASP_CreateLayer(displayID, DivLayer, mnu_width, mnu_height) {     

    // get dic to display from client
    var displayDiv = InstantASP_FindControl(displayID);
    
	// create div layer container to holder table
    var elemDiv = document.createElement('span');     	
    elemDiv.id = DivLayer;
    elemDiv.style.position = 'absolute';
    elemDiv.style.top = '-1000px'; /* tweak for opera */
    elemDiv.style.left = '-1000px'; /* tweak for opera */       
    elemDiv.style.overflow = 'hidden';    
    elemDiv.style.zindex = 10;
	elemDiv.style.width = mnu_width;	
	elemDiv.className = "sm_Container"

	if (displayDiv != null) {
	
	    if (displayDiv.className != null && displayDiv.className != "") {
	        elemDiv.className = displayDiv.className;
	    }
	
	    elemDiv.appendChild(displayDiv);
	    elemDiv.innerHTML = displayDiv.innerHTML;
	}else {
	    elemDiv.innerHTML = "No client side div menu found!";
	}
	
	if (InstantASP_IE5) {
        elemDiv.style.filter = 'progid:DXImageTransform.Microsoft.Shadow(color="#888888", Direction=120, Strength=3) alpha(Opacity=100)';
    }
	
	// add elements to document
	document.body.appendChild(elemDiv); 
	
	// get height now content has been added
	var height;	
	if ((InstantASP_IE4 || InstantASP_IE5) || InstantASP_NS6)
		{height = elemDiv.offsetHeight;}
	else if (InstantASP_NS4)	
		{height = elemDiv.clip.height;}
			
    // contents exceed height setup overflow
	if (mnu_height != "") {
	    mnu_height =  InstantASP_StyleWidthToInt(mnu_height)
	    if (height > mnu_height) {
	        elemDiv.style.height = mnu_height + "px";
	        elemDiv.style.overflowX = 'hidden';
	        elemDiv.style.overflowY = 'scroll';
	        height = mnu_height
	    }
	 }
	
	mnu_extent = {
		x : mnu_width,
		y : height
	};
	
		
}

// Hide all menus on click event of document
function InstantASP_HideAllMenusOnClick(event) {

    // hide any possible tooltip
    iasp_hideToolTip();
    // are menus active
	if (InstantASP_MenusActive) {
		// find the element that was clicked
		if (InstantASP_IE4 || InstantASP_IE5 || InstantASP_Opera) {
		    el = window.event.srcElement;
		
		}
		else {
            // resolve issue with links not working in FF
		    if (event.target != null) {
		        if (event.target.tagName.toLowerCase() == "a") {return;}
		    }
		    if (event.target.parentNode != null) {
		        if (event.target.parentNode.tagName.toLowerCase() == "a") {return;}
 		    }		    
			el = (event.target.tagName ? event.target : event.target.parentNode);
		}

		// did we find a parent div layer
		var container = InstantASP_GetContainer(el, "SPAN")

		if (container != null) {
			if (container.id.indexOf("_smMenu") == -1) {
				    // hide all menus
				InstantASP_HideAllMenus();
			}	
		} else {
			// hide all menus
			InstantASP_HideAllMenus();
		}
	}
}

// Hide all active menus 

function InstantASP_HideAllMenus() {
    // hide any possible simply meny control
	if (InstantASP_MenusActive) {	
		for (count = 0; count < InstantASP_MenuItems.length; count++)	{
			var div_layer = InstantASP_FindControl(InstantASP_MenuItems[count]);
			if (div_layer != null)	{
				div_layer.style.display = 'none';
				InstantASP_MenuItems[count] = '';
				InstantASP_MenusActive = false;
			}
		}			
	}
}


/* ----------------------------------------------------------- */
// LinkBar Control
/* ----------------------------------------------------------- */

// toggle link bar tab

function InstantASP_LinkBarToggle(nodeID, clientID,  csstd, csstdsel, csstdchild, csstabline, csstabhl, csstablinesel) {

	// unique node id
	var uniqueid = nodeID + clientID;
	
	// get menu objects
	var lbtdchild = InstantASP_FindControl("lbtdchild_" + clientID);
	var lbchildmenulayer = InstantASP_FindControl("lbchildmenulayer_" + uniqueid);
	
	// reset styles
	InstantASP_LinkBarReset(clientID, csstd, csstdchild, csstabline, csstabhl);
	
	// update styles
	InstantASP_SwitchClass("lbtd_" + uniqueid, csstdsel);
	InstantASP_SwitchClass("lbtdchild_" + clientID, csstdchild);
	InstantASP_SwitchClass("lbtd1_" + uniqueid, csstabline);
	InstantASP_SwitchClass("lbtd2_" + uniqueid, csstabhl);
	InstantASP_SwitchClass("lbtd3_" + uniqueid, csstablinesel);	
	InstantASP_SwitchClass("lbhtd1_" + uniqueid, csstabhl);
	InstantASP_SwitchClass("lbhtd2_" + uniqueid, csstabhl);
	InstantASP_SwitchClass("lbhtd3_" + uniqueid, csstablinesel);	
	
	// populate host with menu
	if (lbchildmenulayer != null) {
	    lbtdchild.innerHTML = lbchildmenulayer.innerHTML;
	}
		
}

// reset link bar tabs

function InstantASP_LinkBarReset(clientID, csstd, csstdchild, csstabline, csstabhl) {
	for (i = 1; i <= 10; i++)	{
		var uniqueid = i + clientID
		InstantASP_SwitchClass("lbtd_" + uniqueid, csstd);
		InstantASP_SwitchClass("lbtdchild_" + clientID, csstdchild);	
		InstantASP_SwitchClass("lbtd1_" + uniqueid, csstabline);
		InstantASP_SwitchClass("lbtd2_" + uniqueid, csstabline);	
		InstantASP_SwitchClass("lbtd3_" + uniqueid, csstabline);
		InstantASP_SwitchClass("lbhtd1_" + uniqueid, csstabhl);
		InstantASP_SwitchClass("lbhtd2_" + uniqueid, csstabhl);	
		InstantASP_SwitchClass("lbhtd3_" + uniqueid, csstabhl);
	}
}

/* ----------------------------------------------------------- */
// Helpers
/* ----------------------------------------------------------- */

// Open a new window

function InstantASP_OpenWindow(Url, Width, Height, Scroll, ToolBar, Location, Status, MenuBar, Resizeable, Unique) {	
	var String;
	var winName = Width.toString() + Height.toString()
   	String =  "toolbar=" + ToolBar + ",location=" + Location 
   	String += ", directories=0,status=" + Status + ",menubar=" + MenuBar + ","
	String += "scrollbars=" + Scroll + ",resizable=" + Resizeable + ",copyhistory=0,";
   	String += ",width=";
   	String += Width;
   	String += ",height=";
   	String += Height;
   	
   	// should we center popup window
   	if (InstantASP_IE4 || InstantASP_IE5 || InstantASP_Opera || InstantASP_NS6)	{
	WndTop  = (screen.height - Height) / 2;
	WndLeft = (screen.width  - Width)  / 2;
	String += ",top=";
   	String += WndTop;
   	String += ",left=";
   	String += WndLeft;}
   	
   	// should we display single popup or allow multiple
   	try {
   		if (Unique == true) {WinPic = window.open(Url,WinNum++,String);}
   		else {WinPic = window.open(Url,winName,String);WinPic.focus();}}
   	catch (e) {};
}

// Hrrm cookies

function InstantASP_UpdateCookie(objName, bolSave, strCookieName) { 
	var ckColl = InstantASP_GetCookie(strCookieName);
	var arrLocTemp = new Array();
	if (ckColl != null) { 
		arrColl = ckColl.split(",");
		for (i in arrColl) { 
			if (arrColl[i] != objName && arrColl[i] != "") {arrLocTemp[arrLocTemp.length] = arrColl[i];}
		}
	}
	if (bolSave) {arrLocTemp[arrLocTemp.length] = objName;}
	InstantASP_SetCookie(strCookieName, arrLocTemp.join(","));
}

function InstantASP_SetCookie(name, value) { 
	expire = "expires=Wed, 1 Jan 2020 00:00:00 GMT;";
	document.cookie = name + "=" + value + "; path=/;" + expire;
}

function InstantASP_GetCookie(name) { 
	ckName = name + "=";ckPos  = document.cookie.indexOf(ckName);
	if (ckPos != -1) {
		ckStart = ckPos + ckName.length;
		ckEnd = document.cookie.indexOf(";", ckStart);
		if (ckEnd == -1) {ckEnd = document.cookie.length;}
		return unescape(document.cookie.substring(ckStart, ckEnd));
	} 
	return null;
}

// Misc

function InstantASP_SwitchClass(objectname, classname)
{
	var obj = InstantASP_FindControl(objectname);
	if (obj) {obj.className = classname;}
}


// Get top offset for object

function InstantASP_GetOffsetTop(objControl) {


	var top = objControl.offsetTop;
	var parent = objControl.offsetParent;
	while (parent != document.form) {
	top += parent.offsetTop;
	parent = parent.offsetParent;}
	return top;

	
}

// Get left offset for object

function InstantASP_GetOffsetLeft(objControl) {

	var left = objControl.offsetLeft;
	var parent = objControl.offsetParent;
	while (parent != document.form) {
	left += parent.offsetLeft;
	parent = parent.offsetParent;}
	return left;
	
}

// Get the height of an object.

function InstantASP_GetObjHeight(obj) {
	var height = 0; 
	if (InstantASP_NS4) {var height = obj.clip.height;}
	else {var height = obj.offsetHeight;}
	return height;  
}

// Starting with the given node, find the nearest contained element             

function InstantASP_GetContainer(node, tagName) {

  while (node != null) {
    if (node.tagName != null && node.tagName == tagName)
      return node; node = node.parentNode;
  }
  return node;
}

// Removes px and percentage markers from css style properties and returns an integer      

function InstantASP_StyleWidthToInt(strInput)	{

	var strOutput = 0;
	if (strInput.toLowerCase().indexOf("px") >= 0) {
		strOutput = strInput.substr(0, strInput.toLowerCase().indexOf("px"));
	} else if (strInput.indexOf("%") >= 0) {
		strOutput = strInput.substr(0, strInput.indexOf("%"));
	}
	return parseInt(strOutput);	
}

// This funtion removes any trialing anchor points within a string

function InstantASP_RemoveBookMark(strInput) {
	var uri = new String(strInput)
	var strOutput; var intPos = uri.indexOf('#');
	if (intPos > 0) {strOutput = uri.substring(0, intPos);}
	else {strOutput = uri;} return strOutput;
}

// This funtion removes any querystring from a string

function InstantASP_RemoveQueryString(strInput) {
	var uri = new String(strInput)
	var strOutput; var intPos = uri.indexOf('?');
	if (intPos > 0) {strOutput = uri.substring(0, intPos);}
	else {strOutput = uri;} return strOutput;
}

function InstantASP_GetViewPortSize()  {

    var size = [0, 0];
    if (typeof window.innerWidth != 'undefined')
    {
     size = [ window.innerWidth, window.innerHeight ];
    }
    else if (typeof document.documentElement != 'undefined' &&
             typeof document.documentElement.clientWidth != 'undefined' &&
             document.documentElement.clientWidth != 0)
    {
     size = [ document.documentElement.clientWidth, document.documentElement.clientHeight ];
    }
    else
    {
     size = [ document.getElementsByTagName('body')[0].clientWidth,
              document.getElementsByTagName('body')[0].clientHeight ];
    }
    
    return size;    
  
}

function InstantASP_ToggleVisibility(strControlName) {
    var obj = InstantASP_FindControl(strControlName);

    if (obj != null) {
        if (obj.style.display == "none") {
            obj.style.display = "inline";
        } else {
            obj.style.display = "none";
        }
    }
}

function InstantASP_HideControl(strControlName) {
    var obj = InstantASP_FindControl(strControlName);
    if (obj != null) {
        obj.style.display = "none";
    }    
}

 function InstantASP_ShowControl(strControlName) {
    var obj = InstantASP_FindControl(strControlName);
    if (obj != null) {
        obj.style.display = "inline";        
    }    
}


/* ----------------------------------------------------------- */
// Dual Drop Down List Client Side JavaScript
// InstantASP.Common.UI.WebControls.DualDropDowns
/* ----------------------------------------------------------- */

function hasOptions(obj) {
	if (obj!=null && obj.options!=null) { return true; }
	return false;
	}

function addTextBoxOption(from,to,inputhidden) {
    var value = from.value;
    	var options = new Object();
	if (hasOptions(to)) {
		for (var i=0; i<to.options.length; i++) {
			options[to.options[i].value] = to.options[i].text;
			}
		}
	if (value == "") {return; }
    if (value == null || value == "undefined" || options[value]!=value) {
        if (!hasOptions(to)) { var index = 0; } else { var index=to.options.length; }
        to.options[index] = new Option( value, value, false, false);
    }
    populateValueField(to,inputhidden);
	from.value = "";
	to.selectedIndex = -1;
}

function addSelectedOptions(from,to,inputhidden) {
	var options = new Object();
	if (hasOptions(to)) {
		for (var i=0; i<to.options.length; i++) {
			options[to.options[i].value] = to.options[i].text;
			}
		}
	if (!hasOptions(from)) { return; }
	for (var i=0; i<from.options.length; i++) {
		var o = from.options[i];
		if (o.selected) {
			if (options[o.value] == null || options[o.value] == "undefined" || options[o.value]!=o.text) {
				if (!hasOptions(to)) { var index = 0; } else { var index=to.options.length; }
				to.options[index] = new Option( o.text, o.value, false, false);
				}
			}
		}
		
	populateValueField(to,inputhidden);
	from.selectedIndex = -1;
	to.selectedIndex = -1;
	
	}

function removeSelectedOptions(from,inputhidden) { 
	if (!hasOptions(from)) { return; }
	if (from.type=="select-one") {
		from.options[from.selectedIndex] = null;
		}
	else {
		for (var i=(from.options.length-1); i>=0; i--) { 
			var o=from.options[i]; 
			if (o.selected) { 
				from.options[i] = null; 
				} 
			}
		}
	populateValueField(from,inputhidden);
	from.selectedIndex = -1; 
	} 

function moveOptionUp(obj,inputhidden) {
	if (!hasOptions(obj)) { return; }
	for (i=0; i<obj.options.length; i++) {
		if (obj.options[i].selected) {
			if (i != 0 && !obj.options[i-1].selected) {
				swapOptions(obj,i,i-1);
				obj.options[i-1].selected = true;
				}
			}
		}
	populateValueField(obj,inputhidden);
	}

function moveOptionDown(obj,inputhidden) {
	if (!hasOptions(obj)) { return; }
	for (i=obj.options.length-1; i>=0; i--) {
		if (obj.options[i].selected) {
			if (i != (obj.options.length-1) && ! obj.options[i+1].selected) {
				swapOptions(obj,i,i+1);
				obj.options[i+1].selected = true;
				}
			}
		}
	populateValueField(obj,inputhidden);
	}

function swapOptions(obj,i,j) {
	var o = obj.options;
	var i_selected = o[i].selected;
	var j_selected = o[j].selected;
	var temp = new Option(o[i].text, o[i].value, o[i].defaultSelected, o[i].selected);
	var temp2= new Option(o[j].text, o[j].value, o[j].defaultSelected, o[j].selected);
	o[i] = temp2;
	o[j] = temp;
	o[i].selected = j_selected;
	o[j].selected = i_selected;
	}
	
function populateValueField(obj,inputhidden) {

	if (!hasOptions(obj)) { return; }
	var strValues = "";
	for (i=0; i<obj.options.length; i++) {
		strValues = strValues + obj.options[i].value + ",";
		}
	inputhidden.value = strValues;
	
	}
	
	
/* ----------------------------------------------------------- */
// Bookmark URL method
/* ----------------------------------------------------------- */
	
function InstantASP_Bookmark(bmurl, bmtitle){

     if(window.sidebar) { 
       window.sidebar.addPanel(bmtitle, bmurl,""); 
     }else if( document.all ) {
      window.external.AddFavorite( bmurl, bmtitle);
     }else if( window.opera && window.print ) {
      return true;
      
     }
   }
	
/* ----------------------------------------------------------- */
// ToolTip Control
/* ----------------------------------------------------------- */
	
var iasptooltip_offsetxpoint = 10;
var iasptooltip_offsetypoint = 10;
var iasptooltip_obj = null;
var iasptooltip_allowMove = true;
var iasptooltip_allowHide = true;
var iasptooltip_timeoutID;

/* get ibhect nidel */
function iasp_ieTrueBody() {
    return (document.compatMode && document.compatMode != "BackCompat") ? document.documentElement : document.body;
}

/* enable tooltip */
function iasp_EnableTip(thetext, intWidth, intShowFor) {

    // init vars
    iasptooltip_allowMove = true; 
    iasptooltip_allowHide = true;

    // clear timeout
    if (iasptooltip_timeoutID != null) {clearTimeout(iasptooltip_timeoutID);}
    
    // get tooltip layer
    iasptooltip_obj = InstantASP_FindControl('iasp_ToolTip');   
    
    if (!iasptooltip_obj) {return false;}
    
    iasptooltip_obj.style.left = '-1000px'
    iasptooltip_obj.style.top = '-1000px'
    iasptooltip_obj.style.zindex = '9999999'
      
    if (InstantASP_NS6 || InstantASP_IE5) {
        if (typeof intWidth != "undefined") {
            iasptooltip_obj.style.width = intWidth + "px";
        }
        if (InstantASP_IE5) {
            iasptooltip_obj.style.filter = 'progid:DXImageTransform.Microsoft.Shadow(color="#888888", Direction=120, Strength=3) alpha(Opacity=100)';
        }
        
        // populate text
        iasp_populateToolTip(thetext);
      
        // show tooltip
        iasptooltip_obj.style.display = "block";
        iasp_PositionTip;
        
        // depends on InstantASPTransitions.js
        doFade(iasptooltip_obj, 25);	  
        
        // position tooltip
        document.onmousemove = iasp_PositionTip;
        
        // hide after x secs
        if (intShowFor > 0) {
            iasp_DisableTip(intShowFor)
        }        

    }
}

/* populate tooltip text */
function iasp_populateToolTip(strText) {
      iasptooltip_obj.innerHTML = strText; 
}

/* position tooltip */
function iasp_PositionTip(e) {

    if (iasptooltip_allowMove && iasptooltip_obj.style.display != "none") {
    
        var iasptooltip_curX = (InstantASP_NS6) ? e.pageX : event.x + iasp_ieTrueBody().scrollLeft;
        var iasptooltip_curY = (InstantASP_NS6) ? e.pageY : event.y + iasp_ieTrueBody().scrollTop;      
        var iasptooltip_bottomedge = InstantASP_IE5 && !InstantASP_Opera ? iasp_ieTrueBody().clientHeight - event.clientY - iasptooltip_offsetypoint : window.innerHeight - e.clientY - iasptooltip_offsetypoint;
        var iasptooltip_rightedge = InstantASP_IE5 && !InstantASP_Opera ? iasp_ieTrueBody().clientWidth - event.clientX - iasptooltip_offsetxpoint : (window.innerWidth - e.clientX - iasptooltip_offsetxpoint);       

        // set left
        if (iasptooltip_rightedge < iasptooltip_obj.offsetWidth ) {
             iasptooltip_obj.style.left = InstantASP_IE5 ? iasp_ieTrueBody().scrollLeft + event.clientX - iasptooltip_obj.offsetWidth - 15 + "px" : window.pageXOffset + (e.clientX - iasptooltip_obj.offsetWidth - 15) + "px";
            } 
        else {
            iasptooltip_obj.style.left = iasptooltip_curX + (iasptooltip_offsetxpoint) + "px";
        }        

        // set top
        iasptooltip_obj.style.top = InstantASP_IE5? iasp_ieTrueBody().scrollTop + event.clientY + iasptooltip_offsetypoint + "px" : window.pageYOffset + e.clientY + iasptooltip_offsetypoint + "px";
        
        // don't move again
        iasptooltip_allowMove = false;
          
    }  
}

function iasp_DisableTip(intDelay) {
        if (intDelay == null) {intDelay = 0;}       
        if (iasptooltip_allowHide) {
            iasptooltip_timeoutID = setTimeout(iasp_hideToolTip,intDelay * 1000)
        }
}

function iasp_clearToolTipTimeout() {
    // clear timeout
    if (iasptooltip_timeoutID != null) {clearTimeout(iasptooltip_timeoutID);}
    iasp_showToolTip();
    iasptooltip_allowHide = false;
}

function iasp_showToolTip() {
    if (InstantASP_NS6 || InstantASP_IE5) {
        if (iasptooltip_obj != null) {
            iasptooltip_obj.style.display = "inline-block";
            iasptooltip_allowMove = false;
        }
    }
}

function iasp_hideToolTip() {
    if (InstantASP_NS6 || InstantASP_IE5) {
        if (iasptooltip_obj != null) {
             iasptooltip_obj.style.display = "none";
             iasptooltip_allowMove = true;
         }
    }
}


/* ----------------------------------------------------------- */
// Ajax Loader
/* ----------------------------------------------------------- */

var iasp_bolLoadStarted = false;
var iasp_bolLoadEnded = false;
var iasp_LoaderDivId = 'iasp_LoaderDiv';

function iasp_AjaxExtensionsInitializeRequest(postBackElement) {

    // ensure method is only ran once
    if (!iasp_bolLoadStarted) {
            
        // get body
        var body = document.getElementsByTagName("body");
        
        // tweak opacity
        if (InstantASP_IE4 || InstantASP_IE5 || InstantASP_Opera || InstantASP_NS6)	{
	       body[0].style.filter = "alpha(opacity=25); -moz-opacity: .25;";
        }
        
        // set pointer to hourglass
        if (document.body != null) {document.body.style.cursor = 'wait';}
        
        // show loader
        iasp_AddLoader();
        
        // update flags
        iasp_bolLoadStarted = true;
        iasp_bolLoadEnded = false;
    }
}

function iasp_AjaxExtensionsEndRequest(postBackElement) {

    // ensure method is only ran once
    if (!iasp_bolLoadEnded) {
    
        // get body
        var body = document.getElementsByTagName("body");
    
         // tweak opacity
        if (InstantASP_IE4 || InstantASP_IE5 || InstantASP_Opera || InstantASP_NS6)	{
            body[0].style.filter = "";
        }
        
        // set pointer to default
        if (document.body != null) {document.body.style.cursor = 'default';}
        
        // hide loader
        iasp_RemoveLoader();
        
        // update flags
        iasp_bolLoadEnded = true;
        iasp_bolLoadStarted = false;
        
    }
}

var iasp_LoaderDiv;
function iasp_AddLoader() {

    // calculate position
    var top = Math.round((document.documentElement.clientHeight/2)+document.documentElement.scrollTop) + "px";
    var left = Math.round((document.documentElement.clientWidth/2))-100 + "px";
    
	// build loader
   if (!iasp_LoaderDiv) {iasp_LoaderDiv = document.createElement('div');}
    iasp_LoaderDiv.id = iasp_LoaderDivId;   
    iasp_LoaderDiv.style.position = 'absolute';
    iasp_LoaderDiv.style.top = top;
    iasp_LoaderDiv.style.left = left;
    iasp_LoaderDiv.style.zindex = 999999;
	iasp_LoaderDiv.innerHTML = iasp_AjaxLoadingText;
	
	// add to document
	document.body.appendChild(iasp_LoaderDiv);    
}

function iasp_RemoveLoader() {
    // hide loader
    var iasp_LoaderDiv = InstantASP_FindControl(iasp_LoaderDivId);
    if (iasp_LoaderDiv != null)  {
        iasp_LoaderDiv.style.display = "";
        document.body.removeChild(iasp_LoaderDiv);  
    }   
}


// ================================================================
// ================================================================
// ================================================================

/* ----------------------------------------------------------- */
// common UI elements
/* ----------------------------------------------------------- */

instantaspcommonui = new Object();

function InstantASPCommonUI(strImgFolder) { 

    // public properties
    this.imgFolder = strImgFolder;   
    this._sfloat  = null;
        
    if (document.all) { 
        this._sfloat = "styleFloat"; //ie
    } else {  
        this._sfloat = "cssFloat"; //ff
    }

  if (instantaspcommonui[strImgFolder]!=null) {
        return  instantaspcommonui[strImgFolder];
    } else { 
        instantaspcommonui[strImgFolder]=this;
    }

    return this;
    
}

// build table cell

InstantASPCommonUI.prototype.buildTD = function(strClass, strWidth, strAlign, objControl, intColSpan) {

   var td = document.createElement("TD");
    if (strClass != null) {td.className =  strClass;};
    if (strWidth != null) {td.style.width = strWidth;};
    if (strAlign != null) {td.align = strAlign;};
    if (intColSpan != null) {td.setAttribute('colSpan',intColSpan)};
    if (objControl != null) {td.appendChild(objControl);};
    return td;
    
}

// build select list 

InstantASPCommonUI.prototype.buildSelect = function(strClass, strWidth, arrValues) {

    var objSelect = document.createElement("SELECT");
    if (strClass != null) {
        objSelect.className = strClass;
    } else {
        objSelect.className = "FormInputDropDown";    
    }
    
    if (arrValues != null) {    
            
         for(i=0;i<arrValues.length;i++) { 
                 
           var arrValue = arrValues[i];       
            var objOption = document.createElement("OPTION");
            objOption.text = arrValue[1];
            objOption.value =  arrValue[2];
            this.AddOptToSelect(objSelect, objOption);            

         }
        
    } else {
    
        var objOption = document.createElement("OPTION");
        objOption.text = "No data";
        objOption.value = "0";
        this.AddOptToSelect(objSelect, objOption);
        
    }
    
    return objSelect;

}

// add option to select

InstantASPCommonUI.prototype.AddOptToSelect = function(select, option) {

    if(document.all && !window.opera) {
        select.add(option);
    }  else {
        select.add(option, null);
    }
    
}

// search textbox

InstantASPCommonUI.prototype.buildSearchTxtBox = function(txtTextBox, butSubmit, butOptions) {
       
    var div1 = document.createElement("div");  
    div1.className = "input_BG";
    
    var div2 = document.createElement("div");  
    div2.className = "input_BGLeft";

    var div3 = document.createElement("div");  
    div3.className = "input_BGContainer";

    var div4 = document.createElement("div");  
    div4.className = "input_BGContainerBG";
    
    div1.appendChild(div2);
    div2.appendChild(div3);
    div3.appendChild(div4);
    
    // setup textbox
    
    var div5 = document.createElement("div");  
    div5.className = "text-field";

    if (txtTextBox != null) {      
        
        // catch enter button
        addEvent(txtTextBox, 'keydown', function(e) {
            return catchKeyDown(butSubmit.id, e);
        }
        ); 
        
        div5.appendChild(txtTextBox);
  
        
    }
    
    // setup search button
    
    var div6 = document.createElement("div");  
    div6.className = "button-field";
    

    if (butSubmit != null) {
        div6.appendChild(butSubmit);    
    }
    
    // setup show forums button
       
    var div7 = null;
    if (butOptions != null) {
        div7 = this.buildSimpleMenuLink(butOptions);
        div7.className = "button-catfield";
    }

    
    // add search options to div
    
    div4.appendChild(div5);
    div4.appendChild(div6);
    
    if (div7 != null) {div4.appendChild(div7);}

    return div1;

}

InstantASPCommonUI.prototype.buildSimpleMenuLink = function(ctl) {

    var div = document.createElement("span");  
  
    if (ctl != null) {
        div.setAttribute("id", ctl.id + "_smMenuContainer");    
        div.appendChild(ctl);
    }
    
    return div;
    
}



// rounded tab le

InstantASPCommonUI.prototype.buildRoundedTable = function(title, div) {

    var strPadding = "12px";
    
    // build table
    
    var tbl = document.createElement("TABLE");  
    tbl.style[this._sfloat] = "left";
    tbl.style.width = "100%";
    tbl.className = "rt_tbl"       
    tbl.setAttribute("cellPadding","0px")
    tbl.setAttribute("cellSpacing","0px")
    
    var tBody = document.createElement("TBODY");  
 
    tbl.appendChild(tBody);
    
    // ---------------- top row
    
    var row = document.createElement("TR");  
    
    // top left 
    
    var img =  document.createElement("IMG");
     img.src = this.imgFolder + "Common/RoundedTable/tbl_topleft.gif";
    img.style.display = "block";

    var td1 = this.buildTD("rt_Edge", null, null, img)
    row.appendChild(td1);  
    
    // top
                      
    var div1 = document.createElement("DIV");     
    div1.className = "hLight"
    div1.appendChild(document.createTextNode(title));
    
    var td2 = this.buildTD("rt_Top", null, null, div1)     
    row.appendChild(td2); 
    
    // top right 
    
    var img =  document.createElement("IMG");
    img.src = this.imgFolder + "Common/RoundedTable/tbl_topright.gif";
    img.style.display = "block";

    var td3 = this.buildTD("rt_Edge", null, null, img)
    row.appendChild(td3);  
    
    tBody.appendChild(row);
    
    
     // ---------------- middle row
    
    var row = document.createElement("TR");  
    
    // middle left 

    var td4 =this.buildTD("rt_Left", null, null, document.createElement("DIV"))
    row.appendChild(td4);  
    
    // middle
    
    // create container table
            
    var tblContent = document.createElement("TABLE");  
    tblContent.style.width = "100%";
    tblContent.setAttribute("cellPadding", strPadding);  
    tblContent.setAttribute("cellSpacing", "0px");  
          
    var tBodyContent = document.createElement("TBODY");         
    tblContent.appendChild(tBodyContent);   

    var rowContent = document.createElement("TR"); 
    
    var tdContent =this.buildTD(null, null, null, div)
    rowContent.appendChild(tdContent);   
           
    tBodyContent.appendChild(rowContent);        
                     
    var td5 =this.buildTD(null, null, null, tblContent)
    
    row.appendChild(td5); 
    
    // middle right  

    var td6 =this.buildTD("rt_Right", null, null, document.createElement("DIV"))
    row.appendChild(td6);  
    
    tBody.appendChild(row);        
    
    // ---------------- bottom row
    
    var row = document.createElement("TR");  
    
    // bottom left 
    
   var img =  document.createElement("IMG");
     img.src = this.imgFolder + "Common/RoundedTable/tbl_bottomleft.gif";
     img.style.display = "block";

    var td7 =this.buildTD("rt_Edge", null, null, img)
    row.appendChild(td7);  
    
    // bottom                          

    var td8 =this.buildTD("rt_Bottom", null, null, document.createElement("DIV"));       
    row.appendChild(td8); 
    
    // bottom right 
    
    var img =  document.createElement("IMG");
     img.src = this.imgFolder + "Common/RoundedTable/tbl_bottomright.gif";    
    img.style.display = "block";
    
    var td9 =this.buildTD("rt_Edge", null, null, img)
    row.appendChild(td9);  
    
    tBody.appendChild(row);
    
    return tbl;
    
}


// records per page drop down list

InstantASPCommonUI.prototype.buildSortOrderDropDown = function() {

    var arr = new Array(2);
    for (i=0; i < arr.length; i++) {
    arr[i]=new Array(2);
    }

    arr[0][1] = "in: DESC order";
    arr[0][2] = "1";
    arr[1][1] = "in: ASC order";
    arr[1][2] = "2";

    return this.buildSelect(null, null, arr);    


}


// records per page drop down list

InstantASPCommonUI.prototype.buildRecordsPerPageDropDown = function() {
    
    var arr = new Array(4);
    for (i=0; i < arr.length; i++) {
    arr[i]=new Array(2);
    }

    arr[0][1] = "with 10 per page";
    arr[0][2] = "10";
    arr[1][1] = "with 25 per page";
    arr[1][2] = "25";
    arr[2][1] = "with 50 per page";
    arr[2][2] = "50";
    arr[3][1] = "with 100 per page";
    arr[3][2] = "100";

    return this.buildSelect(null, null, arr);     



}


// search type drop down list

InstantASPCommonUI.prototype.buildSearchTypeDropDown = function() {
    
    var arr = new Array(3);
    for (i=0; i < arr.length; i++) {
    arr[i]=new Array(2);
    }

    arr[0][1] = "using: ALL keywords";
    arr[0][2] = "1";
    arr[1][1] = "using: ANY keywords";
    arr[1][2] = "2";
    arr[2][1] = "using: EXACT metch";
    arr[2][2] = "3";

    return this.buildSelect(null, null, arr);   

}

InstantASPCommonUI.prototype.setAttribute = function(node, attr, value) {

	if(value == null || node == null || attr == null) return;
	if(attr.toLowerCase() == "style") {
		this.setStyleAttribute(node, value);
	}
	else {
		node.setAttribute(attr, value);
	}
	
}

InstantASPCommonUI.prototype.setStyleAttribute = function(node, style) {

	if(style == null) return;
	var styles = style.split(";");
	var pos;
	for(var i=0;i<styles.length;i++) {
		var attributes = styles[i].split(":");
		if(attributes.length == 2) {
			try {
				var attr = this.trim(attributes[0]);
				while((pos = attr.search(/-/)) != -1) {
					var strBefore = attr.substring(0, pos);
					var strToUpperCase = attr.substring(pos + 1, pos + 2);
					var strAfter = attr.substring(pos + 2, attr.length);
					attr = strBefore + strToUpperCase.toUpperCase() + strAfter;
				}
				var value = this.trim(attributes[1]).toLowerCase();
				node.style[attr] = value;
			}
			catch (e) {
				alert(e);
			}
		}
	}
}

InstantASPCommonUI.prototype.trim = function(str) {
	return str.replace(/^\s*|\s*$/g,"");
}

/* ----------------------------------------------------------- */
// transition helpers
/* ----------------------------------------------------------- */

var fadetimer = false;
var timerloopback = 1;
var dtCurrentTime;

instantaspTransition = new Object();

function InstantASPTransition(transitionid) { 
 this.TransitionID = transitionid;
 this.ExpandSlide = 2;
 this.ExpandSlideDuration = 200;
 this.ExpandTransition = 12;
 this.ExpandTransitionDuration = 175;
 this.CollapseSlide = 2;
 this.CollapseSlideDuration = 200;
 this.CollapseTransition = 12;
 this.CollapseTransitionDuration = 175;
 this.UseFade = false;
 this.FadeIncrement = 25;
 this.Container = null;
 if (instantaspTransition[this.TransitionID]!=null) {
  return instantaspTransition[this.TransitionID];
 } else { 
  instantaspTransition[this.TransitionID] = this;
 }
 return this;
}

InstantASPTransition.prototype.ExpandDiv = function(obj) {
	
	if (obj!=null) {
	
		obj.style.overflow = 'hidden';
		obj.style.display = '';
		
		if (this.ExpandSlide > 0) {dtCurrentTime = (new Date()).getTime();
		ExpandDivSlide(InstantASP_GetObjHeight(obj), this.ExpandSlideDuration, this.ExpandSlide, obj.id);}	
		
		if (this.ExpandTransition>0) {
			obj.style.filter = InitializeFilter(this.ExpandTransition, this.ExpandTransitionDuration);
			if (obj.filters && obj.filters[0]) {
				obj.style.visibility = 'hidden';
				obj.filters[0].apply();
				obj.style.visibility = 'visible';
				obj.filters[0].play();
			}
		} else {
			obj.style.visibility = 'visible'		
		} 		
	
		if (this.UseFade) {doFade(obj, this.FadeIncrement);}
	
	}
		
}

InstantASPTransition.prototype.CollapseDiv = function(obj) {

	if (obj!=null) {
	
		obj.style.overflow = 'hidden';
		
		if (this.CollapseSlide > 0) {
			if (this.CollapseSlide > 0) {dtCurrentTime = (new Date()).getTime();
			CollapseDivSlide(InstantASP_GetObjHeight(obj), this.CollapseSlideDuration, this.CollapseSlide, obj.id);}	
		} else {
			obj.style.display='none';
		}
//		
//		if (this.CollapseTransition>=0&&InstantASP_Transitions) {
//			obj.style.filter = InitializeFilter(this.CollapseTransition, this.CollapseTransitionDuration);
//			if (obj.filters && obj.filters[0]) {
//				obj.style.visibility = 'visible';
//				obj.filters[0].apply();
//				obj.style.visibility = 'hidden';
//				obj.filters[0].play();
//			}
//		} else {
//			obj.style.visibility = 'hidden'		
//		} 
//		

		if (this.UseFade) {doFade(obj, this.FadeIncrement);}
	
	}
	
}

function ExpandDivSlide (height, slideduration, slidetype, id) {
	var obj = InstantASP_FindControl(id);
	var slidetimer = (new Date()).getTime()-dtCurrentTime;
	var slideincrement = InitializeSlide(slidetimer, slideduration, slidetype);
	if (slideincrement==1) { 
		obj.style.height = height + 'px'; 
		obj.style.overflow='visible'; 
		obj.style.height=''; 
		obj=null;
	} else {
		obj.style.height = Math.max(1, Math.floor(height*slideincrement))+'px';
		setTimeout('ExpandDivSlide('+height+','+slideduration+','+slidetype+',"'+id+'");',timerloopback);
	};
}

function CollapseDivSlide (height, slideduration, slidetype, id) {
	var obj = InstantASP_FindControl(id);
	var slidetimer = (new Date()).getTime()-dtCurrentTime;
	var slideincrement = InitializeSlide(slidetimer, slideduration, slidetype);
	if (slideincrement==1) {
		obj.style.display='none'; obj=null;
	} else {
		obj.style.height = Math.ceil((1-slideincrement)*height)+'px';
		setTimeout('CollapseDivSlide('+height+','+slideduration+','+slidetype+',"'+id+'");',timerloopback);
	};
}

function InitializeFilter(transition, duration) {  
	var s; if (InstantASP_BrowserVer < 5.5) { 
	 if (transition=37) {transition=parseInt(23*Math.random());} 
	 s = "revealTrans(Transition="+transition+",Duration="+(duration/1000)+");";
	} else { 
	 if (transition==37) {transition=parseInt(36*Math.random());} 
	 s = "progid:DXImageTransform.Microsoft."+GetFilter(transition); 
	 s = s.replace(')','Duration='+(duration/1000)+');');}
	 return s;
}

function InitializeSlide(slidetimer, slideduration, slidetype) {
	if (slidetype == 0 || slidetimer >= slideduration) {return 1;};
	if (slidetype==1) {slidetimer = slideduration-slidetimer;};
	var intMod = slidetimer/slideduration; 
	var intReturn;
	switch (slidetype) { 
		case 1: intReturn = 1-Math.pow(1/300,intMod); break;
		case 2:
		case 3: intReturn = intMod; break;
	};
	if (slidetype==1) {intReturn = 1-intReturn;};
	return Math.min(Math.max(0,intReturn),1);
};

function GetFilter(transition) {
    switch (transition) {
     case 0:return "Iris(irisStyle=SQUARE,motion=in,)";
     case 1:return "Iris(irisStyle=SQUARE,motion=out,)";
     case 2:return "Iris(irisStyle=CIRCLE,motion=in,)";
     case 3:return "Iris(irisStyle=CIRCLE,motion=out,)";
     case 4:return "Wipe(GradientSize=1.0,wipeStyle=1,motion=reverse,)";
     case 5:return "Wipe(GradientSize=1.0,wipeStyle=1,motion=forward,)";
     case 6:return "Wipe(GradientSize=1.0,wipeStyle=0,motion=forward,)";
     case 7:return "Wipe(GradientSize=1.0,wipeStyle=0,motion=reverse,)";
     case 8:return "Blinds(bands=8,direction=RIGHT,)";
     case 9:return "Blinds(bands=8,direction=DOWN,)";
     case 10:return "Checkerboard(squaresX=16,squaresY=16,direction=right,)";
     case 11:return "Checkerboard(squaresX=12,squaresY=12,direction=down,)";
     case 12:return "RandomDissolve()";
	 case 13:return "Barn(orientation=vertical,motion=in,)";
	 case 14:return "Barn(orientation=vertical,motion=out,)";
	 case 15:return "Barn(orientation=horizontal,motion=in,)";
	 case 16:return "Barn(orientation=horizontal,motion=out,)";
	 case 17:return "Strips(Motion=leftdown,)";
	 case 18:return "Strips(Motion=leftup,)";
	 case 19:return "Strips(Motion=rightdown,)";
	 case 20:return "Strips(Motion=rightup,)";
	 case 21:return "RandomBars(orientation=horizontal,)";
	 case 22:return "RandomBars(orientation=vertical,)";
	 case 23:return "Fade(overlap=.5,)";
	 case 24:return "Wheel(spokes=16,)";
     case 25:return "Slide(slideStyle=hide,bands=15,)";
	 case 26:return "Slide(slideStyle=swap,bands=15,)";
	 case 27:return "Inset()";
	 case 28:return "Pixelate(MaxSquare=15,)";
	 case 29:return "Stretch(stretchStyle=hide,)";
	 case 30:return "Stretch(stretchStyle=spin,)";
	 case 31:return "Iris(irisStyle=cross,motion=in,)";
	 case 32:return "Iris(irisStyle=cross,motion=out,)";
	 case 33: return "Iris(irisStyle=plus,motion=in,)";
	 case 34: return "Iris(irisStyle=plus,motion=out,)";
	 case 35: return "Iris(irisStyle=star,motion=in,)";
	 case 36: return "Iris(irisStyle=star,motion=out,)";
    };
     return null;
}


function doFade(obj, fadeincrement) {
	if (obj.filters!=null&&obj.style.filter.indexOf("alpha")==-1) {
	 obj.style.filter = "alpha(opacity=0); moz-opacity:0%;" 
	} 
	FadeIn(obj.id, 0, fadeincrement);
}

function FadeIn(id, opac, fadeincrement) {
	obj = InstantASP_FindControl(id);
	if (opac <= 100) {
		opac+=fadeincrement; 
		if (InstantASP_IE4 || InstantASP_IE5) {obj.filters.alpha.opacity = opac;}
		if (InstantASP_NS6) {obj.style.MozOpacity = opac/100;}
		fadetimer = setTimeout("FadeIn('"+id+"', "+opac+","+fadeincrement+");",timerloopback);
	} else {
		clearTimeout(fadetimer)
	}
}


// ================================================================
// ================================================================
// ================================================================

// ---------------------------------------------------------
// Json Proxy
// ---------------------------------------------------------

instantaspjsonproxy = new Object();

function InstantASPJSONProxy(strJSON) { 
this.json = strJSON;

 if (instantaspjsonproxy[this.json]!=null) {
    return this;
 } else { 
  instantaspjsonproxy[this.json]=this;
 }
 return this;
}

InstantASPJSONProxy.prototype.getData = function() {	

	var data = JSON.parse(this.json);
    if( !data) {alert("Unable to parse JSON string!"); return;} 
    return data;
		
}


InstantASPJSONProxy.prototype.objToArray = function(obj) {

    if( !obj) return new Array();
    if( !obj.length) return new Array(obj);
    return obj;	

}

// ---------------------------------------------------------
// Json Table
// ---------------------------------------------------------

instantaspjsontable = new Object();

function InstantASPJSONTable(strTableID) { 

    this.JSON = null;
    this.TableID = strTableID;
    this.jsonproxy = null;
    this.Host = null;
    this.commonUI = null;

    if (instantaspjsontable[this.TableID]!=null) {
        return  instantaspjsontable[this.TableID];
    } else { 
        instantaspjsontable[this.TableID]=this;
    }
    return this;
    
}

InstantASPJSONTable.prototype.initalize = function() {
    
    // setup json proxy object
    if (this.JSON != null) {this.jsonproxy = new InstantASPJSONProxy(this.JSON);}

    if (this.commonUI == null) {this.commonUI = new InstantASPCommonUI();}
    
    // show loader whist we build the table
    this.showLoader();   
    
    this.buildTable();
    
    this.hideLoader();
        

    
}

InstantASPJSONTable.prototype.buildTable = function() {

    // get table header
    var tHead = this.getTableHead();

    // add table row to header
    if ( this.OnHeaderRowAdd != null) {
        tHead.appendChild(this.addHeaderRow());          
    }
    

    if (this.BindData != null) {
    
        // rause bind data event to get data
        var data = this.BindData(this.Host, this.jsonproxy);

        this.buildRowsFromData(data);
        
    }



}

InstantASPJSONTable.prototype.buildRowsFromData = function(data) {

    var tBody = this.getTableBody();    

    // build our data rows
    if (data != null) {    
        for (var i = 0; i < data.length; i++) {                            
            tBody.appendChild(this.addRow(data[i]));     
        }        
        
    } else {
         tBody.appendChild(this.buildNoResults()); 
    }
    
}

InstantASPJSONTable.prototype.buildNoResults = function() {

    // get header columns
    var intColSpan = (this.getTableHead().getElementsByTagName("TD").length - 1);
    
    // cell css
    var strCssLight = "TableCell_Light";

    // create row
    var row = document.createElement("TR");  
    
    // create label
    var span = document.createElement("SPAN");
    span.appendChild(document.createTextNode(iasp_NoResults)); 

    // create column
    var td = this.commonUI.buildTD(strCssLight, "100%", null, span, intColSpan)
    
    // add column to row
    row.appendChild(td);
    
    // return row
    return row;
    

}

InstantASPJSONTable.prototype.clearTable = function() {

    this.clearHeader();
    this.clearBody();

}

InstantASPJSONTable.prototype.clearHeader = function() {

    var tHead = this.getTableHead();
    var rows = tHead.getElementsByTagName("TR");
    
    // ensure we never remove the first row  
    for (i=rows.length-1; i >= 1; i--) {    
          tHead.removeChild(rows[i]);
    }   
    
}

InstantASPJSONTable.prototype.clearBody = function() {

    var tBody = this.getTableBody();
    var rows = tBody.getElementsByTagName("TR");
    
    // ensure we never remove the first row
    for (i=rows.length-1; i >= 1; i--) {    
          tBody.removeChild(rows[i]);
    }    
    
}

InstantASPJSONTable.prototype.showLoader = function() {
    
    var trLoader = this.getLoader();
    trLoader.style.display = '';
}

InstantASPJSONTable.prototype.hideLoader = function() {
    
    var trLoader = this.getLoader();
    trLoader.style.display = 'none';
    
}

InstantASPJSONTable.prototype.getTable = function() {
    return InstantASP_FindControl(this.TableID);    
}

InstantASPJSONTable.prototype.getTableHead = function() {
    return this.getTable().getElementsByTagName("THEAD")[0];
}

InstantASPJSONTable.prototype.getTableBody = function() {
    return this.getTable().getElementsByTagName("TBODY")[0];
}

InstantASPJSONTable.prototype.getLoader = function() {
    return  this.getTableBody().getElementsByTagName("TR")[0];
}


InstantASPJSONTable.prototype.addHeaderRow = function() { 
 
    // raise event so we can build the table tow
    return this.OnHeaderRowAdd(this.Host); 
    
}

InstantASPJSONTable.prototype.addRow = function(data) { 
        
    // raise event so we can build the table tow
    return this.OnRowAdd(this.Host, data); 

}

InstantASPJSONTable.prototype.BindData = function(host, jsonproxy){};
InstantASPJSONTable.prototype.OnHeaderRowAdd = function(){};
InstantASPJSONTable.prototype.OnRowAdd = function(host, data){};

// ---------------------------------------------------------
// helpers
// ---------------------------------------------------------

// catch enter key for search forms
function catchKeyDown(butSubmitID, e) {
    
    var keyCode = getKeyCode(e)
    if ((keyCode && keyCode == 13)) {
        var but = InstantASP_FindControl(butSubmitID);
        if (but != null) {
            but.click();        
        }
        return false;
    } else  {
        return true;
    }
    
}

// disable form submitting
function disableFormSubmit() {
    var frm = document.forms[0];    
     if (frm) {  alert(frm.id);
        
        frm.onsubmit = function() {return false};
     }
}
            

// get keycode to catch carraige returns
function getKeyCode(e) {
    if(window.event) {
        return event.keyCode;
    }
    else if(e.which) {
        return e.which;
    }
}

// global add event method
function addEvent(obj, evType, fn) { 

    if (obj.addEventListener) { 
        obj.addEventListener(evType, fn, false); 
        return false; 
    } else if (obj.attachEvent) { 
        var r = obj.attachEvent("on"+evType, fn); 
        return r; 
    } else { 
        return false; 
    } 
}

// clear textbox default value and reset if nothing is entered

function clearTxt(txt, defaultVal, clear) {
     
    var strDefaultVal = "";
    if (defaultVal != null) {strDefaultVal = defaultVal;}
    if (!clear) {clear = false;}
    
    if (txt != null) {        
        if (clear) {
            if(txt.value == strDefaultVal) {
                txt.value = "";
            }            
        } else {
           if (txt.value == "") {
                txt.value = strDefaultVal;
            }
        }
         
        
    }
}

function resetTextbox(txt, defaultVal) {

    var strDefaultVal = "";
    if (defaultVal != null) {strDefaultVal = defaultVal;}

    if (txt != null) {
     
    }
    

}

// used only for user controls implementing IScriptControl interface
function refreshControl(controlID, pageIndex) {
        
    var pIndex = 1;    
    if (pageIndex != null) {    
        if (pageIndex != "" && IsNumeric(pageIndex)) {            
            pIndex = pageIndex;
        } else {
            alert("You must provide a valid page number!");
            return;
        }    
        InstantASP_HideAllMenus();
    }
    
    var ctl = $find(controlID);
    if (ctl != null) {
        ctl.fetchData(pIndex);
    }
}

// check to see if a string is numbers only
function IsNumeric(sText) {

   var ValidChars = "0123456789";
   var IsNumber=true;
   var Char;

 
   for (i = 0; i < sText.length && IsNumber == true; i++) 
      { 
      Char = sText.charAt(i); 
      if (ValidChars.indexOf(Char) == -1) 
         {
         IsNumber = false;
         }
      }
      
   return IsNumber;
  
}

// convert array to xml
function ObjToXml(obj,d)    { 

    d=(d)?d:0; 
    var rString="\n"; 
    var pad=""; 
    
    for(var i=0;i<d;i++){ 
        pad+=" "; 
    } 
   
    if(typeof obj == "object") { 
    
        if(obj.constructor.toString().indexOf("Array")!== -1) {          
            for(i=0;i<obj.length;i++){ 
                if (obj[i] != null && obj[i] != "") {
                    rString+=pad+"<item>"+obj[i]+"</item>\n"; 
                }
            }             
            rString=rString.substr(0,rString.length-1);            
        } else { 
        
            for (i in obj){                             
                if (obj[i] != null) {                                        
                    var val = ObjToXml(obj[i],d+1);          
                    if (val == null) {
                        rString = "";
                    } else {                    
                        rString+=((rString==="\n")?"":"\n")+pad+"<"+i+">"+val+((typeof obj[i]==="object")?"\n"+pad:"")+"</"+i+">"; 
                    }
                } 
            } 
        } 
    
    
    } 
    else if(typeof obj == "string"){ 
        rString = obj; 
    } 
    else if(typeof obj == "number"){ 
        rString = obj.toString(); 
    } 
    else if(obj.toString) { 
        rString = obj.toString(); 
    } 
    else{ 
        return false; 
    } 

    return rString; 
    
} 

// convert JSON string to XML
function JsonToXml(json)    { 

    return eval("ObjToXml("+json+");"); 
    
}
 