﻿; (function (win, doc, $) {

    var blog = {
        showMenu: function (a) {
            var link = $(a);
            var id = link.data("menu");
            this.toggleMenu(id);
        },
        resetNavSelection: function () {
            $("#blogNav").find("a").removeClass("selected");
        },
        setNavSelection: function (id) {
            $("#blogNav").find("[data-menu='" + id + "']").addClass("selected");
        },
        toggleMenu: function (id) {
            this.resetNavSelection();
            var mnu = $("#blogMenu");
            if ($(id).is(":visible")) {
                mnu.slideUp("fast");

            } else {
                this.setNavSelection(id);
                $("#tags").hide();
                $("#search").hide();
                $("#popular").hide();
                $(id).show();
                mnu.slideDown("fast");
            }
        }
    }

    window.blog = blog;

    $(win).scroll(function () {
        rotatePhotos();
    });
    $(win).load(function () {
        rotatePhotos();
    });

    function rotatePhotos() {
        $(".user-photo").each(function () {
            var img = $(this).find("img")
            if (!img.data("animated")) {
                if (isScrolledIntoView(img)) {
                    img.data("animated", "true");
                    img.animate({ rotate: 6.28 }, 500);
                }
            }
        });
    }

    function isScrolledIntoView(elem) {
        var docViewTop = $(win).scrollTop(),
            docViewBottom = (docViewTop + ($(win).height() / 1.5)),
            elemTop = $(elem).offset().top,
            elemBottom = elemTop + $(elem).height();
        return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
    }

}(window, window.document, jQuery));
