<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="robots" content="noodp">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<div id="wrapper">
		<header id="header">
			<div class="top">
				<div class="content">
					<div class="right">
						<span class="tel">Call Us:
							<a href="<?php the_field('_called_phone_number', 'option'); ?>"><?php the_field('_displayed_phone_number', 'option'); ?></a>
						</span>
						<ul class="sub-menu">
							<?php wp_nav_menu( array( 'theme_location' => 'top' ) ); ?>
						</ul>
					</div>
				</div>
			</div>
			<div class="header-holder">
				<div class="content">
					<strong class="logo"><a href="<?php echo home_url(); ?>">3Gvision</a></strong>
					<a href="#" class="opener">opener</a>
					<nav class="right hidemenu hideme">
						<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container' => false,
  'menu_id' => 'nav' ) ); ?>
						<a href="<?php echo site_url(); ?>/get-started/" class="btn">Get Started</a>
					</nav>
				</div>
			</div>
			<?php $image = get_field('_image',34); ?>
			<?php if ($image): ?>
				<section class="visual">
					<img src="<?php echo $image['url']; ?>" width="<?php echo $image['width']; ?>" height="<?php echo $image['height']; ?>" alt="#" />
				<div class="text">
				<div class="text-h">
					<div class="text-f">
						<?php if(is_search()):?>
						<h1>Search Results</h1>
<?php else:?>
						<h1><?php the_field("_title",34); ?></h1>
<?php endif;?>
						<?php if (get_field("_description",34)): ?>
							<p><?php the_field("_description",34); ?></p>
						<?php endif; ?>
					</div>
				</div>
				</div>
			</section>
			<?php endif; ?>
		</header>

		<div id="main">